// #################################$#################################

// TYPE OF INC FILE: Generator of Fire, Smoke ...                       
// VERSION : 0.1
// CREATOR : Toni Bratincevic                                       
// E-MAIL  : tbrat@mail.geocities.com                                
// HOMEPAGE: http://members.xoom.com/Intercepto                     
// Created in POVRay 3.1 on Pentium 133 (64MB Ram, 1.6GB HD, WinNT) 

// ################################$##################################

// ALWAYS SET max_trace_level to 10+

// If you have some ideas, suggestions, comments or if you want to work
// with me on this macro, please be free to e-mail me. There are many
// other things that must be implemented in this source. This version
// is primary made to show users what can be done with this technique.

global_settings { max_trace_level 20 }

#declare cam_position = <0,0,-10>;
/*camera {
   location cam_position
   look_at <0,0,0>
} */

#declare fire =
#union {

#declare fake_the_smoke = on;          // on - 2D effects; off - 3D effects (not implemented yet)
#declare smoke_start_point = <0,0,0>; // start point of fire or smoke
#declare smoke_to_x = 2;               // x size of fire
#declare smoke_to_y = 2;               // y size ...
#declare smoke_to_y_exponent = 0;      // linear or exponential aproach to end point
#declare max_dispersion = 2;           // at first sample this is 0 and rise as it aproach end smpl

#declare smoke_samples = 200;          // samples - particles - discs

#declare smoke_start_radius = 0.3;     // radius of disc at first sample
#declare smoke_end_radius = 1.2;       // radius of disc at last sample

#declare rs = seed (2655945);             // seed for random number generator
#declare intensity = 1.5;              // color*intensity
#declare ambientlght = 4;              // set ambient value to x
#declare counter = 0;                  // oh my god, it is Mr. Counter! :-)

// SET THE TYPE OF TEXTURE
#declare Pig_Type = 1;                 // pigment types; for now 4 of them

// USE RANDOM COLORS IN PIGMENTS OR
#declare rand_color = off;             // you can use gradient through colors or rand color
#declare RRMult = 0.9;                 // multiplyer of rand number for red color
#declare GRMult = 0.9;                 // multiplyer of rand number for green color
#declare BRMult = 0.9;                 // multiplyer of rand number for blue color

// ... GRADIENT FROM COLORS
#declare num_of_colors = 4;                     // set number of colors 
#declare grad_colors = array [num_of_colors]    // array for your colors
#declare grad_colors [0] = <1,1,.7>;            // set the first color
#declare grad_colors [1] = <1,.85,0>;           // ... second color
#declare grad_colors [2] = <0.8,0.4,0>;         // ... third color
#declare grad_colors [3] = <0.35,0.25,0.15>;    // ... fourth color


#macro calculate_color ()
   #if (rand_color)
     #declare flame_color = <rand (rs)*RRMult,rand(rs)*GRMult,rand(rs)*BRMult>;
   #else
     #declare wh_color = int((num_of_colors-1)*counter);
     #declare fc_mult = counter*(num_of_colors-1)-wh_color;
     #declare fcol1 = (1-fc_mult)*grad_colors [wh_color];
     #declare fcol2 = fc_mult*grad_colors [wh_color+1];
     #declare flame_color = intensity*(fcol1+fcol2)/2; 
   #end
#end

#macro calculate_position ()
   #declare x_vector = counter*smoke_to_x; 
   #declare y_vector = pow(counter,smoke_to_y_exponent)*smoke_to_y;
   #declare z_vector = vrotate(<0,0,counter*(max_dispersion)*rand(rs)>,<rand(rs)*360,0,0>);
   //#declare z_vector = <0,0,(max_dispersion/2)-(max_dispersion*rand(rs))>;
   #declare radi = smoke_start_radius+(counter*(smoke_end_radius-smoke_start_radius));
   #declare sample_position = <x_vector,0,0>+z_vector+<0,y_vector,0>;
#end

#macro F_Pigment ()
  #switch (Pig_Type)
  #case (1)
    pigment {
       spherical
       pigment_map {
          [ 0.10 color rgb 0 transmit 1 ]
          [ 0.85
             wrinkles
             color_map {
                [ 0 color rgb flame_color ]
                [ 1 color rgb flame_color*0.3 ]
             }
             scale <0.2,0.2,0.2>
             translate <rand(rs),rand(rs),rand(rs)>*20
          ]
       }
       scale radi/1.25
       translate sample_position 
       turbulence 0.2
       octaves 6
       lambda 2
       omega 0.8
    }
  #break
  #case (2)
    pigment {
       spherical
       pigment_map {
          [ 0.4 color rgb 0 transmit 1 ]
          [ 0.5 color rgb flame_color  ]
          [ 0.6 color rgb 0 transmit 1 ]
       }
       scale radi/1.25
       translate sample_position 
    }
  #break
  #case (3)
    pigment {
       spherical
       pigment_map {
          [ 0.3 color rgb 0 transmit 1 ]
          [ 0.7 
            spiral1 5
            color_map {
               [ 0.4 color rgb 0 transmit 1 ]
               [ 0.8 color rgb flame_color transmit 0.5 ]
            }
          ]
       }
       scale radi/1.25
       translate sample_position 
    }
  #break
  #case (4)
    pigment {
       spherical
       pigment_map {
          [ 0.3 color rgb 0 transmit 1 ]
          [ 0.7 
            spotted
            color_map {
               [ 0.4 color rgb flame_color transmit 0.95  ]
               [ 0.8 color rgb flame_color*0.5 transmit 0.4 ]
            }
            scale 0.5          ]
       }
       scale radi/1.25
       translate sample_position 
    }
  #break
  #end
#end

#macro F_Smoke ()
 disc {
    sample_position,
    cam_position,
    radi,0
    F_Pigment ()
    finish { ambient ambientlght }
    no_shadow
 }
#end

#macro T_Smoke ()
 sphere {
    sample_position, radi
    material {
      texture {
        pigment { color rgb 1 transmit 1 }
        finish { ambient 1 diffuse 0 }
      }
      interior {
        media {
           emission 1
           density {
              spherical
              density_map {
                 [ 0.10 color rgb 0 ]
                 [ 0.85
                   wrinkles
                   color_map {
                      [ 0.2 color rgb flame_color-(flame_color*(xmov_rand/smoke_to.x)) ]
                      [ 0.8 color rgb (flame_color-(flame_color*(xmov_rand/smoke_to.x)))*0.3 ]
                   }
                   scale <0.4,0.4,0.4>
                   translate <rand(rs),rand(rs),rand(rs)>*50
                 ]
                 [ 0.9 color rgb flame_color ]
              }
              scale radi/1.25
              translate <xmov_rand,ymov_rand,zmov>
              turbulence 0.2
              octaves 6
              lambda 2
              omega 0.8
           }
        }
      }
    }
    no_shadow
    hollow
 }
#end

#macro do_you_smoke ()
  union {
    #while (counter<1)
      calculate_position ()
      calculate_color ()
      #if (fake_the_smoke)
        F_Smoke ()
      #else
        T_Smoke ()
      #end
      #declare counter = counter + 1/smoke_samples;
    #end
    translate smoke_start_point
    hollow
  }
#end

do_you_smoke () 
}