// Persistence of Vision Ray Tracer Scene Description File
// File: flag.pov
// Vers: 3.5
// Desc: A flag object for the graveyard
// Date: 10/3/2001 
// Auth: Martin Presler-Marshall
// To do:



/**********************************************************************
 * Includes
 *
 **********************************************************************/
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "woods.inc"   
#include "tombdef.pov"
#include "shapes_old.inc"
#include "shapesq.inc"
#include "flagdef.pov"

/**********************************************************************
 * Textures
 *
 **********************************************************************/
#declare T_Concrete =
texture {
    pigment {
        quilted
        turbulence 0.5
        frequency 6
        scale 0.25
        rotate <0, -45, 30>
        color_map {
            [0.02 color rgbf <0.75, 0.75, 0.75, 0.0> ]
            [0.10 color rgbf <0.90, 0.90, 0.90, 0.0> ]
            [1.00 color rgbf <0.85, 0.85, 0.85, 0.0> ]
        }
    } 
    normal {  
        bumps 0.15 
        scale 0.01
    }
}                    

// Colors for the grass texture
#declare Blanc1=rgb<0.90,0.81,0.81>;
#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted = pigment {
    spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0   color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen = pigment{Green2*1.3}
#declare txtGrass = texture {                  
    pigment {
        gradient y
        turbulence 0.2
            pigment_map {                                
                [0.0 pigEarth]
                [0.3 pigGreen]
                [0.9 pigSpotted]
                [1.0 pigEarth]
            }
        }
        finish { 
            ambient 0.01 
            diffuse 0.7 
            specular 0.2 
            roughness 0.015
        }
        scale <0.001,1,0.001> 
} 


/**********************************************************************
 * Camera
 *
 **********************************************************************/
// set viewer's position in the scene
camera {
    location  <0.0,  0.0, -3.0> // position of camera <X Y Z>
    look_at   <0.0,  0.0,  0.0> // point center of view at this point <X Y Z>
}

/**********************************************************************
 * Lights
 *
 **********************************************************************/
// The sun
light_source {
  <10, 10, -150>               // Position
  color rgb <2, 2, 2>  // light's color
  area_light
  <5, 0, 0> <0, 5, 0> // lights spread out across this distance (x * z)
  1, 1                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  //jitter              // adds random softening of light        
  //circular
  parallel
  shadowless
}       


/**********************************************************************
 * Grass
 *
 **********************************************************************/
// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane {
    <0, 1, 0>, // <X Y Z> unit surface normal, vector points "away from surface"
    -5.0 // distance from the origin in the direction of the surface normal
    texture { pigment { rgb <0.2, 1.0, 0.8>}}
}
                            
                            
//flag(-45,  1.5, 0, 0)                     
//flag(-30,  0.5, 0, 0)
//flag(0,  0.0, 0, 0)
//flag(-30, -1.0, 0, 0)   
//flag(-30, -2.0, 0, 0)
//flag(-30, -4.0, 0, 0)

// create a box that extends between the 2 specified points
box {
  <0, 0, 0>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>

        texture {     
            // Ugh - how to get this to map onto a bent flag shape?
            pigment {
                image_map {
                    gif "USFlag640.gif" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                    map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                    interpolate 1     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                    //once           // for no repetitive tiling
                } // image_map
                  
                scale <1.5, 1, 1>    
                rotate <0, 0, 90>
                //scale <0.64, 0.336, 1.0>  
            } // pigment 
        } // texture  
        //texture { pigment { Blue}}
}
  
/***** Original, working flag def:
// Reticulating splines... 
union {
    bicubic_patch {                            
    type 1
    u_steps 3
    v_steps 3
    flatness 0.01
    <0, 0.336,  0.0>, <0.22,  0.336, -0.0>, <0.43, 0.336,  0.1>,  <0.64, 0.336,  0.2>, 
    <0, 0.224, -0.1>, <0.22,  0.224,  0.0>, <0.43, 0.224, -0.0>,  <0.64, 0.224,  0.1>,
    <0, 0.112, -0.1>, <0.22,  0.112, -0.1>, <0.43, 0.112,  0.0>,  <0.64, 0.112, -0.0>,
    <0, 0.000,  0.0>, <0.22,  0.000, -0.1>, <0.43, 0.000, -0.1>,  <0.64, 0.000,  0.0>
        //texture { pigment { Red}}             
        texture {
            pigment {
                image_map {
                    gif "USFlag640.gif" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                    map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                    interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                    once           // for no repetitive tiling
                    // [use_color | use_index]
                } // image_map
                  
                scale <0.64, 0.336, 1.0>  
            } // pigment 
        } // texture                      
    }
    cylinder {
        <0, -0.6, 0>,
        <0,  0.336, 0>,
        0.01
        texture { pigment { Black }}
    }
    
    
    rotate <0, 0, -45>
}
*/    
                       
