// Persistence of Vision Ray Tracer Scene Description File
// File: grass.pov
// Vers: 3.1
// Desc: Tombs for use in my battlefield... 
// Date: 
// Auth: Martin Presler-Marshall

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "woods.inc"  



// set viewer's position in the scene
camera {
    location  <1.5, 5.0, -3.0> // position of camera <X Y Z>
    look_at   <0.0, 1.0,  0.0> // point center of view at this point <X Y Z>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0, 40, -20>
}

                                     
union {                                     
bicubic_patch {
    type 1
    flatness 0
    u_steps 3
    v_steps 3
    <-0.1, 0, 5>,  <-0.05, -0, 5>, <0.05, -0, 5>, <0.1, 0, 5>,
    <-0.6, 0, 4.7>,  <-0.15, -0.5, 4.7>,  <0.15,  0.5,  4.7>, <0.6, 0, 4.7>,
    <-0.8, 0, 4.25>, <-0.15, -0.8, 4.25>, <0.15, -0.8, 4.25>, <0.8, 0, 4.25>,
    <-1, 0, 4>,      <-0.25, -1, 4>,      <0.25, -1, 4>,      <1, 0, 4>
} 
bicubic_patch {
    type 1
    flatness 0
    u_steps 3
    v_steps 3
    <-1, 0, 4>, <-0.25, -1, 4>, <0.25, -1, 4>, <1, 0, 4>,
    <-1, 0, 3>, <-0.25, -1, 3>, <0.25, -1, 3>, <1, 0, 3>,
    <-1, 0, 2>, <-0.25, -1, 2>, <0.25, -1, 2>, <1, 0, 2>,
    <-1, 0, 0>, <-0.25, -1, 0>, <0.25, -1, 0>, <1, 0, 0>
}  
    texture { pigment { Green } }
}
/*
// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
height_field {
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "grass.gif"     // the file name to read
  smooth
  scale <10, 0.5, 10>
  translate <-5, 0, -5>  
  texture { pigment { Green}}
  //texture { T_Crack4 scale 5 }

}
 */