// Persistence of Vision Ray Tracer Scene Description File
// File: tombdef.pov
// Vers: 3.5
// Desc:
// Date: 10/3/2001
// Auth: Martin Presler-Marshall

/**********************************************************************
 * Quick-render settings
 *
 **********************************************************************/        
#declare LabelTombs = true; // Set to false to leave the text labels off; they render slowly

/**********************************************************************
 * Headstone parameters
 *
 **********************************************************************/        
#declare HeadstoneHeight = 1;  // Height of the headstone        
#declare HeadstoneDepth = 0.2; // Depth (z-axis) of the headstone                 
#declare Standout = 0.015;     // Z-axis depth of headstone features.                      
#declare TextColor = texture { pigment { rgb <0.1, 0.1, 0.1> } }
#declare T_Blank = 0;
#declare T_Christian = 1;
#declare T_Jewish = 2;    
#declare T_Muslim = 3;
#declare T_Moslem = T_Muslim; // Alternate spellings, anyone?     
             
/**********************************************************************
 * Headstone definition
 *
 **********************************************************************/        
#macro Headstone(HeadstoneHeight, HeadstoneDepth, StartX, StartY, StartZ, Name, Unit, Dates, Religion)
#local StandoutMultiplier = 0.075; // The standout is produced by (HeadstoneDepth * StandoutMultiplier)
#local Standout = (StandoutMultiplier * HeadstoneDepth);                       
#local RelStandout = Standout;
union {            
    // Vertical
    box {
        <StartX - 0.5, StartY,                   StartZ>
        <StartX + 0.5, StartY + HeadstoneHeight, StartZ + HeadstoneDepth>
    }
    // Rounded top           
    cylinder {
        <StartX, StartY + HeadstoneHeight, StartZ>
        <StartX, StartY + HeadstoneHeight, StartZ + HeadstoneDepth>,
        0.5
    }               

    // Top of vertical
    box {
        <StartX - 0.5, StartY + HeadstoneHeight - 0.05,  StartZ>
        <StartX + 0.5, StartY + HeadstoneHeight,         StartZ - Standout>
    }

    
    // Loop over the top of the headstone
    difference {
        cylinder {
            <StartX, StartY + HeadstoneHeight, StartZ>
            <StartX, StartY + HeadstoneHeight, StartZ - Standout>
            0.5
        }
        cylinder { 
            <StartX, StartY + HeadstoneHeight,  StartZ + 0.001>
            <StartX, StartY + HeadstoneHeight,  StartZ - (Standout + 0.001)>
            0.5 - Standout
        }
        box {
            <StartX - 0.5, StartY,                   StartZ - (Standout + 0.001)>
            <StartX + 0.5, StartY + HeadstoneHeight, StartZ + 0.25>
        }
    }             

    #if (Religion = T_Christian)
        // Cross
        box {
            <StartX - 0.04, StartY + HeadstoneHeight,       StartZ>
            <StartX + 0.04, StartY + HeadstoneHeight + 0.4, StartZ - (RelStandout)>
        }     
        box {
            <StartX - 0.15, StartY + HeadstoneHeight + 0.25, StartZ>
            <StartX + 0.15, StartY + HeadstoneHeight + 0.30, StartZ -(RelStandout)>
        }              
    #end // End cross for Christian tombs
                                            
    #if (Religion = T_Jewish) 
    union {  
        prism {
            linear_sweep
            linear_spline
            0, 
            RelStandout, 
            8,
            <- 0.10, 0.05>, <+ 0.00, 0.25>, <+ 0.10, 0.05>, <- 0.10, 0.05>
            <- 0.07, 0.07>, <+ 0.00, 0.22>, <+ 0.07, 0.07>, <- 0.07, 0.07>
        }
        prism {
            linear_sweep
            linear_spline
            0.0, 
            RelStandout, 
            8,
            <-0.10, 0.20>, <0.00, 0.00>, <0.10, 0.20>, <-0.10, 0.20>
            <-0.07, 0.18>, <0.00, 0.03>, <0.07, 0.18>, <-0.07, 0.18>
        }     
        scale 1.4
        rotate <-90, 0, 0>
        translate <StartX, StartY + HeadstoneHeight + 0.065, StartZ>
    } 
    #end // End Star of David for Jewish tombs               
    
    #if (Religion = T_Muslim) 
    difference {
        cylinder {
            <0, 0, 0>
            <0, 0, -(RelStandout * 1.5)>
            0.14
        }
        cylinder { 
            <0.05, 0, 0.001>
            <0.05, 0, -(RelStandout * 1.5 + 0.001)>
            0.125
        }
        rotate <0, 0, 20>
        translate <StartX, StartY + HeadstoneHeight + 0.225, StartZ>
    }
    #end // End of crescent moon for Muslim tombs
    
    texture { T_Concrete }
}

/**********************************************************************
 * Labels on the tomb.
 *
 **********************************************************************/
#if (LabelTombs)                                                        
// Person's name
#declare TW = Text_Width("c:/winnt/Fonts/times.ttf", Name, 0.08, 0);
text {
    ttf 
    "c:/winnt/Fonts/times.ttf"     
    Name,
    1, 0          
    texture { TextColor }
    scale  0.08
    translate <StartX - (TW/2), StartY + HeadstoneHeight - 0.2, StartZ - 0.005>
}               
// Unit
#declare TW = Text_Width("c:/winnt/Fonts/times.ttf", Unit, 0.08, 0);
text {
    ttf 
    "c:/winnt/Fonts/times.ttf"     
    Unit,
    1, 0          
    texture { TextColor }
    scale  0.08
    translate <StartX - (TW/2), StartY + HeadstoneHeight - 0.3, StartZ - 0.005> 
}
// Dates
#declare TW = Text_Width("c:/winnt/Fonts/times.ttf", Dates, 0.08, 0);
text {
    ttf 
    "c:/winnt/Fonts/times.ttf"     
    Dates,
    1, 0          
    texture { TextColor }
    scale  0.08
    translate <StartX - (TW/2), StartY + HeadstoneHeight - 0.4, StartZ - 0.005> 
}
#end

#end // End of Tomb Macro   
