// Persistence of Vision Ray Tracer Scene Description File
// File: tombs.pov
// Vers: 3.1
// Desc: Let this be your last battlefield...
// Date: 
// Auth: Martin Presler-Marshall
// To do:
// 4) Put in fewer leaves of grass, and put a flat textured plane under them all.
//    That gives a "row" effect to the grass. Can I randomize the centerpoints of the grass 
//    blobs in a "prarie"?
// 5) How about creating several grass patches, and randomly selecting one each time a patch
//    of grass is called for?
// 6) Can I get that flag to work?



/**********************************************************************
 * Includes
 *
 **********************************************************************/
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "woods.inc"   
#include "shapes.inc"
#include "rand.inc"
#include "tombdef.pov"
#include "flagdef.pov"  // Attempt to define a flag to decorate the tombs
// Grass definition, courtesy of Gilles Tran
#include "mgrass.pov"

// Configuration; turn off certain features for better appearance.
#declare FineGrass     = true;
#declare LabelTombs    = true; 
#declare IncludeTombs  = true;   
#declare TexturedEarth = true;               
#declare TreeShadow    = true;

/**********************************************************************
 * Textures
 *
 **********************************************************************/
#declare T_Concrete =
texture {
    pigment {
        quilted
        turbulence 0.5
        frequency 6
        scale 0.25
        rotate <0, -45, 30>
        color_map {
            [0.02 color rgbf <0.75, 0.75, 0.75, 0.0> ]
            [0.10 color rgbf <0.90, 0.90, 0.90, 0.0> ]
            [1.00 color rgbf <0.85, 0.85, 0.85, 0.0> ]
        }
    } 
    normal {  
        bumps 0.15 
        scale 0.01
    }
}                    

// Colors for the grass texture (from Gilles Tran's grass file)
#declare Blanc1=rgb<0.90,0.81,0.81>;
#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted = pigment {
    spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0   color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen = pigment{Green2*1.3}
#declare txtGrass = texture {                  
    pigment {
        gradient y
        turbulence 0.2
            pigment_map {                                
                [0.0 pigEarth]
                [0.3 pigGreen]
                [0.9 pigSpotted]
                [1.0 pigEarth]
            }
        }
        finish { 
            ambient 0.01 
            diffuse 0.7 
            specular 0.2 
            roughness 0.015
        }
        scale <0.001,1,0.001> 
} 


/**********************************************************************
 * Camera
 *
 **********************************************************************/
// set viewer's position in the scene
camera {
    location  <0.0,  3.0, -5.0> // position of camera <X Y Z>
    look_at   <0.0,  0.0, -0.0> // point center of view at this point <X Y Z>
}

/**********************************************************************
 * Lights
 *
 **********************************************************************/
// The sun
light_source {
  <100, 200, -150>               // Position
  color rgb <2, 2, 2>  // light's color
  area_light
  <5, 0, 0> <0, 5, 0> // lights spread out across this distance (x * z)
  5, 5                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light        
  //circular
  //parallel
}       

/**********************************************************************
 * Shadows
 *
 **********************************************************************/
#if (TreeShadow)
// A disc to cast a "tree leaves" shadow.  
union {
    disc {
        <5, 5, -10>  // center position
        <0, 1, 0.1>,   // normal vector
        5.0          // outer radius
    }
    disc {
        <4, 5, -6>
        <0, 1, 0.1>,
        1.5
    }
    texture {
        pigment {
            bozo
            turbulence 2.0 
            octaves 6
            omega 0.7
            lambda 2.0
            color_map {
                [0.0 0.1 color rgb <0.60, 0.60, 0.60> color rgb <0.55, 0.60, 0.55>]
                [0.1 0.3 color rgb <0.55, 0.60, 0.55> color rgb <0.50, 0.50, 0.50>]
                [0.3 0.4 color rgb <0.50, 0.50, 0.50>      color rgbt <1, 1, 1, 1>]
                [0.4 1.0 color rgbt <1, 1, 1, 1>      color rgbt <1, 1, 1, 1>]

            }                                                                       
            scale 2.0
        }        
        rotate <0, 90, 0>
    }    
}    
#end


/**********************************************************************
 * Grass
 *
 **********************************************************************/
#if (FineGrass)
#include "grassfield.pov"
#end

/**********************************************************************
 * The ground. This is put in even if there's grass, as there's got to be 
 * something under the grass, right?
 *
 **********************************************************************/
plane {
    <0, 1, 0>, 
    0.0 
#if (TexturedEarth)    
    texture {txtGrass scale 1000}
#else   
    // A faster texture.
    texture { pigment { Green}}
    texture { T_Crack4 scale 5 }
#end
}                   


/**********************************************************************
 * Functions for assigning content to the tombstones
 *
 **********************************************************************/
// Select a random religion:
// 70% Christian
// 20% Muslim
// 10% Jewish
#macro PickReligion() 
    #local Rolled = RRand(1, 100, RdmC);
    #local Picked = T_Blank; 
    #switch (Rolled)
        #range (0, 10)
            #local Picked = T_Jewish;
            #local Text = "Jewish";
            #break
        #range (11, 30)
            #local Picked = T_Muslim;
            #local Text = "Muslim";
            #break
        #else
            #local Picked = T_Christian;
            #local Text = "Christian";
            #break
    #end  
    #warning Text                
    (Picked)
#end
    
/**********************************************************************
 * Name generation
 *
 **********************************************************************/    
// List of names                            
#declare NumNames = 34;
#declare NameList = array[NumNames] {
    "Wallace Stevens",
    "Helen Vendler",
    "Langston Hughes",
    "Theodore Roethke",
    "Elizabeth Bishop",
    "Robert Hayden",
    "Randall Jarrell",
    "Kara Gunter", 
    "Hadeer Dujari",
    "John Berryman",
    "Robert Lowell",
    "Howard Nemerov",
    "Nabeel Gupta",    
    "Amy Clampitt",
    "Richard Wilbur",
    "Tariq Rahman",
    "James Dickey",
    "Ellen Ginsburg",
    "James Merrill",
    "Martha O'Hara",
    "John Ashbery",
    "James Wright",
    "Anne Sexton",
    "Adrienne Rich",
    "Gary Snyder",
    "Mark Strand",
    "Charles Wright",
    "Michael Harper",
    "Charles Simic",
    "Frank Bidart",
    "Robert Pinsky",
    "Dave Smith",
    "Albert Goldbarth",
    "Rita Dove" 
    }
#declare NameIndex = 3;    
#macro GetName()       
    #local TempIndex = NameIndex;
    #declare NameIndex = NameIndex + 1;
    #if (NameIndex >= NumNames) 
        #declare NameIndex = 0;
    #end
    #local Result = NameList[TempIndex];
    Result
#end

#macro GetYears()         
    #local Rolled = RRand(1, 10, RdmB);
    #local Picked = "1974"; 
    #switch (Rolled)
        #case (1)
            #declare Picked = "1978";
            #break
        #range (2, 3)
            #declare Picked = "1979";
            #break                   
        #range (4,6)
            #declare Picked = "1980";
            #break
        #case (7) 
            #declare Picked = "1981";
            #break                 
        #case (8)
            #declare Picked = "1977";
            #break;
        #else
            #declare Picked = "1982";
            #break
    #end
    concat(Picked, " - 2001")
#end

#declare Units = array[6] {
    "47th Inf. Div",
    "3rd Armored Inf. Div",
    "1st Inf. Div.",
    "29th Airborne",
    "8th Air Force",
    "4th Armored Div."
    }
#macro GetUnit()         
    #local Rolled = RRand(0, 5, RdmB);
    Units[Rolled - 1]
#end

    
/**********************************************************************
 * Tomb placement/generation logic
 *
 **********************************************************************/        
#if (IncludeTombs)
                       
#declare RowOffsetX = 2.25;                       
#declare RowOffsetZ = 6;              
#declare XStart = -5;
#declare XEnd = 5;
      
#declare Row = 1;
#while (Row <= 5)                            
    #declare XLoc = XStart;
    #while (XLoc <= XEnd)
        Headstone(1, 0.2, XLoc * RowOffsetX, 0, (Row - 1) * RowOffsetZ, GetName(), GetUnit(), GetYears(), PickReligion())
        #declare XLoc = XLoc + 1;
    #end // X-loop
    #declare Row = Row + 1;
    #declare XStart = XStart - 1;
    #declare XEnd = XEnd + 1;
#end // Row loop.

/*                            
// Zeroth row

    Headstone(1, 0.2,               0, 0, (RowOffsetZ * -1), "Pvt. Alan Greinwald", "1979 - 2001", T_Blank)
    Headstone(1, 0.2,      RowOffsetX, 0, (RowOffsetZ * -1), "PFC Joe Schmoe",      "1978 - 2001", T_Blank)
    Headstone(1, 0.2,     -RowOffsetX, 0, (RowOffsetZ * -1), "Pvt. No Body",        "1981 - 2001", T_Blank)
    Headstone(1, 0.2,  2 * RowOffsetX, 0, (RowOffsetZ * -1), "PFC Joe Schmoe", "1978 - 2001", T_Blank)
    Headstone(1, 0.2, -2 * RowOffsetX, 0, (RowOffsetZ * -1), "Pvt. No Body", "1981 - 2001", T_Blank)

// First row                                                         
    Headstone(1, 0.2,               0, 0, (RowOffsetZ * 0), "Pvt. Alan Greinwald", "3rd Armored Inf. Div", "1979 - 2001", T_Jewish)
    Headstone(1, 0.2,      RowOffsetX, 0, (RowOffsetZ * 0), "PFC Joe Schmoe",      "3rd Armored Inf. Div", "1978 - 2001", PickReligion())
    Headstone(1, 0.2,     -RowOffsetX, 0, (RowOffsetZ * 0), "Pvt. No Body",        "1st Inf. Div",         "1981 - 2001", PickReligion())
    Headstone(1, 0.2,  2 * RowOffsetX, 0, (RowOffsetZ * 0), "PFC Joe Schmoe",      "1st Inf. Div",         "1978 - 2001", PickReligion())
    Headstone(1, 0.2, -2 * RowOffsetX, 0, (RowOffsetZ * 0), "Pvt. No Body",        "47th Inf. Div",        "1981 - 2001", PickReligion())
   
// Second row
    Headstone(1, 0.2,               0, 0, (RowOffsetZ * 1), "Pvt. Kara Gunter", "1980 - 2001", T_Christian)
    Headstone(1, 0.2,      RowOffsetX, 0, (RowOffsetZ * 1), "Lt. Sharon Nusan", "1978 - 2001", T_Jewish)
    Headstone(1, 0.2,     -RowOffsetX, 0, (RowOffsetZ * 1), "Pvt. David Cole", "1981 - 2001", T_Christian)
    Headstone(1, 0.2,  2 * RowOffsetX, 0, (RowOffsetZ * 1), "Lt. Sharon Nusan", "1978 - 2001", T_Christian)
    Headstone(1, 0.2, -2 * RowOffsetX, 0, (RowOffsetZ * 1), "Pvt. David Cole", "1981 - 2001", T_Jewish)
    Headstone(1, 0.2,  3 * RowOffsetX, 0, (RowOffsetZ * 1), "Lt. Sharon Nusan", "1978 - 2001", T_Jewish)
    Headstone(1, 0.2, -3 * RowOffsetX, 0, (RowOffsetZ * 1), "Pvt. David Cole", "1981 - 2001", T_Jewish)

// Third row
    Headstone(1, 0.2,               0, 0, (RowOffsetZ * 2), "Pvt. Kara Gunter", "1980 - 2001", T_Christian)
    Headstone(1, 0.2,      RowOffsetX, 0, (RowOffsetZ * 2), "Lt. Sharon Nusan", "1978 - 2001", T_Christian)  
    Headstone(1, 0.2,     -RowOffsetX, 0, (RowOffsetZ * 2), "Pvt. David Cole", "1981 - 2001", T_Christian)
    Headstone(1, 0.2,  2 * RowOffsetX, 0, (RowOffsetZ * 2), "Lt. Sharon Nusan", "1978 - 2001", T_Christian)
    Headstone(1, 0.2, -2 * RowOffsetX, 0, (RowOffsetZ * 2), "Pvt. David Cole", "1981 - 2001", T_Christian)
    Headstone(1, 0.2,  3 * RowOffsetX, 0, (RowOffsetZ * 2), "Lt. Sharon Nusan", "1978 - 2001", T_Jewish)
    Headstone(1, 0.2, -3 * RowOffsetX, 0, (RowOffsetZ * 2), "Pvt. David Cole", "1981 - 2001", T_Christian)

// Fourth row
    Headstone(1, 0.2,               0, 0, (RowOffsetZ * 3), "Pvt. Kara Gunter", "1980 - 2001", T_Christian)
    Headstone(1, 0.2,      RowOffsetX, 0, (RowOffsetZ * 3), "Lt. Sharon Nusan", "1978 - 2001", T_Jewish)
    Headstone(1, 0.2,     -RowOffsetX, 0, (RowOffsetZ * 3), "Pvt. David Cole", "1981 - 2001", T_Christian)
    Headstone(1, 0.2,  2 * RowOffsetX, 0, (RowOffsetZ * 3), "Lt. Sharon Nusan", "1978 - 2001", T_Christian)
    Headstone(1, 0.2, -2 * RowOffsetX, 0, (RowOffsetZ * 3), "Pvt. David Cole", "1981 - 2001", T_Christian)
    Headstone(1, 0.2,  3 * RowOffsetX, 0, (RowOffsetZ * 3), "Lt. Sharon Nusan", "1978 - 2001", T_Christian)
    Headstone(1, 0.2, -3 * RowOffsetX, 0, (RowOffsetZ * 3), "Pvt. David Cole", "1981 - 2001", T_Jewish)
 */              

#end
