
// Glenn's Accesories POV-Ray Scene File
// first concept 31-May-97 last update 12-Apr-98
// copyright Glenn McCarter 1997, 1998
// This file does not render.  #include "Accessories.inc" in another .pov file
//
// A collection of personal accesories:
// PoliceHat
// PoliceBadge
// SunGlasses
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system

//===============================================
//             Variable Declarations
//===============================================

#declare InverseY = // forms a mirror image
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}


//===============================================
//             Textures
//===============================================

#declare DBlueCloth =
	texture {
		pigment { color rgb<.1,.1,.6> }
		finish { specular .2 roughness .10 }
	}
#declare BumpyDBlueCloth =
	texture {
		pigment { color rgb<.1,.1,.6> }
		normal { bumps .8 scale <1,1,1> }
		finish { specular .2 roughness .10 }
	}

#declare WavyDBlueCloth =
	texture {
		pigment { color rgb<.1,.1,.6> }
		normal { bumps .7 scale <2,2,2> }
		finish { specular .2 roughness .10 }
	}

#declare DBluePlastic =
	texture {
		pigment { color rgb<.1,.1,.6> }
		finish { specular .8 roughness .05 }
	}
#declare BlackPlastic =
	texture {
		pigment { color rgb<.05,.05,.08> }
		finish { specular .8 roughness .05 }
	}
#declare HardHatTex =
	texture {
		pigment { color rgb<1.05,1.25,.3> }
		finish { specular .9 roughness .01 }
	}
#declare GoldStar =
	texture {
		pigment { color rgb<.8,.7,.1> }
//		finish { specular .8 roughness .002 reflection .1 }
		finish { specular .8 roughness .002  }
	}

#declare SunGlassTex =
	texture {
		pigment { color rgbt<.5,.3,.08,.6> } // very light for sunglasses
		pigment { color rgbt<.4,.25,.08,.56> } // slightly darker
//		finish { phong 1 phong_size 200  reflection .2 }
		finish { phong 1 phong_size 200 }
	}
#declare WhTex =
	texture {
		pigment { color rgb<1.3,1.3,1.3> }
		finish { phong 1 phong_size 200 }
	}
#declare TieTex =
	texture {
		pigment { color rgb<.1,.1,.1> }
		finish { phong 1 phong_size 200 }
	}

#declare CamoTex =
	texture {
		pigment {
			crackle solid
	    color_map {
				[ 0.0 rgb<0.01,0.11,0.01> ]
				[ 1.0 rgb<0.46,0.62,0.42> ]
			}
			scale 0.4
			turbulence 0.3
		}
		normal { bumps .18 scale 1.33 }
		finish { ambient .10 diffuse .45 specular .08 roughness .167 }
	}


//===============================================
//       Objects
//===============================================

//---------- Police Star -----------

#declare StarPart =
	prism { // extruded along y-axis
		linear_sweep
		linear_spline
		-0.1,        // height 1
		0.1,        // height 2
		4,          // number of points
		// the <u,v> points
		< -0.3, 0.0>,
		<  0.0, 1.0>,
		<  0.3, 0.0>,
		< -0.3, 0.0>
		texture { pigment { color rgb<.9,.9,.2> } }
	}

#declare PoliceBadge =
	union {
		object { StarPart rotate <0,0,0> }
		object { StarPart rotate <0,360/5,0> }
		object { StarPart rotate <0,360/5*2,0> }
		object { StarPart rotate <0,360/5*3,0> }
		object { StarPart rotate <0,360/5*4,0> }
		box { <-1,0,-1>,<1,.2,1> texture { BlackPlastic } }
		rotate <0,0,-90> // set on X plane
	}

//---------- Police Hat -----------

#declare PoliceHat = // origin at center base
	union {
		object { PoliceBadge scale .7 translate <-4,0,.9> }
		cylinder { // main body
			<0,0,0>,<0,0,3>,4.0
			texture { WavyDBlueCloth }
			scale <1,1,1>
			rotate <0,0,0>
			translate <0,0,0>
			clipped_by { box { <-6,-6,-1>,<6,6,1.4> rotate <0,15,0> } }
		}
		sphere { // top flop
			<0,0,0>,5.0
			texture { BumpyDBlueCloth }
			scale <1.03,1,.15>
			rotate <0,15,0>
			translate <0,0,1.7>
		}
		sphere { // top flop center popup
			<0,0,0>,5.0
			texture { BumpyDBlueCloth }
			scale <.73,.7,.3>
			rotate <0,15,0>
			translate <0,0,1.7>
		}
		cylinder { // brim
			<0,0,0>,<0,0,.13>,3.6
			texture { BlackPlastic }
			scale <1,1,1>
			rotate <0,0,0>
			translate <-2.3,0,0>
		}
	}
//---------- HardHat -----------

#declare HardHat = // origin at center base
	union {
		sphere { // main
			<0,0,0>,5
			clipped_by{box{<-8,-8,0>,<8,8,8>}}
		}
		cylinder { // rim
			<0,0,0>,<0,0,.2>,6.0
		}
			texture { HardHatTex }
	} // end union

//---------- Sunglasses -----------

#declare RawLens =
	intersection {
		sphere { // outer
			<0,0,0>,2.0
			texture { SunGlassTex	}
		}
		sphere { // inner
			<0,0,0>,1.9
			texture { SunGlassTex	}
			inverse
		}
		cylinder {
			<-4,0,0>,<0,0,0>,.9
			texture { SunGlassTex }
		}
		translate <1.75,0,0> // origin at back of lens
	}

#declare FramedLens =
	union {
		object { RawLens }
		torus {
			0.9,.03
			texture { GoldStar }
			rotate <0,0,-90>
		}
	}

#declare WireArm = // origin at pivot
	union {
		cylinder { // main part
			<0,0,0>,<3,0,0>,.1
			scale <1,.2,.7>
			translate <0,-.08,0>
			texture { GoldStar }
		}
		cylinder { // pivot
			<0,0,-.1>,<0,0,.1>,.15
			texture { GoldStar }
		}
		box { // front
			<-.15,.2,-.1>,<0,0,.1>
			texture { GoldStar }
		}
	}

#declare NoseBridge = // origin at upper bar
	union {
		torus { // lower arc
			.5,.05
			texture { GoldStar }
			rotate <0,0,-90>
			translate <0,0,-.3>
			clipped_by { box { <-1,-1,0>,<1,1,1> } }
			translate <-.3,0,-.3>
		}
		cylinder { // upper bar
			<0,-1.0,0>,<0,1.0,0>,.03
			texture { GoldStar }
		}
	}

#declare SunGlasses =
	union {
		object { FramedLens scale <1,1.3,1> rotate <15,0,18> translate <0,-1.5,0> } // LH
		object { FramedLens scale <1,1.3,1> rotate <-15,0,-18> translate <0,1.5,0> } // RH
		object { WireArm rotate <-5,0,-10> translate <.4,-2.8,.1> } // LH
		object { WireArm transform InverseY rotate <5,0,10> translate <.4,2.8,.1> } // RH
		object { NoseBridge translate <-.1,0,.9> }
	}

#declare Tie =
	union {
		cone { // shirt
			<0,0,-12>,1,<0,0,1>,2
			scale <.1,1,1>
			texture { WhTex }
		}
		cone { // main
			<0,0,-12>,2,<0,0,0>,.3
			scale <.1,1,1>
			translate <-.3,0,0>
			texture { TieTex }
		}
		cone { // top
			<0,0,0>,.4,<0,0,1.5>,1.0
			scale <.1,1,1>
			translate <-.3,0,0>
			texture { TieTex }
		}
		cone { // bottom
			<0,0,-12>,2,<0,0,-13>,0
			scale <.1,1,1>
			translate <-.3,0,0>
			texture { TieTex }
		}
	}


//---------- Canteen -----------

#declare Canteen =
	union {
		cylinder { // main
			<-0.75,0,0>,<0.75,0,0>,3.0
		}
		sphere { // front side
			<0,0,0>,3.0
			scale <0.15,1,1>
			translate <-0.75,0,0>
		}
		sphere { // back side
			<0,0,0>,3.0
			scale <0.15,1,1>
			translate <0.75,0,0>
		}
		cylinder { // lid stuff...
			<0,0,-1>,<0,0,.7>,.5
			translate <0,0,3.0>
		}
		cylinder {
			<0,0,0.6>,<0,0,1.1>,0.6
			translate <0,0,3.0>
		}
		sphere {
			<0,0,0>,0.6
			scale <1,1,0.2>
			translate <0,0,1.1+3.0>
		}
		sphere {
			<0,0,0>,0.15
			translate <0,0,3.0+1.1+.1>
		}
		texture { CamoTex }
	} // end union


#declare CamoBox =
	union {
		object { RoundedBox2(2.6,1.3,4,0.2) }
		texture { CamoTex }
	} // end union


