
#local RenderThisFile = 0; // change to 1 to test render this file only

// POV-Ray Object File - Battle Debris
// created 13-Oct-01
// last update 29-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "BattleDebris.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Building1BricksPile 
// BeamGroup
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


#if (RenderThisFile = 1)
	#include "GIncludeRH.inc" // uncomment for testing only
	#include "Shapes.inc" // uncomment for testing only
	#declare GS = 1; // uncomment for testing only 
	//#include "GRuler.inc" // for testing only
#end

//===============================================
//             Includes
//===============================================




//===============================================
//             Macros
//===============================================

#declare e = 2.718281828459;
#macro Gauss(RSR) // produces a normal (gaussian) distribution, given a ransom number
	sqrt(-2*log(rand(RSR))/log(e))*cos(2*pi*rand(RSR))
#end


//===============================================
//             Textures
//===============================================

#declare HoleTex = pigment { rgb<0,0,0> }
#declare RadialTex =
	pigment {
		radial
		frequency 7
		color_map {
			[ 0.1 rgb<0,0,0> ]
			[ 0.5 rgbt<1,1,1,1> ]
			[ 0.9 rgb<0,0,0> ]
		}
		turbulence 0.3
	}
#declare ClearTex = pigment { rgbt<1,1,1,1> }
#declare BulletHole2Tex =
	texture {
		pigment {
			spherical
			pigment_map {
				[ 0.20 ClearTex ] // outside
				[ 0.70 RadialTex ]
				[ 0.80 HoleTex ] // center of sphere 

			}
			turbulence 0.02
			scale 1
		}
	}

#declare BurntWoodTex =
	texture {
		pigment {
			onion
			color_map {
				[ 0.10 rgb<.071,.061,.001> ]
				[ 0.35 rgb<.571,.561,.501> ]
				[ 0.65 rgb<.571,.561,.501> ]
				[ 0.90 rgb<.071,.061,.001> ]
			}
			scale 1 // scale it up later...
		}
		normal { bumps 0.4 scale 3 }
		finish { ambient 0.05 specular 0.4 roughness 0.08 }
	}



//===============================================
//             Objects
//===============================================

#declare RS = seed(30275);
#include "functions.inc"
#macro BulletHole2d()
	#declare Fn = function {
		f_kummer_surface_v2(x, y, z, 0.001, -2, -.84, 0.4)
		+ f_noise3d(x,y,z)*.15 // add some noise
	}
	isosurface {
		function { - Fn(x,y,z) }
		max_gradient 2
		contained_by{sphere {0,10}}
		rotate <rand(RS)*180,rand(RS)*180,0>
		texture { BulletHoleTex }
		scale <.2,0.001,.2>
	}
#end

#declare RS = seed(90238);
#macro BulletHole()
//#declare MyBH =
	cylinder {
		<0,-0.001,0>,<0,0.001,0>,1
		texture { BulletHole2Tex rotate <rand(RS)*180,rand(RS)*180,0> }
		scale 2
	}
#end

//===============================================
//             Groups
//===============================================

#declare BBrick =
	box {
		<-5,-2,-1>,<5,2,1>
		texture { pigment { rgb<.7,.4,.4> } }
	}

#declare Building1BricksPile =
	union {
		#local BC = 0;
		#while (BC < 1000)
			object { BBrick
				rotate <rand(RS)*180,rand(RS)*180,0>
				translate <Gauss(RS)*3*Feet,Gauss(RS)*3*Feet,abs(Gauss(RS)*0.8*Feet)>
			}
			#declare BC = BC + 1;
		#end
	} // end union

#declare WoodSplinterBox =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Damage.png"
		water_level .01
		translate <-0.5,0,-0.5> // center on Y
//		texture { WhitePaint }
	}

#declare RS = seed(97523);
#macro BurntBeam(BLength)
		difference {
			box { <0,0,0>,<BLength,2,10> }
			object { WoodSplinterBox scale 20 rotate <0,rand(RS)*360,0> rotate <0,0,90> translate <BLength,1,5> }
			texture { BurntWoodTex scale BLength }
		}

#end

#declare BeamGroup =
	union {
		object { BurntBeam(8*Feet) }
		object { BurntBeam(8.7*Feet) rotate <70,13,-60> translate <4*Feet,-3*Feet,12> }
		object { BurntBeam(5.3*Feet) rotate <-18,-63,34> translate <2*Feet,-6*Feet,12> }
		object { BurntBeam(9.3*Feet) rotate <40,-8,-60> translate <7*Feet,-3*Feet,13> }
		object { BurntBeam(7.1*Feet) rotate <-50,8,-78> translate <4*Feet,-6*Feet,12> }
		object { BurntBeam(4.6*Feet) rotate <15,5,-18> translate <8*Feet,-2*Feet,10> }
		object { BurntBeam(8.6*Feet) rotate <66,-4,-34> translate <8*Feet,-7*Feet,-5> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderThisFile = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
//		location  <1, -48*Feet, 8*Feet>
//		look_at <7*Feet,0,15*Feet>
		location  <1, -60*Feet, 18*Feet>
		look_at <10,10,0>
	}


light_source
{ <40*Feet,-35*Feet,40*Feet>, <.9,.9,1.0>
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}

light_source
{ <-40*Feet,-35*Feet,10*Feet>, <1.13,0.93,.76>
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 12 }

//box { <0,0,0>,<100,100,100> pigment { rgb<1,1,1> } }
//object { BulletHole2d() rotate <0,0,0> translate <4,0,5> }
//object { BuildingBulletHoles rotate <0,0,0> translate <-0.1,0,5> }
object { Building1BricksPile }
object { BeamGroup }
#end
