// Glenn's POV-Ray Environments File
// created 20-June-96 updated 1-Apr-97
// copyright Glenn McCarter

// using English coordinate system -- basic unit is Inches
#declare Foot = 12
#declare Feet = 12
#declare Mile = 12*5280
#declare Miles = 12*5280

#declare LightFog =
  fog {
    fog_type 1
    distance 180*Feet
    colour rgbt<.72,.64,.91,.2> //transmittance
    turbulence .1
  }

#declare GroundFog =
  fog {
    fog_type 2
    distance 6*Feet
    colour rgbt<.6,.7,.74,.4>
    fog_offset 5
    fog_alt 5
    turbulence .1
  }

#declare GroundPlaneGreen =
  plane { y, 0
    texture {
      pigment{ForestGreen}
    }
    hollow
  }
#declare GroundPlaneWhite =
  plane { y, 0
    texture {
      pigment{White}
    }
    hollow
  }
//----------------------------------
// following wood stuff is from the
// POV-Ray include files.
//----------------------------------
#declare M_Wood1A =
color_map {
    [0.0, 0.1 color rgb <0.88, 0.60, 0.40>
              color rgb <0.88, 0.60, 0.40>]
    [0.1, 0.9 color rgb <0.88, 0.60, 0.40>
              color rgb <0.60, 0.30, 0.20>]
    [0.9, 1.0 color rgb <0.60, 0.30, 0.20>
              color rgb <0.60, 0.30, 0.20>]
}
#declare M_Wood1B =
color_map {
    [0.0, 0.1 color rgbf <0.55, 0.32, 0.20, 0.100>
              color rgbf <0.55, 0.32, 0.20, 0.500>]
    [0.1, 0.2 color rgbf <0.55, 0.35, 0.20, 0.650>
              color rgbf <0.88, 0.60, 0.40, 0.975>]
    [0.2, 0.3 color rgbf <0.88, 0.60, 0.40, 0.975>
              color rgbf <0.60, 0.30, 0.20, 1.000>]
    [0.3, 0.4 color rgbf <0.60, 0.30, 0.20, 0.100>
              color rgbf <0.60, 0.30, 0.20, 0.500>]
    [0.4, 0.9 color rgbf <0.60, 0.30, 0.20, 0.650>
              color rgbf <0.88, 0.60, 0.40, 0.975>]
    [0.9, 1.0 color rgbf <0.88, 0.60, 0.40, 0.975>
              color rgbf <0.55, 0.32, 0.20, 1.000>]
}
#declare P_WoodGrain1A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}
#declare P_WoodGrain1B =
pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}
// Natural oak (light)
#declare T_Wood1 =
    texture { pigment { P_WoodGrain1A  color_map { M_Wood1A }}}
    texture { pigment { P_WoodGrain1B  color_map { M_Wood1B }}}
//----------------------------------

#declare GroundPlaneWood =
  plane { y, 0
    texture {
      T_Wood1
    }
//    scale 6
    hollow
  }

#declare BasicRoom16x12 =
  box {
    <-8*Feet,0,-6*Feet>,<8*Feet,8*Feet,6*Feet>
  texture {
      pigment { color <1,1,1> }
      finish { ambient .3 phong .6 }
  }
  hollow
  }

#declare BasicGarage =
  box {
    <-16*Feet,0,-16*Feet>,<16*Feet,10*Feet,16*Feet>
  texture {pigment { color White}}
  hollow
  }
