
// POV-Ray Object File - Smoke and Fire
// created 12-Oct-01
// last update 27-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "SmokeFire.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Smoke
// SmokeGroup
// LtSmoke
// Flame
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)


//===============================================
//             Variables
//===============================================

// Put the following line in the main scene:
//#declare GoodSmoke = 1; // 1 turns on real smoke and fire, otherwise use simple spheres

// Use this function to apply a random rotation to any object
#declare RSeed = seed(101095);
#macro RandRot()
	<rand(RSeed)*360,rand(RSeed)*360,rand(RSeed)*360>
#end

//===============================================
//             Textures
//===============================================

#declare WhitePaint = // for quick cloud
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 0.5 }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}

#declare CloudTestTex = // for testing only
	texture {
		pigment { color rgb<.5,.5,.5> }
		normal { bumps .3 scale .3 }
		finish { ambient .1 diffuse .7 specular .5 roughness .2 }
	}
#macro SmokeInt(An,Sn)
	interior {
		media {
			absorption <An,An,An>
			scattering { 1, <Sn,Sn,Sn> extinction 1.0 }
//			absorption <.95,.95,.95> // pretty darn dark
//			absorption <.005,.005,.005> // nearly transparent with low enough scattering
//			scattering { 1, <.25,.25,.25> extinction 1.0 } // a bit of scatter
//			scattering { 1, <.05,.05,.05> extinction 1.0 } // 
//			scattering { 1, <.02,.02,.02> extinction 1.0 } // 
//			scattering { 3, <.01,.01,.01> extinction 1.0 } //
//			scattering { 1, <.002,.002,.002> extinction 1.0 } // 
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[0.4 color rgb <0,0,0> ] // this prevents it from reaching the container
					[1.0 color rgb <1,1,1> ] // inside is opaque
				}
			turbulence .18
			omega 0.835 // default 0.5, higher = rougher
    	}
		}
	}
#end
#declare SmokeSurfTex =
	texture {
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	}
#macro SmokeMaterial(An,Sn)
	{
		texture { SmokeSurfTex }
		SmokeInt(An,Sn)
	}
#end
#declare LtSmokeInt = // lighter version
	interior {
		media {
			scattering { 1, <.002,.002,.002,> extinction 1.0 } // thicker fluffy grey
//			scattering { 1, <.001,.001,.001,> extinction 1.0 } // medium fluffy grey
//			scattering { 1, <.0001,.0001,.0001,> extinction 1.0 } // thin fluffy grey
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[0.3 color rgb <0,0,0> ] // this prevents it from reaching the container
//					[1.0 color rgb <.15,.15,.15> ] // inside is almost transparent
					[1.0 color rgb <.95,.95,.95> ] // inside is almost opaque
				}
				scale .6
			turbulence .8
			omega 0.835 // default 0.5, higher = rougher
    	}
		}
	}
#declare LtSmokeMaterial =
	material {
		texture { SmokeSurfTex }
		interior { LtSmokeInt }
	}

#declare FlameInt =
	interior {
		media {
			emission <.0005,.0005,.0005,>
	    density {
			spherical
				color_map{
					[0.00 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.40 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.45 color rgb<0.00,0.00,0.06> ] // blue tinge
					[0.50 color rgb<0.70,0.02,0.00> ]
					[0.80 color rgb<0.60,0.30,0.00> ]
					[0.90 color rgb<1.30,1.30,1.15> ] // inside is opaque
				}
				scale .6
			turbulence <.08,1.2,.08>
			omega 0.835 // default 0.5 higher = rougher
	    }
		}
	}
#declare FlameMaterial =
	material {
		texture { SmokeSurfTex }
		interior { FlameInt }
	}

//===============================================
//						 Objects
//===============================================

//------------- Smoke --------------------
/*
#declare Smoke =
	#switch ( GoodSmoke )
	#case (0)
		sphere { <0,0,0>,1 texture { BlackPaint } scale 3*Feet } // quick test
	#break
	#case (1)
		sphere { <0,0,0>,1 hollow material { SmokeMaterial } scale 5*Feet } // render
	#break
	#end
*/
#macro SmokePuff(An,Sn)
	#switch ( GoodSmoke )
	#case (0)
		sphere { <0,0,0>,1 texture { BlackPaint } scale .7*Feet } // quick test
	#break
	#case (1)
		sphere { <0,0,0>,1 hollow material SmokeMaterial(An,Sn) scale 1.3*Feet } // render
	#break
	#end
#end

#declare SmokeSpline =
	spline {
		quadratic_spline
		0,<0,0,0>,
		1,<1.0*Feet,2.7*Feet, 3*Feet>,
		2,<0.2*Feet,4.5*Feet, 6*Feet>,
		3,<-1.4*Feet,1.5*Feet, 9*Feet>,
		4,< 2.4*Feet,-3.5*Feet, 13*Feet>,
		5,< 3.8*Feet,-6.0*Feet, 17*Feet>,
		6,< 6.1*Feet,-13.0*Feet, 23*Feet>
	}

#declare SmokeGroup = // for burning truck
/*
	union { // too big clouds of smoke
		object { Smoke rotate RandRot() scale 1.0 translate <0,-4*Feet,2*Feet> }
		object { Smoke rotate RandRot() scale 1.5 translate <-3*Feet,-2*Feet,6*Feet> }
		object { Smoke rotate RandRot() scale 1.7 translate <-8*Feet,0*Feet,12*Feet> }
		object { Smoke rotate RandRot() scale 2.0 translate <-3*Feet,-4*Feet,14*Feet> }
		object { Smoke rotate RandRot() scale 2.6 translate <3*Feet,-8*Feet,19*Feet> }
		bounded_by { cylinder{<0,0,-20*Feet>,<0,0,80*Feet>,50*Feet} }
	}
*/
	union {
		#declare SPC = 0;
		#declare SPCmax = 11;
		#while (SPC < SPCmax+1)
//			object { SmokePuff(0.95,0.25)
			object { SmokePuff(1-(SPC/SPCmax),0.250-(SPC/SPCmax*0.251))
				rotate RandRot()
				scale 1+SPC/(SPCmax/4)
				translate SmokeSpline((SPC/SPCmax)*6)+<rand(RSeed)*SPC/3,rand(RSeed)*SPC/3,0>
			}
			#declare SPC = SPC + 1;
		#end
	} // end union

#declare RP = 230*Feet; // Right Position
#declare FarSmoke =
	union {
		object { SmokePuff(0.70,0.150) rotate RandRot() scale 12 translate <0,0,20*Feet> }
		object { SmokePuff(0.40,0.080) rotate RandRot() scale 22 translate <10*Feet,0,26*Feet> }
		object { SmokePuff(0.04,0.006) rotate RandRot() scale 28 translate <28*Feet,0,38*Feet> }

		object { SmokePuff(0.06,0.050) rotate RandRot() scale 28 translate <RP+100*Feet,0,140*Feet> }
		object { SmokePuff(0.20,0.012) rotate RandRot() scale 14 translate <RP+128*Feet,0,90*Feet> }
		object { SmokePuff(0.30,0.050) rotate RandRot() scale 10 translate <RP+77*Feet,0,98*Feet> }
		object { SmokePuff(0.20,0.005) rotate RandRot() scale 10 translate <RP+139*Feet,0,103*Feet> }
		object { SmokePuff(0.02,0.005) rotate RandRot() scale 48 translate <RP+200*Feet,0,168*Feet> }
	} // end union
