global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#declare Mist = material
{
        texture
        {
                pigment
                {
                        color rgbt <1.0,1.0,1.0,1.0>
                }
        }   
        interior
        {
                media
                {      
                        scattering
                        { 
                                    1
                                    rgb<1.0, 1.0, 1.0>
                                    extinction 0.25
                        }
                        //emission rgb < 0.12, 0.07, 0.03 >
                        density
                        {
                                planar
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        //[ 0.2  rgb <0.01, 0.01, 0.01> ]
                                        //[ 0.4  rgb <0.04, 0.04, 0.04> ]
                                        //[ 4.8  rgb <0.48, 0.48, 0.48> ]
                                        //[ 9.6  rgb <0.96, 0.96, 0.96> ]
                                        //[ 10   rgb <1.0, 1.0, 1.0> ]
                                        //[ 250.0  rgb <1.0, 1.0, 1.0> ]
                                        [ 1000.0  rgb <1.0, 1.0, 1.0> ]
                                }
                                turbulence .7
                                omega 0.55
                                lambda 5.0
                                triangle_wave
                        }
                }
        }     
}

#declare Fire = material
{
        texture
        {
                pigment
                {
                        color rgbt <1.0,1.0,1.0,1.0>
                }
        }
        interior
        {
                media
                {
                        emission rgb < 0.12, 0.07, 0.03 >
                        density
                        {
                                spherical
                                color_map
                                {
                                        /*
                                        [ 0.4  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.7  rgb <0.01, 0.0, 0.01> ]
                                        [ 0.8  rgb <0.4, 0.01, 0.0> ]
                                        [ 0.9  rgb <0.6, 0.4, 0.01> ]
                                        [ 1.0  rgb <0.8, 0.6, 0.4> ]
                                        */
                                        [ 0.4  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.7  rgb <0.001, 0.001, 0.001> ]
                                        [ 0.8  rgb <0.04, 0.04, 0.04> ]
                                        [ 0.9  rgb <0.06, 0.06, 0.06> ]
                                        [ 1.0  rgb <0.1, 0.1, 0.1> ]
                                }
                                turbulence 0.3
                                omega 0.8
                                triangle_wave
                        }
                }
        }
}

#declare iron = texture
{       
        pigment
        {
                color rgb< 0.7, 0.9, 1.0 >
        }
        normal
        {
                dents
                bump_size 0.5
                scale 0.01
        }
        finish
        {
                reflection 0.1
                phong 3.0
                ambient 0.0
        }

}

#declare rust = texture
{        
        pigment
        {
                bozo
                color_map
                {
                        [0.0 color rgb< 1.0, 0.5, 0.2>]
                        [1.0 color rgb< 0.5, 0.2, 0.0>]
                }
                turbulence 0.8
                lambda 0.55
         }
         normal
         {
                bumps
                bump_size 0.5
                scale 0.01
         }
         finish
         {
                ambient 0.0
         }
}

#declare hull_texture = texture
{       
        bozo
        texture_map
        {
                [0.0 rust]
                [0.5 iron]
        }
        scale< 1, 2, 1 >
        turbulence 1 
        lambda 55
}

#declare Sea = texture
{       
        pigment
        {
                color rgb <0.25, 0.6, 0.5 > //Water
                //color rgb <0.00, 0.00, 0.00 >
                //color rgb <1,1,1>
        }
        normal
        {
                waves 0.06
                frequency 50000.0
                scale 1000.0
                turbulence 0.3
        }
        finish
        {
                ambient 0.0
                diffuse 0.1
                reflection 0.8
        }  
}
