// Persistence of Vision Ray Tracer Scene Description File
// File: Asia.pov
// Vers: 3.5 beta 9
// Desc: IRTC Entry For the Nov/Dec 2001 round (Topic: Spirit of Asia)
// Date: 27/12/2001
// Auth: Alun Thomas
//


#include "colors.inc"
#include "txttree.inc"

#declare ShowTrees = true;
#declare BoxTrees = false;
#declare ShowClifftopPlants = true;
global_settings
{
  assumed_gamma 1.0
}

background { color White }

// create a regular point light source
light_source {
  <-30,10,-10>                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  parallel
  point_at <0, 0, 0>
}


// ----------------------------------------
camera
{
  location  <0.0, 0.0, -4.0>
  direction 1.5*z
  up        y
  right     x
  look_at   <0.0, 0.0,  0.0>
  angle 60
  rotate x*15
  translate 7*y

}



// ----------------------------------------
union {
	difference
	{
	        box
	        {
	                <-1,-1,-3> <1,1,-2.95>
	        }
	        // create a superquadric ellipsoid shape
	        // As the exponents approach 1.0, the edges get rounder
	        superellipsoid
	        {
	                .7 //<0.75, 0.75>
	                scale 0.55
	                translate -2.975*z
	        }
	        texture
	        {
	                finish { ambient 1 diffuse 0 specular 0 }
	                pigment { colour (Yellow+White*3)/4 }
	        }
	}
	difference {
		box { <-0.54,-0.2,-3.001> <-0.51,0.53,-3> }
		union {
			difference {
				cylinder {
						<0,0,-.0015> <0,0,.02> 0.015
						scale <0.9,1,1>
						translate <-0.526,0.488,-3>
					}
				difference {
					cylinder {
						<0,0,-.0015> <0,0,.02> 0.012
						scale <0.9,1,1>
						translate <-0.526,0.488,-3>
					}
					text {
						ttf
						"crystal.ttf",
						"c"
						2,
						0  
						scale .03
						translate <-0.534,0.48,-3.002>
					}
				}
			}
			#declare String="2001 ALUN THOMAS";
			#declare Posn=<-0.535,0.43,-3.002>;
			#while (strlen(String)>0)
				text {
					ttf
					"crystal.ttf",
					substr(String,1,1)
					2,
					0  
					scale .05
					translate Posn
				}
				#declare String=substr(String,2,strlen(String)-1);
				#declare Posn=Posn-y*0.04;
			#end
		}
		texture {
			finish {ambient 1 }
			pigment { colour rgbf <0.7,0.1,0.1,0.5> }
		}
		translate 3*z
		scale 0.5
		translate <0.8,-0.45,-3>
	}


	plane
	{
	        -z 2.95
	        hollow on
	        texture
	        {
	                finish { ambient 1 diffuse 0 specular 0 }
	                pigment
	                { 
	                        granite scale <2,1,1>
	                        colour_map
	                        {
	                                [ 0 rgbf <.9,.8,.3,.7> ]
	                                [ 1 rgbf <.85,.6,.25,.65> ]
	                        }
	                }
	        }
	}
	rotate x*15
	translate 7*y
}


#declare HillSide_o = cone
	{
	  <20,3,25>,  5.0,
	  <20,-30,25>, 40.0
	  texture {
	  	pigment { colour White }
	  	normal { bumps scale .1 bump_size 2 }
	  }
	}
object{ HillSide_o }

#declare Ridge_Half_o = 
	height_field {
		sys               // the file type to read (tga/pot/pgm/ppm/png/sys)
		"cliff_hf.bmp"     // the file name to read
		smooth        // smooth surface normal
		water_level 0.1 // truncate/clip below N (0.0 ... 1.0) 
		translate -x/2
	}
	 

	
#declare Ridge_o = 
	union {
		object {Ridge_Half_o}
		object {Ridge_Half_o scale <1,-1,1> }	  
		texture { pigment { colour White } }
		scale <20,10,10>
		rotate x*-85
		rotate y*30 translate 15*x+25*z-5*y
	}

object{ Ridge_o }

//
// Trees....
//
#if (ShowTrees)

	#declare txtTree=texture{txtTree_5}
	#declare txtLeaf=texture{txtLeaf_1}
	#declare Leaf=object{#include "my_leaf.inc" } 
	#declare Tree1=object{#include "my_tree.inc" }                      
	#declare Foliage1=object{#include "my_foliage.inc"  texture{txtLeaf} }
	
	#if (BoxTrees)

		#declare ScaledTree_o = 
			object{
				box { min_extent(Tree1) max_extent(Tree1) pigment { White } }
				scale 4/max_extent(Tree1).y
			}
				
	#else // not (BoxTrees)
	
		#declare ScaledTree_o = 
			union{
				object {Foliage1}
				object {Tree1}
				scale 4/max_extent(Tree1).y
			}
			
	#end // of if (BoxTrees)                                                    
	
	
	//
	// place Trees
	// 
	#declare treeRand = seed(0);
	#declare sx=-15;
	#declare zstart=0;
	#declare zend=2;
	#while (sx<5)
		#declare sz=zstart;
		#while (sz<zend)	
			#declare StartPos = <15,100,25> + sx*2*x + sz*2*z;
			#declare Norm = <0, 0, 0>;
			#declare Pos = trace (
			                  HillSide_o,      // object to test
			                  StartPos,        // starting point
			                  -y,              // direction
			                  Norm );          // normal
	
			#if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
				#declare Norm = <0, 0, 0>;
				#declare Pos2 = trace (
			                  Ridge_o,         // object to test
			                  StartPos,        // starting point
			                  -y,              // direction
			                  Norm );
				#if (Norm.x = 0 & Norm.y = 0 & Norm.z = 0)
			        	object {
			        		ScaledTree_o
			        		rotate y*360*rand(treeRand)
			        		scale 1+0.25*rand(treeRand)-0.25*rand(treeRand)
			        		translate Pos
			        	}
			        #end
				
			#end
	
			#declare sz=sz+1;
		#end
		#if ( sx<-10)
			#declare zstart = zstart-1;
		#else
			#if ( sx=-4 )
				#declare zend = zend-5;
			#else
				#if ( sx>-4 )
					#declare zend = zend-1;
				#end                         
			#end
		#end
		#declare sx=sx+1;
	#end

#end // of if (ShowTrees)

//
// distant 'fog' shrouded mountains
//
union {
	height_field {
	  sys               // the file type to read (tga/pot/pgm/ppm/png/sys)
	  "make_distant_hf.bmp"     // the file name to read
	  texture { 
	  	pigment { colour  White }
	  	normal { crackle triangle_wave scale <100,200,100> }
	  }
	  smooth        // smooth surface normal
	  water_level 0.1 // truncate/clip below N (0.0 ... 1.0) 
	  translate -x/2
	  scale <300,80,300>
	  rotate x*-10
	  translate z*650 +x*200 - 50*y
	}
	
	plane
	{
		-z, -500
		hollow on
		no_shadow
		texture {
			pigment {
				gradient y
				translate -0.5
				scale 200
				colour_map
				{
					[ 0.0 rgbf <1,1,1,0> ]
					[ 0.4 rgbf <1,1,1,0> ]
					[ 0.6 rgbf <1,1,1,1> ]
					[ 1.0 rgbf <1,1,1,1> ]
				}
			}
			finish {
				ambient 1
				diffuse 0
			}
		}	
	}
	plane
	{
		-z, -700
		hollow on
		no_shadow
		texture {
			pigment {
				gradient y
				translate -0.5
				scale 200
				colour_map
				{
					[ 0.0 rgbf <1,1,1,0> ]
					[ 0.4 rgbf <1,1,1,0> ]
					[ 0.6 rgbf <1,1,1,1> ]
					[ 1.0 rgbf <1,1,1,1> ]
				}
			}
			finish {
				ambient 1
				diffuse 0
			}
		}	
	}
	plane
	{
		-z, -820
		hollow on
		no_shadow
		texture {
			pigment {
				gradient y
				translate -0.5
				scale 200
				colour_map
				{
					[ 0.0 rgbf <1,1,1,0> ]
					[ 0.4 rgbf <1,1,1,0> ]
					[ 0.6 rgbf <1,1,1,1> ]
					[ 1.0 rgbf <1,1,1,1> ]
				}
			}
			finish {
				ambient 1
				diffuse 0
			}
		}	
	}
	translate <150,50,250>
}

//
// Cliftop Temple.
//

#include "Temple.inc"

object { Temple rotate y*90 translate <-8,0,-2> rotate y*30 translate <15,5.3,25>  }         

#if (ShowClifftopPlants )
	//
	// Cliftop Trees
	//
	#declare ct_txtTree=texture{txtTree_3} // Bark texture
	#declare ct_txtLeaf=texture{txtLeaf_5} // Leaf texture
	#declare Leaf=object{#include "ct_leaf.inc"} // declares the Leaf object
	
	#declare num_ct_tree_types = 4;
	#declare CT_Tree = array[ num_ct_tree_types ]
	
	#declare treetype = 0;
	#while (treetype<num_ct_tree_types)
		#declare CT_Tree[treetype] = union {
				object{#include concat("ct_tree",str(treetype+1,1,0),".inc") texture{txtTree_3} }                        
				object{#include concat("ct_foliage",str(treetype+1,1,0),".inc") texture{ct_txtLeaf} }
				rotate y*-30
		}
		#declare treetype=treetype+1;
	#end
	
	#declare CT_Scalefactor = 2/max_extent(CT_Tree[0]).y
	
	object { CT_Tree[0] scale CT_Scalefactor translate <-5,0,-5> rotate y*30 translate <15,4,25> }
	
	object { CT_Tree[1] scale CT_Scalefactor translate <-4,0,2> rotate y*30 translate <15,3.5,25> }   
	
	object { CT_Tree[2] scale CT_Scalefactor translate <-1,0,-6> rotate y*30 translate <15,4,25> }   
	
	object { CT_Tree[3] scale CT_Scalefactor translate <-1,0,3> rotate y*30 translate <15,4,25> }   
	
	#declare Scaled_bush = union {
			object{#include "bush_foliage.inc" texture{txtLeaf_1} }
			object{#include "bush.inc" texture{txtTree_3} }
			scale CT_Scalefactor 
		} 
	
	object { Scaled_bush translate <-5,0,-6> rotate y*30 translate <15,4,25> }
	object { Scaled_bush translate <-6,0,-5.5> rotate y*30 translate <15,4.2,25> }

#end // of ShowCliftopPlants
