// Persistence of Vision Ray Tracer Scene Description File
// File: Make_clifftop_tree.pov
// Vers: 3.5 beta 9
// Desc: IRTC Entry For the Nov/Dec 2001 round (Topic: Spirit of Asia)
//		This file uses Giles Tran's MakeTree/MakeLeaf macros to build
//		a 4 trees that can be placed on top of the cliff by the main file Asia.pov
// Date: 27/12/2001
// Auth: Alun Thomas
//

//-----------------------------------------
// This file calls the MakeTree and MakeLeaf macros
// and defines the textures and parameters
// Set the [dofile] parameter to "true"
// when you want to create the final file
//-----------------------------------------
#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
//=========================================
// Camera & light
//-----------------------------------------
#declare PdV=<100, 4 , -210>;
#declare PdA=<0,25,20>;
camera {location  PdV direction <0.0 , 0.0 , 1.3 > up y  right 4*x/3 look_at   PdA}
//-----------------------------------------
light_source{PdV color White*0.5  shadowless}
light_source{<130,40,-200> color White*1.8}

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=1431;      // random seed
#declare rsd=1432;      // random seed
#declare rsd=1433;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

// Generator Loop -- i.e. make me several trees....      
#declare TreeNum = 1;
#while (TreeNum<=4)
	
	//=========================================
	// Tree macro Parameters
	//-----------------------------------------
	// These parameters must be declared before calling the tree macro
	//-----------------------------------------
	#declare dofile=true;    // true creates a tree file ; false otherwise
	#declare dotexture=false;  // true creates a textured tree (with the texture following the branch); false otherwise
	
	#declare ftname=concat("ct_tree",str(TreeNum,1,0),".inc") // file name for tree
	#declare fvname=concat("ct_foliage",str(TreeNum,1,0),".inc") // file name for foliage
	#declare ffname="ct_leaf.inc" // file name for leaf
	#declare txtTree=texture{txtTree_3} // Bark texture
	
	
	//-----------------------------------------
	// Tree structure parameters        
	// test with low level0 and nseg0 (3 or 4)
	// High (>=6) recursion levels [level0] gives more complex trees
	// High (>=6) segment numbers [nseg0] gives smoother trees
	//-----------------------------------------
	#declare level0=6;      // recursion level
	#declare nseg0=12;       // initial number of branch segments (decreases of one at each level)
	#declare nb=4;          // max number of branches per level
	#declare dotop=false;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)
	
	#declare lb0=15;        // initial branch length
	#declare rb0=1.5;         // initial branch radius
	#declare ab0=60;        // initial branch angle (x angle between the trunk and the first branch)
	#declare qlb=0.85;       // branch length decrease ratio (1=constant length)
	#declare qrb=0.59;       // branch radius decrease ratio (1=constant radius)
	#declare qab=0.88;       // branch angle decrease ratio (1=constant angle)
	#declare stdax=20;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
	#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)
	
	#declare branchproba=0.8; // probability of branch apparition 
	#declare jb=0.75;        // secondary branches start after this ratio of branch length
	
	#declare fgnarl=0.5;    // gnarledness factor - keep it low <0.8
	#declare stdlseg=0.5;     // stddev of branch segment length (0...1) (adds more randomness to branch length)
	
	#declare twigproba=0.79; // probability to have a twig on a trunk segment
	
	#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
	#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)
	
	//-----------------------------------------
	// constraints parameters
	//-----------------------------------------
	#declare vpush=<0.5,0.5,0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
	#declare fpush=0.6;       // force of push
	#declare aboveground=0; // constrains the branches above this level 
	#declare belowsky=140;  // constrains the branches below this level 
	
	//-----------------------------------------
	// root parameters
	//-----------------------------------------
	#declare rootproba=0;   // probability of root 0=no root ; 1=all [nb] roots
	#declare nroot=5;      // number of roots;
	#declare vroot=<1,0,0>; // initial direction of root 
	#declare yroot=<0,0.5,0>;   // initial position of root above ground
	
	//-----------------------------------------
	// leaf position parameters
	//-----------------------------------------
	#declare leafproba=0.65;   // probability of leaf 0=no leaf ; 1=leaf on each segment
	//#declare leafproba=0;   // probability of leaf 0=no leaf ; 1=leaf on each segment
	#declare leaflevel=3;   // level where the leaves start to appear
	#declare alz0=100;       // max z angle for leaf
	#declare alx0=-10;      // start x angle for leaf
	#declare stdalx=40;     // std x angle for leaf
	#declare stdlsize=0.1;     // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)
	
	//-----------------------------------------
	// leaf structure parameters
	//-----------------------------------------
	#declare txtLeaf=texture{txtLeaf_5} // Leaf texture
	#declare lsize=0.25;     // leaf size
	#declare seg=3;        // nb of leaf segments and stalk segments : increase to smooth
	#declare ll=10;          // leaf length
	#declare wl=2;          // leaf width 
	#declare fl=0.5;        // depth of leaf fold
	#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
	#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
	#declare apow=1;        // curve power, how slow the leaf bends
	#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
	#declare nlobes=1;      // number of lobes (individual leaves)
	#declare alobes=110;    // angle made by all the lobes
	#declare qlobes=0.7;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
	#declare ls=3;          // stalk length (0=no stalk)
	#declare ws=0.12;        // width of stalk
	#declare as=10;         // stalk bending angle : the stalk bends forward
	//-----------------------------------------
	// end of parameters
	//=========================================
	
	//=========================================
	// Make the tree now !
	//-----------------------------------------
	
	object{
	        #if (leafproba>0)
	        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
	                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
	                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
	                        texture{txtLeaf}
	                 #end
	        } 
	        
	        #end              
	        MakeTree()
	        
	        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
	                texture {txtLeaf}
	        #else
	
	                texture {txtTree} // apply tree texture  regardless of the tree structure
	        #end
	        translate (TreeNum-1)*(100*z+50*x)-100*x
	}

	#declare TreeNum=TreeNum+1;
#end // of Generator Loop
	
plane{y,0 pigment{rgb<1,0.7,0.3>}}


background{color rgb <0.8,0.9,1>}

