// Persistence of Vision Ray Tracer include File
// File: Make_distant_hf.pov
// Vers: 3.5 beta 9
// Desc: IRTC Entry For the Nov/Dec 2001 round (Topic: Spirit of Asia)
//		This include file declares a Temple object that is placed on the
//		ridge by the main file Asia.pov
//		This file was initially created using Andy Koepke's Calimax Modeller,
//		but has since been hand editted (ie hacked about) in POV-Ray's editor.
// Date: 27/12/2001
// Auth: Alun Thomas
//
// Calimax Modeller 95 copyright (c) 1996 Andy Koepke
// registered freeware
//$author:$ 
//$company:$ 

//$zoom front:$ 50.0000
//$zoom right:$ 50.0000
//$zoom top:$ 10.0000
//$grid front:$ 1.0000
//$grid right:$ 1.0000
//$grid top:$ 1.0000
//$usepov3$ do not delete this line
//
//  standard include files for POV.
//
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stoneold.inc"
#include "consts.inc"
#include "woods.inc"
#include "stones.inc"

#include "txttree.inc"

#declare EndWall_2 = union {
	#declare Cyl=0;
	#while (Cyl<9)
		cylinder {
			#if (Cyl<4)
				(-0.6+0.15*Cyl)*z + (0.1+0.15*Cyl)*y  
				(-0.6+0.15*Cyl)*z + (0.1+0.15*Cyl)*-y  
			#else
				(-0.6+0.15*Cyl)*z + (1.30-0.15*Cyl)*y  
				(-0.6+0.15*Cyl)*z + (1.30-0.15*Cyl)*-y  
			#end
			0.075
			texture{txtTree_5 translate Cyl} 
		}
		#declare Cyl=Cyl+1;
	#end
	texture{txtTree_5} 
    translate <-1.3400,0.1600,0.8800>
}
/*
#declare EndWall_2 = box {
  <-0.5,-0.5,-0.5>
  <0.5,0.5,0.5>
  texture{txtTree_5} 
  scale <0.1000,1.0000,1.0000>
  rotate <45.0000,0.0000,0.0000>
  translate <-1.3400,0.1600,0.8800>
}
*/

#declare Cylinder_009 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,-0.8300,-0.5000>
}

#declare Cylinder_010 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <2.0100,-0.8600,-0.5000>
}

#declare Cylinder_011 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-0.9800,-0.7900,-0.5100>
}

#declare Cylinder_012 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <0.9900,-0.8300,-0.5100>
}

#declare Polygon_000 = polygon {
  4.0
  <-1.0000,0.0000> , 
  <0.9930,0.0000> , 
  <0.9860,0.5000> , 
  <-1.0000,0.5000>
  scale <1.0000,1.0000,1.0000>
  //$quickcolor:$ <1.0000 1.0000 1.0000> 
  texture
  {
    pigment { colour rgbt < 1,1,0.8,0.1 > }
  }
  rotate <0.0000,0.0000,0.0000>
  translate <-0.9800,-1.1500,-0.5000>
}

#declare Polygon_002 = polygon {
  4.0
  <-1.0000,0.0000> , 
  <0.9930,0.0000> , 
  <0.9860,0.5000> , 
  <-1.0000,0.5000>
  scale <1.0000,1.0000,1.0000>
  //$quickcolor:$ <1.0000 1.0000 1.0000> 
  texture
  {
    pigment { colour rgbt < 1,1,0.8,0.1 > }
  }
  rotate <0.0000,0.0000,0.0000>
  translate <1.0300,-1.1600,-0.5000>
}

#declare Cylinder_007 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-1.9700,-0.8300,-0.5000>
}


#declare Fence_1 = union {
	object { Cylinder_007 }
	object { Polygon_002 }
	object { Polygon_000 }
	object { Cylinder_012 texture{txtTree_5} }
	object { Cylinder_011 texture{txtTree_5} }
	object { Cylinder_010 texture{txtTree_5} }
	object { Cylinder_009 texture{txtTree_5} }
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,0.0000,0.0000>
}

#declare Cylinder_022 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,-0.8300,-0.5000>
}

#declare Cylinder_021 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <2.0100,-0.8600,-0.5000>
}

#declare Cylinder_020 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-0.9800,-0.7900,-0.5100>
}

#declare Cylinder_019 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <0.9900,-0.8300,-0.5100>
}

#declare Polygon_006 = polygon {
  4.0
  <-1.0000,0.0000> , 
  <0.9930,0.0000> , 
  <0.9860,0.5000> , 
  <-1.0000,0.5000>
  scale <1.0000,1.0000,1.0000>
  //$quickcolor:$ <1.0000 1.0000 1.0000> 
  double_illuminate
  texture
  {
    pigment { colour rgbt < 1,1,0.8,0.1 > }
  }
  rotate <0.0000,0.0000,0.0000>
  translate <-0.9800,-1.1500,-0.5000>
}

#declare Polygon_005 = polygon {
  4.0
  <-1.0000,0.0000> , 
  <0.9930,0.0000> , 
  <0.9860,0.5000> , 
  <-1.0000,0.5000>
  scale <1.0000,1.0000,1.0000>
  //$quickcolor:$ <1.0000 1.0000 1.0000> 
  double_illuminate
  texture
  {
    pigment { colour rgbt < 1,1,0.8,0.1 > }
  }
  rotate <0.0000,0.0000,0.0000>
  translate <1.0300,-1.1600,-0.5000>
}

#declare Cylinder_018 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-1.9700,-0.8300,-0.5000>
}


#declare Fence_2 = union {
	object { Cylinder_018 }
	object { Polygon_005 }
	object { Polygon_006 }
	object { Cylinder_019 texture{txtTree_5} }
	object { Cylinder_020 texture{txtTree_5} }
	object { Cylinder_021 texture{txtTree_5} }
	object { Cylinder_022 texture{txtTree_5} }
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,0.0000,3.0000>
}

#declare Cylinder_023 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-0.4400,0.0800,-0.5000>
}

#declare Cylinder_021 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-1.4400,0.0800,-0.5100>
}

#declare Polygon_007 = polygon {
  4.0
  <-1.0000,0.0000> , 
  <0.9930,0.0000> , 
  <0.9860,0.5000> , 
  <-1.0000,0.5000>
  scale <1.5000,1.0000,1.0000>
  //$quickcolor:$ <1.0000 1.0000 1.0000> 
  texture
  {
    pigment { colour rgbt < 1,1,0.8,0.1 > }
  }
  rotate <0.0000,0.0000,0.0000>
  translate <-0.9700,-0.2900,-0.5000>
}


#declare Fence_3 = union {
	object { Polygon_007 }
	object { Cylinder_021 texture{txtTree_5} }
	object { Cylinder_023 texture{txtTree_5} }
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,90.0000,0.0000>
  translate <2.5100,-0.9400,0.0000>
}

#declare Cylinder_036 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-0.4400,0.0800,-0.5000>
}

#declare Cylinder_034 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.0600,0.7500,0.0400>
  rotate <0.0000,0.0000,0.0000>
  translate <-1.4400,0.0800,-0.5100>
}

#declare Polygon_012 = polygon {
  4.0
  <-1.0000,0.0000> , 
  <0.9930,0.0000> , 
  <0.9860,0.5000> , 
  <-1.0000,0.5000>
  scale <1.5000,1.0000,1.0000>
  //$quickcolor:$ <1.0000 1.0000 1.0000> 
  texture
  {
    pigment { colour rgbt < 1,1,0.8,0.1 > }
  }
  rotate <0.0000,0.0000,0.0000>
  translate <-0.9700,-0.2900,-0.5000>
}


#declare Fence_4 = union {
	object { Polygon_012 }
	object { Cylinder_034 texture{txtTree_5} }
	object { Cylinder_036 texture{txtTree_5} }
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,90.0000,0.0000>
  translate <-1.4800,-0.9100,0.0000>
}

#declare Box_002 = box {
  <-0.5,-0.5,-0.5>
  <0.5,0.5,0.5>
  scale <3.0000,0.1000,1.5000>
  rotate <-30.0000,0.0000,0.0000>
  translate <-0.0900,0.5900,0.2500>
}

#declare Box_000 = box {
  <-0.5,-0.5,-0.5>
  <0.5,0.5,0.5>
  scale <3.0000,0.1000,1.5000>
  rotate <30.0000,0.0000,0.0000>
  translate <-0.1000,0.6000,1.5000>
}


#declare OuterRoof = union {
	object { Box_000 }
	object { Box_002 }
  scale <1.0000,1.0000,1.0000>
  //$quickcolor:$ <1.0000 1.0000 1.0000> 
  texture
  {
    Dark_Wood
    scale <0.1000,0.1000,0.1000>
    rotate <0.0000,0.0000,0.0000>
    translate <0.0000,0.0000,0.0000>
  }
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,0.0000,0.0000>
}

#declare Box_006 = box {
  <-0.5,-0.5,-0.5>
  <0.5,0.5,0.5>
  scale <2.8000,0.3000,1.2500>
  rotate <30.0000,0.0000,0.0000>
  translate <-0.1000,0.4700,1.3600>
}

#declare Box_004 = box {
  <-0.5,-0.5,-0.5>
  <0.5,0.5,0.5>
  scale <2.8000,0.3000,1.2500>
  rotate <-30.0000,0.0000,0.0000>
  translate <-0.1100,0.4800,0.4300>
}


#declare InnerRoof = union {
	object { Box_004 }
	object { Box_006 }
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,0.0000,0.0000>
}


#declare Roof = union {
	object { InnerRoof }
	object { OuterRoof }
  	texture{txtTree_5}
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,0.0000,0.0000>
}

#declare Cylinder_003 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.1000,1.0000,0.1000>
  rotate <0.0000,0.0000,0.0000>
  translate <-1.3400,-0.3200,0.1100>
}

#declare Cylinder_004 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.1000,1.0000,0.1000>
  rotate <0.0000,0.0000,0.0000>
  translate <1.1400,-0.3400,1.6800>
}

#declare Cylinder_006 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.1000,1.0000,0.1000>
  rotate <0.0000,0.0000,0.0000>
  translate <-1.3500,-0.3400,1.6800>
}

#declare Cylinder_000 = cylinder {
  <0.0,-0.5,0.0>,<0.0,0.5,0.0>,1.0
  scale <0.1000,1.0000,0.1000>
  rotate <0.0000,0.0000,0.0000>
  translate <1.1500,-0.3200,0.1100>
}


#declare Supports = union {
	object { Cylinder_000 }
	object { Cylinder_006 }
	object { Cylinder_004 }
	object { Cylinder_003 }
	texture{txtTree_5}
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,0.0000,0.0000>
}

#declare TempleFloor = box {
  <-0.5,-0.5,-0.5>
  <0.5,0.5,0.5>
  texture {
	  pigment { colour Gray70 }
	  finish {           // (---surface finish---)
	    ambient 0.2
	    specular 0.6     // shiny
	  }
  }

  scale <3.0000,0.3000,2.0000>
  rotate <0.0000,0.0000,0.0000>
  translate <-0.1100,-0.9700,0.8900>
}

#declare EndWall_1 = union {
	#declare Cyl=0;
	#while (Cyl<9)
		cylinder {
			#if (Cyl<4)
				(-0.6+0.15*Cyl)*z + (0.1+0.15*Cyl)*y  
				(-0.6+0.15*Cyl)*z + (0.1+0.15*Cyl)*-y  
			#else
				(-0.6+0.15*Cyl)*z + (1.30-0.15*Cyl)*y  
				(-0.6+0.15*Cyl)*z + (1.30-0.15*Cyl)*-y  
			#end
			0.075
			texture{txtTree_5 translate Cyl} 
		}
		#declare Cyl=Cyl+1;
	#end
	translate <1.1400,0.1800,0.8800>
}
/*
#declare EndWall_1 = box {
  <-0.5,-0.5,-0.5>
  <0.5,0.5,0.5>
  texture{txtTree_5} 
  scale <0.1000,1.0000,1.0000>
  rotate <45.0000,0.0000,0.0000>
  translate <1.1400,0.1800,0.8800>
}
*/
#declare InsideLight = light_source {
  <-0.0400,0.4000,0.8700> color Goldenrod
  fade_power 2
  fade_distance 4
  media_interaction on
  media_attenuation on
}

#declare SomeAir = sphere {
	<-0.0400,0.5000,0.8700> 3
	hollow on
	pigment { Clear }
	interior {
		media {
		  // (---general values---)
		  intervals 10           // number of intervals used for sampling [10]
		  samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
		  confidence 0.9         // statistic parameter higher->better quality [0.9]
		  variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
		  ratio 0.9              // distribution between lit and unlit areas [0.9]
		  // (---media types---)
		  scattering {           // scattering media
		    2,                   // scattering type 1=isotropic; 2=Mie haze; 3=Mie murky
		                         // 4=Rayleigh; 5=Henyey-Greenstein
		    rgb .01          // color
		    //eccentricity 0.25  // eccentricity for type 5 [0.0]
		    extinction 1     // for balancing amount of absorption [1.0]
		  }
		  // (---method---)
		  //method 1             // old Povray 3.1 method
		  method 2             // new method with even distribution
		  //method 3               // adaptive sampling
	
		}
	}
}

#declare Temple = union {
	object { EndWall_1 }
	object { TempleFloor }
	object { Supports }
	object { Roof }
	object { Fence_4 }
	object { Fence_3 }
	object { Fence_2 }
	object { Fence_1 }
	object { EndWall_2 }
	object { InsideLight }
	//object { SomeAir }
  scale <1.0000,1.0000,1.0000>
  rotate <0.0000,0.0000,0.0000>
  translate <0.0000,0.0000,0.0000>
}

