// Persistence of Vision Ray Tracer Scene Description File
// File: Make_distant_hf.pov
// Vers: 3.5 beta 9
// Desc: IRTC Entry For the Nov/Dec 2001 round (Topic: Spirit of Asia)
//		This file generates an image thatis used by the main file Asia.pov
//		as a heightfield to form the nearby cliff/ridge on which the temple
//		built.
// Date: 27/12/2001
// Auth: Alun Thomas
//

#version 3.5

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  orthographic
  location <0,0,1>     // position & direction of view
  look_at  <0,0,0>
  right 1*x            // horizontal size of view  \___ to be rendered at square size
  up 1*y               // vertical size of view    /
}

// ----------------------------------------

box {                  // this box fits exactly in view
	<-0.5, -0.5, 0>, <0.5, 0.5, 0>

	// -----------------------------------------
	texture {
		pigment {
			gradient x scallop_wave
			turbulence 0.05
			scale 0.1
			color_map {
				[0.0 color rgb 0.3 ]
				[0.01 colour rgb 0.5 ]
				[1.0 color rgb 0.7 ]
			}
		}
		finish {
			ambient 1.0
			diffuse 0.0
		}
	}
	// -----------------------------------------
	texture {
		pigment {
            granite
            scale <1,5,1>
            warp {
				repeat x*0.1           // repeat direction
				flip y             // flip when repeating
				offset z      // translate when repeating
       	 	}
            colour_map {
                [0 colour Clear ]
                [1 colour rgbt <1,1,1,0.25> ]
            }            
		}
    }
    texture {
        pigment {
            crackle triangle_wave
            scale <0.01,0.5,1>
            colour_map {
                [0 colour Clear ]
                [1 colour rgbt <1,1,1,0.95> ]
            }
        }
        
    }        
                
   // -----------------------------------------
   texture {
      pigment {
        crackle scallop_wave
        turbulence 0.1 octaves 3
		warp {
			repeat x*0.1           // repeat direction
			flip y             // flip when repeating
			offset z      // translate when repeating
		}

        colour_map {
                [ 0     colour rgbt .2 ]
                [0.01  colour rgbt <.3,.3,.3,.9> ]
                [ 0.05  colour rgbt <.3,.3,.3,1> ]
                } 
                }
      finish {
        ambient 1.0
        diffuse 0.0
        }
   }
      // -----------------------------------------
   texture {
      pigment {
        gradient y
        scale 2
        translate -0.6*y
        turbulence 0.05
		warp {
			repeat x*0.1           // repeat direction
			flip z             // flip when repeating
			offset z      // translate when repeating
		}

        colour_map {
                [ 0.00  colour rgbt <0,0,0,1> ]
                [ 0.80/2  colour rgbt <0,0,0,1> ]
                [ 0.90/2  colour rgbt <0,0,0,0.75> ]
                [ 0.95/2  colour rgbt <0,0,0,0.25> ]
                [ 1.00/2  colour rgbt <0,0,0,0.0> ]
                } 
                }
      finish {
        ambient 1.0
        diffuse 0.0
        }
    }  

}

