// Persistence of Vision Ray Tracer Scene Description File
// File: Make_distant_hf.pov
// Vers: 3.5 beta 9
// Desc: IRTC Entry For the Nov/Dec 2001 round (Topic: Spirit of Asia)
//		This file generates an image thatis used by the main file Asia.pov
//		as a heightfield to form the distant mountains visible in the top
//		right of the image.
// Date: 27/12/2001
// Auth: Alun Thomas
//

#version 3.5

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  orthographic
  location <0,0,1>     // position & direction of view
  look_at  <0,0,0>
  right 1*x            // horizontal size of view  \___ to be rendered at square size
  up 1*y               // vertical size of view    /
}

// ----------------------------------------

	
box {                  // this box fits exactly in view
	<-0.5, -0.5, 0>, <0.5, 0.5, 0>

	texture {
		pigment { 
			cylindrical
			rotate x*90 
			scale 0.5 //translate -0.5*y
			pigment_map {
				[  0 colour Black ] 
				[  .5 leopard triangle_wave scale .2 turbulence 0.2
						pigment_map {
							[ 0.00 colour Black ]
							[ 0.50 colour White*0.2 ]
							[ 0.80 colour White*0.6 ]
							[ 1.00 colour White ]
						} 
				]
			}
		}
		finish {
					ambient 1.0
					diffuse 0.0
		}
	}

}

