/*
Spline Tree Example File 1 - basic tree

Note: these files use portrait aspect ratio.  To fix the distortion, 
add +W450 +H600 to the command line.

Parse: 0:12
Trace: 1:26
Memory: 12 Mb
Setting: 450*600
System: Pentium III 700MHZ 128Mb RAM
Rendered in: MegaPov 0.5
*/


// If you are using megapov, uncomment the line below.
//#version unofficial MegaPov 0.5;


////////////////////////////////////////////////////////
// Environment
////////////////////////////////////////////////////////

camera {
	location <0, 3, -15>
	up <0,4/3,0>
	right <1,0,0>
	look_at <0, 4, 0>
	angle 25
}

sky_sphere {
	pigment {
		gradient y
		color_map {
			[ 0 rgb <0.8,0.8,0.9> ]
			[ 0.5 rgb <0.5,0.5,0.6> ]
		}
	}
}

fog {
	fog_type 2
	distance 200
	color rgb 0.9
	fog_offset 0
	fog_alt 2
}

plane {
	y,0
	texture {
		pigment {
			color rgb <0.7,0.7,0.6>
		}
		finish {
			ambient 0.5
			diffuse 0.5
		}
	}
}

light_source {
	<100, 100, -100>
	color rgb 1.2
}

light_source {
	<0, 5, -32>
	color rgb 0.5
}

////////////////////////////////////////////////////////
// Tree
////////////////////////////////////////////////////////

// Include the leaf definition and splinetree files
#include "leafdefs.inc"
#include "splinetree.inc"

#declare recursionmax = 5; // Defines the complexity of the tree
#declare divisions = array[5] {5,4,3,3,2}
init_rand (48,148,157)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.4, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.35, 0.003, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <0,-0.1,0>;

// Variables for leaves
#declare leafarray = array[3] {maple1,maple2,maple3}
#declare leafprob = array[3] {0.4,0.3,0.3}
#declare leafscale = array[3] {0.2,0.2,0.2}
#declare leafnoise = array[3] {1,1,1}

// Assign the branch texture
#declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <1,1,1>
	rotate <0,0,0>
	translate <0,0.3,0>
}

// Provide feedback in the first 2 recursion levels
#declare feedback = 2;

// Call the macro
splinetree(0,0)