// bonsai.inc


#declare test_bonsai_inc = off;

#declare PotR = 10;
#declare PotH = 6;
#declare PotEp1 = 1;
#declare PotEp2 = .3;
#declare TerreH = 2.5;
#declare Bonsai_Tree = on;
#declare Bonsai_Mousse = on;

#declare PotBonsai = difference{
	union{
		// rebord
		difference {
			union{
				cylinder{PotH*y, (PotH-PotEp1/2)*y, (PotR+PotEp1)}
				intersection{
					sphere{0,(PotR+PotEp1*.5) scale <1,.6,1> translate y*PotH*.9}
					box{<-(PotR+PotEp1*2)*1.01,0,-(PotR+PotEp1*2)*1.01>,<(PotR+PotEp1*2)*1.01,PotH-.001,(PotR+PotEp1*2)*1.01>}
				}
			}
			cylinder{PotH*y*1.01, (PotH-PotEp1/2)*y, (PotR-PotEp1/2)}
		}
		torus{(PotR-PotEp1/2),PotEp1/2 translate (PotH-PotEp1/2)*y}
		torus{(PotR+PotEp1), PotEp1/8 scale <1,2,1> translate (PotH-PotEp1/4)*y}
		difference {
			cylinder{0, PotH*.5*y, PotR*.6}
			cylinder{0,PotR*.61*x, PotEp2*2 translate -PotEp2*y}
			cylinder{0,PotR*.61*x, PotEp2*2 translate -PotEp2*y rotate y*120}
			cylinder{0,PotR*.61*x, PotEp2*2 translate -PotEp2*y rotate -y*120}
			height_field{
				function 200,200{pigment{agate scale .2 poly_wave 3 color_map{[0 rgb 0][1 rgb 1]}}}
				smooth translate -.5*x-.5*z
				scale <(PotR*.6)*2.01, PotEp2*.5,(PotR*.6)*2.01>
				translate -PotEp2*.1*y
			}
		}
	}
	union{
		cylinder{PotH*1.01*y, PotH*.8*y, (PotR-PotEp1)}
		height_field{
			function 300,300{pigment{bozo scale .06 poly_wave 3 color_map{[0 rgb 0][1 rgb 1]}}}
			smooth translate -.5*x-.5*z
			scale <(PotR+PotEp1)*2.01, -PotEp1*.3,(PotR+PotEp1)*2.01>
			translate (PotH+PotEp1*0.05)*y
			pigment {
				pigment_pattern {
					bozo warp{turbulence .3 octaves 2 lambda 3}
					scale 3
					color_map {[.1 rgb 0][.9 rgb 1]}
				}
				pigment_map {
					[.1 granite scale .01 color_map{[.6 rgb<1, .5, .2>*.6][.7 rgb .7*.7]}]
					[.9 granite scale .01 color_map{[.2 rgb<1, .5, .2>*.6][.3 rgb .7*.7]}]
				}
			}
		}
	}
	#declare P_Pot=pigment{rgb <.94,.96,1>}
	#declare F_Pot=finish{
			specular .1 roughness .01 phong .05 phong_size 10
			/*reflection_min 0 reflection_max .5 reflection_falloff 4*/
	}
	texture{
		pigment {
			pigment_pattern {
				bozo warp{turbulence .3 octaves 2 lambda 3}
				scale 3
				color_map {[.1 rgb 0][.9 rgb 1]}
			}
			pigment_map {
				[.1 granite scale .01 color_map{[.6 rgb<1, .5, .2>*.8][.7 rgb .7*.9]}]
				[.9 granite scale .01 color_map{[.2 rgb<1, .5, .2>*.8][.3 rgb .7*.9]}]
			}
		}
		normal{
			pigment_pattern{gradient y scale PotH warp{turbulence .01 octaves 2}}
			normal_map{
				#local StB=seed(1342);
				#local i=.01;
				#while(i<.99)
					[i gradient y bump_size -.5 scallop_wave turbulence .1 octaves 2 scale PotH*.2*(.2+.8*rand(StB))]
					#local i=i+rand(StB)*.15;
				#end
				[5 granite scale 0.1]
			}
		}
		finish{F_Pot}
	}
}

#declare f_monticule=function{pigment{cylindrical scale (PotR-PotEp1) color_map{[0 rgb 0][1 rgb 1]}}}
#declare f_boulettes=function{pigment{bozo scale .3*PotEp1 color_map{[0 rgb 0][1 rgb 1]}}}

#declare TerreBonsai = intersection{
	cylinder{-.01*y,(TerreH+PotEp1)*y, (PotR-PotEp1)}
	isosurface{
		function{y-TerreH*f_monticule(x,y,z).red-PotEp1*f_boulettes(x,y,z).red}
//		evaluate 1,10,.9
		max_gradient 5
		contained_by{box{<-(PotR-PotEp1)*1.01,-.011,-(PotR-PotEp1)*1.01>,<(PotR-PotEp1)*1.01,(TerreH+PotEp1)*1.01,(PotR-PotEp1)*1.01>}}
	}
	texture{
#if (Bonsai_Mousse)
		pigment{rgb<.5,.3,.05>*.7}finish{brilliance .95}
#else
		bozo warp{turbulence .2} scale 3 warp{turbulence .2 lambda 6}
		texture_map{
			[.49 pigment{rgb<.5,.3,.05>*.7}finish{brilliance .95}]
			[.51 pigment{bozo scale .01 color_map{[.3 rgb<.4,.7,.2>*.7][.3 rgb<.6,.7,.2>*.7]}} normal{agate 1.5 agate_turb 1.0 scale .02}]
		}
#end
	}
}

#if (Bonsai_Mousse)
#declare f_mousse=function{pigment{
	pigment_pattern{bozo warp{turbulence .2} scale 3 warp{turbulence .2 lambda 6} color_map{[0.4 rgb 0][.6 rgb 1]}}
	pigment_map{[0 rgb 0][1 bozo scale .1 color_map{[0 rgb .5][1 rgb 1]}]}
}}
#declare MousseBonsai = intersection{
	cylinder{-.01*y,(TerreH+PotEp1*2)*y, (PotR-PotEp1)}
	isosurface{
		function{y+(PotEp1/2)-TerreH*f_monticule(x,y,z).red-PotEp1*2*f_mousse(x,y,z).red}
//		evaluate 1,10,.9
		accuracy .01
		max_gradient 10
		contained_by{box{<-(PotR-PotEp1)*1.01,-.011,-(PotR-PotEp1)*1.01>,<(PotR-PotEp1)*1.01,(TerreH+PotEp1*2)*1.01,(PotR-PotEp1)*1.01>}}
	}
	texture{
/*		bozo warp{turbulence .2} scale 3 warp{turbulence .2 lambda 6}
		texture_map{
			[.49 pigment{rgb<.5,.3,.05>*.7}finish{brilliance .95}]
			[.51 pigment{bozo scale .01 color_map{[.3 rgb<.4,.7,.2>*.7][.3 rgb<.6,.7,.2>*.7]}} normal{agate 1.5 agate_turb 1.0 scale .02}]
		}
*/		pigment{bozo scale .01 color_map{[.3 rgb<.4,.7,.2>*.8][.3 rgb<.6,.7,.2>*.8]}}normal{agate 1.5 agate_turb 1.0 scale .02}
	}
}
#end


#if (Bonsai_Tree)
#include "txttree.inc"
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_3}
#declare Leaf=object{#include "bonsaileaf.inc"}
#declare Bonsai=union{
	object{#include "bonsaitree.inc"}
	object{#include "bonsaifoliage.inc" texture{txtLeaf}}
}
#end


//================
//	SAMPLE SCENE
//================

#if (test_bonsai_inc)

#declare Rad=on;
#declare Area=on;
#declare NbArea=6;

#declare Rad_count=100;
#declare Rad_error = 0.6;
#declare Rad_rec = 1;
#declare Rad_brigth = 1.0;
#declare Rad_bo = 0.02;
#declare Rad_maxs = 2.0;

global_settings {
        max_trace_level 35
        adc_bailout 0.02
#if (Rad)
        radiosity{
                count Rad_count
                nearest_count 4
                error_bound Rad_error
                recursion_limit Rad_rec
                brightness Rad_brigth

                pretrace_start  .05
                pretrace_end  .02

                low_error_factor .5
                gray_threshold 0.2
                minimum_reuse 0.015
                normal on

                max_sample Rad_maxs
                adc_bailout Rad_bo
        }
#end
}


camera {
	location <2, 9, -20>*3
	angle 35
	look_at <0,PotH*2,0>
}

background{rgb <.5,.6,1>*.7}

light_source{<-1,1,-1>*100 color rgb <1,.98,.85>*1.7
#if (Area)
	area_light 20*x,20*y, NbArea,NbArea
	circular orient jitter adaptive 1
#end
}
#if (Rad=off)
light_source{< 1,1,-1>*100 color rgb 0.3 shadowless}
#end

#local St=seed(1342);
plane {y, 0
	texture{
		pigment{rgb 1}
		finish {diffuse 0.6}
	}
}

#if (Bonsai_Tree)
object{Bonsai scale .9 rotate -y*20 translate <1,(PotH-PotEp1/4),1>}
#end
object{PotBonsai}
object{TerreBonsai translate (PotH-PotEp1*1.5)*y }
#if (Bonsai_Mousse)
object{MousseBonsai translate (PotH-PotEp1*1.5)*y }
#end

#end
