// cubes.inc

#declare test_cubes_inc = off;

#macro LampeCube(Cote, Ep, Ec, Col, Area, Lga, Nba, Media, Nbs, Mepint, Mepext, Fdist, Fpow)

#local Lng1=Cote/2;
#local Lng2=Cote/2-Ep;
#local Lng3=(Lng1+Lng2)/2;

#local T_Cote = texture{
	pigment{
		wood frequency 10 warp{turbulence .06}
		color_map{[0 rgb<.4,.3,.05>*1.5][1 rgb<.4,.3,.05>*.7]}
	}
	normal{
		average
		normal_map{
			[1 pigment_pattern{wood frequency 10 warp{turbulence .2}color_map{[0 rgb 1][1 rgb 0]}}
			   slope_map{[.7 <1,0>][.95 <0,0>]}]
			[1 dents -.5 scale .001]
		}
	}
	finish{specular .5 roughness .01}
	scale Ep
}

union {
	union {
		box{<-Lng1,-Lng1,-Lng1>,<Lng1,-Lng2,-Lng2>}
		box{<-Lng1, Lng1,-Lng1>,<Lng1, Lng2,-Lng2>}
		box{<-Lng1,-Lng1, Lng1>,<Lng1,-Lng2, Lng2>}
		box{<-Lng1, Lng1, Lng1>,<Lng1, Lng2, Lng2>}
		texture{T_Cote rotate y*90}
	}
	union {
		box{<-Lng1,-Lng1,-Lng2+Ec>,<-Lng2,-Lng2, Lng2-Ec>}
		box{< Lng1,-Lng1,-Lng2+Ec>,< Lng2,-Lng2, Lng2-Ec>}
		box{<-Lng1, Lng1,-Lng2+Ec>,<-Lng2, Lng2, Lng2-Ec>}
		box{< Lng1, Lng1,-Lng2+Ec>,< Lng2, Lng2, Lng2-Ec>}
		texture{T_Cote}
	}
	union {
		box{<-Lng1,-Lng2+Ec,-Lng1>,<-Lng2, Lng2-Ec,-Lng2>}
		box{< Lng1,-Lng2+Ec,-Lng1>,< Lng2, Lng2-Ec,-Lng2>}
		box{<-Lng1,-Lng2+Ec, Lng1>,<-Lng2, Lng2-Ec, Lng2>}
		box{< Lng1,-Lng2+Ec, Lng1>,< Lng2, Lng2-Ec, Lng2>}
		texture{T_Cote rotate x*90}
	}
	box{<-Lng3,-Lng3,-Lng3>,< Lng3, Lng3, Lng3>
		hollow
		double_illuminate
		texture{
			pigment{ spotted turbulence .5 scale .15
				color_map{[.7 rgbf<.98,.98,.96,.2>][.8 rgb<.98,.98,.96>*.3]}
			}
			finish{diffuse .4 phong .1 phong_size 20}
		}
		interior_texture{
			pigment{rgbf<.98,.98,.96,1>}
			normal{wrinkles .2}
			finish{diffuse .4 brilliance .9 specular .4 roughness .1}
		}
		#if (Media)
		interior{
			media{
				scattering{5, rgb<.98.97.95>*0.8 eccentricity .5 extinction 0}
				samples Nbs,Nbs variance 1/128 confidence .9 aa_level 3 aa_threshold .1 jitter 1
				density{boxed scale Lng3 color_map{[0 rgb 1][Mepext rgb 0][max(1-Mepint,Mepext) rgb 0][1 rgb .5]}}
			}
		}
		#end
	}
	light_source{0, color Col
		fade_distance Fdist fade_power Fpow
		#if (Area)
		area_light Lga*x, Lga*y, Nba, Nba
		circular orient jitter adaptive 1
		#end
	}
}

#end


//==============
// sample scene
//==============
#if (test_cubes_inc)

camera {location <0,5.5,-20> angle 40 look_at <0,0,0>}

plane{y, -3 pigment{rgb 1}}
plane{x, -5 pigment{rgb 1}}
plane{-z, -4 pigment{rgb 1}}

object {
//	LampeCube(Cote, Ep, Ec, Col, Area, Lga, Nba, Media, Nbs, Mepint, Mepext, Fdist, Fpow)
	LampeCube(6, .7, .01, <1,1,.9>*1.5, on, 3, 5, on, 4, .5, .2, 150, 2)
	rotate y*30
}

#declare Rad=on;

#declare Rad_count=100;
#declare Rad_error = .8;
#declare Rad_rec = 1;
#declare Rad_brigth = 2.0;
#declare Rad_bo = 0.1;
#declare Rad_maxs = 2.0;

global_settings {
        max_trace_level 35
        adc_bailout 0.1
#if (Rad)
        radiosity{
                count Rad_count
                nearest_count 4
                error_bound Rad_error
                recursion_limit Rad_rec
                brightness Rad_brigth

                pretrace_start  .05
                pretrace_end  .02

                low_error_factor .5
                gray_threshold 0.2
                minimum_reuse 0.015
                normal on

                max_sample Rad_maxs
                adc_bailout Rad_bo
        }
#end
}

#if (Rad=off)
light_source {<-1,1,-1>*100 color rgb .4 media_interaction off}
#end

#end
