#include "colors.inc"
#include "woods.inc"

#declare test_puzzle_inc = off;

#declare PuzLong = 15/2;
#declare PuzHaut = 12/2;
#declare PuzLarg = 12/2;
#declare Cote = 2/2;
#declare Decal = 2;
#declare Scal = .97;
#declare AngMax = .4*degrees(asin(1-Scal));

#declare TWoods = array[8]
#declare TWoods[0] = texture{T_Wood1}
#declare TWoods[1] = texture{T_Wood13}
#declare TWoods[2] = texture{T_Wood14}
#declare TWoods[3] = texture{T_Wood23}
#declare TWoods[4] = texture{T_Wood30}
#declare TWoods[5] = texture{T_Wood10}
#declare TWoods[6] = texture{T_Wood7}
#declare TWoods[7] = texture{T_Wood28}

#declare StP=seed(13420);

#declare Puzzle = union {
	// suivant l'axe x
	union{
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,-PuzHaut+Decal+Cote,-PuzLarg+Decal>
		}
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,-PuzHaut+Decal+Cote,-PuzLarg+Decal+2*Cote>
		}
	}
	union{
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,+PuzHaut-Decal-Cote,-PuzLarg+Decal>
		}
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,+PuzHaut-Decal-Cote,-PuzLarg+Decal+2*Cote>
		}
	}
	union{
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,-PuzHaut+Decal+Cote,+PuzLarg-Decal>
		}
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,-PuzHaut+Decal+Cote,+PuzLarg-Decal-2*Cote>
		}
	}
	union{
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,+PuzHaut-Decal-Cote,+PuzLarg-Decal>
		}
		box{<-PuzLong,-Cote*Scal,-Cote*Scal>,<PuzLong,Cote*Scal,Cote*Scal>
			rotate .2*x*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate y*90 rotate x*90*(2*rand(StP)-1) translate Cote*<5*rand(StP),rand(StP),rand(StP)>}
			translate <0,+PuzHaut-Decal-Cote,+PuzLarg-Decal-2*Cote>
		}
	}
	// suivant l'axe z
	union{
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <-PuzLong+Decal+Cote,-PuzHaut+Decal,0>
		}
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*17),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <-PuzLong+Decal+Cote,-PuzHaut+Decal+2*Cote,0>
		}
	}
	union{
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <+PuzLong-Decal-Cote,-PuzHaut+Decal,0>
		}
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <+PuzLong-Decal-Cote,-PuzHaut+Decal+2*Cote,0>
		}
	}
	union{
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <-PuzLong+Decal+Cote,+PuzHaut-Decal,0>
		}
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <-PuzLong+Decal+Cote,+PuzHaut-Decal-2*Cote,0>
		}
	}
	union{
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <+PuzLong-Decal-Cote,+PuzHaut-Decal,0>
		}
		box{<-Cote*Scal,-Cote*Scal,-PuzLarg>,<Cote*Scal,Cote*Scal,PuzLarg>
			rotate .2*z*AngMax*(2*rand(StP)-1)
			rotate y*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate z*90*(2*rand(StP)-1) translate Cote*<rand(StP),rand(StP),5*rand(StP)>}
			translate <+PuzLong-Decal-Cote,+PuzHaut-Decal-2*Cote,0>
		}
	}
	// suivant l'axe y
	union{
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <-PuzLong+Decal,0,-PuzHaut+Decal+Cote>
		}
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <-PuzLong+Decal+2*Cote,0,-PuzHaut+Decal+Cote>
		}
	}
	union{
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <+PuzLong-Decal,0,-PuzHaut+Decal+Cote>
		}
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <+PuzLong-Decal-2*Cote,0,-PuzHaut+Decal+Cote>
		}
	}
	union{
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <-PuzLong+Decal,0,+PuzHaut-Decal-Cote>
		}
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <-PuzLong+Decal+2*Cote,0,+PuzHaut-Decal-Cote>
		}
	}
	union{
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <+PuzLong-Decal,0,+PuzHaut-Decal-Cote>
		}
		box{<-Cote*Scal,-PuzHaut,-Cote*Scal>,<Cote*Scal,PuzLarg,Cote*Scal>
			rotate .2*y*AngMax*(2*rand(StP)-1)
			rotate z*AngMax*(2*rand(StP)-1)
			rotate x*AngMax*(2*rand(StP)-1)
			texture{TWoods[mod(int(rand(StP)*97),8)] rotate x*90 rotate y*90*(2*rand(StP)-1) translate Cote*<rand(StP),5*rand(StP),rand(StP)>}
			translate <+PuzLong-Decal-2*Cote,0,+PuzHaut-Decal-Cote>
		}
	}
}




#if (test_puzzle_inc)

#declare Rad=on;
#declare Area=on;
#declare NbArea=6;

#declare Rad_count=150;
#declare Rad_error = 0.5;
#declare Rad_rec = 1;
#declare Rad_brigth = 1.0;
#declare Rad_bo = 0.02;
#declare Rad_maxs = 2.0;

global_settings {
        max_trace_level 35
        adc_bailout 0.02
#if (Rad)
        radiosity{
                count Rad_count
                nearest_count 4
                error_bound Rad_error
                recursion_limit Rad_rec
                brightness Rad_brigth

                pretrace_start  .05
                pretrace_end  .02

                low_error_factor .5
                gray_threshold 0.2
                minimum_reuse 0.015
                normal on

                max_sample Rad_maxs
                adc_bailout Rad_bo
        }
#end
}


camera {
	location <12, 8, -20>*3
	angle 30
	look_at 0
}

background{rgb <.5,.6,1>*.7}

light_source{<-1,1,-1>*100 color rgb <1,.98,.85>*1.7
#if (Area)
	area_light 20*x,20*y, NbArea,NbArea
	circular orient jitter adaptive 1
#end
}
#if (Rad=off)
light_source{< 1,1,-1>*100 color rgb 0.3 shadowless}
#end

#local St=seed(1342);
plane {y, -PuzHaut
	texture{
		pigment{rgb 1}
		normal{
			average normal_map{
				#local i=0;
				#while(i<50)
					[1 bozo .4 scale .001 translate .002*<rand(St),rand(St),rand(St)>]
					#local i=i+1;
				#end
			}
		}
		finish {diffuse 0.3 reflection{.3,.4}}
	}
}
object{Puzzle translate 4*z}
plane{-z, -20 pigment{rgb <.7,.8,1>*.6}}

#end
