// IRTC 12/2001
// tables.inc

#declare test_tables_inc = off;

#include "tblur.mcr"
#include "nblur.mcr"

#declare LnT1=120;
#declare LgT1=80;
#declare HtT1=40;
#declare LpT1=10;
#declare DecT1=.4;

#declare TableBasse1 = union{
	box {<-LnT1/2+DecT1, HtT1*3/4, -LgT1/2+DecT1>,<LnT1/2-DecT1, HtT1-DecT1, LgT1/2-DecT1>}
	box {<-LnT1/2, 0, -LgT1/2>,<-LnT1/2+LpT1, HtT1, -LgT1/2+LpT1>}
	box {< LnT1/2, 0, -LgT1/2>,< LnT1/2-LpT1, HtT1, -LgT1/2+LpT1>}
	box {<-LnT1/2, 0,  LgT1/2>,<-LnT1/2+LpT1, HtT1,  LgT1/2-LpT1>}
	box {< LnT1/2, 0,  LgT1/2>,< LnT1/2-LpT1, HtT1,  LgT1/2-LpT1>}
	union{
		intersection{
			box{<-LnT1/2+LpT1,HtT1*3/4,-LgT1/2+DecT1/2>,< LnT1/2-LpT1,HtT1-DecT1,-LgT1/2+DecT1>}
			plane{y,0 rotate -x*45 translate <0,HtT1-DecT1,-LgT1/2+DecT1>}
		}
		intersection{
			box{<-LnT1/2+LpT1,HtT1*3/4, LgT1/2-DecT1/2>,< LnT1/2-LpT1,HtT1-DecT1, LgT1/2-DecT1>}
			plane{y,0 rotate  x*45 translate <0,HtT1-DecT1, LgT1/2-DecT1>}
		}
		intersection{
			box{<-LnT1/2+DecT1/2,HtT1*3/4,-LgT1/2+LpT1>,<-LnT1/2+DecT1,HtT1-DecT1, LgT1/2-LpT1>}
			plane{y,0 rotate  z*45 translate <-LnT1/2+DecT1,HtT1-DecT1,0>}
		}
		intersection{
			box{< LnT1/2-DecT1/2,HtT1*3/4,-LgT1/2+LpT1>,< LnT1/2-DecT1,HtT1-DecT1, LgT1/2-LpT1>}
			plane{y,0 rotate -z*45 translate < LnT1/2-DecT1,HtT1-DecT1,0>}
		}
		texture{pigment{rgb .1}normal{N_blur(20,.5)}finish{phong .5 phong_size 10}}
	}
	texture{
		#declare Pig = pigment{rgb<1,.6,.2>*.3}
		#declare Fin = finish{specular .7 roughness .01 phong .2 phong_size 20 reflection{0,.2 falloff 3}}
		T_blur(10,.2, Pig, Fin)
	}
}


#declare LnT2=100;
#declare LgT2=55;
#declare HtT2=30;
#declare LpT2=10;
#declare DecT2=.5;


#declare TableBasse2 = union{
	box {<-LgT2/2+DecT2, 3*HtT2/4, -LnT2/2+DecT2>,<LgT2/2-DecT2, HtT2-DecT2, LnT2/2-DecT2>}
	box {<-LgT2/2, 0, -LnT2/2>,<-LgT2/2+LpT2, HtT2, -LnT2/2+LpT2>}
	box {< LgT2/2, 0, -LnT2/2>,< LgT2/2-LpT2, HtT2, -LnT2/2+LpT2>}
	box {<-LgT2/2, 0,  LnT2/2>,<-LgT2/2+LpT2, HtT2,  LnT2/2-LpT2>}
	box {< LgT2/2, 0,  LnT2/2>,< LgT2/2-LpT2, HtT2,  LnT2/2-LpT2>}
	pigment{rgb<.3,.21,.06>*1.5}
	normal{N_blur(20,.3)}
	finish{specular .7 roughness .01 phong .2 phong_size 20 reflection{0,.1 falloff 3}}
}


//================
//	SAMPLE SCENE
//================

#if (test_tables_inc)

#declare Rad=on;
#declare Area=on;
#declare NbArea=4;

#declare Rad_count=100;
#declare Rad_error = 0.8;
#declare Rad_rec = 1;
#declare Rad_brigth = 1.0;
#declare Rad_bo = 0.02;
#declare Rad_maxs = 2.0;

global_settings {
        max_trace_level 35
        adc_bailout 0.02
#if (Rad)
        radiosity{
                count Rad_count
                nearest_count 4
                error_bound Rad_error
                recursion_limit Rad_rec
                brightness Rad_brigth

                pretrace_start  .05
                pretrace_end  .02

                low_error_factor .5
                gray_threshold 0.2
                minimum_reuse 0.015
                normal on

                max_sample Rad_maxs
                adc_bailout Rad_bo
        }
#end
}


camera {
	location <10, 55, -90>*3
	angle 35
	look_at <0,HtT1,0>
}

background{rgb <.5,.6,1>*.7}

light_source{<-1,1,-1>*100 color rgb <1,.98,.85>*1.7
#if (Area)
	area_light 20*x,20*y, NbArea,NbArea
	circular orient jitter adaptive 1
#end
}
#if (Rad=off)
light_source{< 1,1,-1>*100 color rgb 0.3 shadowless}
#end

#local St=seed(1342);
plane {y, 0
	texture{
		pigment{rgb 1}
		finish {diffuse 0.6}
	}
}

object{TableBasse1 rotate y*88}


//========
// coussins
//========
#include "coussins.inc"
#include "functions.inc"
#declare Tex1=texture{
	pigment{image_map{jpeg "coussin1"}}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
#declare Tex2=texture{
	pigment{color rgb <38,116,152>/255}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
object{
//	Coussin(lng, lrg, haut, Rbord, nbx, nbz, func, NORM, UV, Tex1, Tex2, Tex3)
	Coussin(40, 40, 8, .5, 30, 30, function{f_noise3d(x*.1,y,z*.1)}, on, on, Tex1, Tex2, Tex2)
	rotate -y*100
	translate 62*x+4*z
}
#declare Tex1=texture{
	pigment{image_map{jpeg "coussin2"}}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
#declare Tex2=texture{
	pigment{color rgb <59,91,140>/255}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
object{
//	Coussin(lng, lrg, haut, Rbord, nbx, nbz, func, NORM, UV, Tex1, Tex2, Tex3)
	Coussin(40, 40, 8, .5, 30, 30, function{f_noise3d(x*.1+2,y,z*.1+5)}, on, on, Tex1, Tex2, Tex2)
	rotate y*4
	translate -65*x-2*z
}

//========
// the
//========
#include "tea.inc"

object{TeaCup rotate y*10 translate <-26,HtT1-DecT1,-2>}
object{TeaCup rotate -y*70 translate <29,HtT1-DecT1, 2>}
object{TeaPot rotate y*15 translate <7, HtT1-DecT1, 22>}

#end
