// tatamis.inc

#declare test_tatamis_inc=off;

#macro Tatami(Coin1, Coin2, Epbord, Epb, St)

#local Larg1=(Coin2.x-Coin1.x)-2*Epbord;

#local nbb=int(Larg1/Epb);
#local Rb = 1.5*Larg1/(2*nbb);

union{
#local i=0;
#local start=Coin1.x+Rb+Epbord;
#while(i<nbb)
	cylinder{<start,-Rb,Coin1.z+Epbord>,<start,-Rb,Coin2.z-Epbord>, Rb
		texture{
			pigment{color rgb <0.871,0.875,0.690>}
			normal{gradient z turbulence .1 scallop_wave frequency 5 scale Epb rotate y*35 translate rand(St)*Epb*z}
			finish{phong .1 phong_size 5}
		}
		scale <1,(Coin2.y-Coin1.y)/Rb,1>
		translate y*(2*rand(St)-1)*(Coin2.y-Coin1.y)*.05
	}
	#local start=start+2*Rb/1.5;
	#local i=i+1;
#end
	box{Coin1, Coin2-y*(Coin2.y-Coin1.y)/3
		texture{
			pigment{rgb<1,.6,.2>*.5}
			normal{granite .5 scale .001}
			finish{specular .3 roughness .01 phong .3 phong_size 20}
		}
	}
}
#end


//==============
// sample scene
//==============
#if (test_tatamis_inc)

camera{
	location <50, 120, -200>
	angle 35
	look_at <30,0,0>
}
light_source{<-1,.5,-1>*300 color rgb 1.7}

plane{y,0 pigment{rgb 1}}

#declare St=seed(1342);
//	Tatami(Coin1, Coin2, Epbord, Epb, St)
object{
	Tatami(<-50,0,-75>, <50,1,75>, 2, 2, St)
	translate 10*z
}
object{
	Tatami(<-50,0,-75>, <50,1,75>, 2, 2, St)
	rotate y*89
	translate <75-50, 0, 75+52>
}
object{
	Tatami(<-50,0,-75>, <50,1,75>, 2, 2, St)
	rotate y*1
	translate <101, 0, -1>
}
#end
