// teacups for IRTC Nov/Dec. 2001
//#version unofficial megapov 0.6;

#declare test_tea_inc = off;

#declare teacol1 = <1,.96,.92>;
#declare teacol2 = <.8,.56,.32>;


#declare CupHaut = 8;
#declare CupFond = 2.5;
#declare CupR1 = 4;
#declare CupR2 = 2;
#declare CupR3 = .4;


#declare T_tea1 = texture{
	pigment{
		pigment_pattern{ marble rotate z*10 warp{turbulence .2 lambda 4} scale 5}
		pigment_map{
			[.4 marble rotate z*5 turbulence .3 color_map{[0 rgb teacol1][1 rgb teacol1*.7]}]
			[.6 marble rotate -z*5 frequency 2 scale 3 warp{turbulence .3} color_map{[0 rgb teacol2*1.1][1 rgb teacol2*.5]}]
		}
		rotate z*65
		warp{turbulence 1 lambda 5 octaves 2}
	}
	normal{granite .1 scale .1}
	finish{phong .2 phong_size 2 specular .4 roughness .002}
}

#declare TeaCup = union{
	intersection{
		difference {
			#local temp=cos(asin(CupR2/CupR1));
			sphere{0, 1 translate temp*y scale <CupR1, CupHaut/temp, CupR1>}
			sphere{0, 1 scale <CupR1-CupR3, CupHaut-CupFond, CupR1-CupR3> translate CupHaut*y}
		}
		box{<-CupR1*1.01, 0, -CupR1*1.01>, <CupR1*1.01, CupHaut, CupR1*1.01>}
	}
	torus{CupR1-CupR3/2, CupR3/2 translate CupHaut*y}
	torus{CupR2,CupR3/2 translate y*CupR3/2}
	texture{T_tea1}
}

#declare Teapot_Texture = texture{T_tea1 scale 1.5/4}
#declare Teapot_Orientation = <-90,0,0>;
#declare TeaPot = object {
	#include "teapot.inc"
	scale 4
}


// ============
// SAMPLE SCENE
// ============

#if (test_tea_inc)

#declare Rad=on;
#declare Area=on;
#declare NbArea=6;

#declare Rad_count=400;
#declare Rad_error = 0.05;
#declare Rad_rec = 1;
#declare Rad_brigth = 1.0;
#declare Rad_bo = 0.02;
#declare Rad_maxs = 2.0;

global_settings {
	max_trace_level 35
	adc_bailout 0.02
#if (Rad)
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_brigth

		pretrace_start  1
		pretrace_end  1

		low_error_factor .5
		gray_threshold 0.2
		minimum_reuse 0.015
		normal on

		max_sample Rad_maxs
		adc_bailout Rad_bo
	}
#end
}


camera {
	location <5, 10, -15>*3.5
	angle 30
	look_at <2,5,3>
}

background{rgb <.5,.6,1>*.7}

light_source{<-1,1,-1>*100 color rgb <1,.98,.85>*1.7
#if (Area)
	area_light 20*x,20*y, NbArea,NbArea
	circular orient jitter adaptive 1
#end
}
#if (Rad=off)
light_source{< 1,1,-1>*100 color rgb 0.3 shadowless}
#end

#local St=seed(1342);
plane {y, 0
	texture{
		pigment{rgb 1}
		finish {diffuse 0.5 }
	}
}
object{TeaCup translate <-4,0,-2>}
object{TeaPot rotate y*15 translate <3, 0, 12>}

#end
