#version 3.5;

// standard include files

#include "colors.inc"
#include "rad_def.inc"
#include "consts.inc"
#include "finish.inc"

// origami include files

#include "origami.inc"
#include "kimono.inc"
#include "head.inc"
#include "table.inc"
#include "wall.inc"

// others

#include "others/furtex.inc"
#include "others/dof.inc"

global_settings{
  assumed_gamma 1.0
  noise_generator 2
  #if(Quality)
    radiosity{Rad_Settings(Radiosity_OutdoorLQ,1,1)}
  #end
}

// constants

#declare Room_Width=10;
#declare Room_Height=3;
#declare Room_Long=20;

#declare Room_Min=<-Room_Width/2,0,-Room_Long/2>;
#declare Room_Max=<Room_Width/2,Room_Height,Room_Long/2>;

#declare Column_Size=.1;
#declare Wall_Cell=.5;

#declare Camera_Location=Room_Min+1;
#declare Camera_Angle=45;
#declare Camera_LookAt=y;

#declare Mountains=1000;

// textures

#declare Floor_Texture=FurTex(color rgb .5);
#declare Carpet_Texture=texture{pigment{color rgb .9}finish{Dull}};
#declare Roof_Texture=FurTex(color rgb .9);
#declare Column_Texture=texture{pigment{color rgb Brown.gray}finish{Dull}};
#declare Wall_Texture=texture{pigment{color rgb .5 filter .5}finish{Dull}};
#declare Grass_Texture=FurTex(color rgb Green.gray);
#declare Ground_Texture=FurTex(White);

// world

camera{
  perspective
  direction z
  sky y
  up y
  right x*image_width/image_height
  location Camera_Location 
  look_at Camera_LookAt
  angle Camera_Angle
  #if(Quality)
    blur_samples 30
    /*
    DoF(
      Camera_Location,
      image_width/2,
      Camera_Angle,
      Camera_LookAt,
      0,
      Room_Max/2
    )
    */
    aperture 0.113
    focal_point <0.884, 1.000, 1.988>
  #end
}

background{color rgb 1}

light_source{
  (Room_Height-.5)*y
  color rgb 1
  fade_distance Room_Height
  fade_power 2
  area_light x/4,z/4,4,4
}

light_source{
  1000*(y+x)
  color rgb .75
}

// space of room
// box{ Room_Min Room_Max }

// floor
polygon{
  5
  <Room_Min.x-1,Room_Min.y,Room_Min.z-1>
  <Room_Max.x+1,Room_Min.y,Room_Min.z-1>
  <Room_Max.x+1,Room_Min.y,Room_Max.z+1>
  <Room_Min.x-1,Room_Min.y,Room_Max.z+1>
  <Room_Min.x-1,Room_Min.y,Room_Min.z-1>
  texture{Floor_Texture}
}

polygon{
  5
  <Room_Min.x+1,Room_Min.y,Room_Min.z+1>
  <Room_Max.x-1,Room_Min.y,Room_Min.z+1>
  <Room_Max.x-1,Room_Min.y,Room_Max.z-1>
  <Room_Min.x+1,Room_Min.y,Room_Max.z-1>
  <Room_Min.x+1,Room_Min.y,Room_Min.z+1>
  texture{Carpet_Texture}
  translate y*.001
}

plane{
  y,0
  translate -y*.001
  texture{
    gradient x
    texture_map{
      [2/1000 Ground_Texture]
      [2/1000 Grass_Texture]
    }
    scale 1000
    warp{turbulence <1,0,1>}
    scale .1
    warp{turbulence .5}
    scale 10
    rotate y*5
  }
}

// roof
polygon{
  5
  <Room_Min.x-1,Room_Max.y,Room_Min.z-1>
  <Room_Max.x+1,Room_Max.y,Room_Min.z-1>
  <Room_Max.x+1,Room_Max.y,Room_Max.z+1>
  <Room_Min.x-1,Room_Max.y,Room_Max.z+1>
  <Room_Min.x-1,Room_Max.y,Room_Min.z-1>
  texture{Roof_Texture}
}

// wooden columns
#macro Column(P)
  prism{
    linear_spline
    linear_sweep
    Room_Min.y Room_Max.y
    5
    P
    P+DirX*Column_Size
    P+(DirX+DirZ)*Column_Size
    P+DirZ*Column_Size
    P
    open sturm
  }
#end

#macro Columns(Start,DirX,DirZ)
  Column(Start)
  Column(Start-(DirX+DirZ))
  Column(Start+3*DirX)
  Column(Start+4*DirZ)
  Column(Start+3*DirX+4*DirZ)
  Column(Start+3*DirX-DirZ)
  Column(Start+4*DirZ-DirX)
#end

union{
  Columns(<Room_Min.x,Room_Min.z>,u,v)
  Columns(<Room_Min.x,Room_Max.z>,u,-v)
  Columns(<Room_Max.x,Room_Min.z>,-u,v)
  Columns(<Room_Max.x,Room_Max.z>,-u,-v)
  texture{Column_Texture}
}

// walls

#local Folded_Cell=Wall(1,.1);
#local Cell=Draw_Flat_Mesh(Folded_Cell);
#local Cell=union{
  object{Cell}
  object{Cell scale <-1,1,1>}
  object{Cell scale <-1,-1,1>}
  object{Cell scale <1,-1,1>}
}

#local Min=min_extent(Cell);
#local Max=max_extent(Cell);
#local Size=Max-Min;
#local Cell_X=object{
  Cell
  translate -Min
  scale <Wall_Cell/Size.x,Wall_Cell/Size.y,(1/Size.x+1/Size.y)/2>
}
#local Cell_Z=object{Cell_X rotate y*90}

#macro Along_X(Start,DX)
  #local CX=0;
  #while (CX<DX)
    #local CY=0;
    #while (CY<(Room_Max.y-Room_Min.y))
      object{Cell_X translate Start+<CX,CY,0>}
      #local CY=CY+Wall_Cell;
    #end
    #local CX=CX+Wall_Cell;
  #end
#end

#macro Along_Z(Start,DZ)
  #local CZ=0;
  #while (CZ<DZ)
    #local CY=0;
    #while (CY<(Room_Max.y-Room_Min.y))
      object{Cell_Z translate Start+<0,CY,CZ>}
      #local CY=CY+Wall_Cell;
    #end
    #local CZ=CZ+Wall_Cell;
  #end
#end

  union{
    Along_X(<Room_Max.x,Room_Min.y,Room_Max.z>-(3*x+4*z),3)
    Along_X(<Room_Min.x,Room_Min.y,Room_Max.z>,3)
    Along_X(<Room_Max.x-3,Room_Min.y,Room_Max.z>,3)
    Along_X(Room_Min,Room_Max.x-Room_Min.x)
    Along_Z(Room_Min,Room_Max.z-Room_Min.z)
    Along_Z(<Room_Max.x,Room_Min.y,Room_Min.z>,Room_Max.z-Room_Min.z)
    Along_Z(<Room_Max.x,Room_Min.y,Room_Max.z>-(3*x+4*z),4)
    texture{Wall_Texture}
  }

// mountains

#local Mountain=mesh{
  triangle{-x,y,x}
  triangle{-x,-y,x}
}
#local Generator=seed(1);
#local Counter=0;
#while (Counter<Mountains)
    object{
      Mountain
      texture{
        pigment{
          gradient y
          color_map{
            [.5 color rgb .5+.5*rand(Generator)]
            [.5 color rgb 1]
          }
          translate -y/2
          scale 4
          translate 100*x*rand(Generator)
          warp{turbulence <.1,1,.1>}
          scale <.05,1,1>
        }
        finish{Glossy}
      }
      rotate z*(-30+60*rand(Generator))
      rotate 45*x*rand(Generator)
      #local Dist=(1000*rand(Generator)+100);
      scale Dist*rand(Generator)/10
      translate z*Dist
      rotate 360*y*rand(Generator)
      no_shadow
    }
  #local Counter=Counter+1;
#end


// table

#declare Folded_Table=Draw_Flat_Mesh(Table(.210 .297));
union{
  object{Folded_Table scale <1,-1,1>}
  object{Folded_Table scale <-1,-1,1>}
  object{Folded_Table scale <-1,-1,-1>}
  object{Folded_Table scale <1,-1,-1>}
  scale 5
  rotate y*90
  translate x*Room_Width/6-2.5*z
  pigment{color rgb .5}
}

// man

#local Folded_Kimono=Kimono(
  1.5     // PaperSize
  0.085   // Collar_Ratio
  0.61    // Sides_Ratio
  0.245   // Sleeve_Ratio1
  0.35    // Sleeve_Ratio2
  0.162   // Sleeve_Ratio3
  0.7     // Sleeve_Ratio4
  179.9   // Collar_Angle
  179     // Left_Side
  178     // Right_Side
  179.5   // Inner_Side
  80     // Left_Sleeve
  80     // Right_Sleeve
);

#local Folded_Head=Head(
  .48
)

#local Man=union{
  object{
    Draw_Flat_Mesh(Folded_Kimono)
    material{
      texture{uv_mapping pigment{granite color_map{[0 color rgb .5][1 color rgb 1]}scale 1/50}finish{Dull}}
      interior_texture{uv_mapping pigment{granite color_map{[0 color rgb .5][1 color rgb 0]}scale 1/20}finish{Dull}}
    }
  }
  object{
    Draw_Flat_Mesh(Folded_Head)
    material{
      texture{uv_mapping pigment{color rgb .1 scale 1/50}}
      interior_texture{uv_mapping pigment{color rgb .9 scale 1/20}}
    }
  }
}

object{
  Man
  translate -y*min_extent(Man).y
  translate -xz*(min_extent(Man)+max_extent(Man))/2
  scale 1.5
  translate z*12
}

// woman

#local Folded_Kimono=Kimono(
  1.5     // PaperSize
  0.085   // Collar_Ratio
  0.61    // Sides_Ratio
  0.245   // Sleeve_Ratio1
  0.35    // Sleeve_Ratio2
  0.162   // Sleeve_Ratio3
  0.7     // Sleeve_Ratio4
  179.9   // Collar_Angle
  179     // Left_Side
  178     // Right_Side
  179.5   // Inner_Side
  170     // Left_Sleeve
  150     // Right_Sleeve
);

#local Folded_Head=Head(
  .55
)

#local Woman=union{
  object{
    Draw_Flat_Mesh(Folded_Kimono)
    material{
      texture{uv_mapping pigment{granite color_map{[0 color rgb .5][1 color rgb 1]}scale 1/50}finish{Dull}}
      interior_texture{uv_mapping pigment{granite color_map{[0 color rgb .5][1 color rgb 0]}scale 1/20}finish{Dull}}
    }
  }
  object{
    Draw_Flat_Mesh(Folded_Head)
    material{
      texture{uv_mapping pigment{color rgb .1 scale 1/50}}
      interior_texture{uv_mapping pigment{color rgb .9 scale 1/20}}
    }
  }
}

object{
  Woman
  translate -y*min_extent(Woman).y
  translate -xz*(min_extent(Woman)+max_extent(Woman))/2
  scale 1.3
  rotate y*60
  translate x
}