#version 3.5;

#include "origami.inc"

#macro Kimono(
  PaperSize
  Collar_Ratio
  Sides_Ratio
  Sleeve_Ratio1
  Sleeve_Ratio2
  Sleeve_Ratio3
  Sleeve_Ratio4
  Collar_Angle
  Left_Side
  Right_Side
  Inner_Side
  Left_Sleeve
  Right_Sleeve
)

#local Work=Init_Origami;

// initial points

#local O=Add_Point(Work,0*x,.5,.5,"O");
#local R=Add_Point(Work,PaperSize*(x+y)/2,1,1,"R");
#local C=Add_Point(Work,PaperSize*(x-y)/2,1,0,"C");
#local L=Add_Point(Work,PaperSize*(-(x+y))/2,0,0,"L");

// initial triangles

Add_Triangle(Work,R,C,O)
Add_Triangle(Work,O,C,L)

Split_Edge(Work,"O","C","C1",Collar_Ratio)

Split_Edge(Work,"L","C","L1",Collar_Ratio)
Split_Edge(Work,"R","C","R1",Collar_Ratio)

Split_Angle(Work,"L","O","C","L1","C1","L2",Sides_Ratio)
Split_Angle(Work,"L","O","C","L1","C","L3",Sides_Ratio)

Split_Angle(Work,"R","O","C","R1","C1","R2",Sides_Ratio)
Split_Angle(Work,"R","O","C","R1","C","R3",Sides_Ratio)

Mirror_Edge(Work,"O","L3","C1","L1","O","L","L4")
Mirror_Edge(Work,"O","R3","C1","R1","O","R","R4")

Split_Edge(Work,"L2","L3","L5",Sleeve_Ratio1)
Split_Edge(Work,"R2","R3","R5",Sleeve_Ratio1)

Split_Angle(Work,"C","L5","L3","L3","C","L6",Sleeve_Ratio2)
Split_Angle(Work,"C","R5","R3","R3","C","R6",Sleeve_Ratio2)

Mirror_Edge(Work,"L5","L6","L2","L3","L3","L1","L7")
Mirror_Edge(Work,"R5","R6","R2","R3","R3","R1","R7")

Split_Edge(Work,"L2","L1","L8",Sleeve_Ratio3)
Split_Edge(Work,"R2","R1","R8",Sleeve_Ratio3)

Split_Edge(Work,"L4","L","L9",Sleeve_Ratio4)
Split_Edge(Work,"R4","R","R9",Sleeve_Ratio4)

Mirror_Edge(Work,"L8","L9","L8","L1","L1","L7","L10")
Mirror_Edge(Work,"R8","R9","L8","R1","R1","R7","R10")

#local Origami=Init_Origami;

#local O=Copy_Point(Work,Origami,"O");
#local C=Copy_Point(Work,Origami,"C");
#local C1=Copy_Point(Work,Origami,"C1");
#local R=Copy_Point(Work,Origami,"R");
#local R1=Copy_Point(Work,Origami,"R1");
#local R2=Copy_Point(Work,Origami,"R2");
#local R3=Copy_Point(Work,Origami,"R3");
#local R4=Copy_Point(Work,Origami,"R4");
#local R5=Copy_Point(Work,Origami,"R5");
#local R6=Copy_Point(Work,Origami,"R6");
#local R7=Copy_Point(Work,Origami,"R7");
#local R8=Copy_Point(Work,Origami,"R8");
#local R9=Copy_Point(Work,Origami,"R9");
#local R10=Copy_Point(Work,Origami,"R10");
#local L=Copy_Point(Work,Origami,"L");
#local L1=Copy_Point(Work,Origami,"L1");
#local L2=Copy_Point(Work,Origami,"L2");
#local L3=Copy_Point(Work,Origami,"L3");
#local L4=Copy_Point(Work,Origami,"L4");
#local L5=Copy_Point(Work,Origami,"L5");
#local L6=Copy_Point(Work,Origami,"L6");
#local L7=Copy_Point(Work,Origami,"L7");
#local L8=Copy_Point(Work,Origami,"L8");
#local L9=Copy_Point(Work,Origami,"L9");
#local L10=Copy_Point(Work,Origami,"L10");

Add_Triangle(Origami,L6,L3,L5)
Add_Triangle(Origami,L3,L7,L5)
Add_Triangle(Origami,L10,L1,L8)
Add_Triangle(Origami,L6,L3,L5)
Add_Triangle(Origami,L1,L,L9)
Add_Triangle(Origami,L1,L9,L8)
Add_Triangle(Origami,L7,L10,L8)
Add_Triangle(Origami,L7,L8,L5)
Add_Triangle(Origami,L8,L2,L5)
Add_Triangle(Origami,L8,L9,L4)
Add_Triangle(Origami,L8,L4,L2)
Add_Triangle(Origami,L2,L4,O)
Add_Triangle(Origami,L2,O,C1)
Add_Triangle(Origami,L5,L2,C1)
Add_Triangle(Origami,L5,C1,C)
Add_Triangle(Origami,L5,C,L6)

Add_RTriangle(Origami,R6,R3,R5)
Add_RTriangle(Origami,R3,R7,R5)
Add_RTriangle(Origami,R10,R1,R8)
Add_RTriangle(Origami,R6,R3,R5)
Add_RTriangle(Origami,R1,R,R9)
Add_RTriangle(Origami,R1,R9,R8)
Add_RTriangle(Origami,R7,R10,R8)
Add_RTriangle(Origami,R7,R8,R5)
Add_RTriangle(Origami,R8,R2,R5)
Add_RTriangle(Origami,R8,R9,R4)
Add_RTriangle(Origami,R8,R4,R2)
Add_RTriangle(Origami,R2,R4,O)
Add_RTriangle(Origami,R2,O,C1)
Add_RTriangle(Origami,R5,R2,C1)
Add_RTriangle(Origami,R5,C1,C)
Add_RTriangle(Origami,R5,C,R6)

Around_Edge(Origami,"R1","L1","L",Collar_Angle)
Around_Edge(Origami,"R1","L1","L9",Collar_Angle)
Around_Edge(Origami,"R1","L1","L4",Collar_Angle)
Around_Edge(Origami,"R1","L1","O",Collar_Angle)
Around_Edge(Origami,"R1","L1","R4",Collar_Angle)
Around_Edge(Origami,"R1","L1","R9",Collar_Angle)
Around_Edge(Origami,"R1","L1","R",Collar_Angle)

Around_Edge(Origami,"L8","L9","L",-Inner_Side)
Around_Edge(Origami,"L8","L9","L1",-Inner_Side)
Around_Edge(Origami,"L8","L9","L10",-Inner_Side/2)

Around_Edge(Origami,"R8","R9","R",Inner_Side)
Around_Edge(Origami,"R8","R9","R1",Inner_Side)
Around_Edge(Origami,"R8","R9","R10",Inner_Side/2)

Around_Edge(Origami,"L2","L3","L7",-Left_Side)
Around_Edge(Origami,"L2","L3","L8",-Left_Side)
Around_Edge(Origami,"L2","L3","L9",-Left_Side)
Around_Edge(Origami,"L2","L3","L10",-Left_Side)
Around_Edge(Origami,"L2","L3","L1",-Left_Side)
Around_Edge(Origami,"L2","L3","L",-Left_Side)
Around_Edge(Origami,"L2","L3","L4",-Left_Side/2)

Around_Edge(Origami,"R2","R3","R7",Right_Side)
Around_Edge(Origami,"R2","R3","R8",Right_Side)
Around_Edge(Origami,"R2","R3","R9",Right_Side)
Around_Edge(Origami,"R2","R3","R10",Right_Side)
Around_Edge(Origami,"R2","R3","R1",Right_Side)
Around_Edge(Origami,"R2","R3","R",Right_Side)
Around_Edge(Origami,"R2","R3","R4",Right_Side/2)

Around_Edge(Origami,"L5","L7","L3",-Left_Sleeve)
Around_Edge(Origami,"L5","L7","L6",-Left_Sleeve/2)

Around_Edge(Origami,"R5","R7","R3",Right_Sleeve)
Around_Edge(Origami,"R5","R7","R6",Right_Sleeve/2)

Transform_Origami(Origami,transform{rotate y*180})
Transform_Origami(Origami,transform{rotate z*45})
Transform_Origami(Origami,transform{translate -Get_Point(Origami,C1)})

Origami

#end