#version 3.5;

#include "origami.inc"

#macro Table(
  PaperWidth
  PaperHeight
)

#local W=max(PaperWidth,PaperHeight);
#local H=min(PaperWidth,PaperHeight);

#local Work=Init_Origami;
// initial points

#local C=Add_Point(Work,H*y,W/H,1,"C");
#local C1=Add_Point(Work,H*(x+y)/2,W/H-.5,.5,"C1");
#local Rd=Add_Point(Work,W*x+H*y,0,1,"Rd");
#local R=Add_Point(Work,H*x+H*y,W/H-1,1,"R");
#local O=Add_Point(Work,W*x,0,0,"O");
#local L=Add_Point(Work,0,W/H,0,"L");

Add_Triangle(Work,C1,R,Rd)
Add_Triangle(Work,C1,Rd,O)
Add_Triangle(Work,C1,O,L)
Add_Triangle(Work,C1,L,C)
Add_Triangle(Work,C1,C,R)

Split_Edge(Work,"Rd","O","R1",.5)

Mirror_Edge(Work,"C1","R1","C","C1","L","O","L1")

Split_Edge(Work,"C","R","R2",.5)
Split_Edge(Work,"C","L","L2",.5)

Split_Angle(Work,"R2","C","C1","R2","C1","R3",.5)
Split_Angle(Work,"L2","C","C1","L2","C1","L3",.5)

Split_Angle(Work,"C","R3","R2","C","R2","R4",.5)
Split_Angle(Work,"C","L3","L2","C","L2","L4",.5)

Mirror_Edge(Work,"R3","R4","R3","C","C1","C","C2")

Cross_Edge(Work,"C2","R4","C","R3","R5")
Cross_Edge(Work,"C2","L4","C","L3","L5")

#local Dist=vlength(Get_Point(Work,C)-Get_Point(Work,Find_Point(Work[1],"L5")));

#local First_Angle=179;
#local Second_Angle=179;
#local Third_Angle=179;
#local Fourth_Angle=175;

Around_Edge(Work,"R","L","R2",First_Angle)
Around_Edge(Work,"R","L","R3",First_Angle)
Around_Edge(Work,"R","L","R4",First_Angle)
Around_Edge(Work,"R","L","R5",First_Angle)

Around_Edge(Work,"R","L","L2",First_Angle)
Around_Edge(Work,"R","L","L3",First_Angle)
Around_Edge(Work,"R","L","L4",First_Angle)
Around_Edge(Work,"R","L","L5",First_Angle)

Around_Edge(Work,"R","L","C",First_Angle)
Around_Edge(Work,"R","L","C2",First_Angle)

Around_Edge(Work,"C","R3","R2",Second_Angle)
Around_Edge(Work,"C","R3","R4",Second_Angle)

Around_Edge(Work,"C","L3","L2",-Second_Angle)
Around_Edge(Work,"C","L3","L4",-Second_Angle)

Around_Edge(Work,"R3","R4","R5",-Third_Angle)
Around_Edge(Work,"L3","L4","L5",Third_Angle)

#local Point=Get_Point(Work,Find_Point(Work[1],"R5"));
#local Point=Point+Get_Point(Work,Find_Point(Work[1],"L5"));
#local Point=(Point/2)-Dist*z;
#local UV=Get_UV(Work,C);
#local Work[0][C]=<Point.x,Point.y,Point.z,UV.u,UV.v>;

Around_Edge(Work,"C1","R1","Rd",-Fourth_Angle)
Around_Edge(Work,"C1","R1","R",-Fourth_Angle)
Around_Edge(Work,"C1","R1","R3",-Fourth_Angle/2)

Around_Edge(Work,"C1","L1","L",Fourth_Angle)
Around_Edge(Work,"C1","L1","L3",Fourth_Angle/2)

Transform_Origami(Work,transform{rotate x*90})
Transform_Origami(Work,transform{translate -Get_Point(Work,O)})
Transform_Origami(Work,transform{translate -Get_Point(Work,C).y*y})

Work

#end