studio {
//
//level 4 studs
from 9  -16  24
at   0   0   30
angle 45
//
//check symetry
from -9.5  -980   8
at   -9.5     0   8
angle 1
//
//check lantern
from  -12  -80  5.5
at    -12    0 5.5
angle 45
//
//look from lantern
from  -17  -82  3.9
at    -1   -24  12
angle 45
//
//look at planter
from  -10  -52   5
at    -8  -22    3
angle 45
//
//level 5 gable area
from   7   -31   11
at     9   -28   10
angle 45
//
//level 3 gable area
from   -3   -18  29
at     0    -12   27
angle 45
//
//back view
from  0  100 50
at    0    0 15
angle 45
//
//full view
from  0  -100   1600
at    0   300 100
angle 45
//
//contest view
from  -40  -90 -2
at    -10  -9   18
angle 45
//
//contest view2
from  -38  -80 -2
at    -10  -9   18
angle 45
//
up 0 0 1

aperture .1
focal_length 82

ambient 0 0 0
seed 4
jitter .4
}

call background
call atmospheres
call variable_define

light { type spherical radius 40 samples 4 falloff 0 position 0 0 1200 color .6 .4 .2 }

do 3
	light { type spherical radius rnd 2 4 samples 2 falloff 0 position rnd 0 20 rnd -60 -60 rnd 1 30 color rnd .05 .02 rnd .05 .02 rnd .02 .02 }
end_do
//sun
//light { type spherical radius 2 position 800 1160 170 color 1 .5 0 media }
//light { type spherical radius 1 position 700 1000 160 color 2 1 0 media }
light { type point position 700 1000 160 color 2 1 0 media }

//surface { ambient 1 1 1 }
//sphere { center -220 450 330 radius 20 }

//light { type spot falloff 0 position 0 -40 -10 at -15 -15 5 min_angle 20 max_angle 25 color .5 .5 .1 }
//light { type spot falloff 0  position 170 100 100 at 0 0 15  min_angle 90 max_angle 90 color 4 4 0 }

light { type spherical radius 16 samples 4 falloff 0 position -400 -10 22 color .5 .25 0 }

call copyright
call ground




calc level_1_shingles  ==1
calc level_1_decoration==1
calc level_1_slats     ==1
call level_1
call level_1_walls
call level_1_roofing

calc level_2_shingles  ==1
calc level_2_decoration==1
calc level_2_slats     ==1
call level_2
call level_2_walls
call level_2_roofing

calc level_3_shingles  ==1
calc level_3_decoration==1
call level_3
call level_3_walls
call level_3_roofing
call level_3_gable

calc level_4_shingles  ==1
calc level_4_decoration==1
call level_4
call level_4_walls
call level_4_room
call level_4_roofing
call level_4_gable

calc level_5_shingles  ==1
calc level_5_decoration==1
calc level_5_slats     ==1
call level_5
call level_5_walls
call level_5_roof
call level_5_gable



call lantern_variables
call lantern

call tree_in_planter



transform { translate -120 -70 -90 }
#include castle1.dat
tpop

transform { translate -280 330 -48  rotate 12 0 0 }
#include castle2.dat
tpop 2

transform { translate 0 530 -42  rotate 12 0 0  rotate 0 -20 0 }
#include castle2.dat
tpop 3

transform { translate 164 700 26  rotate 18 0 0  rotate 0 0 90 }
#include castle2.dat
tpop 3


object ground
surface { diff .3 .4 .5 fuzz .2 }
box { center 0 0 -20 top_width 32 width 54 height 40 top_depth 53 depth 79 cone_radius .1 }
end_object


//860 x 600
object copyright
transform { translate -1.8 -31 -2.4 }
surface
{
	diff
	{	image "d:\bmp\iwakuni_copyright.gif"
		position -10 0 1
		across 1 0 0
		normal 0 -1 0
		scale 20
		transparent x00 xff x00
	}
	ambient .5 .2 .1
}
polygon { py 0 vpoints 4  -10 -1   -10 1   10 1   10 -1 }
tpop
end_object



object level_5
//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
#flt level5_width 5.5
#flt level5_height 5.5
end_object
//
object level_5_walls
transform { translate 9.5 -20.5 0 }
outside_wall_color
//red_color
box { center 0 0 2.75 width 11 height 6 depth 11 no_bottom no_top }
white_paint
box { center 0 0 6.125 width 11 height .75 depth 11 no_bottom no_top }
//wall slats
if level_1_slats
	slat_color
	calc rot==0
	do 2
		calc x == -5.42
		transform { rotate 0 0 rot }
		do 10
			//red_color
			box { center x -5.5 2.75 width .15 height 5.75 depth .1 no_bottom no_top no_back }
			calc x += 1.205
		end_do
		calc z==0
		do 9
			//red_color
			box { center 0 -5.5 z width 11 height .1 depth .05 no_left no_right no_back }
			calc z += .7
		end_do
		tpop
		calc rot += 90
	end_do
end_if
tpop
end_object



object level_5_roof
//build eves going right.
calc z1 == 0
calc x == -27.5
calc stepno == 0
do 12
	calc stepno += 1
	transform { rotate 0 0 90 }
	transform { translate x -17 level5_height   rotate roof5_tilt 0 0 }
	if stepno < 12
		white_paint
		box { center .5  1.5  .25 width 1  height .5 depth 3 no_top no_back no_right no_left }
		box { center .15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  1 .7  1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof5_depth 1 roof5_depth  1 0 }
	calc x += 1
	tpop 3
end_do
//build shingles going right.
if level_5_shingles
	calc z1 == 0
	calc x == -27.5
	do 16
		transform { rotate 0 0 90 }
		transform { translate x -17 level5_height   rotate roof5_tilt 0 0 }
		shingle_color
		cone { base 0 shingle_overhang .7 apex 0 roof5_depth .7  radius shingle_radius }
		ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
		tpop 3
		calc x += .71
	end_do
end_if
//build eves on other side.
calc z1 == 0
calc x == 27.5
calc stepno == 0
do 19
	calc stepno += 1
	transform { rotate 0 0 270 }
	transform { translate x 2 level5_height   rotate roof5_tilt 0 0 }
	//if stepno < 12
		white_paint
		box { center -.5  1.5  .25 width 1  height .5 depth 3 no_top no_back no_right no_left }
		box { center -.15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
	//end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  -1 .7  -1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof5_depth -1 roof5_depth  -1 0 }
	calc x -= 1
	tpop 3
end_do
//build shingles.
if level_5_shingles
	calc z1 == 0
	calc x == 27.5
	do 21
		transform { rotate 0 0 270 }
		transform { translate x 2 level5_height   rotate roof5_tilt 0 0 }
		shingle_color
		cone { base 0 shingle_overhang .7 apex 0 roof5_depth .7  radius shingle_radius }
		ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
		tpop 3
		calc x -= .71
	end_do
end_if
//tpop
end_object




object level_5_gable
//move to center of room 5
transform { translate 9.5 -20.5 0 }
red_color
transform { translate 0 -5.5 9.7 }
//sphere { center 0 0 0 radius .1 }
white_paint
polygon { py 0 vpoints 3  0 0  5.9 -3.2  -5.9 -3.2 }
//
transform { rotate 0 roof5_tilt 0 }
transform { translate 4.3 -1.5 -.5 }
box { center 0 0 0 width 8.6 height 1.0 depth .1 no_left }
tpop
transform { translate 4.3 -1.6 -.3 }
box { center 0 0 0 width 8.6 height .5 depth .05 no_left no_back }
tpop
transform { translate 4.3 -1.47 -0.9 }
box { center 0 0 0 width 8.6 height .4 depth .1 no_left no_back }
tpop
transform { translate 4.3 -1.44 -0.99 }
box { center 0 0 0 width 8.6 height .4 depth .1 no_left no_back }
tpop
tpop
//
transform { rotate 0 -roof5_tilt 0 }
transform { translate -4.3 -1.5 -.5 }
box { center 0 0 0 width 8.6 height 1.0 depth .1 no_left }
tpop
transform { translate -4.3 -1.6 -.3 }
box { center 0 0 0 width 8.6 height .5 depth .05 no_left no_back }
tpop
transform { translate -4.3 -1.47 -0.9 }
box { center 0 0 0 width 8.6 height .4 depth .1 no_left no_back }
tpop
transform { translate -4.3 -1.44 -0.99 }
box { center 0 0 0 width 8.6 height .4 depth .1 no_left no_back }
tpop
tpop
tpop

if level_5_decoration
	transform { translate 0 -6.94 8.6 }
	call gable_decoration
	tpop
	//
	transform { translate 0 -7.3 9.6 }
	shingle_color
	//red_color
	call swoop_decoration
	cone { base 0 .3 .2 apex 0 15 .2 radius .3 }
	call gable_swoopie
	tpop
	//
	white_paint
	//red_color
	//
	transform { translate 0 -5.5 6.1 }
	box { center 0 0 0 width 11 height .8 depth .3 no_left no_back }
	transform { translate 0 0 1 }
	calc x == -2.5
	do 3
		box { center x 0 0 width .5 height 2 depth .3 no_left no_back }
		calc x += 2.5
	end_do
	tpop
	//
	box { center -4.9 0 0 width .5 height .5 depth 2.6 no_back }
	box { center  4.9 0 0 width .5 height .5 depth 2.6 no_back }
	//
	tpop
end_if
//
tpop
end_object


















object level_4
//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
#flt level4_width 8.3
#flt level4_height 31
calc roof_swoop_z     == level4_height + 4.45
calc eve_swoop_z      == level4_height - .95
calc roof_tip_swoop_z == level4_height + 0.99
calc roof_swoop_xy     == level4_width - 7.5
calc eve_swoop_xy      == level4_width - 2.57
calc roof_tip_swoop_xy == level4_width + .05
end_object
//
object level_4_walls
transform { translate 0 0 level4_height-7 }
white_paint
box { center 0 0 1.5 width level4_width+2 height 2.2 depth level4_width+2 no_bottom no_top }
box { center 0 0 3   width level4_width+5.4 height .8 depth level4_width+5.4 }

ring { center 0 0 5.2 normal 0 0 -1  radius 1 }
light { type point falloff 1 position 1 .3 4.1 color 1 2 3 }

tpop
end_object

object level_4_room
calc rot == 0
do 4
	transform { rotate 0 0 rot }
	transform { translate 0 -level4_width 0 }
		outside_wall_color
		box { center level4_width-2 2 level4_height-1.7 width 2 height 4.4 depth 2 no_top  cone_radius .1 }
		//side stud
		if level_4_decoration
			white_paint
			//surface { diff 1 0 0 }
			calc x == -4.4
			do 4
				transform { translate x 3 level4_height-4.3 }
					box { center 0 0 0 width .6 height .6 depth 3.5 no_back }
				tpop
				calc x += 2.94
			end_do
			//corner stud
			transform { translate 5.2 3 level4_height-4.3 rotate 0 0 45 }
				box { center 0 0 0 width .6 height .6 depth 4.9 no_back }
			tpop 2
			//window glass
			surface { transparent .9 .9 .9 ior 1.1 spec .2 .2 .2 shine 100 }
			//surface { diff 1 .1 .1 }
			box { center 0 1.6 level4_height-2 width 11 height 4 depth .05 no_top no_bottom no_left no_right }
			//
			surface { diff .1 .1 .1 }
			box { center 0 1.5 level4_height+.3 width 11 height .8 depth .1 no_top no_back no_right no_left }
			calc x==-2
			do 2
				box { center x 1.5 level4_height-2 width .2 height 4.0 depth .1 no_bottom no_top no_back }
				calc x += 4
			end_do
			red_rail_color
			//surface { diff 1 1 0 }
			calc x==-3.2
			do 3
				box { center x 1.51 level4_height-2 width .1 height 4.0 depth .1 no_bottom no_top no_back }
				calc x += 3.2
			end_do
			calc z == level4_height - 3.2
			do 3
				box { center 0 1.51 z width level4_width+2.2 height .1 depth .1 no_left no_right no_back }
				calc z += .6
			end_do
		end_if
	tpop
	tpop
	calc rot += 90
end_do
end_object
//
//
//
//
//
object level_4_roofing
//calc level4_height -= .5
transform { translate 0 -level4_width level4_height  rotate 0 0 0 }
global_clip { clip { center 0 level4_width 0  normal -1 -1 0 } clip { center 0 level4_width 0  normal 1 -1 0 } }
call level4_roof
clip_pop
tpop 2
if level_4_decoration
	transform { translate roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 -45 }
	call roof4_swoop
	tpop 2
	transform { translate eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 -45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 -45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate level4_width 0 level4_height  rotate 0 0 90 }
global_clip { clip { center 0 level4_width 0  normal -1 -1 0 } clip { center 0 level4_width 0  normal 1 -1 0 } }
call level4_roof
clip_pop
tpop 2
if level_4_decoration
	transform { translate roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 45 }
	call roof4_swoop
	tpop 2
	transform { translate eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate 0 level4_width level4_height  rotate 0 0 180 }
global_clip { clip { center 0 level4_width 0  normal -1 -1 0 } clip { center 0 level4_width 0  normal 1 -1 0 } }
call level4_roof
clip_pop
tpop 2
if level_4_decoration
	transform { translate -roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 225 }
	call roof4_swoop
	tpop 2
	transform { translate -eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 225 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 225 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate -level4_width 0 level4_height  rotate 0 0 270   }
global_clip { clip { center 0 level4_width 0  normal -1 -1 0 } clip { center 0 level4_width 0  normal 1 -1 0 } }
call level4_roof
clip_pop
tpop 2
if level_4_decoration
	transform { translate -roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 135 }
	call roof4_swoop
	tpop 2
	transform { translate -eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 135 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 135 }
	call roof_tip_swoop
	tpop 2
end_if

end_object


object level4_roof
//build eves going right.
calc z1 == 0
calc z2 == 0
calc x == -.15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc angle == 0
do 8
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 -rot 0  rotate roof4_tilt 0 0 }
	surface { diff angle angle angle }
	white_paint
	box { center .5  1.5  .25 width 1  height .5 depth 3 no_top no_back no_right no_left }
	if level_4_decoration
		box { center .15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  1 .7  1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof4_depth 1 roof4_depth  1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x += xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .004
	calc zinc2 += zinc3
	calc zinc3 += .004
	//calc dep -= .1
	tpop 3
end_do
//tip of right side
transform { translate x 0 z1  rotate 0 -rot 0  rotate roof4_tilt 0 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  .3 .52  .6 .55  1 .6  .8 .38  .5 .18  .2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  1 .7  1 .6  .6 .55  .3 .52  extrude 1.1 0 1 0}
tpop 3
//
//build shingles going right.
if level_4_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc angle == 0
	do 12
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		transform { rotate roof4_tilt 0 0 }
		cone { base 0 shingle_overhang .7 apex 0 roof4_depth .7  radius shingle_radius }
		ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
		tpop 2
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x += xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0002
		calc zinc2 += zinc3
		calc zinc3 += .0011
	end_do
end_if
//
//going left, start just right of small eve brace.
calc z1 == 0
calc z2 == 0
calc x == .15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc zinc4 == 0
calc angle == 0
calc stepno == 0
do 8
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 rot 0  rotate roof4_tilt 0 0 }
	white_paint
	box { center -.5 1.5 .25 width 1 height .5 depth 3 no_top no_back no_right no_left }
	calc stepno += 1
	if level_4_decoration
		if stepno > 1
			box { center -.15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
		end_if
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  -1 .7  -1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof4_depth  -1 roof4_depth  -1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x -= xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .004
	calc zinc2 += zinc3
	calc zinc3 += .004
	tpop 3
end_do
//tip of left side
transform { translate x 0 z1  rotate roof4_tilt rot 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  -.3 .52  -.6 .55  -1 .6  -.8 .38  -.5 .18  -.2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  -1 .7  -1 .6  -.6 .55  -.3 .52  extrude 1.1 0 1 0 }
tpop 2
//
//build shingles going left.
if level_4_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc zinc4 == 0
	calc angle == 0
	calc stepno == 0
	do 12
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		calc stepno += 1
		if stepno > 1
			transform { rotate roof4_tilt 0 0 }
			cone { base 0 shingle_overhang .7 apex 0 roof4_depth .7  radius shingle_radius }
			ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
			tpop
		end_if
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x -= xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0002
		calc zinc2 += zinc3
		calc zinc3 += .0011
		tpop
	end_do
end_if
end_object



object level_4_gable
//
transform { translate 0 0.85 level4_height+4.8 }
white_paint
global_clip { clip { center 0 0 0 normal 1 0 0 } clip { center 5 0 0 normal -1 0 0 } clip { center 0 0 8 normal 0 0 -1 } }
shingle_color
ring { center 10 -9 8 normal 0 -1 0  min_radius 12.8 max_radius 12.9 }
cone { base   10 -9 8 apex 10 9 8 radius 12.8 }
global_clip { clip { center 0 -9 -3.8 normal 0 -.46 1 } }
if level_4_decoration
	white_paint
	ring { center 10 -9.00 8 normal  0 -1 0 min_radius 12.9 max_radius 13.1 }
	cone { base   10 -9.00 8 apex   10 -1 8 radius 12.9 }
	ring { center 10 -8.90 8 normal  0 -1 0 min_radius 13.1 max_radius 13.2 }
	cone { base   10 -8.90 8 apex   10 -1 8 radius 13.2 }
	ring { center 10 -8.85 8 normal  0 -1 0 min_radius 13.2 max_radius 13.5 }
	cone { base   10 -8.85 8 apex   10 -1 8 radius 13.5 }
	ring { center 10 -8.80 8 normal  0 -1 0 min_radius 13.5 max_radius 13.7 }
	cone { base   10 -8.80 8 apex   10 -1 8 radius 13.7 }
	//ring { center 10 -8.7 8 normal  0 -1 0 min_radius 13.6 max_radius 16 }
end_if
clip_pop
clip_pop

global_clip { clip { center 0 0 0 normal -1 0 0 } clip { center -5 0 0 normal 1 0 0 } clip { center 0 0 8 normal 0 0 -1 } }
shingle_color
ring { center -10 -9 8 normal 0 -1 0  min_radius 12.8 max_radius 12.9 }
cone { base   -10 -9 8 apex -10 9 8 radius 12.8 }
global_clip { clip { center 0 -9 -3.8 normal 0 -.46 1 } }
if level_4_decoration
	white_paint
	ring { center -10 -9.00 8 normal  0 -1 0 min_radius 12.9 max_radius 13.1 }
	cone { base   -10 -9.00 8 apex  -10 -1 8 radius 12.9 }
	ring { center -10 -8.90 8 normal  0 -1 0 min_radius 13.1 max_radius 13.2 }
	cone { base   -10 -8.90 8 apex  -10 -1 8 radius 13.2 }
	ring { center -10 -8.85 8 normal  0 -1 0 min_radius 13.2 max_radius 13.5 }
	cone { base   -10 -8.85 8 apex  -10 -1 8 radius 13.5 }
	ring { center -10 -8.80 8 normal  0 -1 0 min_radius 13.5 max_radius 13.7 }
	cone { base   -10 -8.80 8 apex  -10 -1 8 radius 13.7 }
	//ring { center -9 -8.30 8 normal 0 -1 0 min_radius 13.2 max_radius 15 }
end_if
clip_pop
clip_pop
//
//transform { translate 0 -8.68 -1.2 }
//surface {
//	diff {
//		image "d:\bmp\check.gif"
//		position  -1 0 1
//		across 1 0 0
//		normal 0 -1 0
//		scale .6
//		transparent x00 xff x00
//	}
//}
//polygon { py 0 vpoints 3  0 0  3.5 -2.4 -3.5 -2.4 }
//tpop

surface { diff .3 .3 .32 spec .4 .4 .4 shine 100 1 1 1 }
transform { translate 0 -8.68 -1.2 }
calc x1==-.25
calc y == .2
calc z==-.7
calc rad==.1
calc xstep==.25
calc zinc==.02
do 2
	calc x==x1 * 3
	do 7
		sphere { center x y z radius .1 }
		calc x += xstep
	end_do
	calc z -= xstep
end_do
do 2
	calc x==x1 * 5
	do 11
		sphere { center x y z radius .1 }
		calc x += xstep
	end_do
	calc z -= xstep
end_do
do 2
	calc x==x1 * 8
	do 17
		sphere { center x y z radius .1 }
		calc x += xstep
	end_do
	calc z -= xstep
end_do
do 2
	calc x==x1 * 10
	do 21
		sphere { center x y z radius .1 }
		calc x += xstep
	end_do
	calc z -= xstep
end_do
tpop


//gable shingles
if level_4_shingles
	//right
	transform { translate 10 0 8 }
	red_color
	shingle_color
	calc rot == -26
	do 11
		transform { rotate 0 rot 0 }
		//sphere { center -8.9 -9 -7.9 radius shingle_radius }
		cone { base -9.995 -9+shingle_overhang -7.995 apex -9.995 9 -7.995 radius shingle_radius }
		ring { center -9.995 -9+shingle_overhang -7.995 normal 0 -1 0  radius shingle_radius }
		tpop
		calc rot += 2.6
	end_do
	tpop
	//left
	transform { translate -10 0 8 }
	calc stepno==0
	calc rot == 26
	do 11
		calc stepno += 1
		if stepno < 11
			transform { rotate 0 rot 0 }
			cone { base 9.995 -9+shingle_overhang -7.995 apex 9.995 9 -7.995 radius shingle_radius }
			ring { center 9.995 -9+shingle_overhang -7.995 normal 0 -1 0  radius shingle_radius }
			tpop
		end_if
		calc rot -= 2.6
	end_do
	tpop
end_if
//
//transform { translate 0 0 -.6 }
//shingle_color
//cone { base -.4 0 0 apex .4 0 0 radius .55 }
//sphere { center -.4 0 0 radius .55 }
//sphere { center  .4 0 0 radius .55 }
//tpop
//
//gable decoration
if level_4_decoration
	calc rot==0
	do 1
		transform { rotate 0 0 rot }
		transform { translate 0 -8.75 -1.2 }
		call gable_decoration
		tpop
		//
		transform { translate 0 -9.1 -.1 }
		shingle_color
		call swoop_decoration
		cone { base 0 .2 .2 apex 0 9.2 .2 radius .3 }
		call gable_swoopie
		tpop
		//
		//transform { translate 0 -8.9 -.3  rotate 0 0 -90 }
		//call roof_tip_swoop
		//tpop 2
		//
		transform { translate 0 -7 .4 }
		//ring { center 0 0 0 normal 0 0 -1 radius .7 }
		global_clip { clip { center 0 0 -.4 normal 0 0 1 } }
		calc y == 0
		calc x == 0
		calc z == -.2
		calc rad == .52
		calc xstep == 0
		calc ystep == -.16
		calc zstep == .13
		calc radstep == -.012
		calc stepno==0
		do 20
			calc stepno += 1
			sphere { center x y z radius rad }
			if stepno > 1
				cone { base x y1 z1 apex x y z base_radius rad1 apex_radius rad }
			end_if
			calc y1 == y
			calc z1 == z
			calc rad1 == rad
			calc y += ystep
			calc z += zstep
			calc rad += radstep
			calc ystep += .014
		end_do
		clip_pop
		//
		transform { translate 0 -.53 2.36 rotate -30 0 0 }
		call fish_tail
		tpop 2
		//
		transform { translate -.42 -.36 .52 }
		surface { diff 0 0 0 }
		sphere { center 0 0 0 radius .09 }
		tpop

		tpop
		tpop
		calc rot += 180
	end_do
end_if
//
tpop
end_object














object level_3
//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
#flt level3_width 13.4
#flt level3_height 21
calc roof_swoop_z     == level3_height + 4.2
calc eve_swoop_z      == level3_height - .8
calc roof_tip_swoop_z == level3_height + 1.0
calc roof_swoop_xy     == level3_width - 6.9
calc eve_swoop_xy      == level3_width - 2.5
calc roof_tip_swoop_xy == level3_width
end_object
//
object level_3_walls
transform { translate 0 0 level3_height-7 }
white_paint
box { center 0 0 1 width 19 height 3 depth 19 no_bottom no_top }
//box { center 0 0 5.5 width 22 height 6 depth 22 no_top }
//
calc rot == 0
do 4
	transform { rotate 0 0 rot }
	//
	global_clip {
	clip { base -8 -11 4.2 apex -8 -11 6.2 radius .7 }
	clip { base  8 -11 4.2 apex  8 -11 6.2 radius .7 }
	clip { base -5 -11 3.4 apex -5 -11 4.2 radius .2 }
	clip { base  5 -11 3.4 apex  5 -11 4.2 radius .2 }
	}
	white_paint
	//box { center 0 0 1 width 19 height 3 depth 19 no_bottom no_top no_left no_right no_back }
	box { center 0 0 5.5 width 22 height 6 depth 22 no_top no_left no_right no_back }
	clip_pop
	//
	if level_3_decoration
		transform { translate 0 -11 0 }
		white_paint
		box { center -8 .1 5.2 width 1.4 height 2 depth .2 no_front no_back }
		box { center  8 .1 5.2 width 1.4 height 2 depth .2 no_front no_back }
		surface { diff .3 .3 .3 }
		surface { transparent .8 .5 .4 ior 1.1  spec .12 .12 .12 }
		box { center -8 .2 5.2 width 1.4 height 2 depth .2 no_top no_bottom no_left no_right }
		box { center  8 .2 5.2 width 1.4 height 2 depth .2 no_top no_bottom no_left no_right }
		white_paint
		box { center -5 .2 3.8 width .4 height .8 depth .4 no_front no_back }
		box { center  5 .2 3.8 width .4 height .8 depth .4 no_front no_back }
		surface { diff .3 .3 .3 }
		box { center 0 .3 3.7 width 14 height 1 depth .1 no_back no_left no_right no_top no_bottom }
		//black corners
		//shingle_color
		surface { diff .1 .1 .1 }
		cone { base 11 0 2.5 apex 11 0 7 radius .15 }
		tpop
	end_if
	//
	if level_3_decoration
		//side stud
		white_paint
		//surface { diff 1 0 0 }
		calc x == -9.0
		do 5
			transform { translate x -10.5 -.25 }
			box { center 0 0 2.5 width .5 height .5 depth 1.4 no_back }
			transform { translate 0 .6 1.4 rotate -45 0 0 }
			box { center 0 0 0 width .4 height .4 depth 2.8 no_back }
			tpop 2
			tpop
			calc x += 4.5
		end_do
		//corner stud
		transform { translate 10.3 -10.3 -.25 rotate 0 0 45 }
		box { center 0 0 2.5 width .5 height .5 depth 2.5 no_back }
		transform { translate 0 .6 1.4 rotate -35 0 0 }
		box { center 0 0 0 width .4 height .4 depth 3.5 no_back }
		tpop 2
		tpop 2
	end_if
	tpop
	calc rot += 90
end_do
tpop
//
//grill decoration
if level_3_decoration
	transform { translate 0 -11.05 19.1 }
	surface { diff 1 0 0  spec .2 .2 .2 }
	outside_wall_color
	global_clip { clip { center 0 0 .3 normal 0 0 1 } }
	ring { center 0 -.1 0  normal 0 -1 0  min_radius 1  max_radius 1.2 }
	ring { center 0   0 0  normal 0 -1 0  min_radius 1  max_radius 1.2 }
	cone { base 0 -.1 0 apex 0 0 0  radius 1 }
	cone { base 0 -.1 0 apex 0 0 0  radius 1.2 }
	clip_pop
	//
	box { center  1.058 0 -0.7  width .36 depth .2 top_width .2 height 2.0 no_back no_top no_bottom }
	box { center -1.058 0 -0.7  width .36 depth .2 top_width .2 height 2.0 no_back no_top no_bottom }
	//
	box { center 0 0 -1.65 width 2.4 depth .2 height .1 no_back }
	//
	box { center 0 0 -.3 width .3 depth .1 height 2.7 no_back no_top no_bottom }
	box { center .4 0 -.3 width .15 depth .1 height 2.7 no_back no_top no_bottom }
	box { center .7 0 -.4 width .15 depth .1 height 2.5 no_back no_top no_bottom }
	box { center -.7 0 -.4 width .15 depth .1 height 2.5 no_back no_top no_bottom }
	box { center -.4 0 -.3 width .15 depth .1 height 2.7 no_back no_top no_bottom }
	//
	box { center 0 .1 -.5 width 2.1 depth .16 height .2 no_back no_right no_left }
	//
	//surface { diff 0 1 0 }
	//ring { center 1.055 -.11 .32 normal 0 -1 0 radius .1 }
	//
	tpop
end_if
//
end_object
//
object level_3_roofing
transform { translate 0 -level3_width level3_height  rotate 0 0 0 }
global_clip { clip { center 0 level3_width 0  normal -1 -1 0 } clip { center 0 level3_width 0  normal 1 -1 0 } }
call level3_roof
clip_pop
tpop 2
if level_3_decoration
	transform { translate roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 -45 }
	call roof3_swoop
	tpop 2
	transform { translate eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 -45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 -45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate level3_width 0 level3_height  rotate 0 0 90 }
global_clip { clip { center 0 level3_width 0  normal -1 -1 0 } clip { center 0 level3_width 0  normal 1 -1 0 } }
call level3_roof
clip_pop
tpop 2
if level_3_decoration
	transform { translate roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 45 }
	call roof3_swoop
	tpop 2
	transform { translate eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate 0 level3_width level3_height  rotate 0 0 180 }
global_clip { clip { center 0 level3_width 0  normal -1 -1 0 } clip { center 0 level3_width 0  normal 1 -1 0 } }
call level3_roof
clip_pop
tpop 2
if level_3_decoration
	transform { translate -roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 225 }
	call roof3_swoop
	tpop 2
	transform { translate -eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 225 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 225 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate -level3_width 0 level3_height  rotate 0 0 270   }
global_clip { clip { center 0 level3_width 0  normal -1 -1 0 } clip { center 0 level3_width 0  normal 1 -1 0 } }
call level3_roof
clip_pop
tpop 2
if level_3_decoration
	transform { translate -roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 135 }
	call roof3_swoop
	tpop 2
	transform { translate -eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 135 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 135 }
	call roof_tip_swoop
	tpop 2
end_if
//
shingle_color
box { center 0 0 level3_height+4 width level3_width-.3 depth level3_width-.3 height .27 no_bottom }
//
end_object


object level3_roof
//build eves going right.
calc z1 == 0
calc z2 == 0
calc x == -.15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc angle == 0
do 13
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 -rot 0  rotate roof3_tilt 0 0 }
	surface { diff angle angle angle }
	white_paint
	box { center .5  1.5  .25 width 1  height .5 depth 3 no_top no_back no_right no_left }
	if level_3_decoration
		box { center .15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  1 .7  1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof3_depth 1 roof3_depth  1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x += xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .0007
	calc zinc2 += zinc3
	calc zinc3 += .0005
	//calc dep -= .1
	tpop 3
end_do
//tip of right side
transform { translate x 0 z1  rotate 0 -rot 0  rotate roof3_tilt 0 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  .3 .52  .6 .55  1 .6  .8 .38  .5 .18  .2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  1 .7  1 .6  .6 .55  .3 .52  extrude 1.1 0 1 0}
tpop 3
//
//build shingles going right.
if level_3_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc angle == 0
	do 19
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		transform { rotate roof3_tilt 0 0 }
		cone { base 0 shingle_overhang .7 apex 0 roof3_depth .7  radius shingle_radius }
		ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
		tpop 2
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x += xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0001
		calc zinc2 += zinc3
		calc zinc3 += .00013
	end_do
end_if
//
//going left, start just right of small eve brace.
calc z1 == 0
calc z2 == 0
calc x == .15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc zinc4 == 0
calc angle == 0
calc stepno == 0
do 13
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 rot 0  rotate roof3_tilt 0 0 }
	white_paint
	box { center -.5 1.5 .25 width 1 height .5 depth 3 no_top no_back no_right no_left }
	calc stepno += 1
	if level_3_decoration
		if stepno > 1
			box { center -.15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
		end_if
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  -1 .7  -1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof3_depth  -1 roof3_depth  -1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x -= xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .0007
	calc zinc2 += zinc3
	calc zinc3 += .0005
	tpop 3
end_do
//tip of left side
transform { translate x 0 z1  rotate roof3_tilt rot 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  -.3 .52  -.6 .55  -1 .6  -.8 .38  -.5 .18  -.2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  -1 .7  -1 .6  -.6 .55  -.3 .52  extrude 1.1 0 1 0 }
tpop 2
//
//build shingles going left.
if level_3_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc zinc4 == 0
	calc angle == 0
	calc stepno == 0
	do 19
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		calc stepno += 1
		if stepno > 1
			transform { rotate roof3_tilt 0 0 }
			cone { base 0 shingle_overhang .7 apex 0 roof3_depth .7  radius shingle_radius }
			ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
			tpop
		end_if
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x -= xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0001
		calc zinc2 += zinc3
		calc zinc3 += .00013
		tpop
	end_do
end_if
end_object



object level_3_gable
//
transform { translate 0 -4 level3_height+5 }
white_paint
global_clip { clip { center 0 0 0 normal 1 0 0 } clip { center 6.5 0 0 normal -1 0 0 } clip { center 0 0 8 normal 0 0 -1 } }
shingle_color
ring { center 9 -9 8 normal 0 -1 0  min_radius 12.04 max_radius 12.2 }
cone { base 9 -9 8 apex 9 2 8 radius 12.04 }
global_clip { clip { center 0 -9 -3.8 normal 0 -.46 1 } }
if level_3_decoration
	white_paint
	ring { center 9 -9.00 8 normal 0 -1 0 min_radius 12.2 max_radius 12.5 }
	cone { base   9 -9.00 8 apex   9 -1 8 radius 12.5 }
	ring { center 9 -8.70 8 normal 0 -1 0 min_radius 12.5 max_radius 12.8 }
	cone { base   9 -8.70 8 apex   9 -1 8 radius 12.8 }
	ring { center 9 -8.65 8 normal 0 -1 0 min_radius 12.8 max_radius 13.1 }
	cone { base   9 -8.65 8 apex   9 -1 8 radius 13.1 }
	ring { center 9 -8.60 8 normal 0 -1 0 min_radius 13.1 max_radius 13.2 }
	cone { base   9 -8.60 8 apex   9 -1 8 radius 13.2 }
	ring { center 9 -8.30 8 normal 0 -1 0 min_radius 13.2 max_radius 15 }
end_if
clip_pop
clip_pop

global_clip { clip { center 0 0 0 normal -1 0 0 } clip { center -6.5 0 0 normal 1 0 0 } clip { center 0 0 8 normal 0 0 -1 } }
shingle_color
ring { center -9 -9 8 normal 0 -1 0  min_radius 12.04 max_radius 12.2 }
cone { base -9 -9 8 apex -9 2 8 radius 12.04 }
global_clip { clip { center 0 -9 -3.8 normal 0 -.46 1 } }
if level_3_decoration
	white_paint
	ring { center -9 -9.00 8 normal 0 -1 0 min_radius 12.2 max_radius 12.5 }
	cone { base   -9 -9.00 8 apex  -9 -1 8 radius 12.5 }
	ring { center -9 -8.70 8 normal 0 -1 0 min_radius 12.5 max_radius 12.8 }
	cone { base   -9 -8.70 8 apex  -9 -1 8 radius 12.8 }
	ring { center -9 -8.65 8 normal 0 -1 0 min_radius 12.8 max_radius 13.1 }
	cone { base   -9 -8.65 8 apex  -9 -1 8 radius 13.1 }
	ring { center -9 -8.60 8 normal 0 -1 0 min_radius 13.1 max_radius 13.2 }
	cone { base   -9 -8.60 8 apex  -9 -1 8 radius 13.2 }
	ring { center -9 -8.30 8 normal 0 -1 0 min_radius 13.2 max_radius 15 }
end_if
clip_pop
clip_pop
//
//gable shingles
if level_3_shingles
	//right
	transform { translate 9 0 8 }
	red_color
	shingle_color
	calc rot == -36
	do 13
		transform { rotate 0 rot 0 }
		//sphere { center -8.9 -9 -7.9 radius shingle_radius }
		cone { base -8.995 -9+shingle_overhang -7.995 apex -8.995 2 -7.995 radius shingle_radius }
		ring { center -8.995 -9+shingle_overhang -7.995 normal 0 -1 0  radius shingle_radius }
		tpop
		calc rot += 2.78
	end_do
	tpop
	//left
	transform { translate -9 0 8 }
	calc stepno==0
	calc rot == 36
	do 14
		calc stepno += 1
		if stepno < 14
			transform { rotate 0 rot 0 }
			cone { base 8.995 -9+shingle_overhang -7.995 apex 8.995 2 -7.995 radius shingle_radius }
			ring { center 8.995 -9+shingle_overhang -7.995 normal 0 -1 0  radius shingle_radius }
			tpop
		end_if
		calc rot -= 2.78
	end_do
	tpop
end_if
//
//gable decoration
if level_3_decoration
	transform { translate 0 -8.45 -1.5 }
	call gable_decoration
	tpop
	//
	transform { translate 0 -9.1 -.1 }
	shingle_color
	call swoop_decoration
	cone { base 0 .3 .2 apex 0 11 .2 radius .3 }
	call gable_swoopie
	tpop
	//
	transform { translate 0 -8.9 -.3  rotate 0 0 -90 }
	call roof_tip_swoop
	tpop 2
end_if
//
tpop
end_object










object level_2
//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
#flt level2_width 14.6
#flt level2_height 11.5
calc roof_swoop_z     == level2_height + 3.15
calc eve_swoop_z      == level2_height - .8
calc roof_tip_swoop_z == level2_height + 1.05
calc roof_swoop_xy     == level2_width - 4.6
calc eve_swoop_xy      == level2_width - 2.5
calc roof_tip_swoop_xy == level2_width
end_object
//
object level_2_walls
transform { translate 0 0 level2_height }
outside_wall_color
box { center 0 0 -2.5 width 26 height 5 depth 26 no_bottom no_top }
white_paint
box { center 0 0 .2 width 26.1 height .5 depth 26.1 no_top }
tpop
//
//wall slats
if level_2_slats
	slat_color
	calc rot==0
	do 2
		calc x == -12.925
		transform { rotate 0 0 rot }
		do 22
			//red_color
			transform { translate 0 -13 level2_height-2.5 }
				box { center x 0 0 width .15 height 5 depth .1 no_bottom no_top no_back }
			calc x += 1.232
			tpop
		end_do
		calc z==0
		do 6
			//red_color
			transform { translate 0 -13 level2_height-5 }
				box { center 0 0 z width 26 height .1 depth .05 no_left no_right no_back }
			calc z += .7
			tpop
		end_do
		calc rot += 90
		tpop
	end_do
end_if
//
end_object
//
object level_2_roofing
transform { translate 0 -level2_width level2_height  rotate 0 0 0 }
global_clip { clip { center 0 level2_width 0  normal -1 -1 0 } clip { center 0 level2_width 0  normal 1 -1 0 } }
call level2_roof
clip_pop
tpop 2
if level_2_decoration
	transform { translate roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 -45 }
	call roof2_swoop
	tpop 2
	transform { translate eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 -45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 -45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate level2_width 0 level2_height  rotate 0 0 90 }
global_clip { clip { center 0 level2_width 0  normal -1 -1 0 } clip { center 0 level2_width 0  normal 1 -1 0 } }
call level2_roof
clip_pop
tpop 2
if level_2_decoration
	transform { translate roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 45 }
	call roof2_swoop
	tpop 2
	transform { translate eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate 0 level2_width level2_height  rotate 0 0 180 }
global_clip { clip { center 0 level2_width 0  normal -1 -1 0 } clip { center 0 level2_width 0  normal 1 -1 0 } }
call level2_roof
clip_pop
tpop 2
if level_2_decoration
	transform { translate -roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 225 }
	call roof2_swoop
	tpop 2
	transform { translate -eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 225 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 225 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate -level2_width 0 level2_height  rotate 0 0 270   }
global_clip { clip { center 0 level2_width 0  normal -1 -1 0 } clip { center 0 level2_width 0  normal 1 -1 0 } }
call level2_roof
clip_pop
tpop 2
if level_2_decoration
	transform { translate -roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 135 }
	call roof2_swoop
	tpop 2
	transform { translate -eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 135 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 135 }
	call roof_tip_swoop
	tpop 2
end_if
end_object



object level2_roof
//build eves going right.
calc z1 == 0
calc z2 == 0
calc x == -.15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc angle == 0
do 14
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 -rot 0  rotate roof2_tilt 0 0 }
	surface { diff angle angle angle }
	white_paint
	box { center .5  1.5  .25 width 1  height .5 depth 3 no_top no_back no_right no_left }
	if level_2_decoration
		box { center .15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  1 .7  1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof2_depth 1 roof2_depth  1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x += xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .0005
	calc zinc2 += zinc3
	calc zinc3 += .000322
	//calc dep -= .1
	tpop 3
end_do
//tip of right side
transform { translate x 0 z1  rotate 0 -rot 0  rotate roof2_tilt 0 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  .3 .52  .6 .55  1 .6  .8 .38  .5 .18  .2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  1 .7  1 .6  .6 .55  .3 .52  extrude 1.1 0 1 0}
tpop 3
//
//build shingles going right.
if level_2_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc angle == 0
	do 21
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		transform { rotate roof2_tilt 0 0 }
		cone { base 0 shingle_overhang .7 apex 0 roof2_depth .7  radius shingle_radius }
		ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
		tpop 2
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x += xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0001
		calc zinc2 += zinc3
		calc zinc3 += .000086
	end_do
end_if
//going left, start just right of small eve brace.
calc z1 == 0
calc z2 == 0
calc x == .15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc zinc4 == 0
calc angle == 0
calc stepno == 0
do 14
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 rot 0  rotate roof2_tilt 0 0 }
	white_paint
	box { center -.5 1.5 .25 width 1 height .5 depth 3 no_top no_back no_right no_left }
	calc stepno += 1
	if level_2_decoration
		if stepno > 1
			box { center -.15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
		end_if
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  -1 .7  -1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof2_depth  -1 roof2_depth  -1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x -= xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .0005
	calc zinc2 += zinc3
	calc zinc3 += .000322
	tpop 3
end_do
//tip of left side
transform { translate x 0 z1  rotate roof2_tilt rot 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  -.3 .52  -.6 .55  -1 .6  -.8 .38  -.5 .18  -.2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  -1 .7  -1 .6  -.6 .55  -.3 .52  extrude 1.1 0 1 0 }
tpop 2
//build shingles going left.
if level_2_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc zinc4 == 0
	calc angle == 0
	calc stepno == 0
	do 21
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		calc stepno += 1
		if stepno > 1
			transform { rotate roof2_tilt 0 0 }
			cone { base 0 shingle_overhang .7 apex 0 roof2_depth .7  radius shingle_radius }
			ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
			tpop
		end_if
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x -= xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0001
		calc zinc2 += zinc3
		calc zinc3 += .000086
		tpop
	end_do
end_if
end_object
























object level_1
//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
#flt level1_width 16.5
#flt level1_height 5.5
calc roof_swoop_z     == level1_height + 2.8
calc eve_swoop_z      == level1_height - .8
calc roof_tip_swoop_z == level1_height + 1.05
calc roof_swoop_xy     == level1_width - 3.7
calc eve_swoop_xy      == level1_width - 2.5
calc roof_tip_swoop_xy == level1_width
end_object
//
object level_1_walls
outside_wall_color
box { center 0 0 3.25 width 30 height 6.5 depth 30 no_bottom no_top }
//wall slats
if level_1_slats
	slat_color
	calc rot==0
	do 2
		calc x == -14.92
		transform { rotate 0 0 rot }
		do 26
			//red_color
			box { center x -15 3.25 width .15 height 6.5 depth .1 no_bottom no_top no_back }
			calc x += 1.194
		end_do
		calc z==0
		do 9
			//red_color
			box { center 0 -15 z width 30 height .1 depth .05 no_left no_right no_back }
			calc z += .7
		end_do
		tpop
		calc rot += 90
	end_do
end_if
//white_paint
//box { center 0 0 5.4 width 30 height 1 depth 30 no_bottom no_top }
end_object
//
object level_1_roofing
transform { translate 0 -level1_width level1_height  rotate 0 0 0 }
global_clip { clip { center 0 level1_width 0  normal -1 -1 0 } clip { center 0 level1_width 0  normal 1 -1 0 } }
call level1_roof
clip_pop
tpop 2
if level_1_decoration
	transform { translate roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 -45 }
	call roof1_swoop
	tpop 2
	transform { translate eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 -45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 -45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate level1_width 0 level1_height  rotate 0 0 90 }
global_clip { clip { center 0 level1_width 0  normal -1 -1 0 } clip { center 0 level1_width 0  normal 1 -1 0 } }
call level1_roof
clip_pop
tpop 2
if level_1_decoration
	transform { translate roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 45 }
	call roof1_swoop
	tpop 2
	transform { translate eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 45 }
	call eve_swoop
	tpop 2
	transform { translate roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 45 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate 0 level1_width level1_height  rotate 0 0 180 }
global_clip { clip { center 0 level1_width 0  normal -1 -1 0 } clip { center 0 level1_width 0  normal 1 -1 0 } }
call level1_roof
clip_pop
tpop 2
if level_1_decoration
	transform { translate -roof_swoop_xy -roof_swoop_xy roof_swoop_z  rotate 0 0 225 }
	call roof1_swoop
	tpop 2
	transform { translate -eve_swoop_xy -eve_swoop_xy eve_swoop_z  rotate 0 0 225 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy -roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 225 }
	call roof_tip_swoop
	tpop 2
end_if
//
transform { translate -level1_width 0 level1_height  rotate 0 0 270   }
global_clip { clip { center 0 level1_width 0  normal -1 -1 0 } clip { center 0 level1_width 0  normal 1 -1 0 } }
call level1_roof
clip_pop
tpop 2
if level_1_decoration
	transform { translate -roof_swoop_xy roof_swoop_xy roof_swoop_z  rotate 0 0 135 }
	call roof1_swoop
	tpop 2
	transform { translate -eve_swoop_xy eve_swoop_xy eve_swoop_z  rotate 0 0 135 }
	call eve_swoop
	tpop 2
	transform { translate -roof_tip_swoop_xy roof_tip_swoop_xy roof_tip_swoop_z  rotate 0 0 135 }
	call roof_tip_swoop
	tpop 2
end_if
end_object




object level1_roof
//build eves going right.
calc z1 == 0
calc z2 == 0
calc x == -.15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc angle == 0
do 16
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 -rot 0  rotate roof1_tilt 0 0 }
	surface { diff angle angle angle }
	white_paint
	box { center .5  1.5  .25 width 1  height .5 depth 3 no_top no_back no_right no_left }
	if level_1_decoration
		box { center .15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  1 .7  1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof1_depth  1 roof1_depth  1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x += xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .0005
	calc zinc2 += zinc3
	calc zinc3 += .0002
	tpop 3
end_do
//tip of right side
transform { translate x 0 z1  rotate 0 -rot 0  rotate roof1_tilt 0 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  .3 .52  .6 .55  1 .6  .8 .38  .5 .18  .2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  1 .7  1 .6  .6 .55  .3 .52  extrude 1.1 0 1 0}
tpop 3
//
//build shingles going right.
if level_1_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc angle == 0
	do 24
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		transform { rotate roof1_tilt 0 0 }
		cone { base 0 shingle_overhang .7 apex 0 roof1_depth .7  radius shingle_radius }
		ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
		tpop 2
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x += xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0001
		calc zinc2 += zinc3
		calc zinc3 += .000051
	end_do
end_if
//
//going left, start just right of small eve brace.
calc z1 == 0
calc z2 == 0
calc x == .15
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc angle == 0
calc stepno == 0
do 16
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1  rotate 0 rot 0  rotate roof1_tilt 0 0 }
	white_paint
	box { center -.5 1.5 .25 width 1 height .5 depth 3 no_top no_back no_right no_left }
	calc stepno += 1
	if level_1_decoration
		if stepno > 1
			box { center -.15 1.5 -.15 width .3 height .3 depth 3 no_top no_back }
		end_if
	end_if
	shingle_color
	polygon { py 0 vpoints 4  0 .5  0 .7  -1 .7  -1 .5 }
	polygon { pz .7 vpoints 4  0 0  0 roof1_depth  -1 roof1_depth  -1 0 }
	calc zchange == sin angle
	calc xchange == cos angle
	calc x -= xchange
	calc z1 += zchange
	calc angle += zinc2
	calc angle += .0005
	calc zinc2 += zinc3
	calc zinc3 += .0002
	tpop 3
end_do
//tip of left side
transform { translate x 0 z1  rotate roof1_tilt rot 0 }
white_paint
polygon { py 0 vpoints 8   0 0  0 .5  -.3 .52  -.6 .55  -1 .6  -.8 .38  -.5 .18  -.2 .05   extrude .2 0 1 0}
shingle_color
polygon { py 0 vpoints 6  0 .5  0 .7  -1 .7  -1 .6  -.6 .55  -.3 .52  extrude 1.1 0 1 0 }
tpop 2
//
//build shingles going left.
if level_1_shingles
	calc z1 == 0
	calc z2 == 0
	calc x == 0
	calc zinc  == 0
	calc zinc2 == 0
	calc zinc3 == 0
	calc angle == 0
	calc stepno == 0
	do 24
		calc rot == angle
		calc rot /= 3.14159
		calc rot *= 180
		transform { translate x 0 z1 }
		shingle_color
		calc stepno += 1
		if stepno > 1
			transform { rotate roof1_tilt 0 0 }
			cone { base 0 shingle_overhang .7 apex 0 roof1_depth .7  radius shingle_radius }
			ring { center 0 shingle_overhang .7  normal 0 -1 0 radius shingle_radius }
			tpop
		end_if
		calc zchange == sin angle
		calc xchange == cos angle
		calc xchange *= .71
		calc x -= xchange
		calc z1 += zchange
		calc angle += zinc2
		calc angle += .0001
		calc zinc2 += zinc3
		calc zinc3 += .000051
		tpop
	end_do
end_if
end_object





object roof1_swoop
shingle_color
calc rad1 == .16
calc rad2 == .16
calc x1 == 0
calc x2 == 0
calc xstep == .265
calc z1 == 0
calc z2 == 0
calc zstep == -.08
calc zinc  == 0
do 20
	calc z1 == z2
	calc z2 += zstep
	calc rad1 == rad2
	calc rad2 += .0022
	calc x1 == x2
	calc x2 += xstep
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	calc zstep += zinc
	calc zinc += .00025
end_do
transform { translate x2 0 z2-.3 rotate 0 10 0 rotate 0 0 90 }
call swoop_decoration
tpop 3
//top swoopie
calc rad1 == .01
calc rad2 == .01
calc x1 == 4.6
calc x2 == 4.6
calc z1 == -1
calc z2 == -1
calc xstep == .134
calc zstep == -.03
calc radstep == .0127
shingle_color
calc stepno == 0
do 9
	calc stepno += 1
	calc x2 += xstep
	calc z2 += zstep
	calc rad2 += radstep
	if stepno = 9
		global_clip { clip { center x2-0.07 0 z1 normal -1 0 0 } }
	end_if
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	if stepno = 9
		clip_pop
		global_clip { clip { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 inside } }
		ring { center x2-.07 0 z1 normal -1 0 0 radius 1 }
	clip_pop
	end_if
	calc x1 == x2
	calc z1 == z2
	calc rad1 == rad2
	calc zstep += .016
end_do
end_object






object roof2_swoop
shingle_color
calc rad1 == .16
calc rad2 == .16
calc x1 == 0
calc x2 == 0
calc xstep == .326
calc z1 == 0
calc z2 == 0
calc zstep == -.11
calc zinc  == 0
do 20
	calc z1 == z2
	calc z2 += zstep
	calc rad1 == rad2
	calc rad2 += .0022
	calc x1 == x2
	calc x2 += xstep
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	calc zstep += zinc
	calc zinc += .00045
end_do
transform { translate x2 0 z2-.3 rotate 0 10 0 rotate 0 0 90 }
call swoop_decoration
tpop 3
//top swoopie
calc rad1 == .01
calc rad2 == .01
calc x1 == 5.8
calc x2 == 5.8
calc z1 == -1.4
calc z2 == -1.4
calc xstep == .134
calc zstep == -.027
calc radstep == .0127
shingle_color
calc stepno == 0
do 9
	calc stepno += 1
	calc x2 += xstep
	calc z2 += zstep
	calc rad2 += radstep
	if stepno = 9
		global_clip { clip { center x2-0.07 0 z1 normal -1 0 0 } }
	end_if
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	if stepno = 9
		clip_pop
		global_clip { clip { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 inside } }
		ring { center x2-.07 0 z1 normal -1 0 0 radius 1 }
	clip_pop
	end_if
	calc x1 == x2
	calc z1 == z2
	calc rad1 == rad2
	calc zstep += .016
end_do
end_object





object roof3_swoop
shingle_color
calc rad1 == .16
calc rad2 == .16
calc x1 == 0
calc x2 == 0
calc xstep == .322
calc z1 == 0
calc z2 == 0
calc zstep == -.11
calc zinc  == 0
do 30
	calc z1 == z2
	calc z2 += zstep
	calc rad1 == rad2
	calc rad2 += .0022
	calc x1 == x2
	calc x2 += xstep
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	calc zstep += zinc
	calc zinc += .000135
end_do
transform { translate x2 0 z2-.3 rotate 0 10 0 rotate 0 0 90 }
call swoop_decoration
tpop 3
//top swoopie
calc rad1 == .01
calc rad2 == .01
calc x1 == 9.1
calc x2 == 9.1
calc z1 == -2.4
calc z2 == -2.4
calc xstep == .134
calc zstep == -.027
calc radstep == .0127
shingle_color
calc stepno == 0
do 9
	calc stepno += 1
	calc x2 += xstep
	calc z2 += zstep
	calc rad2 += radstep
	if stepno = 9
		global_clip { clip { center x2-0.07 0 z1 normal -1 0 0 } }
	end_if
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	if stepno = 9
		clip_pop
		global_clip { clip { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 inside } }
		ring { center x2-.07 0 z1 normal -1 0 0 radius 1 }
	clip_pop
	end_if
	calc x1 == x2
	calc z1 == z2
	calc rad1 == rad2
	calc zstep += .016
end_do
end_object






object roof4_swoop
shingle_color
calc rad1 == .16
calc rad2 == .16
calc x1 == -1
calc x2 == -1
calc xstep == .394
calc z1 == .2
calc z2 == .2
calc zstep == -.13
calc zinc  == 0
do 30
	calc z1 == z2
	calc z2 += zstep
	calc rad1 == rad2
	calc rad2 += .0012
	calc x1 == x2
	calc x2 += xstep
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	calc zstep += zinc
	calc zinc += .00018
end_do
transform { translate x2 0 z2-.3 rotate 0 10 0 rotate 0 0 90 }
call swoop_decoration
tpop 3
//top swoopie
calc rad1 == .01
calc rad2 == .01
calc x1 == 10.3
calc x2 == 10.3
calc z1 == -2.67
calc z2 == -2.67
calc xstep == .134
calc zstep == -.027
calc radstep == .0127
shingle_color
calc stepno == 0
do 9
	calc stepno += 1
	calc x2 += xstep
	calc z2 += zstep
	calc rad2 += radstep
	if stepno = 9
		global_clip { clip { center x2-0.07 0 z1 normal -1 0 0 } }
	end_if
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	if stepno = 9
		clip_pop
		global_clip { clip { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 inside } }
		ring { center x2-.07 0 z1 normal -1 0 0 radius 1 }
	clip_pop
	end_if
	calc x1 == x2
	calc z1 == z2
	calc rad1 == rad2
	calc zstep += .016
end_do
end_object






object eve_swoop
calc x == 0
calc z1 == 1
calc z2 == 0
calc zinc  == 0
calc zinc2 == 0
calc zinc3 == 0
calc angle == 0
calc wid == .35
transform { rotate 0 6 0 }
do 11
	calc rot == angle
	calc rot /= 3.14159
	calc rot *= 180
	transform { translate x 0 z1   rotate 0 -rot 0   }
	white_paint
	//sphere { center 0 -wid 0 radius .05 }
	//surface { diff rnd 0 1 rnd 0 1 rnd 0 1 }
	box { center wid/2 0 wid width wid depth .4 height .4 no_left }
	tpop
	tpop
	calc zchange == sin angle
	calc zchange *= wid
	calc xchange == cos angle
	calc xchange *= wid
	calc x += xchange
	calc z1 += zchange
	calc angle += .02
end_do
tpop
transform { translate x 0 z1-.02 rotate 0 27 0 }
//surface { diff rnd 0 1 rnd 0 1 rnd 0 1 }
box { center 0 0 0 width .4 depth .4 height .3 no_top }
surface { diff .1 .1 .1 spec .1 .1 .1 shine 40 }
box { center 0 0 .15 width .45 depth .45 height .06  cone_radius .03 no_bottom }
tpop
tpop
end_object


object roof_tip_swoop
//surface { diff 1 0 0 }
shingle_color
transform { rotate 0 -14 0 }
global_clip { clip { center .68 0 0 normal -1 0 1.3 } }
cone { base 0 0 0 apex 1.4 0 0 base_radius .1 apex_radius .2 }
clip_pop
global_clip { clip { base 0 0 0 apex 1.4 0 0 base_radius .1 apex_radius .2 inside } }
ring { center .68 0 0 normal -1 0 1.3 radius 1 }
clip_pop
tpop
end_object


object gable_decoration
white_paint
polygon { py 0 vpoints 13  .4 0  .4 -.8  .45 -1.05  .2 -1  .1 -1.05  .05 -1.1  0 -1.2  -.05 -1.1  -.1 -1.05  -.2 -1  -.45 -1.05  -.4 -.8  -.4 0 extrude .2 0 1 0}
surface { diff .1 .1 .1 spec .4 .4 .4 }
sphere { center 0 0 -.675 radius .16 }
end_object


object swoop_decoration
polygon { py 0 vpoints 34
0     0
-.3   0
-.4  .02
-.45 .1
-.45 .25
-.4  .175
-.35 .15
-.3  .175
-.3  .4
-.25 .5
-.2  .55
-.1  .6
0    .575
.1  .6
.2  .55
.25 .5
.3  .4
.3  .175
.35 .15
.4  .175
.45 .25
.45 .1
.4  .02
.3   0
0 0
0 .1
.1414 .1586
.2 .3
.1414 .4414
0 .5
-.1414 .4414
-.2 .3
-.1414 .1586
0 .1
extrude .125 0 1 0 }
ring { center 0 .08 .3  normal 0 -1 0  radius .2 }
//surface { diff 1 0 0 }
sphere { center 0 0 .3 radius .055 }
calc rot==0
do 8
	transform { translate 0 0 .3 rotate 0 rot 0 }
	//sphere { center 0 .02 .12 radius .04 }
	ring { center 0 -.03 .12 normal 0 -1 0 radius .035 }
	cone { base 0 -.03 .12 apex 0 .1 .12 radius .035 }
	tpop 2
	calc rot += 45
end_do
end_object


object gable_swoopie
transform { rotate 0 0 270 }
calc rad1 == .01
calc rad2 == .01
calc x1 == -.96
calc x2 == -.96
calc z1 == .51
calc z2 == .51
calc xstep == .16
calc zstep == 0
calc radstep == .0115
shingle_color
calc stepno == 0
do 9
	calc stepno += 1
	calc x2 += xstep
	calc z2 += zstep
	calc rad2 += radstep
	if stepno = 9
		global_clip { clip { center x2-0.05 0 z1 normal -1 0 0 } }
	end_if
	cone { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 }
	if stepno = 9
		clip_pop
		global_clip { clip { base x1 0 z1 apex x2 0 z2 base_radius rad1 apex_radius rad2 inside } }
		ring { center x2-.05 0 z1 normal -1 0 0 radius .5 }
		clip_pop
	end_if
	calc x1 == x2
	calc z1 == z2
	calc rad1 == rad2
	calc zstep += .01
end_do
tpop
end_object




object fish_tail
transform { translate 0 -1.05 0 }
	global_clip { clip { base -1 1.1 -2 apex 1 1.1 -2 radius 3.01 inside } }
	global_clip { 	clip { center 0 0 0 normal 0 0 1 } clip { center 0 -.1 0 normal 0 1 0 } }
	transform { rotate 0 90 0 }
		poly_torus { center 0 0 0 radius .8 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
		poly_torus { center 0 0 0 radius .9 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
		poly_torus { center 0 0 0 radius 1 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
		poly_torus { center 0 0 0 radius 1.1 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
		poly_torus { center 0 0 0 radius 1.2 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
	tpop
	clip_pop
tpop
transform { translate 0 1.05 0 }
	global_clip { 	clip { center 0 0 0 normal 0 0 1 } clip { center 0 .1 0 normal 0 -1 0 } }
	transform { rotate 0 90 0 }
		poly_torus { center 0 0 0 radius .9 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
		poly_torus { center 0 0 0 radius 1 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
		poly_torus { center 0 0 0 radius 1.1 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
		poly_torus { center 0 0 0 radius 1.2 tube_radius .06 density 4 tube_start 45 tube_density 4 rings }
	tpop
	clip_pop
	clip_pop
tpop
end_object


object background
//
background { "sky.map" percent 1.0 }
//background {
//panorama { image "d:\bmp\landscape\sun1.jpg" }
//light .8 .8 .8
//radius 200
//percent 0.8
//}

/*
transform { scale 120 }
surface {
	texture {
		pattern noise
		terms 2
		blend .1
		scale 20 20 1
		surf { diff 1 1 1 }
		surf { transparent 1 1 1 }
	}
}
tpop
//surface { diff 1 1 0 }
ring { center 0 0 1000 normal 0 0 -1  radius 950000 }
ring { center 0 0 1001 normal 0 0 -1  radius 950000 }
*/

//surface {
//	texture {
//		pattern noise
//		terms 2
//		blend .1
//		scale 2 2 1
//		surf { diff .7 .7. 7 }
//		surf { transparent 1 1 1 }
//	}
//}
//surface { transparent 1 1 1 }
//ring { center -16 -32 0 normal 0 -1 0 radius 10 }
//ring { center -16 -30 0 normal 0 -1 0 radius 10 }


end_object


object atmospheres
haze
{
	start 100
	density .0015
	//color .5 .5 .2
	//min -200 -24 -200
	//max 200 40 200
}
media
{
	density .08
	step 5
	min -1140 -1140 -100
	max  1140  1140 200
	//min -2000 -1120  10
	//max  2000  1140 200
	media_maxlevel 3
	variance 0.1
}
//radios
//{
//	cell_size 1
//	density 0.1
//	density 0.2
//	density 0.8
//	shadows
//	distance .1
//	radios_min_light 0.001
//	max_cells 4000
//}
end_object




object lantern
transform { translate -3 -21 0  scale .6 }
surf {
	texture {
		pattern noise
		scale .1 .1 .1
		terms 2
		surf { diff .6 .6 .4 }
		surf { diff .8 .8 .6 }
	}
	bump
	{
		scale .01 .01 .01
		//translate 0 0 0
		turbulence
		{
			scale .01 .01 .01
			//translate 0 0 0
			amplitude .91
			terms 1
		}
	}
}
//
transform { translate 0 0 5 }
calc cube_width == 1.0
calc cube_legwidth == .14
call cube
calc cube_width == .75
calc cube_legwidth == .22
call cube
//
calc dep1==1.96
calc dep2==1.96
calc z==.45
calc zinc==.01
calc stepno==0
//box { center 0 0 .50  width 1.76 depth 1.76 height .05 }
do 16
	calc dep1 == dep2
	calc dep2 -= zinc
	calc zinc += .012
	if stepno = 0
		box { center 0 0 z width dep1 depth dep1 top_width dep2 top_depth dep2 height .025 no_top }
	end_if
	if stepno > 0
		box { center 0 0 z width dep1 depth dep1 top_width dep2 top_depth dep2 height .025 no_bottom no_top }
	end_if
	calc z += .025
end_do
box { center 0 0 .9 width .4 depth .4 height .1  cone_radius .05 }
//
box { center 0 0 -0.62 width 1.35 depth 1.35 height .2 cone_radius .03 }
cone { base 0 0 -1 apex 0 0 -.5 radius .45 }
box { center 0 0 -1.05 width 1.25 depth 1.25 height .3 cone_radius .02 }
tpop
//
global_clip { clip { center 0 0 0  normal 0 0 1 } clip { center 0 0 4  normal 0 0 -1 } clip { center 0 0 0  normal 1 0 0 } }
ring { center -6.7 -.35 -2  normal 0 -1 0  min_radius 9.1  max_radius 9.4 }
ring { center -6.7  .35 -2  normal 0 -1 0  min_radius 9.1  max_radius 9.4 }
cone { base -6.7 -.35 -2 apex -6.7  .35 -2 radius 9.1 }
cone { base -6.7 -.35 -2 apex -6.7  .35 -2 radius 9.4 }
clip_pop
global_clip { clip { center 0 0 0  normal 0 0 1 } clip { center 0 0 4  normal 0 0 -1 } clip { center 0 0 0  normal -1 0 0 } }
ring { center  6.7 -.35 -2  normal 0 -1 0  min_radius 9.1  max_radius 9.4 }
ring { center  6.7  .35 -2  normal 0 -1 0  min_radius 9.1  max_radius 9.4 }
cone { base  6.7 -.35 -2 apex  6.7  .35 -2 radius 9.1 }
cone { base  6.7 -.35 -2 apex  6.7  .35 -2 radius 9.4 }
clip_pop
tpop 2
end_object


object lantern_variables
//#flt z 0
#flt dep1 1.76
#flt dep2 1.76
//#flt zinc
#flt cube_width 1.0
#flt cube_dist 0
#flt cube_left 0
#flt cube_right 0
#flt cube_top 0
#flt cube_bottom 0
#flt cube_front 0
#flt cube_back 0
#flt cube_legwidth .1
#flt cube_lw_div2 0
end_object


object cube
	calc cube_dist 0
	calc cube_left 0
	calc cube_right 0
	calc cube_top 0
	calc cube_bottom 0
	calc cube_front 0
	calc cube_back 0
	calc cube_legwidth .1
	calc cube_lw_div2 0
	//
	calc cube_dist == cube_width
	calc cube_dist /= 2
	//
	calc cube_left == cube_dist
	calc cube_right == cube_dist
	calc cube_top == cube_dist
	calc cube_bottom == cube_dist
	calc cube_front == cube_dist
	calc cube_back == cube_dist
	//
	calc cube_left *= -1
	calc cube_bottom *= -1
	calc cube_front *= -1
	//
	calc cube_lw_div2 == cube_legwidth
	calc cube_lw_div2 /= 2
	calc cube_left += cube_lw_div2
	calc cube_right -= cube_lw_div2
	calc cube_top -= cube_lw_div2
	calc cube_bottom += cube_lw_div2
	calc cube_back -= cube_lw_div2
	calc cube_front += cube_lw_div2
	//right front
	box { center cube_right cube_front 0 width cube_legwidth height cube_width depth cube_legwidth cone_radius .01 }
	//right back
	box { center cube_right cube_back 0 width cube_legwidth height cube_width depth cube_legwidth cone_radius .01 }
	//left front
	box { center cube_left cube_front 0 width cube_legwidth height cube_width depth cube_legwidth cone_radius .01 }
	//left back
	box { center cube_left cube_back 0 width cube_legwidth height cube_width depth cube_legwidth cone_radius .01 }
	//top front
	box { center 0 cube_front cube_top width cube_width height cube_legwidth depth cube_legwidth cone_radius .01 }
	//top back
	box { center 0 cube_back cube_top width cube_width height cube_legwidth depth cube_legwidth cone_radius .01 }
	//bottom front
	box { center 0 cube_front cube_bottom width cube_width height cube_legwidth depth cube_legwidth cone_radius .01 }
	//bottom back
	box { center 0 cube_back cube_bottom width cube_width height cube_legwidth depth cube_legwidth cone_radius .01 }
	//right bottom
	box { center cube_right 0 cube_bottom width cube_legwidth height cube_legwidth depth cube_width cone_radius .01 }
	//left bottom
	box { center cube_left 0 cube_bottom width cube_legwidth height cube_legwidth depth cube_width cone_radius .01 }
	//right top
	box { center cube_right 0 cube_top width cube_legwidth height cube_legwidth depth cube_width cone_radius .01 }
	//left top
	box { center cube_left 0 cube_top width cube_legwidth height cube_legwidth depth cube_width cone_radius .01 }
	//
end_object





object tree_in_planter
transform { translate -10 -21 0  scale .65 }
//surface { diff .4 .4 .3 }
surf {
	texture {
		pattern noise
		scale .1 .1 .1
		terms 2
		surf { diff .4 .4 .3 }
		surf { diff .2 .2 .1 }
	}
	bump
	{
		scale .1 .1 .1
		//translate 0 0 0
		turbulence
		{
			scale .1 .1 .1
			//translate 0 0 0
			amplitude .5
			terms 2
		}
	}
}
ring { center 0 0 .05  normal 0 0 1  radius 5 }
//
//surface { diff .7 .7 .6 }
surf {
	texture {
		pattern noise
		scale .04 .04 .04
		terms 2
		surf { diff .4 .4 .3 }
		surf { diff .6 .6 .5 }
	}
}
//
calc angle==0
do 20
	transform { rotate 0 0 angle translate rnd 4.95 .1 0 .2 rotate 0 rnd 87 6 0 }
	//box { center 0 0 0  width .5  depth 1.5  height .4 }
	box { center 0 0 0  width .4  depth 1.4  top_depth 1.55  height .5 }
	tpop 3
	calc angle += 18
end_do
//
calc angle==12
do 20
	transform { rotate 0 0 angle translate rnd 4.95 .1 0 .6 rotate 0 rnd 87 6 0 }
	//box { center 0 0 0  width .5  depth 1.5  height .4 }
	box { center 0 0 0  width .4  depth 1.4  top_depth 1.55  height .5 }
	tpop 3
	calc angle += 18
end_do
//
calc angle==6
do 20
	transform { rotate 0 0 angle translate rnd 4.95 .1 0 1.0 rotate 0 rnd 87 6 0 }
	//box { center 0 0 0  width .5  depth 1.5  height .4 }
	box { center 0 0 0  width .4  depth 1.4  top_depth 1.55  height .5 }
	tpop 3
	calc angle += 18
end_do
//
//ring { center 0 0 .5  normal 0 0 1  min_radius 5 max_radius 5.5 }
//cone { base 0 0 .05  apex 0 0 .5 radius 5 }
//cone { base 0 0 -1  apex 0 0 .5 radius 5.5 }
#include tree1.dat
tpop 2
end_object









object variable_define
#define roof_color surface { diff .2 .22 .23 spec .05 .05 .05 }
#define shingle_color surface { diff .25 .25 .26  spec .1 .1 .1  shine 100 .7 .7 .8  fuzz .1 }
#define red_color surface { diff 1 0 0 }
#define white_paint surface { diff .95 .95 .95 spec .01 .01 .01  shine 100  fuzz .01 }
#define red_rail_color surface { diff .8 .1 .1 spec .2 .2 .2  shine 100 }
#define outside_wall_color surface { diff .1 .1 .1 spec .05 .05 .05 shine 200 fuzz .03 }
#define slat_color surface { diff .05 .05 .05 spec .1 .1 .1 shine 100 fuzz .01 }
#flt shingle_overhang -.1
#flt shingle_radius .14
#flt roof1_depth 4.5
#flt roof2_depth 5.5
#flt roof3_depth 8
#flt roof4_depth 8.5
#flt roof5_depth 8.5
#flt roof1_tilt 25
#flt roof2_tilt 25
#flt roof3_tilt 25
#flt roof4_tilt 25
#flt roof5_tilt 25
#flt x 0
#flt y 0
#flt z 0
#flt z1 0
#flt z2 0
#flt y1 0
#flt y2 0
#flt x1 0
#flt x2 0
#flt rad 0
#flt radstep 0
#flt xstep 0
#flt ystep 0
#flt zstep 0
#flt zinc 0
#flt zinc2 0
#flt zinc3 0
#flt zinc4 0
#flt angle 0
#flt zchange
#flt xchange
#flt rot
#flt rad1
#flt rad2
#flt stepno 0
#flt savez 0
#flt savex 0
#flt wid 0
#flt roof_swoop_z 0
#flt eve_swoop_z 0
#flt roof_tip_swoop_z 0
#flt roof_swoop_xy 0
#flt eve_swoop_xy 0
#flt roof_tip_swoop_xy 0
#flt level_1_shingles 0
#flt level_2_shingles 0
#flt level_3_shingles 0
#flt level_4_shingles 0
#flt level_5_shingles 0
#flt level_1_decoration 0
#flt level_2_decoration 0
#flt level_3_decoration 0
#flt level_4_decoration 0
#flt level_5_decoration 0
#flt level_1_slats 0
#flt level_2_slats 0
#flt level_5_slats 0
end_object





















