
/*
camera{
	location < -3.341, 2.249, -3.195 >
	look_at < 0.121, 1.817, 0.267 >
	angle 40.000
}

background{ rgb <0/255,0/255,0/255> }


light_source{<100,100,-100> rgb 1}
light_source{<0,10,-1000> rgb 1}


global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}
}
*/ 


#declare bird=
union{
//patch_obj_00
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.196, 1.849, 0.057> <-0.179, 1.884, 0.043> <-0.177, 1.946, 0.042> <-0.140, 1.967, 0.010> 
		<-0.196, 1.849, 0.057> <-0.170, 1.898, 0.005> <-0.205, 1.946, 0.008> <-0.167, 1.967, -0.023> 
		<-0.196, 1.849, 0.057> <-0.170, 1.898, 0.005> <-0.218, 1.912, -0.029> <-0.180, 1.933, -0.061> 
		<-0.196, 1.849, 0.057> <-0.187, 1.862, 0.019> <-0.205, 1.873, -0.040> <-0.167, 1.893, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.196, 1.849, 0.057> <-0.179, 1.884, 0.043> <-0.177, 1.946, 0.042> <-0.140, 1.967, 0.010> 
		<-0.196, 1.849, 0.057> <-0.140, 1.898, 0.041> <-0.149, 1.946, 0.075> <-0.112, 1.967, 0.043> 
		<-0.196, 1.849, 0.057> <-0.140, 1.898, 0.041> <-0.115, 1.912, 0.094> <-0.077, 1.933, 0.062> 
		<-0.196, 1.849, 0.057> <-0.157, 1.862, 0.056> <-0.102, 1.873, 0.083> <-0.064, 1.893, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 1.967, 0.010> <-0.109, 1.984, -0.016> <-0.072, 1.964, -0.047> <-0.059, 1.925, -0.057> 
		<-0.140, 1.967, 0.010> <-0.081, 1.984, 0.018> <-0.044, 1.964, -0.013> <-0.032, 1.925, -0.024> 
		<-0.140, 1.967, 0.010> <-0.081, 1.984, 0.018> <-0.047, 1.950, 0.036> <-0.034, 1.910, 0.026> 
		<-0.140, 1.967, 0.010> <-0.112, 1.967, 0.043> <-0.077, 1.933, 0.062> <-0.064, 1.893, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 1.967, 0.010> <-0.109, 1.984, -0.016> <-0.072, 1.964, -0.047> <-0.059, 1.925, -0.057> 
		<-0.140, 1.967, 0.010> <-0.137, 1.984, -0.049> <-0.100, 1.964, -0.080> <-0.087, 1.925, -0.091> 
		<-0.140, 1.967, 0.010> <-0.137, 1.984, -0.049> <-0.150, 1.950, -0.086> <-0.137, 1.910, -0.097> 
		<-0.140, 1.967, 0.010> <-0.167, 1.967, -0.023> <-0.180, 1.933, -0.061> <-0.167, 1.893, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.059, 1.925, -0.057> <-0.046, 1.885, -0.068> <-0.061, 1.837, -0.056> <-0.092, 1.820, -0.030> 
		<-0.059, 1.925, -0.057> <-0.019, 1.885, -0.035> <-0.033, 1.837, -0.023> <-0.064, 1.820, 0.003> 
		<-0.059, 1.925, -0.057> <-0.019, 1.885, -0.035> <-0.021, 1.870, 0.015> <-0.051, 1.854, 0.040> 
		<-0.059, 1.925, -0.057> <-0.032, 1.925, -0.024> <-0.034, 1.910, 0.026> <-0.064, 1.893, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.059, 1.925, -0.057> <-0.046, 1.885, -0.068> <-0.061, 1.837, -0.056> <-0.092, 1.820, -0.030> 
		<-0.059, 1.925, -0.057> <-0.074, 1.885, -0.101> <-0.089, 1.837, -0.089> <-0.120, 1.820, -0.063> 
		<-0.059, 1.925, -0.057> <-0.074, 1.885, -0.101> <-0.124, 1.870, -0.108> <-0.154, 1.854, -0.082> 
		<-0.059, 1.925, -0.057> <-0.087, 1.925, -0.091> <-0.137, 1.910, -0.097> <-0.167, 1.893, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.092, 1.820, -0.030> <-0.129, 1.799, 0.001> <-0.165, 1.840, 0.031> <-0.196, 1.849, 0.057> 
		<-0.092, 1.820, -0.030> <-0.157, 1.799, -0.032> <-0.156, 1.853, -0.007> <-0.187, 1.862, 0.019> 
		<-0.092, 1.820, -0.030> <-0.157, 1.799, -0.032> <-0.192, 1.833, -0.051> <-0.205, 1.873, -0.040> 
		<-0.092, 1.820, -0.030> <-0.120, 1.820, -0.063> <-0.154, 1.854, -0.082> <-0.167, 1.893, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.092, 1.820, -0.030> <-0.129, 1.799, 0.001> <-0.165, 1.840, 0.031> <-0.196, 1.849, 0.057> 
		<-0.092, 1.820, -0.030> <-0.102, 1.799, 0.034> <-0.125, 1.853, 0.029> <-0.157, 1.862, 0.056> 
		<-0.092, 1.820, -0.030> <-0.102, 1.799, 0.034> <-0.089, 1.833, 0.072> <-0.102, 1.873, 0.083> 
		<-0.092, 1.820, -0.030> <-0.064, 1.820, 0.003> <-0.051, 1.854, 0.040> <-0.064, 1.893, 0.051> 
	}
	pigment{rgb <255/255, 255/255, 255/255>}
	finish{ambient 0.5 diffuse 0.4}

}

//patch_obj_01
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.201, 1.782, 0.102> <-0.197, 1.810, 0.079> <-0.207, 1.851, 0.058> <-0.185, 1.877, 0.025> 
		<-0.201, 1.782, 0.102> <-0.188, 1.822, 0.047> <-0.219, 1.837, 0.041> <-0.198, 1.863, 0.008> 
		<-0.201, 1.782, 0.102> <-0.188, 1.822, 0.047> <-0.219, 1.797, 0.026> <-0.199, 1.822, -0.006> 
		<-0.201, 1.782, 0.102> <-0.193, 1.793, 0.070> <-0.194, 1.796, 0.026> <-0.174, 1.821, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.201, 1.782, 0.102> <-0.197, 1.810, 0.079> <-0.207, 1.851, 0.058> <-0.185, 1.877, 0.025> 
		<-0.201, 1.782, 0.102> <-0.175, 1.837, 0.065> <-0.195, 1.864, 0.075> <-0.173, 1.890, 0.042> 
		<-0.201, 1.782, 0.102> <-0.175, 1.837, 0.065> <-0.175, 1.845, 0.090> <-0.154, 1.872, 0.057> 
		<-0.201, 1.782, 0.102> <-0.180, 1.808, 0.088> <-0.150, 1.845, 0.090> <-0.129, 1.871, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.185, 1.877, 0.025> <-0.174, 1.891, 0.008> <-0.155, 1.870, -0.008> <-0.130, 1.869, -0.009> 
		<-0.185, 1.877, 0.025> <-0.162, 1.904, 0.025> <-0.143, 1.883, 0.009> <-0.118, 1.883, 0.008> 
		<-0.185, 1.877, 0.025> <-0.162, 1.904, 0.025> <-0.143, 1.885, 0.039> <-0.118, 1.885, 0.039> 
		<-0.185, 1.877, 0.025> <-0.173, 1.890, 0.042> <-0.154, 1.872, 0.057> <-0.129, 1.871, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.185, 1.877, 0.025> <-0.174, 1.891, 0.008> <-0.155, 1.870, -0.008> <-0.130, 1.869, -0.009> 
		<-0.185, 1.877, 0.025> <-0.186, 1.877, -0.009> <-0.167, 1.856, -0.025> <-0.143, 1.856, -0.025> 
		<-0.185, 1.877, 0.025> <-0.186, 1.877, -0.009> <-0.187, 1.836, -0.023> <-0.163, 1.835, -0.024> 
		<-0.185, 1.877, 0.025> <-0.198, 1.863, 0.008> <-0.199, 1.822, -0.006> <-0.174, 1.821, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 1.869, -0.009> <-0.117, 1.869, -0.009> <-0.137, 1.883, 0.015> <-0.143, 1.876, 0.025> 
		<-0.130, 1.869, -0.009> <-0.104, 1.883, 0.008> <-0.130, 1.891, 0.024> <-0.137, 1.883, 0.034> 
		<-0.130, 1.869, -0.009> <-0.104, 1.883, 0.008> <-0.104, 1.885, 0.039> <-0.115, 1.871, 0.056> 
		<-0.130, 1.869, -0.009> <-0.118, 1.883, 0.008> <-0.118, 1.885, 0.039> <-0.129, 1.871, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 1.869, -0.009> <-0.117, 1.869, -0.009> <-0.137, 1.883, 0.015> <-0.143, 1.876, 0.025> 
		<-0.130, 1.869, -0.009> <-0.129, 1.856, -0.026> <-0.150, 1.869, -0.003> <-0.156, 1.861, 0.006> 
		<-0.130, 1.869, -0.009> <-0.129, 1.856, -0.026> <-0.136, 1.834, -0.024> <-0.147, 1.821, -0.007> 
		<-0.130, 1.869, -0.009> <-0.143, 1.856, -0.025> <-0.163, 1.835, -0.024> <-0.174, 1.821, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, 1.876, 0.025> <-0.166, 1.847, 0.061> <-0.184, 1.810, 0.079> <-0.201, 1.782, 0.102> 
		<-0.143, 1.876, 0.025> <-0.179, 1.833, 0.043> <-0.176, 1.822, 0.046> <-0.193, 1.793, 0.070> 
		<-0.143, 1.876, 0.025> <-0.179, 1.833, 0.043> <-0.167, 1.795, 0.025> <-0.194, 1.796, 0.026> 
		<-0.143, 1.876, 0.025> <-0.156, 1.861, 0.006> <-0.147, 1.821, -0.007> <-0.174, 1.821, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, 1.876, 0.025> <-0.166, 1.847, 0.061> <-0.184, 1.810, 0.079> <-0.201, 1.782, 0.102> 
		<-0.143, 1.876, 0.025> <-0.160, 1.854, 0.070> <-0.162, 1.837, 0.065> <-0.180, 1.808, 0.088> 
		<-0.143, 1.876, 0.025> <-0.160, 1.854, 0.070> <-0.137, 1.844, 0.089> <-0.150, 1.845, 0.090> 
		<-0.143, 1.876, 0.025> <-0.137, 1.883, 0.034> <-0.115, 1.871, 0.056> <-0.129, 1.871, 0.056> 
	}
	pigment{rgb <227/255, 182/255, 98/255>}
	finish{ambient 0.5 diffuse 0.4}

}

//patch_obj_03
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.030, 1.860, -0.122> <-0.019, 1.972, -0.158> <0.099, 1.836, -0.299> <0.132, 1.737, -0.355> 
		<-0.030, 1.860, -0.122> <-0.139, 1.941, -0.198> <0.026, 1.817, -0.323> <0.059, 1.718, -0.380> 
		<-0.030, 1.860, -0.122> <-0.139, 1.941, -0.198> <-0.051, 1.781, -0.300> <-0.014, 1.673, -0.362> 
		<-0.030, 1.860, -0.122> <-0.150, 1.829, -0.162> <-0.058, 1.706, -0.276> <-0.022, 1.597, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.030, 1.860, -0.122> <-0.019, 1.972, -0.158> <0.099, 1.836, -0.299> <0.132, 1.737, -0.355> 
		<-0.030, 1.860, -0.122> <0.100, 2.003, -0.119> <0.146, 1.848, -0.283> <0.180, 1.750, -0.340> 
		<-0.030, 1.860, -0.122> <0.100, 2.003, -0.119> <0.159, 1.808, -0.222> <0.195, 1.701, -0.284> 
		<-0.030, 1.860, -0.122> <0.088, 1.891, -0.083> <0.154, 1.760, -0.207> <0.190, 1.653, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.132, 1.737, -0.355> <0.185, 1.580, -0.445> <0.160, 1.403, -0.433> <0.172, 1.259, -0.466> 
		<0.132, 1.737, -0.355> <0.232, 1.593, -0.429> <0.166, 1.521, -0.373> <0.178, 1.377, -0.407> 
		<0.132, 1.737, -0.355> <0.232, 1.593, -0.429> <0.243, 1.561, -0.364> <0.238, 1.512, -0.348> 
		<0.132, 1.737, -0.355> <0.180, 1.750, -0.340> <0.195, 1.701, -0.284> <0.190, 1.653, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.132, 1.737, -0.355> <0.185, 1.580, -0.445> <0.160, 1.403, -0.433> <0.172, 1.259, -0.466> 
		<0.132, 1.737, -0.355> <0.112, 1.561, -0.469> <0.102, 1.504, -0.394> <0.114, 1.361, -0.428> 
		<0.132, 1.737, -0.355> <0.112, 1.561, -0.469> <0.030, 1.542, -0.437> <0.022, 1.467, -0.413> 
		<0.132, 1.737, -0.355> <0.059, 1.718, -0.380> <-0.014, 1.673, -0.362> <-0.022, 1.597, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.172, 1.259, -0.466> <0.152, 1.321, -0.406> <0.136, 1.371, -0.321> <0.104, 1.465, -0.267> 
		<0.172, 1.259, -0.466> <0.157, 1.439, -0.347> <0.209, 1.390, -0.296> <0.177, 1.484, -0.243> 
		<0.172, 1.259, -0.466> <0.157, 1.439, -0.347> <0.230, 1.438, -0.324> <0.183, 1.578, -0.243> 
		<0.172, 1.259, -0.466> <0.178, 1.377, -0.407> <0.238, 1.512, -0.348> <0.190, 1.653, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.172, 1.259, -0.466> <0.152, 1.321, -0.406> <0.136, 1.371, -0.321> <0.104, 1.465, -0.267> 
		<0.172, 1.259, -0.466> <0.094, 1.422, -0.368> <0.067, 1.353, -0.343> <0.035, 1.447, -0.290> 
		<0.172, 1.259, -0.466> <0.094, 1.422, -0.368> <0.015, 1.396, -0.390> <-0.029, 1.526, -0.315> 
		<0.172, 1.259, -0.466> <0.114, 1.361, -0.428> <0.022, 1.467, -0.413> <-0.022, 1.597, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.104, 1.465, -0.267> <0.057, 1.605, -0.186> <-0.047, 1.700, -0.070> <-0.030, 1.860, -0.122> 
		<0.104, 1.465, -0.267> <-0.012, 1.587, -0.209> <-0.167, 1.669, -0.110> <-0.150, 1.829, -0.162> 
		<0.104, 1.465, -0.267> <-0.012, 1.587, -0.209> <-0.066, 1.635, -0.253> <-0.058, 1.706, -0.276> 
		<0.104, 1.465, -0.267> <0.035, 1.447, -0.290> <-0.029, 1.526, -0.315> <-0.022, 1.597, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.104, 1.465, -0.267> <0.057, 1.605, -0.186> <-0.047, 1.700, -0.070> <-0.030, 1.860, -0.122> 
		<0.104, 1.465, -0.267> <0.130, 1.624, -0.162> <0.071, 1.731, -0.031> <0.088, 1.891, -0.083> 
		<0.104, 1.465, -0.267> <0.130, 1.624, -0.162> <0.146, 1.685, -0.182> <0.154, 1.760, -0.207> 
		<0.104, 1.465, -0.267> <0.177, 1.484, -0.243> <0.183, 1.578, -0.243> <0.190, 1.653, -0.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 1.520, -0.333> <0.112, 1.420, -0.398> <0.202, 1.307, -0.507> <0.222, 1.188, -0.548> 
		<0.065, 1.520, -0.333> <0.133, 1.287, -0.461> <0.168, 1.283, -0.516> <0.188, 1.164, -0.558> 
		<0.065, 1.520, -0.333> <0.133, 1.287, -0.461> <0.073, 1.232, -0.499> <0.097, 1.093, -0.547> 
		<0.065, 1.520, -0.333> <0.086, 1.386, -0.397> <0.112, 1.215, -0.496> <0.135, 1.076, -0.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 1.520, -0.333> <0.112, 1.420, -0.398> <0.202, 1.307, -0.507> <0.222, 1.188, -0.548> 
		<0.065, 1.520, -0.333> <0.181, 1.322, -0.447> <0.223, 1.322, -0.501> <0.243, 1.203, -0.542> 
		<0.065, 1.520, -0.333> <0.181, 1.322, -0.447> <0.251, 1.324, -0.458> <0.271, 1.203, -0.500> 
		<0.065, 1.520, -0.333> <0.134, 1.421, -0.383> <0.275, 1.313, -0.456> <0.296, 1.192, -0.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.222, 1.188, -0.548> <0.250, 1.019, -0.606> <0.221, 0.772, -0.622> <0.221, 0.594, -0.654> 
		<0.222, 1.188, -0.548> <0.272, 1.034, -0.600> <0.244, 0.952, -0.575> <0.244, 0.773, -0.607> 
		<0.222, 1.188, -0.548> <0.272, 1.034, -0.600> <0.301, 1.029, -0.560> <0.325, 1.018, -0.558> 
		<0.222, 1.188, -0.548> <0.243, 1.203, -0.542> <0.271, 1.203, -0.500> <0.296, 1.192, -0.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.222, 1.188, -0.548> <0.250, 1.019, -0.606> <0.221, 0.772, -0.622> <0.221, 0.594, -0.654> 
		<0.222, 1.188, -0.548> <0.217, 0.995, -0.616> <0.196, 0.917, -0.589> <0.195, 0.739, -0.621> 
		<0.222, 1.188, -0.548> <0.217, 0.995, -0.616> <0.120, 0.953, -0.595> <0.159, 0.935, -0.593> 
		<0.222, 1.188, -0.548> <0.188, 1.164, -0.558> <0.097, 1.093, -0.547> <0.135, 1.076, -0.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.221, 0.594, -0.654> <0.240, 0.764, -0.621> <0.312, 0.998, -0.600> <0.285, 1.160, -0.544> 
		<0.221, 0.594, -0.654> <0.263, 0.943, -0.574> <0.326, 1.007, -0.596> <0.299, 1.170, -0.540> 
		<0.221, 0.594, -0.654> <0.263, 0.943, -0.574> <0.341, 1.011, -0.557> <0.311, 1.185, -0.497> 
		<0.221, 0.594, -0.654> <0.244, 0.773, -0.607> <0.325, 1.018, -0.558> <0.296, 1.192, -0.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.221, 0.594, -0.654> <0.240, 0.764, -0.621> <0.312, 0.998, -0.600> <0.285, 1.160, -0.544> 
		<0.221, 0.594, -0.654> <0.215, 0.908, -0.588> <0.272, 0.968, -0.612> <0.244, 1.130, -0.555> 
		<0.221, 0.594, -0.654> <0.215, 0.908, -0.588> <0.206, 0.914, -0.590> <0.182, 1.055, -0.541> 
		<0.221, 0.594, -0.654> <0.195, 0.739, -0.621> <0.159, 0.935, -0.593> <0.135, 1.076, -0.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.285, 1.160, -0.544> <0.263, 1.292, -0.498> <0.131, 1.412, -0.396> <0.065, 1.520, -0.333> 
		<0.285, 1.160, -0.544> <0.222, 1.262, -0.510> <0.152, 1.278, -0.460> <0.086, 1.386, -0.397> 
		<0.285, 1.160, -0.544> <0.222, 1.262, -0.510> <0.159, 1.194, -0.493> <0.112, 1.215, -0.496> 
		<0.285, 1.160, -0.544> <0.244, 1.130, -0.555> <0.182, 1.055, -0.541> <0.135, 1.076, -0.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.285, 1.160, -0.544> <0.263, 1.292, -0.498> <0.131, 1.412, -0.396> <0.065, 1.520, -0.333> 
		<0.285, 1.160, -0.544> <0.276, 1.302, -0.494> <0.200, 1.313, -0.446> <0.134, 1.421, -0.383> 
		<0.285, 1.160, -0.544> <0.276, 1.302, -0.494> <0.291, 1.306, -0.455> <0.275, 1.313, -0.456> 
		<0.285, 1.160, -0.544> <0.299, 1.170, -0.540> <0.311, 1.185, -0.497> <0.296, 1.192, -0.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 1.934, -0.009> <-0.162, 1.980, -0.039> <-0.114, 2.000, -0.092> <-0.084, 1.967, -0.123> 
		<-0.162, 1.934, -0.009> <-0.186, 1.974, -0.044> <-0.167, 1.987, -0.103> <-0.138, 1.953, -0.135> 
		<-0.162, 1.934, -0.009> <-0.186, 1.974, -0.044> <-0.189, 1.944, -0.063> <-0.176, 1.929, -0.077> 
		<-0.162, 1.934, -0.009> <-0.186, 1.928, -0.014> <-0.190, 1.897, -0.032> <-0.177, 1.882, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 1.934, -0.009> <-0.162, 1.980, -0.039> <-0.114, 2.000, -0.092> <-0.084, 1.967, -0.123> 
		<-0.162, 1.934, -0.009> <-0.102, 1.995, -0.026> <-0.060, 2.014, -0.081> <-0.031, 1.981, -0.112> 
		<-0.162, 1.934, -0.009> <-0.102, 1.995, -0.026> <-0.031, 2.013, -0.004> <0.003, 1.975, -0.040> 
		<-0.162, 1.934, -0.009> <-0.103, 1.949, 0.003> <-0.032, 1.966, 0.027> <0.002, 1.927, -0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 1.967, -0.123> <-0.047, 1.924, -0.164> <-0.035, 1.850, -0.183> <-0.036, 1.791, -0.145> 
		<-0.084, 1.967, -0.123> <0.007, 1.938, -0.153> <0.036, 1.868, -0.168> <0.035, 1.809, -0.130> 
		<-0.084, 1.967, -0.123> <0.007, 1.938, -0.153> <0.043, 1.929, -0.084> <0.042, 1.882, -0.053> 
		<-0.084, 1.967, -0.123> <-0.031, 1.981, -0.112> <0.003, 1.975, -0.040> <0.002, 1.927, -0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 1.967, -0.123> <-0.047, 1.924, -0.164> <-0.035, 1.850, -0.183> <-0.036, 1.791, -0.145> 
		<-0.084, 1.967, -0.123> <-0.100, 1.910, -0.175> <-0.106, 1.832, -0.198> <-0.107, 1.773, -0.160> 
		<-0.084, 1.967, -0.123> <-0.100, 1.910, -0.175> <-0.136, 1.884, -0.120> <-0.137, 1.836, -0.090> 
		<-0.084, 1.967, -0.123> <-0.138, 1.953, -0.135> <-0.176, 1.929, -0.077> <-0.177, 1.882, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.036, 1.791, -0.145> <-0.037, 1.746, -0.116> <-0.058, 1.765, -0.046> <-0.087, 1.798, -0.015> 
		<-0.036, 1.791, -0.145> <0.034, 1.764, -0.101> <-0.001, 1.780, -0.034> <-0.030, 1.812, -0.003> 
		<-0.036, 1.791, -0.145> <0.034, 1.764, -0.101> <0.042, 1.831, -0.020> <0.001, 1.877, 0.023> 
		<-0.036, 1.791, -0.145> <0.035, 1.809, -0.130> <0.042, 1.882, -0.053> <0.002, 1.927, -0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.036, 1.791, -0.145> <-0.037, 1.746, -0.116> <-0.058, 1.765, -0.046> <-0.087, 1.798, -0.015> 
		<-0.036, 1.791, -0.145> <-0.107, 1.728, -0.131> <-0.104, 1.753, -0.056> <-0.133, 1.786, -0.025> 
		<-0.036, 1.791, -0.145> <-0.107, 1.728, -0.131> <-0.137, 1.796, -0.064> <-0.177, 1.841, -0.021> 
		<-0.036, 1.791, -0.145> <-0.107, 1.773, -0.160> <-0.137, 1.836, -0.090> <-0.177, 1.882, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.087, 1.798, -0.015> <-0.119, 1.834, 0.019> <-0.163, 1.884, 0.023> <-0.162, 1.934, -0.009> 
		<-0.087, 1.798, -0.015> <-0.165, 1.822, 0.010> <-0.187, 1.878, 0.018> <-0.186, 1.928, -0.014> 
		<-0.087, 1.798, -0.015> <-0.165, 1.822, 0.010> <-0.191, 1.856, -0.006> <-0.190, 1.897, -0.032> 
		<-0.087, 1.798, -0.015> <-0.133, 1.786, -0.025> <-0.177, 1.841, -0.021> <-0.177, 1.882, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.087, 1.798, -0.015> <-0.119, 1.834, 0.019> <-0.163, 1.884, 0.023> <-0.162, 1.934, -0.009> 
		<-0.087, 1.798, -0.015> <-0.062, 1.849, 0.032> <-0.104, 1.899, 0.035> <-0.103, 1.949, 0.003> 
		<-0.087, 1.798, -0.015> <-0.062, 1.849, 0.032> <-0.033, 1.915, 0.060> <-0.032, 1.966, 0.027> 
		<-0.087, 1.798, -0.015> <-0.030, 1.812, -0.003> <0.001, 1.877, 0.023> <0.002, 1.927, -0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 2.046, -0.100> <0.004, 2.012, -0.085> <0.007, 1.963, -0.063> <-0.032, 1.933, -0.051> 
		<0.020, 2.046, -0.100> <-0.048, 1.980, -0.077> <-0.023, 1.950, -0.098> <-0.063, 1.920, -0.086> 
		<0.020, 2.046, -0.100> <-0.048, 1.980, -0.077> <-0.048, 1.973, -0.094> <-0.110, 1.926, -0.075> 
		<0.020, 2.046, -0.100> <-0.033, 2.013, -0.092> <-0.094, 1.985, -0.092> <-0.156, 1.938, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 2.046, -0.100> <0.004, 2.012, -0.085> <0.007, 1.963, -0.063> <-0.032, 1.933, -0.051> 
		<0.020, 2.046, -0.100> <-0.024, 1.991, -0.049> <0.030, 1.973, -0.038> <-0.010, 1.943, -0.026> 
		<0.020, 2.046, -0.100> <-0.024, 1.991, -0.049> <0.010, 2.003, 0.004> <-0.039, 1.965, 0.019> 
		<0.020, 2.046, -0.100> <-0.008, 2.024, -0.063> <-0.024, 2.012, 0.006> <-0.074, 1.974, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 1.933, -0.051> <-0.068, 1.906, -0.040> <-0.107, 1.903, -0.050> <-0.152, 1.915, -0.048> 
		<-0.032, 1.933, -0.051> <-0.046, 1.916, -0.015> <-0.078, 1.915, -0.016> <-0.123, 1.927, -0.014> 
		<-0.032, 1.933, -0.051> <-0.046, 1.916, -0.015> <-0.075, 1.938, 0.030> <-0.109, 1.947, 0.032> 
		<-0.032, 1.933, -0.051> <-0.010, 1.943, -0.026> <-0.039, 1.965, 0.019> <-0.074, 1.974, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 1.933, -0.051> <-0.068, 1.906, -0.040> <-0.107, 1.903, -0.050> <-0.152, 1.915, -0.048> 
		<-0.032, 1.933, -0.051> <-0.099, 1.893, -0.075> <-0.116, 1.899, -0.059> <-0.161, 1.911, -0.057> 
		<-0.032, 1.933, -0.051> <-0.099, 1.893, -0.075> <-0.120, 1.918, -0.072> <-0.166, 1.930, -0.070> 
		<-0.032, 1.933, -0.051> <-0.063, 1.920, -0.086> <-0.110, 1.926, -0.075> <-0.156, 1.938, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.152, 1.915, -0.048> <-0.171, 1.919, -0.047> <-0.162, 1.953, -0.042> <-0.147, 1.964, -0.046> 
		<-0.152, 1.915, -0.048> <-0.142, 1.932, -0.014> <-0.137, 1.963, -0.014> <-0.123, 1.975, -0.019> 
		<-0.152, 1.915, -0.048> <-0.142, 1.932, -0.014> <-0.146, 1.957, 0.033> <-0.111, 1.984, 0.023> 
		<-0.152, 1.915, -0.048> <-0.123, 1.927, -0.014> <-0.109, 1.947, 0.032> <-0.074, 1.974, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.152, 1.915, -0.048> <-0.171, 1.919, -0.047> <-0.162, 1.953, -0.042> <-0.147, 1.964, -0.046> 
		<-0.152, 1.915, -0.048> <-0.179, 1.916, -0.056> <-0.171, 1.949, -0.052> <-0.156, 1.960, -0.057> 
		<-0.152, 1.915, -0.048> <-0.179, 1.916, -0.056> <-0.180, 1.934, -0.069> <-0.170, 1.942, -0.073> 
		<-0.152, 1.915, -0.048> <-0.161, 1.911, -0.057> <-0.166, 1.930, -0.070> <-0.156, 1.938, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 1.964, -0.046> <-0.090, 2.007, -0.063> <-0.030, 2.021, -0.084> <0.020, 2.046, -0.100> 
		<-0.147, 1.964, -0.046> <-0.099, 2.003, -0.074> <-0.083, 1.989, -0.076> <-0.033, 2.013, -0.092> 
		<-0.147, 1.964, -0.046> <-0.099, 2.003, -0.074> <-0.109, 1.989, -0.091> <-0.094, 1.985, -0.092> 
		<-0.147, 1.964, -0.046> <-0.156, 1.960, -0.057> <-0.170, 1.942, -0.073> <-0.156, 1.938, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 1.964, -0.046> <-0.090, 2.007, -0.063> <-0.030, 2.021, -0.084> <0.020, 2.046, -0.100> 
		<-0.147, 1.964, -0.046> <-0.066, 2.018, -0.036> <-0.058, 2.000, -0.047> <-0.008, 2.024, -0.063> 
		<-0.147, 1.964, -0.046> <-0.066, 2.018, -0.036> <-0.061, 2.022, 0.008> <-0.024, 2.012, 0.006> 
		<-0.147, 1.964, -0.046> <-0.123, 1.975, -0.019> <-0.111, 1.984, 0.023> <-0.074, 1.974, 0.021> 
	}
	pigment{rgb <215/255, 21/255, 21/255>}
	finish{ambient 0.6 diffuse 0.5}

}

//patch_obj_04
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.092, 1.467, -0.320> <0.142, 1.417, -0.314> <0.145, 1.492, -0.200> <0.131, 1.546, -0.157> 
		<0.092, 1.467, -0.320> <0.188, 1.478, -0.354> <0.173, 1.530, -0.225> <0.159, 1.584, -0.182> 
		<0.092, 1.467, -0.320> <0.188, 1.478, -0.354> <0.139, 1.562, -0.263> <0.122, 1.627, -0.211> 
		<0.092, 1.467, -0.320> <0.138, 1.527, -0.360> <0.101, 1.599, -0.268> <0.084, 1.665, -0.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.092, 1.467, -0.320> <0.142, 1.417, -0.314> <0.145, 1.492, -0.200> <0.131, 1.546, -0.157> 
		<0.092, 1.467, -0.320> <0.097, 1.357, -0.274> <0.117, 1.455, -0.176> <0.103, 1.509, -0.133> 
		<0.092, 1.467, -0.320> <0.097, 1.357, -0.274> <0.048, 1.445, -0.185> <0.032, 1.510, -0.133> 
		<0.092, 1.467, -0.320> <0.047, 1.407, -0.281> <0.012, 1.481, -0.189> <-0.005, 1.546, -0.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.131, 1.546, -0.157> <0.109, 1.630, -0.091> <0.087, 1.711, -0.055> <0.011, 1.787, -0.065> 
		<0.131, 1.546, -0.157> <0.082, 1.593, -0.066> <0.036, 1.643, -0.010> <-0.041, 1.719, -0.020> 
		<0.131, 1.546, -0.157> <0.082, 1.593, -0.066> <0.013, 1.583, -0.074> <-0.024, 1.620, -0.079> 
		<0.131, 1.546, -0.157> <0.103, 1.509, -0.133> <0.032, 1.510, -0.133> <-0.005, 1.546, -0.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.131, 1.546, -0.157> <0.109, 1.630, -0.091> <0.087, 1.711, -0.055> <0.011, 1.787, -0.065> 
		<0.131, 1.546, -0.157> <0.138, 1.667, -0.116> <0.130, 1.767, -0.093> <0.053, 1.843, -0.102> 
		<0.131, 1.546, -0.157> <0.138, 1.667, -0.116> <0.106, 1.688, -0.163> <0.069, 1.726, -0.167> 
		<0.131, 1.546, -0.157> <0.159, 1.584, -0.182> <0.122, 1.627, -0.211> <0.084, 1.665, -0.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 1.787, -0.065> <-0.032, 1.830, -0.070> <-0.006, 1.717, -0.136> <0.006, 1.671, -0.173> 
		<0.011, 1.787, -0.065> <-0.084, 1.762, -0.025> <-0.032, 1.682, -0.112> <-0.020, 1.636, -0.150> 
		<0.011, 1.787, -0.065> <-0.084, 1.762, -0.025> <-0.059, 1.655, -0.083> <-0.040, 1.581, -0.142> 
		<0.011, 1.787, -0.065> <-0.041, 1.719, -0.020> <-0.024, 1.620, -0.079> <-0.005, 1.546, -0.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 1.787, -0.065> <-0.032, 1.830, -0.070> <-0.006, 1.717, -0.136> <0.006, 1.671, -0.173> 
		<0.011, 1.787, -0.065> <0.010, 1.886, -0.107> <0.013, 1.741, -0.151> <0.025, 1.695, -0.189> 
		<0.011, 1.787, -0.065> <0.010, 1.886, -0.107> <0.045, 1.750, -0.170> <0.060, 1.689, -0.219> 
		<0.011, 1.787, -0.065> <0.053, 1.843, -0.102> <0.069, 1.726, -0.167> <0.084, 1.665, -0.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.006, 1.671, -0.173> <0.026, 1.593, -0.235> <0.021, 1.539, -0.329> <0.092, 1.467, -0.320> 
		<0.006, 1.671, -0.173> <0.044, 1.617, -0.251> <0.066, 1.599, -0.369> <0.138, 1.527, -0.360> 
		<0.006, 1.671, -0.173> <0.044, 1.617, -0.251> <0.077, 1.623, -0.271> <0.101, 1.599, -0.268> 
		<0.006, 1.671, -0.173> <0.025, 1.695, -0.189> <0.060, 1.689, -0.219> <0.084, 1.665, -0.216> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.006, 1.671, -0.173> <0.026, 1.593, -0.235> <0.021, 1.539, -0.329> <0.092, 1.467, -0.320> 
		<0.006, 1.671, -0.173> <-0.000, 1.558, -0.212> <-0.024, 1.479, -0.290> <0.047, 1.407, -0.281> 
		<0.006, 1.671, -0.173> <-0.000, 1.558, -0.212> <-0.023, 1.516, -0.194> <0.012, 1.481, -0.189> 
		<0.006, 1.671, -0.173> <-0.020, 1.636, -0.150> <-0.040, 1.581, -0.142> <-0.005, 1.546, -0.137> 
	}
	pigment{rgb <255/255, 255/255, 255/255>}
	finish{ambient 0.5 diffuse 0.4}

}

//patch_obj_06
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.038, 1.317, -0.252> <0.038, 1.319, -0.248> <0.041, 1.319, -0.246> <0.045, 1.319, -0.246> 
		<0.038, 1.317, -0.252> <0.038, 1.317, -0.252> <0.041, 1.318, -0.249> <0.045, 1.318, -0.249> 
		<0.038, 1.317, -0.252> <0.038, 1.317, -0.252> <0.041, 1.317, -0.254> <0.045, 1.317, -0.254> 
		<0.038, 1.317, -0.252> <0.038, 1.316, -0.255> <0.041, 1.315, -0.258> <0.045, 1.315, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 1.319, -0.246> <0.048, 1.319, -0.246> <0.051, 1.319, -0.248> <0.051, 1.317, -0.252> 
		<0.045, 1.319, -0.246> <0.048, 1.318, -0.249> <0.051, 1.317, -0.252> <0.051, 1.316, -0.255> 
		<0.045, 1.319, -0.246> <0.048, 1.318, -0.249> <0.048, 1.317, -0.254> <0.048, 1.315, -0.258> 
		<0.045, 1.319, -0.246> <0.045, 1.318, -0.249> <0.045, 1.317, -0.254> <0.045, 1.315, -0.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.038, 1.447, -0.296> <0.038, 1.448, -0.293> <0.041, 1.449, -0.290> <0.045, 1.449, -0.290> 
		<0.038, 1.447, -0.296> <0.038, 1.447, -0.296> <0.041, 1.448, -0.294> <0.045, 1.448, -0.294> 
		<0.038, 1.447, -0.296> <0.038, 1.447, -0.296> <0.041, 1.446, -0.299> <0.045, 1.446, -0.299> 
		<0.038, 1.447, -0.296> <0.038, 1.446, -0.300> <0.041, 1.445, -0.302> <0.045, 1.445, -0.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 1.449, -0.290> <0.048, 1.449, -0.290> <0.051, 1.448, -0.293> <0.051, 1.447, -0.296> 
		<0.045, 1.449, -0.290> <0.048, 1.448, -0.294> <0.051, 1.447, -0.296> <0.051, 1.446, -0.300> 
		<0.045, 1.449, -0.290> <0.048, 1.448, -0.294> <0.048, 1.446, -0.299> <0.048, 1.445, -0.302> 
		<0.045, 1.449, -0.290> <0.045, 1.448, -0.294> <0.045, 1.446, -0.299> <0.045, 1.445, -0.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 1.347, -0.237> <0.084, 1.348, -0.233> <0.086, 1.349, -0.230> <0.089, 1.349, -0.229> 
		<0.085, 1.347, -0.237> <0.085, 1.347, -0.237> <0.087, 1.347, -0.233> <0.090, 1.347, -0.232> 
		<0.085, 1.347, -0.237> <0.085, 1.347, -0.237> <0.089, 1.346, -0.238> <0.092, 1.346, -0.237> 
		<0.085, 1.347, -0.237> <0.086, 1.345, -0.240> <0.090, 1.345, -0.241> <0.093, 1.345, -0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.089, 1.349, -0.229> <0.092, 1.349, -0.228> <0.096, 1.348, -0.229> <0.097, 1.347, -0.232> 
		<0.089, 1.349, -0.229> <0.094, 1.347, -0.231> <0.097, 1.347, -0.232> <0.098, 1.345, -0.236> 
		<0.089, 1.349, -0.229> <0.094, 1.347, -0.231> <0.095, 1.346, -0.236> <0.096, 1.345, -0.239> 
		<0.089, 1.349, -0.229> <0.090, 1.347, -0.232> <0.092, 1.346, -0.237> <0.093, 1.345, -0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 1.476, -0.279> <0.098, 1.477, -0.276> <0.100, 1.478, -0.272> <0.104, 1.478, -0.271> 
		<0.100, 1.476, -0.279> <0.100, 1.476, -0.279> <0.101, 1.477, -0.276> <0.105, 1.477, -0.274> 
		<0.100, 1.476, -0.279> <0.100, 1.476, -0.279> <0.103, 1.475, -0.280> <0.106, 1.475, -0.279> 
		<0.100, 1.476, -0.279> <0.101, 1.475, -0.282> <0.104, 1.474, -0.284> <0.108, 1.474, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.104, 1.478, -0.271> <0.107, 1.478, -0.270> <0.110, 1.477, -0.272> <0.112, 1.476, -0.275> 
		<0.104, 1.478, -0.271> <0.108, 1.477, -0.273> <0.112, 1.476, -0.275> <0.113, 1.475, -0.278> 
		<0.104, 1.478, -0.271> <0.108, 1.477, -0.273> <0.110, 1.475, -0.278> <0.111, 1.474, -0.281> 
		<0.104, 1.478, -0.271> <0.105, 1.477, -0.274> <0.106, 1.475, -0.279> <0.108, 1.474, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 1.319, -0.246> <0.048, 1.319, -0.246> <0.051, 1.319, -0.248> <0.051, 1.317, -0.252> 
		<0.045, 1.358, -0.259> <0.048, 1.358, -0.259> <0.051, 1.357, -0.262> <0.051, 1.356, -0.265> 
		<0.045, 1.410, -0.277> <0.048, 1.410, -0.277> <0.051, 1.409, -0.280> <0.051, 1.408, -0.283> 
		<0.045, 1.449, -0.290> <0.048, 1.449, -0.290> <0.051, 1.448, -0.293> <0.051, 1.447, -0.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.051, 1.317, -0.252> <0.051, 1.316, -0.255> <0.048, 1.315, -0.258> <0.045, 1.315, -0.258> 
		<0.051, 1.356, -0.265> <0.051, 1.355, -0.268> <0.048, 1.354, -0.271> <0.045, 1.354, -0.271> 
		<0.051, 1.408, -0.283> <0.051, 1.407, -0.286> <0.048, 1.406, -0.289> <0.045, 1.406, -0.289> 
		<0.051, 1.447, -0.296> <0.051, 1.446, -0.300> <0.048, 1.445, -0.302> <0.045, 1.445, -0.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 1.315, -0.258> <0.041, 1.315, -0.258> <0.038, 1.316, -0.255> <0.038, 1.317, -0.252> 
		<0.045, 1.354, -0.271> <0.041, 1.354, -0.271> <0.038, 1.355, -0.268> <0.038, 1.356, -0.265> 
		<0.045, 1.406, -0.289> <0.041, 1.406, -0.289> <0.038, 1.407, -0.286> <0.038, 1.408, -0.283> 
		<0.045, 1.445, -0.302> <0.041, 1.445, -0.302> <0.038, 1.446, -0.300> <0.038, 1.447, -0.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.038, 1.447, -0.296> <0.038, 1.448, -0.293> <0.041, 1.449, -0.290> <0.045, 1.449, -0.290> 
		<0.038, 1.408, -0.283> <0.038, 1.409, -0.280> <0.041, 1.410, -0.277> <0.045, 1.410, -0.277> 
		<0.038, 1.356, -0.265> <0.038, 1.357, -0.262> <0.041, 1.358, -0.259> <0.045, 1.358, -0.259> 
		<0.038, 1.317, -0.252> <0.038, 1.319, -0.248> <0.041, 1.319, -0.246> <0.045, 1.319, -0.246> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.089, 1.349, -0.229> <0.092, 1.349, -0.228> <0.096, 1.348, -0.229> <0.097, 1.347, -0.232> 
		<0.093, 1.388, -0.241> <0.097, 1.388, -0.240> <0.100, 1.387, -0.242> <0.101, 1.386, -0.245> 
		<0.099, 1.439, -0.258> <0.103, 1.439, -0.257> <0.106, 1.439, -0.259> <0.107, 1.437, -0.262> 
		<0.104, 1.478, -0.271> <0.107, 1.478, -0.270> <0.110, 1.477, -0.272> <0.112, 1.476, -0.275> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.097, 1.347, -0.232> <0.098, 1.345, -0.236> <0.096, 1.345, -0.239> <0.093, 1.345, -0.240> 
		<0.101, 1.386, -0.245> <0.102, 1.384, -0.248> <0.101, 1.383, -0.252> <0.097, 1.383, -0.253> 
		<0.107, 1.437, -0.262> <0.108, 1.436, -0.265> <0.106, 1.435, -0.269> <0.103, 1.435, -0.270> 
		<0.112, 1.476, -0.275> <0.113, 1.475, -0.278> <0.111, 1.474, -0.281> <0.108, 1.474, -0.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.345, -0.240> <0.090, 1.345, -0.241> <0.086, 1.345, -0.240> <0.085, 1.347, -0.237> 
		<0.097, 1.383, -0.253> <0.094, 1.383, -0.254> <0.090, 1.384, -0.252> <0.089, 1.386, -0.249> 
		<0.103, 1.435, -0.270> <0.100, 1.435, -0.271> <0.096, 1.436, -0.269> <0.095, 1.437, -0.266> 
		<0.108, 1.474, -0.282> <0.104, 1.474, -0.284> <0.101, 1.475, -0.282> <0.100, 1.476, -0.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 1.476, -0.279> <0.098, 1.477, -0.276> <0.100, 1.478, -0.272> <0.104, 1.478, -0.271> 
		<0.095, 1.437, -0.266> <0.094, 1.439, -0.263> <0.096, 1.439, -0.260> <0.099, 1.439, -0.258> 
		<0.089, 1.386, -0.249> <0.088, 1.387, -0.246> <0.090, 1.388, -0.243> <0.093, 1.388, -0.241> 
		<0.085, 1.347, -0.237> <0.084, 1.348, -0.233> <0.086, 1.349, -0.230> <0.089, 1.349, -0.229> 
	}
	pigment{rgb <128/255, 64/255, 64/255>}
	finish{ambient 0.5 diffuse 0.4}

}
}
