
/*
camera{
	location < 12.260, 1.976, -16.455 >
	look_at < 0.000, 0.000, 0.000 >
	angle 40.000
}

background{ rgb <0/255,0/255,0/255> }


light_source{<100,100,-100> rgb 1}
light_source{<0,10,-1000> rgb 1}


global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	
	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	} 
}
*/ 

#declare casa01=
union{
//patch_obj_00
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.017, -1.063, -2.453> <2.705, -0.439, -1.846> <2.289, 0.393, -1.038> <1.977, 1.017, -0.432> 
		<1.210, -1.063, -2.453> <0.898, -0.439, -1.846> <1.095, 0.393, -1.038> <0.783, 1.017, -0.432> 
		<-1.199, -1.063, -2.453> <-0.899, -0.439, -1.846> <-1.111, 0.393, -1.038> <-0.811, 1.017, -0.432> 
		<-3.006, -1.063, -2.453> <-2.706, -0.439, -1.846> <-2.306, 0.393, -1.038> <-2.006, 1.017, -0.432> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.977, 1.017, -0.432> <0.783, 1.017, -0.432> <-0.811, 1.017, -0.432> <-2.006, 1.017, -0.432> 
		<2.101, 1.317, -0.296> <0.906, 1.317, -0.296> <-0.905, 1.317, -0.296> <-2.100, 1.317, -0.296> 
		<2.266, 1.717, -0.116> <0.853, 1.717, -0.116> <-0.813, 1.717, -0.116> <-2.225, 1.717, -0.116> 
		<2.390, 2.018, 0.020> <0.977, 2.018, 0.020> <-0.907, 2.018, 0.020> <-2.320, 2.018, 0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.037, -1.024, 2.511> <2.725, -0.406, 1.899> <2.309, 0.419, 1.083> <1.997, 1.037, 0.471> 
		<1.230, -1.024, 2.511> <0.918, -0.406, 1.899> <1.114, 0.419, 1.083> <0.802, 1.037, 0.471> 
		<-1.180, -1.024, 2.511> <-0.879, -0.406, 1.899> <-1.091, 0.419, 1.083> <-0.791, 1.037, 0.471> 
		<-2.987, -1.024, 2.511> <-2.686, -0.406, 1.899> <-2.286, 0.419, 1.083> <-1.986, 1.037, 0.471> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.997, 1.037, 0.471> <0.802, 1.037, 0.471> <-0.791, 1.037, 0.471> <-1.986, 1.037, 0.471> 
		<2.115, 1.331, 0.336> <0.920, 1.331, 0.336> <-0.891, 1.331, 0.336> <-2.086, 1.331, 0.336> 
		<2.272, 1.723, 0.155> <0.859, 1.723, 0.155> <-0.807, 1.723, 0.155> <-2.219, 1.723, 0.155> 
		<2.390, 2.018, 0.020> <0.977, 2.018, 0.020> <-0.907, 2.018, 0.020> <-2.320, 2.018, 0.020> 
	}
	pigment{Marfil}
	normal {agate 0.5 scale 0.25}
	finish{ambient 0.3 diffuse 0.3 reflection 0.1}  

}

//patch_obj_01
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.943, -1.023, -2.301> <2.631, -0.411, -1.730> <2.215, 0.405, -0.968> <1.903, 1.017, -0.397> 
		<2.943, -1.023, -2.301> <2.637, -0.417, -1.047> <2.533, -0.213, -0.856> <2.221, 0.399, -0.285> 
		<2.943, -1.023, -2.301> <2.637, -0.417, -1.047> <2.639, -0.419, -0.819> <2.645, -0.425, -0.136> 
		<2.943, -1.023, -2.301> <2.949, -1.029, -1.618> <2.957, -1.037, -0.707> <2.963, -1.043, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.903, 1.017, -0.397> <1.903, 1.012, -0.285> <1.903, 1.004, -0.136> <1.903, 0.998, -0.025> 
		<1.903, 1.017, -0.397> <2.003, 1.302, -0.171> <2.003, 1.300, -0.134> <2.003, 1.295, -0.022> 
		<1.903, 1.017, -0.397> <2.003, 1.302, -0.171> <2.037, 1.399, -0.133> <2.137, 1.690, -0.019> 
		<1.903, 1.017, -0.397> <2.003, 1.308, -0.283> <2.137, 1.696, -0.131> <2.237, 1.987, -0.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.903, 1.017, -0.397> <1.903, 1.012, -0.285> <1.903, 1.004, -0.136> <1.903, 0.998, -0.025> 
		<1.903, 1.017, -0.397> <2.221, 0.393, -0.174> <2.221, 0.392, -0.136> <2.221, 0.386, -0.025> 
		<1.903, 1.017, -0.397> <2.221, 0.393, -0.174> <2.327, 0.187, -0.136> <2.645, -0.431, -0.025> 
		<1.903, 1.017, -0.397> <2.221, 0.399, -0.285> <2.645, -0.425, -0.136> <2.963, -1.043, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.903, 0.998, -0.025> <2.221, 0.386, -0.025> <2.645, -0.431, -0.025> <2.963, -1.043, -0.025> 
		<1.903, 0.998, -0.025> <2.221, 0.397, 0.126> <2.327, 0.193, 0.126> <2.645, -0.419, 0.126> 
		<1.903, 0.998, -0.025> <2.221, 0.397, 0.126> <2.221, 0.401, 0.176> <2.221, 0.413, 0.326> 
		<1.903, 0.998, -0.025> <1.903, 1.010, 0.126> <1.903, 1.025, 0.326> <1.903, 1.037, 0.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.963, -1.023, 2.379> <2.645, -0.405, 1.808> <2.221, 0.419, 1.047> <1.903, 1.037, 0.476> 
		<2.963, -1.023, 2.379> <2.645, -0.411, 1.087> <2.539, -0.205, 0.897> <2.221, 0.413, 0.326> 
		<2.963, -1.023, 2.379> <2.645, -0.411, 1.087> <2.645, -0.413, 0.847> <2.645, -0.419, 0.126> 
		<2.963, -1.023, 2.379> <2.963, -1.029, 1.658> <2.963, -1.037, 0.697> <2.963, -1.043, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.903, 1.037, 0.476> <1.903, 1.025, 0.326> <1.903, 1.010, 0.126> <1.903, 0.998, -0.025> 
		<1.903, 1.037, 0.476> <2.003, 1.310, 0.178> <2.003, 1.306, 0.128> <2.003, 1.295, -0.022> 
		<1.903, 1.037, 0.476> <2.003, 1.310, 0.178> <2.037, 1.405, 0.129> <2.137, 1.690, -0.019> 
		<1.903, 1.037, 0.476> <2.003, 1.322, 0.328> <2.137, 1.702, 0.131> <2.237, 1.987, -0.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.884, -1.023, -2.281> <-2.572, -0.411, -1.710> <-2.156, 0.405, -0.949> <-1.844, 1.017, -0.378> 
		<-2.884, -1.023, -2.281> <-2.578, -0.417, -1.027> <-2.474, -0.213, -0.837> <-2.162, 0.399, -0.266> 
		<-2.884, -1.023, -2.281> <-2.578, -0.417, -1.027> <-2.580, -0.419, -0.800> <-2.586, -0.425, -0.117> 
		<-2.884, -1.023, -2.281> <-2.890, -1.029, -1.598> <-2.898, -1.037, -0.688> <-2.904, -1.043, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.844, 1.017, -0.378> <-1.844, 1.012, -0.266> <-1.844, 1.004, -0.117> <-1.844, 0.998, -0.005> 
		<-1.844, 1.017, -0.378> <-1.944, 1.302, -0.152> <-1.944, 1.300, -0.114> <-1.944, 1.295, -0.002> 
		<-1.844, 1.017, -0.378> <-1.944, 1.302, -0.152> <-1.978, 1.399, -0.113> <-2.078, 1.690, 0.001> 
		<-1.844, 1.017, -0.378> <-1.944, 1.308, -0.263> <-2.078, 1.696, -0.111> <-2.178, 1.987, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.844, 1.017, -0.378> <-1.844, 1.012, -0.266> <-1.844, 1.004, -0.117> <-1.844, 0.998, -0.005> 
		<-1.844, 1.017, -0.378> <-2.162, 0.393, -0.154> <-2.162, 0.392, -0.117> <-2.162, 0.386, -0.005> 
		<-1.844, 1.017, -0.378> <-2.162, 0.393, -0.154> <-2.268, 0.187, -0.117> <-2.586, -0.431, -0.005> 
		<-1.844, 1.017, -0.378> <-2.162, 0.399, -0.266> <-2.586, -0.425, -0.117> <-2.904, -1.043, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.844, 0.998, -0.005> <-2.162, 0.386, -0.005> <-2.586, -0.431, -0.005> <-2.904, -1.043, -0.005> 
		<-1.844, 0.998, -0.005> <-2.162, 0.397, 0.145> <-2.268, 0.193, 0.145> <-2.586, -0.419, 0.145> 
		<-1.844, 0.998, -0.005> <-2.162, 0.397, 0.145> <-2.162, 0.401, 0.195> <-2.162, 0.413, 0.345> 
		<-1.844, 0.998, -0.005> <-1.844, 1.010, 0.145> <-1.844, 1.025, 0.345> <-1.844, 1.037, 0.495> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.904, -1.023, 2.399> <-2.586, -0.405, 1.828> <-2.162, 0.419, 1.066> <-1.844, 1.037, 0.495> 
		<-2.904, -1.023, 2.399> <-2.586, -0.411, 1.107> <-2.480, -0.205, 0.916> <-2.162, 0.413, 0.345> 
		<-2.904, -1.023, 2.399> <-2.586, -0.411, 1.107> <-2.586, -0.413, 0.866> <-2.586, -0.419, 0.145> 
		<-2.904, -1.023, 2.399> <-2.904, -1.029, 1.678> <-2.904, -1.037, 0.716> <-2.904, -1.043, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.844, 1.037, 0.495> <-1.844, 1.025, 0.345> <-1.844, 1.010, 0.145> <-1.844, 0.998, -0.005> 
		<-1.844, 1.037, 0.495> <-1.944, 1.310, 0.198> <-1.944, 1.306, 0.148> <-1.944, 1.295, -0.002> 
		<-1.844, 1.037, 0.495> <-1.944, 1.310, 0.198> <-1.978, 1.405, 0.149> <-2.078, 1.690, 0.001> 
		<-1.844, 1.037, 0.495> <-1.944, 1.322, 0.348> <-2.078, 1.702, 0.151> <-2.178, 1.987, 0.003> 
	}
	pigment{Gray10}
	finish{ambient 0.4 diffuse 0.4 }

}

//patch_obj_02
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.815, -0.991, -2.286> <-1.685, -0.995, -2.286> <1.705, -1.007, -2.286> <2.835, -1.011, -2.286> 
		<-2.815, -1.191, -2.286> <-1.685, -1.195, -2.286> <1.705, -1.207, -2.286> <2.835, -1.211, -2.286> 
		<-2.815, -1.791, -2.286> <-1.685, -1.795, -2.286> <1.705, -1.807, -2.286> <2.835, -1.811, -2.286> 
		<-2.815, -1.991, -2.286> <-1.685, -1.995, -2.286> <1.705, -2.007, -2.286> <2.835, -2.011, -2.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.855, -0.991, 2.344> <-1.724, -0.995, 2.344> <1.666, -1.007, 2.344> <2.796, -1.011, 2.344> 
		<-2.847, -0.991, 1.418> <-1.717, -0.995, 1.418> <1.673, -1.007, 1.418> <2.804, -1.011, 1.418> 
		<-2.819, -0.991, -1.823> <-1.689, -0.995, -1.823> <1.701, -1.007, -1.823> <2.831, -1.011, -1.823> 
		<-2.815, -0.991, -2.286> <-1.685, -0.995, -2.286> <1.705, -1.007, -2.286> <2.835, -1.011, -2.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.855, -0.991, 2.344> <-1.724, -0.995, 2.344> <1.666, -1.007, 2.344> <2.796, -1.011, 2.344> 
		<-2.855, -1.191, 2.344> <-1.724, -1.195, 2.344> <1.666, -1.207, 2.344> <2.796, -1.211, 2.344> 
		<-2.855, -1.791, 2.344> <-1.724, -1.795, 2.344> <1.666, -1.807, 2.344> <2.796, -1.811, 2.344> 
		<-2.855, -1.991, 2.344> <-1.724, -1.995, 2.344> <1.666, -2.007, 2.344> <2.796, -2.011, 2.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.796, -1.011, 2.344> <2.796, -1.211, 2.344> <2.796, -1.811, 2.344> <2.796, -2.011, 2.344> 
		<2.804, -1.011, 1.418> <2.804, -1.211, 1.418> <2.804, -1.811, 1.418> <2.804, -2.011, 1.418> 
		<2.831, -1.011, -1.823> <2.831, -1.211, -1.823> <2.831, -1.811, -1.823> <2.831, -2.011, -1.823> 
		<2.835, -1.011, -2.286> <2.835, -1.211, -2.286> <2.835, -1.811, -2.286> <2.835, -2.011, -2.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.796, -2.011, 2.344> <1.666, -2.007, 2.344> <-1.724, -1.995, 2.344> <-2.855, -1.991, 2.344> 
		<2.804, -2.011, 1.418> <1.673, -2.007, 1.418> <-1.717, -1.995, 1.418> <-2.847, -1.991, 1.418> 
		<2.831, -2.011, -1.823> <1.701, -2.007, -1.823> <-1.689, -1.995, -1.823> <-2.819, -1.991, -1.823> 
		<2.835, -2.011, -2.286> <1.705, -2.007, -2.286> <-1.685, -1.995, -2.286> <-2.815, -1.991, -2.286> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.855, -1.991, 2.344> <-2.855, -1.791, 2.344> <-2.855, -1.191, 2.344> <-2.855, -0.991, 2.344> 
		<-2.847, -1.991, 1.418> <-2.847, -1.791, 1.418> <-2.847, -1.191, 1.418> <-2.847, -0.991, 1.418> 
		<-2.819, -1.991, -1.823> <-2.819, -1.791, -1.823> <-2.819, -1.191, -1.823> <-2.819, -0.991, -1.823> 
		<-2.815, -1.991, -2.286> <-2.815, -1.791, -2.286> <-2.815, -1.191, -2.286> <-2.815, -0.991, -2.286> 
	}
	pigment{Tan}
	normal {agate 0.5 }
	finish{ambient 0.3 diffuse 0.3 reflection 0.1}

}

//patch_obj_03
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.975, -1.815, -2.401> <-1.789, -1.819, -2.401> <1.771, -1.831, -2.401> <2.958, -1.835, -2.401> 
		<-2.975, -2.015, -2.401> <-1.789, -2.019, -2.401> <1.771, -2.031, -2.401> <2.958, -2.035, -2.401> 
		<-2.975, -2.615, -2.401> <-1.789, -2.619, -2.401> <1.771, -2.631, -2.401> <2.958, -2.635, -2.401> 
		<-2.975, -2.815, -2.401> <-1.789, -2.819, -2.401> <1.771, -2.831, -2.401> <2.958, -2.835, -2.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.016, -1.815, 2.460> <-1.830, -1.819, 2.460> <1.730, -1.831, 2.460> <2.916, -1.835, 2.460> 
		<-3.008, -1.815, 1.488> <-1.822, -1.819, 1.488> <1.738, -1.831, 1.488> <2.925, -1.835, 1.488> 
		<-2.979, -1.815, -1.915> <-1.793, -1.819, -1.915> <1.767, -1.831, -1.915> <2.953, -1.835, -1.915> 
		<-2.975, -1.815, -2.401> <-1.789, -1.819, -2.401> <1.771, -1.831, -2.401> <2.958, -1.835, -2.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.016, -1.815, 2.460> <-1.830, -1.819, 2.460> <1.730, -1.831, 2.460> <2.916, -1.835, 2.460> 
		<-3.016, -2.015, 2.460> <-1.830, -2.019, 2.460> <1.730, -2.031, 2.460> <2.916, -2.035, 2.460> 
		<-3.016, -2.615, 2.460> <-1.830, -2.619, 2.460> <1.730, -2.631, 2.460> <2.916, -2.635, 2.460> 
		<-3.016, -2.815, 2.460> <-1.830, -2.819, 2.460> <1.730, -2.831, 2.460> <2.916, -2.835, 2.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.916, -1.835, 2.460> <2.916, -2.035, 2.460> <2.916, -2.635, 2.460> <2.916, -2.835, 2.460> 
		<2.925, -1.835, 1.488> <2.925, -2.035, 1.488> <2.925, -2.635, 1.488> <2.925, -2.835, 1.488> 
		<2.953, -1.835, -1.915> <2.953, -2.035, -1.915> <2.953, -2.635, -1.915> <2.953, -2.835, -1.915> 
		<2.958, -1.835, -2.401> <2.958, -2.035, -2.401> <2.958, -2.635, -2.401> <2.958, -2.835, -2.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.916, -2.835, 2.460> <1.730, -2.831, 2.460> <-1.830, -2.819, 2.460> <-3.016, -2.815, 2.460> 
		<2.925, -2.835, 1.488> <1.738, -2.831, 1.488> <-1.822, -2.819, 1.488> <-3.008, -2.815, 1.488> 
		<2.953, -2.835, -1.915> <1.767, -2.831, -1.915> <-1.793, -2.819, -1.915> <-2.979, -2.815, -1.915> 
		<2.958, -2.835, -2.401> <1.771, -2.831, -2.401> <-1.789, -2.819, -2.401> <-2.975, -2.815, -2.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.016, -2.815, 2.460> <-3.016, -2.615, 2.460> <-3.016, -2.015, 2.460> <-3.016, -1.815, 2.460> 
		<-3.008, -2.815, 1.488> <-3.008, -2.615, 1.488> <-3.008, -2.015, 1.488> <-3.008, -1.815, 1.488> 
		<-2.979, -2.815, -1.915> <-2.979, -2.615, -1.915> <-2.979, -2.015, -1.915> <-2.979, -1.815, -1.915> 
		<-2.975, -2.815, -2.401> <-2.975, -2.615, -2.401> <-2.975, -2.015, -2.401> <-2.975, -1.815, -2.401> 
	}
	pigment{DarkWood}
	
	finish{ambient 0.4 diffuse 0.4 }

}

//patch_obj_04
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.818, -4.239, -2.126> <-2.818, -4.239, -2.033> <-2.740, -4.239, -1.955> <-2.647, -4.239, -1.955> 
		<-2.818, -4.239, -2.126> <-2.818, -4.239, -2.126> <-2.740, -4.239, -2.058> <-2.647, -4.239, -2.058> 
		<-2.818, -4.239, -2.126> <-2.818, -4.239, -2.126> <-2.740, -4.239, -2.195> <-2.647, -4.239, -2.195> 
		<-2.818, -4.239, -2.126> <-2.818, -4.239, -2.219> <-2.740, -4.239, -2.297> <-2.647, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.647, -4.239, -1.955> <-2.554, -4.239, -1.955> <-2.476, -4.239, -2.033> <-2.476, -4.239, -2.126> 
		<-2.647, -4.239, -1.955> <-2.554, -4.239, -2.058> <-2.476, -4.239, -2.126> <-2.476, -4.239, -2.219> 
		<-2.647, -4.239, -1.955> <-2.554, -4.239, -2.058> <-2.554, -4.239, -2.195> <-2.554, -4.239, -2.297> 
		<-2.647, -4.239, -1.955> <-2.647, -4.239, -2.058> <-2.647, -4.239, -2.195> <-2.647, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.818, -2.569, -2.126> <-2.818, -2.569, -2.033> <-2.740, -2.569, -1.955> <-2.647, -2.569, -1.955> 
		<-2.818, -2.569, -2.126> <-2.818, -2.569, -2.126> <-2.740, -2.569, -2.058> <-2.647, -2.569, -2.058> 
		<-2.818, -2.569, -2.126> <-2.818, -2.569, -2.126> <-2.740, -2.569, -2.195> <-2.647, -2.569, -2.195> 
		<-2.818, -2.569, -2.126> <-2.818, -2.569, -2.219> <-2.740, -2.569, -2.297> <-2.647, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.647, -2.569, -1.955> <-2.554, -2.569, -1.955> <-2.476, -2.569, -2.033> <-2.476, -2.569, -2.126> 
		<-2.647, -2.569, -1.955> <-2.554, -2.569, -2.058> <-2.476, -2.569, -2.126> <-2.476, -2.569, -2.219> 
		<-2.647, -2.569, -1.955> <-2.554, -2.569, -2.058> <-2.554, -2.569, -2.195> <-2.554, -2.569, -2.297> 
		<-2.647, -2.569, -1.955> <-2.647, -2.569, -2.058> <-2.647, -2.569, -2.195> <-2.647, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.492, -4.239, -2.126> <2.492, -4.239, -2.033> <2.570, -4.239, -1.955> <2.663, -4.239, -1.955> 
		<2.492, -4.239, -2.126> <2.492, -4.239, -2.126> <2.570, -4.239, -2.058> <2.663, -4.239, -2.058> 
		<2.492, -4.239, -2.126> <2.492, -4.239, -2.126> <2.570, -4.239, -2.195> <2.663, -4.239, -2.195> 
		<2.492, -4.239, -2.126> <2.492, -4.239, -2.219> <2.570, -4.239, -2.297> <2.663, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.663, -4.239, -1.955> <2.756, -4.239, -1.955> <2.834, -4.239, -2.033> <2.834, -4.239, -2.126> 
		<2.663, -4.239, -1.955> <2.756, -4.239, -2.058> <2.834, -4.239, -2.126> <2.834, -4.239, -2.219> 
		<2.663, -4.239, -1.955> <2.756, -4.239, -2.058> <2.756, -4.239, -2.195> <2.756, -4.239, -2.297> 
		<2.663, -4.239, -1.955> <2.663, -4.239, -2.058> <2.663, -4.239, -2.195> <2.663, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.492, -2.569, -2.126> <2.492, -2.569, -2.033> <2.570, -2.569, -1.955> <2.663, -2.569, -1.955> 
		<2.492, -2.569, -2.126> <2.492, -2.569, -2.126> <2.570, -2.569, -2.058> <2.663, -2.569, -2.058> 
		<2.492, -2.569, -2.126> <2.492, -2.569, -2.126> <2.570, -2.569, -2.195> <2.663, -2.569, -2.195> 
		<2.492, -2.569, -2.126> <2.492, -2.569, -2.219> <2.570, -2.569, -2.297> <2.663, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.663, -2.569, -1.955> <2.756, -2.569, -1.955> <2.834, -2.569, -2.033> <2.834, -2.569, -2.126> 
		<2.663, -2.569, -1.955> <2.756, -2.569, -2.058> <2.834, -2.569, -2.126> <2.834, -2.569, -2.219> 
		<2.663, -2.569, -1.955> <2.756, -2.569, -2.058> <2.756, -2.569, -2.195> <2.756, -2.569, -2.297> 
		<2.663, -2.569, -1.955> <2.663, -2.569, -2.058> <2.663, -2.569, -2.195> <2.663, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, -4.239, -2.126> <-0.172, -4.239, -2.033> <-0.095, -4.239, -1.955> <-0.001, -4.239, -1.955> 
		<-0.172, -4.239, -2.126> <-0.172, -4.239, -2.126> <-0.095, -4.239, -2.058> <-0.001, -4.239, -2.058> 
		<-0.172, -4.239, -2.126> <-0.172, -4.239, -2.126> <-0.095, -4.239, -2.195> <-0.001, -4.239, -2.195> 
		<-0.172, -4.239, -2.126> <-0.172, -4.239, -2.219> <-0.095, -4.239, -2.297> <-0.001, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, -4.239, -1.955> <0.092, -4.239, -1.955> <0.170, -4.239, -2.033> <0.170, -4.239, -2.126> 
		<-0.001, -4.239, -1.955> <0.092, -4.239, -2.058> <0.170, -4.239, -2.126> <0.170, -4.239, -2.219> 
		<-0.001, -4.239, -1.955> <0.092, -4.239, -2.058> <0.092, -4.239, -2.195> <0.092, -4.239, -2.297> 
		<-0.001, -4.239, -1.955> <-0.001, -4.239, -2.058> <-0.001, -4.239, -2.195> <-0.001, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, -2.569, -2.126> <-0.172, -2.569, -2.033> <-0.095, -2.569, -1.955> <-0.001, -2.569, -1.955> 
		<-0.172, -2.569, -2.126> <-0.172, -2.569, -2.126> <-0.095, -2.569, -2.058> <-0.001, -2.569, -2.058> 
		<-0.172, -2.569, -2.126> <-0.172, -2.569, -2.126> <-0.095, -2.569, -2.195> <-0.001, -2.569, -2.195> 
		<-0.172, -2.569, -2.126> <-0.172, -2.569, -2.219> <-0.095, -2.569, -2.297> <-0.001, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, -2.569, -1.955> <0.092, -2.569, -1.955> <0.170, -2.569, -2.033> <0.170, -2.569, -2.126> 
		<-0.001, -2.569, -1.955> <0.092, -2.569, -2.058> <0.170, -2.569, -2.126> <0.170, -2.569, -2.219> 
		<-0.001, -2.569, -1.955> <0.092, -2.569, -2.058> <0.092, -2.569, -2.195> <0.092, -2.569, -2.297> 
		<-0.001, -2.569, -1.955> <-0.001, -2.569, -2.058> <-0.001, -2.569, -2.195> <-0.001, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.505, -4.239, -2.126> <-1.505, -4.239, -2.033> <-1.427, -4.239, -1.955> <-1.334, -4.239, -1.955> 
		<-1.505, -4.239, -2.126> <-1.505, -4.239, -2.126> <-1.427, -4.239, -2.058> <-1.334, -4.239, -2.058> 
		<-1.505, -4.239, -2.126> <-1.505, -4.239, -2.126> <-1.427, -4.239, -2.195> <-1.334, -4.239, -2.195> 
		<-1.505, -4.239, -2.126> <-1.505, -4.239, -2.219> <-1.427, -4.239, -2.297> <-1.334, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.334, -4.239, -1.955> <-1.240, -4.239, -1.955> <-1.163, -4.239, -2.033> <-1.163, -4.239, -2.126> 
		<-1.334, -4.239, -1.955> <-1.240, -4.239, -2.058> <-1.163, -4.239, -2.126> <-1.163, -4.239, -2.219> 
		<-1.334, -4.239, -1.955> <-1.240, -4.239, -2.058> <-1.240, -4.239, -2.195> <-1.240, -4.239, -2.297> 
		<-1.334, -4.239, -1.955> <-1.334, -4.239, -2.058> <-1.334, -4.239, -2.195> <-1.334, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.505, -2.569, -2.126> <-1.505, -2.569, -2.033> <-1.427, -2.569, -1.955> <-1.334, -2.569, -1.955> 
		<-1.505, -2.569, -2.126> <-1.505, -2.569, -2.126> <-1.427, -2.569, -2.058> <-1.334, -2.569, -2.058> 
		<-1.505, -2.569, -2.126> <-1.505, -2.569, -2.126> <-1.427, -2.569, -2.195> <-1.334, -2.569, -2.195> 
		<-1.505, -2.569, -2.126> <-1.505, -2.569, -2.219> <-1.427, -2.569, -2.297> <-1.334, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.334, -2.569, -1.955> <-1.240, -2.569, -1.955> <-1.163, -2.569, -2.033> <-1.163, -2.569, -2.126> 
		<-1.334, -2.569, -1.955> <-1.240, -2.569, -2.058> <-1.163, -2.569, -2.126> <-1.163, -2.569, -2.219> 
		<-1.334, -2.569, -1.955> <-1.240, -2.569, -2.058> <-1.240, -2.569, -2.195> <-1.240, -2.569, -2.297> 
		<-1.334, -2.569, -1.955> <-1.334, -2.569, -2.058> <-1.334, -2.569, -2.195> <-1.334, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.160, -4.239, -2.126> <1.160, -4.239, -2.033> <1.238, -4.239, -1.955> <1.331, -4.239, -1.955> 
		<1.160, -4.239, -2.126> <1.160, -4.239, -2.126> <1.238, -4.239, -2.058> <1.331, -4.239, -2.058> 
		<1.160, -4.239, -2.126> <1.160, -4.239, -2.126> <1.238, -4.239, -2.195> <1.331, -4.239, -2.195> 
		<1.160, -4.239, -2.126> <1.160, -4.239, -2.219> <1.238, -4.239, -2.297> <1.331, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, -4.239, -1.955> <1.424, -4.239, -1.955> <1.502, -4.239, -2.033> <1.502, -4.239, -2.126> 
		<1.331, -4.239, -1.955> <1.424, -4.239, -2.058> <1.502, -4.239, -2.126> <1.502, -4.239, -2.219> 
		<1.331, -4.239, -1.955> <1.424, -4.239, -2.058> <1.424, -4.239, -2.195> <1.424, -4.239, -2.297> 
		<1.331, -4.239, -1.955> <1.331, -4.239, -2.058> <1.331, -4.239, -2.195> <1.331, -4.239, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.160, -2.569, -2.126> <1.160, -2.569, -2.033> <1.238, -2.569, -1.955> <1.331, -2.569, -1.955> 
		<1.160, -2.569, -2.126> <1.160, -2.569, -2.126> <1.238, -2.569, -2.058> <1.331, -2.569, -2.058> 
		<1.160, -2.569, -2.126> <1.160, -2.569, -2.126> <1.238, -2.569, -2.195> <1.331, -2.569, -2.195> 
		<1.160, -2.569, -2.126> <1.160, -2.569, -2.219> <1.238, -2.569, -2.297> <1.331, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, -2.569, -1.955> <1.424, -2.569, -1.955> <1.502, -2.569, -2.033> <1.502, -2.569, -2.126> 
		<1.331, -2.569, -1.955> <1.424, -2.569, -2.058> <1.502, -2.569, -2.126> <1.502, -2.569, -2.219> 
		<1.331, -2.569, -1.955> <1.424, -2.569, -2.058> <1.424, -2.569, -2.195> <1.424, -2.569, -2.297> 
		<1.331, -2.569, -1.955> <1.331, -2.569, -2.058> <1.331, -2.569, -2.195> <1.331, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.856, -4.239, 2.099> <-2.856, -4.239, 2.192> <-2.778, -4.239, 2.270> <-2.685, -4.239, 2.270> 
		<-2.856, -4.239, 2.099> <-2.856, -4.239, 2.099> <-2.778, -4.239, 2.167> <-2.685, -4.239, 2.167> 
		<-2.856, -4.239, 2.099> <-2.856, -4.239, 2.099> <-2.778, -4.239, 2.031> <-2.685, -4.239, 2.031> 
		<-2.856, -4.239, 2.099> <-2.856, -4.239, 2.006> <-2.778, -4.239, 1.928> <-2.685, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.685, -4.239, 2.270> <-2.592, -4.239, 2.270> <-2.514, -4.239, 2.192> <-2.514, -4.239, 2.099> 
		<-2.685, -4.239, 2.270> <-2.592, -4.239, 2.167> <-2.514, -4.239, 2.099> <-2.514, -4.239, 2.006> 
		<-2.685, -4.239, 2.270> <-2.592, -4.239, 2.167> <-2.592, -4.239, 2.031> <-2.592, -4.239, 1.928> 
		<-2.685, -4.239, 2.270> <-2.685, -4.239, 2.167> <-2.685, -4.239, 2.031> <-2.685, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.856, -2.569, 2.099> <-2.856, -2.569, 2.192> <-2.778, -2.569, 2.270> <-2.685, -2.569, 2.270> 
		<-2.856, -2.569, 2.099> <-2.856, -2.569, 2.099> <-2.778, -2.569, 2.167> <-2.685, -2.569, 2.167> 
		<-2.856, -2.569, 2.099> <-2.856, -2.569, 2.099> <-2.778, -2.569, 2.031> <-2.685, -2.569, 2.031> 
		<-2.856, -2.569, 2.099> <-2.856, -2.569, 2.006> <-2.778, -2.569, 1.928> <-2.685, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.685, -2.569, 2.270> <-2.592, -2.569, 2.270> <-2.514, -2.569, 2.192> <-2.514, -2.569, 2.099> 
		<-2.685, -2.569, 2.270> <-2.592, -2.569, 2.167> <-2.514, -2.569, 2.099> <-2.514, -2.569, 2.006> 
		<-2.685, -2.569, 2.270> <-2.592, -2.569, 2.167> <-2.592, -2.569, 2.031> <-2.592, -2.569, 1.928> 
		<-2.685, -2.569, 2.270> <-2.685, -2.569, 2.167> <-2.685, -2.569, 2.031> <-2.685, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.454, -4.239, 2.099> <2.454, -4.239, 2.192> <2.532, -4.239, 2.270> <2.625, -4.239, 2.270> 
		<2.454, -4.239, 2.099> <2.454, -4.239, 2.099> <2.532, -4.239, 2.167> <2.625, -4.239, 2.167> 
		<2.454, -4.239, 2.099> <2.454, -4.239, 2.099> <2.532, -4.239, 2.031> <2.625, -4.239, 2.031> 
		<2.454, -4.239, 2.099> <2.454, -4.239, 2.006> <2.532, -4.239, 1.928> <2.625, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.625, -4.239, 2.270> <2.718, -4.239, 2.270> <2.796, -4.239, 2.192> <2.796, -4.239, 2.099> 
		<2.625, -4.239, 2.270> <2.718, -4.239, 2.167> <2.796, -4.239, 2.099> <2.796, -4.239, 2.006> 
		<2.625, -4.239, 2.270> <2.718, -4.239, 2.167> <2.718, -4.239, 2.031> <2.718, -4.239, 1.928> 
		<2.625, -4.239, 2.270> <2.625, -4.239, 2.167> <2.625, -4.239, 2.031> <2.625, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.454, -2.569, 2.099> <2.454, -2.569, 2.192> <2.532, -2.569, 2.270> <2.625, -2.569, 2.270> 
		<2.454, -2.569, 2.099> <2.454, -2.569, 2.099> <2.532, -2.569, 2.167> <2.625, -2.569, 2.167> 
		<2.454, -2.569, 2.099> <2.454, -2.569, 2.099> <2.532, -2.569, 2.031> <2.625, -2.569, 2.031> 
		<2.454, -2.569, 2.099> <2.454, -2.569, 2.006> <2.532, -2.569, 1.928> <2.625, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.625, -2.569, 2.270> <2.718, -2.569, 2.270> <2.796, -2.569, 2.192> <2.796, -2.569, 2.099> 
		<2.625, -2.569, 2.270> <2.718, -2.569, 2.167> <2.796, -2.569, 2.099> <2.796, -2.569, 2.006> 
		<2.625, -2.569, 2.270> <2.718, -2.569, 2.167> <2.718, -2.569, 2.031> <2.718, -2.569, 1.928> 
		<2.625, -2.569, 2.270> <2.625, -2.569, 2.167> <2.625, -2.569, 2.031> <2.625, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, -4.239, 2.099> <-0.210, -4.239, 2.192> <-0.133, -4.239, 2.270> <-0.039, -4.239, 2.270> 
		<-0.210, -4.239, 2.099> <-0.210, -4.239, 2.099> <-0.133, -4.239, 2.167> <-0.039, -4.239, 2.167> 
		<-0.210, -4.239, 2.099> <-0.210, -4.239, 2.099> <-0.133, -4.239, 2.031> <-0.039, -4.239, 2.031> 
		<-0.210, -4.239, 2.099> <-0.210, -4.239, 2.006> <-0.133, -4.239, 1.928> <-0.039, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, -4.239, 2.270> <0.054, -4.239, 2.270> <0.131, -4.239, 2.192> <0.131, -4.239, 2.099> 
		<-0.039, -4.239, 2.270> <0.054, -4.239, 2.167> <0.131, -4.239, 2.099> <0.131, -4.239, 2.006> 
		<-0.039, -4.239, 2.270> <0.054, -4.239, 2.167> <0.054, -4.239, 2.031> <0.054, -4.239, 1.928> 
		<-0.039, -4.239, 2.270> <-0.039, -4.239, 2.167> <-0.039, -4.239, 2.031> <-0.039, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, -2.569, 2.099> <-0.210, -2.569, 2.192> <-0.133, -2.569, 2.270> <-0.039, -2.569, 2.270> 
		<-0.210, -2.569, 2.099> <-0.210, -2.569, 2.099> <-0.133, -2.569, 2.167> <-0.039, -2.569, 2.167> 
		<-0.210, -2.569, 2.099> <-0.210, -2.569, 2.099> <-0.133, -2.569, 2.031> <-0.039, -2.569, 2.031> 
		<-0.210, -2.569, 2.099> <-0.210, -2.569, 2.006> <-0.133, -2.569, 1.928> <-0.039, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, -2.569, 2.270> <0.054, -2.569, 2.270> <0.131, -2.569, 2.192> <0.131, -2.569, 2.099> 
		<-0.039, -2.569, 2.270> <0.054, -2.569, 2.167> <0.131, -2.569, 2.099> <0.131, -2.569, 2.006> 
		<-0.039, -2.569, 2.270> <0.054, -2.569, 2.167> <0.054, -2.569, 2.031> <0.054, -2.569, 1.928> 
		<-0.039, -2.569, 2.270> <-0.039, -2.569, 2.167> <-0.039, -2.569, 2.031> <-0.039, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.543, -4.239, 2.099> <-1.543, -4.239, 2.192> <-1.465, -4.239, 2.270> <-1.372, -4.239, 2.270> 
		<-1.543, -4.239, 2.099> <-1.543, -4.239, 2.099> <-1.465, -4.239, 2.167> <-1.372, -4.239, 2.167> 
		<-1.543, -4.239, 2.099> <-1.543, -4.239, 2.099> <-1.465, -4.239, 2.031> <-1.372, -4.239, 2.031> 
		<-1.543, -4.239, 2.099> <-1.543, -4.239, 2.006> <-1.465, -4.239, 1.928> <-1.372, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.372, -4.239, 2.270> <-1.278, -4.239, 2.270> <-1.201, -4.239, 2.192> <-1.201, -4.239, 2.099> 
		<-1.372, -4.239, 2.270> <-1.278, -4.239, 2.167> <-1.201, -4.239, 2.099> <-1.201, -4.239, 2.006> 
		<-1.372, -4.239, 2.270> <-1.278, -4.239, 2.167> <-1.278, -4.239, 2.031> <-1.278, -4.239, 1.928> 
		<-1.372, -4.239, 2.270> <-1.372, -4.239, 2.167> <-1.372, -4.239, 2.031> <-1.372, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.543, -2.569, 2.099> <-1.543, -2.569, 2.192> <-1.465, -2.569, 2.270> <-1.372, -2.569, 2.270> 
		<-1.543, -2.569, 2.099> <-1.543, -2.569, 2.099> <-1.465, -2.569, 2.167> <-1.372, -2.569, 2.167> 
		<-1.543, -2.569, 2.099> <-1.543, -2.569, 2.099> <-1.465, -2.569, 2.031> <-1.372, -2.569, 2.031> 
		<-1.543, -2.569, 2.099> <-1.543, -2.569, 2.006> <-1.465, -2.569, 1.928> <-1.372, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.372, -2.569, 2.270> <-1.278, -2.569, 2.270> <-1.201, -2.569, 2.192> <-1.201, -2.569, 2.099> 
		<-1.372, -2.569, 2.270> <-1.278, -2.569, 2.167> <-1.201, -2.569, 2.099> <-1.201, -2.569, 2.006> 
		<-1.372, -2.569, 2.270> <-1.278, -2.569, 2.167> <-1.278, -2.569, 2.031> <-1.278, -2.569, 1.928> 
		<-1.372, -2.569, 2.270> <-1.372, -2.569, 2.167> <-1.372, -2.569, 2.031> <-1.372, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.122, -4.239, 2.099> <1.122, -4.239, 2.192> <1.200, -4.239, 2.270> <1.293, -4.239, 2.270> 
		<1.122, -4.239, 2.099> <1.122, -4.239, 2.099> <1.200, -4.239, 2.167> <1.293, -4.239, 2.167> 
		<1.122, -4.239, 2.099> <1.122, -4.239, 2.099> <1.200, -4.239, 2.031> <1.293, -4.239, 2.031> 
		<1.122, -4.239, 2.099> <1.122, -4.239, 2.006> <1.200, -4.239, 1.928> <1.293, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, -4.239, 2.270> <1.386, -4.239, 2.270> <1.464, -4.239, 2.192> <1.464, -4.239, 2.099> 
		<1.293, -4.239, 2.270> <1.386, -4.239, 2.167> <1.464, -4.239, 2.099> <1.464, -4.239, 2.006> 
		<1.293, -4.239, 2.270> <1.386, -4.239, 2.167> <1.386, -4.239, 2.031> <1.386, -4.239, 1.928> 
		<1.293, -4.239, 2.270> <1.293, -4.239, 2.167> <1.293, -4.239, 2.031> <1.293, -4.239, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.122, -2.569, 2.099> <1.122, -2.569, 2.192> <1.200, -2.569, 2.270> <1.293, -2.569, 2.270> 
		<1.122, -2.569, 2.099> <1.122, -2.569, 2.099> <1.200, -2.569, 2.167> <1.293, -2.569, 2.167> 
		<1.122, -2.569, 2.099> <1.122, -2.569, 2.099> <1.200, -2.569, 2.031> <1.293, -2.569, 2.031> 
		<1.122, -2.569, 2.099> <1.122, -2.569, 2.006> <1.200, -2.569, 1.928> <1.293, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, -2.569, 2.270> <1.386, -2.569, 2.270> <1.464, -2.569, 2.192> <1.464, -2.569, 2.099> 
		<1.293, -2.569, 2.270> <1.386, -2.569, 2.167> <1.464, -2.569, 2.099> <1.464, -2.569, 2.006> 
		<1.293, -2.569, 2.270> <1.386, -2.569, 2.167> <1.386, -2.569, 2.031> <1.386, -2.569, 1.928> 
		<1.293, -2.569, 2.270> <1.293, -2.569, 2.167> <1.293, -2.569, 2.031> <1.293, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.647, -4.239, -1.955> <-2.554, -4.239, -1.955> <-2.476, -4.239, -2.033> <-2.476, -4.239, -2.126> 
		<-2.647, -3.738, -1.955> <-2.554, -3.738, -1.955> <-2.476, -3.738, -2.033> <-2.476, -3.738, -2.126> 
		<-2.647, -3.070, -1.955> <-2.554, -3.070, -1.955> <-2.476, -3.070, -2.033> <-2.476, -3.070, -2.126> 
		<-2.647, -2.569, -1.955> <-2.554, -2.569, -1.955> <-2.476, -2.569, -2.033> <-2.476, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.476, -4.239, -2.126> <-2.476, -4.239, -2.219> <-2.554, -4.239, -2.297> <-2.647, -4.239, -2.297> 
		<-2.476, -3.738, -2.126> <-2.476, -3.738, -2.219> <-2.554, -3.738, -2.297> <-2.647, -3.738, -2.297> 
		<-2.476, -3.070, -2.126> <-2.476, -3.070, -2.219> <-2.554, -3.070, -2.297> <-2.647, -3.070, -2.297> 
		<-2.476, -2.569, -2.126> <-2.476, -2.569, -2.219> <-2.554, -2.569, -2.297> <-2.647, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.647, -4.239, -2.297> <-2.740, -4.239, -2.297> <-2.818, -4.239, -2.219> <-2.818, -4.239, -2.126> 
		<-2.647, -3.738, -2.297> <-2.740, -3.738, -2.297> <-2.818, -3.738, -2.219> <-2.818, -3.738, -2.126> 
		<-2.647, -3.070, -2.297> <-2.740, -3.070, -2.297> <-2.818, -3.070, -2.219> <-2.818, -3.070, -2.126> 
		<-2.647, -2.569, -2.297> <-2.740, -2.569, -2.297> <-2.818, -2.569, -2.219> <-2.818, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.818, -2.569, -2.126> <-2.818, -2.569, -2.033> <-2.740, -2.569, -1.955> <-2.647, -2.569, -1.955> 
		<-2.818, -3.070, -2.126> <-2.818, -3.070, -2.033> <-2.740, -3.070, -1.955> <-2.647, -3.070, -1.955> 
		<-2.818, -3.738, -2.126> <-2.818, -3.738, -2.033> <-2.740, -3.738, -1.955> <-2.647, -3.738, -1.955> 
		<-2.818, -4.239, -2.126> <-2.818, -4.239, -2.033> <-2.740, -4.239, -1.955> <-2.647, -4.239, -1.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.663, -4.239, -1.955> <2.756, -4.239, -1.955> <2.834, -4.239, -2.033> <2.834, -4.239, -2.126> 
		<2.663, -3.738, -1.955> <2.756, -3.738, -1.955> <2.834, -3.738, -2.033> <2.834, -3.738, -2.126> 
		<2.663, -3.070, -1.955> <2.756, -3.070, -1.955> <2.834, -3.070, -2.033> <2.834, -3.070, -2.126> 
		<2.663, -2.569, -1.955> <2.756, -2.569, -1.955> <2.834, -2.569, -2.033> <2.834, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.834, -4.239, -2.126> <2.834, -4.239, -2.219> <2.756, -4.239, -2.297> <2.663, -4.239, -2.297> 
		<2.834, -3.738, -2.126> <2.834, -3.738, -2.219> <2.756, -3.738, -2.297> <2.663, -3.738, -2.297> 
		<2.834, -3.070, -2.126> <2.834, -3.070, -2.219> <2.756, -3.070, -2.297> <2.663, -3.070, -2.297> 
		<2.834, -2.569, -2.126> <2.834, -2.569, -2.219> <2.756, -2.569, -2.297> <2.663, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.663, -4.239, -2.297> <2.570, -4.239, -2.297> <2.492, -4.239, -2.219> <2.492, -4.239, -2.126> 
		<2.663, -3.738, -2.297> <2.570, -3.738, -2.297> <2.492, -3.738, -2.219> <2.492, -3.738, -2.126> 
		<2.663, -3.070, -2.297> <2.570, -3.070, -2.297> <2.492, -3.070, -2.219> <2.492, -3.070, -2.126> 
		<2.663, -2.569, -2.297> <2.570, -2.569, -2.297> <2.492, -2.569, -2.219> <2.492, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.492, -2.569, -2.126> <2.492, -2.569, -2.033> <2.570, -2.569, -1.955> <2.663, -2.569, -1.955> 
		<2.492, -3.070, -2.126> <2.492, -3.070, -2.033> <2.570, -3.070, -1.955> <2.663, -3.070, -1.955> 
		<2.492, -3.738, -2.126> <2.492, -3.738, -2.033> <2.570, -3.738, -1.955> <2.663, -3.738, -1.955> 
		<2.492, -4.239, -2.126> <2.492, -4.239, -2.033> <2.570, -4.239, -1.955> <2.663, -4.239, -1.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, -4.239, -1.955> <0.092, -4.239, -1.955> <0.170, -4.239, -2.033> <0.170, -4.239, -2.126> 
		<-0.001, -3.738, -1.955> <0.092, -3.738, -1.955> <0.170, -3.738, -2.033> <0.170, -3.738, -2.126> 
		<-0.001, -3.070, -1.955> <0.092, -3.070, -1.955> <0.170, -3.070, -2.033> <0.170, -3.070, -2.126> 
		<-0.001, -2.569, -1.955> <0.092, -2.569, -1.955> <0.170, -2.569, -2.033> <0.170, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, -4.239, -2.126> <0.170, -4.239, -2.219> <0.092, -4.239, -2.297> <-0.001, -4.239, -2.297> 
		<0.170, -3.738, -2.126> <0.170, -3.738, -2.219> <0.092, -3.738, -2.297> <-0.001, -3.738, -2.297> 
		<0.170, -3.070, -2.126> <0.170, -3.070, -2.219> <0.092, -3.070, -2.297> <-0.001, -3.070, -2.297> 
		<0.170, -2.569, -2.126> <0.170, -2.569, -2.219> <0.092, -2.569, -2.297> <-0.001, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, -4.239, -2.297> <-0.095, -4.239, -2.297> <-0.172, -4.239, -2.219> <-0.172, -4.239, -2.126> 
		<-0.001, -3.738, -2.297> <-0.095, -3.738, -2.297> <-0.172, -3.738, -2.219> <-0.172, -3.738, -2.126> 
		<-0.001, -3.070, -2.297> <-0.095, -3.070, -2.297> <-0.172, -3.070, -2.219> <-0.172, -3.070, -2.126> 
		<-0.001, -2.569, -2.297> <-0.095, -2.569, -2.297> <-0.172, -2.569, -2.219> <-0.172, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, -2.569, -2.126> <-0.172, -2.569, -2.033> <-0.095, -2.569, -1.955> <-0.001, -2.569, -1.955> 
		<-0.172, -3.070, -2.126> <-0.172, -3.070, -2.033> <-0.095, -3.070, -1.955> <-0.001, -3.070, -1.955> 
		<-0.172, -3.738, -2.126> <-0.172, -3.738, -2.033> <-0.095, -3.738, -1.955> <-0.001, -3.738, -1.955> 
		<-0.172, -4.239, -2.126> <-0.172, -4.239, -2.033> <-0.095, -4.239, -1.955> <-0.001, -4.239, -1.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.334, -4.239, -1.955> <-1.240, -4.239, -1.955> <-1.163, -4.239, -2.033> <-1.163, -4.239, -2.126> 
		<-1.334, -3.738, -1.955> <-1.240, -3.738, -1.955> <-1.163, -3.738, -2.033> <-1.163, -3.738, -2.126> 
		<-1.334, -3.070, -1.955> <-1.240, -3.070, -1.955> <-1.163, -3.070, -2.033> <-1.163, -3.070, -2.126> 
		<-1.334, -2.569, -1.955> <-1.240, -2.569, -1.955> <-1.163, -2.569, -2.033> <-1.163, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.163, -4.239, -2.126> <-1.163, -4.239, -2.219> <-1.240, -4.239, -2.297> <-1.334, -4.239, -2.297> 
		<-1.163, -3.738, -2.126> <-1.163, -3.738, -2.219> <-1.240, -3.738, -2.297> <-1.334, -3.738, -2.297> 
		<-1.163, -3.070, -2.126> <-1.163, -3.070, -2.219> <-1.240, -3.070, -2.297> <-1.334, -3.070, -2.297> 
		<-1.163, -2.569, -2.126> <-1.163, -2.569, -2.219> <-1.240, -2.569, -2.297> <-1.334, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.334, -4.239, -2.297> <-1.427, -4.239, -2.297> <-1.505, -4.239, -2.219> <-1.505, -4.239, -2.126> 
		<-1.334, -3.738, -2.297> <-1.427, -3.738, -2.297> <-1.505, -3.738, -2.219> <-1.505, -3.738, -2.126> 
		<-1.334, -3.070, -2.297> <-1.427, -3.070, -2.297> <-1.505, -3.070, -2.219> <-1.505, -3.070, -2.126> 
		<-1.334, -2.569, -2.297> <-1.427, -2.569, -2.297> <-1.505, -2.569, -2.219> <-1.505, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.505, -2.569, -2.126> <-1.505, -2.569, -2.033> <-1.427, -2.569, -1.955> <-1.334, -2.569, -1.955> 
		<-1.505, -3.070, -2.126> <-1.505, -3.070, -2.033> <-1.427, -3.070, -1.955> <-1.334, -3.070, -1.955> 
		<-1.505, -3.738, -2.126> <-1.505, -3.738, -2.033> <-1.427, -3.738, -1.955> <-1.334, -3.738, -1.955> 
		<-1.505, -4.239, -2.126> <-1.505, -4.239, -2.033> <-1.427, -4.239, -1.955> <-1.334, -4.239, -1.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, -4.239, -1.955> <1.424, -4.239, -1.955> <1.502, -4.239, -2.033> <1.502, -4.239, -2.126> 
		<1.331, -3.738, -1.955> <1.424, -3.738, -1.955> <1.502, -3.738, -2.033> <1.502, -3.738, -2.126> 
		<1.331, -3.070, -1.955> <1.424, -3.070, -1.955> <1.502, -3.070, -2.033> <1.502, -3.070, -2.126> 
		<1.331, -2.569, -1.955> <1.424, -2.569, -1.955> <1.502, -2.569, -2.033> <1.502, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.502, -4.239, -2.126> <1.502, -4.239, -2.219> <1.424, -4.239, -2.297> <1.331, -4.239, -2.297> 
		<1.502, -3.738, -2.126> <1.502, -3.738, -2.219> <1.424, -3.738, -2.297> <1.331, -3.738, -2.297> 
		<1.502, -3.070, -2.126> <1.502, -3.070, -2.219> <1.424, -3.070, -2.297> <1.331, -3.070, -2.297> 
		<1.502, -2.569, -2.126> <1.502, -2.569, -2.219> <1.424, -2.569, -2.297> <1.331, -2.569, -2.297> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, -4.239, -2.297> <1.238, -4.239, -2.297> <1.160, -4.239, -2.219> <1.160, -4.239, -2.126> 
		<1.331, -3.738, -2.297> <1.238, -3.738, -2.297> <1.160, -3.738, -2.219> <1.160, -3.738, -2.126> 
		<1.331, -3.070, -2.297> <1.238, -3.070, -2.297> <1.160, -3.070, -2.219> <1.160, -3.070, -2.126> 
		<1.331, -2.569, -2.297> <1.238, -2.569, -2.297> <1.160, -2.569, -2.219> <1.160, -2.569, -2.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.160, -2.569, -2.126> <1.160, -2.569, -2.033> <1.238, -2.569, -1.955> <1.331, -2.569, -1.955> 
		<1.160, -3.070, -2.126> <1.160, -3.070, -2.033> <1.238, -3.070, -1.955> <1.331, -3.070, -1.955> 
		<1.160, -3.738, -2.126> <1.160, -3.738, -2.033> <1.238, -3.738, -1.955> <1.331, -3.738, -1.955> 
		<1.160, -4.239, -2.126> <1.160, -4.239, -2.033> <1.238, -4.239, -1.955> <1.331, -4.239, -1.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.685, -4.239, 2.270> <-2.592, -4.239, 2.270> <-2.514, -4.239, 2.192> <-2.514, -4.239, 2.099> 
		<-2.685, -3.738, 2.270> <-2.592, -3.738, 2.270> <-2.514, -3.738, 2.192> <-2.514, -3.738, 2.099> 
		<-2.685, -3.070, 2.270> <-2.592, -3.070, 2.270> <-2.514, -3.070, 2.192> <-2.514, -3.070, 2.099> 
		<-2.685, -2.569, 2.270> <-2.592, -2.569, 2.270> <-2.514, -2.569, 2.192> <-2.514, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.514, -4.239, 2.099> <-2.514, -4.239, 2.006> <-2.592, -4.239, 1.928> <-2.685, -4.239, 1.928> 
		<-2.514, -3.738, 2.099> <-2.514, -3.738, 2.006> <-2.592, -3.738, 1.928> <-2.685, -3.738, 1.928> 
		<-2.514, -3.070, 2.099> <-2.514, -3.070, 2.006> <-2.592, -3.070, 1.928> <-2.685, -3.070, 1.928> 
		<-2.514, -2.569, 2.099> <-2.514, -2.569, 2.006> <-2.592, -2.569, 1.928> <-2.685, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.685, -4.239, 1.928> <-2.778, -4.239, 1.928> <-2.856, -4.239, 2.006> <-2.856, -4.239, 2.099> 
		<-2.685, -3.738, 1.928> <-2.778, -3.738, 1.928> <-2.856, -3.738, 2.006> <-2.856, -3.738, 2.099> 
		<-2.685, -3.070, 1.928> <-2.778, -3.070, 1.928> <-2.856, -3.070, 2.006> <-2.856, -3.070, 2.099> 
		<-2.685, -2.569, 1.928> <-2.778, -2.569, 1.928> <-2.856, -2.569, 2.006> <-2.856, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.856, -2.569, 2.099> <-2.856, -2.569, 2.192> <-2.778, -2.569, 2.270> <-2.685, -2.569, 2.270> 
		<-2.856, -3.070, 2.099> <-2.856, -3.070, 2.192> <-2.778, -3.070, 2.270> <-2.685, -3.070, 2.270> 
		<-2.856, -3.738, 2.099> <-2.856, -3.738, 2.192> <-2.778, -3.738, 2.270> <-2.685, -3.738, 2.270> 
		<-2.856, -4.239, 2.099> <-2.856, -4.239, 2.192> <-2.778, -4.239, 2.270> <-2.685, -4.239, 2.270> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.625, -4.239, 2.270> <2.718, -4.239, 2.270> <2.796, -4.239, 2.192> <2.796, -4.239, 2.099> 
		<2.625, -3.738, 2.270> <2.718, -3.738, 2.270> <2.796, -3.738, 2.192> <2.796, -3.738, 2.099> 
		<2.625, -3.070, 2.270> <2.718, -3.070, 2.270> <2.796, -3.070, 2.192> <2.796, -3.070, 2.099> 
		<2.625, -2.569, 2.270> <2.718, -2.569, 2.270> <2.796, -2.569, 2.192> <2.796, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.796, -4.239, 2.099> <2.796, -4.239, 2.006> <2.718, -4.239, 1.928> <2.625, -4.239, 1.928> 
		<2.796, -3.738, 2.099> <2.796, -3.738, 2.006> <2.718, -3.738, 1.928> <2.625, -3.738, 1.928> 
		<2.796, -3.070, 2.099> <2.796, -3.070, 2.006> <2.718, -3.070, 1.928> <2.625, -3.070, 1.928> 
		<2.796, -2.569, 2.099> <2.796, -2.569, 2.006> <2.718, -2.569, 1.928> <2.625, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.625, -4.239, 1.928> <2.532, -4.239, 1.928> <2.454, -4.239, 2.006> <2.454, -4.239, 2.099> 
		<2.625, -3.738, 1.928> <2.532, -3.738, 1.928> <2.454, -3.738, 2.006> <2.454, -3.738, 2.099> 
		<2.625, -3.070, 1.928> <2.532, -3.070, 1.928> <2.454, -3.070, 2.006> <2.454, -3.070, 2.099> 
		<2.625, -2.569, 1.928> <2.532, -2.569, 1.928> <2.454, -2.569, 2.006> <2.454, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.454, -2.569, 2.099> <2.454, -2.569, 2.192> <2.532, -2.569, 2.270> <2.625, -2.569, 2.270> 
		<2.454, -3.070, 2.099> <2.454, -3.070, 2.192> <2.532, -3.070, 2.270> <2.625, -3.070, 2.270> 
		<2.454, -3.738, 2.099> <2.454, -3.738, 2.192> <2.532, -3.738, 2.270> <2.625, -3.738, 2.270> 
		<2.454, -4.239, 2.099> <2.454, -4.239, 2.192> <2.532, -4.239, 2.270> <2.625, -4.239, 2.270> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, -4.239, 2.270> <0.054, -4.239, 2.270> <0.131, -4.239, 2.192> <0.131, -4.239, 2.099> 
		<-0.039, -3.738, 2.270> <0.054, -3.738, 2.270> <0.131, -3.738, 2.192> <0.131, -3.738, 2.099> 
		<-0.039, -3.070, 2.270> <0.054, -3.070, 2.270> <0.131, -3.070, 2.192> <0.131, -3.070, 2.099> 
		<-0.039, -2.569, 2.270> <0.054, -2.569, 2.270> <0.131, -2.569, 2.192> <0.131, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.131, -4.239, 2.099> <0.131, -4.239, 2.006> <0.054, -4.239, 1.928> <-0.039, -4.239, 1.928> 
		<0.131, -3.738, 2.099> <0.131, -3.738, 2.006> <0.054, -3.738, 1.928> <-0.039, -3.738, 1.928> 
		<0.131, -3.070, 2.099> <0.131, -3.070, 2.006> <0.054, -3.070, 1.928> <-0.039, -3.070, 1.928> 
		<0.131, -2.569, 2.099> <0.131, -2.569, 2.006> <0.054, -2.569, 1.928> <-0.039, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, -4.239, 1.928> <-0.133, -4.239, 1.928> <-0.210, -4.239, 2.006> <-0.210, -4.239, 2.099> 
		<-0.039, -3.738, 1.928> <-0.133, -3.738, 1.928> <-0.210, -3.738, 2.006> <-0.210, -3.738, 2.099> 
		<-0.039, -3.070, 1.928> <-0.133, -3.070, 1.928> <-0.210, -3.070, 2.006> <-0.210, -3.070, 2.099> 
		<-0.039, -2.569, 1.928> <-0.133, -2.569, 1.928> <-0.210, -2.569, 2.006> <-0.210, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, -2.569, 2.099> <-0.210, -2.569, 2.192> <-0.133, -2.569, 2.270> <-0.039, -2.569, 2.270> 
		<-0.210, -3.070, 2.099> <-0.210, -3.070, 2.192> <-0.133, -3.070, 2.270> <-0.039, -3.070, 2.270> 
		<-0.210, -3.738, 2.099> <-0.210, -3.738, 2.192> <-0.133, -3.738, 2.270> <-0.039, -3.738, 2.270> 
		<-0.210, -4.239, 2.099> <-0.210, -4.239, 2.192> <-0.133, -4.239, 2.270> <-0.039, -4.239, 2.270> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.372, -4.239, 2.270> <-1.278, -4.239, 2.270> <-1.201, -4.239, 2.192> <-1.201, -4.239, 2.099> 
		<-1.372, -3.738, 2.270> <-1.278, -3.738, 2.270> <-1.201, -3.738, 2.192> <-1.201, -3.738, 2.099> 
		<-1.372, -3.070, 2.270> <-1.278, -3.070, 2.270> <-1.201, -3.070, 2.192> <-1.201, -3.070, 2.099> 
		<-1.372, -2.569, 2.270> <-1.278, -2.569, 2.270> <-1.201, -2.569, 2.192> <-1.201, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.201, -4.239, 2.099> <-1.201, -4.239, 2.006> <-1.278, -4.239, 1.928> <-1.372, -4.239, 1.928> 
		<-1.201, -3.738, 2.099> <-1.201, -3.738, 2.006> <-1.278, -3.738, 1.928> <-1.372, -3.738, 1.928> 
		<-1.201, -3.070, 2.099> <-1.201, -3.070, 2.006> <-1.278, -3.070, 1.928> <-1.372, -3.070, 1.928> 
		<-1.201, -2.569, 2.099> <-1.201, -2.569, 2.006> <-1.278, -2.569, 1.928> <-1.372, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.372, -4.239, 1.928> <-1.465, -4.239, 1.928> <-1.543, -4.239, 2.006> <-1.543, -4.239, 2.099> 
		<-1.372, -3.738, 1.928> <-1.465, -3.738, 1.928> <-1.543, -3.738, 2.006> <-1.543, -3.738, 2.099> 
		<-1.372, -3.070, 1.928> <-1.465, -3.070, 1.928> <-1.543, -3.070, 2.006> <-1.543, -3.070, 2.099> 
		<-1.372, -2.569, 1.928> <-1.465, -2.569, 1.928> <-1.543, -2.569, 2.006> <-1.543, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.543, -2.569, 2.099> <-1.543, -2.569, 2.192> <-1.465, -2.569, 2.270> <-1.372, -2.569, 2.270> 
		<-1.543, -3.070, 2.099> <-1.543, -3.070, 2.192> <-1.465, -3.070, 2.270> <-1.372, -3.070, 2.270> 
		<-1.543, -3.738, 2.099> <-1.543, -3.738, 2.192> <-1.465, -3.738, 2.270> <-1.372, -3.738, 2.270> 
		<-1.543, -4.239, 2.099> <-1.543, -4.239, 2.192> <-1.465, -4.239, 2.270> <-1.372, -4.239, 2.270> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, -4.239, 2.270> <1.386, -4.239, 2.270> <1.464, -4.239, 2.192> <1.464, -4.239, 2.099> 
		<1.293, -3.738, 2.270> <1.386, -3.738, 2.270> <1.464, -3.738, 2.192> <1.464, -3.738, 2.099> 
		<1.293, -3.070, 2.270> <1.386, -3.070, 2.270> <1.464, -3.070, 2.192> <1.464, -3.070, 2.099> 
		<1.293, -2.569, 2.270> <1.386, -2.569, 2.270> <1.464, -2.569, 2.192> <1.464, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.464, -4.239, 2.099> <1.464, -4.239, 2.006> <1.386, -4.239, 1.928> <1.293, -4.239, 1.928> 
		<1.464, -3.738, 2.099> <1.464, -3.738, 2.006> <1.386, -3.738, 1.928> <1.293, -3.738, 1.928> 
		<1.464, -3.070, 2.099> <1.464, -3.070, 2.006> <1.386, -3.070, 1.928> <1.293, -3.070, 1.928> 
		<1.464, -2.569, 2.099> <1.464, -2.569, 2.006> <1.386, -2.569, 1.928> <1.293, -2.569, 1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, -4.239, 1.928> <1.200, -4.239, 1.928> <1.122, -4.239, 2.006> <1.122, -4.239, 2.099> 
		<1.293, -3.738, 1.928> <1.200, -3.738, 1.928> <1.122, -3.738, 2.006> <1.122, -3.738, 2.099> 
		<1.293, -3.070, 1.928> <1.200, -3.070, 1.928> <1.122, -3.070, 2.006> <1.122, -3.070, 2.099> 
		<1.293, -2.569, 1.928> <1.200, -2.569, 1.928> <1.122, -2.569, 2.006> <1.122, -2.569, 2.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.122, -2.569, 2.099> <1.122, -2.569, 2.192> <1.200, -2.569, 2.270> <1.293, -2.569, 2.270> 
		<1.122, -3.070, 2.099> <1.122, -3.070, 2.192> <1.200, -3.070, 2.270> <1.293, -3.070, 2.270> 
		<1.122, -3.738, 2.099> <1.122, -3.738, 2.192> <1.200, -3.738, 2.270> <1.293, -3.738, 2.270> 
		<1.122, -4.239, 2.099> <1.122, -4.239, 2.192> <1.200, -4.239, 2.270> <1.293, -4.239, 2.270> 
	}
	pigment{DarkWood}
	finish{ambient 0.4 diffuse 0.4}

}

/*
//patch_obj_05
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -2.835, -1.022> <-2.782, -2.835, -0.929> <-2.782, -2.913, -0.851> <-2.782, -3.006, -0.851> 
		<-2.782, -2.835, -1.022> <-2.782, -2.835, -1.022> <-2.782, -2.913, -0.954> <-2.782, -3.006, -0.954> 
		<-2.782, -2.835, -1.022> <-2.782, -2.835, -1.022> <-2.782, -2.913, -1.091> <-2.782, -3.006, -1.091> 
		<-2.782, -2.835, -1.022> <-2.782, -2.835, -1.116> <-2.782, -2.913, -1.193> <-2.782, -3.006, -1.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -3.006, -0.851> <-2.782, -3.099, -0.851> <-2.782, -3.177, -0.929> <-2.782, -3.177, -1.022> 
		<-2.782, -3.006, -0.851> <-2.782, -3.099, -0.954> <-2.782, -3.177, -1.022> <-2.782, -3.177, -1.116> 
		<-2.782, -3.006, -0.851> <-2.782, -3.099, -0.954> <-2.782, -3.099, -1.091> <-2.782, -3.099, -1.193> 
		<-2.782, -3.006, -0.851> <-2.782, -3.006, -0.954> <-2.782, -3.006, -1.091> <-2.782, -3.006, -1.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.765, -2.863, -1.022> <7.765, -2.863, -0.929> <7.765, -2.941, -0.851> <7.765, -3.034, -0.851> 
		<7.765, -2.863, -1.022> <7.765, -2.863, -1.022> <7.765, -2.941, -0.954> <7.765, -3.034, -0.954> 
		<7.765, -2.863, -1.022> <7.765, -2.863, -1.022> <7.765, -2.941, -1.091> <7.765, -3.034, -1.091> 
		<7.765, -2.863, -1.022> <7.765, -2.863, -1.116> <7.765, -2.941, -1.193> <7.765, -3.034, -1.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.765, -3.034, -0.851> <7.765, -3.128, -0.851> <7.765, -3.205, -0.929> <7.765, -3.205, -1.022> 
		<7.765, -3.034, -0.851> <7.765, -3.128, -0.954> <7.765, -3.205, -1.022> <7.765, -3.205, -1.116> 
		<7.765, -3.034, -0.851> <7.765, -3.128, -0.954> <7.765, -3.128, -1.091> <7.765, -3.128, -1.193> 
		<7.765, -3.034, -0.851> <7.765, -3.034, -0.954> <7.765, -3.034, -1.091> <7.765, -3.034, -1.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -2.815, 1.018> <-2.782, -2.815, 1.112> <-2.782, -2.893, 1.189> <-2.782, -2.986, 1.189> 
		<-2.782, -2.815, 1.018> <-2.782, -2.815, 1.018> <-2.782, -2.893, 1.087> <-2.782, -2.986, 1.087> 
		<-2.782, -2.815, 1.018> <-2.782, -2.815, 1.018> <-2.782, -2.893, 0.950> <-2.782, -2.986, 0.950> 
		<-2.782, -2.815, 1.018> <-2.782, -2.815, 0.925> <-2.782, -2.893, 0.847> <-2.782, -2.986, 0.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -2.986, 1.189> <-2.782, -3.080, 1.189> <-2.782, -3.157, 1.112> <-2.782, -3.157, 1.018> 
		<-2.782, -2.986, 1.189> <-2.782, -3.080, 1.087> <-2.782, -3.157, 1.018> <-2.782, -3.157, 0.925> 
		<-2.782, -2.986, 1.189> <-2.782, -3.080, 1.087> <-2.782, -3.080, 0.950> <-2.782, -3.080, 0.847> 
		<-2.782, -2.986, 1.189> <-2.782, -2.986, 1.087> <-2.782, -2.986, 0.950> <-2.782, -2.986, 0.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.765, -2.844, 1.018> <7.765, -2.844, 1.112> <7.765, -2.921, 1.189> <7.765, -3.015, 1.189> 
		<7.765, -2.844, 1.018> <7.765, -2.844, 1.018> <7.765, -2.921, 1.087> <7.765, -3.015, 1.087> 
		<7.765, -2.844, 1.018> <7.765, -2.844, 1.018> <7.765, -2.921, 0.950> <7.765, -3.015, 0.950> 
		<7.765, -2.844, 1.018> <7.765, -2.844, 0.925> <7.765, -2.921, 0.847> <7.765, -3.015, 0.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.765, -3.015, 1.189> <7.765, -3.108, 1.189> <7.765, -3.186, 1.112> <7.765, -3.186, 1.018> 
		<7.765, -3.015, 1.189> <7.765, -3.108, 1.087> <7.765, -3.186, 1.018> <7.765, -3.186, 0.925> 
		<7.765, -3.015, 1.189> <7.765, -3.108, 1.087> <7.765, -3.108, 0.950> <7.765, -3.108, 0.847> 
		<7.765, -3.015, 1.189> <7.765, -3.015, 1.087> <7.765, -3.015, 0.950> <7.765, -3.015, 0.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -3.006, -0.851> <-2.782, -3.099, -0.851> <-2.782, -3.177, -0.929> <-2.782, -3.177, -1.022> 
		<0.382, -3.014, -0.851> <0.382, -3.108, -0.851> <0.382, -3.185, -0.929> <0.382, -3.185, -1.022> 
		<4.601, -3.026, -0.851> <4.601, -3.119, -0.851> <4.601, -3.197, -0.929> <4.601, -3.197, -1.022> 
		<7.765, -3.034, -0.851> <7.765, -3.128, -0.851> <7.765, -3.205, -0.929> <7.765, -3.205, -1.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -3.177, -1.022> <-2.782, -3.177, -1.116> <-2.782, -3.099, -1.193> <-2.782, -3.006, -1.193> 
		<0.382, -3.185, -1.022> <0.382, -3.185, -1.116> <0.382, -3.108, -1.193> <0.382, -3.014, -1.193> 
		<4.601, -3.197, -1.022> <4.601, -3.197, -1.116> <4.601, -3.119, -1.193> <4.601, -3.026, -1.193> 
		<7.765, -3.205, -1.022> <7.765, -3.205, -1.116> <7.765, -3.128, -1.193> <7.765, -3.034, -1.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -3.006, -1.193> <-2.782, -2.913, -1.193> <-2.782, -2.835, -1.116> <-2.782, -2.835, -1.022> 
		<0.382, -3.014, -1.193> <0.382, -2.921, -1.193> <0.382, -2.844, -1.116> <0.382, -2.844, -1.022> 
		<4.601, -3.026, -1.193> <4.601, -2.933, -1.193> <4.601, -2.855, -1.116> <4.601, -2.855, -1.022> 
		<7.765, -3.034, -1.193> <7.765, -2.941, -1.193> <7.765, -2.863, -1.116> <7.765, -2.863, -1.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.765, -2.863, -1.022> <7.765, -2.863, -0.929> <7.765, -2.941, -0.851> <7.765, -3.034, -0.851> 
		<4.601, -2.855, -1.022> <4.601, -2.855, -0.929> <4.601, -2.933, -0.851> <4.601, -3.026, -0.851> 
		<0.382, -2.844, -1.022> <0.382, -2.844, -0.929> <0.382, -2.921, -0.851> <0.382, -3.014, -0.851> 
		<-2.782, -2.835, -1.022> <-2.782, -2.835, -0.929> <-2.782, -2.913, -0.851> <-2.782, -3.006, -0.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -2.986, 1.189> <-2.782, -3.080, 1.189> <-2.782, -3.157, 1.112> <-2.782, -3.157, 1.018> 
		<0.382, -2.995, 1.189> <0.382, -3.088, 1.189> <0.382, -3.166, 1.112> <0.382, -3.166, 1.018> 
		<4.601, -3.006, 1.189> <4.601, -3.100, 1.189> <4.601, -3.177, 1.112> <4.601, -3.177, 1.018> 
		<7.765, -3.015, 1.189> <7.765, -3.108, 1.189> <7.765, -3.186, 1.112> <7.765, -3.186, 1.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -3.157, 1.018> <-2.782, -3.157, 0.925> <-2.782, -3.080, 0.847> <-2.782, -2.986, 0.847> 
		<0.382, -3.166, 1.018> <0.382, -3.166, 0.925> <0.382, -3.088, 0.847> <0.382, -2.995, 0.847> 
		<4.601, -3.177, 1.018> <4.601, -3.177, 0.925> <4.601, -3.100, 0.847> <4.601, -3.006, 0.847> 
		<7.765, -3.186, 1.018> <7.765, -3.186, 0.925> <7.765, -3.108, 0.847> <7.765, -3.015, 0.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.782, -2.986, 0.847> <-2.782, -2.893, 0.847> <-2.782, -2.815, 0.925> <-2.782, -2.815, 1.018> 
		<0.382, -2.995, 0.847> <0.382, -2.902, 0.847> <0.382, -2.824, 0.925> <0.382, -2.824, 1.018> 
		<4.601, -3.006, 0.847> <4.601, -2.913, 0.847> <4.601, -2.835, 0.925> <4.601, -2.835, 1.018> 
		<7.765, -3.015, 0.847> <7.765, -2.921, 0.847> <7.765, -2.844, 0.925> <7.765, -2.844, 1.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.765, -2.844, 1.018> <7.765, -2.844, 1.112> <7.765, -2.921, 1.189> <7.765, -3.015, 1.189> 
		<4.601, -2.835, 1.018> <4.601, -2.835, 1.112> <4.601, -2.913, 1.189> <4.601, -3.006, 1.189> 
		<0.382, -2.824, 1.018> <0.382, -2.824, 1.112> <0.382, -2.902, 1.189> <0.382, -2.995, 1.189> 
		<-2.782, -2.815, 1.018> <-2.782, -2.815, 1.112> <-2.782, -2.893, 1.189> <-2.782, -2.986, 1.189> 
	}
	pigment{rgb <120/255, 0/255, 175/255>}
	finish{phong 1}

} */
}
