 // Persistence of Vision Ray Tracer Scene Description File
// File: mg_asia.pov
// Vers: 3.5 beta 9
// Desc: IRTC  "Spirit of Asia"  entry
// Date: December 2001
// Auth: Marjorie Graterol


#include "colors.inc"	  
#include "textures.inc"	  
#include "functions.inc"
//======================  
#include "medidas.inc"
#include "mg_asia_tex.inc"




camera {
  location  <-4,0.35,6>
  look_at     <3.5, 1.75, 6>
  angle 60
}

/*
global_settings{
	ambient_light color AzulCeruleo
	assumed_gamma 2.20//
}
*/

global_settings{
  ambient_light color 0
  assumed_gamma 2.20
	radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 300                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.5//0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1//1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }

}
/*
global_settings{
	adc_bailout 0.0039
	ambient_light color White+Gray05
	assumed_gamma 1.8
	irid_wavelength rgb <0.25,0.18,0.14>
	max_intersections 64                 
	max_trace_level 10
	number_of_waves 10
	radiosity{
	          brightness 3.33
	          count 300//
	          distance_maximum  150.0
	          error_bound 0.3
	          gray_threshold  0.5
	}

}


*/



// radiosity (global illumination) settings



//object {ejes}	

//Luces superficies- Lights terrains

light_source { <0,68,0> color HumoClaro shadowless}//
light_source { <45,0,30> color  Marfil shadowless}//   <65,0,0> Marfil
//light_source { <45,0,30> color Guayaba shadowless}//


//contenedor -  container
sphere {0, 70 hollow no_shadow //75

texture{asiacie}
texture {fantasma scale <220,200,210>//150 

translate 0.001*y}

clipped_by {sphere {0, 72 hollow no_shadow }}


} 



//Luces  NO MOVER

//bridge- luz para el puente


light_source {
  0*x                     
  color Carton
  parallel                
  translate <2.8,9,9> 
  point_at <3.5,0,9>      
  fade_power 1
  fade_distance 10               
}

//houses- luz casas
light_source {
  0*x                     
  color Napoles
  parallel
  translate <9.5,16,11.5> 
  point_at <9.5,1,11.5>      
  
}

//luz debajo del ala
 
light_source {
  0*x                     
  color Gray70
  translate <-1.25,1.65,5.05>
  fade_distance 2
  fade_power 1
  shadowless
}
 
light_source {
  0*x                     
  color Gray70
  translate <-3.10,1.65,6>
  fade_distance 2
  fade_power 1
  shadowless
}



//water plane -plano de agua
plane { y, -0.50//-0.50 

  texture{
    pigment{
      Turquoise 
      filter 0.5
    }
    normal {
      waves 0.5 
      frequency 0.5
    }
    finish{
      ambient 0.3 
      reflection 0.3
      diffuse 0.4 
      crand 0.2 
    }
  }
  interior{
    ior 1.33
  }
}


//terrain (object) - superficie (objeto) primer plano

#include "porfin.inc" 

object{
  delta 
    texture{ 
      pigment {
        escala_geo 
        scale <1,3,1> 
        rotate x*56
      } 
      normal {
        norm_geo
      }  
      finish{
        crand 0.3 
        ambient 0.3 
        diffuse 0.43
      }  
    scale <1.5,1,0.5>
    }
  no_shadow
  scale <10,1,10>
  translate <0,0,6>
}


//second terrain- segundo terreno intermedio

object{
  delta
    texture{ 
      pigment {
        escala_geo 
        scale <1,3,1> 
        rotate x*56
      } 
      normal {
        norm_geo
      }  
      finish{
        crand 0.3 
        ambient 0.3 
        diffuse 0.43
      }  
    scale <1.5,1,0.5>
    
    }
  no_shadow
  scale <5,3,5> 
  translate <30,-0.25,10>
}


//third terrain- tercero y lejano

object{
  delta 
    texture{
      lab_02tb scale 2
    }
  no_shadow
  scale <3,5,4>//<3,4,3> 
  rotate 110*y//235*y 
  translate <40,0.5,-3>
}

//small bridge -pequeo puente
#include "puente.inc" 

object {
  puente2
    texture{
      puentes
    }
  no_shadow 
  scale <0.65,0.45,0.45>
  rotate 50*y
  translate <25,0,0.5>
  
  }
 

//front bridge -puente del frente
#include "bridge.inc"
object{
  puente
 
    texture {
      pigment {
        White
      } 
      normal {
        granite 0.4 
        turbulence 3 
        scale 0.75 
      }
      finish{
        ambient 0.4 
        diffuse 0.4 
        crand 0.001
      }
    }
    
    texture {
      lab_02tb 
      translate 0.02*y
    } 
  scale 0.50
  rotate 50*y
  translate <4,-0.15,9>
  }
  


 
#include "techo2.inc"
  object{
    ala 
    scale 0.15 
    rotate 130*y 
    translate <-2,2.10,5.6>
  }

#include "casa01.inc"

object{
  casa01 
  scale 0.50 
  rotate 110*y 
  translate <9,2,12.5>
}
object{
  casa01 
  scale 0.70 
  rotate 110*y 
  translate <11.5,2.70,10.85>
}     

//table - mesa
#include "mesa.inc"

object {
  mesa 
  scale <0.12,0.13,0.12> 
  rotate 130*y 
  translate <-1.10,0.20,5>
}

//chair- silla
#include "silla.inc"

object {
  silla 
  texture {madera} 
  scale 0.10 
  rotate 140*y 
  translate <-1.48,0.02,4.72>
}

//lamps -lamparas
#include "chinese.inc" 

object {
  chinese  
  scale 0.08 
  rotate 15*y 
  translate <-2.55,0.97,6.20>
} 
object {
  chinese  
  scale 0.08 
  rotate 15*y 
  translate <-1.10,0.97,4.95>
}



//platform- plataforma de ala - 

box {
  <-2, -0.25, -1> < 2,  -0.23,  1>  
  texture{ 
    pigment {
      image_map {
        tga "mos_tex.tga" 
        map_type 0        
        interpolate 2     
        
      }
    rotate 90*x
    rotate 45*z
    }

    normal{
      bump_map { 
        tga "mos_tex.tga" 
        map_type 0        
        interpolate 1     
        bump_size 2    
      } 
      rotate 90*x
      rotate 45*z 
    }
    finish {
      reflection 0.05 
      ambient 0.4 
      diffuse 0.4 
    }
  scale <2,1,2>
  }
  rotate -140*y 
  translate <-2.5,0.10,6> 
  
}



#include "follaje5.inc"

object {
  follaje5 
  scale 0.010 
  translate <3.25,0,5>
}
object {
  follaje5 
  scale 0.010 
  translate <1.25,-0.5,8.25>
}

//trees from tomtree.inc (Tom Aust)                                  
#include "BIRCH.inc"
#include "TOMTREE.inc"
//fuente adelante
object

{
	TREE
	scale 4//1000
	translate <5,-3,8>
}
//fuente atras
object
{
	TREE
	scale 4//1000
	translate <2.50,-1.50,10.5>
}
//casa2 


object
{
	TREE
	scale 4//1000
	translate <12.5,-1,7.85>//<4.25,-3,4.5>
} 

//casa2more
object
{
	TREE
	scale 4//1000
	translate <12.5,-1.25,5>//<4.25,-3,4.5>
}

//little birds -pajaritos

#include "bird.inc"        
object {
  bird  
  scale 0.30 
  translate <4,1.24,10.30>
}
object {
  bird  
  scale 0.30
  rotate 90*y 
  translate <3.88,1.00,10.33>
}



//bamboo -bambues

#include "bambu.inc" 

object{
  bambu 
  texture {
    pigment {
      ForestGreen
    }
    finish {
      ambient 0.4 
      diffuse 0.4 
      brilliance 0.3
    }
  }
  translate <-1.10,0.52,5>
}



object{
  bambu
  texture { 
    pigment {
      ForestGreen
    }
    finish {
      ambient 0.4 
      diffuse 0.4 
      brilliance 0.3
    }
  }
  scale <1,0.80,0>
  rotate 40*y
  translate <-1.12,0.65,4.97>
}




cylinder {
  0*y,  0.1*y,  0.08
  
  texture {
    Gold_Texture
  }
   
  //pigment {Blue}
  scale <0.80,1,0.80>  
  translate <-1.10,0.45,5>
}
