// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
//#include "functions.inc"  // internal functions usable in user defined functions

#declare Ocre= color rgb <0.702,0.580,0.000>;






#declare ArenaGold= rgb<1.00,0.706,0.125>;
#declare AzulCeruleo= rgb <0.53516, 0.63281, 0.71094>;
#declare AzulCeruleoClaro= rgb <0.58594, 0.66016, 0.71875>;
#declare AzulMarino=color rgb <0.129,0.165,0.459>;
#declare BlancoArena= rgb<1.00,0.914,0.749>;
#declare Cadmio=color rgb <0.925,0.780,0.071>;
#declare CadmioOscuro= color rgb <0.89453, 0.61328, 0.21484>;
#declare CadmioSat= rgb <0.92969, 0.74219, 0.48828>;
#declare Carton= rgb <0.72266, 0.66016, 0.60156>;
#declare Guayaba= rgb <0.86719, 0.66016, 0.52734>;
#declare GrisAzulado = rgb <0.64453, 0.68359, 0.69141>;
#declare GrisTurquesa= rgb <0.60156, 0.64453, 0.63281>; 
#declare GrisVerde= rgb <0.69141, 0.70313, 0.58984>;
#declare GrisVioleta= rgb <0.8125, 0.80469, 0.8125>;
#declare Humo=rgb <0.88281, 0.90234, 0.89844>;
#declare HumoClaro= rgb <0.92578, 0.94141, 0.92969>;
#declare Malva=color rgbf <0.690,0.588,0.471,0.500>;
#declare Marfil= rgb <0.99219, 0.98828, 0.91797>;
#declare Marron= color rgb <0.416,0.310,0.118>; 
#declare MarronOscuro= rgb <0.28516, 0.21484, 0.17188>;
#declare Napoles= rgb <0.91797, 0.87109, 0.55078>;
#declare VerdeOliva=color rgb <0.404,0.443,0.125>;
#declare VerdeOlivaGris= rgb <0.42578, 0.45703, 0.36719>;
#declare VerdeOlivaPlano= rgb <0.45703, 0.51563, 0.36328>;
#declare VinoTinto=color rgb <0.459,0.200,0.129>;


//escala_geo (pigmento)
#declare escala_geo=
pigment{

gradient y
turbulence 0.5 
color_map {
  
  [ 0.0, 0.10   color GrisVioleta color Carton]
  [ 0.10, 0.30  color Carton color GrisVerde] 
  [ 0.30, 0.50  color GrisVerde color Malva]
  [ 0.50, 0.70  color Malva color GrisAzulado]
  [ 0.70, 0.90  color GrisAzulado color Humo]  
  [ 0.90  1.00  color Humo color GrisVioleta]
  
} 

}
//escala_geo2 (pigmento)
#declare escala_geo2=
pigment{

gradient y
turbulence 0.5 
color_map {
  
  [ 0.0, 0.10   color GrisVioleta filter 0.5 color GrisAzulado filter 0.5]
  [ 0.30, 0.50  color GrisAzulado filter 0.5 color GrisTurquesa filter 0.5]
  [ 0.50, 0.70  color GrisTurquesa filter 0.5 color Humo filter 0.5]
  [ 0.90  1.00  color Humo filter 0.5 color GrisVioleta filter 0.5]//VerdeOlivaPlano]
  
} 

}

//escala_geo3 (pigmento)
#declare escala_geo3=
pigment{

gradient y
turbulence 0.5 
color_map {
  
  [ 0.0, 0.10   color GrisVioleta filter 0.5 color GrisAzulado filter 0.5]
  [ 0.30, 0.50  color GrisAzulado filter 0.5 color GrisTurquesa filter 0.5]
  [ 0.50, 0.70  color GrisTurquesa filter 0.5 color Humo filter 0.5]
  [ 0.90  1.00  color Humo filter 0.5 color GrisVioleta filter 0.5]//VerdeOlivaPlano]
} 

}

//norm_geo (normal)
#declare norm_geo=
normal {
    agate         
    slope_map {
      [0    <0.5, 1>]   
      [0.25 <0.5,-1>]   
      [0.5  <0.5,-1>]   
      [0.75 <0.25, -0.5>]   
      [6    <0.5, 1>]   
    }
  }


 
//escala de colores para el color_map
//de backbeach.pov

#declare croma_01  =color rgb <0.92188, 0.875, 0.84375>; 
#declare croma_02  =color rgb <0.9375, 0.89063, 0.85938>;
#declare croma_03  =color rgb <0.81641, 0.72266, 0.73828>;
#declare croma_04  =color rgb <0.63281, 0.55859, 0.63281>;
#declare croma_05  =color rgb <0.63281, 0.64844, 0.73828>;
#declare croma_06  =color rgb <0.66406, 0.71094, 0.78516>;
#declare croma_07  =color rgb <0.71094, 0.75391, 0.83203>;
#declare croma_08  =color rgb <0.76953, 0.83203, 0.92188>;
#declare croma_09  =color rgb <0.875, 0.90625, 0.9375>;
#declare croma_10  =color rgb <0.99609, 0.96484, 0.875>;


#declare backdrop =color rgb <0.37891, 0.39063, 0.51172>;

#declare cielito=texture{

pigment{
  wrinkles
                            
                            
                            
  frequency 0.25
  phase 0.5
  turbulence <0, 1, 0.5> 
  lambda 2.0      
  omega 0.5       
  octaves 6       
  color_map{
    [0.100  color croma_01]
    [0.200  color croma_02]
    [0.300  color croma_03]
    [0.400  color croma_04]
    [0.500  color croma_05]
    [0.600  color croma_06]
    [0.700  color croma_07]
    [0.800  color croma_08]
    [0.900  color croma_09]
    [1.00  color croma_10]
          }
}

finish{ambient 0.6 diffuse 0.5}
scale <0.5,0.5,0.5>
}

//textura cielo 
#declare asiacie=
texture {
pigment 
{
  gradient y
  turbulence 0.30
  color_map 
  {
    [0.0, 0.25 color Guayaba color CadmioOscuro]
    [0.25, 0.350 color CadmioOscuro color Cadmio]
    [0.350, 0.50 color Cadmio color CadmioSat]
    [0.50, 0.70 color CadmioSat color Marfil]
    [0.70, 1.0 color Marfil color Guayaba]
  }
    
	 
	rotate z*24
	scale 31
				
}
	finish{ambient 0.5 diffuse 0.5} }

//modificacion de fantasma -textura- de mg_fte
#declare fantasma=
texture{
 pigment {
 granite 
 color_map{
 [0.33 color White*2 filter 0.3 transmit 0.2]
 [0.66 color Clear]
 [1.00 color White*3 filter 0.1 transmit 0.3]
 }
 
 
 }
 normal {granite 0.3}
 finish {ambient 0.4 diffuse 0.3333 }
 
 rotate 15*z   
 
}

//modificacion de la anterior
#declare fantasma_g=
texture{
 pigment {
 granite 
 color_map{
 [0.33 color White filter 0.3 transmit 0.2]
 [0.66 color Clear]
 [1.00 color White filter 0.1 transmit 0.3]
 }
 
 
 }
 normal {granite 0.3}
 finish {ambient 0.4 diffuse 0.3333 }   
 
}
//sin usar en esta imagen 
#declare abertura=
difference {

box {
  <-50, -50, -0.10>  
  < 50,  50,  0.10>  
  
}

union{
box {
  <-3, -3, -4>  
  < 3,  3,  4>  
pigment{Clear}

finish {phong 0.6}
hollow


}


box {
  <-2, -4, -4>  
  < 2,  4,  4>  
pigment{Clear}

finish {phong 0.6}
hollow


}}}

//modificacion de textura de mg_lab

#declare lab_02ta = texture {
  pigment {
    bozo
     
    colour_map {
      [0 rgb <0.565,0.467,0.471>] 
      [1.0 rgb <0.455,0.459,0.424>] 
    }
    scale 25 
  }
  normal {
    granite 0.3 scale 0.10 
  }
  finish {
    phong 0.8
  }
  scale 0.05
}

//modificacion de textura de mg_lab
#declare lab_02tb=
#declare R=seed(1957);  
  texture{
  pigment
	{
		gradient y
		color_map
		{
			[0.0 color rgb <0.886,0.792,0.957>]  
			[0.2 color Clear]
			[0.4 color rgb <0.537,0.604,0.608>]    
			[0.8 color Clear]
			[0.9 color rgb <0.804,0.843,0.851>]     
			[1.0 color Clear]
		}
		
		scale 50
		turbulence rand(R)
		octaves 10
		omega 0.7
	}
	normal
	{
		bumps 100
		scale 0.75
		turbulence 0.4
	}
	
	finish{ambient 0.2 crand 0.2}
	}

//ibidem
#declare lab_02tb2=
#declare R=seed(10);  
  texture{
  pigment
	{
		gradient y
		color_map
		{
			[0.0 color rgb <0.886,0.792,0.957>]  
			[0.2 color Clear]
			[0.4 color rgb <0.537,0.604,0.608>]    
			[0.8 color Clear]
			[0.9 color rgb <0.804,0.843,0.851>]     
			[1.0 color Clear]
		}
		
		scale 50
		turbulence rand(R)
		octaves 10
		omega 0.7
	}
	normal
	{
		bumps 100
		scale 0.75
		turbulence 0.4
	}
	
	finish{ambient 0.45 diffuse 0.35 crand 0.2}
	}
//recontraibidem
#declare lab_03tb=
#declare R=seed(1957);  
  texture{
  pigment
	{
		gradient y
		color_map
		{
			[0.0 color Ocre]  
			[0.2 color Clear]
			[0.4 color Marron]    
			[0.8 color Clear]
			[0.9 color VerdeOliva]     
			[1.0 color Clear]
		}
		
		scale 50
		turbulence rand(R)
		octaves 10
		omega 0.7
	}
	normal
	{
		bumps 100
		scale 0.75
		turbulence 0.4
	}
	
	finish{ambient 0.355 diffuse 0.355 crand 0.2}
	}


//mesa y silla	
#declare madera=
	texture{
	  pigment{
image_map {
  tga "madera01.tga" 
  map_type 0        
  interpolate 2     
  
  
} 
 
}	
normal{

bump_map { 
  tga "madera01b.tga" 
  map_type 0        
  interpolate 2     
  
  
  bump_size 0.9     
} 

 
}	
finish {ambient 0.5 diffuse 0.5 brilliance 0.3}	
	}
	

//modificada de mg_lab -grupo de luces- sin usar
#declare luces_lab=
union{
light_source
{
  0*x 
  color Marfil
  shadowless
  fade_power 1
  fade_distance 5
  translate <3, 5, -20>
}  
//nueva
light_source
{
  0*x 
  color  Carton
  shadowless
  fade_power 1
  fade_distance 10
  translate <5,24,7>  
}
/*

 */
light_source
{
  0*x 
  color SkyBlue
  shadowless 
  translate <5, 10, 6>
  fade_power 1
  fade_distance 10
} 


}



#declare puentes=

texture {pigment {White} normal {granite 0.4 turbulence 3 scale 0.75 }finish{ambient 0.4 diffuse 0.4 
  crand 0.001
  }}
    
  texture {
    lab_02tb 
    
    translate 0.02*y} 


  	  	