/*
camera{
	location < 6.342, -1.963, -19.517 >
	look_at < 0.000, 0.000, 0.000 >
	angle 40.000
}

background{ rgb <0/255,0/255,0/255> }


light_source{<100,100,-100> rgb 1}
light_source{<0,10,-1000> rgb 1}


global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}
}
*/

#declare silla=
union{
//patch_obj_00
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.441, 2.053, -1.528> <-0.830, 2.053, -1.528> <1.003, 2.053, -1.528> <1.614, 2.053, -1.528> 
		<-1.441, 2.010, -1.528> <-0.830, 2.010, -1.528> <1.003, 2.010, -1.528> <1.614, 2.010, -1.528> 
		<-1.441, 1.882, -1.528> <-0.830, 1.882, -1.528> <1.003, 1.882, -1.528> <1.614, 1.882, -1.528> 
		<-1.441, 1.839, -1.528> <-0.830, 1.839, -1.528> <1.003, 1.839, -1.528> <1.614, 1.839, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.441, 2.053, 1.528> <-0.830, 2.053, 1.528> <1.003, 2.053, 1.528> <1.614, 2.053, 1.528> 
		<-1.441, 2.053, 0.917> <-0.830, 2.053, 0.917> <1.003, 2.053, 0.917> <1.614, 2.053, 0.917> 
		<-1.441, 2.053, -1.222> <-0.830, 2.053, -1.222> <1.003, 2.053, -1.222> <1.614, 2.053, -1.222> 
		<-1.441, 2.053, -1.528> <-0.830, 2.053, -1.528> <1.003, 2.053, -1.528> <1.614, 2.053, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.441, 2.053, 1.528> <-0.830, 2.053, 1.528> <1.003, 2.053, 1.528> <1.614, 2.053, 1.528> 
		<-1.441, 2.010, 1.528> <-0.830, 2.010, 1.528> <1.003, 2.010, 1.528> <1.614, 2.010, 1.528> 
		<-1.441, 1.882, 1.528> <-0.830, 1.882, 1.528> <1.003, 1.882, 1.528> <1.614, 1.882, 1.528> 
		<-1.441, 1.839, 1.528> <-0.830, 1.839, 1.528> <1.003, 1.839, 1.528> <1.614, 1.839, 1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.614, 2.053, 1.528> <1.614, 2.010, 1.528> <1.614, 1.882, 1.528> <1.614, 1.839, 1.528> 
		<1.614, 2.053, 0.917> <1.614, 2.010, 0.917> <1.614, 1.882, 0.917> <1.614, 1.839, 0.917> 
		<1.614, 2.053, -1.222> <1.614, 2.010, -1.222> <1.614, 1.882, -1.222> <1.614, 1.839, -1.222> 
		<1.614, 2.053, -1.528> <1.614, 2.010, -1.528> <1.614, 1.882, -1.528> <1.614, 1.839, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.614, 1.839, 1.528> <1.003, 1.839, 1.528> <-0.830, 1.839, 1.528> <-1.441, 1.839, 1.528> 
		<1.614, 1.839, 0.917> <1.003, 1.839, 0.917> <-0.830, 1.839, 0.917> <-1.441, 1.839, 0.917> 
		<1.614, 1.839, -1.222> <1.003, 1.839, -1.222> <-0.830, 1.839, -1.222> <-1.441, 1.839, -1.222> 
		<1.614, 1.839, -1.528> <1.003, 1.839, -1.528> <-0.830, 1.839, -1.528> <-1.441, 1.839, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.441, 1.839, 1.528> <-1.441, 1.882, 1.528> <-1.441, 2.010, 1.528> <-1.441, 2.053, 1.528> 
		<-1.441, 1.839, 0.917> <-1.441, 1.882, 0.917> <-1.441, 2.010, 0.917> <-1.441, 2.053, 0.917> 
		<-1.441, 1.839, -1.222> <-1.441, 1.882, -1.222> <-1.441, 2.010, -1.222> <-1.441, 2.053, -1.222> 
		<-1.441, 1.839, -1.528> <-1.441, 1.882, -1.528> <-1.441, 2.010, -1.528> <-1.441, 2.053, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.131, 2.043, -1.507> <-1.131, 1.184, -1.507> <-1.131, -1.393, -1.507> <-1.131, -2.252, -1.507> 
		<-1.191, 2.043, -1.507> <-1.191, 1.184, -1.507> <-1.191, -1.393, -1.507> <-1.191, -2.252, -1.507> 
		<-1.374, 2.043, -1.507> <-1.374, 1.184, -1.507> <-1.374, -1.393, -1.507> <-1.374, -2.252, -1.507> 
		<-1.434, 2.043, -1.507> <-1.434, 1.184, -1.507> <-1.434, -1.393, -1.507> <-1.434, -2.252, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.131, 2.043, -1.163> <-1.131, 1.184, -1.163> <-1.131, -1.393, -1.163> <-1.131, -2.252, -1.163> 
		<-1.131, 2.043, -1.232> <-1.131, 1.184, -1.232> <-1.131, -1.393, -1.232> <-1.131, -2.252, -1.232> 
		<-1.131, 2.043, -1.472> <-1.131, 1.184, -1.472> <-1.131, -1.393, -1.472> <-1.131, -2.252, -1.472> 
		<-1.131, 2.043, -1.507> <-1.131, 1.184, -1.507> <-1.131, -1.393, -1.507> <-1.131, -2.252, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.131, 2.043, -1.163> <-1.131, 1.184, -1.163> <-1.131, -1.393, -1.163> <-1.131, -2.252, -1.163> 
		<-1.191, 2.043, -1.163> <-1.191, 1.184, -1.163> <-1.191, -1.393, -1.163> <-1.191, -2.252, -1.163> 
		<-1.374, 2.043, -1.163> <-1.374, 1.184, -1.163> <-1.374, -1.393, -1.163> <-1.374, -2.252, -1.163> 
		<-1.434, 2.043, -1.163> <-1.434, 1.184, -1.163> <-1.434, -1.393, -1.163> <-1.434, -2.252, -1.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.131, -2.252, -1.163> <-1.191, -2.252, -1.163> <-1.374, -2.252, -1.163> <-1.434, -2.252, -1.163> 
		<-1.131, -2.252, -1.232> <-1.191, -2.252, -1.232> <-1.374, -2.252, -1.232> <-1.434, -2.252, -1.232> 
		<-1.131, -2.252, -1.472> <-1.191, -2.252, -1.472> <-1.374, -2.252, -1.472> <-1.434, -2.252, -1.472> 
		<-1.131, -2.252, -1.507> <-1.191, -2.252, -1.507> <-1.374, -2.252, -1.507> <-1.434, -2.252, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.434, -2.252, -1.163> <-1.434, -1.393, -1.163> <-1.434, 1.184, -1.163> <-1.434, 2.043, -1.163> 
		<-1.434, -2.252, -1.232> <-1.434, -1.393, -1.232> <-1.434, 1.184, -1.232> <-1.434, 2.043, -1.232> 
		<-1.434, -2.252, -1.472> <-1.434, -1.393, -1.472> <-1.434, 1.184, -1.472> <-1.434, 2.043, -1.472> 
		<-1.434, -2.252, -1.507> <-1.434, -1.393, -1.507> <-1.434, 1.184, -1.507> <-1.434, 2.043, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.434, 2.043, -1.163> <-1.374, 2.043, -1.163> <-1.191, 2.043, -1.163> <-1.131, 2.043, -1.163> 
		<-1.434, 2.043, -1.232> <-1.374, 2.043, -1.232> <-1.191, 2.043, -1.232> <-1.131, 2.043, -1.232> 
		<-1.434, 2.043, -1.472> <-1.374, 2.043, -1.472> <-1.191, 2.043, -1.472> <-1.131, 2.043, -1.472> 
		<-1.434, 2.043, -1.507> <-1.374, 2.043, -1.507> <-1.191, 2.043, -1.507> <-1.131, 2.043, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.593, 2.043, -1.507> <1.593, 1.184, -1.507> <1.593, -1.393, -1.507> <1.593, -2.252, -1.507> 
		<1.533, 2.043, -1.507> <1.533, 1.184, -1.507> <1.533, -1.393, -1.507> <1.533, -2.252, -1.507> 
		<1.350, 2.043, -1.507> <1.350, 1.184, -1.507> <1.350, -1.393, -1.507> <1.350, -2.252, -1.507> 
		<1.290, 2.043, -1.507> <1.290, 1.184, -1.507> <1.290, -1.393, -1.507> <1.290, -2.252, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.593, 2.043, -1.163> <1.593, 1.184, -1.163> <1.593, -1.393, -1.163> <1.593, -2.252, -1.163> 
		<1.593, 2.043, -1.232> <1.593, 1.184, -1.232> <1.593, -1.393, -1.232> <1.593, -2.252, -1.232> 
		<1.593, 2.043, -1.472> <1.593, 1.184, -1.472> <1.593, -1.393, -1.472> <1.593, -2.252, -1.472> 
		<1.593, 2.043, -1.507> <1.593, 1.184, -1.507> <1.593, -1.393, -1.507> <1.593, -2.252, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.593, 2.043, -1.163> <1.593, 1.184, -1.163> <1.593, -1.393, -1.163> <1.593, -2.252, -1.163> 
		<1.533, 2.043, -1.163> <1.533, 1.184, -1.163> <1.533, -1.393, -1.163> <1.533, -2.252, -1.163> 
		<1.350, 2.043, -1.163> <1.350, 1.184, -1.163> <1.350, -1.393, -1.163> <1.350, -2.252, -1.163> 
		<1.290, 2.043, -1.163> <1.290, 1.184, -1.163> <1.290, -1.393, -1.163> <1.290, -2.252, -1.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.593, -2.252, -1.163> <1.533, -2.252, -1.163> <1.350, -2.252, -1.163> <1.290, -2.252, -1.163> 
		<1.593, -2.252, -1.232> <1.533, -2.252, -1.232> <1.350, -2.252, -1.232> <1.290, -2.252, -1.232> 
		<1.593, -2.252, -1.472> <1.533, -2.252, -1.472> <1.350, -2.252, -1.472> <1.290, -2.252, -1.472> 
		<1.593, -2.252, -1.507> <1.533, -2.252, -1.507> <1.350, -2.252, -1.507> <1.290, -2.252, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.290, -2.252, -1.163> <1.290, -1.393, -1.163> <1.290, 1.184, -1.163> <1.290, 2.043, -1.163> 
		<1.290, -2.252, -1.232> <1.290, -1.393, -1.232> <1.290, 1.184, -1.232> <1.290, 2.043, -1.232> 
		<1.290, -2.252, -1.472> <1.290, -1.393, -1.472> <1.290, 1.184, -1.472> <1.290, 2.043, -1.472> 
		<1.290, -2.252, -1.507> <1.290, -1.393, -1.507> <1.290, 1.184, -1.507> <1.290, 2.043, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.290, 2.043, -1.163> <1.350, 2.043, -1.163> <1.533, 2.043, -1.163> <1.593, 2.043, -1.163> 
		<1.290, 2.043, -1.232> <1.350, 2.043, -1.232> <1.533, 2.043, -1.232> <1.593, 2.043, -1.232> 
		<1.290, 2.043, -1.472> <1.350, 2.043, -1.472> <1.533, 2.043, -1.472> <1.593, 2.043, -1.472> 
		<1.290, 2.043, -1.507> <1.350, 2.043, -1.507> <1.533, 2.043, -1.507> <1.593, 2.043, -1.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.152, 2.043, 1.142> <-1.152, 1.184, 1.142> <-1.152, -1.393, 1.142> <-1.152, -2.252, 1.142> 
		<-1.212, 2.043, 1.142> <-1.212, 1.184, 1.142> <-1.212, -1.393, 1.142> <-1.212, -2.252, 1.142> 
		<-1.395, 2.043, 1.142> <-1.395, 1.184, 1.142> <-1.395, -1.393, 1.142> <-1.395, -2.252, 1.142> 
		<-1.455, 2.043, 1.142> <-1.455, 1.184, 1.142> <-1.455, -1.393, 1.142> <-1.455, -2.252, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.152, 2.043, 1.486> <-1.152, 1.184, 1.486> <-1.152, -1.393, 1.486> <-1.152, -2.252, 1.486> 
		<-1.152, 2.043, 1.417> <-1.152, 1.184, 1.417> <-1.152, -1.393, 1.417> <-1.152, -2.252, 1.417> 
		<-1.152, 2.043, 1.177> <-1.152, 1.184, 1.177> <-1.152, -1.393, 1.177> <-1.152, -2.252, 1.177> 
		<-1.152, 2.043, 1.142> <-1.152, 1.184, 1.142> <-1.152, -1.393, 1.142> <-1.152, -2.252, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.152, 2.043, 1.486> <-1.152, 1.184, 1.486> <-1.152, -1.393, 1.486> <-1.152, -2.252, 1.486> 
		<-1.212, 2.043, 1.486> <-1.212, 1.184, 1.486> <-1.212, -1.393, 1.486> <-1.212, -2.252, 1.486> 
		<-1.395, 2.043, 1.486> <-1.395, 1.184, 1.486> <-1.395, -1.393, 1.486> <-1.395, -2.252, 1.486> 
		<-1.455, 2.043, 1.486> <-1.455, 1.184, 1.486> <-1.455, -1.393, 1.486> <-1.455, -2.252, 1.486> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.152, -2.252, 1.486> <-1.212, -2.252, 1.486> <-1.395, -2.252, 1.486> <-1.455, -2.252, 1.486> 
		<-1.152, -2.252, 1.417> <-1.212, -2.252, 1.417> <-1.395, -2.252, 1.417> <-1.455, -2.252, 1.417> 
		<-1.152, -2.252, 1.177> <-1.212, -2.252, 1.177> <-1.395, -2.252, 1.177> <-1.455, -2.252, 1.177> 
		<-1.152, -2.252, 1.142> <-1.212, -2.252, 1.142> <-1.395, -2.252, 1.142> <-1.455, -2.252, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.455, -2.252, 1.486> <-1.455, -1.393, 1.486> <-1.455, 1.184, 1.486> <-1.455, 2.043, 1.486> 
		<-1.455, -2.252, 1.417> <-1.455, -1.393, 1.417> <-1.455, 1.184, 1.417> <-1.455, 2.043, 1.417> 
		<-1.455, -2.252, 1.177> <-1.455, -1.393, 1.177> <-1.455, 1.184, 1.177> <-1.455, 2.043, 1.177> 
		<-1.455, -2.252, 1.142> <-1.455, -1.393, 1.142> <-1.455, 1.184, 1.142> <-1.455, 2.043, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.455, 2.043, 1.486> <-1.395, 2.043, 1.486> <-1.212, 2.043, 1.486> <-1.152, 2.043, 1.486> 
		<-1.455, 2.043, 1.417> <-1.395, 2.043, 1.417> <-1.212, 2.043, 1.417> <-1.152, 2.043, 1.417> 
		<-1.455, 2.043, 1.177> <-1.395, 2.043, 1.177> <-1.212, 2.043, 1.177> <-1.152, 2.043, 1.177> 
		<-1.455, 2.043, 1.142> <-1.395, 2.043, 1.142> <-1.212, 2.043, 1.142> <-1.152, 2.043, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.573, 2.043, 1.142> <1.573, 1.184, 1.142> <1.573, -1.393, 1.142> <1.573, -2.252, 1.142> 
		<1.512, 2.043, 1.142> <1.512, 1.184, 1.142> <1.512, -1.393, 1.142> <1.512, -2.252, 1.142> 
		<1.330, 2.043, 1.142> <1.330, 1.184, 1.142> <1.330, -1.393, 1.142> <1.330, -2.252, 1.142> 
		<1.269, 2.043, 1.142> <1.269, 1.184, 1.142> <1.269, -1.393, 1.142> <1.269, -2.252, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.573, 2.043, 1.486> <1.573, 1.184, 1.486> <1.573, -1.393, 1.486> <1.573, -2.252, 1.486> 
		<1.573, 2.043, 1.417> <1.573, 1.184, 1.417> <1.573, -1.393, 1.417> <1.573, -2.252, 1.417> 
		<1.573, 2.043, 1.177> <1.573, 1.184, 1.177> <1.573, -1.393, 1.177> <1.573, -2.252, 1.177> 
		<1.573, 2.043, 1.142> <1.573, 1.184, 1.142> <1.573, -1.393, 1.142> <1.573, -2.252, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.573, 2.043, 1.486> <1.573, 1.184, 1.486> <1.573, -1.393, 1.486> <1.573, -2.252, 1.486> 
		<1.512, 2.043, 1.486> <1.512, 1.184, 1.486> <1.512, -1.393, 1.486> <1.512, -2.252, 1.486> 
		<1.330, 2.043, 1.486> <1.330, 1.184, 1.486> <1.330, -1.393, 1.486> <1.330, -2.252, 1.486> 
		<1.269, 2.043, 1.486> <1.269, 1.184, 1.486> <1.269, -1.393, 1.486> <1.269, -2.252, 1.486> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.573, -2.252, 1.486> <1.512, -2.252, 1.486> <1.330, -2.252, 1.486> <1.269, -2.252, 1.486> 
		<1.573, -2.252, 1.417> <1.512, -2.252, 1.417> <1.330, -2.252, 1.417> <1.269, -2.252, 1.417> 
		<1.573, -2.252, 1.177> <1.512, -2.252, 1.177> <1.330, -2.252, 1.177> <1.269, -2.252, 1.177> 
		<1.573, -2.252, 1.142> <1.512, -2.252, 1.142> <1.330, -2.252, 1.142> <1.269, -2.252, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.269, -2.252, 1.486> <1.269, -1.393, 1.486> <1.269, 1.184, 1.486> <1.269, 2.043, 1.486> 
		<1.269, -2.252, 1.417> <1.269, -1.393, 1.417> <1.269, 1.184, 1.417> <1.269, 2.043, 1.417> 
		<1.269, -2.252, 1.177> <1.269, -1.393, 1.177> <1.269, 1.184, 1.177> <1.269, 2.043, 1.177> 
		<1.269, -2.252, 1.142> <1.269, -1.393, 1.142> <1.269, 1.184, 1.142> <1.269, 2.043, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.269, 2.043, 1.486> <1.330, 2.043, 1.486> <1.512, 2.043, 1.486> <1.573, 2.043, 1.486> 
		<1.269, 2.043, 1.417> <1.330, 2.043, 1.417> <1.512, 2.043, 1.417> <1.573, 2.043, 1.417> 
		<1.269, 2.043, 1.177> <1.330, 2.043, 1.177> <1.512, 2.043, 1.177> <1.573, 2.043, 1.177> 
		<1.269, 2.043, 1.142> <1.330, 2.043, 1.142> <1.512, 2.043, 1.142> <1.573, 2.043, 1.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.494, -2.018, -1.436> <0.918, -2.018, -1.436> <-0.808, -2.018, -1.436> <-1.384, -2.018, -1.436> 
		<1.494, -1.982, -1.436> <0.918, -1.982, -1.436> <-0.808, -1.982, -1.436> <-1.384, -1.982, -1.436> 
		<1.494, -1.875, -1.436> <0.918, -1.875, -1.436> <-0.808, -1.875, -1.436> <-1.384, -1.875, -1.436> 
		<1.494, -1.839, -1.436> <0.918, -1.839, -1.436> <-0.808, -1.839, -1.436> <-1.384, -1.839, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.494, -2.018, -1.234> <0.918, -2.018, -1.234> <-0.808, -2.018, -1.234> <-1.384, -2.018, -1.234> 
		<1.494, -2.018, -1.274> <0.918, -2.018, -1.274> <-0.808, -2.018, -1.274> <-1.384, -2.018, -1.274> 
		<1.494, -2.018, -1.416> <0.918, -2.018, -1.416> <-0.808, -2.018, -1.416> <-1.384, -2.018, -1.416> 
		<1.494, -2.018, -1.436> <0.918, -2.018, -1.436> <-0.808, -2.018, -1.436> <-1.384, -2.018, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.494, -2.018, -1.234> <0.918, -2.018, -1.234> <-0.808, -2.018, -1.234> <-1.384, -2.018, -1.234> 
		<1.494, -1.982, -1.234> <0.918, -1.982, -1.234> <-0.808, -1.982, -1.234> <-1.384, -1.982, -1.234> 
		<1.494, -1.875, -1.234> <0.918, -1.875, -1.234> <-0.808, -1.875, -1.234> <-1.384, -1.875, -1.234> 
		<1.494, -1.839, -1.234> <0.918, -1.839, -1.234> <-0.808, -1.839, -1.234> <-1.384, -1.839, -1.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.384, -2.018, -1.234> <-1.384, -1.982, -1.234> <-1.384, -1.875, -1.234> <-1.384, -1.839, -1.234> 
		<-1.384, -2.018, -1.274> <-1.384, -1.982, -1.274> <-1.384, -1.875, -1.274> <-1.384, -1.839, -1.274> 
		<-1.384, -2.018, -1.416> <-1.384, -1.982, -1.416> <-1.384, -1.875, -1.416> <-1.384, -1.839, -1.416> 
		<-1.384, -2.018, -1.436> <-1.384, -1.982, -1.436> <-1.384, -1.875, -1.436> <-1.384, -1.839, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.384, -1.839, -1.234> <-0.808, -1.839, -1.234> <0.918, -1.839, -1.234> <1.494, -1.839, -1.234> 
		<-1.384, -1.839, -1.274> <-0.808, -1.839, -1.274> <0.918, -1.839, -1.274> <1.494, -1.839, -1.274> 
		<-1.384, -1.839, -1.416> <-0.808, -1.839, -1.416> <0.918, -1.839, -1.416> <1.494, -1.839, -1.416> 
		<-1.384, -1.839, -1.436> <-0.808, -1.839, -1.436> <0.918, -1.839, -1.436> <1.494, -1.839, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.494, -1.839, -1.234> <1.494, -1.875, -1.234> <1.494, -1.982, -1.234> <1.494, -2.018, -1.234> 
		<1.494, -1.839, -1.274> <1.494, -1.875, -1.274> <1.494, -1.982, -1.274> <1.494, -2.018, -1.274> 
		<1.494, -1.839, -1.416> <1.494, -1.875, -1.416> <1.494, -1.982, -1.416> <1.494, -2.018, -1.416> 
		<1.494, -1.839, -1.436> <1.494, -1.875, -1.436> <1.494, -1.982, -1.436> <1.494, -2.018, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.515, -2.018, 1.213> <0.939, -2.018, 1.213> <-0.787, -2.018, 1.213> <-1.363, -2.018, 1.213> 
		<1.515, -1.982, 1.213> <0.939, -1.982, 1.213> <-0.787, -1.982, 1.213> <-1.363, -1.982, 1.213> 
		<1.515, -1.875, 1.213> <0.939, -1.875, 1.213> <-0.787, -1.875, 1.213> <-1.363, -1.875, 1.213> 
		<1.515, -1.839, 1.213> <0.939, -1.839, 1.213> <-0.787, -1.839, 1.213> <-1.363, -1.839, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.515, -2.018, 1.415> <0.939, -2.018, 1.415> <-0.787, -2.018, 1.415> <-1.363, -2.018, 1.415> 
		<1.515, -2.018, 1.375> <0.939, -2.018, 1.375> <-0.787, -2.018, 1.375> <-1.363, -2.018, 1.375> 
		<1.515, -2.018, 1.233> <0.939, -2.018, 1.233> <-0.787, -2.018, 1.233> <-1.363, -2.018, 1.233> 
		<1.515, -2.018, 1.213> <0.939, -2.018, 1.213> <-0.787, -2.018, 1.213> <-1.363, -2.018, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.515, -2.018, 1.415> <0.939, -2.018, 1.415> <-0.787, -2.018, 1.415> <-1.363, -2.018, 1.415> 
		<1.515, -1.982, 1.415> <0.939, -1.982, 1.415> <-0.787, -1.982, 1.415> <-1.363, -1.982, 1.415> 
		<1.515, -1.875, 1.415> <0.939, -1.875, 1.415> <-0.787, -1.875, 1.415> <-1.363, -1.875, 1.415> 
		<1.515, -1.839, 1.415> <0.939, -1.839, 1.415> <-0.787, -1.839, 1.415> <-1.363, -1.839, 1.415> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, -2.018, 1.415> <-1.363, -1.982, 1.415> <-1.363, -1.875, 1.415> <-1.363, -1.839, 1.415> 
		<-1.363, -2.018, 1.375> <-1.363, -1.982, 1.375> <-1.363, -1.875, 1.375> <-1.363, -1.839, 1.375> 
		<-1.363, -2.018, 1.233> <-1.363, -1.982, 1.233> <-1.363, -1.875, 1.233> <-1.363, -1.839, 1.233> 
		<-1.363, -2.018, 1.213> <-1.363, -1.982, 1.213> <-1.363, -1.875, 1.213> <-1.363, -1.839, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, -1.839, 1.415> <-0.787, -1.839, 1.415> <0.939, -1.839, 1.415> <1.515, -1.839, 1.415> 
		<-1.363, -1.839, 1.375> <-0.787, -1.839, 1.375> <0.939, -1.839, 1.375> <1.515, -1.839, 1.375> 
		<-1.363, -1.839, 1.233> <-0.787, -1.839, 1.233> <0.939, -1.839, 1.233> <1.515, -1.839, 1.233> 
		<-1.363, -1.839, 1.213> <-0.787, -1.839, 1.213> <0.939, -1.839, 1.213> <1.515, -1.839, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.515, -1.839, 1.415> <1.515, -1.875, 1.415> <1.515, -1.982, 1.415> <1.515, -2.018, 1.415> 
		<1.515, -1.839, 1.375> <1.515, -1.875, 1.375> <1.515, -1.982, 1.375> <1.515, -2.018, 1.375> 
		<1.515, -1.839, 1.233> <1.515, -1.875, 1.233> <1.515, -1.982, 1.233> <1.515, -2.018, 1.233> 
		<1.515, -1.839, 1.213> <1.515, -1.875, 1.213> <1.515, -1.982, 1.213> <1.515, -2.018, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.511, 1.040, -1.436> <0.936, 1.040, -1.436> <-0.791, 1.040, -1.436> <-1.366, 1.040, -1.436> 
		<1.511, 1.076, -1.436> <0.936, 1.076, -1.436> <-0.791, 1.076, -1.436> <-1.366, 1.076, -1.436> 
		<1.511, 1.183, -1.436> <0.936, 1.183, -1.436> <-0.791, 1.183, -1.436> <-1.366, 1.183, -1.436> 
		<1.511, 1.219, -1.436> <0.936, 1.219, -1.436> <-0.791, 1.219, -1.436> <-1.366, 1.219, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.511, 1.040, -1.234> <0.936, 1.040, -1.234> <-0.791, 1.040, -1.234> <-1.366, 1.040, -1.234> 
		<1.511, 1.040, -1.274> <0.936, 1.040, -1.274> <-0.791, 1.040, -1.274> <-1.366, 1.040, -1.274> 
		<1.511, 1.040, -1.416> <0.936, 1.040, -1.416> <-0.791, 1.040, -1.416> <-1.366, 1.040, -1.416> 
		<1.511, 1.040, -1.436> <0.936, 1.040, -1.436> <-0.791, 1.040, -1.436> <-1.366, 1.040, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.511, 1.040, -1.234> <0.936, 1.040, -1.234> <-0.791, 1.040, -1.234> <-1.366, 1.040, -1.234> 
		<1.511, 1.076, -1.234> <0.936, 1.076, -1.234> <-0.791, 1.076, -1.234> <-1.366, 1.076, -1.234> 
		<1.511, 1.183, -1.234> <0.936, 1.183, -1.234> <-0.791, 1.183, -1.234> <-1.366, 1.183, -1.234> 
		<1.511, 1.219, -1.234> <0.936, 1.219, -1.234> <-0.791, 1.219, -1.234> <-1.366, 1.219, -1.234> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.366, 1.040, -1.234> <-1.366, 1.076, -1.234> <-1.366, 1.183, -1.234> <-1.366, 1.219, -1.234> 
		<-1.366, 1.040, -1.274> <-1.366, 1.076, -1.274> <-1.366, 1.183, -1.274> <-1.366, 1.219, -1.274> 
		<-1.366, 1.040, -1.416> <-1.366, 1.076, -1.416> <-1.366, 1.183, -1.416> <-1.366, 1.219, -1.416> 
		<-1.366, 1.040, -1.436> <-1.366, 1.076, -1.436> <-1.366, 1.183, -1.436> <-1.366, 1.219, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.366, 1.219, -1.234> <-0.791, 1.219, -1.234> <0.936, 1.219, -1.234> <1.511, 1.219, -1.234> 
		<-1.366, 1.219, -1.274> <-0.791, 1.219, -1.274> <0.936, 1.219, -1.274> <1.511, 1.219, -1.274> 
		<-1.366, 1.219, -1.416> <-0.791, 1.219, -1.416> <0.936, 1.219, -1.416> <1.511, 1.219, -1.416> 
		<-1.366, 1.219, -1.436> <-0.791, 1.219, -1.436> <0.936, 1.219, -1.436> <1.511, 1.219, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.511, 1.219, -1.234> <1.511, 1.183, -1.234> <1.511, 1.076, -1.234> <1.511, 1.040, -1.234> 
		<1.511, 1.219, -1.274> <1.511, 1.183, -1.274> <1.511, 1.076, -1.274> <1.511, 1.040, -1.274> 
		<1.511, 1.219, -1.416> <1.511, 1.183, -1.416> <1.511, 1.076, -1.416> <1.511, 1.040, -1.416> 
		<1.511, 1.219, -1.436> <1.511, 1.183, -1.436> <1.511, 1.076, -1.436> <1.511, 1.040, -1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.532, 1.040, 1.213> <0.957, 1.040, 1.213> <-0.770, 1.040, 1.213> <-1.345, 1.040, 1.213> 
		<1.532, 1.076, 1.213> <0.957, 1.076, 1.213> <-0.770, 1.076, 1.213> <-1.345, 1.076, 1.213> 
		<1.532, 1.183, 1.213> <0.957, 1.183, 1.213> <-0.770, 1.183, 1.213> <-1.345, 1.183, 1.213> 
		<1.532, 1.219, 1.213> <0.957, 1.219, 1.213> <-0.770, 1.219, 1.213> <-1.345, 1.219, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.532, 1.040, 1.415> <0.957, 1.040, 1.415> <-0.770, 1.040, 1.415> <-1.345, 1.040, 1.415> 
		<1.532, 1.040, 1.375> <0.957, 1.040, 1.375> <-0.770, 1.040, 1.375> <-1.345, 1.040, 1.375> 
		<1.532, 1.040, 1.233> <0.957, 1.040, 1.233> <-0.770, 1.040, 1.233> <-1.345, 1.040, 1.233> 
		<1.532, 1.040, 1.213> <0.957, 1.040, 1.213> <-0.770, 1.040, 1.213> <-1.345, 1.040, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.532, 1.040, 1.415> <0.957, 1.040, 1.415> <-0.770, 1.040, 1.415> <-1.345, 1.040, 1.415> 
		<1.532, 1.076, 1.415> <0.957, 1.076, 1.415> <-0.770, 1.076, 1.415> <-1.345, 1.076, 1.415> 
		<1.532, 1.183, 1.415> <0.957, 1.183, 1.415> <-0.770, 1.183, 1.415> <-1.345, 1.183, 1.415> 
		<1.532, 1.219, 1.415> <0.957, 1.219, 1.415> <-0.770, 1.219, 1.415> <-1.345, 1.219, 1.415> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.345, 1.040, 1.415> <-1.345, 1.076, 1.415> <-1.345, 1.183, 1.415> <-1.345, 1.219, 1.415> 
		<-1.345, 1.040, 1.375> <-1.345, 1.076, 1.375> <-1.345, 1.183, 1.375> <-1.345, 1.219, 1.375> 
		<-1.345, 1.040, 1.233> <-1.345, 1.076, 1.233> <-1.345, 1.183, 1.233> <-1.345, 1.219, 1.233> 
		<-1.345, 1.040, 1.213> <-1.345, 1.076, 1.213> <-1.345, 1.183, 1.213> <-1.345, 1.219, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.345, 1.219, 1.415> <-0.770, 1.219, 1.415> <0.957, 1.219, 1.415> <1.532, 1.219, 1.415> 
		<-1.345, 1.219, 1.375> <-0.770, 1.219, 1.375> <0.957, 1.219, 1.375> <1.532, 1.219, 1.375> 
		<-1.345, 1.219, 1.233> <-0.770, 1.219, 1.233> <0.957, 1.219, 1.233> <1.532, 1.219, 1.233> 
		<-1.345, 1.219, 1.213> <-0.770, 1.219, 1.213> <0.957, 1.219, 1.213> <1.532, 1.219, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.532, 1.219, 1.415> <1.532, 1.183, 1.415> <1.532, 1.076, 1.415> <1.532, 1.040, 1.415> 
		<1.532, 1.219, 1.375> <1.532, 1.183, 1.375> <1.532, 1.076, 1.375> <1.532, 1.040, 1.375> 
		<1.532, 1.219, 1.233> <1.532, 1.183, 1.233> <1.532, 1.076, 1.233> <1.532, 1.040, 1.233> 
		<1.532, 1.219, 1.213> <1.532, 1.183, 1.213> <1.532, 1.076, 1.213> <1.532, 1.040, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.343, 1.040, -1.439> <-1.343, 1.040, -0.863> <-1.343, 1.040, 0.863> <-1.343, 1.040, 1.439> 
		<-1.343, 1.076, -1.439> <-1.343, 1.076, -0.863> <-1.343, 1.076, 0.863> <-1.343, 1.076, 1.439> 
		<-1.343, 1.183, -1.439> <-1.343, 1.183, -0.863> <-1.343, 1.183, 0.863> <-1.343, 1.183, 1.439> 
		<-1.343, 1.219, -1.439> <-1.343, 1.219, -0.863> <-1.343, 1.219, 0.863> <-1.343, 1.219, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.140, 1.040, -1.439> <-1.140, 1.040, -0.863> <-1.140, 1.040, 0.863> <-1.140, 1.040, 1.439> 
		<-1.181, 1.040, -1.439> <-1.181, 1.040, -0.863> <-1.181, 1.040, 0.863> <-1.181, 1.040, 1.439> 
		<-1.323, 1.040, -1.439> <-1.323, 1.040, -0.863> <-1.323, 1.040, 0.863> <-1.323, 1.040, 1.439> 
		<-1.343, 1.040, -1.439> <-1.343, 1.040, -0.863> <-1.343, 1.040, 0.863> <-1.343, 1.040, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.140, 1.040, -1.439> <-1.140, 1.040, -0.863> <-1.140, 1.040, 0.863> <-1.140, 1.040, 1.439> 
		<-1.140, 1.076, -1.439> <-1.140, 1.076, -0.863> <-1.140, 1.076, 0.863> <-1.140, 1.076, 1.439> 
		<-1.140, 1.183, -1.439> <-1.140, 1.183, -0.863> <-1.140, 1.183, 0.863> <-1.140, 1.183, 1.439> 
		<-1.140, 1.219, -1.439> <-1.140, 1.219, -0.863> <-1.140, 1.219, 0.863> <-1.140, 1.219, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.140, 1.040, 1.439> <-1.140, 1.076, 1.439> <-1.140, 1.183, 1.439> <-1.140, 1.219, 1.439> 
		<-1.181, 1.040, 1.439> <-1.181, 1.076, 1.439> <-1.181, 1.183, 1.439> <-1.181, 1.219, 1.439> 
		<-1.323, 1.040, 1.439> <-1.323, 1.076, 1.439> <-1.323, 1.183, 1.439> <-1.323, 1.219, 1.439> 
		<-1.343, 1.040, 1.439> <-1.343, 1.076, 1.439> <-1.343, 1.183, 1.439> <-1.343, 1.219, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.140, 1.219, 1.439> <-1.140, 1.219, 0.863> <-1.140, 1.219, -0.863> <-1.140, 1.219, -1.439> 
		<-1.181, 1.219, 1.439> <-1.181, 1.219, 0.863> <-1.181, 1.219, -0.863> <-1.181, 1.219, -1.439> 
		<-1.323, 1.219, 1.439> <-1.323, 1.219, 0.863> <-1.323, 1.219, -0.863> <-1.323, 1.219, -1.439> 
		<-1.343, 1.219, 1.439> <-1.343, 1.219, 0.863> <-1.343, 1.219, -0.863> <-1.343, 1.219, -1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.140, 1.219, -1.439> <-1.140, 1.183, -1.439> <-1.140, 1.076, -1.439> <-1.140, 1.040, -1.439> 
		<-1.181, 1.219, -1.439> <-1.181, 1.183, -1.439> <-1.181, 1.076, -1.439> <-1.181, 1.040, -1.439> 
		<-1.323, 1.219, -1.439> <-1.323, 1.183, -1.439> <-1.323, 1.076, -1.439> <-1.323, 1.040, -1.439> 
		<-1.343, 1.219, -1.439> <-1.343, 1.183, -1.439> <-1.343, 1.076, -1.439> <-1.343, 1.040, -1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.306, 1.040, -1.460> <1.306, 1.040, -0.884> <1.306, 1.040, 0.842> <1.306, 1.040, 1.418> 
		<1.306, 1.076, -1.460> <1.306, 1.076, -0.884> <1.306, 1.076, 0.842> <1.306, 1.076, 1.418> 
		<1.306, 1.183, -1.460> <1.306, 1.183, -0.884> <1.306, 1.183, 0.842> <1.306, 1.183, 1.418> 
		<1.306, 1.219, -1.460> <1.306, 1.219, -0.884> <1.306, 1.219, 0.842> <1.306, 1.219, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.509, 1.040, -1.460> <1.509, 1.040, -0.884> <1.509, 1.040, 0.842> <1.509, 1.040, 1.418> 
		<1.468, 1.040, -1.460> <1.468, 1.040, -0.884> <1.468, 1.040, 0.842> <1.468, 1.040, 1.418> 
		<1.326, 1.040, -1.460> <1.326, 1.040, -0.884> <1.326, 1.040, 0.842> <1.326, 1.040, 1.418> 
		<1.306, 1.040, -1.460> <1.306, 1.040, -0.884> <1.306, 1.040, 0.842> <1.306, 1.040, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.509, 1.040, -1.460> <1.509, 1.040, -0.884> <1.509, 1.040, 0.842> <1.509, 1.040, 1.418> 
		<1.509, 1.076, -1.460> <1.509, 1.076, -0.884> <1.509, 1.076, 0.842> <1.509, 1.076, 1.418> 
		<1.509, 1.183, -1.460> <1.509, 1.183, -0.884> <1.509, 1.183, 0.842> <1.509, 1.183, 1.418> 
		<1.509, 1.219, -1.460> <1.509, 1.219, -0.884> <1.509, 1.219, 0.842> <1.509, 1.219, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.509, 1.040, 1.418> <1.509, 1.076, 1.418> <1.509, 1.183, 1.418> <1.509, 1.219, 1.418> 
		<1.468, 1.040, 1.418> <1.468, 1.076, 1.418> <1.468, 1.183, 1.418> <1.468, 1.219, 1.418> 
		<1.326, 1.040, 1.418> <1.326, 1.076, 1.418> <1.326, 1.183, 1.418> <1.326, 1.219, 1.418> 
		<1.306, 1.040, 1.418> <1.306, 1.076, 1.418> <1.306, 1.183, 1.418> <1.306, 1.219, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.509, 1.219, 1.418> <1.509, 1.219, 0.842> <1.509, 1.219, -0.884> <1.509, 1.219, -1.460> 
		<1.468, 1.219, 1.418> <1.468, 1.219, 0.842> <1.468, 1.219, -0.884> <1.468, 1.219, -1.460> 
		<1.326, 1.219, 1.418> <1.326, 1.219, 0.842> <1.326, 1.219, -0.884> <1.326, 1.219, -1.460> 
		<1.306, 1.219, 1.418> <1.306, 1.219, 0.842> <1.306, 1.219, -0.884> <1.306, 1.219, -1.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.509, 1.219, -1.460> <1.509, 1.183, -1.460> <1.509, 1.076, -1.460> <1.509, 1.040, -1.460> 
		<1.468, 1.219, -1.460> <1.468, 1.183, -1.460> <1.468, 1.076, -1.460> <1.468, 1.040, -1.460> 
		<1.326, 1.219, -1.460> <1.326, 1.183, -1.460> <1.326, 1.076, -1.460> <1.326, 1.040, -1.460> 
		<1.306, 1.219, -1.460> <1.306, 1.183, -1.460> <1.306, 1.076, -1.460> <1.306, 1.040, -1.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.360, -2.018, -1.439> <-1.360, -2.018, -0.863> <-1.360, -2.018, 0.863> <-1.360, -2.018, 1.439> 
		<-1.360, -1.982, -1.439> <-1.360, -1.982, -0.863> <-1.360, -1.982, 0.863> <-1.360, -1.982, 1.439> 
		<-1.360, -1.875, -1.439> <-1.360, -1.875, -0.863> <-1.360, -1.875, 0.863> <-1.360, -1.875, 1.439> 
		<-1.360, -1.839, -1.439> <-1.360, -1.839, -0.863> <-1.360, -1.839, 0.863> <-1.360, -1.839, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.158, -2.018, -1.439> <-1.158, -2.018, -0.863> <-1.158, -2.018, 0.863> <-1.158, -2.018, 1.439> 
		<-1.198, -2.018, -1.439> <-1.198, -2.018, -0.863> <-1.198, -2.018, 0.863> <-1.198, -2.018, 1.439> 
		<-1.340, -2.018, -1.439> <-1.340, -2.018, -0.863> <-1.340, -2.018, 0.863> <-1.340, -2.018, 1.439> 
		<-1.360, -2.018, -1.439> <-1.360, -2.018, -0.863> <-1.360, -2.018, 0.863> <-1.360, -2.018, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.158, -2.018, -1.439> <-1.158, -2.018, -0.863> <-1.158, -2.018, 0.863> <-1.158, -2.018, 1.439> 
		<-1.158, -1.982, -1.439> <-1.158, -1.982, -0.863> <-1.158, -1.982, 0.863> <-1.158, -1.982, 1.439> 
		<-1.158, -1.875, -1.439> <-1.158, -1.875, -0.863> <-1.158, -1.875, 0.863> <-1.158, -1.875, 1.439> 
		<-1.158, -1.839, -1.439> <-1.158, -1.839, -0.863> <-1.158, -1.839, 0.863> <-1.158, -1.839, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.158, -2.018, 1.439> <-1.158, -1.982, 1.439> <-1.158, -1.875, 1.439> <-1.158, -1.839, 1.439> 
		<-1.198, -2.018, 1.439> <-1.198, -1.982, 1.439> <-1.198, -1.875, 1.439> <-1.198, -1.839, 1.439> 
		<-1.340, -2.018, 1.439> <-1.340, -1.982, 1.439> <-1.340, -1.875, 1.439> <-1.340, -1.839, 1.439> 
		<-1.360, -2.018, 1.439> <-1.360, -1.982, 1.439> <-1.360, -1.875, 1.439> <-1.360, -1.839, 1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.158, -1.839, 1.439> <-1.158, -1.839, 0.863> <-1.158, -1.839, -0.863> <-1.158, -1.839, -1.439> 
		<-1.198, -1.839, 1.439> <-1.198, -1.839, 0.863> <-1.198, -1.839, -0.863> <-1.198, -1.839, -1.439> 
		<-1.340, -1.839, 1.439> <-1.340, -1.839, 0.863> <-1.340, -1.839, -0.863> <-1.340, -1.839, -1.439> 
		<-1.360, -1.839, 1.439> <-1.360, -1.839, 0.863> <-1.360, -1.839, -0.863> <-1.360, -1.839, -1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.158, -1.839, -1.439> <-1.158, -1.875, -1.439> <-1.158, -1.982, -1.439> <-1.158, -2.018, -1.439> 
		<-1.198, -1.839, -1.439> <-1.198, -1.875, -1.439> <-1.198, -1.982, -1.439> <-1.198, -2.018, -1.439> 
		<-1.340, -1.839, -1.439> <-1.340, -1.875, -1.439> <-1.340, -1.982, -1.439> <-1.340, -2.018, -1.439> 
		<-1.360, -1.839, -1.439> <-1.360, -1.875, -1.439> <-1.360, -1.982, -1.439> <-1.360, -2.018, -1.439> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.289, -2.018, -1.460> <1.289, -2.018, -0.884> <1.289, -2.018, 0.842> <1.289, -2.018, 1.418> 
		<1.289, -1.982, -1.460> <1.289, -1.982, -0.884> <1.289, -1.982, 0.842> <1.289, -1.982, 1.418> 
		<1.289, -1.875, -1.460> <1.289, -1.875, -0.884> <1.289, -1.875, 0.842> <1.289, -1.875, 1.418> 
		<1.289, -1.839, -1.460> <1.289, -1.839, -0.884> <1.289, -1.839, 0.842> <1.289, -1.839, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, -2.018, -1.460> <1.491, -2.018, -0.884> <1.491, -2.018, 0.842> <1.491, -2.018, 1.418> 
		<1.451, -2.018, -1.460> <1.451, -2.018, -0.884> <1.451, -2.018, 0.842> <1.451, -2.018, 1.418> 
		<1.309, -2.018, -1.460> <1.309, -2.018, -0.884> <1.309, -2.018, 0.842> <1.309, -2.018, 1.418> 
		<1.289, -2.018, -1.460> <1.289, -2.018, -0.884> <1.289, -2.018, 0.842> <1.289, -2.018, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, -2.018, -1.460> <1.491, -2.018, -0.884> <1.491, -2.018, 0.842> <1.491, -2.018, 1.418> 
		<1.491, -1.982, -1.460> <1.491, -1.982, -0.884> <1.491, -1.982, 0.842> <1.491, -1.982, 1.418> 
		<1.491, -1.875, -1.460> <1.491, -1.875, -0.884> <1.491, -1.875, 0.842> <1.491, -1.875, 1.418> 
		<1.491, -1.839, -1.460> <1.491, -1.839, -0.884> <1.491, -1.839, 0.842> <1.491, -1.839, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, -2.018, 1.418> <1.491, -1.982, 1.418> <1.491, -1.875, 1.418> <1.491, -1.839, 1.418> 
		<1.451, -2.018, 1.418> <1.451, -1.982, 1.418> <1.451, -1.875, 1.418> <1.451, -1.839, 1.418> 
		<1.309, -2.018, 1.418> <1.309, -1.982, 1.418> <1.309, -1.875, 1.418> <1.309, -1.839, 1.418> 
		<1.289, -2.018, 1.418> <1.289, -1.982, 1.418> <1.289, -1.875, 1.418> <1.289, -1.839, 1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, -1.839, 1.418> <1.491, -1.839, 0.842> <1.491, -1.839, -0.884> <1.491, -1.839, -1.460> 
		<1.451, -1.839, 1.418> <1.451, -1.839, 0.842> <1.451, -1.839, -0.884> <1.451, -1.839, -1.460> 
		<1.309, -1.839, 1.418> <1.309, -1.839, 0.842> <1.309, -1.839, -0.884> <1.309, -1.839, -1.460> 
		<1.289, -1.839, 1.418> <1.289, -1.839, 0.842> <1.289, -1.839, -0.884> <1.289, -1.839, -1.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, -1.839, -1.460> <1.491, -1.875, -1.460> <1.491, -1.982, -1.460> <1.491, -2.018, -1.460> 
		<1.451, -1.839, -1.460> <1.451, -1.875, -1.460> <1.451, -1.982, -1.460> <1.451, -2.018, -1.460> 
		<1.309, -1.839, -1.460> <1.309, -1.875, -1.460> <1.309, -1.982, -1.460> <1.309, -2.018, -1.460> 
		<1.289, -1.839, -1.460> <1.289, -1.875, -1.460> <1.289, -1.982, -1.460> <1.289, -2.018, -1.460> 
	}
	//pigment{rgb <234/255, 185/255, 16/255>}
	//finish{phong 1}

}

//patch_obj_01
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.550, 2.286, -1.619> <-0.578, 2.286, -1.619> <0.717, 2.286, -1.619> <1.689, 2.286, -1.619> 
		<-1.550, 2.207, -1.619> <-0.578, 2.207, -1.619> <0.717, 2.207, -1.619> <1.689, 2.207, -1.619> 
		<-1.550, 2.102, -1.619> <-0.578, 2.102, -1.619> <0.717, 2.102, -1.619> <1.689, 2.102, -1.619> 
		<-1.550, 2.023, -1.619> <-0.578, 2.023, -1.619> <0.717, 2.023, -1.619> <1.689, 2.023, -1.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.550, 2.286, 1.619> <-0.578, 2.286, 1.619> <0.717, 2.286, 1.619> <1.689, 2.286, 1.619> 
		<-1.550, 2.286, 0.648> <-0.578, 2.286, 0.648> <0.717, 2.286, 0.648> <1.689, 2.286, 0.648> 
		<-1.550, 2.286, -0.648> <-0.578, 2.286, -0.648> <0.717, 2.286, -0.648> <1.689, 2.286, -0.648> 
		<-1.550, 2.286, -1.619> <-0.578, 2.286, -1.619> <0.717, 2.286, -1.619> <1.689, 2.286, -1.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.550, 2.286, 1.619> <-0.578, 2.286, 1.619> <0.717, 2.286, 1.619> <1.689, 2.286, 1.619> 
		<-1.550, 2.207, 1.619> <-0.578, 2.207, 1.619> <0.717, 2.207, 1.619> <1.689, 2.207, 1.619> 
		<-1.550, 2.102, 1.619> <-0.578, 2.102, 1.619> <0.717, 2.102, 1.619> <1.689, 2.102, 1.619> 
		<-1.550, 2.023, 1.619> <-0.578, 2.023, 1.619> <0.717, 2.023, 1.619> <1.689, 2.023, 1.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.689, 2.286, 1.619> <1.689, 2.207, 1.619> <1.689, 2.102, 1.619> <1.689, 2.023, 1.619> 
		<1.689, 2.286, 0.648> <1.689, 2.207, 0.648> <1.689, 2.102, 0.648> <1.689, 2.023, 0.648> 
		<1.689, 2.286, -0.648> <1.689, 2.207, -0.648> <1.689, 2.102, -0.648> <1.689, 2.023, -0.648> 
		<1.689, 2.286, -1.619> <1.689, 2.207, -1.619> <1.689, 2.102, -1.619> <1.689, 2.023, -1.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.689, 2.023, 1.619> <0.717, 2.023, 1.619> <-0.578, 2.023, 1.619> <-1.550, 2.023, 1.619> 
		<1.689, 2.023, 0.648> <0.717, 2.023, 0.648> <-0.578, 2.023, 0.648> <-1.550, 2.023, 0.648> 
		<1.689, 2.023, -0.648> <0.717, 2.023, -0.648> <-0.578, 2.023, -0.648> <-1.550, 2.023, -0.648> 
		<1.689, 2.023, -1.619> <0.717, 2.023, -1.619> <-0.578, 2.023, -1.619> <-1.550, 2.023, -1.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.550, 2.023, 1.619> <-1.550, 2.102, 1.619> <-1.550, 2.207, 1.619> <-1.550, 2.286, 1.619> 
		<-1.550, 2.023, 0.648> <-1.550, 2.102, 0.648> <-1.550, 2.207, 0.648> <-1.550, 2.286, 0.648> 
		<-1.550, 2.023, -0.648> <-1.550, 2.102, -0.648> <-1.550, 2.207, -0.648> <-1.550, 2.286, -0.648> 
		<-1.550, 2.023, -1.619> <-1.550, 2.102, -1.619> <-1.550, 2.207, -1.619> <-1.550, 2.286, -1.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.179, 6.317, 1.213> <-1.179, 5.458, 1.213> <-1.179, 2.881, 1.213> <-1.179, 2.022, 1.213> 
		<-1.215, 6.317, 1.213> <-1.215, 5.458, 1.213> <-1.215, 2.881, 1.213> <-1.215, 2.022, 1.213> 
		<-1.322, 6.317, 1.213> <-1.322, 5.458, 1.213> <-1.322, 2.881, 1.213> <-1.322, 2.022, 1.213> 
		<-1.358, 6.317, 1.213> <-1.358, 5.458, 1.213> <-1.358, 2.881, 1.213> <-1.358, 2.022, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.179, 6.317, 1.415> <-1.179, 5.458, 1.415> <-1.179, 2.881, 1.415> <-1.179, 2.022, 1.415> 
		<-1.179, 6.317, 1.375> <-1.179, 5.458, 1.375> <-1.179, 2.881, 1.375> <-1.179, 2.022, 1.375> 
		<-1.179, 6.317, 1.233> <-1.179, 5.458, 1.233> <-1.179, 2.881, 1.233> <-1.179, 2.022, 1.233> 
		<-1.179, 6.317, 1.213> <-1.179, 5.458, 1.213> <-1.179, 2.881, 1.213> <-1.179, 2.022, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.179, 6.317, 1.415> <-1.179, 5.458, 1.415> <-1.179, 2.881, 1.415> <-1.179, 2.022, 1.415> 
		<-1.215, 6.317, 1.415> <-1.215, 5.458, 1.415> <-1.215, 2.881, 1.415> <-1.215, 2.022, 1.415> 
		<-1.322, 6.317, 1.415> <-1.322, 5.458, 1.415> <-1.322, 2.881, 1.415> <-1.322, 2.022, 1.415> 
		<-1.358, 6.317, 1.415> <-1.358, 5.458, 1.415> <-1.358, 2.881, 1.415> <-1.358, 2.022, 1.415> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.179, 2.022, 1.415> <-1.215, 2.022, 1.415> <-1.322, 2.022, 1.415> <-1.358, 2.022, 1.415> 
		<-1.179, 2.022, 1.375> <-1.215, 2.022, 1.375> <-1.322, 2.022, 1.375> <-1.358, 2.022, 1.375> 
		<-1.179, 2.022, 1.233> <-1.215, 2.022, 1.233> <-1.322, 2.022, 1.233> <-1.358, 2.022, 1.233> 
		<-1.179, 2.022, 1.213> <-1.215, 2.022, 1.213> <-1.322, 2.022, 1.213> <-1.358, 2.022, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.358, 2.022, 1.415> <-1.358, 2.881, 1.415> <-1.358, 5.458, 1.415> <-1.358, 6.317, 1.415> 
		<-1.358, 2.022, 1.375> <-1.358, 2.881, 1.375> <-1.358, 5.458, 1.375> <-1.358, 6.317, 1.375> 
		<-1.358, 2.022, 1.233> <-1.358, 2.881, 1.233> <-1.358, 5.458, 1.233> <-1.358, 6.317, 1.233> 
		<-1.358, 2.022, 1.213> <-1.358, 2.881, 1.213> <-1.358, 5.458, 1.213> <-1.358, 6.317, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.358, 6.317, 1.415> <-1.322, 6.317, 1.415> <-1.215, 6.317, 1.415> <-1.179, 6.317, 1.415> 
		<-1.358, 6.317, 1.375> <-1.322, 6.317, 1.375> <-1.215, 6.317, 1.375> <-1.179, 6.317, 1.375> 
		<-1.358, 6.317, 1.233> <-1.322, 6.317, 1.233> <-1.215, 6.317, 1.233> <-1.179, 6.317, 1.233> 
		<-1.358, 6.317, 1.213> <-1.322, 6.317, 1.213> <-1.215, 6.317, 1.213> <-1.179, 6.317, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, 6.317, 1.213> <1.491, 5.458, 1.213> <1.491, 2.881, 1.213> <1.491, 2.022, 1.213> 
		<1.455, 6.317, 1.213> <1.455, 5.458, 1.213> <1.455, 2.881, 1.213> <1.455, 2.022, 1.213> 
		<1.347, 6.317, 1.213> <1.347, 5.458, 1.213> <1.347, 2.881, 1.213> <1.347, 2.022, 1.213> 
		<1.312, 6.317, 1.213> <1.312, 5.458, 1.213> <1.312, 2.881, 1.213> <1.312, 2.022, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, 6.317, 1.415> <1.491, 5.458, 1.415> <1.491, 2.881, 1.415> <1.491, 2.022, 1.415> 
		<1.491, 6.317, 1.375> <1.491, 5.458, 1.375> <1.491, 2.881, 1.375> <1.491, 2.022, 1.375> 
		<1.491, 6.317, 1.233> <1.491, 5.458, 1.233> <1.491, 2.881, 1.233> <1.491, 2.022, 1.233> 
		<1.491, 6.317, 1.213> <1.491, 5.458, 1.213> <1.491, 2.881, 1.213> <1.491, 2.022, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, 6.317, 1.415> <1.491, 5.458, 1.415> <1.491, 2.881, 1.415> <1.491, 2.022, 1.415> 
		<1.455, 6.317, 1.415> <1.455, 5.458, 1.415> <1.455, 2.881, 1.415> <1.455, 2.022, 1.415> 
		<1.347, 6.317, 1.415> <1.347, 5.458, 1.415> <1.347, 2.881, 1.415> <1.347, 2.022, 1.415> 
		<1.312, 6.317, 1.415> <1.312, 5.458, 1.415> <1.312, 2.881, 1.415> <1.312, 2.022, 1.415> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.491, 2.022, 1.415> <1.455, 2.022, 1.415> <1.347, 2.022, 1.415> <1.312, 2.022, 1.415> 
		<1.491, 2.022, 1.375> <1.455, 2.022, 1.375> <1.347, 2.022, 1.375> <1.312, 2.022, 1.375> 
		<1.491, 2.022, 1.233> <1.455, 2.022, 1.233> <1.347, 2.022, 1.233> <1.312, 2.022, 1.233> 
		<1.491, 2.022, 1.213> <1.455, 2.022, 1.213> <1.347, 2.022, 1.213> <1.312, 2.022, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.312, 2.022, 1.415> <1.312, 2.881, 1.415> <1.312, 5.458, 1.415> <1.312, 6.317, 1.415> 
		<1.312, 2.022, 1.375> <1.312, 2.881, 1.375> <1.312, 5.458, 1.375> <1.312, 6.317, 1.375> 
		<1.312, 2.022, 1.233> <1.312, 2.881, 1.233> <1.312, 5.458, 1.233> <1.312, 6.317, 1.233> 
		<1.312, 2.022, 1.213> <1.312, 2.881, 1.213> <1.312, 5.458, 1.213> <1.312, 6.317, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.312, 6.317, 1.415> <1.347, 6.317, 1.415> <1.455, 6.317, 1.415> <1.491, 6.317, 1.415> 
		<1.312, 6.317, 1.375> <1.347, 6.317, 1.375> <1.455, 6.317, 1.375> <1.491, 6.317, 1.375> 
		<1.312, 6.317, 1.233> <1.347, 6.317, 1.233> <1.455, 6.317, 1.233> <1.491, 6.317, 1.233> 
		<1.312, 6.317, 1.213> <1.347, 6.317, 1.213> <1.455, 6.317, 1.213> <1.491, 6.317, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.464, 6.130, 1.213> <0.904, 6.130, 1.213> <-0.777, 6.130, 1.213> <-1.337, 6.130, 1.213> 
		<1.464, 6.166, 1.213> <0.904, 6.166, 1.213> <-0.777, 6.166, 1.213> <-1.337, 6.166, 1.213> 
		<1.464, 6.273, 1.213> <0.904, 6.273, 1.213> <-0.777, 6.273, 1.213> <-1.337, 6.273, 1.213> 
		<1.464, 6.309, 1.213> <0.904, 6.309, 1.213> <-0.777, 6.309, 1.213> <-1.337, 6.309, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.464, 6.130, 1.415> <0.904, 6.130, 1.415> <-0.777, 6.130, 1.415> <-1.337, 6.130, 1.415> 
		<1.464, 6.130, 1.375> <0.904, 6.130, 1.375> <-0.777, 6.130, 1.375> <-1.337, 6.130, 1.375> 
		<1.464, 6.130, 1.233> <0.904, 6.130, 1.233> <-0.777, 6.130, 1.233> <-1.337, 6.130, 1.233> 
		<1.464, 6.130, 1.213> <0.904, 6.130, 1.213> <-0.777, 6.130, 1.213> <-1.337, 6.130, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.464, 6.130, 1.415> <0.904, 6.130, 1.415> <-0.777, 6.130, 1.415> <-1.337, 6.130, 1.415> 
		<1.464, 6.166, 1.415> <0.904, 6.166, 1.415> <-0.777, 6.166, 1.415> <-1.337, 6.166, 1.415> 
		<1.464, 6.273, 1.415> <0.904, 6.273, 1.415> <-0.777, 6.273, 1.415> <-1.337, 6.273, 1.415> 
		<1.464, 6.309, 1.415> <0.904, 6.309, 1.415> <-0.777, 6.309, 1.415> <-1.337, 6.309, 1.415> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.337, 6.130, 1.415> <-1.337, 6.166, 1.415> <-1.337, 6.273, 1.415> <-1.337, 6.309, 1.415> 
		<-1.337, 6.130, 1.375> <-1.337, 6.166, 1.375> <-1.337, 6.273, 1.375> <-1.337, 6.309, 1.375> 
		<-1.337, 6.130, 1.233> <-1.337, 6.166, 1.233> <-1.337, 6.273, 1.233> <-1.337, 6.309, 1.233> 
		<-1.337, 6.130, 1.213> <-1.337, 6.166, 1.213> <-1.337, 6.273, 1.213> <-1.337, 6.309, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.337, 6.309, 1.415> <-0.777, 6.309, 1.415> <0.904, 6.309, 1.415> <1.464, 6.309, 1.415> 
		<-1.337, 6.309, 1.375> <-0.777, 6.309, 1.375> <0.904, 6.309, 1.375> <1.464, 6.309, 1.375> 
		<-1.337, 6.309, 1.233> <-0.777, 6.309, 1.233> <0.904, 6.309, 1.233> <1.464, 6.309, 1.233> 
		<-1.337, 6.309, 1.213> <-0.777, 6.309, 1.213> <0.904, 6.309, 1.213> <1.464, 6.309, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.464, 6.309, 1.415> <1.464, 6.273, 1.415> <1.464, 6.166, 1.415> <1.464, 6.130, 1.415> 
		<1.464, 6.309, 1.375> <1.464, 6.273, 1.375> <1.464, 6.166, 1.375> <1.464, 6.130, 1.375> 
		<1.464, 6.309, 1.233> <1.464, 6.273, 1.233> <1.464, 6.166, 1.233> <1.464, 6.130, 1.233> 
		<1.464, 6.309, 1.213> <1.464, 6.273, 1.213> <1.464, 6.166, 1.213> <1.464, 6.130, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.373, 6.210, 1.192> <-0.373, 5.394, 1.192> <-0.373, 2.945, 1.192> <-0.373, 2.129, 1.192> 
		<-0.409, 6.210, 1.192> <-0.409, 5.394, 1.192> <-0.409, 2.945, 1.192> <-0.409, 2.129, 1.192> 
		<-0.516, 6.210, 1.192> <-0.516, 5.394, 1.192> <-0.516, 2.945, 1.192> <-0.516, 2.129, 1.192> 
		<-0.552, 6.210, 1.192> <-0.552, 5.394, 1.192> <-0.552, 2.945, 1.192> <-0.552, 2.129, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.373, 6.210, 1.395> <-0.373, 5.394, 1.395> <-0.373, 2.945, 1.395> <-0.373, 2.129, 1.395> 
		<-0.373, 6.210, 1.354> <-0.373, 5.394, 1.354> <-0.373, 2.945, 1.354> <-0.373, 2.129, 1.354> 
		<-0.373, 6.210, 1.212> <-0.373, 5.394, 1.212> <-0.373, 2.945, 1.212> <-0.373, 2.129, 1.212> 
		<-0.373, 6.210, 1.192> <-0.373, 5.394, 1.192> <-0.373, 2.945, 1.192> <-0.373, 2.129, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.373, 6.210, 1.395> <-0.373, 5.394, 1.395> <-0.373, 2.945, 1.395> <-0.373, 2.129, 1.395> 
		<-0.409, 6.210, 1.395> <-0.409, 5.394, 1.395> <-0.409, 2.945, 1.395> <-0.409, 2.129, 1.395> 
		<-0.516, 6.210, 1.395> <-0.516, 5.394, 1.395> <-0.516, 2.945, 1.395> <-0.516, 2.129, 1.395> 
		<-0.552, 6.210, 1.395> <-0.552, 5.394, 1.395> <-0.552, 2.945, 1.395> <-0.552, 2.129, 1.395> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.373, 2.129, 1.395> <-0.409, 2.129, 1.395> <-0.516, 2.129, 1.395> <-0.552, 2.129, 1.395> 
		<-0.373, 2.129, 1.354> <-0.409, 2.129, 1.354> <-0.516, 2.129, 1.354> <-0.552, 2.129, 1.354> 
		<-0.373, 2.129, 1.212> <-0.409, 2.129, 1.212> <-0.516, 2.129, 1.212> <-0.552, 2.129, 1.212> 
		<-0.373, 2.129, 1.192> <-0.409, 2.129, 1.192> <-0.516, 2.129, 1.192> <-0.552, 2.129, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.552, 2.129, 1.395> <-0.552, 2.945, 1.395> <-0.552, 5.394, 1.395> <-0.552, 6.210, 1.395> 
		<-0.552, 2.129, 1.354> <-0.552, 2.945, 1.354> <-0.552, 5.394, 1.354> <-0.552, 6.210, 1.354> 
		<-0.552, 2.129, 1.212> <-0.552, 2.945, 1.212> <-0.552, 5.394, 1.212> <-0.552, 6.210, 1.212> 
		<-0.552, 2.129, 1.192> <-0.552, 2.945, 1.192> <-0.552, 5.394, 1.192> <-0.552, 6.210, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.552, 6.210, 1.395> <-0.516, 6.210, 1.395> <-0.409, 6.210, 1.395> <-0.373, 6.210, 1.395> 
		<-0.552, 6.210, 1.354> <-0.516, 6.210, 1.354> <-0.409, 6.210, 1.354> <-0.373, 6.210, 1.354> 
		<-0.552, 6.210, 1.212> <-0.516, 6.210, 1.212> <-0.409, 6.210, 1.212> <-0.373, 6.210, 1.212> 
		<-0.552, 6.210, 1.192> <-0.516, 6.210, 1.192> <-0.409, 6.210, 1.192> <-0.373, 6.210, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.565, 6.227, 1.192> <0.565, 5.411, 1.192> <0.565, 2.963, 1.192> <0.565, 2.147, 1.192> 
		<0.529, 6.227, 1.192> <0.529, 5.411, 1.192> <0.529, 2.963, 1.192> <0.529, 2.147, 1.192> 
		<0.422, 6.227, 1.192> <0.422, 5.411, 1.192> <0.422, 2.963, 1.192> <0.422, 2.147, 1.192> 
		<0.386, 6.227, 1.192> <0.386, 5.411, 1.192> <0.386, 2.963, 1.192> <0.386, 2.147, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.565, 6.227, 1.395> <0.565, 5.411, 1.395> <0.565, 2.963, 1.395> <0.565, 2.147, 1.395> 
		<0.565, 6.227, 1.354> <0.565, 5.411, 1.354> <0.565, 2.963, 1.354> <0.565, 2.147, 1.354> 
		<0.565, 6.227, 1.212> <0.565, 5.411, 1.212> <0.565, 2.963, 1.212> <0.565, 2.147, 1.212> 
		<0.565, 6.227, 1.192> <0.565, 5.411, 1.192> <0.565, 2.963, 1.192> <0.565, 2.147, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.565, 6.227, 1.395> <0.565, 5.411, 1.395> <0.565, 2.963, 1.395> <0.565, 2.147, 1.395> 
		<0.529, 6.227, 1.395> <0.529, 5.411, 1.395> <0.529, 2.963, 1.395> <0.529, 2.147, 1.395> 
		<0.422, 6.227, 1.395> <0.422, 5.411, 1.395> <0.422, 2.963, 1.395> <0.422, 2.147, 1.395> 
		<0.386, 6.227, 1.395> <0.386, 5.411, 1.395> <0.386, 2.963, 1.395> <0.386, 2.147, 1.395> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.565, 2.147, 1.395> <0.529, 2.147, 1.395> <0.422, 2.147, 1.395> <0.386, 2.147, 1.395> 
		<0.565, 2.147, 1.354> <0.529, 2.147, 1.354> <0.422, 2.147, 1.354> <0.386, 2.147, 1.354> 
		<0.565, 2.147, 1.212> <0.529, 2.147, 1.212> <0.422, 2.147, 1.212> <0.386, 2.147, 1.212> 
		<0.565, 2.147, 1.192> <0.529, 2.147, 1.192> <0.422, 2.147, 1.192> <0.386, 2.147, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.386, 2.147, 1.395> <0.386, 2.963, 1.395> <0.386, 5.411, 1.395> <0.386, 6.227, 1.395> 
		<0.386, 2.147, 1.354> <0.386, 2.963, 1.354> <0.386, 5.411, 1.354> <0.386, 6.227, 1.354> 
		<0.386, 2.147, 1.212> <0.386, 2.963, 1.212> <0.386, 5.411, 1.212> <0.386, 6.227, 1.212> 
		<0.386, 2.147, 1.192> <0.386, 2.963, 1.192> <0.386, 5.411, 1.192> <0.386, 6.227, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.386, 6.227, 1.395> <0.422, 6.227, 1.395> <0.529, 6.227, 1.395> <0.565, 6.227, 1.395> 
		<0.386, 6.227, 1.354> <0.422, 6.227, 1.354> <0.529, 6.227, 1.354> <0.565, 6.227, 1.354> 
		<0.386, 6.227, 1.212> <0.422, 6.227, 1.212> <0.529, 6.227, 1.212> <0.565, 6.227, 1.212> 
		<0.386, 6.227, 1.192> <0.422, 6.227, 1.192> <0.529, 6.227, 1.192> <0.565, 6.227, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 4.619, 1.192> <0.306, 4.619, 1.192> <-0.328, 4.619, 1.192> <-0.539, 4.619, 1.192> 
		<0.517, 4.654, 1.192> <0.306, 4.654, 1.192> <-0.328, 4.654, 1.192> <-0.539, 4.654, 1.192> 
		<0.517, 4.762, 1.192> <0.306, 4.762, 1.192> <-0.328, 4.762, 1.192> <-0.539, 4.762, 1.192> 
		<0.517, 4.798, 1.192> <0.306, 4.798, 1.192> <-0.328, 4.798, 1.192> <-0.539, 4.798, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 4.619, 1.395> <0.306, 4.619, 1.395> <-0.328, 4.619, 1.395> <-0.539, 4.619, 1.395> 
		<0.517, 4.619, 1.354> <0.306, 4.619, 1.354> <-0.328, 4.619, 1.354> <-0.539, 4.619, 1.354> 
		<0.517, 4.619, 1.212> <0.306, 4.619, 1.212> <-0.328, 4.619, 1.212> <-0.539, 4.619, 1.212> 
		<0.517, 4.619, 1.192> <0.306, 4.619, 1.192> <-0.328, 4.619, 1.192> <-0.539, 4.619, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 4.619, 1.395> <0.306, 4.619, 1.395> <-0.328, 4.619, 1.395> <-0.539, 4.619, 1.395> 
		<0.517, 4.654, 1.395> <0.306, 4.654, 1.395> <-0.328, 4.654, 1.395> <-0.539, 4.654, 1.395> 
		<0.517, 4.762, 1.395> <0.306, 4.762, 1.395> <-0.328, 4.762, 1.395> <-0.539, 4.762, 1.395> 
		<0.517, 4.798, 1.395> <0.306, 4.798, 1.395> <-0.328, 4.798, 1.395> <-0.539, 4.798, 1.395> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, 4.619, 1.395> <-0.539, 4.654, 1.395> <-0.539, 4.762, 1.395> <-0.539, 4.798, 1.395> 
		<-0.539, 4.619, 1.354> <-0.539, 4.654, 1.354> <-0.539, 4.762, 1.354> <-0.539, 4.798, 1.354> 
		<-0.539, 4.619, 1.212> <-0.539, 4.654, 1.212> <-0.539, 4.762, 1.212> <-0.539, 4.798, 1.212> 
		<-0.539, 4.619, 1.192> <-0.539, 4.654, 1.192> <-0.539, 4.762, 1.192> <-0.539, 4.798, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, 4.798, 1.395> <-0.328, 4.798, 1.395> <0.306, 4.798, 1.395> <0.517, 4.798, 1.395> 
		<-0.539, 4.798, 1.354> <-0.328, 4.798, 1.354> <0.306, 4.798, 1.354> <0.517, 4.798, 1.354> 
		<-0.539, 4.798, 1.212> <-0.328, 4.798, 1.212> <0.306, 4.798, 1.212> <0.517, 4.798, 1.212> 
		<-0.539, 4.798, 1.192> <-0.328, 4.798, 1.192> <0.306, 4.798, 1.192> <0.517, 4.798, 1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.517, 4.798, 1.395> <0.517, 4.762, 1.395> <0.517, 4.654, 1.395> <0.517, 4.619, 1.395> 
		<0.517, 4.798, 1.354> <0.517, 4.762, 1.354> <0.517, 4.654, 1.354> <0.517, 4.619, 1.354> 
		<0.517, 4.798, 1.212> <0.517, 4.762, 1.212> <0.517, 4.654, 1.212> <0.517, 4.619, 1.212> 
		<0.517, 4.798, 1.192> <0.517, 4.762, 1.192> <0.517, 4.654, 1.192> <0.517, 4.619, 1.192> 
	}
	//pigment{rgb <213/255, 214/255, 89/255>}
	//finish{phong 1}

}


}
