


/*

         " the temple "
         
         (c) Pierrick Zoss 2001
         
         
         
sorry for the english-french mix :)

*/


// nul :     +fn +w130 +h170
// cool :    +fn +w390 +h510 +a
// final :   +fn +w455 +h595 +a
// Too big : +fn +w1300 +h1700 +a



#include "colors.inc"
#include "skies.inc"
#include "bird.pov"
#include "pot.pov"
#include "rad_def.inc"








#declare rad = yes;
#declare tex = yes;

#declare lum = 0.7;



global_settings {
  #if (rad)
    /*radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 100
      nearest_count 5//4
      error_bound 1//0.6
      recursion_limit 2//1
      low_error_factor 0.8
      gray_threshold 0
      minimum_reuse 0.015
      brightness 1.0
      adc_bailout 0.01/0.4//0.01/2
    }*/
    radiosity {Rad_Settings(Radiosity_OutdoorHQ, off, off)}
  #end
}




//----------------------------------- textures ------------------------------------


#declare catelles =
texture {
  pigment {
    image_pattern {sys "catelles.bmp" interpolate 2}
    color_map {
      [0.1 rgb <237,203,176>/255*0.1]
      /*[0.3 rgb <244,206,133>/255]
      [0.7 rgb <255,231,160>/255]*/
      [0.7 rgb <239,239,206>/255]
    }
    //rgb <244,206,133>/255
  }
  normal {
    bump_map {
      sys "catelles.bmp" interpolate 2
      
      bump_size 0.5
    }
    
  }
  rotate x*90
  scale <0.38,1,0.38>
  //scale <0.6,1,0.6>
  
}

#declare orange_toit =
  texture {
   pigment{
     rgb Orange*0.1+ <80, 44, 28> / 255*0.6
   
   }
  }
  
#declare tex_sous_toit =
texture {
  pigment {
    wood
    turbulence 0.15
    
    color_map {
      [0 rgb (<0.3,0.3,0.3> +<0.3,0.2,0.1>*0.5+<80, 44, 28> / 255*0.3)*0.5]
      [1 rgb (<0.5,0.5,0.5> +<0.3,0.2,0.1>*1+<80, 44, 28> / 255*0.7)*0.5]   
    }
    rotate x*90
    scale <0.05,0.25,0.05>
  }
}


#declare tex_brik =  
  texture {    
    pigment{
      image_pattern {sys "brik.bmp" interpolate 2}
      color_map {
        [0 rgb 0.1]
        [0.2 rgb <152,137,114>/255*0.7]
        [1 rgb <152,137,114>/255*1]
      
      }      
    }
    
    finish {ambient 0.08 diffuse 0.5}
      
    normal {
      bump_map {
        sys "brik.bmp" interpolate 2
        bump_size 1.8
      }
      
      
    }

    rotate x*90
    scale 1.7 
  }


#declare pla =
  texture {
    agate
   
    texture_map {
      [0 pigment {rgb 0.38}]
      [0.9 tex_brik]
    }
    scale 2
  }



#declare tex_toit =
              texture {
                pigment{
                  image_map {
                    sys
                    "toit.bmp"
                    interpolate 2
                  }
                }
                normal {
                  bump_map {sys "bump_toit.bmp" interpolate 2 bump_size 2}                  
                }
                scale 2
                rotate y*-90
                rotate z*90
              }


#declare bois_barriere=texture {
  pigment{
    wood
    turbulence 0.1
    color_map {
      [0 rgb <0.3,0.25,0.2>*1.4] 
      [1 rgb <0.5,0.4,0.3>*1.4]   
    }
    scale <0.2,0.2,0.3>
  }
  finish {ambient 0.4}
}


#declare t_truc_porte=texture {
  pigment{
    wood
    turbulence 0.2
    color_map {
      [0 rgb <0.3,0.25,0.2>*1.1] 
      [1 rgb <0.5,0.4,0.3>*1.1]   
    }
    scale <0.2,0.2,0.4>
  }
  finish {ambient 0.3}
}

#declare stor_joint= texture{
  pigment {
    rgbt <0.4,0.2,0.17,0.4>
  }
  finish {reflection 0.1 phong 0.1 ambient 0.05 diffuse 0.4}
}




#declare bois_tour_sup=texture {
  pigment{
    wood
    turbulence 0.1
    color_map {
      [0 rgb (<80, 44, 28>/255*0.7+<0.3,0.25,0.2>*0.2 + <0.5,0.4,0.3>*0.3)*0.7] 
      [1 rgb (<80, 44, 28>/255*0.7+<0.5,0.4,0.3>*0.3 + <0.5,0.4,0.3>*0.5)*0.7]   
    }
    scale 0.08
    
  }
  finish {ambient 0.3}
}

#declare t_window_blanc = texture {
  pigment {
    gradient y
    turbulence 0.4
    color_map{[0 rgb 1.09] [0.5 rgb 0.96] [1 rgb 1.09]}
    scale <1, 0.04, 1>
  }
  
}

#declare t_window_gold = texture {
  pigment {
    rgb <255,225,195>/255*1.1
  }
}

#declare t_2nd_floor = texture {   // BROWN
  pigment {
    spotted
    turbulence 0.1
    color_map {
      [0 rgb <63, 42, 51> / 255 * 1.2]
      
      [0.42 rgb <80, 44, 28> / 255 * 1.2]
      [0.7 rgb <63, 42, 51> / 255 * 0.9]
      [1 rgb <63, 42, 51> / 255 * 1.2]
    }
    //scale <0.14, 0.7, 0.14>
    scale <0.12, 0.55, 0.12>
    translate z*1.6
  }
}

#declare t_sommet_metal = texture {
  pigment {granite color_map {[0 rgb <0.5,0.5,0.5>*1.4] [1 rgb <0.5,0.5,0.52>*1.45]} scale <0.3, 0.5, 0.3>}
  finish {reflection 0.3 metallic}
  
}


#declare blanc_inf =
texture{    
  pigment {rgb <1,1,1>*0.87+Yellow*0.04}
  finish {ambient 0.21}
}
texture {
  pigment {
    gradient y
    color_map {
      [0.5 rgbt <0,0,0,1>]
      [1   rgbt <0,0,0,0.35>]
    }
  }
}
texture{
  pigment{
    spotted
    turbulence 0.9
    color_map {
      [0.5 rgbt <0,0,0,1>]
      [1   rgbt <0,0,0,0.7>]
    }
    //scale <1,2,1>
    scale <0.5,1,0.5>
  }
}
    
    

#declare nothing = texture {
  pigment {
    rgb <1.2, 0.95, 0.8>
  }
}


//------------------------------------- roof ------------------------------------------------------------

#declare roof1 = 5;
#declare roof2 = 1.9;
#declare roof3 = 0.45;
#declare roof4 = 3.1;
#declare roof5 = 5.4; //4.5
#declare roof6 = 0.6; //0.7
#declare roof7 = -0.08;
#declare roof8 = 2.8;
#declare roof9 = 7.2; //6.2
#declare roof10 = 4.7;
#declare roof11 = 0.06;
#declare roof12 = 0.05;
#declare roof13 = 0.13;
#declare roofbeta = 44.8;
#declare roofscale = <1.34, 1, 1.34>;//1.34

#declare roof =
object {
  union {
    intersection {
      difference {
        box {
          <-roof1 / 2, 0.0001, -roof1 / 2>,
          <roof1 / 2, roof2, roof1 / 2>
          #if (tex) texture {orange_toit scale 1/roofscale} #end
        }
        #declare a = 0;
        #while (a < 4)
          union {
            sphere {
              0, 1
              scale <roof4, roof6, roof5>
              #if (tex) texture {
                tex_toit scale 1/roofscale
              } #end
            }
            cylinder {
              0, <0, 1000, 0>, 1000
            }
            
            translate y * roof6
            rotate z * -roofbeta
            translate <roof3 / 2, roof2, 0>
            rotate y * a * 90
          }
          #declare a = a + 1;
        #end
      }
      sphere {
        0, 1
        scale <roof9, roof8, roof9>
        translate y * (roof8 + roof7)
        #if (tex) texture {tex_sous_toit scale 1/roofscale} #end    
      }      
    }
    difference {
      box {
        <-roof10 / 2, 0, -roof10 / 2>,
        <roof10 / 2, roof8 / 2, roof10 / 2>
      }
      sphere {
        0, 1
        scale <roof9, roof8, roof9> * 0.9999
        translate y * (roof8 + roof7)
      }
      #if (tex) texture {tex_sous_toit scale 1/roofscale} #end    
    }
    union {
      #declare plank1 =
      box {
        <-roof11 / 2, -roof11 / 2, -roof10 / 2 - roof12>,
        <roof11 / 2, roof11 / 2, roof10 / 2 + roof12>
        //#if (tex) texture {tex_sous_toit} #end
        #if (tex) texture {bois_tour_sup scale 1/roofscale} #end
      }
      #declare plank2 =
      box {
        <-roof11 / 2, -roof11 / 2, -(roof10 / 2) * sqrt (2) - roof12>,
        <roof11 / 2, roof11 / 2, (roof10 / 2) * sqrt (2) - roof12>
        //#if (tex) texture {tex_sous_toit} #end
        #if (tex) texture {bois_tour_sup scale 1/roofscale} #end
      }
      #declare a = 1;
      #while (a < 10)
        box {plank1 translate x * (-roof10 / 2 + roof10 / 10 * a)}
        box {plank1 rotate y * 90 translate z * (-roof10 / 2 + roof10 / 10 * a)}
        #declare a = a + 1;
      #end
      box {plank2 rotate y * 45}
      box {plank2 rotate y * -45}
    }
    box {
      <-roof3 / 2 -0.03, roof2, -roof3 / 2 -0.03>,
      <roof3 / 2 + 0.03, roof2 + roof13, roof3 / 2 + 0.03>
      #if (tex) texture {t_sommet_metal scale 1/roofscale} #end
    }     
  }   
  scale roofscale

  texture {nothing}
}



//-------------------------------------- 2nd floor -------------------------------------------

#include "window.inc"

#declare sup1 = 4.5;
#declare sup2 = 1.8;
#declare sup3 = 0.2;
#declare sup4 = 0.07;
#declare sup5 = 0.035;
#declare sup6 = 0.56;


#declare sup =
object {
  union {
    box {
      <-sup1 / 2, 0, -sup1 / 2>,
      <sup1 / 2, sup2, sup1 / 2>
      #if (tex) texture {t_2nd_floor} #end
    }
    box {
      <-sup1 / 2 - sup5-0.001, sup2 - sup3 - sup4, -sup1 / 2 - sup5-0.001>,
      <sup1 / 2 + sup5+0.001, sup2 - sup3, sup1 / 2 + sup5+0.001>
      #if (tex) texture {bois_tour_sup} #end
    }
    #declare plank_one_side =
    union {
      #declare a = 0;
      #while (a < 3)
        box {
          <-sup4 / 2, 0, -sup1 / 2 - sup4 / 2>
          <sup4 / 2, sup2 - sup3 - sup4 / 2, -sup1 / 2 + sup4 / 2>
          translate x * (-sup1 / 2 + sup1 / 3 * a)
          //#if (tex) texture {t_2nd_floor} #end
          #if (tex) texture {bois_tour_sup} #end           
        }
        #declare a = a + 1;
      #end
    }
    
    box {
      <-sup1 / 2, sup6 - sup4 / 2, -sup1 / 2 - sup5>,
      <sup1 / 2, sup6 + sup4 / 2, -sup1 / 2 + 0.001>
      #if (tex) texture {t_2nd_floor} #end
    }
    
    #declare a = 1;
    #while (a < 5)
      object {plank_one_side rotate y * (a * 90)}
      #declare a = a + 1;
    #end
    
    #declare a = 0;
    #while (a < 3)
      object {
        window 
         
        translate <-sup1 / 2 + sup1 / 3 * (a + 0.5), 0.98, -sup1 / 2 + 0.001>
      }
      #declare a = a + 1;
    #end
  }
  
  texture {nothing}
}



//------------------------------------ balcony --------------------------------------------------------


#declare bal1 = 0.1;
#declare bal2 = 0.15;
#declare bal3 = 0.035;
#declare bal4 = 5.95;
#declare bal5 = 0.38;



#declare balcony =
object {
  union {
    box {
      <-bal4 / 2, 0, -bal4 / 2>
      <bal4 / 2, bal1, bal4 / 2>
      #if (tex) texture {tex_sous_toit} #end
    }
    #declare barrier_one_side =
    union {
      #declare a = 0;
      #while (a < 3)
        box {
          <-bal4 / 2 - bal2, 0, -bal4 / 2>,
          <bal4 / 2 + bal2, bal3, -bal4 / 2 + bal3>
          #if (tex) texture {bois_barriere rotate y*90 translate x*a*20} #end
          translate y * (bal1 + bal5 / 2 * a)
          
        }        
        #declare a = a + 1;
      #end
      #declare one_vertical_barrier =
      box {
        <-bal3 / 2, 0, -bal4 / 2>,
        <bal3 / 2, 1, -bal4 / 2 + bal3>      
      }
      object { one_vertical_barrier scale <1, bal5, 1> #if (tex) texture {bois_barriere rotate x*90} #end translate <-bal4 / 2 + bal3 / 2, bal1, 0> }
      #declare a = 1;
      #while (a < 8)
        object {
          one_vertical_barrier
          scale <1, bal5 * (mod (a, 2) + 1) / 2, 1>
          #if (tex) texture {bois_barriere rotate x*90 translate y*a*232} #end
          translate <-bal4 / 2 + bal3 / 2 + (bal4 - bal3) / 8 * a, bal1, 0>
          
        }       
        #declare a = a + 1;
      #end    
    }
    
    #declare a = 0;
    #while (a < 4)
      object {
        barrier_one_side
        rotate y * 90 * a
      }
      #declare a = a + 1;
    #end 
  
    
  }
  
  texture {nothing}
  
}



//----------------------------- 2nd roof -------------------------------------------------------

#declare ndr1 = 8.5;
#declare ndr2 = 1.1;
#declare ndr3 = 4.8;
#declare ndr4 = 10;
#declare ndr5 = -0.83;
#declare ndr6 = 12.5; // > ndr1
#declare ndr7 = -0.00;
#declare ndr8 = 1.75;
#declare ndr9 = 16.1;
#declare ndr10 = 0.9;
#declare ndr11 = 8;
#declare ndrbeta = 25;

#declare ndr =
object {
  union {
    intersection {
      difference {
        box {
          <-ndr1 / 2, 0.0001, -ndr1 / 2>,
          <ndr1 / 2, ndr2, ndr1 / 2>
          #if (tex) texture {orange_toit} #end
        }
        #declare a = 0;
        #while (a < 4)
          union {
            sphere {
              0, 1
              scale <ndr4 / 2, ndr10 / 2, ndr6 / 2>
              #if (tex) texture {
                tex_toit
              } #end
            }
            cylinder {
              0, <0, 1000, 0>, 1000
            }
            
            translate y * ndr10 / 2
            rotate z * -ndrbeta
            translate <bal4 / 2 + ndr5, ndr2, 0>
            translate <ndr3 * cos (radians(ndrbeta)), -ndr3 * sin (radians(ndrbeta)), 0>
            rotate y * a * 90
          }
          #declare a = a + 1;
        #end
      }
      sphere {
        0, 1
        scale <ndr9 / 2, ndr8 / 2, ndr9 / 2>
        translate y * (ndr8 / 2 + ndr7)
        #if (tex) texture {tex_sous_toit} #end
      }      
    }
    difference {
      box {
        <-ndr11 / 2, 0, -ndr11 / 2>,
        <ndr11 / 2, ndr8 / 2, ndr11 / 2>
      }
      sphere {
        0, 1
        scale <ndr9 / 2, ndr8 / 2, ndr9 / 2> * 0.9999
        translate y * (ndr8 / 2 + ndr7)
      }
      #if (tex) texture {tex_sous_toit} #end    
    }
    union {
      #declare plank1 =
      box {
        <-roof11 / 2, -roof11 / 2, -ndr11 / 2 - roof12>,
        <roof11 / 2, roof11 / 2, ndr11 / 2 + roof12>
        //#if (tex) texture {tex_sous_toit} #end
        #if (tex) texture {bois_tour_sup} #end
      }
      #declare plank2 =
      box {
        <-roof11 / 2, -roof11 / 2, -(ndr11 / 2) * sqrt (2) - roof12>,
        <roof11 / 2, roof11 / 2, (ndr11 / 2) * sqrt (2) - roof12>
        //#if (tex) texture {tex_sous_toit} #end
        #if (tex) texture {bois_tour_sup} #end
      }
      #declare a = 1;
      #while (a < 17)
        box {plank1 translate x * (-ndr11 / 2 + ndr11 / 17 * a)}
        box {plank1 rotate y * 90 translate z * (-ndr11 / 2 + ndr11 / 17 * a)}
        #declare a = a + 1;
      #end
      box {plank2 rotate y * 45}
      box {plank2 rotate y * -45}
    }
        
  }
  texture {nothing}
}   


//--------------------------------------- 1st floor ---------------------------------------------------------


#declare inf1 =2.3;
#declare inf2 = 5.8;
#declare inf3 = 2.9;
#declare inf4 = 0.65;
#declare inf5 = 0.05;
//#declare inf6 = ;
#declare inf7 = 0.5;
#declare inf8 = 1.5;
#declare inf9 = 2;
#declare inf10 = 0.1;
#declare inf11 = 1.5;
#declare inf12 = 0.7;

          
#declare cg1=inf3/2;
#declare cg2=-inf2/2+inf3/2;

#declare inf = object {
  union{
    difference {
      box {<-inf2/2,0,-inf2/2>,
           <inf2/2,inf1,inf2/2>}
      box {<-inf2,-1,-inf2>, // little space
           <-inf2/2+inf3,inf1+1,-inf2/2+inf9>}
      box {<inf2/2-inf10,-1,-inf2/2+inf10>,
           <-inf2/2+inf3+inf10,inf1+1,inf2/2-inf10>}   // make wall
      box {<-inf2/2+inf10,-1,inf2/2-inf10>,
           <-inf2/2+inf3+inf10+0.001,inf1+1,-inf2/2+inf9+inf10>}
      box {<cg1-inf8/2,-1,-inf2>,<cg1+inf8/2,inf1-inf4,-inf2/2+inf10+0.1>}
      box {<cg2-inf11/2,-1,-inf2/2>,<cg2+inf11/2,inf1-inf4,-inf2/2+inf10+inf9+0.1>}
      
      
      #if (tex) texture {blanc_inf scale <1,inf1,1>} #end
    }
    
    // floor
    
    union {
      box {
        <-inf2/2+inf10,0,inf2/2-inf10>,
        <-inf2/2+inf3+inf10,0.02,-inf2/2+inf9+inf10>
      }
      box {
        <-inf2/2+inf3+inf10,0,-inf2/2+inf10>,
        <inf2/2-inf10,0.02,inf2/2-inf10>
      }
      #if (tex) texture {catelles} #end    
    }
    
    
    // around
    difference {
      box {<-inf2/2-inf5,inf1-inf4-inf5,-inf2/2-inf5>,
           <inf2/2+inf5, inf1-inf4+inf5, inf2/2+inf5>}
      box {<-inf2/2-1,0,-inf2/2-1>,<-inf2/2+inf3-inf5,inf1,-inf2/2+inf9-inf5>}
      #if (tex) texture{t_2nd_floor} #end
    }
    
    //poutre
    box {
      <-inf2/2-inf5,0,-inf2/2-inf5>,
      <-inf2/2+inf5,inf1,-inf2/2+inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    
    difference{        
      //bas
      box {
        <-inf2/2-inf5,0,-inf2/2-inf5>,
        <inf2/2+inf5,inf12,inf2/2+inf5>
      }
      box {
        <inf2/2,-1,-inf2/2>,
        <-inf2/2+inf3,inf1,inf2/2>
      }
      box {
        <-inf2/2,-1,-inf2/2+inf9>,
        <inf2/2+inf3+0.001,inf1,inf2/2>
      }
      box {
        <-inf2,-1,-inf2>,
        <-inf2/2+inf3-inf5,inf1,-inf2/2+inf9-inf5>
      }
      box {<cg1-inf8/2,-1,-inf2>,<cg1+inf8/2,inf1-inf4,-inf2/2+inf10+0.1>}
      box {<cg2-inf11/2,-1,-inf2/2>,<cg2+inf11/2,inf1-inf4,-inf2/2+inf10+inf9+0.1>}
      #if (tex)
        texture {
          gradient y
          texture_map {
            [0 pigment {rgb <0.3,0.2,0.1>*0.5}]
            [0.15 t_2nd_floor]          
          }
          scale <1,inf12+0.001,1>
        }
      #end
    }
    
    // poutres gates
    box {
      <cg1-inf5, inf1-inf4, -inf2/2-inf5>,
      <cg1+inf5, inf1, -inf2/2+inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    box {
      <cg2-inf5, inf1-inf4, -inf2/2+inf9-inf5>,
      <cg2+inf5, inf1, -inf2/2+inf9+inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    
    // poutres coins
    box {
      <-inf2/2-inf5,inf12,-inf2/2+inf9+inf5>,
      <-inf2/2+inf5,inf1, -inf2/2+inf9-inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    box {
      <-inf2/2-inf5,inf12,inf2/2+inf5>,
      <-inf2/2+inf5,inf1, inf2/2-inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    box {
      <-inf2/2+inf3-inf5,inf12,-inf2/2+inf9+inf5>,
      <-inf2/2+inf3+inf5,inf1, -inf2/2+inf9-inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    box {
      <-inf2/2+inf3-inf5,inf12,-inf2/2+inf5>,
      <-inf2/2+inf3+inf5,inf1, -inf2/2-inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    box {
      <inf2/2-inf5,inf12,-inf2/2+inf5>,
      <inf2/2+inf5,inf1, -inf2/2-inf5>
      #if (tex) texture{t_2nd_floor} #end
    }
    
    // truc porte

    #declare r=seed(387869);    
    #declare a=0;
    
    
    
    #while (a<inf7-0.001)
      #declare py=inf1-inf4-inf5-a-0.05;
      #declare rr = rand(r)*0.035-0.0175;
      cylinder {
        <cg1-inf8/2,py,-inf2/2+inf10+rr>, <cg1+inf8/2,py,-inf2/2+inf10+rr>, 0.05
        #if (tex) texture{ t_truc_porte translate x*rand(r)*200 rotate y*90} #end
        //#if (tex) texture{bois_tour_sup translate x*rand(r)*200 } #end
        
      }
      cylinder {
        <cg1-inf8/4-0.04,py,-inf2/2+inf10+rr>, <cg1-inf8/4+0.04,py,-inf2/2+inf10+rr>, 0.065
        texture {stor_joint}
      }
      cylinder {
        <cg1+inf8/4-0.04,py,-inf2/2+inf10+rr>, <cg1+inf8/4+0.04,py,-inf2/2+inf10+rr>, 0.065
        texture {stor_joint}
      }      
      #declare a=a+inf7/8;
    #end
      
  }  
  

  texture {nothing}

}



object {roof translate y * (sup2 + bal1 + ndr2 +inf1)}
object {sup translate y * (bal1 + ndr2+inf1)}
object {balcony translate y * (ndr2+inf1)}
object {ndr translate y * inf1}
object {inf}

// oiseaux

#declare r=seed(486);

#declare a=0
#while (a<15)
 object {bird scale 0.1 rotate z*(rand(r)*10-5) rotate x*(rand(r)*10-5)  rotate y*rand(r)*360 translate <30+rand(r)*6-3,19+rand(r)*5-2.5,25+rand(r)*10-5>}
 #declare a=a+1;
#end

// pot

object {pot_
  scale 0.1
  translate <-0.57,0,-2.7>
}

object {pot_
  scale 0.07
  rotate y*100
  translate <-0.55,0,-2>
}



    





//---------------------------------------- plane ----------------------------------------------





plane{
  y,0//-roof11/2
  
  
  texture {
    pla
  }
}

fog {
    distance 15
    //color rgb (0.7+<0.2, 0.3, 0.535>*0.3)*lum
    color rgb <.7, .6, .5>*0.6 + <1, 1, 0.9>*0.4
    fog_type 2
    fog_offset 0
    fog_alt 1.4
   
  }


//------------------------------------------- POV sky ------------------------------------------------------


// modified sky of Michael Hough  (thx man !!)
// Here's his tutorial :
// http://free.prohosting.com/~olana/povray/sky2/sunset.html


#declare the_sun =
pigment {
  gradient y
  color_map {
    [0.0000 color rgbt <1, .95, .9, .0>*1.5]
    [0.00023 color rgbt <1, .95, .9, .1>*1.5]
    [0.00028 color rgbt <1, 1, 0.9, .3>]
    [0.06   color rgbt <.7, .6, .5, .5>]
    [0.09   color rgbt <.7, .6, .5, .7>]
    [1      color rgbt <1, 1, 1, 1>]
  }
  scale 2
  translate -1
  rotate -99.5*x
  rotate 21.5*y
}




//light_source {<0, -1000, 0> color rgb <1, .997, .97> rotate -100*x} 



#declare the_gradient =
pigment {
gradient y
color_map {
[0 color rgbt <.7, .6, .5, .2>]
[1 color rgb <0.0, 0.0, 0>]
}
}


#declare cloud_layer =
pigment {
wrinkles
turbulence .5
octaves 6
lambda 6 //3 to 6
omega 0.6 //0.2 to 0.6
color_map {
[0 color rgbt <1, 1, 1, 1>]
[0.5 color rgbt <0.98, 0.99, 0.99, .75>]
[1 color rgbt <1, 1, 1, 1>]
}
scale <.8, .1, .8>
}


sky_sphere {
    pigment {the_gradient}
    pigment {the_sun}
    pigment {cloud_layer}
}




//camera {location <-7,2,-10> look_at <1, 3.3, 0> angle 55} // Contre plonge
camera {location <-6,4.4,-10> right x up 170/130*y look_at <0.9, 3, 0> angle 45} // at top  
//camera {location <-1,1,-3> right x up 170/130*y look_at <-0.57,0,-2.7> angle 45} // pot
//camera {location <-6,1.9,-14> look_at <0.91, 3.3, 0> angle 34} // Vue gnrale
//camera {location <-inf2/2+inf3/2,1,-inf2/2> look_at <-inf2/2+inf3/2,0,inf2/2-(inf2-inf9)/2> angle 36} // Vue sur les catelles



  


light_source {<20,17,-50> rgb 0.4*lum shadowless}
light_source {<-40.5,7,-50> rgb (0.2+<0.25, 0.25, 0.43> * 0.2)*lum }
light_source {<-40,7.5,-50> rgb (0.2+<0.25, 0.25, 0.43> * 0.2)*lum }
//light_source {<0,1,-30> rgb 0.2*lum shadowless}

// sun light

light_source {
  <0,-1000,0>
  rgb <.7, .6, .5>*1.8
  rotate x*-99.5
  rotate y*21.5
}