//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 10 materials and 79 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 11/29/2001    (29.11.2001)
//
// Modified by Steve Reeves in POV-Ray editor.
// Image & Source Copyright 2001 by Steve Reeves

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.3 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <    301.453,      54.477,      -8.157>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.50671,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         92.00000    // Vertical      69.000
  look_at   <    248.889,      44.875,     -13.948>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5712
  translate  <569.32596, 86.819294, 373.83739>
}


//
// ********  MATERIALS  *******
//

#include "mech.inc"

//
// ********  REFERENCED OBJECTS  *******
//


 
//
// ********  CUSTOM ADDED *******
//
// Everything in this area was custom added by Steve

sky_sphere {
    pigment {
      gradient x
      color_map {
        [0.000 0.002 color rgb <1.0, 0.2, 0.0>
                     color rgb <1.0, 0.2, 0.0>]
        [0.002 0.200 color rgb <0.8, 0.1, 0.0>
                     color rgb <0.2, 0.2, 0.3>]
      }
      scale 2
   
    }
    pigment {
      bozo
      turbulence 0.45
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    
  }


//
// ********  OBJECTS  *******
//

union { // Flag
  sphere { // Sphere004
    <0,0,0>,1
    material {
      Brushed_Aluminum
    }
    scale 0.498567
    translate  <254.74862, 62.051021, 4.96152>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <-0.47745, -0.47745, -62.350807>
    rotate -180.0*z
    translate  <254.74806, 62.039467, 4.802003>
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      Red
    }
    scale <0.01, 5.335081, 5.335081>
    rotate 180.0*x
    translate  <254.891304, 71.044279, -2.034965>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      White
    }
    scale <0.094379, 9.056339, 6.79213>
    rotate 180.0*z
    translate  <254.753044, 71.321189, -2.077924>
  }
  translate  -7.064254*x
}


#declare Head = lathe {
  linear_spline
  8  // control points
  <5.232439, -1.356699>,
  <3.213326, -0.308422>,
  <3.516658, 4.139979>,
  <3.296356, 4.656303>,
  <3.079825, 5.03666>,
  <2.916846, 5.380699>,
  <2.623634, 5.687664>,
  <1.335261, 7.290139>
  rotate <90,0,90>
  material {
    MainRobot
  }
  scale <1.068878, 1.366527, 1.366527>
  translate  <-2.699786, -6.351102, 65.377>
}
#declare CSG001 = difference {
  object { Head }
  box { // FaceDiff
    <-1, -1, -1>, <1, 1, 1>
    material {
      MainRobot
    }
    no_shadow
    scale <2.107528, 2.815119, 1.046143>
    translate  <-0.939119, -6.500345, 69.780536>
  }
}
#declare MainLaserFun = lathe {
  linear_spline
  8  // control points
  <0.010269, -20.695744>,
  <4.743176, -20.695744>,
  <2.924363, -8.364043>,
  <1.058952, -7.247695>,
  <1.220641, -1.347979>,
  <2.0, -0.5>,
  <2.383412, 0.531299>,
  <0.86698, 1.946792>
  rotate <90,0,90>
  material {
    LaserGun
  }
  rotate -9.786924*x
  translate  <-2.896035, -27.970941, 24.164257>
}
#declare Blaster = difference {
  object { MainLaserFun }
  cylinder { // GunHole
    <0,0,1>, <0,0,0>, 1 
    material {
      LaserGun
    }
    scale <1.98992, 1.989924, 11.56219>
    rotate -9.95766*x
    translate  <-2.972695, -31.422034, 3.386465>
  }
}
#declare Neck = lathe {
  cubic_spline
  6  // control points
  <-0.017214, -0.15493>,
  <2.437989, -0.206866>,
  <1.547453, 0.201055>,
  <0.981796, 0.354701>,
  <0.298115, 0.58408>,
  <0.053208, 1.43036>
  rotate <90,0,90>
  material {
    MainRobot
  }
  scale <2.3, 4.8, 2.9>
  translate  <-2.7, -6.2, 61.5>
}
#declare LArm1 = union {
  sphere { // LElbow1
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 2.6
    rotate -130.0*x
    translate  <-2.8, 17.7, 44.9>
  }
  cylinder { // LUpperArm1
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.6, 2.4, 18.200001>
    rotate -130.0*x
    translate  <-2.8, 3.2, 57.1>
  }
  cylinder { // LForearm1
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.6, 2.4, 15.5>
    rotate <-160.0, -0.0, -0.0>
    translate  <-2.8, 18.1, 44.2>
  }
}
#declare LArm = union {
  sphere { // LElbow
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 2.6
    rotate -130.0*x
    translate  <-2.8, 17.7, 44.9>
  }
  cylinder { // LUpperArm
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.6, 2.4, 18.200001>
    rotate -130.0*x
    translate  <-2.8, 3.2, 57.1>
  }
  cylinder { // LForearm
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.6, 2.4, 15.5>
    rotate <-160.0, -0.0, -0.0>
    translate  <-2.8, 18.1, 44.2>
  }
  object { LArm1 }
}
#declare TaperSweep001 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    MainRobot
  }
  scale <1.768545, 4.207007, 2.267795>
  rotate 180.0*x
  translate  <-2.711985, -6.246841, 29.363405>
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <1.336463, -1.0>,
  <0.536385, 0.007981>,
  <1.329811, 0.996922>,
  <0.032104, 0.700074>,
  <0.029069, -0.73771>,
  <1.336463, -1.0>
  rotate -x*90
  material {
    MainRobot
  }
  scale <7.0, 11.6, 12.0>
  rotate 90.0*y
  translate  <-8.7, -6.4, 33.5>
}
#declare Torso = union {
  object { TaperSweep001 }
  object { TransSweep001 }
}
#declare TransSweep002 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.984351, 1.625978>,
  <-0.425252, 0.008353>,
  <-0.985213, -1.611128>,
  <1.0, -1.0>,
  <0.997455, -0.000928>,
  <1.0, 1.0>,
  <-0.984351, 1.625978>,
  <-0.425252, 0.008353>,
  <-0.985213, -1.611128>
  rotate -x*90
  material {
    MainRobot
  }
  scale <3.8, 5.5, 12.0>
  rotate <90.0, 0.0, -90.0>
  translate  <3.2, -17.3, 44.2>
}
#declare TransSweep003 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.984351, 1.625978>,
  <-0.425252, 0.008353>,
  <-0.985213, -1.611128>,
  <1.0, -1.0>,
  <0.997455, -0.000928>,
  <1.0, 1.0>,
  <-0.984351, 1.625978>,
  <-0.425252, 0.008353>,
  <-0.985213, -1.611128>
  rotate -x*90
  material {
    MainRobot
  }
  scale <3.8, 5.5, 12.0>
  rotate <-90.0, 0.0, 90.0>
  translate  <3.2, 4.5, 44.3>
}
#declare TransSweep004 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.679186, 1.007825>,
  <-0.366197, 1.023474>,
  <-0.405321, -0.968701>,
  <0.671362, -0.992175>,
  <0.105875, -0.641058>,
  <0.124214, 0.51692>,
  <0.679186, 1.007825>,
  <-0.366197, 1.023474>,
  <-0.405321, -0.968701>
  rotate -x*90
  material {
    MainRobot
  }
  scale 2.4
  rotate <90.0, -25.0, -90.0>
  translate  <0.0, 5.0, 30.7>
}
#declare TransSweep005 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.679186, 1.007825>,
  <-0.366197, 1.023474>,
  <-0.405321, -0.968701>,
  <0.671362, -0.992175>,
  <0.105875, -0.641058>,
  <0.124214, 0.51692>,
  <0.679186, 1.007825>,
  <-0.366197, 1.023474>,
  <-0.405321, -0.968701>
  rotate -x*90
  material {
    MainRobot
  }
  scale 2.4
  rotate <90.0, -25.0, 90.0>
  translate  <0.0, -17.3, 30.7>
}
#declare RobotBody = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <5.6, 11.6, 31.4>
    translate  <-2.7, -6.2, 29.7>
  }
  object { TransSweep002 }
  object { TransSweep003 }
  object { TransSweep004 }
  object { TransSweep005 }
}
#declare RALThigh = union {
  cone { // RThighStabilizer
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      MainRobot
    }
    scale <2.1, 2.1, 2.4>
    rotate 180.0*x
    translate  <-2.6, -0.5, 27.1>
  }
  cylinder { // RThigh
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.1, 2.1, 9.0>
    translate  <-2.7, -0.5, 15.7>
  }
  sphere { // LThighJoint
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 2.0
    translate  <-2.6, -12.0, 25.7>
  }
  cone { // LTorsoConnection
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      MainRobot
    }
    scale <5.9, 5.8, 3.4>
    translate  <-2.7, -12.0, 26.0>
  }
  cone { // RThighStabilizer1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      MainRobot
    }
    scale <2.1, 2.1, 2.4>
    rotate -180.0*x
    translate  <-2.6, -12.0, 27.1>
  }
  cylinder { // RThigh1
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.1, 2.1, 9.0>
    translate  <-2.7, -12.0, 15.7>
  }
  sphere { // RThighJoint
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 2.0
    translate  <-2.6, -0.5, 25.7>
  }
  cone { // RTorsoConnection
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      MainRobot
    }
    scale <5.9, 5.8, 3.4>
    translate  <-2.7, -0.5, 26.0>
  }
}
#declare LLegAKnee = union {
  sphere { // RKneeBolt1
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 0.8
    translate  <-2.5, -2.6, 14.6>
  }
  cylinder { // RKneeSleeve
    <0,0,1>, <0,0,0>, 1 
    material {
      BoltBlack
    }
    scale <0.8, 0.8, 5.0>
    rotate <-90.0, -0.0, 0.0>
    translate  <-2.5, -3.0, 14.6>
  }
  cylinder { // RCalf
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.1, 2.1, 7.5>
    translate  <-2.6, -0.5, 6.1>
  }
  cone { // RLegStabilizer
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      MainRobot
    }
    scale <2.1, 2.1, 2.4>
    translate  <-2.6, -0.5, 3.7>
  }
  sphere { // RKnee
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 2.5
    translate  <-2.6, -0.5, 14.6>
  }
  sphere { // RKneeBolt2
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 0.8
    translate  <-2.5, 1.6, 14.6>
  }
}
#declare RlegSuportBase1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <-1.140845, -1.0>,
  <3.167449, -1.0>,
  <3.035675, -0.423039>,
  <2.991784, -0.284272>,
  <2.925408, -0.163116>,
  <2.860217, -0.086909>,
  <2.761045, 0.001704>,
  <2.65501, 0.080314>,
  <2.515524, 0.15146>,
  <2.38464, 0.208357>,
  <2.206737, 0.260704>,
  <2.001565, 0.295775>,
  <0.00939, 0.295775>,
  <-0.984351, -0.28169>,
  <-1.140845, -1.0>
  rotate -x*90
  material {
    MainRobot
  }
  rotate <90.0, 0.0, -0.0>
  translate  <-3.393757, 4.531018, 1.036771>
}
// Include contains 'RFootBase'
#include "mech.in1"

#declare RFootBase = object {
  RFootBase_Raw
  material {
    MainRobot
  }
  scale <1.0, 1.006396, 2.865717>
  rotate 91.287636*x
  translate  <-0.064456, 0.959343, 1.070399>
}
#declare RLegFillIn = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-0.953052, 1.214397>,
  <0.710485, -0.256651>,
  <0.780908, 1.782473>,
  <-0.953052, 1.214397>
  rotate -x*90
  material {
    MainRobot
  }
  scale <1.783933, 1.335485, 1.00031>
  rotate <90.0, -63.363251, -179.655411>
  translate  <-2.884146, -0.99721, 0.928517>
}
#declare RFootRearStabilizer = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.28169, 0.001565>,
  <2.416275, 0.00939>,
  <1.302034, 0.861346>,
  <0.945227, 0.859155>,
  <-0.844053, 0.85759>,
  <-1.632629, 1.273865>,
  <-2.103286, 1.0>,
  <-2.183099, 0.004617>,
  <-1.28169, 0.001565>
  rotate -x*90
  material {
    MainRobot
  }
  scale <0.737504, 0.716286, 2.880444>
  rotate 90.0*x
  translate  <-4.689597, 0.979417, 0.025792>
}
#declare RlegSuportBase = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <-1.140845, -1.0>,
  <3.167449, -1.0>,
  <3.035675, -0.423039>,
  <2.991784, -0.284272>,
  <2.925408, -0.163116>,
  <2.860217, -0.086909>,
  <2.761045, 0.001704>,
  <2.65501, 0.080314>,
  <2.515524, 0.15146>,
  <2.38464, 0.208357>,
  <2.206737, 0.260704>,
  <2.001565, 0.295775>,
  <0.00939, 0.295775>,
  <-0.984351, -0.28169>,
  <-1.140845, -1.0>
  rotate -x*90
  material {
    MainRobot
  }
  rotate 90.0*x
  translate  <-3.393757, -4.433555, 1.063691>
}
#declare RFootALeg = union {
  object { RlegSuportBase1 }
  object { RFootBase }
  box { // RLeg
    <-1, -1, -1>, <1, 1, 1>
    material {
      MainRobot
    }
    scale <1.6, 0.5, 4.6>
    translate  <-2.5, -0.5, 6.5>
  }
  box { // RLegFootSupport
    <-1, -1, -1>, <1, 1, 1>
    material {
      MainRobot
    }
    scale <-0.173258, -0.487002, -1.804479>
    rotate <-180.0, -56.193935, 0.0>
    translate  <-2.707098, -0.516881, 1.185566>
  }
  box { // RFootRearSupport
    <-1, -1, -1>, <1, 1, 1>
    material {
      MainRobot
    }
    scale <0.401781, 0.486461, 0.993348>
    rotate 41.663792*y
    translate  <-3.843031, -0.492141, 1.048689>
  }
  object { RLegFillIn }
  object { RFootRearStabilizer }
  cylinder { // RLegSupport1
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <0.415455, 0.339533, 4.733877>
    rotate <-158.105255, -56.407013, -116.55423>
    translate  <-2.553423, -0.740376, 3.337229>
  }
  object { RlegSuportBase }
  cylinder { // RLegSupport2
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <0.417413, 0.341908, 5.071177>
    rotate <160.683014, 59.7771, -112.603714>
    translate  <-2.553423, -0.255804, 3.36415>
  }
}
#declare RlegSuportBase2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <-1.140845, -1.0>,
  <3.167449, -1.0>,
  <3.035675, -0.423039>,
  <2.991784, -0.284272>,
  <2.925408, -0.163116>,
  <2.860217, -0.086909>,
  <2.761045, 0.001704>,
  <2.65501, 0.080314>,
  <2.515524, 0.15146>,
  <2.38464, 0.208357>,
  <2.206737, 0.260704>,
  <2.001565, 0.295775>,
  <0.00939, 0.295775>,
  <-0.984351, -0.28169>,
  <-1.140845, -1.0>
  rotate -x*90
  material {
    MainRobot
  }
  rotate <90.0, 0.0, -0.0>
  translate  <-3.393757, 4.531018, 1.036771>
}
// Include contains 'RFootBase1'
#include "mech.in2"

#declare RFootBase1 = object {
  RFootBase1_Raw
  material {
    MainRobot
  }
  scale <1.0, 1.006396, 2.865717>
  rotate 91.287636*x
  translate  <-0.064456, 0.959343, 1.070399>
}
#declare RLegFillIn1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-0.953052, 1.214397>,
  <0.710485, -0.256651>,
  <0.780908, 1.782473>,
  <-0.953052, 1.214397>
  rotate -x*90
  material {
    MainRobot
  }
  scale <1.783933, 1.335485, 1.00031>
  rotate <90.0, -63.363251, -179.655411>
  translate  <-2.884146, -0.99721, 0.928517>
}
#declare RFootRearStabilizer1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.28169, 0.001565>,
  <2.416275, 0.00939>,
  <1.302034, 0.861346>,
  <0.945227, 0.859155>,
  <-0.844053, 0.85759>,
  <-1.632629, 1.273865>,
  <-2.103286, 1.0>,
  <-2.183099, 0.004617>,
  <-1.28169, 0.001565>
  rotate -x*90
  material {
    MainRobot
  }
  scale <0.737504, 0.716286, 2.880444>
  rotate 90.0*x
  translate  <-4.689597, 0.979417, 0.025792>
}
#declare RlegSuportBase3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <-1.140845, -1.0>,
  <3.167449, -1.0>,
  <3.035675, -0.423039>,
  <2.991784, -0.284272>,
  <2.925408, -0.163116>,
  <2.860217, -0.086909>,
  <2.761045, 0.001704>,
  <2.65501, 0.080314>,
  <2.515524, 0.15146>,
  <2.38464, 0.208357>,
  <2.206737, 0.260704>,
  <2.001565, 0.295775>,
  <0.00939, 0.295775>,
  <-0.984351, -0.28169>,
  <-1.140845, -1.0>
  rotate -x*90
  material {
    MainRobot
  }
  rotate 90.0*x
  translate  <-3.393757, -4.433555, 1.063691>
}
#declare LFootALeg = union {
  object { RlegSuportBase2 }
  object { RFootBase1 }
  box { // RLeg1
    <-1, -1, -1>, <1, 1, 1>
    material {
      MainRobot
    }
    scale <1.6, 0.5, 4.6>
    translate  <-2.5, -0.5, 6.5>
  }
  box { // RLegFootSupport1
    <-1, -1, -1>, <1, 1, 1>
    material {
      MainRobot
    }
    scale <-0.173258, -0.487002, -1.804479>
    rotate <-180.0, -56.193935, 0.0>
    translate  <-2.707098, -0.516881, 1.185566>
  }
  box { // RFootRearSupport1
    <-1, -1, -1>, <1, 1, 1>
    material {
      MainRobot
    }
    scale <0.401781, 0.486461, 0.993348>
    rotate 41.663792*y
    translate  <-3.843031, -0.492141, 1.048689>
  }
  object { RLegFillIn1 }
  object { RFootRearStabilizer1 }
  cylinder { // RLegSupport3
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <0.415455, 0.339533, 4.733877>
    rotate <-158.105255, -56.407013, -116.55423>
    translate  <-2.553423, -0.740376, 3.337229>
  }
  object { RlegSuportBase3 }
  cylinder { // RLegSupport4
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <0.417413, 0.341908, 5.071177>
    rotate <160.683014, 59.7771, -112.603714>
    translate  <-2.553423, -0.255804, 3.36415>
  }
  translate  -11.5*y
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.438185, -0.71831>,
  <0.726135, -0.334898>,
  <-0.244131, 0.029577>,
  <0.726135, 0.209703>,
  <-1.273865, 1.007825>,
  <-2.132238, 0.150626>,
  <-1.438185, -0.71831>
  rotate -x*90
  material {
    GunMetal
  }
  rotate <-89.843262, 17.278168, -90.0>
  translate  <-0.245235, -1.210055, -1.016676>
}
#declare Gun = union {
  object { TransSweep006 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      GunMetal
    }
    scale <0.29516, 0.295164, 1.94753>
    rotate 102.404221*x
    translate  <0.271944, -1.730327, 1.242887>
  }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    material {
      GunMetal
    }
    scale <0.198478, 0.19848, 0.176328>
    rotate <100.949997, 0.0, -0.0>
    translate  <0.269685, -3.529903, 0.867704>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      GunMetal
    }
    scale <0.1, 0.1, 1.0>
    rotate 10.0*x
    translate  <0.2, -1.6, -0.1>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      GunMetal
    }
    scale <0.1, 0.1, 1.0>
    rotate 10.0*x
    translate  <0.2, -3.3, -0.4>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 open
    material {
      GunMetal
    }
    hollow
    scale <0.5, 0.5, 9.0>
    rotate 100.0*x
    translate  0.7*x
  }
  torus { // Torus002
    1.5, 0.5  rotate -x*90
    material {
      GunMetal
    }
    scale <0.198478, 0.19848, 0.176328>
    rotate <100.949997, 0.0, -0.0>
    translate  <0.269685, -1.825415, 1.155112>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 open
    material {
      GunMetal
    }
    hollow
    scale <0.5, 0.5, 9.0>
    rotate 100.0*x
  }
  scale 2.649759
  rotate <63.564651, -3.8741, 162.97464>
  translate  <-2.109445, 25.006955, 30.132548>
}
#declare RArm = union {
  sphere { // LElbow2
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 2.6
    rotate <-145.0, 0.0, -0.0>
    translate  <-2.8, 13.7, 42.2>
  }
  cylinder { // LUpperArm2
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.6, 2.4, 18.200001>
    rotate <-145.0, 0.0, 0.0>
    translate  <-2.8, 2.9, 57.5>
  }
  cylinder { // LForearm2
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.6, 2.4, 15.5>
    rotate <-165.0, -0.0, -0.0>
    translate  <-2.8, 14.0, 41.7>
  }
  rotate <-5.0, 0.0, -180.0>
  translate  <-5.6, -7.6, -0.4>
}
#declare RLegAKnee = union {
  sphere { // RKneeBolt3
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 0.8
    translate  <-2.5, -2.6, 14.6>
  }
  cylinder { // RKneeSleeve1
    <0,0,1>, <0,0,0>, 1 
    material {
      BoltBlack
    }
    scale <0.8, 0.8, 5.0>
    rotate <-90.0, -0.0, 0.0>
    translate  <-2.5, -3.0, 14.6>
  }
  cylinder { // RCalf1
    <0,0,1>, <0,0,0>, 1 
    material {
      MainRobot
    }
    scale <2.1, 2.1, 7.5>
    translate  <-2.6, -0.5, 6.1>
  }
  cone { // RLegStabilizer1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      MainRobot
    }
    scale <2.1, 2.1, 2.4>
    translate  <-2.6, -0.5, 3.7>
  }
  sphere { // RKnee1
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 2.5
    translate  <-2.6, -0.5, 14.6>
  }
  sphere { // RKneeBolt4
    <0,0,0>,1
    material {
      MainRobot
    }
    scale 0.8
    translate  <-2.5, 1.6, 14.6>
  }
  translate  -11.5*y
}
union { // Mech
  sphere { // Sphere001
    <0,0,0>,1
    material {
      RedEyes
    }
    no_shadow
    scale <1.0, 1.068108, 0.557295>
    translate  <-2.000159, -8.110574, 69.701449>
  }
  object { CSG001 }
  torus { // faceplate
    1.65, 0.35  rotate -x*90
    material {
      MainRobot
    }
    scale <3.054609, 3.760607, 3.912806>
    translate  <-2.633744, -6.25079, 62.731235>
  }
  object { Blaster }
  torus { // LaserLoop
    1.5, 0.5  rotate -x*90
    material {
      GunLoop
    }
    scale <2.629584, 2.833823, 1.254579>
    rotate <-9.957662, 0.0, -0.0>
    translate  <-3.201352, -31.371873, 4.258069>
  }
  object { Neck }
  object { LArm }
  object { Torso }
  object { RobotBody }
  object { RALThigh }
  object { LLegAKnee }
  object { RFootALeg }
  object { LFootALeg }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      RedEyes
    }
    no_shadow
    scale <1.0, 1.068108, 0.523241>
    translate  <-2.000159, -5.318128, 69.735503>
  }
  object { Gun }
  object { RArm }
  object { RLegAKnee }
  scale 0.594426
  translate  <252.975654, 46.367591, -36.956728>
}


object {   // HgtFld001
  height_field {
    tga "D:\hf-lab90\mech.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Grass1
  }
  scale <638.911926, 400.123077, 64.523102>
  translate  -32.415137*z
}
  
  



