// Persistence of Vision Ray Tracer Scene Description File
// File:   pave.pov
// Vers:   3.1
// Desc:   Include for walkside construction
// Date:   2/2/2002
// Auteur: Dominique ROSSI
//
#version 3.1;

// PAVE
#declare PAVE = superellipsoid { <0.3, 0.4> scale <.5,1,1> translate < 0,0, 0>}

// PAVE TEXTURES
#declare T_PAVE_1 = texture {
  pigment { granite 
    color_map {
      [0 rgb 0.5]
      [1 rgb 0.4]}
    scale 0.3} 
  finish {phong 1.0}  
  }
#declare T_PAVE_2 = texture {
  pigment { granite 
    color_map {
      [0 rgb 0.3]
      [1 rgb 0.4]}
    scale 0.5} 
  finish {phong 1.0}  
  }
#declare T_PAVE_3 = texture {
  pigment { granite 
    color_map {
      [0 rgb 0.6]
      [1 rgb 0.4]}
    scale 0.5} 
  finish {phong 0.4}  
  }

// LOOP FOR CONSTRUCTION OF A PAVEMENT         
#declare PAVE_XMIN = 0;        
#declare PAVE_XMAX = 15;        
#declare PAVE_ZMIN = 0;        
#declare PAVE_ZMAX = 60;        
#declare PAVE_X = PAVE_XMIN;
#declare PAVE_RAND = seed(95);

#declare SIDEWALK_15x60 = union {
  #while ( PAVE_X <= PAVE_XMAX )
    #declare PAVE_Z = PAVE_ZMIN;
    #while ( PAVE_Z <= PAVE_ZMAX)
      superellipsoid { <0.3, 0.4> 
        rotate <12*rand(PAVE_RAND)-6, 
                12*rand(PAVE_RAND)-6, 
                12*rand(PAVE_RAND)-6> 
        scale <.55,1,1.05> 
        translate < PAVE_X,0, 2* PAVE_Z + mod(PAVE_X,2) >
        #switch ( rand (PAVE_RAND) )
          #range (0,.3) texture {T_PAVE_1} #break
          #range (0.3,.7) texture {T_PAVE_2} #break
          #range (0.7,1) texture {T_PAVE_3} #break
        #end
        }
      #declare PAVE_Z = PAVE_Z + 1;
    #end
    #declare PAVE_X = PAVE_X + 1;
  #end
  }
