
#include "colors.inc"
#include "rad_def.inc"

#declare Included_File = true;

#include "txttree.inc"
#include "MakeSemi.inc"
#include "MakeFence.inc"
#include "MakeGarage.inc"
#include "Child1.inc"
#include "Pistol.inc"
#include "TopiaryT-Rex.inc"
#include "Greenhouse.cm"
#include "Gate.cm"
#include "Fortress.cm"

#declare Included_File = false;

#declare Final=true;

#declare FullLighting=false;
#declare FastObjects=false;
#declare ShowTrees=false;
#declare ShowCity=false;


#if (Final) 

	#declare FullLighting=true;
	#declare FastObjects=false;
	#declare ShowTrees=true;
	#declare ShowCity=true;
	
#end


#declare Grass1  =          
	material {
		texture {
			pigment { 
				granite
				colour_map
				{
					[ 0 rgb <0.1,0.3,0.05> ]
					[ 1 rgb <0.2,0.4,0.1> ]
				}
			}
			normal {
				bumps
				scale 0.1
				bump_size 0.05
			}
			finish {
				diffuse 1//0.7
				ambient 0//.3
				specular 0
			}
		}
	}
	
//plane { y, 0 material {Grass1} }

// grey ground plane (for anywhere I can't be bothered creating ground for)
plane { y, -0.1 pigment { rgb 0.5 } }

// "grassy" surface for near gardens
box { <-22,-0.2,0> <-11,0,-34> material {Grass1} }

// "ground" surface for "good-life" garden
box { 
	<-11,-0.2,0> <-5.5,-0.03,-34> 
	texture {
		pigment { granite scale 0.5 pigment_map { [0 rgb 0][1 rgb <0.25,0.2,0.18> ] } }
		normal { crackle scale 0.1 bump_size 2 }
		finish { ambient 0 diffuse 0.7 specular 0.3 }
	}
}

// "ground" surface for back lane
box { 
	<-11,-0.2,-33> <11,-0.01,-36> 
	texture {
		pigment { granite scale 0.3 pigment_map { [0 rgb 0][1 rgb 0.2] } }
		normal { crackle scale 0.1 bump_size 2 }
		finish { ambient 0 diffuse 0.7 specular 0.3 }
	}
}


// "grassy" surface for far gardens
box { <-5.5,-0.2,0> <110,0,-34> material {Grass1} }


// a sky sphere done with a real sphere
// (Well, I did try to use radiosity earlier, but gave up on it...)
sphere {
	0, 1
	hollow on
	texture {
		pigment {
			gradient y
			pigment_map {
				[0.5 color rgb .6]
				[0.6 granite scale <1,0.25,1>
					colour_map {
						[ 0.2 rgb <.5,.5,.5> ]
						[ 0.4 rgb <.6,.6,.6> ]
						[ 0.9 rgb <.3,.4,.6> ]
					} 
				]
			}
			scale 2
			translate -1
		}
		finish { ambient 1 diffuse 0 specular 0 }
	}
	scale 1000000
}

camera {
	location 0 
	sky y
	up 3*y
	right 4*x
	look_at 30*x-16*y - <-20,8,-36>
	angle 60
	translate <-20,8,-36>
}

//
// Lightting
//
#declare s1 = color rgb <.6, .55, .5>;
#declare c = color rgb (1.25*<1,1,1>-s1); 
#declare n = 6;

#default {
	finish { diffuse 1 ambient 0 specular 0 }
}

#if (FullLighting)

	light_source {
	  <10000, 10000, -15000>
	  color s1*1.5
	  area_light 2000*x, 2000*y, 6, 6
	  adaptive 0
	  jitter
	  circular
	  orient
	  media_interaction on
	  media_attenuation on
	}

	light_source {
		<0, 10000, 0>
		color c*1.1
		area_light x*20000, z*20000, n, n
		adaptive 1
		jitter
	}
	light_source {
		<10000, 5000, 0>
		color c*0.9
		area_light y*10000, z*20000, n, n
		adaptive 1
		jitter
	}
	light_source {
	<-10000,5000, 0>
		color c*0.9
		area_light y*10000, z*20000, n, n
		adaptive 1
		jitter
	}
	light_source {
		<0, 5000, 10000>
		color c*0.9
		area_light y*10000, x*20000, n, n
		adaptive 1
		jitter
	}
	light_source {
		<0, 5000, -10000>
		color c*0.9
		area_light y*10000, x*20000, n, n
		adaptive 1
		jitter
	}

#else
	light_source {
	  <10000, 10000, -5000>
	  color rgb 1
	  area_light <100, 0, 200>, <-200, 200, 100>, 3, 3
	  adaptive 1
	  jitter
	  media_interaction on
	  media_attenuation on
	}
	
	light_source {
	  <-100, 100, 0>
	  color rgb .5
	  shadowless
	}
#end

#declare n=-2;
#while (n<10)

	object { MakeSemi(n) translate 11*x*n }
    object { MakeSemi(n) rotate y*180 translate 11*x*n +z*25 }
    
    #if (!FastObjects)
    
		#switch (n)
			//#case (expr)
			//#break
			#range (0,1)
				object { MakeFence(6) translate 11*x*n }		
			#break
	
			#range (2,5)
				object { MakeFence(7) translate 11*x*n }		
			#break
	
			#else
				object { MakeFence(3) translate 11*x*n }		
		#end
		
    #else
    	object { MakeFence(1) translate 11*x*n }
    #end
    
	object { MakeFence(4) translate <11*n+5.5,0,0> }

	object { MakeGarage(n) translate <11*n-3.9,0,-32.4> }
	object { MakeGarage(n) translate <11*n+3.9,0,-32.4> }
    
    object { Gate scale <-1,0.75,1> rotate y*180 translate <11*n+2.1,0,-34.85> }
	object { FencePost translate <11*n+2.2,0,-34.85> }
    object { FencePost translate <11*n+1.2,0,-34.85> }
    
    object { Gate scale <-1,0.75,1> rotate y*180 translate <11*n-2.1,0,-34.85> }
	object { FencePost translate <11*n-2.2,0,-34.85> }
    object { FencePost translate <11*n-1.2,0,-34.85> }
    
    object { FencePanel rotate y*90 scale <2.3/1.83,1,1> translate <11*n+1.2,0,-34.85> }

    object { Gate scale <1.52,1,1> rotate y*(90-19) translate <11*n+5.5,0,-5.45> }
    object { Gate scale <1.52,1,1> rotate y*(90+19) translate <11*n+5.5,0,-5.45> }

	#declare n=n+1;
#end

fog {
  fog_type   2
  distance   150
  color      rgb <0.55,0.6,0.65>
  fog_offset 0
  fog_alt    2
  turbulence 0.8
}

fog {
  fog_type   2
  distance   1000
  color      rgb <0.55,0.6,0.65>*0.7
  fog_offset 0
  fog_alt    20
  turbulence 0.8
}

// --------- 

object { Child1 rotate y*100 translate <-1*11-1.5,0,-27> }
object { Child1 rotate y*-80 translate <-1*11-2.5,0,-26.5> }
object { Pistol rotate <90,0,0> scale 0.01 translate <-1*11-2,0.01,-27> }
object { Pistol rotate <90,30,0> scale 0.01 translate <-1*11-2.75,0.01,-25.75> } 
object { Cardboard_Fortress rotate y*60 translate <-1*11-2.0,0,-25> }

// --------- 

#if (!FastObjects)
	object { Greenhouse rotate y*180 translate <-0.5*11-0.8,0.01,-28> }
	object { Greenhouse rotate y*180 translate <-0.5*11-2.4,0.01,-28> }
#end 

 
// ---------

#declare Ladder=
	union {
		box { <0.16,0,-0.02> <0.14,4,0.02> }
		box { <0.16,0,-0.02> <0.14,4,0.02> scale <-1,1,1> }

		cylinder { -0.15*x 0.15*x 0.01 translate 0.33*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 0.67*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 1*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 1.33*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 1.67*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 2*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 2.33*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 2.67*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 3*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 3.33*y }
		cylinder { -0.15*x 0.15*x 0.01 translate 3.67*y }
		
		texture { Aluminum }
	}

#if (!FastObjects)
	object { Topiary_T_Rex rotate y*90 translate <2*11-2.5,0.01,-15.75> }
	object { Topiary_T_Rex rotate y*270 translate <2*11-2.5,0.01,-26> }
	object { Ladder rotate y*90 rotate z*-30 translate <2*11-4,0.01,-16.75> }
#end


//
// Distant Trees....
//
#if (ShowTrees)

	#declare txtTree=texture{txtTree_5}
	#declare txtLeaf=texture{txtLeaf_1}
	#declare Leaf=object{#include "my_leaf.inc" } 
	#declare Tree1=object{#include "my_tree.inc" }                      
	#declare Foliage1=object{#include "my_foliage.inc"  texture{txtLeaf} }
	
	#declare FastObjects=false; //*********!
	#if (FastObjects)

		#declare ScaledTree_o = 
			object{
				box { min_extent(Tree1) max_extent(Tree1) pigment { White } }
				scale 5/max_extent(Tree1).y
			}
				
	#else // not (FastObjects)
	
		#declare ScaledTree_o = 
			union{
				object {Foliage1}
				object {Tree1}
				scale 5/max_extent(Tree1).y
			}
			
	#end // of if (BoxTrees)                                                    
	
	
	//
	// place Trees
	// 
	#declare treeRand = seed(0);
	#declare sx=125;
	#declare zstart=-20;
	#declare zend=5;
	#while (sx<136)
		#declare sz=zstart;
		#while (sz<zend)	
			#declare Pos = sx*x + sz*z;
        	object {
        		ScaledTree_o
        		rotate y*360*rand(treeRand)
        		scale 1+0.25*rand(treeRand)-0.25*rand(treeRand)
        		translate Pos
        	}
	
			#declare sz=sz+5*rand(treeRand);
		#end
		#declare sx=sx+5;
	#end

#end // of if (ShowTrees)

//
// distant city buildings
// AKA: "its the day before submission, and I haven't done the background yet...."
//
#if (ShowCity)
	#declare Avg_City_Distance=2000;
	#declare City_Distance_Variance=1900;
	#declare Number_of_buildings=3000;
	#declare Min_Angle=-70;
	#declare Angle_range=80;
	#declare CityRand = seed(0);
	
	#declare n=0;
	#while (n<Number_of_buildings)
	
		box {
			<-10,0,-10> <10,25,10>
			scale <1+rand(CityRand)-rand(CityRand) , 1+rand(CityRand)-rand(CityRand) , 1+rand(CityRand)-rand(CityRand) > 
			texture {
				normal {
					quilted control0 0 control1 0.67
					scale <2,3,2>
					slope_map {
						[ 0.7 <0,0> ]
						[ 0.7 <0,1> ]
						[ 0.8 <1,1> ]
						[ 0.8 <1,0> ] 
						[ 1.0 <1,0> ]
					}
					bump_size 0.25
				}
				pigment { rgb 0.8*(0.5+rand(CityRand)/2)}
			}
			translate  x * ( Avg_City_Distance+rand(CityRand)*City_Distance_Variance - +rand(CityRand)*City_Distance_Variance ) 
			rotate y*(Min_Angle+Angle_range*(n/Number_of_buildings))
		}
	
		#declare n=n+1;
	#end // city while loop
#end // of if ShowCity