/ Persistence of Vision Ray Tracer Scene Description File
// File: StoneWall.inc
// Vers: 3.5
// Desc: Makes a stone wall out of isosurfaces
// Date: 12/13/2001
// Auth: Jeff M. Thomas
//

#version 3.5;

#macro Dents(Rand, Scale)
  #declare fn_Dents=function 
  {
    pigment 
    {
      agate  
      warp{ turbulence <0.1,0.1,0> octaves 6 lambda .5 omega .5 }
      scale Scale
      translate <1.3*Rand,.63*Rand,.2*Rand>
    }
  }
#end

#macro Granite(Rand, Scale)
  #declare fn_granite=function
  {
    pigment
    {
      granite
      //color_map { [0 rgb 0.0][1 rgb 0.52] }
      color_map { [0 rgb 0.0][.3 rgb 0.05][.8 rgb 0.25][1 rgb 0.35] }
      //color_map { [0 rgb 0.0][.3 rgb 0.01][.8 rgb 0.1][1 rgb 0.22] }
      //scale 5
      warp { turbulence .5 octaves 6 lambda .5 omega .5 }
      //scale .2
      //scale Scale
      scale .4
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
     }
   }
#end

#macro Warp(Rand)
  #declare fn_Warp=function 
  {
    pigment
    {
      dents
      warp 
      {                  // deforming the bricks ...
        turbulence <0.05,0.1,0.1>
        octaves 6
        lambda .5
        omega .5
      }
      scale <0.5,0.5,0.5>         
      translate <1.3*Rand,3.63*Rand,2.2*Rand>
    }
  }
#end

#macro Stone(StoneSize, Texture, Interior, Roughness, Bumpness, Randomizer, IsoStone)

  #declare StoneObject = 
  object
  {
    #if ( IsoStone = false )
      box { <-StoneSize.x/2,-StoneSize.y/2,-StoneSize.z/2>, <StoneSize.x/2,StoneSize.y/2,StoneSize.z/2> }         
    #else
      isosurface
      {
        //function { (x+y+z)+(f_wrinkles(x/2,y/2,z/2)*0.4) }
        #declare Rand = Randomizer;
        #declare Rough = Roughness;
        #declare xScale = (.5*StoneSize.x);
        #declare yScale = (.5*StoneSize.y);
        #declare zScale = (.5*StoneSize.z);
        //#declare bumpScale = (.05 * StoneSize).gray;
        //#debug concat( "Rough = ",str(Rough,7,2), "\n" )
        Dents(Rand,StoneSize)
        Granite(Rand,StoneSize)
        #if( Rough = 0 )
          #declare sizeBuffer = .1;  
          function{ f_rounded_box(x,y,z,0.01,xScale,yScale,zScale)-(fn_Dents((x+Rand)*Bumpness,(y+Rand)*Bumpness,(z+Rand)*Bumpness).gray*.05) }
        #else
          #declare sizeBuffer = .01;  
          //function{ f_rounded_box(x,y,z,0.01,xScale,yScale,zScale)-(f_wrinkles((x+(.8*Rand))/Rough,(y+(1.43*Rand))/Rough,(z+(.71*Rand))/Rough)*0.02)-(fn_Dents((x+Rand)*Bumpness,(y+Rand)*Bumpness,(z+Rand)*Bumpness).gray*.05) }
          //function{ f_rounded_box(x,y,z,0.01,xScale,yScale,zScale)-(fn_granite((x+(.8*Rand))*Rough,(y+(1.43*Rand))*Rough,(z+(.71*Rand))*Rough).gray)-(fn_Dents((x+Rand)*Bumpness,(y+Rand)*Bumpness,(z+Rand)*Bumpness).gray*.05) }
          function{ (f_rounded_box(x,y,z,0.02,xScale,yScale,zScale)+(fn_granite(x,y,z).gray*.045))/*-(fn_Dents((x+Rand)*Bumpness,(y+Rand)*Bumpness,(z+Rand)*Bumpness).gray*.05)*/ }
        #end
        threshold 0
        //accuracy .0005                                 
        max_gradient 1.153
        contained_by { box { <-((StoneSize.x/2)+sizeBuffer),-((StoneSize.y/2)+sizeBuffer),-((StoneSize.z/2)+sizeBuffer)>, <(StoneSize.x/2)+sizeBuffer,(StoneSize.y/2)+sizeBuffer,(StoneSize.z/2)+sizeBuffer> } }  
        all_intersections
      }
    #end
    texture{ Texture translate Rand rotate Rand }
    interior{ Interior }  
  }
#end // Stone macro

#macro MakeStoneWall(StoneSize, MortorSize, MortorDepth, WallSize, Texture, Interior, Roughness, Bumpness, IsoStones, Translucent)
  
  #declare xWidth = (((StoneSize.x+MortorSize.x)*WallSize.x)-MortorSize.x);
  #declare yWidth = (((StoneSize.y+MortorSize.y)*WallSize.y)-MortorSize.y);
  #declare zWidth = (((StoneSize.z+MortorSize.z)*WallSize.z)-MortorSize.z);
      
  #local MortorObject =
  object
  {
    box { <-xWidth/2+MortorDepth.x,-yWidth/2+MortorDepth.y,-zWidth/2+MortorDepth.z>, <xWidth/2-MortorDepth.x,yWidth/2-MortorDepth.y,zWidth/2-MortorDepth.z> }
    texture
    {
      pigment{ Gray }
      normal
      {
        agate
        agate_turb .5
        scale .1
      }
    }
/*    pigment 
    {
      pigment_pattern {
         wrinkles
         scale 0.25
      }
      color_map {
         [.55, rgb 0.5]
         [.55, rgb <1,1,0.95>]
      }
      warp{ turbulence <0.1,0.1,0> octaves 6 lambda .5 omega .5 }
      scale <2,2,2>
    }
*/
  }
  
  #local Stones =
  union 
  {
    #declare xStart = (0 - (xWidth/2)) + (StoneSize.x/2);
    #declare yStart = (0 - (yWidth/2)) + (StoneSize.y/2);
    #declare zStart = (0 - (zWidth/2)) + (StoneSize.z/2);
    //#debug concat( "xStart=",str(xStart,7,2), "\n" )
    //#debug concat( "yStart=",str(yStart,7,2), "\n" )
    //#debug concat( "zStart=",str(zStart,7,2), "\n" )
    #declare iCount = 0;
    #declare iz = 0;
    #while (iz < WallSize.z)
      #declare iy = 0;
      #while (iy < WallSize.y)
        #declare ix = 0;
        #while (ix < WallSize.x)
        
          Stone( StoneSize, Texture, Interior, Roughness, Bumpness, iCount, IsoStones )
          #declare iCount = iCount + 1;
  
          object{
            StoneObject
            //Stone_B_01( StoneSize.x, StoneSize.y, StoneSize.z, .01, Texture, Interior, iCount )
            translate< xStart+(ix*(StoneSize.x+MortorSize.x)), yStart+(iy*(StoneSize.y+MortorSize.y)), zStart+(iz*(StoneSize.z+MortorSize.z)) >
            //#debug concat( "ix= ",str(ix,2,0), " iy= ",str(iy,2,0), " iz= ",str(iz,2,0), " : " )
            //#debug concat( "xLocation=",str(xStart+(ix*(StoneSize.x+MortorSize.x)),7,2), " " )
            //#debug concat( "yLocation=",str(yStart+(iy*(StoneSize.y+MortorSize.y)),7,2), " " )
            //#debug concat( "zLocation=",str(zStart+(iz*(StoneSize.z+MortorSize.z)),7,2), "\n" )
          }
           
          #declare ix = ix + 1;
        #end // ix
        #declare iy = iy + 1;
      #end // iy
      #declare iz = iz + 1;
    #end // iz
    #if ( (WallSize.x = 1) & (WallSize.y = 1) & (WallSize.z = 1) )
      // this quiets the warnings I get about CSG's needing more than one
      // object when I use this macro for creating 1 stone.
      // (over kill? Yes. Lazy? Oh yes.)
      box{ -.0001, .0001 pigment{ color rgbf 1 } }
    #end           
    //texture{ T_Stone1 }  
  } // Stones union
  
  #declare StoneWall =
    #if (Translucent = false)
      union
      {    
        object{ Stones }
        object{ MortorObject }
      } 
    #else
      union
      {    
        object{ Stones }
        difference
        {
          object{ MortorObject }
          object{ Stones }
        }
      } 
    #end

#end // MakeStoneWall macro


// some samples
/*
#declare StoneWallTexture=
  texture{ pigment{ DimGray } }
  texture{ T_Grnt8a }  
  //glass wall sample, be sure to use the interior and set Translucent to true
  //texture { pigment{ Col_Glass_Clear } finish{ F_Glass5 }}
  
  
#declare StoneWallInterior=
  interior {
//    ior 1.5
//    fade_distance 1.0
//    fade_power 2
//    fade_color Col_Glass_Old
  }

MakeStoneWall( <.5,.5,.5>, <.05,.05,.05>, <.02,.02,.02>, <5,5,1>, StoneWallTexture, StoneWallInterior, 10, true, false )
object{ StoneWall }    

MakeStoneWall( <.5,.5,.5>, <.05,.05,.05>, <.02,.02,.02>, <2,2,1>, StoneWallTexture, StoneWallInterior, 10, true, false)
object{ StoneWall translate<0,0,-1> }    
*/