//candles.inc by Chris Young AKA Dastardly
// Some modifications done by Jeff M. Thomas
#declare RS1 = seed(420);
#declare RS2 = seed (569);
#declare RS3 = seed(6969);

#ifndef (CandleColor)
  #declare CandleColor = rgb <244/255, 244/255, 210/255>;
#end

#declare C_WickBottom = rgb 0;

#declare C_WickTop = rgb<1,0,0>;

#declare T_Wick =
texture{
  pigment{
    gradient y
    pigment_map {
      [0.0 color C_WickBottom]
      [1.0 bozo
        color_map{
          [0.0 C_WickBottom]
          [1.0 C_WickTop]
        }
      ]
    }
  }
  finish{ambient 1}
}

///////////////////////

#declare O_Wick =
intersection{
  torus{
    1,
    0.05
    rotate x*90
  }
  box{<-2,0,-2>, <-0.9, 2, 2>}
  translate x
  rotate y*45
  scale 0.2
  texture{T_Wick scale 0.1}
  no_shadow
}

#declare O_Flame =
union{

  sphere{
    <0, 0, 0>, 1
    hollow
    no_shadow

    finish{ambient 9}
    pigment { color rgbf <1, .7, .4, .8> }
    
    interior {
      media {
        emission <1.0, 0.6, 0.0>
        density {
          gradient y
          color_map {
            [ 0.0 color rgbt <1.0, 0.6, 0.0,  1> ]
            [ 0.5 color rgbt <1.0, 1.0, 0.8, -1> ]
            [ 1.0 color rgbt <1.0, 0.7, 0.0,  1> ]
          }
          warp{turbulence 0.2}
        }
        //samples 30
        //scale 0.5
      }
    }
    scale <0.05,0.25,0.05>
  }

  light_source{
    0, color <0.5, 0.35, 0.1>
    fade_distance .8
    fade_power 1.75
    photons { reflection off refraction off } 
    //area_light
    //<0, 0, 0> <0, 0.2, 0>
    //6, 1
    //adaptive 2
    //jitter
  }

}

#macro O_CandleBody( mheight,  mradius)
difference{
  cylinder{
    <0,0,0>,
    <0,2,0>, 1
  }
  sphere{<0,20,0>, 19.1}
  intersection{
    height_field{
      png
      "plasma3.png"
      smooth
    }
    box{0,1}
    translate -0.5
    scale<1,1.25,1>
    rotate x*180
    translate y*1.0
    scale <10,1,10>
  }
texture{
  gradient y
  texture_map{
    [0.0 pigment{color CandleColor} finish{ambient 0.7}]
    [0.5 pigment{color CandleColor} finish{ambient 0}]
    [1.0 pigment{color CandleColor} finish{ambient 0}]
  }
  translate -0.5*y
  rotate z*180
  translate y*0.5
}
scale <mradius, mheight, mradius>
}
#end

#macro CandleWax( height,  Radius,  DripCount)
  #declare Drips = DripCount;
  blob{
    threshold 0.01
    #while (Drips > 0)
      #declare Height = height - (height*.1428);
      #declare Stop = rand(RS1)*Height;
      #declare Rotate = (360/(DripCount))*Drips;
      #while (Height > Stop)
        #declare Size = rand(RS3);
        sphere{<0, Height, -Radius>, (Radius*.025)+Size/60, (Radius/2)+Size/65 rotate y*Rotate}
        sphere{<0, Height-0.01, -Radius>, ((Radius*.030)+Size/30)*1.5, ((Radius/1.75)+Size/35)*1.5 rotate y*Rotate}
        #declare Height = Height - 0.03;
      #end //(While Height > Stop)
      #declare Drips = Drips-1;
    #end //(While drips > 0)
    sphere{0, Radius+0.1, Radius+0.1 scale <1,1/2,1> translate (Radius/2*rand(RS1))*x + (Radius/2*rand(RS3))*z}
    texture{ gradient y
  texture_map{
    [0.0 pigment{color CandleColor} finish{ambient 0.7}]
    [0.5 pigment{color CandleColor} finish{ambient 0}]
    [1.0 pigment{color CandleColor} finish{ambient 0}]
  }
  translate -0.5*y
  rotate z*180
  translate y*0.5 scale <Radius, height, Radius>}
    clipped_by{box{<-Radius*4, 0, -Radius*4>,<Radius*4, height*4, Radius*4>}}
  }//blob
#end

#macro O_Candle()
union{
  #O_CandleBody(0.7, 0.2)
  object{O_Wick  translate y*0.65}
  object{O_Flame translate y*0.85}
  #CandleWax(0.7, 0.2, 6)
}
#end

#macro O_BigCandle()
union{
  #O_CandleBody(0.4, 0.2)
  object{O_Wick  translate y*0.35}
  object{O_Flame translate y*0.53}
  #CandleWax(0.4, 0.2, 5)
}
#end

#macro O_SkinyCandle()
union{
  #O_CandleBody(0.7, 0.1)
  object{O_Wick  translate y*0.65}
  object{O_Flame translate y*0.85}
  #CandleWax(0.7, 0.1, 4)
}
#end

#macro O_TallCandle()
union{
  #O_CandleBody(1.45, 0.1)
  object{O_Wick  translate y*1.25}
  object{O_Flame translate y*1.45}
  #CandleWax(1.45, 0.1, 4)
}
#end
