#include "textures.inc"

#declare Eye = 
   texture  
   {   
      pigment
      {
         gradient x
         color_map
         {
            [ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            [ 0.128114  rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            [ 0.142349  rgbft <0.933333, 0.92549, 0.92549, 0.0, 0.0> ]
            [ 1.0     rgbft <0.882353, 0.882353, 0.866667, 0.0, 0.0> ]
         }
      }   
      normal
      {
         granite , 0.05
      }   
      finish
      {
         ambient 0.1
         phong 0.431633
         phong_size 22.513333
         specular 0.1007
      }   
      scale  <2.0, 1.0, 1.0>
      translate 1.0 * x
   }

#declare Fin = 
   texture  
   {   
      pigment
      {
         radial
         color_map
         {
            [ 0.0     rgbft <1.0, 0.501961, 0.0, 0.187467, 0.208333> ]
            [ 0.5     rgbft <0.988235, 0.721569, 0.011765, 0.229133, 0.3958> ]
            [ 1.0     rgbft <1.0, 0.501961, 0.0, 0.229133, 0.2708> ]
         }
         rotate -90*x
         turbulence 0.1
         frequency 60.0
      }   
      normal
      {
         radial , 0.2
         rotate -90*x
         turbulence 0.1
         frequency 60.0
         sine_wave
      }   
      finish
      {
         ambient 0.2
         phong 0.2158
         specular 0.143867
         metallic 1.0
      }
   }

#declare Top_Fin = 
   texture  
   {   
      pigment
      {
         gradient x
         color_map
         {
            [ 0.0     rgbft <1.0, 0.501961, 0.0, 0.187467, 0.208333> ]
            [ 0.5     rgbft <0.988235, 0.721569, 0.011765, 0.229133, 0.3958> ]
            [ 1.0     rgbft <1.0, 0.501961, 0.0, 0.229133, 0.2708> ]
         }
         turbulence 0.01
         frequency 60.0
      }   
      normal
      {
         gradient x , 0.2
         turbulence 0.01
         frequency 60.0
         sine_wave
      }   
      finish
      {
         ambient 0.2
         phong 0.187033
         specular 0.129467
         metallic 1.0
      }
   }

#declare Scales = 
   texture  
   {   
      pigment
      {
         crackle
         color_map
         {
            [ 0.0     rgbft <0.907843, 0.572549, 0.12549, 0.0, 0.0> ]
            [ 0.234875  rgbft <0.588235, 0.4, 0.086275, 0.0, 0.0> ]
            [ 1.0     rgbft <0.447059, 0.345098, 0.078431, 0.0, 0.0> ]
         }
      }   
      normal
      {
         crackle , 0.125
         slope_map
         {
            [ 0.0  <0.0 , 0.0> ]
            [ 0.02  <0.1 , 1.0> ]
            [ 0.07  <0.9 , 1.0> ]
            [ 0.9  <1.0 , 0.0> ]
            [ 1.0  <1.0 , 0.0> ]
         }
      }   
      finish
      {
         ambient 0.2
         phong 0.4676
         specular 0.525167
         metallic 1.0
      }   
      scale  0.02
   }



#declare sPatchObj17 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.215516, -0.433003, -0.145776>, <0.199380, -0.363855, -0.103154>, <0.113010, -0.209593, -0.080900>, <0.113931, -0.222370, 0.000919>, 
      <0.220453, -0.454160, -0.158816>, <0.204317, -0.385011, -0.116195>, <0.117521, -0.220160, -0.079029>, <0.118441, -0.232937, 0.002790>, 
      <0.187675, -0.480555, -0.175232>, <0.172432, -0.406475, -0.121187>, <0.117745, -0.242674, -0.086319>, <0.124521, -0.246868, 0.006296>, 
      <0.179774, -0.504525, -0.172993>, <0.164531, -0.430446, -0.118949>, <0.122188, -0.253399, -0.085459>, <0.128964, -0.257593, 0.007156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.193318, -0.500344, -0.139486>, <0.193915, -0.507363, -0.147823>, <0.176370, -0.514851, -0.172029>, <0.179774, -0.504525, -0.172993>, 
      <0.189799, -0.458904, -0.090263>, <0.190395, -0.465923, -0.098600>, <0.161127, -0.440771, -0.117984>, <0.164531, -0.430446, -0.118949>, 
      <0.154817, -0.344880, -0.052066>, <0.143523, -0.317299, -0.053254>, <0.133572, -0.280880, -0.083255>, <0.122188, -0.253399, -0.085459>, 
      <0.166608, -0.349528, 0.011115>, <0.155315, -0.321948, 0.009928>, <0.140349, -0.285074, 0.009360>, <0.128964, -0.257593, 0.007156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.258768, -0.526144, 0.211193>, <0.245974, -0.474174, 0.145542>, <0.182108, -0.355638, 0.094163>, <0.166608, -0.349528, 0.011115>, 
      <0.261172, -0.535910, 0.223530>, <0.248378, -0.483940, 0.157879>, <0.170815, -0.328058, 0.092976>, <0.155315, -0.321948, 0.009928>, 
      <0.220653, -0.533001, 0.225615>, <0.196565, -0.453446, 0.158772>, <0.148125, -0.289886, 0.115630>, <0.140349, -0.285074, 0.009360>, 
      <0.209259, -0.522774, 0.229966>, <0.185171, -0.443220, 0.163123>, <0.136740, -0.262406, 0.113427>, <0.128964, -0.257593, 0.007156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219699, -0.491077, 0.226112>, <0.222165, -0.498847, 0.232037>, <0.202045, -0.516298, 0.232721>, <0.209259, -0.522774, 0.229966>, 
      <0.192818, -0.406369, 0.161526>, <0.195284, -0.414140, 0.167451>, <0.177956, -0.436744, 0.165878>, <0.185171, -0.443220, 0.163123>, 
      <0.115151, -0.239318, 0.109457>, <0.119661, -0.249886, 0.111328>, <0.132297, -0.251681, 0.112567>, <0.136740, -0.262406, 0.113427>, 
      <0.113931, -0.222370, 0.000919>, <0.118441, -0.232937, 0.002790>, <0.124521, -0.246868, 0.006296>, <0.128964, -0.257593, 0.007156>
    }
  }
  texture {
    Fin
    scale <0.3, 0.4, 0.4>
    rotate <20.0, -90.0, 0.0>
    translate <0.150000, -0.250000, 0.000000>
  }
}
#declare sPatchObj18 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.067614, 0.444472, 0.000000>, <-0.065255, 0.439610, 0.000000>, <-0.062023, 0.433169, 0.000000>, <-0.059750, 0.428266, 0.000000>, 
      <-0.152092, 0.419896, 0.002991>, <-0.149733, 0.415034, 0.002991>, <-0.148519, 0.395797, -0.004187>, <-0.146247, 0.390894, -0.004187>, 
      <-0.264731, 0.387127, 0.006979>, <-0.264389, 0.369470, -0.000199>, <-0.269413, 0.358443, -0.009771>, <-0.261574, 0.341066, -0.009771>, 
      <-0.349210, 0.362551, 0.009970>, <-0.348868, 0.344894, 0.002792>, <-0.355909, 0.321072, -0.013958>, <-0.348071, 0.303695, -0.013958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.040528, 0.384467, 0.000000>, <-0.092009, 0.314693, 0.004786>, <-0.160651, 0.221662, 0.011166>, <-0.212133, 0.151888, 0.015952>, 
      <-0.044035, 0.388507, 0.000000>, <-0.095517, 0.318733, 0.004786>, <-0.174300, 0.232704, 0.002792>, <-0.225782, 0.162930, 0.007577>, 
      <-0.050068, 0.393035, 0.000000>, <-0.111691, 0.330264, -0.003589>, <-0.183059, 0.236980, -0.007463>, <-0.244682, 0.174208, -0.011052>, 
      <-0.052220, 0.397934, 0.000000>, <-0.113843, 0.335162, -0.003589>, <-0.196007, 0.251467, -0.008375>, <-0.257630, 0.188696, -0.011964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.053775, 0.414623, 0.000000>, <-0.052564, 0.409743, 0.000000>, <-0.054242, 0.402538, 0.000000>, <-0.052220, 0.397934, 0.000000>, 
      <-0.126753, 0.364302, 0.002991>, <-0.125541, 0.359422, 0.002991>, <-0.115865, 0.339766, -0.003589>, <-0.113843, 0.335162, -0.003589>, 
      <-0.224056, 0.297207, 0.006979>, <-0.210404, 0.279848, 0.007280>, <-0.210708, 0.267917, -0.009411>, <-0.196007, 0.251467, -0.008375>, 
      <-0.297034, 0.246886, 0.009970>, <-0.283382, 0.229527, 0.010271>, <-0.272331, 0.205145, -0.013000>, <-0.257630, 0.188696, -0.011964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.053775, 0.414623, 0.000000>, <-0.126753, 0.364302, 0.002991>, <-0.224056, 0.297207, 0.006979>, <-0.297034, 0.246886, 0.009970>, 
      <-0.054852, 0.418959, 0.000000>, <-0.127830, 0.368638, 0.002991>, <-0.238896, 0.316077, 0.006652>, <-0.311874, 0.265756, 0.009643>, 
      <-0.057871, 0.424212, 0.000000>, <-0.144367, 0.386841, -0.004187>, <-0.251702, 0.319181, -0.009771>, <-0.338198, 0.281810, -0.013958>, 
      <-0.059750, 0.428266, 0.000000>, <-0.146247, 0.390894, -0.004187>, <-0.261574, 0.341066, -0.009771>, <-0.348071, 0.303695, -0.013958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.094538, 0.444472, 0.000000>, <0.092180, 0.439610, 0.000000>, <0.088948, 0.433169, 0.000000>, <0.086676, 0.428266, 0.000000>, 
      <0.179017, 0.419896, 0.002991>, <0.176658, 0.415034, 0.002991>, <0.175444, 0.395797, -0.004187>, <0.173172, 0.390894, -0.004187>, 
      <0.291656, 0.387127, 0.006979>, <0.291314, 0.369470, -0.000199>, <0.296338, 0.358443, -0.009771>, <0.288500, 0.341066, -0.009771>, 
      <0.376134, 0.362551, 0.009970>, <0.375793, 0.344894, 0.002792>, <0.382834, 0.321072, -0.013958>, <0.374995, 0.303695, -0.013958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.067452, 0.384467, 0.000000>, <0.118934, 0.314693, 0.004786>, <0.187576, 0.221662, 0.011166>, <0.239058, 0.151888, 0.015952>, 
      <0.070960, 0.388507, 0.000000>, <0.122442, 0.318733, 0.004786>, <0.201225, 0.232704, 0.002792>, <0.252707, 0.162930, 0.007577>, 
      <0.076993, 0.393035, 0.000000>, <0.138616, 0.330264, -0.003589>, <0.209984, 0.236980, -0.007463>, <0.271607, 0.174208, -0.011052>, 
      <0.079145, 0.397934, 0.000000>, <0.140767, 0.335162, -0.003589>, <0.222932, 0.251467, -0.008375>, <0.284554, 0.188696, -0.011964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.080700, 0.414623, 0.000000>, <0.079489, 0.409743, 0.000000>, <0.081167, 0.402538, 0.000000>, <0.079145, 0.397934, 0.000000>, 
      <0.153678, 0.364302, 0.002991>, <0.152466, 0.359422, 0.002991>, <0.142790, 0.339766, -0.003589>, <0.140767, 0.335162, -0.003589>, 
      <0.250981, 0.297207, 0.006979>, <0.237329, 0.279848, 0.007280>, <0.237633, 0.267917, -0.009411>, <0.222932, 0.251467, -0.008375>, 
      <0.323958, 0.246886, 0.009970>, <0.310307, 0.229527, 0.010271>, <0.299256, 0.205145, -0.013000>, <0.284554, 0.188696, -0.011964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.080700, 0.414623, 0.000000>, <0.153678, 0.364302, 0.002991>, <0.250981, 0.297207, 0.006979>, <0.323958, 0.246886, 0.009970>, 
      <0.081777, 0.418959, 0.000000>, <0.154755, 0.368638, 0.002991>, <0.265821, 0.316077, 0.006652>, <0.338799, 0.265756, 0.009643>, 
      <0.084796, 0.424212, 0.000000>, <0.171292, 0.386841, -0.004187>, <0.278627, 0.319181, -0.009771>, <0.365123, 0.281810, -0.013958>, 
      <0.086676, 0.428266, 0.000000>, <0.173172, 0.390894, -0.004187>, <0.288500, 0.341066, -0.009771>, <0.374995, 0.303695, -0.013958>
    }
  }
  texture {
    Fin
    scale 0.3
    translate <0.000000, 0.450000, 0.000000>
  }
  scale 0.95
}
#declare sPatchObj19 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004859, 0.188682, 0.079978>, <0.004859, 0.193874, 0.080768>, <0.004859, 0.200948, 0.081133>, <0.004859, 0.205986, 0.082612>, 
      <0.009110, 0.156351, 0.125782>, <0.009110, 0.161542, 0.126573>, <0.004252, 0.174202, 0.130902>, <0.004252, 0.179241, 0.132381>, 
      <0.014779, 0.113242, 0.186855>, <0.009920, 0.124019, 0.191609>, <0.003055, 0.132823, 0.191920>, <0.003442, 0.143580, 0.198739>, 
      <0.019030, 0.080910, 0.232659>, <0.014171, 0.091688, 0.237414>, <0.002447, 0.106077, 0.241689>, <0.002834, 0.116834, 0.248508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004859, 0.224577, 0.090513>, <0.009718, 0.198364, 0.143862>, <0.016196, 0.163413, 0.214994>, <0.021054, 0.137200, 0.268343>, 
      <0.003652, 0.219312, 0.087766>, <0.008511, 0.193099, 0.141115>, <0.015454, 0.154535, 0.210174>, <0.020313, 0.128322, 0.263523>, 
      <0.004859, 0.211801, 0.084319>, <0.004252, 0.185056, 0.134087>, <0.003749, 0.152132, 0.204160>, <0.003141, 0.125386, 0.253929>, 
      <0.004859, 0.205986, 0.082612>, <0.004252, 0.179241, 0.132381>, <0.003442, 0.143580, 0.198739>, <0.002834, 0.116834, 0.248508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012957, 0.241328, 0.101047>, <0.011135, 0.218534, 0.153186>, <0.008705, 0.188142, 0.222706>, <0.006883, 0.165348, 0.274845>, 
      <0.010958, 0.235816, 0.098447>, <0.009136, 0.213022, 0.150586>, <0.008705, 0.179885, 0.217705>, <0.006883, 0.157091, 0.269845>, 
      <0.006136, 0.230151, 0.093420>, <0.010995, 0.203937, 0.146769>, <0.016902, 0.171875, 0.219587>, <0.021760, 0.145661, 0.272936>, 
      <0.004859, 0.224577, 0.090513>, <0.009718, 0.198364, 0.143862>, <0.016196, 0.163413, 0.214994>, <0.021054, 0.137200, 0.268343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017006, 0.258079, 0.106315>, <0.018220, 0.234193, 0.162419>, <0.019840, 0.202343, 0.237223>, <0.021054, 0.178456, 0.293327>, 
      <0.017006, 0.252936, 0.104650>, <0.018220, 0.229049, 0.160754>, <0.017534, 0.195640, 0.233477>, <0.018749, 0.171753, 0.289581>, 
      <0.014642, 0.245975, 0.103239>, <0.012819, 0.223181, 0.155378>, <0.008705, 0.195000, 0.226859>, <0.006883, 0.172206, 0.278998>, 
      <0.012957, 0.241328, 0.101047>, <0.011135, 0.218534, 0.153186>, <0.008705, 0.188142, 0.222706>, <0.006883, 0.165348, 0.274845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012957, 0.282009, 0.114216>, <0.014779, 0.257607, 0.168327>, <0.017208, 0.225071, 0.240474>, <0.019030, 0.200668, 0.294585>, 
      <0.014951, 0.274939, 0.112055>, <0.016773, 0.250537, 0.166165>, <0.017530, 0.218786, 0.238168>, <0.019351, 0.194384, 0.292279>, 
      <0.017006, 0.265364, 0.108673>, <0.018220, 0.241477, 0.164777>, <0.021767, 0.207946, 0.240355>, <0.022981, 0.184059, 0.296459>, 
      <0.017006, 0.258079, 0.106315>, <0.018220, 0.234193, 0.162419>, <0.019840, 0.202343, 0.237223>, <0.021054, 0.178456, 0.293327>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004859, 0.301153, 0.119483>, <0.009110, 0.276216, 0.175993>, <0.014779, 0.242967, 0.251339>, <0.019030, 0.218030, 0.307848>, 
      <0.003580, 0.295174, 0.117486>, <0.007831, 0.270237, 0.173995>, <0.014779, 0.236793, 0.249138>, <0.019030, 0.211856, 0.305648>, 
      <0.011282, 0.287949, 0.116032>, <0.013104, 0.263547, 0.170143>, <0.016894, 0.231217, 0.242730>, <0.018716, 0.206815, 0.296840>, 
      <0.012957, 0.282009, 0.114216>, <0.014779, 0.257607, 0.168327>, <0.017208, 0.225071, 0.240474>, <0.019030, 0.200668, 0.294585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023079, 0.329315, 0.130018>, <0.021864, 0.302926, 0.183737>, <0.020245, 0.267739, 0.255363>, <0.019030, 0.241349, 0.309082>, 
      <0.023079, 0.319580, 0.125961>, <0.021864, 0.293190, 0.179680>, <0.022821, 0.261890, 0.252494>, <0.021606, 0.235500, 0.306214>, 
      <0.006957, 0.310957, 0.122758>, <0.011208, 0.286021, 0.179267>, <0.014779, 0.249566, 0.253690>, <0.019030, 0.224629, 0.310200>, 
      <0.004859, 0.301153, 0.119483>, <0.009110, 0.276216, 0.175993>, <0.014779, 0.242967, 0.251339>, <0.019030, 0.218030, 0.307848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004859, 0.358032, 0.143185>, <0.004859, 0.325684, 0.197317>, <0.004859, 0.282552, 0.269494>, <0.004859, 0.250203, 0.323626>, 
      <0.005618, 0.348063, 0.138743>, <0.005618, 0.315714, 0.192876>, <0.007729, 0.277253, 0.266693>, <0.007729, 0.244904, 0.320825>, 
      <0.023079, 0.339414, 0.134226>, <0.021864, 0.313025, 0.187946>, <0.017801, 0.273288, 0.258084>, <0.016586, 0.246898, 0.311803>, 
      <0.023079, 0.329315, 0.130018>, <0.021864, 0.302926, 0.183737>, <0.020245, 0.267739, 0.255363>, <0.019030, 0.241349, 0.309082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.019030, 0.382515, 0.153720>, <0.014171, 0.349136, 0.205069>, <0.007693, 0.304631, 0.273535>, <0.002834, 0.271251, 0.324884>, 
      <0.018014, 0.373738, 0.151737>, <0.013155, 0.340359, 0.203086>, <0.005332, 0.299247, 0.271120>, <0.000473, 0.265868, 0.322469>, 
      <0.004231, 0.366285, 0.146862>, <0.004231, 0.333936, 0.200994>, <0.002114, 0.287619, 0.272172>, <0.002114, 0.255271, 0.326304>, 
      <0.004859, 0.358032, 0.143185>, <0.004859, 0.325684, 0.197317>, <0.004859, 0.282552, 0.269494>, <0.004859, 0.250203, 0.323626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012957, 0.427983, 0.158988>, <0.014779, 0.384344, 0.212728>, <0.017208, 0.326159, 0.284382>, <0.019030, 0.282520, 0.338123>, 
      <0.014779, 0.414343, 0.157408>, <0.016601, 0.370704, 0.211148>, <0.012349, 0.322779, 0.280411>, <0.014171, 0.279140, 0.334151>, 
      <0.020584, 0.395942, 0.156753>, <0.015726, 0.362562, 0.208102>, <0.010341, 0.310669, 0.276244>, <0.005482, 0.277290, 0.327593>, 
      <0.019030, 0.382515, 0.153720>, <0.014171, 0.349136, 0.205069>, <0.007693, 0.304631, 0.273535>, <0.002834, 0.271251, 0.324884>
    }
  }
  texture {
    Top_Fin
    scale 0.4
    rotate -90.0*z
    translate <0.000000, 0.000000, 0.200000>
  }
}
#declare sPatchObj20 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126773, -0.256800, -0.039323>, <0.135622, -0.253886, -0.039323>, <0.132723, -0.206521, -0.041946>, <0.130521, -0.185898, -0.047368>, 
      <0.117923, -0.259715, -0.039323>, <0.126772, -0.256801, -0.039323>, <0.128558, -0.207892, -0.051257>, <0.126356, -0.187270, -0.056679>, 
      <0.092084, -0.219907, -0.041946>, <0.096249, -0.218535, -0.051256>, <0.106059, -0.193954, -0.070030>, <0.115834, -0.190735, -0.070030>, 
      <0.081597, -0.202010, -0.047368>, <0.085762, -0.200639, -0.056679>, <0.096284, -0.197173, -0.070030>, <0.106059, -0.193954, -0.070030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126773, -0.256800, -0.039323>, <0.135622, -0.253886, -0.039323>, <0.132723, -0.206521, -0.041946>, <0.130521, -0.185898, -0.047368>, 
      <0.126773, -0.256800, -0.039323>, <0.132921, -0.245692, -0.043327>, <0.128558, -0.207892, -0.051257>, <0.126356, -0.187270, -0.056679>, 
      <0.126773, -0.256800, -0.039323>, <0.132921, -0.245692, -0.043327>, <0.122063, -0.209643, -0.060940>, <0.115834, -0.190735, -0.070030>, 
      <0.126773, -0.256800, -0.039323>, <0.124072, -0.248606, -0.043327>, <0.112287, -0.212862, -0.060940>, <0.106059, -0.193954, -0.070030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126773, -0.256800, -0.039323>, <0.124072, -0.248606, -0.043327>, <0.112287, -0.212862, -0.060940>, <0.106059, -0.193954, -0.070030>, 
      <0.126773, -0.256800, -0.039323>, <0.115222, -0.251521, -0.043327>, <0.102512, -0.216082, -0.060940>, <0.096284, -0.197173, -0.070030>, 
      <0.126773, -0.256800, -0.039323>, <0.115222, -0.251521, -0.043327>, <0.096249, -0.218535, -0.051256>, <0.085762, -0.200639, -0.056679>, 
      <0.126773, -0.256800, -0.039323>, <0.117923, -0.259715, -0.039323>, <0.092084, -0.219907, -0.041946>, <0.081597, -0.202010, -0.047368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129894, -0.272568, 0.020946>, <0.141246, -0.268830, 0.020946>, <0.141590, -0.209973, 0.009286>, <0.140659, -0.182559, 0.007313>, 
      <0.129871, -0.272317, 0.012817>, <0.141223, -0.268579, 0.012817>, <0.141590, -0.209973, -0.007428>, <0.140659, -0.182559, -0.009401>, 
      <0.127180, -0.258856, -0.031465>, <0.136029, -0.255942, -0.031465>, <0.139487, -0.204293, -0.026826>, <0.137285, -0.183670, -0.032247>, 
      <0.126773, -0.256800, -0.039323>, <0.135622, -0.253886, -0.039323>, <0.132723, -0.206521, -0.041946>, <0.130521, -0.185898, -0.047368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129894, -0.272568, 0.020946>, <0.118736, -0.276243, 0.020946>, <0.086398, -0.227793, 0.009261>, <0.071460, -0.205348, 0.007313>, 
      <0.129871, -0.272317, 0.012817>, <0.118713, -0.275992, 0.012817>, <0.086398, -0.227793, -0.007453>, <0.071460, -0.205348, -0.009401>, 
      <0.127180, -0.258856, -0.031465>, <0.118330, -0.261771, -0.031465>, <0.085320, -0.222135, -0.026825>, <0.074833, -0.204238, -0.032247>, 
      <0.126773, -0.256800, -0.039323>, <0.117923, -0.259715, -0.039323>, <0.092084, -0.219907, -0.041946>, <0.081597, -0.202010, -0.047368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129894, -0.272568, 0.020946>, <0.141246, -0.268830, 0.020946>, <0.141590, -0.209973, 0.009286>, <0.140659, -0.182559, 0.007313>, 
      <0.129871, -0.272317, 0.012817>, <0.141223, -0.268579, 0.012817>, <0.141590, -0.209973, -0.007428>, <0.140659, -0.182559, -0.009401>, 
      <0.127180, -0.258856, -0.031465>, <0.136029, -0.255942, -0.031465>, <0.139487, -0.204293, -0.026826>, <0.137285, -0.183670, -0.032247>, 
      <0.126773, -0.256800, -0.039323>, <0.135622, -0.253886, -0.039323>, <0.132723, -0.206521, -0.041946>, <0.130521, -0.185898, -0.047368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129894, -0.272568, 0.020946>, <0.129871, -0.272317, 0.012817>, <0.127180, -0.258856, -0.031465>, <0.126773, -0.256800, -0.039323>, 
      <0.118736, -0.276243, 0.020946>, <0.118713, -0.275992, 0.012817>, <0.118330, -0.261771, -0.031465>, <0.117923, -0.259715, -0.039323>, 
      <0.086398, -0.227793, 0.009261>, <0.086398, -0.227793, -0.007453>, <0.085320, -0.222135, -0.026825>, <0.092084, -0.219907, -0.041946>, 
      <0.071460, -0.205348, 0.007313>, <0.071460, -0.205348, -0.009401>, <0.074833, -0.204238, -0.032247>, <0.081597, -0.202010, -0.047368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127069, -0.260057, 0.066315>, <0.136278, -0.257024, 0.066315>, <0.132852, -0.207778, 0.058316>, <0.130521, -0.185898, 0.061995>, 
      <0.117922, -0.263070, 0.066315>, <0.127131, -0.260037, 0.066315>, <0.128687, -0.209150, 0.067627>, <0.126356, -0.187270, 0.071305>, 
      <0.092533, -0.220932, 0.058336>, <0.096698, -0.219561, 0.067647>, <0.106059, -0.193954, 0.084656>, <0.115834, -0.190735, 0.084656>, 
      <0.081597, -0.202010, 0.061995>, <0.085762, -0.200639, 0.071305>, <0.096284, -0.197173, 0.084656>, <0.106059, -0.193954, 0.084656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127069, -0.260057, 0.066315>, <0.136278, -0.257024, 0.066315>, <0.132852, -0.207778, 0.058316>, <0.130521, -0.185898, 0.061995>, 
      <0.127437, -0.261688, 0.060400>, <0.136646, -0.258655, 0.060400>, <0.139617, -0.205551, 0.043195>, <0.137285, -0.183670, 0.046874>, 
      <0.129911, -0.272758, 0.027090>, <0.141263, -0.269019, 0.027090>, <0.141590, -0.209973, 0.026000>, <0.140659, -0.182559, 0.024027>, 
      <0.129894, -0.272568, 0.020946>, <0.141246, -0.268830, 0.020946>, <0.141590, -0.209973, 0.009286>, <0.140659, -0.182559, 0.007313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127069, -0.260057, 0.066315>, <0.117922, -0.263070, 0.066315>, <0.092533, -0.220932, 0.058336>, <0.081597, -0.202010, 0.061995>, 
      <0.127437, -0.261688, 0.060400>, <0.118290, -0.264701, 0.060400>, <0.085768, -0.223160, 0.043216>, <0.074833, -0.204238, 0.046874>, 
      <0.129911, -0.272758, 0.027090>, <0.118753, -0.276432, 0.027090>, <0.086398, -0.227793, 0.025975>, <0.071460, -0.205348, 0.024027>, 
      <0.129894, -0.272568, 0.020946>, <0.118736, -0.276243, 0.020946>, <0.086398, -0.227793, 0.009261>, <0.071460, -0.205348, 0.007313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127069, -0.260057, 0.066315>, <0.136278, -0.257024, 0.066315>, <0.132852, -0.207778, 0.058316>, <0.130521, -0.185898, 0.061995>, 
      <0.127437, -0.261688, 0.060400>, <0.136646, -0.258655, 0.060400>, <0.139617, -0.205551, 0.043195>, <0.137285, -0.183670, 0.046874>, 
      <0.129911, -0.272758, 0.027090>, <0.141263, -0.269019, 0.027090>, <0.141590, -0.209973, 0.026000>, <0.140659, -0.182559, 0.024027>, 
      <0.129894, -0.272568, 0.020946>, <0.141246, -0.268830, 0.020946>, <0.141590, -0.209973, 0.009286>, <0.140659, -0.182559, 0.007313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127069, -0.260057, 0.066315>, <0.127437, -0.261688, 0.060400>, <0.129911, -0.272758, 0.027090>, <0.129894, -0.272568, 0.020946>, 
      <0.117922, -0.263070, 0.066315>, <0.118290, -0.264701, 0.060400>, <0.118753, -0.276432, 0.027090>, <0.118736, -0.276243, 0.020946>, 
      <0.092533, -0.220932, 0.058336>, <0.085768, -0.223160, 0.043216>, <0.086398, -0.227793, 0.025975>, <0.086398, -0.227793, 0.009261>, 
      <0.081597, -0.202010, 0.061995>, <0.074833, -0.204238, 0.046874>, <0.071460, -0.205348, 0.024027>, <0.071460, -0.205348, 0.007313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127069, -0.260057, 0.066315>, <0.117922, -0.263070, 0.066315>, <0.092533, -0.220932, 0.058336>, <0.081597, -0.202010, 0.061995>, 
      <0.127069, -0.260057, 0.066315>, <0.115183, -0.254451, 0.068706>, <0.096698, -0.219561, 0.067647>, <0.085762, -0.200639, 0.071305>, 
      <0.127069, -0.260057, 0.066315>, <0.115183, -0.254451, 0.068706>, <0.102562, -0.216443, 0.077409>, <0.096284, -0.197173, 0.084656>, 
      <0.127069, -0.260057, 0.066315>, <0.124330, -0.251439, 0.068706>, <0.112337, -0.213224, 0.077409>, <0.106059, -0.193954, 0.084656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127069, -0.260057, 0.066315>, <0.124330, -0.251439, 0.068706>, <0.112337, -0.213224, 0.077409>, <0.106059, -0.193954, 0.084656>, 
      <0.127069, -0.260057, 0.066315>, <0.133539, -0.248406, 0.068706>, <0.122112, -0.210005, 0.077409>, <0.115834, -0.190735, 0.084656>, 
      <0.127069, -0.260057, 0.066315>, <0.133539, -0.248406, 0.068706>, <0.128687, -0.209150, 0.067627>, <0.126356, -0.187270, 0.071305>, 
      <0.127069, -0.260057, 0.066315>, <0.136278, -0.257024, 0.066315>, <0.132852, -0.207778, 0.058316>, <0.130521, -0.185898, 0.061995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121419, -0.023135, 0.002993>, <0.126624, -0.071039, 0.003759>, <0.139027, -0.134519, 0.003855>, <0.140659, -0.182559, 0.007313>, 
      <0.121419, -0.023135, 0.034203>, <0.126624, -0.071039, 0.034970>, <0.139027, -0.134519, 0.020570>, <0.140659, -0.182559, 0.024027>, 
      <0.115120, -0.025210, 0.076865>, <0.123053, -0.072072, 0.063299>, <0.132120, -0.135194, 0.055024>, <0.137285, -0.183670, 0.046874>, 
      <0.102489, -0.029369, 0.105100>, <0.110422, -0.076232, 0.091534>, <0.125356, -0.137422, 0.070145>, <0.130521, -0.185898, 0.061995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102489, -0.029369, -0.099113>, <0.110472, -0.076524, -0.083965>, <0.125368, -0.137635, -0.060056>, <0.130521, -0.185898, -0.047368>, 
      <0.115120, -0.025210, -0.070878>, <0.123103, -0.072365, -0.055730>, <0.132132, -0.135408, -0.044935>, <0.137285, -0.183670, -0.032247>, 
      <0.121419, -0.023135, -0.028217>, <0.126624, -0.071039, -0.027451>, <0.139027, -0.134519, -0.012859>, <0.140659, -0.182559, -0.009401>, 
      <0.121419, -0.023135, 0.002993>, <0.126624, -0.071039, 0.003759>, <0.139027, -0.134519, 0.003855>, <0.140659, -0.182559, 0.007313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.056811, -0.044411, -0.141429>, <0.071049, -0.090062, -0.121353>, <0.091299, -0.149145, -0.091572>, <0.106059, -0.193954, -0.070030>, 
      <0.075064, -0.038400, -0.141429>, <0.089302, -0.084051, -0.121353>, <0.101074, -0.145926, -0.091572>, <0.115834, -0.190735, -0.070030>, 
      <0.094711, -0.031930, -0.116499>, <0.102694, -0.079086, -0.101350>, <0.121203, -0.139007, -0.069366>, <0.126356, -0.187270, -0.056679>, 
      <0.102489, -0.029369, -0.099113>, <0.110472, -0.076524, -0.083965>, <0.125368, -0.137635, -0.060056>, <0.130521, -0.185898, -0.047368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011134, -0.059454, -0.099113>, <0.030926, -0.103486, -0.085466>, <0.057058, -0.160133, -0.060056>, <0.081597, -0.202010, -0.047368>, 
      <0.018911, -0.056893, -0.116498>, <0.038704, -0.100925, -0.102851>, <0.061223, -0.158761, -0.069366>, <0.085762, -0.200639, -0.056679>, 
      <0.038558, -0.050422, -0.141429>, <0.052797, -0.096073, -0.121353>, <0.081523, -0.152364, -0.091572>, <0.096284, -0.197173, -0.070030>, 
      <0.056811, -0.044411, -0.141429>, <0.071049, -0.090062, -0.121353>, <0.091299, -0.149145, -0.091572>, <0.106059, -0.193954, -0.070030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.007797, -0.065688, 0.002993>, <0.013929, -0.108700, 0.003647>, <0.044828, -0.165334, 0.003841>, <0.071460, -0.205348, 0.007313>, 
      <-0.007797, -0.065688, -0.028217>, <0.013929, -0.108700, -0.027563>, <0.044828, -0.165334, -0.012873>, <0.071460, -0.205348, -0.009401>, 
      <-0.001497, -0.063614, -0.070878>, <0.018295, -0.107646, -0.057231>, <0.050294, -0.162360, -0.044935>, <0.074833, -0.204238, -0.032247>, 
      <0.011134, -0.059454, -0.099113>, <0.030926, -0.103486, -0.085466>, <0.057058, -0.160133, -0.060056>, <0.081597, -0.202010, -0.047368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011134, -0.059454, 0.105100>, <0.030771, -0.103141, 0.092898>, <0.057204, -0.159803, 0.070155>, <0.081597, -0.202010, 0.061995>, 
      <-0.001497, -0.063614, 0.076865>, <0.018140, -0.107301, 0.064663>, <0.050440, -0.162030, 0.055035>, <0.074833, -0.204238, 0.046874>, 
      <-0.007797, -0.065688, 0.034203>, <0.013929, -0.108700, 0.034857>, <0.044828, -0.165334, 0.020555>, <0.071460, -0.205348, 0.024027>, 
      <-0.007797, -0.065688, 0.002993>, <0.013929, -0.108700, 0.003647>, <0.044828, -0.165334, 0.003841>, <0.071460, -0.205348, 0.007313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.056811, -0.044411, 0.147416>, <0.070916, -0.089634, 0.128938>, <0.091227, -0.148431, 0.101777>, <0.106059, -0.193954, 0.084656>, 
      <0.038558, -0.050422, 0.147416>, <0.052663, -0.095645, 0.128938>, <0.081452, -0.151650, 0.101777>, <0.096284, -0.197173, 0.084656>, 
      <0.018911, -0.056893, 0.122485>, <0.038548, -0.100580, 0.110283>, <0.061369, -0.158431, 0.079466>, <0.085762, -0.200639, 0.071305>, 
      <0.011134, -0.059454, 0.105100>, <0.030771, -0.103141, 0.092898>, <0.057204, -0.159803, 0.070155>, <0.081597, -0.202010, 0.061995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.056811, -0.044411, 0.147416>, <0.075064, -0.038400, 0.147416>, <0.094712, -0.031930, 0.122486>, <0.102489, -0.029369, 0.105100>, 
      <0.070916, -0.089634, 0.128938>, <0.089169, -0.083623, 0.128938>, <0.102645, -0.078793, 0.108919>, <0.110422, -0.076232, 0.091534>, 
      <0.091227, -0.148431, 0.101777>, <0.101002, -0.145212, 0.101777>, <0.121191, -0.138793, 0.079456>, <0.125356, -0.137422, 0.070145>, 
      <0.106059, -0.193954, 0.084656>, <0.115834, -0.190735, 0.084656>, <0.126356, -0.187270, 0.071305>, <0.130521, -0.185898, 0.061995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.111319, 0.087492, 0.002993>, <0.114055, 0.054279, 0.002993>, <0.117820, 0.009992, 0.002463>, <0.121419, -0.023135, 0.002993>, 
      <0.111319, 0.087492, 0.045105>, <0.114055, 0.054279, 0.045105>, <0.117820, 0.009992, 0.033673>, <0.121419, -0.023135, 0.034203>, 
      <0.102380, 0.087066, 0.102669>, <0.106434, 0.051043, 0.097017>, <0.109232, 0.009575, 0.086934>, <0.115120, -0.025210, 0.076865>, 
      <0.084457, 0.086210, 0.140767>, <0.088511, 0.050187, 0.135115>, <0.096600, 0.005415, 0.115170>, <0.102489, -0.029369, 0.105100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.084457, 0.086210, -0.134780>, <0.088511, 0.050187, -0.129128>, <0.096651, 0.005116, -0.110191>, <0.102489, -0.029369, -0.099113>, 
      <0.102380, 0.087066, -0.096682>, <0.106434, 0.051043, -0.091031>, <0.109282, 0.009276, -0.081956>, <0.115120, -0.025210, -0.070878>, 
      <0.111319, 0.087492, -0.039119>, <0.114055, 0.054279, -0.039119>, <0.117820, 0.009992, -0.028747>, <0.121419, -0.023135, -0.028217>, 
      <0.111319, 0.087492, 0.002993>, <0.114055, 0.054279, 0.002993>, <0.117820, 0.009992, 0.002463>, <0.121419, -0.023135, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.019641, 0.083114, -0.191878>, <0.026865, 0.041924, -0.183620>, <0.045108, -0.006890, -0.157930>, <0.056811, -0.044411, -0.141429>, 
      <0.045542, 0.084351, -0.191878>, <0.052766, 0.043161, -0.183620>, <0.063361, -0.000879, -0.157930>, <0.075064, -0.038400, -0.141429>, 
      <0.073421, 0.085683, -0.158239>, <0.077474, 0.049660, -0.152587>, <0.088874, 0.002555, -0.127577>, <0.094711, -0.031930, -0.116499>, 
      <0.084457, 0.086210, -0.134780>, <0.088511, 0.050187, -0.129128>, <0.096651, 0.005116, -0.110191>, <0.102489, -0.029369, -0.099113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045174, 0.080019, -0.134780>, <-0.034983, 0.035152, -0.128980>, <-0.007162, -0.018751, -0.111728>, <0.011134, -0.059454, -0.099113>, 
      <-0.034138, 0.080546, -0.158238>, <-0.023946, 0.035679, -0.152439>, <0.000616, -0.016190, -0.129114>, <0.018911, -0.056893, -0.116498>, 
      <-0.006260, 0.081877, -0.191878>, <0.000964, 0.040687, -0.183620>, <0.026855, -0.012901, -0.157930>, <0.038558, -0.050422, -0.141429>, 
      <0.019641, 0.083114, -0.191878>, <0.026865, 0.041924, -0.183620>, <0.045108, -0.006890, -0.157930>, <0.056811, -0.044411, -0.141429>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.072036, 0.078736, 0.002993>, <-0.060707, 0.032689, 0.002993>, <-0.029175, -0.023365, 0.002349>, <-0.007797, -0.065688, 0.002993>, 
      <-0.072036, 0.078736, -0.039119>, <-0.060707, 0.032689, -0.039119>, <-0.029175, -0.023365, -0.028861>, <-0.007797, -0.065688, -0.028217>, 
      <-0.063097, 0.079163, -0.096682>, <-0.052906, 0.034296, -0.090883>, <-0.019793, -0.022911, -0.083493>, <-0.001497, -0.063614, -0.070878>, 
      <-0.045174, 0.080019, -0.134780>, <-0.034983, 0.035152, -0.128980>, <-0.007162, -0.018751, -0.111728>, <0.011134, -0.059454, -0.099113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045174, 0.080019, 0.140767>, <-0.034983, 0.035152, 0.134967>, <-0.007290, -0.018465, 0.116548>, <0.011134, -0.059454, 0.105100>, 
      <-0.063097, 0.079163, 0.102669>, <-0.052906, 0.034296, 0.096869>, <-0.019922, -0.022625, 0.088313>, <-0.001497, -0.063614, 0.076865>, 
      <-0.072036, 0.078736, 0.045105>, <-0.060707, 0.032689, 0.045105>, <-0.029175, -0.023365, 0.033560>, <-0.007797, -0.065688, 0.034203>, 
      <-0.072036, 0.078736, 0.002993>, <-0.060707, 0.032689, 0.002993>, <-0.029175, -0.023365, 0.002349>, <-0.007797, -0.065688, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.019641, 0.083114, 0.197864>, <0.026865, 0.041924, 0.189606>, <0.044986, -0.006500, 0.162906>, <0.056811, -0.044411, 0.147416>, 
      <-0.006259, 0.081877, 0.197864>, <0.000964, 0.040687, 0.189606>, <0.026734, -0.012511, 0.162906>, <0.038558, -0.050422, 0.147416>, 
      <-0.034138, 0.080546, 0.164225>, <-0.023947, 0.035679, 0.158426>, <0.000487, -0.015904, 0.133934>, <0.018911, -0.056893, 0.122485>, 
      <-0.045174, 0.080019, 0.140767>, <-0.034983, 0.035152, 0.134967>, <-0.007290, -0.018465, 0.116548>, <0.011134, -0.059454, 0.105100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.019641, 0.083114, 0.197864>, <0.045542, 0.084351, 0.197864>, <0.073421, 0.085683, 0.164225>, <0.084457, 0.086210, 0.140767>, 
      <0.026865, 0.041924, 0.189606>, <0.052765, 0.043161, 0.189606>, <0.077475, 0.049660, 0.158574>, <0.088511, 0.050187, 0.135115>, 
      <0.044986, -0.006500, 0.162906>, <0.063239, -0.000489, 0.162906>, <0.088823, 0.002854, 0.132555>, <0.096600, 0.005415, 0.115170>, 
      <0.056811, -0.044411, 0.147416>, <0.075064, -0.038400, 0.147416>, <0.094712, -0.031930, 0.122486>, <0.102489, -0.029369, 0.105100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103525, 0.194126, 0.002993>, <0.104108, 0.162056, 0.002993>, <0.108686, 0.119460, 0.002993>, <0.111319, 0.087492, 0.002993>, 
      <0.103525, 0.194126, 0.045105>, <0.104108, 0.162056, 0.045105>, <0.108686, 0.119460, 0.045105>, <0.111319, 0.087492, 0.045105>, 
      <0.094668, 0.195403, 0.102669>, <0.094947, 0.161842, 0.104319>, <0.098668, 0.120059, 0.107845>, <0.102380, 0.087066, 0.102669>, 
      <0.076908, 0.197963, 0.140767>, <0.077187, 0.164403, 0.142417>, <0.080744, 0.119203, 0.145943>, <0.084457, 0.086210, 0.140767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076908, 0.197963, -0.134780>, <0.077187, 0.164403, -0.136430>, <0.080744, 0.119203, -0.139956>, <0.084457, 0.086210, -0.134780>, 
      <0.094668, 0.195403, -0.096682>, <0.094947, 0.161842, -0.098332>, <0.098668, 0.120059, -0.101859>, <0.102380, 0.087066, -0.096682>, 
      <0.103525, 0.194126, -0.039119>, <0.104108, 0.162056, -0.039119>, <0.108686, 0.119460, -0.039119>, <0.111319, 0.087492, -0.039119>, 
      <0.103525, 0.194126, 0.002993>, <0.104108, 0.162056, 0.002993>, <0.108686, 0.119460, 0.002993>, <0.111319, 0.087492, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012682, 0.207221, -0.191878>, <0.012137, 0.170020, -0.194400>, <0.013322, 0.119149, -0.199102>, <0.019641, 0.083114, -0.191878>, 
      <0.038347, 0.203521, -0.191878>, <0.037802, 0.166320, -0.194400>, <0.039222, 0.120385, -0.199102>, <0.045542, 0.084351, -0.191878>, 
      <0.065972, 0.199539, -0.158239>, <0.066251, 0.165979, -0.159888>, <0.069708, 0.118676, -0.163415>, <0.073421, 0.085683, -0.158239>, 
      <0.076908, 0.197963, -0.134780>, <0.077187, 0.164403, -0.136430>, <0.080744, 0.119203, -0.139956>, <0.084457, 0.086210, -0.134780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.051543, 0.216479, -0.134780>, <-0.053035, 0.175568, -0.136693>, <-0.054180, 0.119670, -0.139905>, <-0.045174, 0.080019, -0.134780>, 
      <-0.040608, 0.214903, -0.158238>, <-0.042099, 0.173992, -0.160152>, <-0.043145, 0.120197, -0.163364>, <-0.034138, 0.080546, -0.158238>, 
      <-0.012983, 0.210921, -0.191878>, <-0.013527, 0.173720, -0.194400>, <-0.012579, 0.117912, -0.199102>, <-0.006260, 0.081877, -0.191878>, 
      <0.012682, 0.207221, -0.191878>, <0.012137, 0.170020, -0.194400>, <0.013322, 0.119149, -0.199102>, <0.019641, 0.083114, -0.191878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.078160, 0.220315, 0.002993>, <-0.080080, 0.177845, 0.002993>, <-0.082192, 0.120019, 0.002993>, <-0.072036, 0.078736, 0.002993>, 
      <-0.078160, 0.220315, -0.039119>, <-0.080080, 0.177845, -0.039119>, <-0.082192, 0.120019, -0.039119>, <-0.072036, 0.078736, -0.039119>, 
      <-0.069303, 0.219039, -0.096682>, <-0.070795, 0.178128, -0.098595>, <-0.072104, 0.118814, -0.101807>, <-0.063097, 0.079163, -0.096682>, 
      <-0.051543, 0.216479, -0.134780>, <-0.053035, 0.175568, -0.136693>, <-0.054180, 0.119670, -0.139905>, <-0.045174, 0.080019, -0.134780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.051543, 0.216479, 0.140767>, <-0.053035, 0.175568, 0.142680>, <-0.054180, 0.119670, 0.145892>, <-0.045174, 0.080019, 0.140767>, 
      <-0.069303, 0.219039, 0.102669>, <-0.070795, 0.178128, 0.104582>, <-0.072104, 0.118814, 0.107794>, <-0.063097, 0.079163, 0.102669>, 
      <-0.078160, 0.220315, 0.045105>, <-0.080080, 0.177845, 0.045105>, <-0.082192, 0.120019, 0.045105>, <-0.072036, 0.078736, 0.045105>, 
      <-0.078160, 0.220315, 0.002993>, <-0.080080, 0.177845, 0.002993>, <-0.082192, 0.120019, 0.002993>, <-0.072036, 0.078736, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012682, 0.207221, 0.197864>, <0.012137, 0.170020, 0.200386>, <0.013322, 0.119149, 0.205088>, <0.019641, 0.083114, 0.197864>, 
      <-0.012983, 0.210921, 0.197864>, <-0.013527, 0.173719, 0.200386>, <-0.012579, 0.117912, 0.205088>, <-0.006259, 0.081877, 0.197864>, 
      <-0.040608, 0.214903, 0.164225>, <-0.042100, 0.173992, 0.166139>, <-0.043145, 0.120197, 0.169350>, <-0.034138, 0.080546, 0.164225>, 
      <-0.051543, 0.216479, 0.140767>, <-0.053035, 0.175568, 0.142680>, <-0.054180, 0.119670, 0.145892>, <-0.045174, 0.080019, 0.140767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012682, 0.207221, 0.197864>, <0.038346, 0.203521, 0.197864>, <0.065972, 0.199539, 0.164225>, <0.076908, 0.197963, 0.140767>, 
      <0.012137, 0.170020, 0.200386>, <0.037802, 0.166320, 0.200386>, <0.066251, 0.165979, 0.165875>, <0.077187, 0.164403, 0.142417>, 
      <0.013322, 0.119149, 0.205088>, <0.039222, 0.120386, 0.205088>, <0.069708, 0.118676, 0.169402>, <0.080744, 0.119203, 0.145943>, 
      <0.019641, 0.083114, 0.197864>, <0.045542, 0.084351, 0.197864>, <0.073421, 0.085683, 0.164225>, <0.084457, 0.086210, 0.140767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.041779, 0.626189, 0.002305>, <0.041779, 0.636814, 0.002821>, <0.035687, 0.670297, 0.004705>, <0.041779, 0.661604, 0.004024>, 
      <0.041779, 0.623660, 0.020631>, <0.041779, 0.634284, 0.021147>, <0.035687, 0.667768, 0.023031>, <0.041779, 0.659075, 0.022350>, 
      <0.039147, 0.665250, 0.021183>, <0.039147, 0.675874, 0.021698>, <0.033664, 0.694734, 0.015979>, <0.039147, 0.700665, 0.022901>, 
      <0.034340, 0.681840, 0.027808>, <0.034340, 0.692465, 0.028323>, <0.028857, 0.711324, 0.022604>, <0.034340, 0.717255, 0.029526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.034340, 0.687836, -0.015632>, <0.034340, 0.698460, -0.015116>, <0.029236, 0.716024, -0.008006>, <0.034340, 0.723249, -0.013912>, 
      <0.039410, 0.669940, -0.010155>, <0.039410, 0.680564, -0.009639>, <0.034306, 0.698129, -0.002529>, <0.039410, 0.705354, -0.008436>, 
      <0.041779, 0.628840, -0.016903>, <0.041779, 0.639465, -0.016387>, <0.035687, 0.672948, -0.014502>, <0.041779, 0.664254, -0.015183>, 
      <0.041779, 0.626189, 0.002305>, <0.041779, 0.636814, 0.002821>, <0.035687, 0.670297, 0.004705>, <0.041779, 0.661604, 0.004024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.715810, -0.025121>, <0.016389, 0.726434, -0.024605>, <0.016389, 0.741970, -0.018156>, <0.016389, 0.751223, -0.023402>, 
      <0.026743, 0.716387, -0.025121>, <0.026743, 0.727011, -0.024605>, <0.026743, 0.742547, -0.018156>, <0.026743, 0.751799, -0.023402>, 
      <0.031628, 0.697407, -0.018561>, <0.031628, 0.708031, -0.018045>, <0.026524, 0.725595, -0.010935>, <0.031628, 0.732820, -0.016841>, 
      <0.034340, 0.687836, -0.015632>, <0.034340, 0.698460, -0.015116>, <0.029236, 0.716024, -0.008006>, <0.034340, 0.723249, -0.013912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001561, 0.685837, -0.015632>, <-0.001561, 0.696461, -0.015116>, <0.003730, 0.714349, -0.007789>, <-0.001561, 0.721251, -0.013912>, 
      <0.001278, 0.695861, -0.018700>, <0.001278, 0.706485, -0.018184>, <0.006570, 0.724373, -0.010856>, <0.001278, 0.731275, -0.016980>, 
      <0.005545, 0.715206, -0.025121>, <0.005545, 0.725830, -0.024605>, <0.005545, 0.741367, -0.018156>, <0.005545, 0.750620, -0.023402>, 
      <0.016389, 0.715810, -0.025121>, <0.016389, 0.726434, -0.024605>, <0.016389, 0.741970, -0.018156>, <0.016389, 0.751223, -0.023402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.009000, 0.626189, 0.002305>, <-0.009000, 0.636814, 0.002821>, <-0.002908, 0.670297, 0.004705>, <-0.009000, 0.661604, 0.004024>, 
      <-0.009000, 0.627913, -0.016435>, <-0.009000, 0.638538, -0.015919>, <-0.002908, 0.672021, -0.014034>, <-0.009000, 0.663328, -0.014715>, 
      <-0.006482, 0.668468, -0.010317>, <-0.006482, 0.679092, -0.009801>, <-0.001190, 0.696980, -0.002473>, <-0.006482, 0.703882, -0.008597>, 
      <-0.001561, 0.685837, -0.015632>, <-0.001561, 0.696461, -0.015116>, <0.003730, 0.714349, -0.007789>, <-0.001561, 0.721251, -0.013912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001561, 0.681840, 0.027808>, <-0.001561, 0.692465, 0.028323>, <0.003921, 0.711324, 0.022604>, <-0.001561, 0.717255, 0.029526>, 
      <-0.006368, 0.665250, 0.021183>, <-0.006368, 0.675874, 0.021698>, <-0.000886, 0.694734, 0.015979>, <-0.006369, 0.700665, 0.022901>, 
      <-0.009000, 0.624494, 0.020727>, <-0.009000, 0.635119, 0.021243>, <-0.002908, 0.668602, 0.023127>, <-0.009000, 0.659909, 0.022446>, 
      <-0.009000, 0.626189, 0.002305>, <-0.009000, 0.636814, 0.002821>, <-0.002908, 0.670297, 0.004705>, <-0.009000, 0.661604, 0.004024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.713812, 0.037297>, <0.016389, 0.724436, 0.037813>, <0.016389, 0.740209, 0.033374>, <0.016389, 0.749225, 0.039016>, 
      <0.005026, 0.713812, 0.037297>, <0.005026, 0.724436, 0.037813>, <0.005027, 0.740209, 0.033374>, <0.005027, 0.749225, 0.039016>, 
      <0.001391, 0.692029, 0.031877>, <0.001391, 0.702654, 0.032392>, <0.006874, 0.721513, 0.026673>, <0.001391, 0.727444, 0.033595>, 
      <-0.001561, 0.681840, 0.027808>, <-0.001561, 0.692465, 0.028323>, <0.003921, 0.711324, 0.022604>, <-0.001561, 0.717255, 0.029526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.713812, 0.037297>, <0.027751, 0.713812, 0.037297>, <0.031387, 0.692030, 0.031877>, <0.034340, 0.681840, 0.027808>, 
      <0.016389, 0.724436, 0.037813>, <0.027751, 0.724436, 0.037813>, <0.031387, 0.702654, 0.032393>, <0.034340, 0.692465, 0.028323>, 
      <0.016389, 0.740209, 0.033374>, <0.027751, 0.740209, 0.033374>, <0.025905, 0.721514, 0.026673>, <0.028857, 0.711324, 0.022604>, 
      <0.016389, 0.749225, 0.039016>, <0.027751, 0.749225, 0.039016>, <0.031387, 0.727444, 0.033595>, <0.034340, 0.717255, 0.029526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051004, 0.613025, 0.001274>, <0.051004, 0.609577, 0.026259>, <0.047416, 0.666277, 0.027009>, <0.040862, 0.688895, 0.036042>, 
      <0.048764, 0.627710, 0.001516>, <0.048764, 0.624262, 0.026501>, <0.046629, 0.674661, 0.023988>, <0.040075, 0.697279, 0.033021>, 
      <0.050288, 0.649462, 0.003073>, <0.050288, 0.646933, 0.021399>, <0.043758, 0.705653, 0.028722>, <0.038951, 0.722243, 0.035348>, 
      <0.041779, 0.661604, 0.004024>, <0.041779, 0.659075, 0.022350>, <0.039147, 0.700665, 0.022901>, <0.034340, 0.717255, 0.029526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.040862, 0.697068, -0.023179>, <0.047774, 0.672670, -0.015713>, <0.051004, 0.616639, -0.024912>, <0.051004, 0.613025, 0.001274>, 
      <0.040190, 0.704830, -0.019637>, <0.047102, 0.680433, -0.012171>, <0.048764, 0.631324, -0.024670>, <0.048764, 0.627710, 0.001516>, 
      <0.038447, 0.729062, -0.018664>, <0.043517, 0.711167, -0.013188>, <0.050288, 0.652112, -0.016134>, <0.050288, 0.649462, 0.003073>, 
      <0.034340, 0.723249, -0.013912>, <0.039410, 0.705354, -0.008436>, <0.041779, 0.664254, -0.015183>, <0.041779, 0.661604, 0.004024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.735205, -0.036117>, <0.030504, 0.735991, -0.036117>, <0.037165, 0.710116, -0.027172>, <0.040862, 0.697068, -0.023179>, 
      <0.016389, 0.740797, -0.033593>, <0.030504, 0.741583, -0.033593>, <0.036493, 0.717878, -0.023631>, <0.040190, 0.704830, -0.019637>, 
      <0.016389, 0.756560, -0.026428>, <0.026743, 0.757136, -0.026428>, <0.035735, 0.738634, -0.021593>, <0.038447, 0.729062, -0.018664>, 
      <0.016389, 0.751223, -0.023402>, <0.026743, 0.751799, -0.023402>, <0.031628, 0.732820, -0.016841>, <0.034340, 0.723249, -0.013912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008083, 0.694344, -0.023179>, <-0.004212, 0.708010, -0.027361>, <0.001605, 0.734382, -0.036117>, <0.016389, 0.735205, -0.036117>, 
      <-0.007381, 0.702251, -0.019477>, <-0.003509, 0.715916, -0.023659>, <0.001605, 0.739975, -0.033593>, <0.016389, 0.740797, -0.033593>, 
      <-0.005919, 0.726935, -0.018954>, <-0.003079, 0.736959, -0.022022>, <0.005545, 0.755957, -0.026428>, <0.016389, 0.756560, -0.026428>, 
      <-0.001561, 0.721251, -0.013912>, <0.001278, 0.731275, -0.016980>, <0.005545, 0.750620, -0.023402>, <0.016389, 0.751223, -0.023402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.018225, 0.613025, 0.001274>, <-0.018225, 0.615376, -0.024274>, <-0.014792, 0.670665, -0.015932>, <-0.008083, 0.694344, -0.023179>, 
      <-0.015986, 0.627710, 0.001516>, <-0.015986, 0.630061, -0.024032>, <-0.014089, 0.678571, -0.012230>, <-0.007381, 0.702251, -0.019477>, 
      <-0.017509, 0.649462, 0.003073>, <-0.017509, 0.651186, -0.015666>, <-0.010839, 0.709566, -0.013639>, <-0.005919, 0.726935, -0.018954>, 
      <-0.009000, 0.661604, 0.004024>, <-0.009000, 0.663328, -0.014715>, <-0.006482, 0.703882, -0.008597>, <-0.001561, 0.721251, -0.013912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008083, 0.688895, 0.036042>, <-0.014637, 0.666277, 0.027009>, <-0.018225, 0.610714, 0.026389>, <-0.018225, 0.613025, 0.001274>, 
      <-0.007297, 0.697279, 0.033021>, <-0.013851, 0.674661, 0.023988>, <-0.015986, 0.625399, 0.026631>, <-0.015986, 0.627710, 0.001516>, 
      <-0.006173, 0.722243, 0.035348>, <-0.010980, 0.705653, 0.028722>, <-0.017509, 0.647767, 0.021495>, <-0.017509, 0.649462, 0.003073>, 
      <-0.001561, 0.717255, 0.029526>, <-0.006369, 0.700665, 0.022901>, <-0.009000, 0.659909, 0.022446>, <-0.009000, 0.661604, 0.004024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.732481, 0.048980>, <0.000899, 0.732481, 0.048980>, <-0.004058, 0.702786, 0.041590>, <-0.008083, 0.688895, 0.036042>, 
      <0.016389, 0.737968, 0.046965>, <0.000899, 0.737968, 0.046965>, <-0.003272, 0.711170, 0.038569>, <-0.007297, 0.697279, 0.033021>, 
      <0.016389, 0.754180, 0.042117>, <0.005027, 0.754180, 0.042117>, <-0.003220, 0.732432, 0.039417>, <-0.006173, 0.722243, 0.035348>, 
      <0.016389, 0.749225, 0.039016>, <0.005027, 0.749225, 0.039016>, <0.001391, 0.727444, 0.033595>, <-0.001561, 0.717255, 0.029526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.732481, 0.048980>, <0.016389, 0.737968, 0.046965>, <0.016389, 0.754180, 0.042117>, <0.016389, 0.749225, 0.039016>, 
      <0.031879, 0.732481, 0.048980>, <0.031879, 0.737968, 0.046965>, <0.027751, 0.754180, 0.042117>, <0.027751, 0.749225, 0.039016>, 
      <0.036836, 0.702786, 0.041590>, <0.036050, 0.711170, 0.038569>, <0.035998, 0.732432, 0.039417>, <0.031387, 0.727444, 0.033595>, 
      <0.040862, 0.688895, 0.036042>, <0.040075, 0.697279, 0.033021>, <0.038951, 0.722243, 0.035348>, <0.034340, 0.717255, 0.029526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051310, 0.599100, 0.002993>, <0.051310, 0.599100, 0.024200>, <0.048945, 0.634977, 0.038709>, <0.041078, 0.645410, 0.055412>, 
      <0.050217, 0.603165, 0.002925>, <0.050217, 0.603165, 0.024132>, <0.046090, 0.648355, 0.034606>, <0.038223, 0.658788, 0.051309>, 
      <0.051638, 0.608864, 0.001205>, <0.051638, 0.605415, 0.026190>, <0.048671, 0.652893, 0.031832>, <0.042117, 0.675511, 0.040864>, 
      <0.051004, 0.613025, 0.001274>, <0.051004, 0.609577, 0.026259>, <0.047416, 0.666277, 0.027009>, <0.040862, 0.688895, 0.036042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.041078, 0.645410, -0.049426>, <0.048945, 0.634977, -0.032723>, <0.051310, 0.599100, -0.018214>, <0.051310, 0.599100, 0.002993>, 
      <0.039571, 0.661857, -0.044005>, <0.047439, 0.651425, -0.027302>, <0.050217, 0.603165, -0.018282>, <0.050217, 0.603165, 0.002925>, 
      <0.042227, 0.681302, -0.030372>, <0.049139, 0.656904, -0.022906>, <0.051638, 0.612477, -0.024981>, <0.051638, 0.608864, 0.001205>, 
      <0.040862, 0.697068, -0.023179>, <0.047774, 0.672670, -0.015713>, <0.051004, 0.616639, -0.024912>, <0.051004, 0.613025, 0.001274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.645410, -0.071150>, <0.026255, 0.645410, -0.071150>, <0.037418, 0.650264, -0.057197>, <0.041078, 0.645410, -0.049426>, 
      <0.016389, 0.672446, -0.060893>, <0.026255, 0.672446, -0.060893>, <0.035911, 0.666711, -0.051776>, <0.039571, 0.661857, -0.044005>, 
      <0.016389, 0.708848, -0.048010>, <0.030504, 0.709634, -0.048010>, <0.038530, 0.694350, -0.034365>, <0.042227, 0.681302, -0.030372>, 
      <0.016389, 0.735205, -0.036117>, <0.030504, 0.735991, -0.036117>, <0.037165, 0.710116, -0.027172>, <0.040862, 0.697068, -0.023179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008299, 0.645410, -0.049426>, <-0.004640, 0.650263, -0.057196>, <0.006523, 0.645410, -0.071150>, <0.016389, 0.645410, -0.071150>, 
      <-0.006837, 0.661148, -0.044164>, <-0.003177, 0.666002, -0.051934>, <0.006523, 0.672446, -0.060893>, <0.016389, 0.672446, -0.060893>, 
      <-0.009419, 0.679306, -0.030221>, <-0.005548, 0.692972, -0.034403>, <0.001605, 0.708025, -0.048010>, <0.016389, 0.708848, -0.048010>, 
      <-0.008083, 0.694344, -0.023179>, <-0.004212, 0.708010, -0.027361>, <0.001605, 0.734382, -0.036117>, <0.016389, 0.735205, -0.036117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.018531, 0.599100, 0.002993>, <-0.018531, 0.599100, -0.018214>, <-0.016166, 0.634977, -0.032723>, <-0.008299, 0.645410, -0.049426>, 
      <-0.017479, 0.603176, 0.002927>, <-0.017479, 0.603176, -0.018280>, <-0.014704, 0.650715, -0.027460>, <-0.006837, 0.661148, -0.044164>, 
      <-0.018860, 0.608864, 0.001205>, <-0.018860, 0.611214, -0.024343>, <-0.016128, 0.655627, -0.022974>, <-0.009419, 0.679306, -0.030221>, 
      <-0.018225, 0.613025, 0.001274>, <-0.018225, 0.615376, -0.024274>, <-0.014792, 0.670665, -0.015932>, <-0.008083, 0.694344, -0.023179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008299, 0.645410, 0.055412>, <-0.016166, 0.634977, 0.038709>, <-0.018531, 0.599100, 0.024200>, <-0.018531, 0.599100, 0.002993>, 
      <-0.005194, 0.658737, 0.051325>, <-0.013061, 0.648304, 0.034621>, <-0.017479, 0.603176, 0.024134>, <-0.017479, 0.603176, 0.002927>, 
      <-0.009338, 0.675511, 0.040864>, <-0.015892, 0.652893, 0.031831>, <-0.018860, 0.606553, 0.026321>, <-0.018860, 0.608864, 0.001205>, 
      <-0.008083, 0.688895, 0.036042>, <-0.014637, 0.666277, 0.027009>, <-0.018225, 0.610714, 0.026389>, <-0.018225, 0.613025, 0.001274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.645410, 0.077136>, <0.006523, 0.645410, 0.077136>, <-0.004640, 0.650263, 0.063182>, <-0.008299, 0.645410, 0.055412>, 
      <0.016786, 0.670525, 0.066056>, <0.006921, 0.670525, 0.066056>, <-0.001534, 0.663590, 0.059095>, <-0.005194, 0.658737, 0.051325>, 
      <0.016389, 0.706710, 0.058443>, <0.000899, 0.706710, 0.058443>, <-0.005313, 0.689402, 0.046412>, <-0.009338, 0.675511, 0.040864>, 
      <0.016389, 0.732481, 0.048980>, <0.000899, 0.732481, 0.048980>, <-0.004058, 0.702786, 0.041590>, <-0.008083, 0.688895, 0.036042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.645410, 0.077136>, <0.016786, 0.670525, 0.066056>, <0.016389, 0.706710, 0.058443>, <0.016389, 0.732481, 0.048980>, 
      <0.026255, 0.645410, 0.077136>, <0.026652, 0.670525, 0.066056>, <0.031879, 0.706710, 0.058443>, <0.031879, 0.732481, 0.048980>, 
      <0.037418, 0.650264, 0.063183>, <0.034563, 0.663642, 0.059080>, <0.038092, 0.689402, 0.046412>, <0.036836, 0.702786, 0.041590>, 
      <0.041078, 0.645410, 0.055412>, <0.038223, 0.658788, 0.051309>, <0.042117, 0.675511, 0.040864>, <0.040862, 0.688895, 0.036042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.078581, 0.510418, 0.002993>, <0.081786, 0.510418, 0.029552>, <0.090834, 0.506942, 0.067682>, <0.079837, 0.506244, 0.092059>, 
      <0.072525, 0.537586, 0.002993>, <0.075731, 0.537586, 0.029552>, <0.084782, 0.549949, 0.057059>, <0.073784, 0.549252, 0.081436>, 
      <0.058533, 0.572223, 0.003443>, <0.058533, 0.572223, 0.024650>, <0.057882, 0.593094, 0.051554>, <0.050015, 0.603526, 0.068257>, 
      <0.051310, 0.599100, 0.002993>, <0.051310, 0.599100, 0.024200>, <0.048945, 0.634977, 0.038709>, <0.041078, 0.645410, 0.055412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.058339, 0.506244, -0.086073>, <0.070476, 0.507059, -0.061488>, <0.075294, 0.510418, -0.024239>, <0.078581, 0.510418, 0.002993>, 
      <0.052453, 0.548069, -0.075742>, <0.064590, 0.548884, -0.051157>, <0.069239, 0.537586, -0.024239>, <0.072525, 0.537586, 0.002993>, 
      <0.044846, 0.604268, -0.062986>, <0.052713, 0.593835, -0.046283>, <0.058533, 0.572223, -0.017764>, <0.058533, 0.572223, 0.003443>, 
      <0.041078, 0.645410, -0.049426>, <0.048945, 0.634977, -0.032723>, <0.051310, 0.599100, -0.018214>, <0.051310, 0.599100, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016389, 0.506244, -0.122984>, <0.033152, 0.506244, -0.122984>, <0.050922, 0.505746, -0.101098>, <0.058339, 0.506244, -0.086073>, 
      <0.015334, 0.548232, -0.108125>, <0.032097, 0.548232, -0.108125>, <0.045035, 0.547572, -0.090767>, <0.052453, 0.548069, -0.075742>, 
      <0.016389, 0.603756, -0.086954>, <0.026255, 0.603756, -0.086954>, <0.041186, 0.609122, -0.070757>, <0.044846, 0.604268, -0.062986>, 
      <0.016389, 0.645410, -0.071150>, <0.026255, 0.645410, -0.071150>, <0.037418, 0.650264, -0.057197>, <0.041078, 0.645410, -0.049426>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025560, 0.506244, -0.086073>, <-0.018140, 0.506244, -0.101104>, <-0.000374, 0.506244, -0.122984>, <0.016389, 0.506244, -0.122984>, 
      <-0.021635, 0.548222, -0.075433>, <-0.014215, 0.548222, -0.090464>, <-0.001429, 0.548232, -0.108125>, <0.015334, 0.548232, -0.108125>, 
      <-0.012116, 0.604331, -0.063161>, <-0.008456, 0.609184, -0.070932>, <0.006523, 0.603756, -0.086954>, <0.016389, 0.603756, -0.086954>, 
      <-0.008299, 0.645410, -0.049426>, <-0.004640, 0.650263, -0.057196>, <0.006523, 0.645410, -0.071150>, <0.016389, 0.645410, -0.071150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045801, 0.506244, 0.002993>, <-0.041981, 0.506244, -0.024140>, <-0.037690, 0.506244, -0.061503>, <-0.025560, 0.506244, -0.086073>, 
      <-0.040890, 0.534859, 0.002993>, <-0.037070, 0.534859, -0.024140>, <-0.033764, 0.548222, -0.050863>, <-0.021635, 0.548222, -0.075433>, 
      <-0.025790, 0.570992, 0.003446>, <-0.025790, 0.570992, -0.017762>, <-0.019983, 0.593898, -0.046458>, <-0.012116, 0.604331, -0.063161>, 
      <-0.018531, 0.599100, 0.002993>, <-0.018531, 0.599100, -0.018214>, <-0.016166, 0.634977, -0.032723>, <-0.008299, 0.645410, -0.049426>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.050641, 0.506244, 0.092059>, <-0.060622, 0.506244, 0.067231>, <-0.049532, 0.506244, 0.029491>, <-0.045801, 0.506244, 0.002993>, 
      <-0.046579, 0.549689, 0.081047>, <-0.056559, 0.549689, 0.056218>, <-0.044621, 0.534859, 0.029491>, <-0.040890, 0.534859, 0.002993>, 
      <-0.018084, 0.603414, 0.068292>, <-0.025951, 0.592981, 0.051588>, <-0.025790, 0.570992, 0.024653>, <-0.025790, 0.570992, 0.003446>, 
      <-0.008299, 0.645410, 0.055412>, <-0.016166, 0.634977, 0.038709>, <-0.018531, 0.599100, 0.024200>, <-0.018531, 0.599100, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012806, 0.506244, 0.148789>, <-0.012727, 0.506244, 0.148789>, <-0.041118, 0.506244, 0.115750>, <-0.050641, 0.506244, 0.092059>, 
      <0.011694, 0.550512, 0.133124>, <-0.013840, 0.550512, 0.133124>, <-0.037056, 0.549689, 0.104738>, <-0.046579, 0.549689, 0.081047>, 
      <0.015708, 0.602440, 0.096093>, <0.005843, 0.602440, 0.096093>, <-0.014425, 0.608268, 0.076062>, <-0.018084, 0.603414, 0.068292>, 
      <0.016389, 0.645410, 0.077136>, <0.006523, 0.645410, 0.077136>, <-0.004640, 0.650263, 0.063182>, <-0.008299, 0.645410, 0.055412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012806, 0.506244, 0.148789>, <0.011694, 0.550512, 0.133124>, <0.015708, 0.602440, 0.096093>, <0.016389, 0.645410, 0.077136>, 
      <0.039150, 0.506244, 0.148789>, <0.038038, 0.550512, 0.133124>, <0.025574, 0.602440, 0.096093>, <0.026255, 0.645410, 0.077136>, 
      <0.069007, 0.505557, 0.116065>, <0.062954, 0.548564, 0.105442>, <0.046355, 0.608380, 0.076028>, <0.037418, 0.650264, 0.063183>, 
      <0.079837, 0.506244, 0.092059>, <0.073784, 0.549252, 0.081436>, <0.050015, 0.603526, 0.068257>, <0.041078, 0.645410, 0.055412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106523, 0.351385, 0.002993>, <0.106523, 0.351385, 0.041097>, <0.098442, 0.351900, 0.093182>, <0.082239, 0.352932, 0.127654>, 
      <0.102714, 0.399676, 0.002993>, <0.102714, 0.399676, 0.041097>, <0.098885, 0.398541, 0.085813>, <0.082682, 0.399574, 0.120285>, 
      <0.089119, 0.463137, 0.002993>, <0.092324, 0.463137, 0.029552>, <0.097227, 0.461519, 0.078902>, <0.086229, 0.460821, 0.103278>, 
      <0.078581, 0.510418, 0.002993>, <0.081786, 0.510418, 0.029552>, <0.090834, 0.506942, 0.067682>, <0.079837, 0.506244, 0.092059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106523, 0.351385, 0.002993>, <0.110233, 0.304345, 0.002993>, <0.102667, 0.241305, 0.002993>, <0.103525, 0.194126, 0.002993>, 
      <0.106523, 0.351385, 0.041097>, <0.110233, 0.304345, 0.041097>, <0.102667, 0.241305, 0.045105>, <0.103525, 0.194126, 0.045105>, 
      <0.098442, 0.351900, 0.093182>, <0.098004, 0.305789, 0.100467>, <0.094280, 0.242029, 0.100377>, <0.094668, 0.195403, 0.102669>, 
      <0.082239, 0.352932, 0.127654>, <0.081801, 0.306822, 0.134939>, <0.076520, 0.244589, 0.138475>, <0.076908, 0.197963, 0.140767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.082239, 0.352932, -0.121668>, <0.098442, 0.351900, -0.087196>, <0.106523, 0.351385, -0.035111>, <0.106523, 0.351385, 0.002993>, 
      <0.079402, 0.400022, -0.114228>, <0.095605, 0.398989, -0.079756>, <0.102714, 0.399676, -0.035111>, <0.102714, 0.399676, 0.002993>, 
      <0.064804, 0.460306, -0.097420>, <0.076941, 0.461120, -0.072835>, <0.085833, 0.463137, -0.024239>, <0.089119, 0.463137, 0.002993>, 
      <0.058339, 0.506244, -0.086073>, <0.070476, 0.507059, -0.061488>, <0.075294, 0.510418, -0.024239>, <0.078581, 0.510418, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.082239, 0.352932, -0.121668>, <0.085011, 0.306901, -0.128941>, <0.076520, 0.244589, -0.132488>, <0.076908, 0.197963, -0.134780>, 
      <0.098442, 0.351900, -0.087196>, <0.101215, 0.305869, -0.094469>, <0.094280, 0.242029, -0.094390>, <0.094668, 0.195403, -0.096682>, 
      <0.106523, 0.351385, -0.035111>, <0.110233, 0.304345, -0.035111>, <0.102667, 0.241305, -0.039119>, <0.103525, 0.194126, -0.039119>, 
      <0.106523, 0.351385, 0.002993>, <0.110233, 0.304345, 0.002993>, <0.102667, 0.241305, 0.002993>, <0.103525, 0.194126, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023644, 0.356666, -0.173331>, <0.047058, 0.355174, -0.173331>, <0.072262, 0.353568, -0.142894>, <0.082239, 0.352932, -0.121668>, 
      <0.024216, 0.402850, -0.162690>, <0.047631, 0.401358, -0.162690>, <0.069425, 0.400658, -0.135454>, <0.079402, 0.400022, -0.114228>, 
      <0.017511, 0.461575, -0.138792>, <0.034274, 0.461575, -0.138792>, <0.057386, 0.459808, -0.112444>, <0.064804, 0.460306, -0.097420>, 
      <0.016389, 0.506244, -0.122984>, <0.033152, 0.506244, -0.122984>, <0.050922, 0.505746, -0.101098>, <0.058339, 0.506244, -0.086073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023644, 0.356666, -0.173331>, <0.023097, 0.312529, -0.183500>, <0.013343, 0.252409, -0.188814>, <0.012682, 0.207221, -0.191878>, 
      <0.047058, 0.355174, -0.173331>, <0.046511, 0.311037, -0.183500>, <0.039008, 0.248710, -0.188814>, <0.038347, 0.203521, -0.191878>, 
      <0.072262, 0.353568, -0.142894>, <0.075034, 0.307537, -0.150166>, <0.065584, 0.246166, -0.155946>, <0.065972, 0.199539, -0.158239>, 
      <0.082239, 0.352932, -0.121668>, <0.085011, 0.306901, -0.128941>, <0.076520, 0.244589, -0.132488>, <0.076908, 0.197963, -0.134780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034950, 0.360399, -0.121668>, <-0.024974, 0.359763, -0.142894>, <0.000229, 0.358158, -0.173331>, <0.023644, 0.356666, -0.173331>, 
      <-0.030975, 0.404728, -0.114217>, <-0.020999, 0.404092, -0.135442>, <0.000802, 0.404342, -0.162690>, <0.024216, 0.402850, -0.162690>, 
      <-0.029634, 0.462680, -0.097115>, <-0.022214, 0.462680, -0.112146>, <0.000748, 0.461575, -0.138792>, <0.017511, 0.461575, -0.138792>, 
      <-0.025560, 0.506244, -0.086073>, <-0.018140, 0.506244, -0.101104>, <-0.000374, 0.506244, -0.122984>, <0.016389, 0.506244, -0.122984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034950, 0.360399, -0.121668>, <-0.038794, 0.317530, -0.128874>, <-0.049955, 0.260042, -0.132743>, <-0.051543, 0.216479, -0.134780>, 
      <-0.024974, 0.359763, -0.142894>, <-0.028818, 0.316895, -0.150099>, <-0.039019, 0.258466, -0.156201>, <-0.040608, 0.214903, -0.158238>, 
      <0.000229, 0.358158, -0.173331>, <-0.000318, 0.314021, -0.183500>, <-0.012322, 0.256109, -0.188814>, <-0.012983, 0.210921, -0.191878>, 
      <0.023644, 0.356666, -0.173331>, <0.023097, 0.312529, -0.183500>, <0.013343, 0.252409, -0.188814>, <0.012682, 0.207221, -0.191878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.059234, 0.361946, 0.002993>, <-0.064055, 0.319351, 0.002993>, <-0.076225, 0.263138, 0.002993>, <-0.078160, 0.220315, 0.002993>, 
      <-0.059234, 0.361946, -0.035111>, <-0.064055, 0.319351, -0.035111>, <-0.076225, 0.263138, -0.039119>, <-0.078160, 0.220315, -0.039119>, 
      <-0.051153, 0.361431, -0.087196>, <-0.054997, 0.318563, -0.094402>, <-0.067715, 0.262602, -0.094645>, <-0.069303, 0.219039, -0.096682>, 
      <-0.034950, 0.360399, -0.121668>, <-0.038794, 0.317530, -0.128874>, <-0.049955, 0.260042, -0.132743>, <-0.051543, 0.216479, -0.134780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.059234, 0.361946, 0.002993>, <-0.059234, 0.361946, -0.035111>, <-0.051153, 0.361431, -0.087196>, <-0.034950, 0.360399, -0.121668>, 
      <-0.054345, 0.405147, 0.002993>, <-0.054345, 0.405147, -0.035111>, <-0.047178, 0.405760, -0.079745>, <-0.030975, 0.404728, -0.114217>, 
      <-0.053156, 0.463394, 0.002993>, <-0.049335, 0.463394, -0.024140>, <-0.041763, 0.462680, -0.072545>, <-0.029634, 0.462680, -0.097115>, 
      <-0.045801, 0.506244, 0.002993>, <-0.041981, 0.506244, -0.024140>, <-0.037690, 0.506244, -0.061503>, <-0.025560, 0.506244, -0.086073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034950, 0.360399, 0.127654>, <-0.035084, 0.317363, 0.134888>, <-0.049955, 0.260042, 0.138730>, <-0.051543, 0.216479, 0.140767>, 
      <-0.051153, 0.361431, 0.093182>, <-0.051287, 0.318396, 0.100416>, <-0.067715, 0.262602, 0.100632>, <-0.069303, 0.219039, 0.102669>, 
      <-0.059234, 0.361946, 0.041097>, <-0.064055, 0.319351, 0.041097>, <-0.076225, 0.263138, 0.045105>, <-0.078160, 0.220315, 0.045105>, 
      <-0.059234, 0.361946, 0.002993>, <-0.064055, 0.319351, 0.002993>, <-0.076225, 0.263138, 0.002993>, <-0.078160, 0.220315, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034950, 0.360399, 0.127654>, <-0.051153, 0.361431, 0.093182>, <-0.059234, 0.361946, 0.041097>, <-0.059234, 0.361946, 0.002993>, 
      <-0.034811, 0.405055, 0.120148>, <-0.051014, 0.406088, 0.085676>, <-0.054345, 0.405147, 0.041097>, <-0.054345, 0.405147, 0.002993>, 
      <-0.054729, 0.462528, 0.103140>, <-0.064710, 0.462528, 0.078311>, <-0.056887, 0.463394, 0.029491>, <-0.053156, 0.463394, 0.002993>, 
      <-0.050641, 0.506244, 0.092059>, <-0.060622, 0.506244, 0.067231>, <-0.049532, 0.506244, 0.029491>, <-0.045801, 0.506244, 0.002993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023644, 0.356666, 0.179317>, <0.023625, 0.311967, 0.186653>, <0.013343, 0.252409, 0.194800>, <0.012682, 0.207221, 0.197864>, 
      <0.000229, 0.358158, 0.179317>, <0.000211, 0.313459, 0.186653>, <-0.012322, 0.256109, 0.194800>, <-0.012983, 0.210921, 0.197864>, 
      <-0.024974, 0.359763, 0.148880>, <-0.025108, 0.316728, 0.156114>, <-0.039019, 0.258466, 0.162188>, <-0.040608, 0.214903, 0.164225>, 
      <-0.034950, 0.360399, 0.127654>, <-0.035084, 0.317363, 0.134888>, <-0.049955, 0.260042, 0.138730>, <-0.051543, 0.216479, 0.140767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023644, 0.356666, 0.179317>, <0.000229, 0.358158, 0.179317>, <-0.024974, 0.359763, 0.148880>, <-0.034950, 0.360399, 0.127654>, 
      <0.023663, 0.401974, 0.171881>, <0.000248, 0.403466, 0.171881>, <-0.024835, 0.404420, 0.141373>, <-0.034811, 0.405055, 0.120148>, 
      <0.013893, 0.462973, 0.164102>, <-0.011640, 0.462973, 0.164102>, <-0.045206, 0.462528, 0.126830>, <-0.054729, 0.462528, 0.103140>, 
      <0.012806, 0.506244, 0.148789>, <-0.012727, 0.506244, 0.148789>, <-0.041118, 0.506244, 0.115750>, <-0.050641, 0.506244, 0.092059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023644, 0.356666, 0.179317>, <0.023663, 0.401974, 0.171881>, <0.013893, 0.462973, 0.164102>, <0.012806, 0.506244, 0.148789>, 
      <0.047058, 0.355174, 0.179317>, <0.047077, 0.400482, 0.171881>, <0.040237, 0.462973, 0.164102>, <0.039150, 0.506244, 0.148789>, 
      <0.072262, 0.353568, 0.148880>, <0.072705, 0.400210, 0.141510>, <0.075399, 0.460134, 0.127284>, <0.069007, 0.505557, 0.116065>, 
      <0.082239, 0.352932, 0.127654>, <0.082682, 0.399574, 0.120285>, <0.086229, 0.460821, 0.103278>, <0.079837, 0.506244, 0.092059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023644, 0.356666, 0.179317>, <0.047058, 0.355174, 0.179317>, <0.072262, 0.353568, 0.148880>, <0.082239, 0.352932, 0.127654>, 
      <0.023625, 0.311967, 0.186653>, <0.047040, 0.310475, 0.186653>, <0.071824, 0.307457, 0.156165>, <0.081801, 0.306822, 0.134939>, 
      <0.013343, 0.252409, 0.194800>, <0.039008, 0.248710, 0.194800>, <0.065584, 0.246166, 0.161933>, <0.076520, 0.244589, 0.138475>, 
      <0.012682, 0.207221, 0.197864>, <0.038346, 0.203521, 0.197864>, <0.065972, 0.199539, 0.164225>, <0.076908, 0.197963, 0.140767>
    }
  }
  texture {
    Scales
  }
}

#declare FishX = union {
  object { sPatchObj17 }
  object { sPatchObj18 }
  object { sPatchObj19 }
  object { sPatchObj20 }

  scale 10.0
  rotate -90.0*z
}

#declare fish = union { 
  sphere { 
    <0,0,0>,1
    texture {
      Eye
      rotate -75.0*z
    }
    scale 0.3
    translate  <5.4, -0.5, 0.8>
  }
  object { FishX }
  sphere { 
    <0,0,0>,1
    texture {
      Eye
      rotate 75.0*z
    }
    scale 0.3
    translate  <5.4, 0.2, 0.8>
  }
}
