#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "campod.inc"
#include "skies.inc"



 atmosphere {
   type 1
     samples 40        // Number of samples in first distance interval
       distance 9000       // Atmosphere density, similar to fog
       color rgbt<1,.91,.71,.9974>
         scattering 0.0000046    // Reflectivity of atmosphere, determines brightness
	   aa_level 8        // Level of binary subdivision in case of aa
	     aa_threshold 0.1  // Threshold for aa to push in
	       jitter 0.2        // Amount of sample jittering
	       }

global_settings {  max_trace_level 99650  }
object { campod
hollow
        translate <0,5,-10.96>
                scale 2
                hollow
                        }  
camera {
         location  <0,5,-10>
         up <0,1,0>
         look_at <0,5,3>
}


light_source { <-9000,100,1100> color White  atmospheric_attenuation on }
light_source { <-9000,100,-1100> color Cyan  atmospheric_attenuation on }

sky_sphere {  S_Cloud1   }

			
 
 #declare LandArea = texture { 
 	pigment { 
		agate 
		turbulence 1
		lambda .5 
		omega .74 
		octaves 15 
		color_map { 
			[0.00 color rgb <.5, .25, .15>] 
			[0.33 color rgb <.1, .5, .4>] 
			[0.86 color rgb <.6, .3, .1>] 
			[1.00 color rgb <.5, .25, .15>] 
		} 
	} 
} 

 #declare OceanArea = texture { 
 	pigment { 
		bozo 
		turbulence .22
		lambda .2 
		color_map { 
			[0.00, 0.33 color rgb <0, 0, 1> color rgb <0, 0, 1>] 
			[0.33, 0.66 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>] 
			[0.66, 1.00 color rgb <0, 0, 1> color rgb <0, 0, 1>] 
		} 
	} 
}

#declare world = union {
sphere {
	0,1 
	pigment { 
		rgbf .99991
	} 
	normal { dents  .35 turbulence .75 frequency 13 }
	finish {
		phong .2
		ior 1.6
		refraction 1
		caustics 1.6
		irid {
			  0.0125
			  thickness .00123
			  turbulence <.2,.02,.3>
		}
	}

	hollow 
		scale 2
}      
sphere {
	0,1
	texture { T_Cloud3  scale <1.2,.1,1> rotate z*15 }
scale .4
hollow
}
sphere {
	0,1
	texture { T_Cloud2  scale <5,2.9,4> rotate z*17 }
scale .39
hollow
}
sphere {
	0,1
	hollow
	texture { LandArea }
	texture { OceanArea }
	scale .38
}
}

object { world scale 4000 translate <1400,900,990> }
object { world scale 14000 translate <2400,-2900,99490> }
object { world scale 2000 translate <-1100,-10,1500> }
object { world scale 2 translate <10,-71,100> }
object { world scale 3 translate <10,-11,70> }
object { world scale 2 translate <-10,91,70> }
object { world scale 2.74 translate <-10,10,0>  rotate y*12 rotate x*12 rotate z*12  rotate y*12 rotate x*12 rotate z*12}
object { world scale 1.4 translate <10,-10,-1>  rotate y*12 rotate x*12 rotate z*12  rotate y*12 rotate x*12 rotate z*12}
object { world scale 1.74 translate <4,-5,1>  rotate y*12 rotate x*12 rotate z*12  rotate y*12 rotate x*12 rotate z*12}
object { world scale 1.74 translate <-20,0,0>  rotate y*12 rotate x*12 rotate z*12  rotate y*12 rotate x*12 rotate z*12}
object { world scale 1.74 translate <-1,30,29>  rotate y*12 rotate x*12 rotate z*12  rotate y*12 rotate x*12 rotate z*12}
object { world scale 1.74 translate <-6,10,50> }
object { world scale 1.4 translate <5,10,127>  rotate y*12 rotate x*12 rotate z*12 }
object { world scale 1.4 translate <5,-10,177>  rotate y*12 rotate x*12 rotate z*12 }
object { world scale 1.4 translate <-5,1,147>  rotate y*12 rotate x*12 rotate z*12 }
object { world scale 4 translate <-5,-10,-7> rotate y*12 rotate x*12 }
object { world scale 1 translate <5,-7,10> rotate y*12  }
object { world scale 4 translate <-1,2,10> }


