/*
   **********************************************
   Gilberto Ficara's IRTC Entry
   February 2002
   
   "World Construction Kit"
   
   
   http://velenux.oltrelinux.com
   <g.ficara@linuxpratico.com>
   
   **********************************************
*/


/* STANDARD INCLUDES */

#include "metals.inc"
#include "woods.inc"
#include "stones.inc"
#include "colors.inc"
#include "glass.inc"
#include "functions.inc"
#include "transforms.inc"


/* PERSONAL INCLUDES */

#include "myTextures.inc" // textures required elsewhere

#include "bacheca.inc"
#include "can.inc"
#include "colla.inc"
#include "foglio.inc"
#include "lampada.inc"
#include "matitinclude.inc"
#include "myRocks.inc"
#include "mySassi.inc"
#include "pen.inc"
#include "pennello.inc"
#include "post_it_01.inc"
#include "post_it_02.inc"
#include "sassinclude.inc"
#include "terrain.inc"
#include "vassoio.inc"



/*  Quality variables  */

#declare fast = 0;
#declare radio = 1;


/*  How many lights for each area light ?  */

#declare area_fast = 3;
#declare area_slow = 8;


/*  Global Settings  */

global_settings {

    #switch (radio)
    
        #case (0)
            // no radiosity
        #break
        
        #case (1)
            radiosity { 
                brightness 0.3
                recursion_limit 1
                max_sample 0.3
            }
        #break
        
    #end
    
    ambient_light <1,1,1>
    assumed_gamma 2.2
}

background { color rgb <0,0,0> }


//  Camera parameters

#declare camera_location = <9,3.5,-13>;
#declare camera_lookat = <1,2,1>;


//  My Camera

camera {
    location camera_location
    right x
    up 0.5*y
    look_at camera_lookat
}



//  Light parameters

#declare lamp_location = <-1,6,-2.5>;
#declare lamp_color = color rgb <1.5,1.3,1>;


/*  Lightsource #1: the Lamp  */

light_source {
    lamp_location, lamp_color

    area_light

    #if(fast=1)
        x*2, z*2, area_fast, area_fast
    #else
        x*2, z*2, area_slow, area_slow
    #end
        
    looks_like { myLamp  translate lamp_location scale 0.5 }

    adaptive 2.9
    jitter
    circular
    orient
}

/*  Lightsource #2: fill light 1  */

light_source {
    <0,3,-5>, color rgb <0.6,0.6,0.5>
    shadowless
}




/* 
   ******************************************************************
   ==================================================================
   <<                        the SCENE                             >>
   ==================================================================
   ******************************************************************
*/



/*  Parete posteriore  */

box {
    <-20,-21,0>, <20,30,1>
    texture { texMuro }
}

/*  Parete Sinistra  */

box {
    <-21,-21,1>, <-20,30,-50>
    texture { texMuro }
}


/*  Pavimento  */

box {
    <-20,-19,1>, <20,-20,-50>
    texture { texPavimento }
}


/*  Tavolo  */

box {
    <-10, -0.5, -0.1>, <12,0,-6>
    texture { texTavolo translate <-20,0,-2.5> }
}

/*  Bacheca  */

object {
    myBacheca
    scale 6
    translate <-2,0.5,-0.01>
}

/*  Post IT 1  */

object {
    myPIT01
    scale 0.8
    translate <1.8,3,-0.135>
    rotate z*5
}


/*  Post IT 2  */

object {
    myPIT02
    scale 0.8
    translate <2,1.9,-0.135>
    rotate z*-8
}


/*  Istruzioni  */

object {
    foglioIstruzioni
    scale 2.5
    translate <-1.1,1.5,-0.14>
}



/*  Plastico  */

object {
    myTerrain
    scale 3
    rotate y*15
    translate <-2,0,-4>
}



/*  Vernici  */

#declare verniceROSSA = picture_can("tx_paint_RED",<1,0,0>);
#declare verniceVERDE = picture_can("tx_paint_GREEN",<0.1,0.6,0.3>);
#declare verniceBLU = picture_can("tx_paint_BLUE",<0.1,0.2,0.6>);
#declare verniceNERA = picture_can("tx_paint_BLACK",<0.1,0.1,0.1>);
#declare verniceBIANCA = picture_can("tx_paint_WHITE",<0.9,0.9,0.9>);
#declare verniceGIALLA = picture_can("tx_paint_YELLOW",<1,0.9,0.2>);
#declare verniceAZZURRA = picture_can("tx_paint_AZURE",<0,0.55,1>);

#declare vernRotate = seed(20);

object {
    verniceROSSA
    rotate y*rand(vernRotate)*360
    translate <2.7,0,-2>
}

object {
    verniceGIALLA
    rotate y*rand(vernRotate)*360
    translate <3.2,0,-2.5>
}

object {
    verniceVERDE
    rotate y*rand(vernRotate)*360    
    translate <3.3,0,-1.7>
}

object {
    verniceBLU
    rotate y*rand(vernRotate)*360    
    translate <2.8,0,-2.4>
}

object {
    verniceNERA
    rotate y*rand(vernRotate)*360    
    translate <2.7,0,-1.6>
}

object {
    verniceBIANCA
    rotate y*rand(vernRotate)*360    
    translate <3,0,-2.1>
}

object {
    verniceAZZURRA
    rotate y*rand(vernRotate)*360    
    translate <3.5,0,-2.3>
}



/*  Pennelli  */


#declare myPennello = object { pennello rotate x*90 }

object {
    #include "scatter_brushes.inc"
    rotate y*130
    scale 0.4    
    translate <4,0,-1.8>
 
}


/*  Colla  */

object {
    barattoloColla
    rotate y*25
    scale 0.3
    translate <3.9,0,-3.3>
}


/*  Rocce  */

object {
    #include "scatter_rocce.inc"
    scale 0.17
    rotate y*55
    translate <-5.5,0,-4>
}


/*  Sassi  */

object {
    mySassi
    translate <-6,0,-1.8>
}


/*  Matite  */

object {
    myMatites
    rotate y*65
    translate <8.5,0,-4>
}



/*  Lampada  */

object { myLampadario scale 0.5 translate lamp_location }

