
//-------//-------//-------//-------//-------//-------//-------//
// meshcone.inc
//
// Macro for one "cone" made from triangles.
//
// By: Paul T. Dawson


//-------//-------//-------//-------//-------//-------//-------//
// Declare the macro.

#macro MeshCone ( BaseVector, LENGTH, DIAM1, DIAM2, TiltVector, Tex )

// If INCREMENT is lower, there will be more triangles!
        
        #local INCREMENT = 20;

// Go around the edges of the cone, do one section at a time.

        #local A = 0; #while ( A < 360 )

                // Starting locations.
                #local Corner1 = vrotate ( <DIAM1,0,0>, <0,A+INCREMENT,0> );
                #local Corner2 = vrotate ( <DIAM2,LENGTH,0>, <0,A+INCREMENT,0> );
                #local Corner3 = vrotate ( <DIAM2,LENGTH,0>, <0,A,0> );
                #local Corner4 = vrotate ( <DIAM1,0,0>, <0,A,0> );

                // Rotate everything.
                #local Corner1 = vrotate ( Corner1, TiltVector );
                #local Corner2 = vrotate ( Corner2, TiltVector );
                #local Corner3 = vrotate ( Corner3, TiltVector );
                #local Corner4 = vrotate ( Corner4, TiltVector );

                // Translate everything.
                #local Corner1 = Corner1 + BaseVector;
                #local Corner2 = Corner2 + BaseVector;
                #local Corner3 = Corner3 + BaseVector;
                #local Corner4 = Corner4 + BaseVector;

                // Make the triangles.
                triangle { Corner1 Corner2 Corner3 texture {Tex} }
                triangle { Corner1 Corner3 Corner4 texture {Tex} }
                
                #declare COUNT_TRIANGLES = COUNT_TRIANGLES + 2;

        #local A = A + INCREMENT; #end

        // Calculate the top center of the cone.
        #declare Cone_End = <0,LENGTH,0>;
        #declare Cone_End = vrotate ( Cone_End, TiltVector );
        #declare Cone_End = Cone_End + BaseVector;

#end


//-------//-------//-------//-------//-------//-------//-------//
// End of this file.

