#declare vColBase =
union {
  difference {
    box {<-2,0,-2>, <2,2,2>}
    plane {<0,0,1>, 0 rotate <25,0,0> translate <0,1.285,-2>}
    plane {<0,0,1>, 0 rotate <25,0,0> translate <0,1.285,-2> rotate <0,90,0>}
    plane {<0,0,1>, 0 rotate <25,0,0> translate <0,1.285,-2> rotate <0,-90,0>}
    plane {<0,0,1>, 0 rotate <25,0,0> translate <0,1.285,-2> rotate <0,180,0>}
    plane {<0,0,1>, 0 rotate <45,0,0> translate <0,1.285,-1.41421356*2> rotate <0,-45,0>}
    plane {<0,0,1>, 0 rotate <45,0,0> translate <0,1.285,-1.41421356*2> rotate <0,45,0>}
    plane {<0,0,1>, 0 rotate <45,0,0> translate <0,1.285,-1.41421356*2> rotate <0,45+90,0>}
    plane {<0,0,1>, 0 rotate <45,0,0> translate <0,1.285,-1.41421356*2> rotate <0,-45-90,0>}
    cylinder {<-2.1,0,0>,<2.1,0,0>,0.325 scale <1,1,0.5> translate <0,0.65,-2>}
    cylinder {<-2.1,0,0>,<2.1,0,0>,0.325 scale <1,1,0.5> translate <0,0.65,-2> rotate <0,90,0>}
    cylinder {<-2.1,0,0>,<2.1,0,0>,0.325 scale <1,1,0.5> translate <0,0.65,-2> rotate <0,180,0>}
    cylinder {<-2.1,0,0>,<2.1,0,0>,0.325 scale <1,1,0.5>  translate <0,0.65,-2> rotate <0,270,0>}
    translate <0,0.5,0>
        }
    box {<-2.2,0,-2.2>,<2.2,0.5,2.2>}
    scale <2.25,2.5,2.25>
    }

#declare qtrCol =
	prism {
	0,40,
	11,
	<0,0>,<0,-2.5>,<1.5,-2.5>,<1.5,-3>,<2.5,-3>,<2.5,-2.5>,<3,-2.5>,<3,-1.5>,<2.5,-1.5>,<2.5,0>,<0,0>
	}

#declare Columny =
union {
	cylinder {<0,35,-40>,<0,59,-40>,1 scale <0.35,1,1> translate <4,0,0> texture { vDarkStone } }

	object { qtrCol }
	object { qtrCol rotate <0,90,0> }
	object { qtrCol rotate <0,-90,0> }
	object { qtrCol rotate <0,180,0> }

    box {<-3.5,32,-3.5>,<3.5,33,3.5>}
    box {<-3.25,31.5,-3.25>,<3.25,32,3.25>}

    object { vColBase texture { DarkStone }}
    box {<-3.2,0,-3.2>,<3.2,7,3.2>}
    texture { Bricky2 }
    }

//////

#declare bSquare =
union {
	object { qtrCol scale <0.85,1,0.85>}
	object { qtrCol rotate <0,90,0> scale <0.85,1,0.85>}
	object { qtrCol rotate <0,-90,0> scale <0.85,1,0.85>}
	object { qtrCol rotate <0,180,0> scale <0.85,1,0.85>}

    object { vColBase scale <0.85,0.55,0.85> texture { DarkStone }}
    box {<-3.2,0,-3.2>,<3.2,7,3.2> scale <0.85,0.55,0.85>}
    texture { Bricky2 }
    }


/////////

#declare FourHel =
	isosurface {
	function { f_helix1(x,y/2,z,4,1,0.8,2.2,1,1,0) }
	threshold 0.0
	accuracy 0.0005
	max_gradient 1
    contained_by { box {<-3,0,-3>, <3,39,3> }}
	    }

#declare Columny2 =
union {
	object { FourHel }
    torus {3,0.25 scale <1,3,1> translate <0,3.25,0> texture { ShinyGold }}
	object {vColBase scale <0.85,0.5,0.85> texture { DarkStone }}
    }

////

#declare Columny3 =
merge {
	cylinder {<0,0,0>,<0,39,0>,3 scale <0.5,1,1>}
    cylinder {<0,0,0>,<0,39,0>,3 scale <0.5,1,1> rotate <0,30,0>}
    cylinder {<0,0,0>,<0,39,0>,3 scale <0.5,1,1> rotate <0,60,0>}
    cylinder {<0,0,0>,<0,39,0>,3 scale <0.5,1,1> rotate <0,90,0>}
    cylinder {<0,0,0>,<0,39,0>,3 scale <0.5,1,1> rotate <0,120,0>}
    cylinder {<0,0,0>,<0,39,0>,3 scale <0.5,1,1> rotate <0,150,0>}
    torus {3,0.25 scale <1,3,1> translate <0,3.25,0> texture { ShinyGold }}
	object {vColBase scale <0.85,0.5,0.85> texture { DarkStone }}
    }

//////

#declare ColBase =
union {
    object { vColBase scale <0.75,0.55,0.75> translate <0,36,0>}
    torus {2,0.5 translate <0,39.5,0> texture { ShinyGold }}
    torus {2,0.35 translate <0,72,0> texture { ShinyGold }}
    torus {2,0.5 translate <0,72+6.25,0> texture { ShinyGold }}
    pigment { Granitey }
    finish { Gloss }
    }

#declare Slit =
union {
    cylinder {<0,0,0>, <0,26,0>, 0.5}
    sphere {<0,0,0>, 0.5 scale <1,4,1>}
    sphere {<0,0,0>, 0.5 scale <1,4,1> translate <0,26,0>}
    scale <0.25,1,1>
    translate <2,6.75,0>
    }

#local Clmangle = 0;
#declare Pillar =
difference {
    cylinder {<0,0,0>, <0,36,0>, 2}
#while ( Clmangle < 360 )
    object { Slit rotate <0,Clmangle,0> }
    #local Clmangle = Clmangle + 45;
#end
    }

#declare Doric =
union {
    object { Pillar }
    sphere {<0,0,0>,3.75 scale <0.5,1,0.875> translate <0,39.2,0> texture {Corinthian}}
    sphere {<0,0,0>,3.75 scale <0.5,1,0.875> rotate <0,30,0> translate <0,39.2,0> texture {Corinthian}}
    sphere {<0,0,0>,3.75 scale <0.5,1,0.875> rotate <0,60,0> translate <0,39.2,0> texture {Corinthian}}
    sphere {<0,0,0>,3.75 scale <0.5,1,0.875> rotate <0,90,0> translate <0,39.2,0> texture {Corinthian}}
    sphere {<0,0,0>,3.75 scale <0.5,1,0.875> rotate <0,120,0> translate <0,39.2,0> texture {Corinthian}}
    sphere {<0,0,0>,3.75 scale <0.5,1,0.875> rotate <0,150,0> translate <0,39.2,0> texture {Corinthian}}
    }

#declare TopColumn =
union {
    cylinder {<0,6.25,0>, <0,33,0>, 2}
    cylinder {<0,0,0>,<0,6.25,0>,2 texture { ShinyGold }}
    pigment { Granitey }
    finish {Gloss}
    }

#declare DColumn =
union {
    object { ColBase translate <0,0,0> }
    object { Doric translate <0,36,0>}
    object { TopColumn translate <0,72,0>}
    translate <0,-36,0>
	pigment { rgb <0.2,0.335,0.9875> }
    finish { Dull }
    }

/////////

#local cbzAng = 0;
#local cbzCirc = 0;
#local cbzDist = 0;

#declare cbgHelPart =
union {
#while ( cbzCirc < 180 )
    sphere {<0,0,0>,1
        translate <0,2,0>
        rotate <cbzAng,0,0>
        translate <0,15,0>
        rotate <0,0,cbzCirc-90>
        }
    sphere {<0,0,0>,1
        translate <0,2,0>
        rotate <cbzAng+120,0,0>
        translate <0,15,0>
        rotate <0,0,cbzCirc-90>
        }
    sphere {<0,0,0>,1
        translate <0,2,0>
        rotate <cbzAng+240,0,0>
        translate <0,15,0>
        rotate <0,0,cbzCirc-90>
        }
    #local cbzAng = cbzAng + 2;
    #local cbzCirc = cbzCirc + 0.5;
#end
	}

#declare HelPBase =
union {
	object { vColBase texture { DarkStone }}
	torus {1,0.2 translate <0,2,0> scale 6.5*0.5 texture { ShinyGold }}
	}

#declare ArchHelix =
union {
	object { cbgHelPart translate <0,31,0> texture { BlueStone finish { Shiny }}}
	object { HelPBase translate <-15,0,0> }
	object { HelPBase translate <15,0,0> }
	object { Pillar scale <1.55,0.75,1.55> translate <-15,4,0> texture { LightStone finish { Shiny }}}
	object { Pillar scale <1.55,0.75,1.55> translate <15,4,0> texture { LightStone finish { Shiny }}}
	torus {0.9,0.2 translate <0,2,0> scale 6.5*0.5 translate <-15,24.5,0> texture { ShinyGold }}
	torus {0.9,0.2 translate <0,2,0> scale 6.5*0.5 translate <15,24.5,0> texture { ShinyGold }}
	}