////////////////////////// telescope

#declare Telescope =
union {
   union {
    torus {0.75,0.15 rotate <0,0,90> translate <-0.75,0,0>}
    torus {0.75,0.1 rotate <0,0,90>}
    torus {1.5,0.15 rotate <0,0,90> translate <23,0,0>}
    torus {1.7,0.05 rotate <0,0,90> translate <26,0,0>}
    cylinder {<-0.75,0,0>, <0,0,0>, 0.85}
    cylinder {<23,0,0>, <26,0,0>, 1.65}
    pigment { rgb <0.1,0.1,0.1> }
    finish { Dull }
      }
  union {
    torus {0.75,0.25 rotate <0,0,90> translate <5,0,0>}
    torus {1,0.25 rotate <0,0,90> translate <10.5,0,0>}
    torus {1.25,0.25 rotate <0,0,90> translate <16.5,0,0>}
    cylinder {<0,0,0>, <5,0,0>, 0.75}
    cylinder {<5,0,0>, <10.5,0,0>, 1}
    cylinder {<10.5,0,0>, <16.5,0,0>, 1.25}
    cylinder {<16.5,0,0>, <23,0,0>, 1.5}
    pigment { rgb <0.8,0.5,0.2> }
    finish { Dull_Metal }
       }
    scale 0.2
    rotate <0,0,90>
    }

/// chair inside tower

#declare SLeg =
union {
    cone {<-8,-1,0>, 0.5, <-4.5,26,0>, 0.75}
    cylinder {<-7,6,0>, <0,6,-7>, 0.5 }
    }

#declare Chair =
union {
    superellipsoid {<1,0.1> rotate <90,0,0> scale <6,0.5,6> translate <0,26,0>}
    object { SLeg }
    object { SLeg rotate <0,90,0> }
    object { SLeg rotate <0,180,0> }
    object { SLeg rotate <0,270,0> }
    texture { ChairWood scale 8 rotate <2,0,1>}
    }

///////

#declare Prt1 =
	prism {
	0,4,
	5,
	<7.1,-10.1>,<-7.1,-10.1>,<-6,-9>,<6,-9>,<7.1,-10.1>
	texture {
		pigment { 
			checker rgb <0.85,0.85,0.9>, rgb <0.1,0.1,0.2> rotate <0,0,45> scale <0.5,1.4,1>*2 translate <0,2,0>
			}
		finish { Shiny2 }
		}
	}

#declare Prt2 =
	prism {
	0,4,
	5,
	<7.1,-10.1>,<6,-9>,<9,-6>,<10.1,-7.1>,<7.1,-10.1>
	texture {
		pigment { 
			checker rgb <0.85,0.85,0.9>, rgb <0.1,0.1,0.2> rotate <0,0,45> scale <0.5,1.4,1>*2 translate <1.4,0,0> rotate <0,-45,0>
			}
		finish { Shiny2 }
		}
	}


#declare PrPattern =
union {
	object { Prt1 }
	object { Prt2 }
	object { Prt1 rotate <0,-90,0> }
	object { Prt2 rotate <0,-90,0> }
	object { Prt1 rotate <0,90,0> }
	object { Prt2 rotate <0,90,0> }
	object { Prt1 rotate <0,180,0> }
	object { Prt2 rotate <0,180,0> }
	}

#declare TowerWall =
	prism {
	0,65,
	18,
	<7,-10>,<-7,-10>,<-10,-7>,<-10,7>,<-7,10>,<7,10>,<10,7>,<10,-7>,<7,-10>,
	<6,-9>,<-6,-9>,<-9,-6>,<-9,6>,<-6,9>,<6,9>,<9,6>,<9,-6>,<6,-9>
	}

#declare TowerFloor =
	prism {
	0,1,
	9,
	<6,-9>,<-6,-9>,<-9,-6>,<-9,6>,<-6,9>,<6,9>,<9,6>,<9,-6>,<6,-9>
	texture { BlCheck }
	}

#declare TowerBase =
	prism {
	0,1,
	9,
	<7.5,-10.5>,<-7.5,-10.5>,<-10.5,-7.5>,<-10.5,7.5>,<-7.5,10.5>,
	<7.5,10.5>,<10.5,7.5>,<10.5,-7.5>,<7.5,-10.5>
	texture { DarkStone }
	}

#declare TowerTurretWall =
	prism {
	0,3,
	21,
	<10,2>,<10,7>,<7,10>,<-7,10>,<-10,7>,<-10,-7>,<-7,-10>,<7,-10>,<10,-7>,<10,-2>,
	<9.5,-2>,<9.5,-6.5>,<6.5,-9.5>,<-6.5,-9.5>,<-9.5,-6.5>,<-9.5,6.5>,<-6.5,9.5>,<6.5,9.5>,<9.5,6.5>,<9.5,2>,<10,2>
	}

#declare CutTowerDoor =
union {
   intersection {
   		cylinder {<0,0,-1.2>,<0,0,1.2>, 5 translate <-2.5,0,0>}
   		cylinder {<0,0,-1.1>,<0,0,1.1>, 5 translate <2.5,0,0>}
   		translate <0,5,0>
   		}
   	box {<-2.5,0,-1.1>,<2.5,5,1.1>}
   	bounded_by { box {<-2.5,0,-1.1>,<2.5,10,1.1>} }
   	}

#declare CutTowerWindow =
union {
	object { CutTowerDoor scale <0.35,0.35,1> translate <-3.5,0,0> }
	object { CutTowerDoor scale <0.35,0.35,1> translate <3.5,0,0> }
	}

#declare TTDoorRim =
    torus {5,0.5 rotate <90,0,0> translate <-2.5,0,0> 
    clipped_by { box {<0,0,-0.51>,<3.5,5.1,0.51>} }
    }

#declare TDoorRim2 = 
union {
    cylinder {<2.5,0,0>,<2.5,5,0>,0.5}
    cylinder {<-2.5,0,0>,<-2.5,5,0>,0.5}
    object { TTDoorRim translate <0,5,0>}
    object { TTDoorRim rotate <0,180,0> translate <0,5,0>}
        }

#declare TDoorRim =
    object {TDoorRim2 scale <1,1,0.125>}

#declare TWinRim2 =
union {
    object {TDoorRim2}
    cylinder {<-2.5,0,0>,<2.5,0,0>,0.5}
    scale 0.35
    scale <1,1,0.125>
    }

#declare TWinRim=
union  {
    object {TWinRim2 translate <-3.5,0,0>}
    object {TWinRim2 translate <3.5,0,0>}
    }
    
//////////////

#declare TheTower =
union {                               
   union {
    object { TDoorRim  translate <0,0,-10> rotate <0,90,0>}
    object { TDoorRim  translate <0,27,-10>}
    object { TDoorRim  translate <0,45,-10> rotate <0,90,0>}
    object { TWinRim translate <0,15,-10>}
    object { TWinRim translate <0,54,-10>}
    object { TWinRim translate <0,5,-10>}
    object { TWinRim translate <0,10,-10> rotate <0,90,0>}
    object { TWinRim translate <0,20,-10> rotate <0,90,0>}
    texture { vDarkStone scale 0.125 finish {Shiny2} normal {granite 0.1 scale 0.5 }}
       }
    
  difference {
	object { TowerWall }

	object { CutTowerDoor translate <0,0,-10> rotate <0,90,0> }
	object { CutTowerDoor translate <0,27,-10> }
	object { CutTowerDoor translate <0,45,-10> rotate <0,90,0> }

	object { CutTowerWindow translate <0,15,-10> }
	object { CutTowerWindow translate <0,54,-10> }

	object { CutTowerWindow translate <0,5,-10> }

	object { CutTowerWindow translate <0,10,-10> rotate <0,90,0> }
	object { CutTowerWindow translate <0,20,-10> rotate <0,90,0> }
	  }
    }

#declare TheTowerb =
union {                               
   union {
    object { TWinRim translate <0,15,-10>}
    object { TWinRim translate <0,55,-10>}
    object { TWinRim translate <0,27,-10>}
    object { TWinRim translate <0,5,-10>}
    object { TWinRim translate <0,10,-10> rotate <0,90,0>}
    object { TWinRim translate <0,20,-10> rotate <0,90,0>}
    object { TWinRim translate <0,40,-10> rotate <0,90,0>}
    texture { vDarkStone scale 0.125 finish {Shiny2} normal {granite 0.1 scale 0.5 }}
       }
  difference {
	object { TowerWall }
	object { CutTowerWindow translate <0,15,-10> }
	object { CutTowerWindow translate <0,55,-10> }
	object { CutTowerWindow translate <0,27,-10> }
	object { CutTowerWindow translate <0,5,-10> }

	object { CutTowerWindow translate <0,10,-10> rotate <0,90,0> }
	object { CutTowerWindow translate <0,20,-10> rotate <0,90,0> }
	object { CutTowerWindow translate <0,40,-10> rotate <0,90,0> }
	  }
    }


#local Twrangle = 0;

#declare TowerRailBars =
union {
	object { CSineWave(0,180,2.25,6,20,0.15) }
	object { CSineWave(60,180,2.25,6,20,0.15) }
	object { CSineWave(120,180,2.25,6,20,0.15) }
	object { CSineWave(180,180,2.25,6,20,0.15) }
	object { CSineWave(240,180,2.25,6,20,0.15) }
	object { CSineWave(300,180,2.25,6,20,0.15) }
	texture { Rails }
	translate <0,2,0>
	rotate <0,90,0>
	}

#declare HRail2 =
	   torus {6,0.2
	   clipped_by {box {<-6.21,-0.21,-6.21>,<6.21,0.21,0>}}
	   }

#declare TowerRail =
union {
#while ( Twrangle < 190 )
	cylinder {<0,-2,0>,<0,0,0>,0.1 translate <6,0,0> rotate <0,Twrangle,0> texture { vDarkStone }}
	#local Twrangle = Twrangle + 10;
#end
	cylinder {<0,-2,0>,<0,0,0>,6 }
	object { TowerRailBars }
	object { HRail2 translate <0,-0.2,0> texture { vDarkStone }}
	object { HRail2 translate <0,-2,0> texture { vDarkStone }}
	cylinder {<0,0,0>,<0,0.1,0>,5.99999 texture { BlCheck } }
	object { TowerRailBars }
	prism {
		-2,2,
		4,
		<-1,0>,<6,0>,<6,-5.5>,<-1,0>
		rotate <0,0,90>
		translate <0,-8,0>
		}
	}

////////// 

#declare BridgeRails =
union {
	object { SineWave(-25,0,2.5,2,50,0.15) translate <0,2.25,4>}
	object { SineWave(-25,120,2.5,2,50,0.15) translate <0,2.25,4>}
	object { SineWave(-25,240,2.5,2,50,0.15) translate <0,2.25,4>}

	object { SineWave(-25,60,2.5,2,50,0.15) translate <0,2.25,4>}
	object { SineWave(-25,180,2.5,2,50,0.15) translate <0,2.25,4>}
	object { SineWave(-25,300,2.5,2,50,0.15) translate <0,2.25,4>}
	}

#local twrxCoord = -23;

#declare BridgeRails2 =
union {
#while ( twrxCoord < 25 )
	cylinder {<twrxCoord,0,-4>,<twrxCoord,4.5,-4>,0.2}
	sphere {<twrxCoord,0,-4>,0.3 texture {LightStone}}
	#local twrxCoord = twrxCoord + 5.33333333;
#end
	texture { Rails }
	}

#local twrxCoord = -25;

#declare TowerBridgeWalk =
union {

	box {<-25,0,-3.5>,<25,0.01,3.5> texture { WalkCheck }}

	box {<-25,-2,-4.5>,<25,0,4.5>}
	cylinder {<-25,-2,-4.5>,<25,-2,-4.5>,0.2 texture { vDarkStone }}
	cylinder {<-25,0,-4.5>,<25,0,-4.5>,0.2 texture { vDarkStone }}
	cylinder {<-25,-2,4.5>,<25,-2,4.5>,0.2 texture { vDarkStone }}
	cylinder {<-25,0,4.5>,<25,0,4.5>,0.2 texture { vDarkStone }}
	object { BridgeRails }
	object { BridgeRails translate <0,0,-8> }
	object { BridgeRails2 }
	object { BridgeRails2 translate <0,0,8> }
#while (twrxCoord < 25)
	cylinder {<twrxCoord,-2,-4.5>,<twrxCoord,0,-4.5>,0.1 texture { vDarkStone }}
	#local twrxCoord = twrxCoord + 1.25;
#end
	}

#declare jrBr1 =
	union {
		lathe {
		5,
		<42,-4.1>,<39,-4.1>,<39,4.1>,<42,4.1>,<42,-4.1>
		rotate <90,0,0>
			}
		lathe {
		5,
		<46,-4.1>,<44,-4.1>,<44,4.1>,<46,4.1>,<46,-4.1>
		rotate <90,0,0>
			}
		torus {42,0.2 rotate <90,0,0> translate <0,0,-4> texture { vDarkStone }}
		torus {39,0.2 rotate <90,0,0> translate <0,0,-4> texture { vDarkStone }}
		torus {42,0.2 rotate <90,0,0> translate <0,0,4> texture { vDarkStone }}
		torus {39,0.2 rotate <90,0,0> translate <0,0,4> texture { vDarkStone }}
		torus {46,0.2 rotate <90,0,0> translate <0,0,-4> texture { vDarkStone }}
		torus {44,0.2 rotate <90,0,0> translate <0,0,-4> texture { vDarkStone }}
		torus {46,0.2 rotate <90,0,0> translate <0,0,4> texture { vDarkStone }}
		torus {44,0.2 rotate <90,0,0> translate <0,0,4> texture { vDarkStone }}
		}

#declare TowerBridgeArch =
	object { jrBr1
	clipped_by {box {<-25,20,-4.25>,<25,42.25,4.25>}}
	translate <0,-43.5,0>
	}

#local Twrangle = 40;

#declare TP1 =
union {
#while (Twrangle < 130)
	cylinder {<39,0,-4.1>,<42,0,-4.1>,0.1 rotate <0,0,Twrangle>
		texture { vDarkStone }
		}
	#local Twrangle = Twrangle + 2.5;
#end
	translate <0,-43.5,0>
	}

#local Twrangle = 55;

#declare TP2 =
union {
#while (Twrangle < 70)
	cylinder {<44,0,-4.1>,<46,0,-4.1>,0.1 rotate <0,0,Twrangle>
		texture { vDarkStone }
		}
	cylinder {<-44,0,-4.1>,<-46,0,-4.1>,0.1 rotate <0,0,-Twrangle>
		texture { vDarkStone }
		}
	#local Twrangle = Twrangle + 2.5;
#end
	translate <0,-43.5,0>
	}

#declare TowerBridge =
union {
	object { TowerBridgeWalk }
	object { TowerBridgeArch }
	object { TP1 }
	object { TP2 }
	texture {
	average
	texture_map {
		[1 Bricky1 scale 0.5 rotate <0,90,0>]
		[0.15 Bljr]
			}
		}
	}

//////////

#declare ATurret =
union {
	box {<-1,0,0>,<1,2,0.5> }
	box {<-1.1,2,-0.1>,<1.1,2.1,0.6> }
	}

#declare AllTurrets =
union {
	object { ATurret translate <0,3,-12> rotate <0,45,0> }
	object { ATurret translate <0,3,-10> }
	object { ATurret translate <3,3,-10> }
	object { ATurret translate <-3,3,-10> }
	object { ATurret translate <6,3,-10> }
	object { ATurret translate <-6,3,-10> }
	}

#declare CutTowerArch =
union {
	box {<-2.5,0,-6.1>,<2.5,7,6.1> }
	cylinder {<0,0,-6.1>,<0,0,6.1>,2.5 translate <0,7,0> }
	}

#declare TowerTopArch =
difference {
	object { TowerWall scale <0.6,0.175,0.6> }
	object { CutTowerArch }
	object { CutTowerArch rotate <0,90,0> }
	}

#declare TTRim =
union {
	cylinder {<-2.5,0,-6>,<-2.5,7,-6>,0.2}
	cylinder {<2.5,0,-6>,<2.5,7,-6>,0.2}
  	torus {2.5,0.2 rotate <90,0,0>
		clipped_by {box {<-2.7,0,-0.2>,<2.7,2.7,0.2>}}
 		translate <0,7,-6>
  		}
  	texture { DarkStone scale 0.125 finish {Shiny2} normal {granite 0.1 scale 0.5 }}
  	}


#declare SpireHelix =
isosurface {
	function { f_helix1(x,y,z,4,0.375,0.2,0.75,2,1,0) }
	threshold 0.0
	accuracy 0.0005
	max_gradient 2.859
    contained_by { box {<-1,0,-1>, <1,19,1> }}
	translate <0,-20,0>
	texture { DarkStone }
	scale 1/0.8
		}

#declare SpireHelix2 =
isosurface {
	function { f_helix1(x,y,z,4,-0.375,0.2,0.75,2,1,0) }
	threshold 0.0
	accuracy 0.0005
	max_gradient 2.859
    contained_by { box {<-1,0,-1>, <1,19,1> }}
	translate <0,-20,0>
	texture { DarkStone }
	scale 1/0.8
		}

#declare Spire =
union {
	difference {
		sphere {<0,0,0>,1}
		torus {1,1 translate <0,1,0>}
		}
	torus {1,1 translate <0,-1,0> }
	torus {1,0.35 translate <0,-2,0> texture { DarkStone}}
	cylinder {<0,-25,0>,<0,0,0>,1 texture { TowerBrick scale 0.5 }}
	object { SpireHelix }
	object { SpireHelix2 }
	scale 0.8
	pigment { rgb <1,1,0> }
	finish { Shiny_Metal }
    }

#declare TowerTurrets =
union {
	object { TTRim }
	object { TTRim rotate <0,90,0>}
	object { TTRim rotate <0,-90,0>}
	object { TTRim rotate <0,180,0>}
	object { TowerTurretWall }
	object { AllTurrets }
	object { AllTurrets rotate <0,90,0> }
	object { AllTurrets rotate <0,180,0> }
	object { ATurret translate <0,3,-12> rotate <0,45+270,0> }
	box {<-7,3,10>,<-2,5,9.5> rotate <0,90,0> }
	box {<-7.1,5,10.1>,<-1.9,5.1,9.4> rotate <0,90,0> }
	box {<7,3,10>,<2,5,9.5> rotate <0,90,0> }
	box {<7.1,5,10.1>,<1.9,5.1,9.4> rotate <0,90,0> }
	object { TowerTopArch }
	object { TowerBase scale <0.6,1,0.6> translate <0,11,0> }
	translate <0,65,0>
	}

/////////

#declare ATower =
union {
	union {
		object { Spire translate <-5.2,86,-5.2> }
		object { Spire translate <5.2,86,5.2> }
		object { Spire translate <5.2,86,-5.2> }
		object { Spire translate <-5.2,86,5.2> }
		sphere {<0,0,0>,5.5
			clipped_by {box {<-5.5,0,-5.5>,<5.5,5.5,5.5>}}
			texture {
				gradient <0,1,0>
				texture_map {
					[0.3 ShinyGold]
					[0.3 bbbBlue]
					[0.5 bbbBlue]
					[0.5 ShinyGold]
						}
					scale <1,5.5,1>
					}
			translate <0,77,0>
    			}
    	torus {5.5,0.25
    		translate <0,77,0>
			pigment { rgb 1 }
			finish { Shiny_Metal }
    			}
		object { TowerTurrets }
		object { TheTower }
		object { TowerRail translate <0,27,-10> 	texture { TowerBrick } }
		object { TowerBridge translate <-35,45,0> }
		object { TowerBridge translate <-35,0,0> }
		translate <0,1,0>
		}
	object { TowerBase translate <0,65,0> }
	object { TowerBase translate <0,60,0> }
	object { TowerBase translate <0,45,0> }
	object { TowerBase translate <0,40,0> }
	object { TheTowerb translate <0,-65,0> }
	object { TowerWall translate <0,-65-65,0> }
	object { TowerBase }
	object { TowerBase translate <0,-5,0>}
	object { PrPattern translate <0,-32,0> }
	object { TowerFloor translate <0,27.1,0> }
	object { TowerFloor translate <0,45.1,0> }
	object { TowerFloor translate <0,0.1,0> }
	object { TowerFloor translate <0,65.1,0> }
	object { Chair translate <0,1,0> scale 0.15 translate <1,28,-6> }
	object { PrPattern translate <0,41,0> }
	object { PrPattern translate <0,61,0> }
	object { PrPattern translate <0,-4,0> }
	object { TowerBase translate <0,-33,0> }
	object { TowerBase translate <0,-28,0> }
	texture {
	average
	texture_map {
		[1 TowerBrick]
		[0.15 Bljr]
			}
		}
	translate <0,2,0>
	}
