// Main POV-Ray Scene File for IRTC Jan-Feb 2002 Entry
// by Matt Walton <matt@alledora.co.uk>
// written for POV-Ray 3.5 beta 11

#version 3.5;

global_settings {
  max_trace_level 255
  adc_bailout 0.01
  photons {
  }
}

/*
 * Texture Definitions
 */
 
#declare tGlass = texture {
  pigment {
    rgbt 1
  }
  finish {
    specular 0.3
    roughness 0.001
    reflection {
      0.1
    }
  }
}

#declare tSecondPlanetSea = texture {
   pigment {
     granite
     colour_map {
       [0 rgb<0.2,0.3,0.7>]
       [1 rgb<0.1,0.2,0.8>]
     }
   }
}

#declare pSecondPlanetPole = pigment {
  bozo
  color_map {
    [0 rgb<0.9,0.9,1>]
    [1 rgb 1]
  }
  turbulence 2
}

#declare pSecondPlanetGreen = pigment {
  bozo
  colour_map {
    [0 rgbt 1]
    [0.5 rgbt 1]
    [0.501 rgb<0.1,0.6,0>]
    [0.8 rgb<0.2,0.6,0.1>]
    [1 rgb<0.4,0.5,0.4>]
  }
  turbulence 2
  scale <1,0.3,1>
}

#declare tSecondPlanetLand = texture {
  pigment {
    gradient y
    pigment_map {
      [0.00 pSecondPlanetPole  ]
      [0.05 pSecondPlanetPole  ]
      [0.06 pSecondPlanetGreen ]
      [0.94 pSecondPlanetGreen ]
      [0.95 pSecondPlanetPole  ]
      [1.00 pSecondPlanetPole  ]
    }
    turbulence 0.1
    scale <1,1.4,1>
  }
  normal {
    granite
    scale 0.1
  }
}

#declare tSecondPlanetClouds = texture {
  pigment {
    bozo
    colour_map {
       [0 rgbt 1]
       [0.2 rgbt 1]
       [1 rgb 1]
    }
    turbulence 3
    scale <4,0.8,4>
  }
  finish {
    ambient 0.4
  }
}
 
#declare tPlanetInner = texture {
  pigment {
    granite
    colour_map {
      [0 rgb<0.46,0.29,0.08>]
      [1 rgb<0.39,0.24,0.07>]
    }
  }
  normal {
    granite
  }
}
/*
 * Interior Definitions
 */
 
#declare iGlass = interior {
  ior 1.5
}

#declare iSecondPlanetAtmosphere = interior {
  media {
    //emission rgb<0.9,0.9,1>
    scattering { 1, rgb<0.2,0.2,0.5>*0.2 }
  }
}
/*
 * Object Definitions
 */
 
#include "bottle.inc"
#declare oBottle = object {
   sob_object
   texture {
     tGlass
   }
   interior {
     iGlass
   }
   photons {
    target
    reflection on
    refraction on
   }
}
#declare oInnerPlanet = union {
  sphere {
    0,2
    texture {
      tSecondPlanetSea
    }
    texture {
      tSecondPlanetLand
      scale 4
      translate <0,-2,0>
    }
    texture {
      tSecondPlanetClouds
    }
  }
  sphere {
    0,2.2
    pigment {
      rgbt 1
    }
    interior {
      iSecondPlanetAtmosphere
    }
    hollow
  }
}

#declare oPlanet = union {
  sphere {
    0,3
    texture {
      tSecondPlanetSea
    }
    texture {
      tSecondPlanetLand
      scale 6
      translate <0,-3,0>
      rotate 83*y
    }
    texture {
      tSecondPlanetClouds
      scale 2
    }
  }
}
#declare oHalfPlanetAtmosphere = difference {
  sphere {
    0,3.2
  }
  sphere {
    0,2.999999
  }
  plane {
    -y,0
  }
}
#declare oOuterPlanetHalf = union {
  difference {
    object {
      oPlanet
    }
    sphere {
      0,2.8
      texture {
        tPlanetInner
      }
    }
    plane {
      -y,0
      texture {
        tPlanetInner
      }
    }
  }
  object {
    oHalfPlanetAtmosphere
    pigment {
      rgbt 1
    }
    interior {
      iSecondPlanetAtmosphere
    }
    hollow
  }
  photons {
    collect off
    reflection on
    refraction on
  }
}

#declare oSecondPlanet = union {
  sphere {
    0,2
    texture {
      tSecondPlanetSea
    }
    texture {
      tSecondPlanetLand
    }
    texture {
      tSecondPlanetClouds
    }
  }
  sphere {
    0,2.2
    pigment {
      rgbt 1
    }
    interior {
      iSecondPlanetAtmosphere
    }
    hollow
  }
  photons {
    collect off
    reflection on
    refraction on
  }
} 

#declare PlanetInBottle = union {
  object {
    oBottle
    translate 1*y
  }

  object {
    oOuterPlanetHalf
    translate 7*y
  }

  object {
    oInnerPlanet
    translate 7*y
  }
}



/*
 * Scene Layout
 */

camera {
  location <-10,25,-11>
  look_at <0,11.5,0>
}

light_source {
  <40,40,0> rgb 0.5
}

light_source {
  <-40,40,0> rgb 0.5
}

light_source {
  <0,40,40> rgb 0.5
}

light_source {
  <0,40,-40> rgb 0.5
}

plane {
  y,0
  texture {
    pigment {
      granite
      colour_map {
        [0 rgb 0.5]
        [1 rgb 0.6]
      }
    }
    finish {
      specular 0.1
    }
    normal {
      granite 0.1
    }
  }
  photons {
    reflection on
    refraction on
  }
}

object {
  PlanetInBottle
}

/*object {
  PlanetInBottle
  translate 15*x
}

object {
  PlanetInBottle
  translate 15*z
}

object {
  PlanetInBottle
  translate 15*x + 15*z
}*/
fog {
  distance 70
  rgbt<0.5,0.5,0.5,0.8>
  turbulence 1
}