
// Persistence of Vision Ray Tracer Scene Description File
// File: mg_led.pov
// Vers: 3.5 beta 10,11
// Desc: Worlds within worlds IRTC topic. Title "It makes me wonder"
// based on 'Stairway to Heaven'(Page/Plant) by Led Zeppelin 1971.  
// Date: February 11th, 2002
// Auth: Marjorie Graterol


#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
#include "mg_led01.inc"


//object {ejes translate <80,10,100>}



global_settings {
  
  adc_bailout 0.0039
	ambient_light Gray40 //
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 32//
	number_of_waves 10
	   
	  radiosity{
		brightness 0.15// 0.25
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
		media on
	} 
  }

sky_sphere {
  pigment {
    colour SkyBlue
    }                              
}


fog {
  fog_type 2
  distance  51.2
  color Gray80 transmit 0 //rgbt <  .772549,  .9960784,  .9843137,  0 >//<  .8,  .7686275,  .8901961,  0 >
  fog_alt  8.28427124
  fog_offset  0
  }


#declare Forester_RedObjects = false;
#declare Forester_Animation = false;
#declare Forester_Frame = 0;
#declare Forester_Time =  ( 0 )  ;
#declare Forester_Season =  1;

#declare Forester_CamAngle =  54.432235175858;
#declare Forester_CamFocus =  6;
#declare Forester_CamAperture =  .12499996977193;
#declare Forester_CamPitch = -1.63773798942566;
#declare Forester_CamHeading =  36.6656303405762;
#declare Forester_CamRoll =  0;
#declare Forester_CamLocation =  < 60, 15, 82>;  //< 60, 15, 82>;

camera {
  sky       < 0, 1, 0>
  up        < 0, 1, 0>
  right     <  .75, 0, 0>
  angle Forester_CamAngle
  rotate -z * Forester_CamRoll
  rotate < -Forester_CamPitch, Forester_CamHeading, 0 >
  translate Forester_CamLocation
}


light_source {
  0*x                     
  color Turquoise filter 0.5
  spotlight
  parallel               
  translate <60, 150, 102> 
  point_at <67, 105, 102>      
  radius 0.15//               
  tightness 50            
  falloff 8               
  fade_power 2
  fade_distance 45//
  shadowless
}


//Lights -Luces

object{luces translate <100,20,100>}

object{luces translate <80,15,55>}



#declare Forester_TerrainPigment1 = pigment { // Base Layer
  granite
  colour_map {
    [ 0.00 rgb <  .454902,  .3137255,  .172549 > ]
    [ 0.50 rgb <  .5003921,  .345098,  .1898039 > ]
    [ 1.00 rgb <  .4094118,  .2823529,  .1552941 > ]
    }
  translate <0, 500,0>
  scale < 100, 100, 100>
  }

#declare Forester_TerrainPigment2 = pigment { // Layer_2
  granite
  colour_map {
    [ 0.00 rgbt <  .9137255,  .7137255,  .1058824,1.00 > ]
    [  .3387097 rgbt <  .9137255,  .7137255,  .1058824,1.00 > ]
    [  .5322581 rgbt <  .8223529,  .6423529,  9.529412E-02, .6 > ]
    [ 1.00 rgbt <  1.005098,  .7850981,  .1164706, .6 > ]
    }
  translate <0, 580,0>
  scale < 100, 100, 100>
  }

#declare Forester_TerrainPigment3 = pigment { // Layer_3
  granite
  colour_map {
    [ 0.00 rgbt <  .454902,  .3137255,  .172549,1.00 > ]
    [  .490566 rgbt <  .454902,  .3137255,  .172549,1.00 > ]
    [  .5471698 rgbt <  .4094118,  .2823529,  .1552941, .85 > ]
    [ 1.00 rgbt <  .5003921,  .345098,  .1898039, .85 > ]
    }
  translate <0, 480,0>
  scale < 1.96, 1.96, 1.96>
  }

#declare Forester_TerrainPigment4 = pigment { // Layer_4
  granite
  colour_map {
    [ 0.00 rgbt <  .627451,  .5372549,  1.960784E-02,1.00 > ]
    [  .1151515 rgbt <  .627451,  .5372549,  1.960784E-02,1.00 > ]
    [  .5090909 rgbt <  .5647058,  .4835294,  1.764706E-02, .52 > ]
    [ 1.00 rgbt <  .6901961,  .5909804,  2.156863E-02, .52 > ]
    }
  translate <0, 810,0>
  scale < 129.96, 129.96, 129.96>
  }

#declare Forester_TerrainPigment0 = pigment { colour rgbft <1,1,1,0,1> }

object {  
  height_field {
    tga "terreno01.tga"
    water_level 0.0
    smooth
    }
  scale < -399,  64, 399>
  translate <399,-32,0>
   //
   
   
   //
  material {
    texture { // Base Layer
      pigment { 
        Forester_TerrainPigment1
        }
      normal { 
        granite,  1
        scale < 3.5, 3.5, 3.5>
        }
      finish { ambient  .6 diffuse  .7 brilliance 1.5 }
       }
    texture { // Layer_2
      pigment { 
        Forester_TerrainPigment2
        }
      normal { 
        granite,  1
        scale < 3.5, 3.5, 3.5>
        }
      finish { ambient  .2 diffuse  .8 brilliance 1.5 }
       }
    texture { // Layer_3
      pigment { 
        gradient y
        pigment_map {
          [  .4960938 Forester_TerrainPigment0 ]
          [  .5039063 Forester_TerrainPigment3 ]
          [  .6289063 Forester_TerrainPigment3 ]
          [  .6367188 Forester_TerrainPigment0 ]
          }
        scale < 1,  64, 1 >
        translate < 0,-32,0>
        warp { turbulence <0, .125,0> octaves 1 lambda 1.2 }
        }
      normal { 
        granite,  .2333333
        scale < 3.5, 3.5, 3.5>
        }
      finish { ambient  1.01 diffuse  1.06 brilliance 1.5 }
       }
    texture { // Layer_4
      pigment { 
        gradient y
        pigment_map {
          [  .5921875 Forester_TerrainPigment0 ]
          [  .6234375 Forester_TerrainPigment4 ]
          [  .5928125 Forester_TerrainPigment4 ]
          [  .6240625 Forester_TerrainPigment0 ]
          }
        scale < 1,  64, 1 >
        translate < 0,-32,0>
        warp { turbulence <0, .5,0> octaves 1 lambda 1.2 }
        }
      normal { 
        granite,  .8
        scale < 3.65, 3.65, 3.65>
        }
      finish { ambient  .49 diffuse  .48 brilliance 1.5 }
       }
    }
    
    //aadida- se superpone a las anteriores
    texture{
      pigment{
        bozo//
 
        color_map{
   
        [0.5 vd2 filter 0.99999]
        [1.0 Clear]
       }
    scale 10//
   
  //
      }
   
      finish { 
        ambient 0.5 
        diffuse 0.5 
        specular 0.02 
        roughness 0.002 
        reflection 0.05
      }
    }  //fin textura aadida
}





#declare Forester_AllRedMaterial =
  material {
    texture {
      pigment { 
        color rgb <1.0, 0.0, 0.0>
        }
      finish {
        diffuse 1.0
        ambient 0.0
        brilliance 0.0
        }
      }
    }

#declare Forester_AllRedTexture =
    texture {
      pigment { 
        color rgb <1.0, 0.0, 0.0>
        }
      finish {
        diffuse 1.0
        ambient 0.0
        brilliance 0.0
        }
      }
//piper   OJO NO TOCAR - 

#include "piper.inc"
object {
  piper
  scale 1.5 
  rotate 255*y 
  translate < 83, 11.2,95> //< 90, 10.55,100>< 90, 10.4,110>
  no_reflection//
  //double_illuminate
} 

#include "lady.inc"


  object{
   lady
  rotate 115*y
  scale 1.40
  
  translate<80.9,10.9,123.5>
  

}
 //OJO
/*Necesita Spiral.inc*/

#include "stairway.inc"
//fondo    anterior<119,10,250>
object {stairs scale 0.75  translate <200,7,300>}   //<80,10,150>}

object{cylinder { 0*y,  3*y,  1 }
texture{
pigment {
  agate 
  turbulence 0.3
  color_map{
    [0.5 color rgbt <  .8,  .7686275,  .8901961,  0.8>]
    [1.0 color Clear] 
  }
scale<2,1,2>  
  
  
}
finish{ambient 0.5 diffuse 0.7}

}
no_shadow
scale <7.50,150,7.50>
translate <200,7,300>}


//frente
object {stairs 
no_shadow
scale 0.75 
rotate -90*y 
translate <116,10,142>
}


object{cylinder { 0*y,  3*y,  1 }
texture{
pigment {
  agate 
  turbulence 0.3
  color_map{
    [0.5 color rgbt <  .8,  .7686275,  .8901961,  0.8>]
    [1.0 color Clear] 
  }
  
scale<2,1,2>  
  
}
finish{ambient 0.5 diffuse 0.7}
}
no_shadow
scale <7.50,150,7.50>
translate < 116, 10,142>}



#include "grama.inc"

object {grama}


//follaje-foliage

union{
object { bos_09 scale 7 translate <120,6,210>} 
object { bos_09 scale 7 translate <115,6.5,200>}
object { bos_09 scale 9 translate <108,6.2,196>}
object { bos_09 scale 9 translate <107,6,185>} 

object { bos_09 scale <8,7,8> translate <104,6,180>} 




}


#include "planta03.inc"

object{planta03 scale 0.04 translate <70,8,87>}

#include "planta02.inc"

object{planta02 scale 0.04 translate <69,7,87>}


#include "piedra.inc"

#declare camino1=
union{
object {piedra rotate  45*y translate <66.5,7.15,93>}

object {piedra2 rotate  45*y translate <64.25,7.15,97.30>}  //<63.5,7.15,97.30>

object {piedra2 translate <61.7,7.17,93.50>}
object {piedra  rotate  35*y translate <68,7.13,96.5>}
object {piedra2 translate <65.3,7.17,94.75>}
object {piedra2 rotate  45*y translate <67.3,7.17,99.75>}
object {piedra2 rotate 5*z rotate  -45*y translate <66.3,6.95,98.65>}
object {piedra rotate 2*x  rotate -90*y translate <70.8,8.13,99>}

object {piedra rotate 2*z  rotate 90*y translate <67.8,8.9,97.0>}
 
texture{
    pigment{
 agate 
 turbulence 0.22 
   color_map{
      
   [0.5 Carton filter 0.8][0.7 Ocre filter 0.8]
   [0.8 Ocre filter 0.7][1.0 Carton filter 0.7 ]
   }
   
   
   
   }
   normal{bumps 0.10}
   finish { ambient 0.5 diffuse 0.5  reflection 0.15}
   
    }  //fin aadida
    
    interior{ior 1.33}
    } 


object{camino1}





#include "arbusto.inc"
//arbustos izquierda
//primero
object {arbusto scale <0.085,0.1,0.085> translate <63.5,6,97>} //0.085<63.5,6,97>
//derecha
object {arbusto scale <0.085,0.1,0.085> rotate -45*y translate <65.5,7,100>}//
//medio
object {arbusto scale <0.085,0.1,0.085> rotate 65*y translate <63.5,5,100>}//


// arbustos derecha
object {arbusto scale <0.085,0.1,0.085> translate <120,6,113>} //0.085<63.5,6,97>
//
object {arbusto scale <0.085,0.1,0.085> rotate -45*y translate <119.5,7,113.5>}//
//
object {arbusto scale <0.085,0.1,0.085> rotate 65*y translate <119,5,114>}//


#include "florecita2.inc"
object {florecita2 scale 0.03 translate <68.2,7.15,92>}//<67,7.15,94>
object {florecita2 scale 0.03 rotate -45*y translate <68,7.15,92>}//<67,7.15,94>

//OJO
#include "arbusto_b.inc"

object{arbusto_b scale 0.085 rotate 45*y translate <68.9,4,110>}

//object{arbusto scale 0.085 rotate 45*y translate <68.9,4,110>}

#include "monte2.inc"

object {monte2 scale 0.03 translate <68,7.09,92> }
object {monte2 scale 0.03 translate <69,7.09,95> }


#declare camino2=
union{
object {piedra rotate  45*y translate <0.665,0,0.93>}

object {piedra2 rotate  45*y translate <0.635,0,0.9730>}
object {piedra2 translate <0.617,0,0.9350>}
object {piedra  rotate  35*y translate <0.68,0,0.965>}
object {piedra2 translate <0.653,0,0.9475>}
object {piedra2 rotate  45*y translate <0.673,0,0.9975>}
object {piedra2 rotate 5*z rotate  -45*y translate <0.663,0,0.9865>}
object {piedra rotate 2*x  rotate -90*y translate <0.708,0,0.99>}

object {piedra rotate 2*z  rotate 90*y translate <0.678,0,0.970>}

texture{
    pigment{
 agate 
 turbulence 0.22 
   color_map{
      
   [0.5 Carton filter 0.8][0.7 Ocre filter 0.8]
   [0.8 Ocre filter 0.7][1.0 Carton filter 0.7 ]
   }
   
   
   
   }
   normal{bumps 0.10}
   finish { ambient 0.5 diffuse 0.5  reflection 0.15}
   
    }  //fin aadida
    
    interior{ior 1.33}
    } 
//}


object{camino2  translate <90,10,100>}
object{camino2  rotate 75*y translate <78.2,8.1,115.5>}
object{camino2  rotate 75*y translate<78.2,8,110.5>}

#include "the_wall.inc"

object {
  the_wall 
  scale <1.5,1,1> 
  rotate -28*y 
  translate <63.4,7,96.8> //97
}



#include "canora.inc"

object {canora scale 0.30 rotate -15*z rotate 160*y translate <65.4,22,95.8>} 

#declare nubes=
//comienzan nubes
//primera visible
object { //Sky
  union { 
  plane { y,  60 inverse no_shadow }
  plane { y,  61.6666666666667 inverse no_shadow }
  plane { y,  63.3333333333333 inverse no_shadow }
  plane { y,  65 inverse no_shadow }
  plane { y,  66.6666666666667 inverse no_shadow }
  plane { y,  68.3333333333333 inverse no_shadow }
  plane { y,  70 inverse no_shadow }
    }
  pigment {  
    wrinkles 
    turbulence  1.34
    octaves 6
    omega 0.55//0.6
    lambda 1.9 
    //colores modificados -todos-
      color_map {
    // (Cloud cover for this frame:  11.25%
      [0.0 color White filter 0.2]
      [ .05625 White filter 0.2]
      [ .075 color White*2 filter 0.8]
      [ .1125 color White*2 ]
      [1.0 color White]
      }
    scale < 128, 81, 128>   
    translate <0, 0,0>  
    }
  finish {
    ambient 1.25
    diffuse 0.8
    brilliance 1
    
    }
   // normal aadida 
  normal {bumps 0.5//0.5 
  scale 50}
  translate <  25,0, 5>
  } 

#declare nubes2=   
//base de la anterior (encima)
object { //Sky
  union { 
  plane { y,  150 inverse no_shadow }
  plane { y,  155 inverse no_shadow }
  plane { y,  160 inverse no_shadow }
    }
  pigment {
    wrinkles
    turbulence  1
    octaves 6
    omega 0.6
    lambda 1.9
    
    color_map {
      //colores modificados
      [0.0 color White ]
      [ .3125 color White filter 0.8 ]
      [ .4166667 color White filter 0.5 ]
      [ .625 color White ]
      [1.0 color White filter 0.8]
      } 
    
    scale < 155, 100, 155>  
    translate <0, 0,0>
    }
    //acabado modificado  
  finish {
    ambient 1.5
    diffuse 0.7
    brilliance 2
    
    }
    //normal aadida
    normal {bumps 0.5//0.5 
    scale 50}
  }
 
 
 #declare semitrans=
 texture{
pigment {
  agate 
  turbulence 0.3
  color_map{
    [0.5 color rgbt <  .8,  .7686275,  .8901961,  0.855>]//0.8
    [1.0 color Clear] 
  }
  
scale <4,3,4>//<5,8,5>//<2,1,2>  
  
}
finish{ambient 0.5 diffuse 0.7}
}

#declare tunel= 
merge{
 
 object{cylinder { 0*y,  3*y,  1  open}
 
no_shadow
scale <7.50,150,7.50>
translate < 116, 10,142>}
object{cylinder {0*y, 20*y, 1} no_shadow scale <7.50,150,7.50>translate < 116, 57,142>}

cone {
  25*y,  12.0,
  -1*y, 7.50
    open
    //pigment{Yellow} //prueba
    translate < 116, 57,142>
}

texture{semitrans scale <2,1,2>}
}


#declare techo=
union{
  object{nubes}
  object{nubes2}
}

#declare final=
difference{
  object{techo}
  object {tunel}
}

object {final}


#declare gente=
box {
  <-1, -1, 0>  
  < 1,  1,  0.010>   
  
  pigment{
  
image_map {
  png "gentio.png" 
  map_type 0        
  interpolate 0     
  once           
  
} 

  
  
  }
  
  finish{ambient 0.3 diffuse 0.4}
  scale <13,4.35,0.010>                          
  
  
}

object { gente scale <2,1.5,1>rotate 45*y translate <95,13.35,112>}


object { gente 

translate <88,12,134>}

