// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

// Persistence of Vision Ray Tracer Scene Description File
// File: mg_led01.inc
// Vers: 3.5
// Desc: archivo para mg_led.pov
// Date:
// Auth: Marjorie Graterol

//from medidas
#declare km = 1000;
#declare mt = 1;
#declare cm = .1;
#declare mm = .01;
#declare in = 2.54*mm;
#declare ft = 12*in;



//ejes
#declare ejes=
union{


cylinder {  -2*y*km,  10*y*km, 0.05  pigment {Green} finish {phong 0.6}  translate <0,0,0> }
cylinder {   -100*x*km,  100*x*km, 0.05  pigment {Red} finish {phong 0.6}  translate <0,0,0> }
cylinder {   -100*z*km,  100*z*km, 0.05  pigment {Blue} finish {phong 0.6}  translate <0,0,0> }
//3*3*3

// 
sphere { 0,  0.25 pigment {Green}translate <0,3,0>}
sphere { 0,  0.25 pigment {Red}translate <-3,0,0>}
sphere { 0,  0.25 pigment {Red}translate <3,0,0>}
sphere { 0,  0.25 pigment {Blue}translate <0,0,-3>}
sphere { 0,  0.25 pigment {Blue}translate <0,0,3>}


sphere { 0,  0.25 pigment {Green}translate <0,10,0>}
sphere { 0,  0.25 pigment {Red}translate <-10,0,0>}
sphere { 0,  0.25 pigment {Red}translate <10,0,0>}
sphere { 0,  0.25 pigment {Blue}translate <0,0,-10>}
sphere { 0,  0.25 pigment {Blue}translate <0,0,10>}

sphere { 0,  0.25 pigment {Green}translate <0,50,0>}
sphere { 0,  0.25 pigment {Red}translate <-50,0,0>}
sphere { 0,  0.25 pigment {Red}translate <50,0,0>}
sphere { 0,  0.25 pigment {Blue}translate <0,0,-50>}
sphere { 0,  0.25 pigment {Blue}translate <0,0,50>}
}

//termina medidas

//Luces -Lights

#declare luces=
union{
light_source
{
  0*x 
  color   Copper//
  
  fade_power 1
  fade_distance 25//50 30 100
  translate <3, 25, -20>// <3, 15, -20><10, 15, -20><-20, 15, -20>
}  

light_source
{
  0*x 
  color  Wheat //
  
  fade_power 10
  fade_distance 10//30 100
  translate <5,24,7>  //<5,14,7>
}

light_source
{
  0*x 
  color Flesh// 
  translate <-4, 30, -20>//
  fade_power 1//
  fade_distance 25//
} 


}  



//Pigmentos  -Pigments

#declare vd2= color red		0.2	  green 0.301960784 	blue 0.160784314;
#declare vd12= color red	0.564705882		green 0.592156863	blue 0.219607843;
#declare Ocre= color rgb <0.702,0.580,0.000>;
#declare VinoTinto=color rgb <0.459,0.200,0.129>;
#declare Carton= color  rgb <0.72266, 0.66016, 0.60156>;
#declare MarronOscuro=  color rgb <0.28516, 0.21484, 0.17188>;
#declare  HumoClaro= color rgb <0.92578, 0.94141, 0.92969>;
#declare Guayaba= color  rgb <0.86719, 0.66016, 0.52734>;
#declare Malva=color rgbf <0.690,0.588,0.471,0.500>;

//Texturas  -Textures
// Constants from file "kashmir.inc"
#declare skin3 = texture {
  pigment {
    crackle
    color_map {
      [0.5 Flesh]
      [1.0 NewTan]
    }
  }
  normal {
    crackle 0.1
    scale 0.05
  }
  finish {
    Phong_Dull
  }
}
#declare skin4 = texture {
  pigment {
    crackle
    color_map {
      [0.5 Bronze]
      [1.0 NewTan]
    }
  }
  normal {
    crackle 0.1
    scale 0.05
  }
  finish {
    Phong_Dull
  }
} 


#declare culebra = texture {
  pigment {
    rgb <0.4549,0.5961,0.4118>
  }
  normal {
    agate 
    turbulence 0.5
    lambda 2
    omega 0.5
    octaves 3
    frequency 1
  }
  finish {
    ambient 0.2
    diffuse 0.2
    metallic
    reflection rgb <0.5, 0.35,0.5>
    crand 1
  }
}
texture {
  pigment {
    spiral2 12
    frequency 2
    scale 3
    rotate <0,45,45>
  }
  normal {
    bumps 0.7
  }
}
texture {
  pigment {
    spiral2 12
    frequency 2
    scale 3
    rotate -45*y
  }
  normal {
    bumps 0.7
  }
}
texture {
  pigment {
    Gold filter 0.5
  }
  normal {
    bumps 0.7 bump_size 15
  }
  finish {
    phong 0.9
  }
  scale 0.5
  rotate 0.75*y
}

#declare densidad = seed(120);
#declare estuco3=
texture{
pigment{

gradient y
turbulence rand(densidad)


color_map{
      
   [0.5 Carton filter 0.8][0.7 Ocre filter 0.8]
   [0.8 Ocre filter 0.7][1.0 Carton filter 0.7 ]
   }
}

normal {granite 0.2 turbulence 0.2 frequency rand(densidad)}
finish {Dull}

}



#declare ladrillo=
texture{
pigment{

agate
turbulence 0.02

color_map
{
  
  [  0.1  color NewTan]
  [  0.3  color Guayaba]
  [  0.5  color Silver]
  [  0.7  color Malva]
  [  1.0  color VLightGray]
} 

}

normal {agate  0.05 turbulence 0.05 }
finish {crand 0.002 ambient 0.4 diffuse 0.4}

}



#declare bos_09=

box {
  <0, 0, 0>  < 1,  1,  0.25>  

  pigment{
    image_map {
      png "foliage03.png" 
      map_type 0        
      interpolate 0     
      once           
  
    } 
  } 

  finish{
    ambient 1 
    diffuse 0
  } 
no_shadow  
translate <0,0,0>
}