// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare monte2 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.006425, 0.2617, 0.0>, 1.2456 }
		cylinder { <-0.006425, 0.2617, 0.0>, <-0.01927, 0.5232, 0.0>, 1.2456 }
		cylinder { <-0.01927, 0.5232, 0.0>, <-0.03853, 0.7843, 0.0>, 1.2456 }
		cylinder { <-0.03853, 0.7843, 0.0>, <-0.06419, 1.04486, 0.0>, 1.2456 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // internode
		cylinder { <-0.06419, 1.04486, 0.0>, <-0.07867, 1.1653, -0.008565>, 0.5788 }
		cylinder { <-0.07867, 1.1653, -0.008565>, <-0.09562, 1.2846, -0.02564>, 0.5788 }
		cylinder { <-0.09562, 1.2846, -0.02564>, <-0.1149, 1.402, -0.05115>, 0.5788 }
		cylinder { <-0.1149, 1.402, -0.05115>, <-0.1365, 1.5168, -0.08495>, 0.5788 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1365, 1.5168, -0.08495>, <-0.9868, 15.128, 1.5236>, 0.6457 }
			cylinder { <-0.9868, 15.128, 1.5236>, <-0.1018, 27.05083, 8.2794>, 0.6457 }
			cylinder { <-0.1018, 27.05083, 8.2794>, <2.3665, 35.2393, 19.02332>, 0.6457 }
			cylinder { <2.3665, 35.2393, 19.02332>, <5.9947, 38.2887, 31.9118>, 0.6457 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <5.9947, 38.2887, 31.9118>, <6.2361, 37.7311, 33.8099>, <6.4368, 38.7059, 33.4732> }
			triangle { <6.4368, 38.7059, 33.4732>, <6.2361, 37.7311, 33.8099>, <6.5584, 37.939, 35.5042> }
			triangle { <6.4368, 38.7059, 33.4732>, <6.5584, 37.939, 35.5042>, <6.7688, 39.1507, 35.1582> }
			triangle { <6.5584, 37.939, 35.5042>, <6.7957, 39.4878, 36.8059>, <6.7688, 39.1507, 35.1582> }
			triangle { <6.4368, 38.7059, 33.4732>, <6.2139, 39.6792, 33.3552>, <5.9947, 38.2887, 31.9118> }
			triangle { <6.2139, 39.6792, 33.3552>, <6.4368, 38.7059, 33.4732>, <6.7688, 39.1507, 35.1582> }
			triangle { <6.4689, 40.09372, 35.1187>, <6.2139, 39.6792, 33.3552>, <6.7688, 39.1507, 35.1582> }
			triangle { <6.4689, 40.09372, 35.1187>, <6.7688, 39.1507, 35.1582>, <6.7957, 39.4878, 36.8059> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-0.1365, 1.5168, -0.08495>, <-0.1909, 1.7828, -0.1774>, 1.3646 }
		cylinder { <-0.1909, 1.7828, -0.1774>, <-0.2486, 2.04348, -0.2824>, 1.3646 }
		cylinder { <-0.2486, 2.04348, -0.2824>, <-0.3094, 2.298, -0.3998>, 1.3646 }
		cylinder { <-0.3094, 2.298, -0.3998>, <-0.3733, 2.5459, -0.5292>, 1.3646 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.3733, 2.5459, -0.5292>, <-2.0398, 15.6222, -1.7711>, 0.6226 }
			cylinder { <-2.0398, 15.6222, -1.7711>, <-2.1713, 28.3409, 1.9068>, 0.6226 }
			cylinder { <-2.1713, 28.3409, 1.9068>, <-0.748, 38.7656, 9.9448>, 0.6226 }
			cylinder { <-0.748, 38.7656, 9.9448>, <2.01354, 45.3093, 21.119>, 0.6226 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <2.01354, 45.3093, 21.119>, <2.1258, 45.3451, 23.03713>, <2.351, 46.1461, 22.4592> }
			triangle { <2.351, 46.1461, 22.4592>, <2.1258, 45.3451, 23.03713>, <2.3376, 46.02693, 24.5522> }
			triangle { <2.351, 46.1461, 22.4592>, <2.3376, 46.02693, 24.5522>, <2.5756, 47.04327, 23.8982> }
			triangle { <2.3376, 46.02693, 24.5522>, <2.5076, 47.8286, 25.3155>, <2.5756, 47.04327, 23.8982> }
			triangle { <2.351, 46.1461, 22.4592>, <2.1556, 47.00626, 22.05699>, <2.01354, 45.3093, 21.119> }
			triangle { <2.1556, 47.00626, 22.05699>, <2.351, 46.1461, 22.4592>, <2.5756, 47.04327, 23.8982> }
			triangle { <2.3011, 47.8976, 23.572>, <2.1556, 47.00626, 22.05699>, <2.5756, 47.04327, 23.8982> }
			triangle { <2.3011, 47.8976, 23.572>, <2.5756, 47.04327, 23.8982>, <2.5076, 47.8286, 25.3155> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-0.3733, 2.5459, -0.5292>, <-0.4501, 2.7795, -0.6401>, 1.2835 }
		cylinder { <-0.4501, 2.7795, -0.6401>, <-0.5432, 3.01227, -0.7398>, 1.2835 }
		cylinder { <-0.5432, 3.01227, -0.7398>, <-0.652, 3.2429, -0.8277>, 1.2835 }
		cylinder { <-0.652, 3.2429, -0.8277>, <-0.7761, 3.4702, -0.9032>, 1.2835 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.7761, 3.4702, -0.9032>, <-0.8961, 14.1987, -8.2427>, 0.6112 }
			cylinder { <-0.8961, 14.1987, -8.2427>, <4.8778, 21.6493, -17.1944>, 0.6112 }
			cylinder { <4.8778, 21.6493, -17.1944>, <14.9028, 23.702, -25.2113>, 0.6112 }
			cylinder { <14.9028, 23.702, -25.2113>, <26.3263, 19.7725, -30.01216>, 0.6112 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <26.3263, 19.7725, -30.01216>, <27.6876, 18.4707, -30.1199>, <27.7276, 19.3341, -30.6121> }
			triangle { <27.7276, 19.3341, -30.6121>, <27.6876, 18.4707, -30.1199>, <29.146, 17.8439, -30.5491> }
			triangle { <27.7276, 19.3341, -30.6121>, <29.146, 17.8439, -30.5491>, <29.2646, 18.8982, -31.1297> }
			triangle { <29.146, 17.8439, -30.5491>, <30.7862, 18.4787, -31.3397>, <29.2646, 18.8982, -31.1297> }
			triangle { <27.7276, 19.3341, -30.6121>, <28.03144, 20.2271, -30.7393>, <26.3263, 19.7725, -30.01216> }
			triangle { <28.03144, 20.2271, -30.7393>, <27.7276, 19.3341, -30.6121>, <29.2646, 18.8982, -31.1297> }
			triangle { <29.638, 19.7564, -31.1821>, <28.03144, 20.2271, -30.7393>, <29.2646, 18.8982, -31.1297> }
			triangle { <29.638, 19.7564, -31.1821>, <29.2646, 18.8982, -31.1297>, <30.7862, 18.4787, -31.3397> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-0.1365, 1.5168, -0.08495>, <-0.1756, 1.6584, -0.1185>, 0.7168 }
		cylinder { <-0.1756, 1.6584, -0.1185>, <-0.2265, 1.798, -0.1436>, 0.7168 }
		cylinder { <-0.2265, 1.798, -0.1436>, <-0.2888, 1.9342, -0.1599>, 0.7168 }
		cylinder { <-0.2888, 1.9342, -0.1599>, <-0.3619, 2.06576, -0.1672>, 0.7168 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.3619, 2.06576, -0.1672>, <-1.09158, 15.02058, -5.08715>, 0.6525 }
			cylinder { <-1.09158, 15.02058, -5.08715>, <4.3916, 25.1299, -12.8525>, 0.6525 }
			cylinder { <4.3916, 25.1299, -12.8525>, <14.5275, 29.5171, -21.2537>, 0.6525 }
			cylinder { <14.5275, 29.5171, -21.2537>, <26.432, 26.934, -27.9002>, 0.6525 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <26.432, 26.934, -27.9002>, <27.8523, 25.6297, -28.4814>, <27.8928, 26.6651, -28.7131> }
			triangle { <27.8928, 26.6651, -28.7131>, <27.8523, 25.6297, -28.4814>, <29.377, 25.1144, -29.1822> }
			triangle { <27.8928, 26.6651, -28.7131>, <29.377, 25.1144, -29.1822>, <29.5017, 26.3717, -29.4474> }
			triangle { <29.377, 25.1144, -29.1822>, <31.1071, 25.9983, -29.8624>, <29.5017, 26.3717, -29.4474> }
			triangle { <27.8928, 26.6651, -28.7131>, <28.2302, 27.6135, -28.5756>, <26.432, 26.934, -27.9002> }
			triangle { <28.2302, 27.6135, -28.5756>, <27.8928, 26.6651, -28.7131>, <29.5017, 26.3717, -29.4474> }
			triangle { <29.9157, 27.2606, -29.2477>, <28.2302, 27.6135, -28.5756>, <29.5017, 26.3717, -29.4474> }
			triangle { <29.9157, 27.2606, -29.2477>, <29.5017, 26.3717, -29.4474>, <31.1071, 25.9983, -29.8624> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-0.3619, 2.06576, -0.1672>, <-0.5785, 2.4219, -0.175>, 1.9835 }
		cylinder { <-0.5785, 2.4219, -0.175>, <-0.8088, 2.7694, -0.1703>, 1.9835 }
		cylinder { <-0.8088, 2.7694, -0.1703>, <-1.05222, 3.1074, -0.1531>, 1.9835 }
		cylinder { <-1.05222, 3.1074, -0.1531>, <-1.3082, 3.4351, -0.1235>, 1.9835 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.3082, 3.4351, -0.1235>, <-5.9355, 16.1171, -2.4016>, 0.6437 }
			cylinder { <-5.9355, 16.1171, -2.4016>, <-6.07922, 28.7885, -7.5835>, 0.6437 }
			cylinder { <-6.07922, 28.7885, -7.5835>, <-1.7174, 39.52, -14.8804>, 0.6437 }
			cylinder { <-1.7174, 39.52, -14.8804>, <6.4858, 46.678, -23.1814>, 0.6437 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <6.4858, 46.678, -23.1814>, <8.3044, 47.06191, -23.8837>, <7.4521, 47.5815, -24.2014> }
			triangle { <7.4521, 47.5815, -24.2014>, <8.3044, 47.06191, -23.8837>, <9.5131, 47.913, -24.786> }
			triangle { <7.4521, 47.5815, -24.2014>, <9.5131, 47.913, -24.786>, <8.5177, 48.6092, -25.1693> }
			triangle { <9.5131, 47.913, -24.786>, <9.6555, 49.6545, -25.8212>, <8.5177, 48.6092, -25.1693> }
			triangle { <7.4521, 47.5815, -24.2014>, <6.835, 48.3713, -24.2067>, <6.4858, 46.678, -23.1814> }
			triangle { <6.835, 48.3713, -24.2067>, <7.4521, 47.5815, -24.2014>, <8.5177, 48.6092, -25.1693> }
			triangle { <7.9916, 49.4433, -25.123>, <6.835, 48.3713, -24.2067>, <8.5177, 48.6092, -25.1693> }
			triangle { <7.9916, 49.4433, -25.123>, <8.5177, 48.6092, -25.1693>, <9.6555, 49.6545, -25.8212> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-1.3082, 3.4351, -0.1235>, <-1.5109, 3.7427, -0.07609>, 1.7673 }
		cylinder { <-1.5109, 3.7427, -0.07609>, <-1.6864, 4.06301, -0.00804>, 1.7673 }
		cylinder { <-1.6864, 4.06301, -0.00804>, <-1.8329, 4.3928, 0.07996>, 1.7673 }
		cylinder { <-1.8329, 4.3928, 0.07996>, <-1.949, 4.729, 0.187>, 1.7673 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.949, 4.729, 0.187>, <-10.1217, 15.6346, 1.3538>, 0.6431 }
			cylinder { <-10.1217, 15.6346, 1.3538>, <-21.09633, 23.6048, -0.4127>, 0.6431 }
			cylinder { <-21.09633, 23.6048, -0.4127>, <-33.4021, 27.5713, -4.8759>, 0.6431 }
			cylinder { <-33.4021, 27.5713, -4.8759>, <-45.3899, 27.00284, -11.4375>, 0.6431 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-45.3899, 27.00284, -11.4375>, <-46.4759, 26.3663, -12.9725>, <-46.8682, 26.9678, -12.2112> }
			triangle { <-46.8682, 26.9678, -12.2112>, <-46.4759, 26.3663, -12.9725>, <-47.8679, 26.251, -13.9937> }
			triangle { <-46.8682, 26.9678, -12.2112>, <-47.8679, 26.251, -13.9937>, <-48.3818, 27.02218, -13.1217> }
			triangle { <-47.8679, 26.251, -13.9937>, <-49.6489, 27.2001, -14.2031>, <-48.3818, 27.02218, -13.1217> }
			triangle { <-46.8682, 26.9678, -12.2112>, <-47.1721, 27.8419, -11.8285>, <-45.3899, 27.00284, -11.4375> }
			triangle { <-47.1721, 27.8419, -11.8285>, <-46.8682, 26.9678, -12.2112>, <-48.3818, 27.02218, -13.1217> }
			triangle { <-48.6793, 27.9222, -12.8493>, <-47.1721, 27.8419, -11.8285>, <-48.3818, 27.02218, -13.1217> }
			triangle { <-48.6793, 27.9222, -12.8493>, <-48.3818, 27.02218, -13.1217>, <-49.6489, 27.2001, -14.2031> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-1.949, 4.729, 0.187>, <-2.05111, 5.05195, 0.2549>, 1.6433 }
		cylinder { <-2.05111, 5.05195, 0.2549>, <-2.1462, 5.382, 0.2903>, 1.6433 }
		cylinder { <-2.1462, 5.382, 0.2903>, <-2.2336, 5.7162, 0.293>, 1.6433 }
		cylinder { <-2.2336, 5.7162, 0.293>, <-2.3123, 6.05118, 0.263>, 1.6433 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.3123, 6.05118, 0.263>, <-6.659, 18.3638, 4.5342>, 0.646 }
			cylinder { <-6.659, 18.3638, 4.5342>, <-11.4765, 27.553, 13.5391>, 0.646 }
			cylinder { <-11.4765, 27.553, 13.5391>, <-15.9382, 32.04225, 25.7324>, 0.646 }
			cylinder { <-15.9382, 32.04225, 25.7324>, <-19.2786, 31.06114, 39.02222>, 0.646 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-19.2786, 31.06114, 39.02222>, <-19.8114, 29.945, 40.5862>, <-19.6913, 30.9876, 40.6452> }
			triangle { <-19.6913, 30.9876, 40.6452>, <-19.8114, 29.945, 40.5862>, <-20.3436, 29.6235, 42.209> }
			triangle { <-19.6913, 30.9876, 40.6452>, <-20.3436, 29.6235, 42.209>, <-20.2611, 30.8938, 42.3235> }
			triangle { <-20.3436, 29.6235, 42.209>, <-21.05561, 30.6902, 43.7929>, <-20.2611, 30.8938, 42.3235> }
			triangle { <-19.6913, 30.9876, 40.6452>, <-20.03706, 31.9317, 40.6761>, <-19.2786, 31.06114, 39.02222> }
			triangle { <-20.03706, 31.9317, 40.6761>, <-19.6913, 30.9876, 40.6452>, <-20.2611, 30.8938, 42.3235> }
			triangle { <-20.7026, 31.7792, 42.3741>, <-20.03706, 31.9317, 40.6761>, <-20.2611, 30.8938, 42.3235> }
			triangle { <-20.7026, 31.7792, 42.3741>, <-20.2611, 30.8938, 42.3235>, <-21.05561, 30.6902, 43.7929> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-2.3123, 6.05118, 0.263>, <-2.3924, 6.2857, 0.2424>, 1.1834 }
		cylinder { <-2.3924, 6.2857, 0.2424>, <-2.4952, 6.5114, 0.2229>, 1.1834 }
		cylinder { <-2.4952, 6.5114, 0.2229>, <-2.6197, 6.7259, 0.2049>, 1.1834 }
		cylinder { <-2.6197, 6.7259, 0.2049>, <-2.7648, 6.9273, 0.1885>, 1.1834 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.7648, 6.9273, 0.1885>, <-4.2359, 20.5467, -1.06195>, 0.6468 }
			cylinder { <-4.2359, 20.5467, -1.06195>, <1.2242, 33.1085, -2.3287>, 0.6468 }
			cylinder { <1.2242, 33.1085, -2.3287>, <12.1971, 41.3487, -3.2826>, 0.6468 }
			cylinder { <12.1971, 41.3487, -3.2826>, <25.8317, 43.1264, -3.6758>, 0.6468 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <25.8317, 43.1264, -3.6758>, <27.6728, 42.355, -3.646>, <27.489, 43.3889, -3.7166> }
			triangle { <27.489, 43.3889, -3.7166>, <27.6728, 42.355, -3.646>, <29.4117, 42.3742, -3.586> }
			triangle { <27.489, 43.3889, -3.7166>, <29.4117, 42.3742, -3.586>, <29.2453, 43.6426, -3.6219> }
			triangle { <29.4117, 42.3742, -3.586>, <30.888, 43.745, -3.2615>, <29.2453, 43.6426, -3.6219> }
			triangle { <27.489, 43.3889, -3.7166>, <27.4256, 44.3195, -3.3367>, <25.8317, 43.1264, -3.6758> }
			triangle { <27.4256, 44.3195, -3.3367>, <27.489, 43.3889, -3.7166>, <29.2453, 43.6426, -3.6219> }
			triangle { <29.2384, 44.5196, -3.1585>, <27.4256, 44.3195, -3.3367>, <29.2453, 43.6426, -3.6219> }
			triangle { <29.2384, 44.5196, -3.1585>, <29.2453, 43.6426, -3.6219>, <30.888, 43.745, -3.2615> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-2.7648, 6.9273, 0.1885>, <-2.9375, 7.1809, 0.1893>, 1.4598 }
		cylinder { <-2.9375, 7.1809, 0.1893>, <-3.1031, 7.4382, 0.2113>, 1.4598 }
		cylinder { <-3.1031, 7.4382, 0.2113>, <-3.2608, 7.698, 0.2542>, 1.4598 }
		cylinder { <-3.2608, 7.698, 0.2542>, <-3.4095, 7.9586, 0.3179>, 1.4598 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.4095, 7.9586, 0.3179>, <-11.9892, 18.238, -3.09278>, 0.6497 }
			cylinder { <-11.9892, 18.238, -3.09278>, <-20.4223, 24.6307, -11.9767>, 0.6497 }
			cylinder { <-20.4223, 24.6307, -11.9767>, <-26.7174, 25.627, -24.2359>, 0.6497 }
			cylinder { <-26.7174, 25.627, -24.2359>, <-29.3878, 20.9916, -36.9753>, 0.6497 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-29.3878, 20.9916, -36.9753>, <-29.0826, 19.6422, -38.4269>, <-29.7343, 20.4669, -38.5396> }
			triangle { <-29.7343, 20.4669, -38.5396>, <-29.0826, 19.6422, -38.4269>, <-29.2115, 18.9497, -40.02652> }
			triangle { <-29.7343, 20.4669, -38.5396>, <-29.2115, 18.9497, -40.02652>, <-29.9758, 19.962, -40.2346> }
			triangle { <-29.2115, 18.9497, -40.02652>, <-29.9029, 19.5254, -41.8681>, <-29.9758, 19.962, -40.2346> }
			triangle { <-29.7343, 20.4669, -38.5396>, <-29.9735, 21.3904, -38.8762>, <-29.3878, 20.9916, -36.9753> }
			triangle { <-29.9735, 21.3904, -38.8762>, <-29.7343, 20.4669, -38.5396>, <-29.9758, 19.962, -40.2346> }
			triangle { <-30.1214, 20.8633, -40.6336>, <-29.9735, 21.3904, -38.8762>, <-29.9758, 19.962, -40.2346> }
			triangle { <-30.1214, 20.8633, -40.6336>, <-29.9758, 19.962, -40.2346>, <-29.9029, 19.5254, -41.8681> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-3.4095, 7.9586, 0.3179>, <-3.5557, 8.2538, 0.3722>, 1.5883 }
		cylinder { <-3.5557, 8.2538, 0.3722>, <-3.6855, 8.5589, 0.4112>, 1.5883 }
		cylinder { <-3.6855, 8.5589, 0.4112>, <-3.7981, 8.8723, 0.4346>, 1.5883 }
		cylinder { <-3.7981, 8.8723, 0.4346>, <-3.8929, 9.1923, 0.4425>, 1.5883 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.8929, 9.1923, 0.4425>, <-12.1189, 19.3329, 4.8725>, 0.6483 }
			cylinder { <-12.1189, 19.3329, 4.8725>, <-22.7125, 24.00255, 12.3624>, 0.6483 }
			cylinder { <-22.7125, 24.00255, 12.3624>, <-33.1717, 22.09834, 21.1433>, 0.6483 }
			cylinder { <-33.1717, 22.09834, 21.1433>, <-41.0267, 14.07001, 29.1416>, 0.6483 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-41.0267, 14.07001, 29.1416>, <-41.5191, 12.2492, 29.8102>, <-42.01411, 13.1264, 30.1242> }
			triangle { <-42.01411, 13.1264, 30.1242>, <-41.5191, 12.2492, 29.8102>, <-42.4608, 11.06101, 30.6727> }
			triangle { <-42.01411, 13.1264, 30.1242>, <-42.4608, 11.06101, 30.6727>, <-43.129, 12.08943, 31.04874> }
			triangle { <-42.4608, 11.06101, 30.6727>, <-44.2541, 10.9844, 31.6535>, <-43.129, 12.08943, 31.04874> }
			triangle { <-42.01411, 13.1264, 30.1242>, <-42.7806, 13.7833, 30.1112>, <-41.0267, 14.07001, 29.1416> }
			triangle { <-42.7806, 13.7833, 30.1112>, <-42.01411, 13.1264, 30.1242>, <-43.129, 12.08943, 31.04874> }
			triangle { <-43.9424, 12.6573, 30.9811>, <-42.7806, 13.7833, 30.1112>, <-43.129, 12.08943, 31.04874> }
			triangle { <-43.9424, 12.6573, 30.9811>, <-43.129, 12.08943, 31.04874>, <-44.2541, 10.9844, 31.6535> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-3.8929, 9.1923, 0.4425>, <-4.01199, 9.519, 0.4365>, 1.6548 }
		cylinder { <-4.01199, 9.519, 0.4365>, <-4.1506, 9.8373, 0.4164>, 1.6548 }
		cylinder { <-4.1506, 9.8373, 0.4164>, <-4.3082, 10.1455, 0.3824>, 1.6548 }
		cylinder { <-4.3082, 10.1455, 0.3824>, <-4.4839, 10.4419, 0.3345>, 1.6548 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.4839, 10.4419, 0.3345>, <-6.9749, 23.7262, 1.5678>, 0.6382 }
			cylinder { <-6.9749, 23.7262, 1.5678>, <-4.6765, 36.4508, 5.6913>, 0.6382 }
			cylinder { <-4.6765, 36.4508, 5.6913>, <2.01675, 46.4322, 11.9977>, 0.6382 }
			cylinder { <2.01675, 46.4322, 11.9977>, <11.9566, 51.958, 19.4048>, 0.6382 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <11.9566, 51.958, 19.4048>, <13.3946, 51.7643, 20.737>, <13.1534, 52.6739, 20.2979> }
			triangle { <13.1534, 52.6739, 20.2979>, <13.3946, 51.7643, 20.737>, <14.6216, 52.2863, 21.8184> }
			triangle { <13.1534, 52.6739, 20.2979>, <14.6216, 52.2863, 21.8184>, <14.3361, 53.4246, 21.3524> }
			triangle { <14.6216, 52.2863, 21.8184>, <15.2861, 54.02974, 22.5751>, <14.3361, 53.4246, 21.3524> }
			triangle { <13.1534, 52.6739, 20.2979>, <12.7237, 53.5699, 20.2904>, <11.9566, 51.958, 19.4048> }
			triangle { <12.7237, 53.5699, 20.2904>, <13.1534, 52.6739, 20.2979>, <14.3361, 53.4246, 21.3524> }
			triangle { <13.9014, 54.2955, 21.4546>, <12.7237, 53.5699, 20.2904>, <14.3361, 53.4246, 21.3524> }
			triangle { <13.9014, 54.2955, 21.4546>, <14.3361, 53.4246, 21.3524>, <15.2861, 54.02974, 22.5751> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-4.4839, 10.4419, 0.3345>, <-4.6726, 10.7419, 0.319>, 1.6881 }
		cylinder { <-4.6726, 10.7419, 0.319>, <-4.8693, 11.03675, 0.3371>, 1.6881 }
		cylinder { <-4.8693, 11.03675, 0.3371>, <-5.07183, 11.3235, 0.3885>, 1.6881 }
		cylinder { <-5.07183, 11.3235, 0.3885>, <-5.2783, 11.5994, 0.4727>, 1.6881 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.2783, 11.5994, 0.4727>, <-12.137, 22.9984, -1.05717>, 0.6296 }
			cylinder { <-12.137, 22.9984, -1.05717>, <-17.1414, 33.8543, -7.09247>, 0.6296 }
			cylinder { <-17.1414, 33.8543, -7.09247>, <-19.6208, 42.7123, -16.8242>, 0.6296 }
			cylinder { <-19.6208, 42.7123, -16.8242>, <-19.243, 48.3852, -28.9483>, 0.6296 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-19.243, 48.3852, -28.9483>, <-18.2728, 48.7891, -30.5832>, <-19.235, 49.09999, -30.4177> }
			triangle { <-19.235, 49.09999, -30.4177>, <-18.2728, 48.7891, -30.5832>, <-17.9992, 49.5118, -32.0907> }
			triangle { <-19.235, 49.09999, -30.4177>, <-17.9992, 49.5118, -32.0907>, <-19.1505, 49.9557, -31.9188> }
			triangle { <-17.9992, 49.5118, -32.0907>, <-18.8459, 50.9135, -33.215>, <-19.1505, 49.9557, -31.9188> }
			triangle { <-19.235, 49.09999, -30.4177>, <-19.9102, 49.7685, -30.176>, <-19.243, 48.3852, -28.9483> }
			triangle { <-19.9102, 49.7685, -30.176>, <-19.235, 49.09999, -30.4177>, <-19.1505, 49.9557, -31.9188> }
			triangle { <-19.737, 50.6892, -31.6941>, <-19.9102, 49.7685, -30.176>, <-19.1505, 49.9557, -31.9188> }
			triangle { <-19.737, 50.6892, -31.6941>, <-19.1505, 49.9557, -31.9188>, <-18.8459, 50.9135, -33.215> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-5.2783, 11.5994, 0.4727>, <-5.4499, 11.8848, 0.5533>, 1.63 }
		cylinder { <-5.4499, 11.8848, 0.5533>, <-5.5921, 12.1863, 0.6322>, 1.63 }
		cylinder { <-5.5921, 12.1863, 0.6322>, <-5.7035, 12.5011, 0.7088>, 1.63 }
		cylinder { <-5.7035, 12.5011, 0.7088>, <-5.783, 12.8261, 0.7824>, 1.63 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.783, 12.8261, 0.7824>, <-13.5686, 23.2295, 3.9594>, 0.629 }
			cylinder { <-13.5686, 23.2295, 3.9594>, <-24.8502, 29.7613, 6.9595>, 0.629 }
			cylinder { <-24.8502, 29.7613, 6.9595>, <-37.9102, 31.4271, 9.326>, 0.629 }
			cylinder { <-37.9102, 31.4271, 9.326>, <-50.7603, 27.9734, 10.6986>, 0.629 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-50.7603, 27.9734, 10.6986>, <-52.2329, 26.7848, 10.2648>, <-52.3364, 27.5923, 10.8852> }
			triangle { <-52.3364, 27.5923, 10.8852>, <-52.2329, 26.7848, 10.2648>, <-53.8359, 26.2437, 10.2378> }
			triangle { <-52.3364, 27.5923, 10.8852>, <-53.8359, 26.2437, 10.2378>, <-54.02682, 27.2402, 10.9585> }
			triangle { <-53.8359, 26.2437, 10.2378>, <-55.6234, 26.9478, 10.7348>, <-54.02682, 27.2402, 10.9585> }
			triangle { <-52.3364, 27.5923, 10.8852>, <-52.6089, 28.511, 11.08755>, <-50.7603, 27.9734, 10.6986> }
			triangle { <-52.6089, 28.511, 11.08755>, <-52.3364, 27.5923, 10.8852>, <-54.02682, 27.2402, 10.9585> }
			triangle { <-54.3522, 28.142, 11.06481>, <-52.6089, 28.511, 11.08755>, <-54.02682, 27.2402, 10.9585> }
			triangle { <-54.3522, 28.142, 11.06481>, <-54.02682, 27.2402, 10.9585>, <-55.6234, 26.9478, 10.7348> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-5.783, 12.8261, 0.7824>, <-5.8612, 13.09977, 0.8183>, 1.3646 }
		cylinder { <-5.8612, 13.09977, 0.8183>, <-5.9502, 13.3722, 0.8283>, 1.3646 }
		cylinder { <-5.9502, 13.3722, 0.8283>, <-6.04937, 13.6409, 0.8123>, 1.3646 }
		cylinder { <-6.04937, 13.6409, 0.8123>, <-6.1575, 13.9032, 0.7704>, 1.3646 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.1575, 13.9032, 0.7704>, <-9.09123, 26.4288, 3.9029>, 0.6226 }
			cylinder { <-9.09123, 26.4288, 3.9029>, <-9.4628, 37.2212, 11.5643>, 0.6226 }
			cylinder { <-9.4628, 37.2212, 11.5643>, <-7.2086, 44.4285, 22.4401>, 0.6226 }
			cylinder { <-7.2086, 44.4285, 22.4401>, <-2.7153, 46.8142, 34.6642>, 0.6226 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-2.7153, 46.8142, 34.6642>, <-2.1119, 46.1609, 36.3677>, <-2.1789, 47.1483, 36.151> }
			triangle { <-2.1789, 47.1483, 36.151>, <-2.1119, 46.1609, 36.3677>, <-1.624, 46.2596, 37.9669> }
			triangle { <-2.1789, 47.1483, 36.151>, <-1.624, 46.2596, 37.9669>, <-1.7337, 47.4707, 37.7708> }
			triangle { <-1.624, 46.2596, 37.9669>, <-1.5545, 47.627, 39.3751>, <-1.7337, 47.4707, 37.7708> }
			triangle { <-2.1789, 47.1483, 36.151>, <-2.6096, 48.01597, 36.1886>, <-2.7153, 46.8142, 34.6642> }
			triangle { <-2.6096, 48.01597, 36.1886>, <-2.1789, 47.1483, 36.151>, <-1.7337, 47.4707, 37.7708> }
			triangle { <-2.2188, 48.2848, 37.8875>, <-2.6096, 48.01597, 36.1886>, <-1.7337, 47.4707, 37.7708> }
			triangle { <-2.2188, 48.2848, 37.8875>, <-1.7337, 47.4707, 37.7708>, <-1.5545, 47.627, 39.3751> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-6.1575, 13.9032, 0.7704>, <-6.2785, 14.1433, 0.7478>, 1.2835 }
		cylinder { <-6.2785, 14.1433, 0.7478>, <-6.4177, 14.3743, 0.7423>, 1.2835 }
		cylinder { <-6.4177, 14.3743, 0.7423>, <-6.5737, 14.5941, 0.7538>, 1.2835 }
		cylinder { <-6.5737, 14.5941, 0.7538>, <-6.745, 14.8005, 0.7823>, 1.2835 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.745, 14.8005, 0.7823>, <-11.884, 26.6197, -0.9151>, 0.6112 }
			cylinder { <-11.884, 26.6197, -0.9151>, <-13.2187, 38.7264, -5.457>, 0.6112 }
			cylinder { <-13.2187, 38.7264, -5.457>, <-10.5701, 49.4983, -12.2347>, 0.6112 }
			cylinder { <-10.5701, 49.4983, -12.2347>, <-4.2933, 57.4917, -20.3397>, 0.6112 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-4.2933, 57.4917, -20.3397>, <-2.6797, 58.09357, -21.1102>, <-3.5639, 58.4915, -21.3318> }
			triangle { <-3.5639, 58.4915, -21.3318>, <-2.6797, 58.09357, -21.1102>, <-1.7081, 59.0691, -22.00934> }
			triangle { <-3.5639, 58.4915, -21.3318>, <-1.7081, 59.0691, -22.00934>, <-2.7521, 59.6183, -22.2761> }
			triangle { <-1.7081, 59.0691, -22.00934>, <-1.8518, 60.7598, -22.9254>, <-2.7521, 59.6183, -22.2761> }
			triangle { <-3.5639, 58.4915, -21.3318>, <-4.2363, 59.1615, -21.2623>, <-4.2933, 57.4917, -20.3397> }
			triangle { <-4.2363, 59.1615, -21.2623>, <-3.5639, 58.4915, -21.3318>, <-2.7521, 59.6183, -22.2761> }
			triangle { <-3.3403, 60.3391, -22.162>, <-4.2363, 59.1615, -21.2623>, <-2.7521, 59.6183, -22.2761> }
			triangle { <-3.3403, 60.3391, -22.162>, <-2.7521, 59.6183, -22.2761>, <-1.8518, 60.7598, -22.9254> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-6.745, 14.8005, 0.7823>, <-6.9114, 15.02855, 0.8239>, 1.3574 }
		cylinder { <-6.9114, 15.02855, 0.8239>, <-7.06217, 15.2649, 0.8766>, 1.3574 }
		cylinder { <-7.06217, 15.2649, 0.8766>, <-7.1964, 15.5085, 0.9401>, 1.3574 }
		cylinder { <-7.1964, 15.5085, 0.9401>, <-7.3134, 15.758, 1.01424>, 1.3574 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.3134, 15.758, 1.01424>, <-17.1777, 23.6298, 0.6344>, 0.5937 }
			cylinder { <-17.1777, 23.6298, 0.6344>, <-28.9205, 26.09519, -3.2951>, 0.5937 }
			cylinder { <-28.9205, 26.09519, -3.2951>, <-39.2006, 22.4525, -9.6563>, 0.5937 }
			cylinder { <-39.2006, 22.4525, -9.6563>, <-45.09286, 13.7384, -16.6391>, 0.5937 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-45.09286, 13.7384, -16.6391>, <-45.1099, 12.07844, -17.4151>, <-45.8399, 12.7049, -17.5035> }
			triangle { <-45.8399, 12.7049, -17.5035>, <-45.1099, 12.07844, -17.4151>, <-45.6599, 10.898, -18.3397> }
			triangle { <-45.8399, 12.7049, -17.5035>, <-45.6599, 10.898, -18.3397>, <-46.552, 11.6417, -18.5151> }
			triangle { <-45.6599, 10.898, -18.3397>, <-46.9975, 10.6673, -19.6303>, <-46.552, 11.6417, -18.5151> }
			triangle { <-45.8399, 12.7049, -17.5035>, <-46.3317, 13.341, -17.9597>, <-45.09286, 13.7384, -16.6391> }
			triangle { <-46.3317, 13.341, -17.9597>, <-45.8399, 12.7049, -17.5035>, <-46.552, 11.6417, -18.5151> }
			triangle { <-46.9853, 12.2385, -19.04903>, <-46.3317, 13.341, -17.9597>, <-46.552, 11.6417, -18.5151> }
			triangle { <-46.9853, 12.2385, -19.04903>, <-46.552, 11.6417, -18.5151>, <-46.9975, 10.6673, -19.6303> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.3134, 15.758, 1.01424>, <-7.4193, 15.9983, 1.05858>, 1.2675 }
		cylinder { <-7.4193, 15.9983, 1.05858>, <-7.5209, 16.2439, 1.07766>, 1.2675 }
		cylinder { <-7.5209, 16.2439, 1.07766>, <-7.6171, 16.4922, 1.0713>, 1.2675 }
		cylinder { <-7.6171, 16.4922, 1.0713>, <-7.7071, 16.741, 1.03957>, 1.2675 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.7071, 16.741, 1.03957>, <-12.7374, 26.8046, 5.2477>, 0.5648 }
			cylinder { <-12.7374, 26.8046, 5.2477>, <-17.5533, 33.3399, 14.1013>, 0.5648 }
			cylinder { <-17.5533, 33.3399, 14.1013>, <-21.0176, 34.8035, 25.5095>, 0.5648 }
			cylinder { <-21.0176, 34.8035, 25.5095>, <-22.3121, 30.8498, 36.7781>, 0.5648 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-22.3121, 30.8498, 36.7781>, <-22.144, 29.5749, 37.9552>, <-22.4935, 30.3996, 38.1611> }
			triangle { <-22.4935, 30.3996, 38.1611>, <-22.144, 29.5749, 37.9552>, <-22.3107, 28.8874, 39.3> }
			triangle { <-22.4935, 30.3996, 38.1611>, <-22.3107, 28.8874, 39.3>, <-22.7824, 29.8591, 39.5868> }
			triangle { <-22.3107, 28.8874, 39.3>, <-23.2084, 29.1675, 40.8136>, <-22.7824, 29.8591, 39.5868> }
			triangle { <-22.4935, 30.3996, 38.1611>, <-23.1572, 30.9536, 38.3226>, <-22.3121, 30.8498, 36.7781> }
			triangle { <-23.1572, 30.9536, 38.3226>, <-22.4935, 30.3996, 38.1611>, <-22.7824, 29.8591, 39.5868> }
			triangle { <-23.4927, 30.3253, 39.7555>, <-23.1572, 30.9536, 38.3226>, <-22.7824, 29.8591, 39.5868> }
			triangle { <-23.4927, 30.3253, 39.7555>, <-22.7824, 29.8591, 39.5868>, <-23.2084, 29.1675, 40.8136> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.7071, 16.741, 1.03957>, <-7.8038, 16.957, 1.01234>, 1.1332 }
		cylinder { <-7.8038, 16.957, 1.01234>, <-7.9163, 17.1653, 0.9864>, 1.1332 }
		cylinder { <-7.9163, 17.1653, 0.9864>, <-8.04392, 17.3649, 0.9619>, 1.1332 }
		cylinder { <-8.04392, 17.3649, 0.9619>, <-8.1859, 17.5547, 0.9389>, 1.1332 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.1859, 17.5547, 0.9389>, <-10.5882, 31.2092, -0.8477>, 0.6573 }
			cylinder { <-10.5882, 31.2092, -0.8477>, <-6.5435, 44.462, -2.6939>, 0.6573 }
			cylinder { <-6.5435, 44.462, -2.6939>, <3.08456, 54.4832, -4.2052>, 0.6573 }
			cylinder { <3.08456, 54.4832, -4.2052>, <16.2398, 59.1326, -5.05901>, 0.6573 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <16.2398, 59.1326, -5.05901>, <18.2326, 58.7947, -4.8842>, <17.8285, 59.7442, -5.1653> }
			triangle { <17.8285, 59.7442, -5.1653>, <18.2326, 58.7947, -4.8842>, <19.9513, 59.2083, -4.8409> }
			triangle { <17.8285, 59.7442, -5.1653>, <19.9513, 59.2083, -4.8409>, <19.5123, 60.3964, -5.1357> }
			triangle { <19.9513, 59.2083, -4.8409>, <21.1062, 60.9304, -4.8098>, <19.5123, 60.3964, -5.1357> }
			triangle { <17.8285, 59.7442, -5.1653>, <17.5493, 60.7109, -4.9777>, <16.2398, 59.1326, -5.05901> }
			triangle { <17.5493, 60.7109, -4.9777>, <17.8285, 59.7442, -5.1653>, <19.5123, 60.3964, -5.1357> }
			triangle { <19.2976, 61.3403, -4.8544>, <17.5493, 60.7109, -4.9777>, <19.5123, 60.3964, -5.1357> }
			triangle { <19.2976, 61.3403, -4.8544>, <19.5123, 60.3964, -5.1357>, <21.1062, 60.9304, -4.8098> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.1859, 17.5547, 0.9389>, <-8.305, 17.7268, 0.9378>, 0.9955 }
		cylinder { <-8.305, 17.7268, 0.9378>, <-8.4172, 17.9025, 0.9556>, 0.9955 }
		cylinder { <-8.4172, 17.9025, 0.9556>, <-8.5214, 18.08025, 0.9923>, 0.9955 }
		cylinder { <-8.5214, 18.08025, 0.9923>, <-8.6167, 18.2581, 1.04752>, 0.9955 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.6167, 18.2581, 1.04752>, <-16.8124, 28.7923, -0.8583>, 0.6339 }
			cylinder { <-16.8124, 28.7923, -0.8583>, <-25.4897, 36.3735, -7.8585>, 0.6339 }
			cylinder { <-25.4897, 36.3735, -7.8585>, <-32.9823, 39.5458, -18.6088>, 0.6339 }
			cylinder { <-32.9823, 39.5458, -18.6088>, <-37.8516, 37.7002, -31.04486>, 0.6339 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-37.8516, 37.7002, -31.04486>, <-37.7734, 36.7833, -32.7717>, <-38.47, 37.5135, -32.5578> }
			triangle { <-38.47, 37.5135, -32.5578>, <-37.7734, 36.7833, -32.7717>, <-38.1813, 36.4705, -34.3978> }
			triangle { <-38.47, 37.5135, -32.5578>, <-38.1813, 36.4705, -34.3978>, <-39.01686, 37.3862, -34.2066> }
			triangle { <-38.1813, 36.4705, -34.3978>, <-39.2561, 37.345, -35.84>, <-39.01686, 37.3862, -34.2066> }
			triangle { <-38.47, 37.5135, -32.5578>, <-38.8266, 38.4328, -32.6041>, <-37.8516, 37.7002, -31.04486> }
			triangle { <-38.8266, 38.4328, -32.6041>, <-38.47, 37.5135, -32.5578>, <-39.01686, 37.3862, -34.2066> }
			triangle { <-39.2957, 38.3089, -34.3333>, <-38.8266, 38.4328, -32.6041>, <-39.01686, 37.3862, -34.2066> }
			triangle { <-39.2957, 38.3089, -34.3333>, <-39.01686, 37.3862, -34.2066>, <-39.2561, 37.345, -35.84> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.6167, 18.2581, 1.04752>, <-8.6858, 18.4149, 1.08281>, 0.8322 }
		cylinder { <-8.6858, 18.4149, 1.08281>, <-8.7435, 18.5782, 1.1069>, 0.8322 }
		cylinder { <-8.7435, 18.5782, 1.1069>, <-8.7895, 18.7465, 1.1196>, 0.8322 }
		cylinder { <-8.7895, 18.7465, 1.1196>, <-8.8231, 18.9182, 1.1209>, 0.8322 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.8231, 18.9182, 1.1209>, <-14.1403, 29.3272, 4.1179>, 0.5674 }
			cylinder { <-14.1403, 29.3272, 4.1179>, <-21.741, 36.9093, 9.6264>, 0.5674 }
			cylinder { <-21.741, 36.9093, 9.6264>, <-30.6067, 40.6485, 16.908>, 0.5674 }
			cylinder { <-30.6067, 40.6485, 16.908>, <-39.5492, 40.04351, 24.9869>, 0.5674 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-39.5492, 40.04351, 24.9869>, <-40.926, 39.1948, 25.6587>, <-40.6342, 40.00909, 25.9816> }
			triangle { <-40.6342, 40.00909, 25.9816>, <-40.926, 39.1948, 25.6587>, <-42.1507, 38.9939, 26.5473> }
			triangle { <-40.6342, 40.00909, 25.9816>, <-42.1507, 38.9939, 26.5473>, <-41.8602, 40.00301, 26.9445> }
			triangle { <-42.1507, 38.9939, 26.5473>, <-43.1679, 39.9892, 27.6331>, <-41.8602, 40.00301, 26.9445> }
			triangle { <-40.6342, 40.00909, 25.9816>, <-40.677, 40.8879, 26.06112>, <-39.5492, 40.04351, 24.9869> }
			triangle { <-40.677, 40.8879, 26.06112>, <-40.6342, 40.00909, 25.9816>, <-41.8602, 40.00301, 26.9445> }
			triangle { <-41.9928, 40.862, 26.9841>, <-40.677, 40.8879, 26.06112>, <-41.8602, 40.00301, 26.9445> }
			triangle { <-41.9928, 40.862, 26.9841>, <-41.8602, 40.00301, 26.9445>, <-43.1679, 39.9892, 27.6331> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.8231, 18.9182, 1.1209>, <-8.8671, 19.08587, 1.1155>, 0.825 }
		cylinder { <-8.8671, 19.08587, 1.1155>, <-8.9216, 19.25, 1.1036>, 0.825 }
		cylinder { <-8.9216, 19.25, 1.1036>, <-8.9861, 19.4099, 1.08535>, 0.825 }
		cylinder { <-8.9861, 19.4099, 1.08535>, <-9.06052, 19.5647, 1.06066>, 0.825 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.06052, 19.5647, 1.06066>, <-9.9265, 29.3729, 1.7493>, 0.4641 }
			cylinder { <-9.9265, 29.3729, 1.7493>, <-7.2785, 38.5005, 4.4138>, 0.4641 }
			cylinder { <-7.2785, 38.5005, 4.4138>, <-1.5707, 45.3814, 8.5971>, 0.4641 }
			cylinder { <-1.5707, 45.3814, 8.5971>, <6.2174, 48.835, 13.5813>, 0.4641 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <6.2174, 48.835, 13.5813>, <7.3059, 48.6118, 14.4854>, <7.1577, 49.2876, 14.1826> }
			triangle { <7.1577, 49.2876, 14.1826>, <7.3059, 48.6118, 14.4854>, <8.2665, 48.9204, 15.2209> }
			triangle { <7.1577, 49.2876, 14.1826>, <8.2665, 48.9204, 15.2209>, <8.09638, 49.7646, 14.902> }
			triangle { <8.2665, 48.9204, 15.2209>, <8.8664, 50.1458, 15.7525>, <8.09638, 49.7646, 14.902> }
			triangle { <7.1577, 49.2876, 14.1826>, <6.8905, 49.9588, 14.2011>, <6.2174, 48.835, 13.5813> }
			triangle { <6.8905, 49.9588, 14.2011>, <7.1577, 49.2876, 14.1826>, <8.09638, 49.7646, 14.902> }
			triangle { <7.829, 50.4169, 15.00025>, <6.8905, 49.9588, 14.2011>, <8.09638, 49.7646, 14.902> }
			triangle { <7.829, 50.4169, 15.00025>, <8.09638, 49.7646, 14.902>, <8.8664, 50.1458, 15.7525> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.06052, 19.5647, 1.06066>, <-9.1063, 19.6548, 1.05588>, 0.4816 }
		cylinder { <-9.1063, 19.6548, 1.05588>, <-9.154, 19.7439, 1.06079>, 0.4816 }
		cylinder { <-9.154, 19.7439, 1.06079>, <-9.2033, 19.8311, 1.07533>, 0.4816 }
		cylinder { <-9.2033, 19.8311, 1.07533>, <-9.2536, 19.9156, 1.09937>, 0.4816 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.2536, 19.9156, 1.09937>, <-12.7395, 27.6132, -0.9548>, 0.4089 }
			cylinder { <-12.7395, 27.6132, -0.9548>, <-14.5677, 33.9315, -6.6435>, 0.4089 }
			cylinder { <-14.5677, 33.9315, -6.6435>, <-14.3067, 37.3784, -14.6232>, 0.4089 }
			cylinder { <-14.3067, 37.3784, -14.6232>, <-12.01789, 37.1398, -23.00944>, 0.4089 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-12.01789, 37.1398, -23.00944>, <-11.399, 36.5777, -23.955>, <-11.7481, 37.1384, -24.03568> }
			triangle { <-11.7481, 37.1384, -24.03568>, <-11.399, 36.5777, -23.955>, <-10.994, 36.4669, -24.9717> }
			triangle { <-11.7481, 37.1384, -24.03568>, <-10.994, 36.4669, -24.9717>, <-11.3824, 37.1653, -25.09763> }
			triangle { <-10.994, 36.4669, -24.9717>, <-10.8602, 37.199, -26.02541>, <-11.3824, 37.1653, -25.09763> }
			triangle { <-11.7481, 37.1384, -24.03568>, <-11.8041, 37.7695, -24.09945>, <-12.01789, 37.1398, -23.00944> }
			triangle { <-11.8041, 37.7695, -24.09945>, <-11.7481, 37.1384, -24.03568>, <-11.3824, 37.1653, -25.09763> }
			triangle { <-11.3675, 37.7878, -25.1723>, <-11.8041, 37.7695, -24.09945>, <-11.3824, 37.1653, -25.09763> }
			triangle { <-11.3675, 37.7878, -25.1723>, <-11.3824, 37.1653, -25.09763>, <-10.8602, 37.199, -26.02541> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.2536, 19.9156, 1.09937>, <-9.2836, 19.9761, 1.1155>, 0.33 }
		cylinder { <-9.2836, 19.9761, 1.1155>, <-9.3091, 20.03873, 1.1311>, 0.33 }
		cylinder { <-9.3091, 20.03873, 1.1311>, <-9.3298, 20.1031, 1.1463>, 0.33 }
		cylinder { <-9.3298, 20.1031, 1.1463>, <-9.3456, 20.1691, 1.1608>, 0.33 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.3456, 20.1691, 1.1608>, <-13.89, 24.9088, 2.8208>, 0.3184 }
			cylinder { <-13.89, 24.9088, 2.8208>, <-20.2492, 26.7179, 4.2901>, 0.3184 }
			cylinder { <-20.2492, 26.7179, 4.2901>, <-26.7711, 25.1264, 5.1869>, 0.3184 }
			cylinder { <-26.7711, 25.1264, 5.1869>, <-31.7609, 20.5477, 5.2783>, 0.3184 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-31.7609, 20.5477, 5.2783>, <-32.06414, 19.6199, 5.1623>, <-32.3851, 20.00621, 5.2901> }
			triangle { <-32.3851, 20.00621, 5.2901>, <-32.06414, 19.6199, 5.1623>, <-32.6295, 18.979, 5.1026> }
			triangle { <-32.3851, 20.00621, 5.2901>, <-32.6295, 18.979, 5.1026>, <-33.04496, 19.4343, 5.2336> }
			triangle { <-32.6295, 18.979, 5.1026>, <-33.6269, 18.8766, 5.03748>, <-33.04496, 19.4343, 5.2336> }
			triangle { <-32.3851, 20.00621, 5.2901>, <-32.7307, 20.3469, 5.1885>, <-31.7609, 20.5477, 5.2783> }
			triangle { <-32.7307, 20.3469, 5.1885>, <-32.3851, 20.00621, 5.2901>, <-33.04496, 19.4343, 5.2336> }
			triangle { <-33.3933, 19.7431, 5.08589>, <-32.7307, 20.3469, 5.1885>, <-33.04496, 19.4343, 5.2336> }
			triangle { <-33.3933, 19.7431, 5.08589>, <-33.04496, 19.4343, 5.2336>, <-33.6269, 18.8766, 5.03748> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.3456, 20.1691, 1.1608>, <-9.3613, 20.2263, 1.1694>, 0.2852 }
		cylinder { <-9.3613, 20.2263, 1.1694>, <-9.3788, 20.2835, 1.174>, 0.2852 }
		cylinder { <-9.3788, 20.2835, 1.174>, <-9.398, 20.3403, 1.1746>, 0.2852 }
		cylinder { <-9.398, 20.3403, 1.1746>, <-9.4189, 20.3964, 1.1711>, 0.2852 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.4189, 20.3964, 1.1711>, <-10.2312, 24.3136, 2.3132>, 0.1956 }
			cylinder { <-10.2312, 24.3136, 2.3132>, <-10.2986, 27.7305, 4.6859>, 0.1956 }
			cylinder { <-10.2986, 27.7305, 4.6859>, <-9.6118, 30.1891, 7.9711>, 0.1956 }
			cylinder { <-9.6118, 30.1891, 7.9711>, <-8.263, 31.36, 11.7287>, 0.1956 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-8.263, 31.36, 11.7287>, <-8.1473, 31.2267, 12.3061>, <-8.09919, 31.5163, 12.183> }
			triangle { <-8.09919, 31.5163, 12.183>, <-8.1473, 31.2267, 12.3061>, <-8.01571, 31.3216, 12.8067> }
			triangle { <-8.09919, 31.5163, 12.183>, <-8.01571, 31.3216, 12.8067>, <-7.9661, 31.6827, 12.6764> }
			triangle { <-8.01571, 31.3216, 12.8067>, <-7.9254, 31.8145, 13.167>, <-7.9661, 31.6827, 12.6764> }
			triangle { <-8.09919, 31.5163, 12.183>, <-8.1744, 31.8075, 12.1349>, <-8.263, 31.36, 11.7287> }
			triangle { <-8.1744, 31.8075, 12.1349>, <-8.09919, 31.5163, 12.183>, <-7.9661, 31.6827, 12.6764> }
			triangle { <-8.06283, 31.9658, 12.6541>, <-8.1744, 31.8075, 12.1349>, <-7.9661, 31.6827, 12.6764> }
			triangle { <-8.06283, 31.9658, 12.6541>, <-7.9661, 31.6827, 12.6764>, <-7.9254, 31.8145, 13.167> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.4189, 20.3964, 1.1711>, <-9.435, 20.4316, 1.1713>, 0.1843 }
		cylinder { <-9.435, 20.4316, 1.1713>, <-9.4537, 20.4654, 1.174>, 0.1843 }
		cylinder { <-9.4537, 20.4654, 1.174>, <-9.4748, 20.4975, 1.1792>, 0.1843 }
		cylinder { <-9.4748, 20.4975, 1.1792>, <-9.498, 20.5276, 1.1868>, 0.1843 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.498, 20.5276, 1.1868>, <-9.6215, 21.02499, 1.1075>, 0.02438 }
			cylinder { <-9.6215, 21.02499, 1.1075>, <-9.523, 21.4753, 0.8701>, 0.02438 }
			cylinder { <-9.523, 21.4753, 0.8701>, <-9.2305, 21.7505, 0.5421>, 0.02438 }
			cylinder { <-9.2305, 21.7505, 0.5421>, <-8.8272, 21.7723, 0.2169>, 0.02438 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-0.3619, 2.06576, -0.1672>, <-0.456, 2.2616, -0.1684>, 1.03396 }
		cylinder { <-0.456, 2.2616, -0.1684>, <-0.5381, 2.4627, -0.1604>, 1.03396 }
		cylinder { <-0.5381, 2.4627, -0.1604>, <-0.6078, 2.6678, -0.143>, 1.03396 }
		cylinder { <-0.6078, 2.6678, -0.143>, <-0.6648, 2.8758, -0.1164>, 1.03396 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.6648, 2.8758, -0.1164>, <-8.7676, 13.5694, -2.1141>, 0.6378 }
			cylinder { <-8.7676, 13.5694, -2.1141>, <-19.6875, 19.6879, -7.3408>, 0.6378 }
			cylinder { <-19.6875, 19.6879, -7.3408>, <-31.09257, 19.9248, -14.6802>, 0.6378 }
			cylinder { <-31.09257, 19.9248, -14.6802>, <-40.5471, 14.2294, -22.5652>, 0.6378 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-40.5471, 14.2294, -22.5652>, <-41.1735, 12.6997, -23.6345>, <-41.7208, 13.5756, -23.5319> }
			triangle { <-41.7208, 13.5756, -23.5319>, <-41.1735, 12.6997, -23.6345>, <-42.1994, 11.8476, -24.7142> }
			triangle { <-41.7208, 13.5756, -23.5319>, <-42.1994, 11.8476, -24.7142>, <-42.881, 12.9085, -24.6632> }
			triangle { <-42.1994, 11.8476, -24.7142>, <-43.7492, 12.2681, -25.9268>, <-42.881, 12.9085, -24.6632> }
			triangle { <-41.7208, 13.5756, -23.5319>, <-42.05334, 14.4563, -23.8483>, <-40.5471, 14.2294, -22.5652> }
			triangle { <-42.05334, 14.4563, -23.8483>, <-41.7208, 13.5756, -23.5319>, <-42.881, 12.9085, -24.6632> }
			triangle { <-43.1734, 13.7459, -25.07558>, <-42.05334, 14.4563, -23.8483>, <-42.881, 12.9085, -24.6632> }
			triangle { <-43.1734, 13.7459, -25.07558>, <-42.881, 12.9085, -24.6632>, <-43.7492, 12.2681, -25.9268> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-0.6648, 2.8758, -0.1164>, <-0.7369, 3.1751, -0.1074>, 1.4654 }
		cylinder { <-0.7369, 3.1751, -0.1074>, <-0.7998, 3.476, -0.1272>, 1.4654 }
		cylinder { <-0.7998, 3.476, -0.1272>, <-0.8529, 3.7755, -0.1754>, 1.4654 }
		cylinder { <-0.8529, 3.7755, -0.1754>, <-0.8956, 4.07086, -0.2518>, 1.4654 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.8956, 4.07086, -0.2518>, <-4.3883, 17.2242, 1.1027>, 0.6431 }
			cylinder { <-4.3883, 17.2242, 1.1027>, <-9.01033, 28.6548, 7.02068>, 0.6431 }
			cylinder { <-9.01033, 28.6548, 7.02068>, <-14.142, 36.8309, 16.7088>, 0.6431 }
			cylinder { <-14.142, 36.8309, 16.7088>, <-19.0959, 40.6568, 28.8689>, 0.6431 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-19.0959, 40.6568, 28.8689>, <-20.1561, 40.2435, 30.4952>, <-19.6891, 41.1675, 30.3426> }
			triangle { <-19.6891, 41.1675, 30.3426>, <-20.1561, 40.2435, 30.4952>, <-20.9463, 40.5661, 32.00011> }
			triangle { <-19.6891, 41.1675, 30.3426>, <-20.9463, 40.5661, 32.00011>, <-20.4413, 41.7231, 31.8418> }
			triangle { <-20.9463, 40.5661, 32.00011>, <-21.4156, 42.19, 33.122>, <-20.4413, 41.7231, 31.8418> }
			triangle { <-19.6891, 41.1675, 30.3426>, <-19.6844, 42.1368, 30.09172>, <-19.0959, 40.6568, 28.8689> }
			triangle { <-19.6844, 42.1368, 30.09172>, <-19.6891, 41.1675, 30.3426>, <-20.4413, 41.7231, 31.8418> }
			triangle { <-20.5479, 42.6741, 31.6034>, <-19.6844, 42.1368, 30.09172>, <-20.4413, 41.7231, 31.8418> }
			triangle { <-20.5479, 42.6741, 31.6034>, <-20.4413, 41.7231, 31.8418>, <-21.4156, 42.19, 33.122> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-0.8956, 4.07086, -0.2518>, <-0.9617, 4.3355, -0.3221>, 1.3402 }
		cylinder { <-0.9617, 4.3355, -0.3221>, <-1.05437, 4.5921, -0.3923>, 1.3402 }
		cylinder { <-1.05437, 4.5921, -0.3923>, <-1.1725, 4.8382, -0.4616>, 1.3402 }
		cylinder { <-1.1725, 4.8382, -0.4616>, <-1.3151, 5.07158, -0.5293>, 1.3402 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.3151, 5.07158, -0.5293>, <-1.2033, 18.8078, -3.937>, 0.6655 }
			cylinder { <-1.2033, 18.8078, -3.937>, <6.1523, 30.6504, -6.3775>, 0.6655 }
			cylinder { <6.1523, 30.6504, -6.3775>, <18.659, 37.2295, -7.1565>, 0.6655 }
			cylinder { <18.659, 37.2295, -7.1565>, <32.7579, 36.6732, -6.05236>, 0.6655 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <32.7579, 36.6732, -6.05236>, <34.4726, 35.582, -5.7546>, <34.4792, 36.6532, -5.9139> }
			triangle { <34.4792, 36.6532, -5.9139>, <34.4726, 35.582, -5.7546>, <36.222, 35.3103, -5.4883> }
			triangle { <34.4792, 36.6532, -5.9139>, <36.222, 35.3103, -5.4883>, <36.2843, 36.6184, -5.625> }
			triangle { <36.222, 35.3103, -5.4883>, <37.9197, 36.4721, -5.06892>, <36.2843, 36.6184, -5.625> }
			triangle { <34.4792, 36.6532, -5.9139>, <34.541, 37.6365, -5.5928>, <32.7579, 36.6732, -6.05236> }
			triangle { <34.541, 37.6365, -5.5928>, <34.4792, 36.6532, -5.9139>, <36.2843, 36.6184, -5.625> }
			triangle { <36.3845, 37.5448, -5.2086>, <34.541, 37.6365, -5.5928>, <36.2843, 36.6184, -5.625> }
			triangle { <36.3845, 37.5448, -5.2086>, <36.2843, 36.6184, -5.625>, <37.9197, 36.4721, -5.06892> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-1.3151, 5.07158, -0.5293>, <-1.4513, 5.2711, -0.5883>, 1.1834 }
		cylinder { <-1.4513, 5.2711, -0.5883>, <-1.5976, 5.4638, -0.6462>, 1.1834 }
		cylinder { <-1.5976, 5.4638, -0.6462>, <-1.7535, 5.6491, -0.703>, 1.1834 }
		cylinder { <-1.7535, 5.6491, -0.703>, <-1.9187, 5.8265, -0.7584>, 1.1834 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.9187, 5.8265, -0.7584>, <-5.4746, 18.6629, -4.1936>, 0.6468 }
			cylinder { <-5.4746, 18.6629, -4.1936>, <-2.6905, 31.7792, -7.264>, 0.6468 }
			cylinder { <-2.6905, 31.7792, -7.264>, <5.8389, 42.3745, -9.314>, 0.6468 }
			cylinder { <5.8389, 42.3745, -9.314>, <18.2925, 48.1861, -9.9058>, 0.6468 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <18.2925, 48.1861, -9.9058>, <20.2487, 48.1155, -9.5136>, <19.7919, 48.9357, -9.9895> }
			triangle { <19.7919, 48.9357, -9.9895>, <20.2487, 48.1155, -9.5136>, <21.8788, 48.7148, -9.4065> }
			triangle { <19.7919, 48.9357, -9.9895>, <21.8788, 48.7148, -9.4065>, <21.3665, 49.7583, -9.9417> }
			triangle { <21.8788, 48.7148, -9.4065>, <22.835, 50.5077, -9.5943>, <21.3665, 49.7583, -9.9417> }
			triangle { <19.7919, 48.9357, -9.9895>, <19.4081, 49.8667, -10.00662>, <18.2925, 48.1861, -9.9058> }
			triangle { <19.4081, 49.8667, -10.00662>, <19.7919, 48.9357, -9.9895>, <21.3665, 49.7583, -9.9417> }
			triangle { <21.03828, 50.6907, -9.8591>, <19.4081, 49.8667, -10.00662>, <21.3665, 49.7583, -9.9417> }
			triangle { <21.03828, 50.6907, -9.8591>, <21.3665, 49.7583, -9.9417>, <22.835, 50.5077, -9.5943> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-1.9187, 5.8265, -0.7584>, <-2.1169, 6.05714, -0.7996>, 1.4598 }
		cylinder { <-2.1169, 6.05714, -0.7996>, <-2.3077, 6.297, -0.8132>, 1.4598 }
		cylinder { <-2.3077, 6.297, -0.8132>, <-2.4891, 6.5441, -0.799>, 1.4598 }
		cylinder { <-2.4891, 6.5441, -0.799>, <-2.6595, 6.7958, -0.7572>, 1.4598 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.6595, 6.7958, -0.7572>, <-12.02606, 15.8679, -5.326>, 0.6497 }
			cylinder { <-12.02606, 15.8679, -5.326>, <-20.6539, 20.3184, -15.1577>, 0.6497 }
			cylinder { <-20.6539, 20.3184, -15.1577>, <-26.3013, 18.9909, -27.6978>, 0.6497 }
			cylinder { <-26.3013, 18.9909, -27.6978>, <-27.501, 12.2303, -39.688>, 0.6497 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-27.501, 12.2303, -39.688>, <-26.9411, 10.7286, -40.8933>, <-27.6717, 11.4415, -41.1682> }
			triangle { <-27.6717, 11.4415, -41.1682>, <-26.9411, 10.7286, -40.8933>, <-26.8748, 9.7966, -42.3704> }
			triangle { <-27.6717, 11.4415, -41.1682>, <-26.8748, 9.7966, -42.3704>, <-27.7312, 10.6657, -42.7748> }
			triangle { <-26.8748, 9.7966, -42.3704>, <-27.4911, 10.0046, -44.3141>, <-27.7312, 10.6657, -42.7748> }
			triangle { <-27.6717, 11.4415, -41.1682>, <-27.9883, 12.2688, -41.6569>, <-27.501, 12.2303, -39.688> }
			triangle { <-27.9883, 12.2688, -41.6569>, <-27.6717, 11.4415, -41.1682>, <-27.7312, 10.6657, -42.7748> }
			triangle { <-27.9479, 11.4734, -43.3164>, <-27.9883, 12.2688, -41.6569>, <-27.7312, 10.6657, -42.7748> }
			triangle { <-27.9479, 11.4734, -43.3164>, <-27.7312, 10.6657, -42.7748>, <-27.4911, 10.0046, -44.3141> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-2.6595, 6.7958, -0.7572>, <-2.8248, 7.08486, -0.7328>, 1.5883 }
		cylinder { <-2.8248, 7.08486, -0.7328>, <-2.9684, 7.3861, -0.7297>, 1.5883 }
		cylinder { <-2.9684, 7.3861, -0.7297>, <-3.08909, 7.6969, -0.7479>, 1.5883 }
		cylinder { <-3.08909, 7.6969, -0.7479>, <-3.1855, 8.0141, -0.7872>, 1.5883 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.1855, 8.0141, -0.7872>, <-11.5958, 18.5945, 1.9413>, 0.6483 }
			cylinder { <-11.5958, 18.5945, 1.9413>, <-22.4471, 24.1565, 8.3788>, 0.6483 }
			cylinder { <-22.4471, 24.1565, 8.3788>, <-33.1766, 23.3864, 17.00501>, 0.6483 }
			cylinder { <-33.1766, 23.3864, 17.00501>, <-41.2506, 16.466, 25.7826>, 0.6483 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-41.2506, 16.466, 25.7826>, <-41.7722, 14.7456, 26.6616>, <-42.2645, 15.6584, 26.8551> }
			triangle { <-42.2645, 15.6584, 26.8551>, <-41.7722, 14.7456, 26.6616>, <-42.7405, 13.68, 27.6462> }
			triangle { <-42.2645, 15.6584, 26.8551>, <-42.7405, 13.68, 27.6462>, <-43.4058, 14.7518, 27.8793> }
			triangle { <-42.7405, 13.68, 27.6462>, <-44.552, 13.7382, 28.5944>, <-43.4058, 14.7518, 27.8793> }
			triangle { <-42.2645, 15.6584, 26.8551>, <-43.02449, 16.3141, 26.7464>, <-41.2506, 16.466, 25.7826> }
			triangle { <-43.02449, 16.3141, 26.7464>, <-42.2645, 15.6584, 26.8551>, <-43.4058, 14.7518, 27.8793> }
			triangle { <-44.2124, 15.3128, 27.7264>, <-43.02449, 16.3141, 26.7464>, <-43.4058, 14.7518, 27.8793> }
			triangle { <-44.2124, 15.3128, 27.7264>, <-43.4058, 14.7518, 27.8793>, <-44.552, 13.7382, 28.5944> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-3.1855, 8.0141, -0.7872>, <-3.3122, 8.3325, -0.8464>, 1.6548 }
		cylinder { <-3.3122, 8.3325, -0.8464>, <-3.4639, 8.6359, -0.9233>, 1.6548 }
		cylinder { <-3.4639, 8.6359, -0.9233>, <-3.6392, 8.9213, -1.01714>, 1.6548 }
		cylinder { <-3.6392, 8.9213, -1.01714>, <-3.8364, 9.1859, -1.1269>, 1.6548 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.8364, 9.1859, -1.1269>, <-6.1535, 22.5491, -1.6322>, 0.6382 }
			cylinder { <-6.1535, 22.5491, -1.6322>, <-2.4347, 35.1462, 1.7858>, 0.6382 }
			cylinder { <-2.4347, 35.1462, 1.7858>, <6.2618, 43.3928, 8.1547>, 0.6382 }
			cylinder { <6.2618, 43.3928, 8.1547>, <17.4616, 44.9424, 15.6622>, 0.6382 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <17.4616, 44.9424, 15.6622>, <19.06704, 44.1699, 16.5025>, <18.813, 45.1728, 16.5913> }
			triangle { <18.813, 45.1728, 16.5913>, <19.06704, 44.1699, 16.5025>, <20.4655, 44.1408, 17.4979> }
			triangle { <18.813, 45.1728, 16.5913>, <20.4655, 44.1408, 17.4979>, <20.176, 45.3564, 17.6789> }
			triangle { <20.4655, 44.1408, 17.4979>, <21.326, 45.3264, 18.879>, <20.176, 45.3564, 17.6789> }
			triangle { <18.813, 45.1728, 16.5913>, <18.4354, 45.9534, 17.0767>, <17.4616, 44.9424, 15.6622> }
			triangle { <18.4354, 45.9534, 17.0767>, <18.813, 45.1728, 16.5913>, <20.176, 45.3564, 17.6789> }
			triangle { <19.8082, 46.06247, 18.2482>, <18.4354, 45.9534, 17.0767>, <20.176, 45.3564, 17.6789> }
			triangle { <19.8082, 46.06247, 18.2482>, <20.176, 45.3564, 17.6789>, <21.326, 45.3264, 18.879> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-3.8364, 9.1859, -1.1269>, <-4.0487, 9.459, -1.2061>, 1.6881 }
		cylinder { <-4.0487, 9.459, -1.2061>, <-4.27, 9.7325, -1.2516>, 1.6881 }
		cylinder { <-4.27, 9.7325, -1.2516>, <-4.4983, 10.00393, -1.2631>, 1.6881 }
		cylinder { <-4.4983, 10.00393, -1.2631>, <-4.7313, 10.2705, -1.2405>, 1.6881 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.7313, 10.2705, -1.2405>, <-11.8295, 20.2447, -6.6673>, 0.6296 }
			cylinder { <-11.8295, 20.2447, -6.6673>, <-15.5542, 27.7763, -17.09428>, 0.6296 }
			cylinder { <-15.5542, 27.7763, -17.09428>, <-15.02579, 31.08679, -30.0589>, 0.6296 }
			cylinder { <-15.02579, 31.08679, -30.0589>, <-10.369, 29.3942, -42.4995>, 0.6296 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-10.369, 29.3942, -42.4995>, <-9.1524, 28.5104, -43.7308>, <-9.8224, 29.2255, -44.03008> }
			triangle { <-9.8224, 29.2255, -44.03008>, <-9.1524, 28.5104, -43.7308>, <-8.3728, 28.2203, -45.2064> }
			triangle { <-9.8224, 29.2255, -44.03008>, <-8.3728, 28.2203, -45.2064>, <-9.1339, 29.1187, -45.6135> }
			triangle { <-8.3728, 28.2203, -45.2064>, <-8.2293, 29.1001, -46.9817>, <-9.1339, 29.1187, -45.6135> }
			triangle { <-9.8224, 29.2255, -44.03008>, <-10.07173, 30.1357, -44.296>, <-10.369, 29.3942, -42.4995> }
			triangle { <-10.07173, 30.1357, -44.296>, <-9.8224, 29.2255, -44.03008>, <-9.1339, 29.1187, -45.6135> }
			triangle { <-9.2725, 30.03422, -45.8877>, <-10.07173, 30.1357, -44.296>, <-9.1339, 29.1187, -45.6135> }
			triangle { <-9.2725, 30.03422, -45.8877>, <-9.1339, 29.1187, -45.6135>, <-8.2293, 29.1001, -46.9817> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-4.7313, 10.2705, -1.2405>, <-4.937, 10.5438, -1.2212>, 1.63 }
		cylinder { <-4.937, 10.5438, -1.2212>, <-5.1221, 10.8316, -1.2046>, 1.63 }
		cylinder { <-5.1221, 10.8316, -1.2046>, <-5.2857, 11.1323, -1.1907>, 1.63 }
		cylinder { <-5.2857, 11.1323, -1.1907>, <-5.427, 11.4442, -1.1797>, 1.63 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.427, 11.4442, -1.1797>, <-15.7873, 19.8382, -0.1105>, 0.629 }
			cylinder { <-15.7873, 19.8382, -0.1105>, <-28.7803, 22.6544, 1.3688>, 0.629 }
			cylinder { <-28.7803, 22.6544, 1.3688>, <-41.6315, 19.2913, 2.9426>, 0.629 }
			cylinder { <-41.6315, 19.2913, 2.9426>, <-51.5963, 10.4671, 4.2748>, 0.629 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-51.5963, 10.4671, 4.2748>, <-52.2242, 8.6302, 4.2486>, <-52.8418, 9.4246, 4.4357> }
			triangle { <-52.8418, 9.4246, 4.4357>, <-52.2242, 8.6302, 4.2486>, <-53.3599, 7.3763, 4.2865> }
			triangle { <-52.8418, 9.4246, 4.4357>, <-53.3599, 7.3763, 4.2865>, <-54.162, 8.3099, 4.4705> }
			triangle { <-53.3599, 7.3763, 4.2865>, <-55.3347, 7.1924, 4.2244>, <-54.162, 8.3099, 4.4705> }
			triangle { <-52.8418, 9.4246, 4.4357>, <-53.5204, 10.08401, 4.1827>, <-51.5963, 10.4671, 4.2748> }
			triangle { <-53.5204, 10.08401, 4.1827>, <-52.8418, 9.4246, 4.4357>, <-54.162, 8.3099, 4.4705> }
			triangle { <-54.8489, 8.8973, 4.1334>, <-53.5204, 10.08401, 4.1827>, <-54.162, 8.3099, 4.4705> }
			triangle { <-54.8489, 8.8973, 4.1334>, <-54.162, 8.3099, 4.4705>, <-55.3347, 7.1924, 4.2244> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-5.427, 11.4442, -1.1797>, <-5.5552, 11.7002, -1.1963>, 1.3646 }
		cylinder { <-5.5552, 11.7002, -1.1963>, <-5.6921, 11.9487, -1.2385>, 1.3646 }
		cylinder { <-5.6921, 11.9487, -1.2385>, <-5.8364, 12.1872, -1.3061>, 1.3646 }
		cylinder { <-5.8364, 12.1872, -1.3061>, <-5.9868, 12.4134, -1.3982>, 1.3646 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.9868, 12.4134, -1.3982>, <-11.5656, 24.4205, -1.2703>, 0.6226 }
			cylinder { <-11.5656, 24.4205, -1.2703>, <-15.03632, 36.3822, 3.222>, 0.6226 }
			cylinder { <-15.03632, 36.3822, 3.222>, <-15.9338, 46.6955, 11.4767>, 0.6226 }
			cylinder { <-15.9338, 46.6955, 11.4767>, <-14.1378, 53.9783, 22.3875>, 0.6226 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-14.1378, 53.9783, 22.3875>, <-13.89, 54.08436, 24.2901>, <-13.93, 54.9035, 23.6955> }
			triangle { <-13.93, 54.9035, 23.6955>, <-13.89, 54.08436, 24.2901>, <-13.7485, 54.8308, 25.7828> }
			triangle { <-13.93, 54.9035, 23.6955>, <-13.7485, 54.8308, 25.7828>, <-13.839, 55.8594, 25.1111> }
			triangle { <-13.7485, 54.8308, 25.7828>, <-14.00164, 56.63, 26.5288>, <-13.839, 55.8594, 25.1111> }
			triangle { <-13.93, 54.9035, 23.6955>, <-14.3764, 55.6728, 23.3099>, <-14.1378, 53.9783, 22.3875> }
			triangle { <-14.3764, 55.6728, 23.3099>, <-13.93, 54.9035, 23.6955>, <-13.839, 55.8594, 25.1111> }
			triangle { <-14.354, 56.604, 24.8078>, <-14.3764, 55.6728, 23.3099>, <-13.839, 55.8594, 25.1111> }
			triangle { <-14.354, 56.604, 24.8078>, <-13.839, 55.8594, 25.1111>, <-14.00164, 56.63, 26.5288> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-5.9868, 12.4134, -1.3982>, <-6.1424, 12.621, -1.4722>, 1.2835 }
		cylinder { <-6.1424, 12.621, -1.4722>, <-6.3116, 12.8221, -1.533>, 1.2835 }
		cylinder { <-6.3116, 12.8221, -1.533>, <-6.4933, 13.01584, -1.5803>, 1.2835 }
		cylinder { <-6.4933, 13.01584, -1.5803>, <-6.6866, 13.201, -1.6139>, 1.2835 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.6866, 13.201, -1.6139>, <-12.01366, 23.7924, -6.9458>, 0.6112 }
			cylinder { <-12.01366, 23.7924, -6.9458>, <-12.3315, 34.01837, -14.9654>, 0.6112 }
			cylinder { <-12.3315, 34.01837, -14.9654>, <-7.5791, 41.9152, -24.1326>, 0.6112 }
			cylinder { <-7.5791, 41.9152, -24.1326>, <1.3307, 45.9667, -32.6872>, 0.6112 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <1.3307, 45.9667, -32.6872>, <3.1072, 45.9476, -33.3223>, <2.39, 46.4925, -33.7442> }
			triangle { <2.39, 46.4925, -33.7442>, <3.1072, 45.9476, -33.3223>, <4.3837, 46.4112, -34.2495> }
			triangle { <2.39, 46.4925, -33.7442>, <4.3837, 46.4112, -34.2495>, <3.5594, 47.128, -34.7686> }
			triangle { <4.3837, 46.4112, -34.2495>, <4.7925, 47.8235, -35.4973>, <3.5594, 47.128, -34.7686> }
			triangle { <2.39, 46.4925, -33.7442>, <1.9264, 47.3074, -33.9082>, <1.3307, 45.9667, -32.6872> }
			triangle { <1.9264, 47.3074, -33.9082>, <2.39, 46.4925, -33.7442>, <3.5594, 47.128, -34.7686> }
			triangle { <3.1865, 47.9798, -34.8874>, <1.9264, 47.3074, -33.9082>, <3.5594, 47.128, -34.7686> }
			triangle { <3.1865, 47.9798, -34.8874>, <3.5594, 47.128, -34.7686>, <4.7925, 47.8235, -35.4973> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-6.6866, 13.201, -1.6139>, <-6.8742, 13.4147, -1.6361>, 1.3574 }
		cylinder { <-6.8742, 13.4147, -1.6361>, <-7.04333, 13.6444, -1.6445>, 1.3574 }
		cylinder { <-7.04333, 13.6444, -1.6445>, <-7.1921, 13.8877, -1.6392>, 1.3574 }
		cylinder { <-7.1921, 13.8877, -1.6392>, <-7.3194, 14.1424, -1.6202>, 1.3574 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.3194, 14.1424, -1.6202>, <-16.1875, 23.01576, -3.04648>, 0.5937 }
			cylinder { <-16.1875, 23.01576, -3.04648>, <-27.1049, 28.3036, -6.5485>, 0.5937 }
			cylinder { <-27.1049, 28.3036, -6.5485>, <-38.6083, 29.2973, -11.657>, 0.5937 }
			cylinder { <-38.6083, 29.2973, -11.657>, <-49.1563, 25.8638, -17.6874>, 0.5937 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-49.1563, 25.8638, -17.6874>, <-49.9959, 24.8223, -18.9397>, <-50.4629, 25.4795, -18.4075> }
			triangle { <-50.4629, 25.4795, -18.4075>, <-49.9959, 24.8223, -18.9397>, <-51.2011, 24.3216, -19.8604> }
			triangle { <-50.4629, 25.4795, -18.4075>, <-51.2011, 24.3216, -19.8604>, <-51.8042, 25.1394, -19.2711> }
			triangle { <-51.2011, 24.3216, -19.8604>, <-52.9247, 24.9005, -20.3099>, <-51.8042, 25.1394, -19.2711> }
			triangle { <-50.4629, 25.4795, -18.4075>, <-50.8588, 26.3041, -18.274>, <-49.1563, 25.8638, -17.6874> }
			triangle { <-50.8588, 26.3041, -18.274>, <-50.4629, 25.4795, -18.4075>, <-51.8042, 25.1394, -19.2711> }
			triangle { <-52.1913, 25.963, -19.242>, <-50.8588, 26.3041, -18.274>, <-51.8042, 25.1394, -19.2711> }
			triangle { <-52.1913, 25.963, -19.242>, <-51.8042, 25.1394, -19.2711>, <-52.9247, 24.9005, -20.3099> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.3194, 14.1424, -1.6202>, <-7.4334, 14.383, -1.628>, 1.2675 }
		cylinder { <-7.4334, 14.383, -1.628>, <-7.5415, 14.6242, -1.6613>, 1.2675 }
		cylinder { <-7.5415, 14.6242, -1.6613>, <-7.6427, 14.8637, -1.7197>, 1.2675 }
		cylinder { <-7.6427, 14.8637, -1.7197>, <-7.736, 15.09906, -1.8027>, 1.2675 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.736, 15.09906, -1.8027>, <-13.221, 25.6561, -0.1436>, 0.5648 }
			cylinder { <-13.221, 25.6561, -0.1436>, <-18.8135, 33.9048, 6.5625>, 0.5648 }
			cylinder { <-18.8135, 33.9048, 6.5625>, <-23.3191, 38.08358, 16.8837>, 0.5648 }
			cylinder { <-23.3191, 38.08358, 16.8837>, <-25.7758, 37.3, 28.6157>, 0.5648 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-25.7758, 37.3, 28.6157>, <-25.8766, 36.3481, 30.0728>, <-26.09379, 37.2408, 30.04527> }
			triangle { <-26.09379, 37.2408, 30.04527>, <-25.8766, 36.3481, 30.0728>, <-26.2176, 36.05021, 31.5232> }
			triangle { <-26.09379, 37.2408, 30.04527>, <-26.2176, 36.05021, 31.5232>, <-26.5345, 37.1218, 31.5284> }
			triangle { <-26.2176, 36.05021, 31.5232>, <-27.126, 36.8292, 32.8434>, <-26.5345, 37.1218, 31.5284> }
			triangle { <-26.09379, 37.2408, 30.04527>, <-26.6631, 37.9103, 30.01242>, <-25.7758, 37.3, 28.6157> }
			triangle { <-26.6631, 37.9103, 30.01242>, <-26.09379, 37.2408, 30.04527>, <-26.5345, 37.1218, 31.5284> }
			triangle { <-27.1647, 37.716, 31.5195>, <-26.6631, 37.9103, 30.01242>, <-26.5345, 37.1218, 31.5284> }
			triangle { <-27.1647, 37.716, 31.5195>, <-26.5345, 37.1218, 31.5284>, <-27.126, 36.8292, 32.8434> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.736, 15.09906, -1.8027>, <-7.8356, 15.3028, -1.8755>, 1.1332 }
		cylinder { <-7.8356, 15.3028, -1.8755>, <-7.9508, 15.4987, -1.9467>, 1.1332 }
		cylinder { <-7.9508, 15.4987, -1.9467>, <-8.08099, 15.6859, -2.0157>, 1.1332 }
		cylinder { <-8.08099, 15.6859, -2.0157>, <-8.2254, 15.8632, -2.08219>, 1.1332 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.2254, 15.8632, -2.08219>, <-10.4755, 28.9225, -6.5317>, 0.6573 }
			cylinder { <-10.4755, 28.9225, -6.5317>, <-5.9648, 41.5514, -10.4776>, 0.6573 }
			cylinder { <-5.9648, 41.5514, -10.4776>, <4.2413, 50.7676, -12.988>, 0.6573 }
			cylinder { <4.2413, 50.7676, -12.988>, <17.7328, 54.3945, -13.4701>, 0.6573 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <17.7328, 54.3945, -13.4701>, <19.6793, 53.9569, -13.1016>, <19.366, 54.8817, -13.5382> }
			triangle { <19.366, 54.8817, -13.5382>, <19.6793, 53.9569, -13.1016>, <21.4174, 54.261, -12.9853> }
			triangle { <19.366, 54.8817, -13.5382>, <21.4174, 54.261, -12.9853>, <21.08804, 55.4218, -13.4705> }
			triangle { <21.4174, 54.261, -12.9853>, <22.6922, 55.8924, -13.1007>, <21.08804, 55.4218, -13.4705> }
			triangle { <19.366, 54.8817, -13.5382>, <19.1477, 55.881, -13.5048>, <17.7328, 54.3945, -13.4701> }
			triangle { <19.1477, 55.881, -13.5048>, <19.366, 54.8817, -13.5382>, <21.08804, 55.4218, -13.4705> }
			triangle { <20.9259, 56.4077, -13.3366>, <19.1477, 55.881, -13.5048>, <21.08804, 55.4218, -13.4705> }
			triangle { <20.9259, 56.4077, -13.3366>, <21.08804, 55.4218, -13.4705>, <22.6922, 55.8924, -13.1007> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.2254, 15.8632, -2.08219>, <-8.348, 16.02789, -2.1226>, 0.9955 }
		cylinder { <-8.348, 16.02789, -2.1226>, <-8.4651, 16.1999, -2.1447>, 0.9955 }
		cylinder { <-8.4651, 16.1999, -2.1447>, <-8.5755, 16.3776, -2.1481>, 0.9955 }
		cylinder { <-8.5755, 16.3776, -2.1481>, <-8.6782, 16.5593, -2.133>, 0.9955 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.6782, 16.5593, -2.133>, <-17.09516, 25.7412, -7.2923>, 0.6339 }
			cylinder { <-17.09516, 25.7412, -7.2923>, <-25.1247, 30.0133, -17.2446>, 0.6339 }
			cylinder { <-25.1247, 30.0133, -17.2446>, <-30.6806, 28.2654, -29.4038>, 0.6339 }
			cylinder { <-30.6806, 28.2654, -29.4038>, <-32.3193, 20.9519, -40.6109>, 0.6339 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-32.3193, 20.9519, -40.6109>, <-31.94, 19.3338, -41.6436>, <-32.5372, 20.09623, -41.9989> }
			triangle { <-32.5372, 20.09623, -41.9989>, <-31.94, 19.3338, -41.6436>, <-31.9488, 18.3086, -43.00664> }
			triangle { <-32.5372, 20.09623, -41.9989>, <-31.9488, 18.3086, -43.00664>, <-32.6411, 19.228, -43.5053> }
			triangle { <-31.9488, 18.3086, -43.00664>, <-32.4427, 18.4354, -44.9405>, <-32.6411, 19.228, -43.5053> }
			triangle { <-32.5372, 20.09623, -41.9989>, <-32.7111, 20.8962, -42.5505>, <-32.3193, 20.9519, -40.6109> }
			triangle { <-32.7111, 20.8962, -42.5505>, <-32.5372, 20.09623, -41.9989>, <-32.6411, 19.228, -43.5053> }
			triangle { <-32.7194, 19.9915, -44.102>, <-32.7111, 20.8962, -42.5505>, <-32.6411, 19.228, -43.5053> }
			triangle { <-32.7194, 19.9915, -44.102>, <-32.6411, 19.228, -43.5053>, <-32.4427, 18.4354, -44.9405> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.6782, 16.5593, -2.133>, <-8.7529, 16.7174, -2.1319>, 0.8322 }
		cylinder { <-8.7529, 16.7174, -2.1319>, <-8.8158, 16.8803, -2.1422>, 0.8322 }
		cylinder { <-8.8158, 16.8803, -2.1422>, <-8.8663, 17.04639, -2.1639>, 0.8322 }
		cylinder { <-8.8663, 17.04639, -2.1639>, <-8.9038, 17.214, -2.1968>, 0.8322 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.9038, 17.214, -2.1968>, <-15.8678, 26.8545, -0.1556>, 0.5674 }
			cylinder { <-15.8678, 26.8545, -0.1556>, <-25.226, 31.827, 5.615>, 0.5674 }
			cylinder { <-25.226, 31.827, 5.615>, <-34.3156, 30.7168, 13.473>, 0.5674 }
			cylinder { <-34.3156, 30.7168, 13.473>, <-40.5503, 23.8396, 21.1825>, 0.5674 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-40.5503, 23.8396, 21.1825>, <-40.7679, 22.3126, 22.01197>, <-41.3416, 23.02767, 22.1219> }
			triangle { <-41.3416, 23.02767, 22.1219>, <-40.7679, 22.3126, 22.01197>, <-41.4761, 21.2825, 22.8879> }
			triangle { <-41.3416, 23.02767, 22.1219>, <-41.4761, 21.2825, 22.8879>, <-42.2249, 22.1085, 23.01923> }
			triangle { <-41.4761, 21.2825, 22.8879>, <-43.08297, 21.08458, 23.6514>, <-42.2249, 22.1085, 23.01923> }
			triangle { <-41.3416, 23.02767, 22.1219>, <-42.09279, 23.4674, 21.9707>, <-40.5503, 23.8396, 21.1825> }
			triangle { <-42.09279, 23.4674, 21.9707>, <-41.3416, 23.02767, 22.1219>, <-42.2249, 22.1085, 23.01923> }
			triangle { <-42.9996, 22.4578, 22.8322>, <-42.09279, 23.4674, 21.9707>, <-42.2249, 22.1085, 23.01923> }
			triangle { <-42.9996, 22.4578, 22.8322>, <-42.2249, 22.1085, 23.01923>, <-43.08297, 21.08458, 23.6514> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.9038, 17.214, -2.1968>, <-8.9544, 17.3746, -2.2382>, 0.825 }
		cylinder { <-8.9544, 17.3746, -2.2382>, <-9.01815, 17.5281, -2.2879>, 0.825 }
		cylinder { <-9.01815, 17.5281, -2.2879>, <-9.09419, 17.6729, -2.3455>, 0.825 }
		cylinder { <-9.09419, 17.6729, -2.3455>, <-9.1818, 17.8077, -2.4104>, 0.825 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.1818, 17.8077, -2.4104>, <-10.1125, 27.575, -3.4873>, 0.4641 }
			cylinder { <-10.1125, 27.575, -3.4873>, <-6.7182, 36.6576, -1.6405>, 0.4641 }
			cylinder { <-6.7182, 36.6576, -1.6405>, <0.03507, 42.4712, 2.6045>, 0.4641 }
			cylinder { <0.03507, 42.4712, 2.6045>, <8.2258, 43.3615, 8.03991>, 0.4641 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <8.2258, 43.3615, 8.03991>, <9.3351, 42.7559, 8.7145>, <9.2169, 43.5018, 8.7096> }
			triangle { <9.2169, 43.5018, 8.7096>, <9.3351, 42.7559, 8.7145>, <10.343, 42.7105, 9.45> }
			triangle { <9.2169, 43.5018, 8.7096>, <10.343, 42.7105, 9.45>, <10.2129, 43.6182, 9.4974> }
			triangle { <10.343, 42.7105, 9.45>, <11.04019, 43.6021, 10.3789>, <10.2129, 43.6182, 9.4974> }
			triangle { <9.2169, 43.5018, 8.7096>, <8.9934, 44.1221, 9.005652>, <8.2258, 43.3615, 8.03991> }
			triangle { <8.9934, 44.1221, 9.005652>, <9.2169, 43.5018, 8.7096>, <10.2129, 43.6182, 9.4974> }
			triangle { <9.9912, 44.1897, 9.8592>, <8.9934, 44.1221, 9.005652>, <10.2129, 43.6182, 9.4974> }
			triangle { <9.9912, 44.1897, 9.8592>, <10.2129, 43.6182, 9.4974>, <11.04019, 43.6021, 10.3789> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.1818, 17.8077, -2.4104>, <-9.2361, 17.8882, -2.439>, 0.4816 }
		cylinder { <-9.2361, 17.8882, -2.439>, <-9.293, 17.9697, -2.4581>, 0.4816 }
		cylinder { <-9.293, 17.9697, -2.4581>, <-9.352, 18.05147, -2.4675>, 0.4816 }
		cylinder { <-9.352, 18.05147, -2.4675>, <-9.4125, 18.1326, -2.467>, 0.4816 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.4125, 18.1326, -2.467>, <-13.6592, 24.7909, -6.1081>, 0.4089 }
			cylinder { <-13.6592, 24.7909, -6.1081>, <-16.1437, 29.8537, -12.7277>, 0.4089 }
			cylinder { <-16.1437, 29.8537, -12.7277>, <-16.3891, 32.3491, -21.05464>, 0.4089 }
			cylinder { <-16.3891, 32.3491, -21.05464>, <-14.3481, 31.7977, -29.4899>, 0.4089 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-14.3481, 31.7977, -29.4899>, <-13.5988, 31.3539, -30.4035>, <-14.1174, 31.7528, -30.5246> }
			triangle { <-14.1174, 31.7528, -30.5246>, <-13.5988, 31.3539, -30.4035>, <-13.2037, 31.2525, -31.4251> }
			triangle { <-14.1174, 31.7528, -30.5246>, <-13.2037, 31.2525, -31.4251>, <-13.8066, 31.7615, -31.6043> }
			triangle { <-13.2037, 31.2525, -31.4251>, <-13.3476, 31.8453, -32.5618>, <-13.8066, 31.7615, -31.6043> }
			triangle { <-14.1174, 31.7528, -30.5246>, <-14.383, 32.3163, -30.6561>, <-14.3481, 31.7977, -29.4899> }
			triangle { <-14.383, 32.3163, -30.6561>, <-14.1174, 31.7528, -30.5246>, <-13.8066, 31.7615, -31.6043> }
			triangle { <-14.00299, 32.3388, -31.7503>, <-14.383, 32.3163, -30.6561>, <-13.8066, 31.7615, -31.6043> }
			triangle { <-14.00299, 32.3388, -31.7503>, <-13.8066, 31.7615, -31.6043>, <-13.3476, 31.8453, -32.5618> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.4125, 18.1326, -2.467>, <-9.4497, 18.1911, -2.4675>, 0.33 }
		cylinder { <-9.4497, 18.1911, -2.4675>, <-9.4826, 18.2522, -2.4686>, 0.33 }
		cylinder { <-9.4826, 18.2522, -2.4686>, <-9.511, 18.3155, -2.4705>, 0.33 }
		cylinder { <-9.511, 18.3155, -2.4705>, <-9.5347, 18.3807, -2.473>, 0.33 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.5347, 18.3807, -2.473>, <-13.964, 23.5035, -2.3748>, 0.3184 }
			cylinder { <-13.964, 23.5035, -2.3748>, <-19.9191, 26.7006, -1.9433>, 0.3184 }
			cylinder { <-19.9191, 26.7006, -1.9433>, <-26.602, 27.5436, -1.2364>, 0.3184 }
			cylinder { <-26.602, 27.5436, -1.2364>, <-33.1171, 25.9195, -0.3487>, 0.3184 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-33.1171, 25.9195, -0.3487>, <-33.8619, 25.2926, -0.4845>, <-33.9162, 25.743, -0.2339> }
			triangle { <-33.9162, 25.743, -0.2339>, <-33.8619, 25.2926, -0.4845>, <-34.674, 25.02023, -0.4649> }
			triangle { <-33.9162, 25.743, -0.2339>, <-34.674, 25.02023, -0.4649>, <-34.7726, 25.5726, -0.1783> }
			triangle { <-34.674, 25.02023, -0.4649>, <-35.5803, 25.4102, -0.2756>, <-34.7726, 25.5726, -0.1783> }
			triangle { <-33.9162, 25.743, -0.2339>, <-34.05415, 26.2182, -0.2016>, <-33.1171, 25.9195, -0.3487> }
			triangle { <-34.05415, 26.2182, -0.2016>, <-33.9162, 25.743, -0.2339>, <-34.7726, 25.5726, -0.1783> }
			triangle { <-34.937, 26.03236, -0.1932>, <-34.05415, 26.2182, -0.2016>, <-34.7726, 25.5726, -0.1783> }
			triangle { <-34.937, 26.03236, -0.1932>, <-34.7726, 25.5726, -0.1783>, <-35.5803, 25.4102, -0.2756> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.5347, 18.3807, -2.473>, <-9.5572, 18.4357, -2.4805>, 0.2852 }
		cylinder { <-9.5572, 18.4357, -2.4805>, <-9.5818, 18.4889, -2.4933>, 0.2852 }
		cylinder { <-9.5818, 18.4889, -2.4933>, <-9.6079, 18.5398, -2.5112>, 0.2852 }
		cylinder { <-9.6079, 18.5398, -2.5112>, <-9.6356, 18.5878, -2.5341>, 0.2852 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.6356, 18.5878, -2.5341>, <-11.09298, 22.4769, -2.7793>, 0.1956 }
			cylinder { <-11.09298, 22.4769, -2.7793>, <-11.8952, 26.3999, -1.6499>, 0.1956 }
			cylinder { <-11.8952, 26.3999, -1.6499>, <-11.9349, 29.8311, 0.7026>, 0.1956 }
			cylinder { <-11.9349, 29.8311, 0.7026>, <-11.2067, 32.3106, 3.9631>, 0.1956 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-11.2067, 32.3106, 3.9631>, <-11.143, 32.3832, 4.5591>, <-11.1198, 32.6244, 4.3526> }
			triangle { <-11.1198, 32.6244, 4.3526>, <-11.143, 32.3832, 4.5591>, <-11.08518, 32.6485, 5.01004> }
			triangle { <-11.1198, 32.6244, 4.3526>, <-11.08518, 32.6485, 5.01004>, <-11.06929, 32.9546, 4.7737> }
			triangle { <-11.08518, 32.6485, 5.01004>, <-11.1046, 33.2364, 5.1968>, <-11.06929, 32.9546, 4.7737> }
			triangle { <-11.1198, 32.6244, 4.3526>, <-11.2271, 32.8699, 4.2078>, <-11.2067, 32.3106, 3.9631> }
			triangle { <-11.2271, 32.8699, 4.2078>, <-11.1198, 32.6244, 4.3526>, <-11.06929, 32.9546, 4.7737> }
			triangle { <-11.1996, 33.1971, 4.6544>, <-11.2271, 32.8699, 4.2078>, <-11.06929, 32.9546, 4.7737> }
			triangle { <-11.1996, 33.1971, 4.6544>, <-11.06929, 32.9546, 4.7737>, <-11.1046, 33.2364, 5.1968> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.6356, 18.5878, -2.5341>, <-9.6555, 18.6184, -2.547>, 0.1843 }
		cylinder { <-9.6555, 18.6184, -2.547>, <-9.6775, 18.6483, -2.558>, 0.1843 }
		cylinder { <-9.6775, 18.6483, -2.558>, <-9.7014, 18.6775, -2.567>, 0.1843 }
		cylinder { <-9.7014, 18.6775, -2.567>, <-9.727, 18.7057, -2.5739>, 0.1843 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.727, 18.7057, -2.5739>, <-9.8952, 19.1269, -2.8254>, 0.02438 }
			cylinder { <-9.8952, 19.1269, -2.8254>, <-9.8529, 19.5014, -3.1815>, 0.02438 }
			cylinder { <-9.8529, 19.5014, -3.1815>, <-9.6091, 19.7495, -3.5661>, 0.02438 }
			cylinder { <-9.6091, 19.7495, -3.5661>, <-9.2159, 19.818, -3.8972>, 0.02438 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-1.3151, 5.07158, -0.5293>, <-1.4812, 5.3602, -0.5879>, 1.6089 }
		cylinder { <-1.4812, 5.3602, -0.5879>, <-1.6412, 5.656, -0.6234>, 1.6089 }
		cylinder { <-1.6412, 5.656, -0.6234>, <-1.7945, 5.9572, -0.6355>, 1.6089 }
		cylinder { <-1.7945, 5.9572, -0.6355>, <-1.94, 6.2622, -0.6243>, 1.6089 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.94, 6.2622, -0.6243>, <-9.4637, 17.1465, -5.9122>, 0.67 }
			cylinder { <-9.4637, 17.1465, -5.9122>, <-16.9341, 23.9716, -15.9443>, 0.67 }
			cylinder { <-16.9341, 23.9716, -15.9443>, <-22.917, 25.4272, -28.7942>, 0.67 }
			cylinder { <-22.917, 25.4272, -28.7942>, <-26.2633, 21.2335, -41.9946>, 0.67 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-26.2633, 21.2335, -41.9946>, <-25.9694, 19.9504, -43.5896>, <-26.6958, 20.7631, -43.6115> }
			triangle { <-26.6958, 20.7631, -43.6115>, <-25.9694, 19.9504, -43.5896>, <-26.171, 19.3235, -45.2675> }
			triangle { <-26.6958, 20.7631, -43.6115>, <-26.171, 19.3235, -45.2675>, <-27.03094, 20.3273, -45.3684> }
			triangle { <-26.171, 19.3235, -45.2675>, <-27.04272, 19.9782, -47.07841>, <-27.03094, 20.3273, -45.3684> }
			triangle { <-26.6958, 20.7631, -43.6115>, <-27.0199, 21.7165, -43.8844>, <-26.2633, 21.2335, -41.9946> }
			triangle { <-27.0199, 21.7165, -43.8844>, <-26.6958, 20.7631, -43.6115>, <-27.03094, 20.3273, -45.3684> }
			triangle { <-27.2617, 21.2675, -45.7128>, <-27.0199, 21.7165, -43.8844>, <-27.03094, 20.3273, -45.3684> }
			triangle { <-27.2617, 21.2675, -45.7128>, <-27.03094, 20.3273, -45.3684>, <-27.04272, 19.9782, -47.07841> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-1.94, 6.2622, -0.6243>, <-2.0577, 6.5685, -0.6329>, 1.5614 }
		cylinder { <-2.0577, 6.5685, -0.6329>, <-2.1506, 6.8819, -0.6608>, 1.5614 }
		cylinder { <-2.1506, 6.8819, -0.6608>, <-2.218, 7.1997, -0.7078>, 1.5614 }
		cylinder { <-2.218, 7.1997, -0.7078>, <-2.2591, 7.5186, -0.7735>, 1.5614 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.2591, 7.5186, -0.7735>, <-8.3527, 20.2911, -0.3046>, 0.6658 }
			cylinder { <-8.3527, 20.2911, -0.3046>, <-17.8378, 30.1323, 3.3934>, 0.6658 }
			cylinder { <-17.8378, 30.1323, 3.3934>, <-29.2702, 35.5439, 9.7577>, 0.6658 }
			cylinder { <-29.2702, 35.5439, 9.7577>, <-40.9095, 35.702, 17.8195>, 0.6658 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-40.9095, 35.702, 17.8195>, <-42.5186, 34.7162, 18.6332>, <-42.3285, 35.7692, 18.8028> }
			triangle { <-42.3285, 35.7692, 18.8028>, <-42.5186, 34.7162, 18.6332>, <-44.06226, 34.5452, 19.5255> }
			triangle { <-42.3285, 35.7692, 18.8028>, <-44.06226, 34.5452, 19.5255>, <-43.9083, 35.8386, 19.7224> }
			triangle { <-44.06226, 34.5452, 19.5255>, <-45.535, 35.8126, 20.3234>, <-43.9083, 35.8386, 19.7224> }
			triangle { <-42.3285, 35.7692, 18.8028>, <-42.491, 36.7789, 18.6326>, <-40.9095, 35.702, 17.8195> }
			triangle { <-42.491, 36.7789, 18.6326>, <-42.3285, 35.7692, 18.8028>, <-43.9083, 35.8386, 19.7224> }
			triangle { <-44.1655, 36.8015, 19.5007>, <-42.491, 36.7789, 18.6326>, <-43.9083, 35.8386, 19.7224> }
			triangle { <-44.1655, 36.8015, 19.5007>, <-43.9083, 35.8386, 19.7224>, <-45.535, 35.8126, 20.3234> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-2.2591, 7.5186, -0.7735>, <-2.327, 7.839, -0.8608>, 1.6125 }
		cylinder { <-2.327, 7.839, -0.8608>, <-2.4196, 8.1473, -0.9668>, 1.6125 }
		cylinder { <-2.4196, 8.1473, -0.9668>, <-2.536, 8.4405, -1.0905>, 1.6125 }
		cylinder { <-2.536, 8.4405, -1.0905>, <-2.6751, 8.716, -1.2306>, 1.6125 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.6751, 8.716, -1.2306>, <-3.3683, 22.6398, -3.2081>, 0.6621 }
			cylinder { <-3.3683, 22.6398, -3.2081>, <1.1895, 35.7562, -0.8732>, 0.6621 }
			cylinder { <1.1895, 35.7562, -0.8732>, <9.922, 44.9675, 5.2225>, 0.6621 }
			cylinder { <9.922, 44.9675, 5.2225>, <20.767, 48.09857, 13.6397>, 0.6621 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <20.767, 48.09857, 13.6397>, <22.1673, 47.5105, 15.00704>, <22.08089, 48.5269, 14.6605> }
			triangle { <22.08089, 48.5269, 14.6605>, <22.1673, 47.5105, 15.00704>, <23.475, 47.7146, 16.199> }
			triangle { <22.08089, 48.5269, 14.6605>, <23.475, 47.7146, 16.199>, <23.3809, 48.9742, 15.8517> }
			triangle { <23.475, 47.7146, 16.199>, <24.4139, 49.2919, 17.1958>, <23.3809, 48.9742, 15.8517> }
			triangle { <22.08089, 48.5269, 14.6605>, <21.7857, 49.5102, 14.7548>, <20.767, 48.09857, 13.6397> }
			triangle { <21.7857, 49.5102, 14.7548>, <22.08089, 48.5269, 14.6605>, <23.3809, 48.9742, 15.8517> }
			triangle { <23.07323, 49.92, 16.05601>, <21.7857, 49.5102, 14.7548>, <23.3809, 48.9742, 15.8517> }
			triangle { <23.07323, 49.92, 16.05601>, <23.3809, 48.9742, 15.8517>, <24.4139, 49.2919, 17.1958> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-2.6751, 8.716, -1.2306>, <-2.8621, 9.06326, -1.3662>, 1.9842 }
		cylinder { <-2.8621, 9.06326, -1.3662>, <-3.06307, 9.4154, -1.4637>, 1.9842 }
		cylinder { <-3.06307, 9.4154, -1.4637>, <-3.276, 9.7692, -1.5221>, 1.9842 }
		cylinder { <-3.276, 9.7692, -1.5221>, <-3.4989, 10.1212, -1.5408>, 1.9842 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.4989, 10.1212, -1.5408>, <-9.03888, 21.4782, -8.02002>, 0.6677 }
			cylinder { <-9.03888, 21.4782, -8.02002>, <-11.4637, 30.02746, -19.09633>, 0.6677 }
			cylinder { <-11.4637, 30.02746, -19.09633>, <-10.3079, 34.1271, -32.6429>, 0.6677 }
			cylinder { <-10.3079, 34.1271, -32.6429>, <-5.7933, 32.99, -46.05854>, 0.6677 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-5.7933, 32.99, -46.05854>, <-4.5442, 32.1215, -47.4488>, <-5.2659, 32.8919, -47.7061> }
			triangle { <-5.2659, 32.8919, -47.7061>, <-4.5442, 32.1215, -47.4488>, <-3.7676, 31.8929, -49.05247> }
			triangle { <-5.2659, 32.8919, -47.7061>, <-3.7676, 31.8929, -49.05247>, <-4.59, 32.8626, -49.4113> }
			triangle { <-3.7676, 31.8929, -49.05247>, <-3.6778, 32.9164, -50.8914>, <-4.59, 32.8626, -49.4113> }
			triangle { <-5.2659, 32.8919, -47.7061>, <-5.5409, 33.8687, -47.9323>, <-5.7933, 32.99, -46.05854> }
			triangle { <-5.5409, 33.8687, -47.9323>, <-5.2659, 32.8919, -47.7061>, <-4.59, 32.8626, -49.4113> }
			triangle { <-4.748, 33.8458, -49.6497>, <-5.5409, 33.8687, -47.9323>, <-4.59, 32.8626, -49.4113> }
			triangle { <-4.748, 33.8458, -49.6497>, <-4.59, 32.8626, -49.4113>, <-3.6778, 32.9164, -50.8914> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-3.4989, 10.1212, -1.5408>, <-3.7038, 10.5043, -1.5623>, 2.06943 }
		cylinder { <-3.7038, 10.5043, -1.5623>, <-3.8799, 10.9013, -1.5856>, 2.06943 }
		cylinder { <-3.8799, 10.9013, -1.5856>, <-4.02629, 11.3101, -1.6106>, 2.06943 }
		cylinder { <-4.02629, 11.3101, -1.6106>, <-4.1421, 11.7285, -1.6371>, 2.06943 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.1421, 11.7285, -1.6371>, <-14.04417, 21.6344, -2.06034>, 0.6589 }
			cylinder { <-14.04417, 21.6344, -2.06034>, <-27.5428, 25.3931, -1.9414>, 0.6589 }
			cylinder { <-27.5428, 25.3931, -1.9414>, <-41.1309, 22.02801, -1.3112>, 0.6589 }
			cylinder { <-41.1309, 22.02801, -1.3112>, <-51.2778, 12.4133, -0.3336>, 0.6589 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-51.2778, 12.4133, -0.3336>, <-51.844, 10.4652, -0.1915>, <-52.5476, 11.2734, -0.2262> }
			triangle { <-52.5476, 11.2734, -0.2262>, <-51.844, 10.4652, -0.1915>, <-52.9696, 9.09626, -0.1591> }
			triangle { <-52.5476, 11.2734, -0.2262>, <-52.9696, 9.09626, -0.1591>, <-53.8687, 10.0359, -0.2498> }
			triangle { <-52.9696, 9.09626, -0.1591>, <-54.9871, 8.7655, -0.5347>, <-53.8687, 10.0359, -0.2498> }
			triangle { <-52.5476, 11.2734, -0.2262>, <-53.2293, 11.8754, -0.7011>, <-51.2778, 12.4133, -0.3336> }
			triangle { <-53.2293, 11.8754, -0.7011>, <-52.5476, 11.2734, -0.2262>, <-53.8687, 10.0359, -0.2498> }
			triangle { <-54.5409, 10.5508, -0.8011>, <-53.2293, 11.8754, -0.7011>, <-53.8687, 10.0359, -0.2498> }
			triangle { <-54.5409, 10.5508, -0.8011>, <-53.8687, 10.0359, -0.2498>, <-54.9871, 8.7655, -0.5347> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-4.1421, 11.7285, -1.6371>, <-4.2971, 12.2239, -1.7175>, 2.499 }
		cylinder { <-4.2971, 12.2239, -1.7175>, <-4.4658, 12.7046, -1.8453>, 2.499 }
		cylinder { <-4.4658, 12.7046, -1.8453>, <-4.6465, 13.166, -2.01943>, 2.499 }
		cylinder { <-4.6465, 13.166, -2.01943>, <-4.8375, 13.6037, -2.2381>, 2.499 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.8375, 13.6037, -2.2381>, <-8.2705, 27.3039, -2.1205>, 0.6641 }
			cylinder { <-8.2705, 27.3039, -2.1205>, <-9.2679, 40.00837, 3.9701>, 0.6641 }
			cylinder { <-9.2679, 40.00837, 3.9701>, <-7.6167, 49.004, 14.7333>, 0.6641 }
			cylinder { <-7.6167, 49.004, 14.7333>, <-3.6695, 52.3698, 27.8705>, 0.6641 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-3.6695, 52.3698, 27.8705>, <-3.0725, 51.7889, 29.7435>, <-3.2033, 52.8251, 29.4659> }
			triangle { <-3.2033, 52.8251, 29.4659>, <-3.0725, 51.7889, 29.7435>, <-2.6469, 51.9949, 31.4666> }
			triangle { <-3.2033, 52.8251, 29.4659>, <-2.6469, 51.9949, 31.4666>, <-2.8404, 53.2667, 31.1988> }
			triangle { <-2.6469, 51.9949, 31.4666>, <-2.7474, 53.5112, 32.909>, <-2.8404, 53.2667, 31.1988> }
			triangle { <-3.2033, 52.8251, 29.4659>, <-3.7258, 53.7173, 29.4458>, <-3.6695, 52.3698, 27.8705> }
			triangle { <-3.7258, 53.7173, 29.4458>, <-3.2033, 52.8251, 29.4659>, <-2.8404, 53.2667, 31.1988> }
			triangle { <-3.4211, 54.1011, 31.2624>, <-3.7258, 53.7173, 29.4458>, <-2.8404, 53.2667, 31.1988> }
			triangle { <-3.4211, 54.1011, 31.2624>, <-2.8404, 53.2667, 31.1988>, <-2.7474, 53.5112, 32.909> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-4.8375, 13.6037, -2.2381>, <-5.01819, 13.9393, -2.3847>, 1.9429 }
		cylinder { <-5.01819, 13.9393, -2.3847>, <-5.2292, 14.267, -2.5064>, 1.9429 }
		cylinder { <-5.2292, 14.267, -2.5064>, <-5.4687, 14.5836, -2.6021>, 1.9429 }
		cylinder { <-5.4687, 14.5836, -2.6021>, <-5.7343, 14.8861, -2.6709>, 1.9429 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.7343, 14.8861, -2.6709>, <-11.06271, 26.4307, -8.2593>, 0.6531 }
			cylinder { <-11.06271, 26.4307, -8.2593>, <-11.9733, 37.6846, -16.3476>, 0.6531 }
			cylinder { <-11.9733, 37.6846, -16.3476>, <-8.3441, 47.1395, -25.852>, 0.6531 }
			cylinder { <-8.3441, 47.1395, -25.852>, <-0.6615, 53.5283, -35.4987>, 0.6531 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-0.6615, 53.5283, -35.4987>, <1.1469, 54.05886, -36.2139>, <0.237, 54.329, -36.6919> }
			triangle { <0.237, 54.329, -36.6919>, <1.1469, 54.05886, -36.2139>, <2.2859, 54.8817, -37.2686> }
			triangle { <0.237, 54.329, -36.6919>, <2.2859, 54.8817, -37.2686>, <1.2095, 55.2806, -37.8616> }
			triangle { <2.2859, 54.8817, -37.2686>, <2.2246, 56.3396, -38.723>, <1.2095, 55.2806, -37.8616> }
			triangle { <0.237, 54.329, -36.6919>, <-0.5093, 54.9798, -36.923>, <-0.6615, 53.5283, -35.4987> }
			triangle { <-0.5093, 54.9798, -36.923>, <0.237, 54.329, -36.6919>, <1.2095, 55.2806, -37.8616> }
			triangle { <0.5422, 56.00339, -38.04991>, <-0.5093, 54.9798, -36.923>, <1.2095, 55.2806, -37.8616> }
			triangle { <0.5422, 56.00339, -38.04991>, <1.2095, 55.2806, -37.8616>, <2.2246, 56.3396, -38.723> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-5.7343, 14.8861, -2.6709>, <-6.006464, 15.256, -2.7265>, 2.2008 }
		cylinder { <-6.006464, 15.256, -2.7265>, <-6.2473, 15.6496, -2.7593>, 2.2008 }
		cylinder { <-6.2473, 15.6496, -2.7593>, <-6.4546, 16.06303, -2.7689>, 2.2008 }
		cylinder { <-6.4546, 16.06303, -2.7689>, <-6.6262, 16.4923, -2.7552>, 2.2008 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.6262, 16.4923, -2.7552>, <-15.5914, 26.7042, -5.07731>, 0.6482 }
			cylinder { <-15.5914, 26.7042, -5.07731>, <-27.04033, 32.7787, -9.7753>, 0.6482 }
			cylinder { <-27.04033, 32.7787, -9.7753>, <-39.23, 33.7909, -16.1341>, 0.6482 }
			cylinder { <-39.23, 33.7909, -16.1341>, <-50.3049, 29.5867, -23.1855>, 0.6482 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-50.3049, 29.5867, -23.1855>, <-51.1388, 28.3441, -24.5135>, <-51.6782, 29.1131, -24.03356> }
			triangle { <-51.6782, 29.1131, -24.03356>, <-51.1388, 28.3441, -24.5135>, <-52.3881, 27.7241, -25.5604> }
			triangle { <-51.6782, 29.1131, -24.03356>, <-52.3881, 27.7241, -25.5604>, <-53.07754, 28.6744, -25.04424> }
			triangle { <-52.3881, 27.7241, -25.5604>, <-54.2212, 28.3274, -26.237>, <-53.07754, 28.6744, -25.04424> }
			triangle { <-51.6782, 29.1131, -24.03356>, <-52.1067, 30.02623, -23.9963>, <-50.3049, 29.5867, -23.1855> }
			triangle { <-52.1067, 30.02623, -23.9963>, <-51.6782, 29.1131, -24.03356>, <-53.07754, 28.6744, -25.04424> }
			triangle { <-53.4883, 29.5765, -25.1194>, <-52.1067, 30.02623, -23.9963>, <-53.07754, 28.6744, -25.04424> }
			triangle { <-53.4883, 29.5765, -25.1194>, <-53.07754, 28.6744, -25.04424>, <-54.2212, 28.3274, -26.237> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-6.6262, 16.4923, -2.7552>, <-6.7086, 16.7266, -2.7416>, 1.1834 }
		cylinder { <-6.7086, 16.7266, -2.7416>, <-6.7809, 16.9638, -2.7218>, 1.1834 }
		cylinder { <-6.7809, 16.9638, -2.7218>, <-6.8429, 17.2032, -2.6959>, 1.1834 }
		cylinder { <-6.8429, 17.2032, -2.6959>, <-6.8945, 17.4445, -2.6638>, 1.1834 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.8945, 17.4445, -2.6638>, <-14.5318, 28.8092, -3.9791>, 0.6468 }
			cylinder { <-14.5318, 28.8092, -3.9791>, <-25.4885, 36.01682, -8.1285>, 0.6468 }
			cylinder { <-25.4885, 36.01682, -8.1285>, <-37.6608, 37.6831, -14.3151>, 0.6468 }
			cylinder { <-37.6608, 37.6831, -14.3151>, <-48.7114, 33.4881, -21.3511>, 0.6468 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-48.7114, 33.4881, -21.3511>, <-49.599, 32.1373, -22.5228>, <-50.07811, 33.01892, -22.2049> }
			triangle { <-50.07811, 33.01892, -22.2049>, <-49.599, 32.1373, -22.5228>, <-50.8478, 31.4811, -23.5416> }
			triangle { <-50.07811, 33.01892, -22.2049>, <-50.8478, 31.4811, -23.5416>, <-51.4585, 32.5605, -23.2259> }
			triangle { <-50.8478, 31.4811, -23.5416>, <-52.5667, 32.1386, -24.4229>, <-51.4585, 32.5605, -23.2259> }
			triangle { <-50.07811, 33.01892, -22.2049>, <-50.4094, 33.9607, -22.3372>, <-48.7114, 33.4881, -21.3511> }
			triangle { <-50.4094, 33.9607, -22.3372>, <-50.07811, 33.01892, -22.2049>, <-51.4585, 32.5605, -23.2259> }
			triangle { <-51.7677, 33.472, -23.4659>, <-50.4094, 33.9607, -22.3372>, <-51.4585, 32.5605, -23.2259> }
			triangle { <-51.7677, 33.472, -23.4659>, <-51.4585, 32.5605, -23.2259>, <-52.5667, 32.1386, -24.4229> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-6.8945, 17.4445, -2.6638>, <-6.9519, 17.7457, -2.6536>, 1.4598 }
		cylinder { <-6.9519, 17.7457, -2.6536>, <-7.002571, 18.04774, -2.6726>, 1.4598 }
		cylinder { <-7.002571, 18.04774, -2.6726>, <-7.04598, 18.3476, -2.7208>, 1.4598 }
		cylinder { <-7.04598, 18.3476, -2.7208>, <-7.08173, 18.6425, -2.7977>, 1.4598 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.08173, 18.6425, -2.7977>, <-9.9457, 32.04179, -1.01854>, 0.6497 }
			cylinder { <-9.9457, 32.04179, -1.01854>, <-13.6276, 43.5216, 5.7316>, 0.6497 }
			cylinder { <-13.6276, 43.5216, 5.7316>, <-17.5669, 51.3343, 16.4252>, 0.6497 }
			cylinder { <-17.5669, 51.3343, 16.4252>, <-21.1639, 54.2904, 29.4342>, 0.6497 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-21.1639, 54.2904, 29.4342>, <-21.9344, 53.7108, 31.1925>, <-21.5982, 54.6967, 31.01177> }
			triangle { <-21.5982, 54.6967, 31.01177>, <-21.9344, 53.7108, 31.1925>, <-22.5383, 53.9042, 32.8213> }
			triangle { <-21.5982, 54.6967, 31.01177>, <-22.5383, 53.9042, 32.8213>, <-22.1917, 55.1285, 32.6389> }
			triangle { <-22.5383, 53.9042, 32.8213>, <-23.02754, 55.4502, 34.07495>, <-22.1917, 55.1285, 32.6389> }
			triangle { <-21.5982, 54.6967, 31.01177>, <-21.7405, 55.6755, 30.7996>, <-21.1639, 54.2904, 29.4342> }
			triangle { <-21.7405, 55.6755, 30.7996>, <-21.5982, 54.6967, 31.01177>, <-22.1917, 55.1285, 32.6389> }
			triangle { <-22.4407, 56.0755, 32.4543>, <-21.7405, 55.6755, 30.7996>, <-22.1917, 55.1285, 32.6389> }
			triangle { <-22.4407, 56.0755, 32.4543>, <-22.1917, 55.1285, 32.6389>, <-23.02754, 55.4502, 34.07495> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.08173, 18.6425, -2.7977>, <-7.1529, 18.9583, -2.8791>, 1.5883 }
		cylinder { <-7.1529, 18.9583, -2.8791>, <-7.2557, 19.2661, -2.9574>, 1.5883 }
		cylinder { <-7.2557, 19.2661, -2.9574>, <-7.3891, 19.5629, -3.03189>, 1.5883 }
		cylinder { <-7.3891, 19.5629, -3.03189>, <-7.5519, 19.8459, -3.1018>, 1.5883 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.5519, 19.8459, -3.1018>, <-7.1327, 33.1671, -6.6367>, 0.6483 }
			cylinder { <-7.1327, 33.1671, -6.6367>, <0.3093, 44.3318, -9.813>, 0.6483 }
			cylinder { <0.3093, 44.3318, -9.813>, <12.6566, 50.1634, -11.7269>, 0.6483 }
			cylinder { <12.6566, 50.1634, -11.7269>, <26.3959, 49.00241, -11.8337>, 0.6483 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <26.3959, 49.00241, -11.8337>, <28.03545, 47.8631, -11.6962>, <28.07565, 48.9071, -11.8428> }
			triangle { <28.07565, 48.9071, -11.8428>, <28.03545, 47.8631, -11.6962>, <29.742, 47.5203, -11.5856> }
			triangle { <28.07565, 48.9071, -11.8428>, <29.742, 47.5203, -11.5856>, <29.8485, 48.7923, -11.713> }
			triangle { <29.742, 47.5203, -11.5856>, <31.4741, 48.573, -11.3106>, <29.8485, 48.7923, -11.713> }
			triangle { <28.07565, 48.9071, -11.8428>, <28.2053, 49.8577, -11.5284>, <26.3959, 49.00241, -11.8337> }
			triangle { <28.2053, 49.8577, -11.5284>, <28.07565, 48.9071, -11.8428>, <29.8485, 48.7923, -11.713> }
			triangle { <30.0209, 49.6847, -11.3098>, <28.2053, 49.8577, -11.5284>, <29.8485, 48.7923, -11.713> }
			triangle { <30.0209, 49.6847, -11.3098>, <29.8485, 48.7923, -11.713>, <31.4741, 48.573, -11.3106> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.5519, 19.8459, -3.1018>, <-7.7111, 20.1522, -3.1442>, 1.6548 }
		cylinder { <-7.7111, 20.1522, -3.1442>, <-7.8583, 20.4671, -3.1558>, 1.6548 }
		cylinder { <-7.8583, 20.4671, -3.1558>, <-7.9922, 20.7875, -3.1366>, 1.6548 }
		cylinder { <-7.9922, 20.7875, -3.1366>, <-8.1115, 21.1104, -3.08658>, 1.6548 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.1115, 21.1104, -3.08658>, <-14.7288, 32.6139, -5.929>, 0.6382 }
			cylinder { <-14.7288, 32.6139, -5.929>, <-22.3026, 41.2706, -13.133>, 0.6382 }
			cylinder { <-22.3026, 41.2706, -13.133>, <-29.6799, 45.7627, -23.6018>, 0.6382 }
			cylinder { <-29.6799, 45.7627, -23.6018>, <-35.7376, 45.4061, -35.7417>, 0.6382 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-35.7376, 45.4061, -35.7417>, <-35.8309, 44.6951, -37.5764>, <-36.5002, 45.4005, -37.2117> }
			triangle { <-36.5002, 45.4005, -37.2117>, <-35.8309, 44.6951, -37.5764>, <-36.3946, 44.5768, -39.1937> }
			triangle { <-36.5002, 45.4005, -37.2117>, <-36.3946, 44.5768, -39.1937>, <-37.2029, 45.4705, -38.8166> }
			triangle { <-36.3946, 44.5768, -39.1937>, <-37.5949, 45.6242, -40.4248>, <-37.2029, 45.4705, -38.8166> }
			triangle { <-36.5002, 45.4005, -37.2117>, <-36.8505, 46.3254, -37.1155>, <-35.7376, 45.4061, -35.7417> }
			triangle { <-36.8505, 46.3254, -37.1155>, <-36.5002, 45.4005, -37.2117>, <-37.2029, 45.4705, -38.8166> }
			triangle { <-37.4828, 46.4082, -38.8073>, <-36.8505, 46.3254, -37.1155>, <-37.2029, 45.4705, -38.8166> }
			triangle { <-37.4828, 46.4082, -38.8073>, <-37.2029, 45.4705, -38.8166>, <-37.5949, 45.6242, -40.4248> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.1115, 21.1104, -3.08658>, <-8.2095, 21.4502, -3.05892>, 1.6881 }
		cylinder { <-8.2095, 21.4502, -3.05892>, <-8.283, 21.7973, -3.05489>, 1.6881 }
		cylinder { <-8.283, 21.7973, -3.05489>, <-8.3313, 22.1483, -3.07452>, 1.6881 }
		cylinder { <-8.3313, 22.1483, -3.07452>, <-8.3539, 22.4997, -3.1176>, 1.6881 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.3539, 22.4997, -3.1176>, <-14.1951, 34.1139, 0.09355>, 0.6296 }
			cylinder { <-14.1951, 34.1139, 0.09355>, <-23.3631, 40.773, 7.2296>, 0.6296 }
			cylinder { <-23.3631, 40.773, 7.2296>, <-33.2492, 40.5823, 16.26>, 0.6296 }
			cylinder { <-33.2492, 40.5823, 16.26>, <-41.04041, 33.5961, 24.6152>, 0.6296 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-41.04041, 33.5961, 24.6152>, <-41.5073, 31.909, 25.4596>, <-42.02025, 32.7784, 25.6355> }
			triangle { <-42.02025, 32.7784, 25.6355>, <-41.5073, 31.909, 25.4596>, <-42.4322, 30.8425, 26.3958> }
			triangle { <-42.02025, 32.7784, 25.6355>, <-42.4322, 30.8425, 26.3958>, <-43.1192, 31.8602, 26.6062> }
			triangle { <-42.4322, 30.8425, 26.3958>, <-44.2126, 30.8379, 27.2768>, <-43.1192, 31.8602, 26.6062> }
			triangle { <-42.02025, 32.7784, 25.6355>, <-42.7775, 33.3889, 25.5125>, <-41.04041, 33.5961, 24.6152> }
			triangle { <-42.7775, 33.3889, 25.5125>, <-42.02025, 32.7784, 25.6355>, <-43.1192, 31.8602, 26.6062> }
			triangle { <-43.9176, 32.3772, 26.4394>, <-42.7775, 33.3889, 25.5125>, <-43.1192, 31.8602, 26.6062> }
			triangle { <-43.9176, 32.3772, 26.4394>, <-43.1192, 31.8602, 26.6062>, <-44.2126, 30.8379, 27.2768> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.3539, 22.4997, -3.1176>, <-8.4043, 22.8335, -3.1761>, 1.63 }
		cylinder { <-8.4043, 22.8335, -3.1761>, <-8.4827, 23.1585, -3.2508>, 1.63 }
		cylinder { <-8.4827, 23.1585, -3.2508>, <-8.5885, 23.4716, -3.3411>, 1.63 }
		cylinder { <-8.5885, 23.4716, -3.3411>, <-8.7206, 23.7698, -3.4461>, 1.63 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.7206, 23.7698, -3.4461>, <-9.2915, 37.0546, -4.9047>, 0.629 }
			cylinder { <-9.2915, 37.0546, -4.9047>, <-5.1779, 49.7024, -3.4732>, 0.629 }
			cylinder { <-5.1779, 49.7024, -3.4732>, <2.9141, 59.5432, 0.6028>, 0.629 }
			cylinder { <2.9141, 59.5432, 0.6028>, <13.5964, 64.8885, 6.6241>, 0.629 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <13.5964, 64.8885, 6.6241>, <15.04226, 64.7451, 7.9118>, <14.8883, 65.5812, 7.3419> }
			triangle { <14.8883, 65.5812, 7.3419>, <15.04226, 64.7451, 7.9118>, <16.3506, 65.2772, 8.8437> }
			triangle { <14.8883, 65.5812, 7.3419>, <16.3506, 65.2772, 8.8437>, <16.1777, 66.335, 8.2113> }
			triangle { <16.3506, 65.2772, 8.8437>, <17.2309, 67.00272, 9.2741>, <16.1777, 66.335, 8.2113> }
			triangle { <14.8883, 65.5812, 7.3419>, <14.5683, 66.4957, 7.1985>, <13.5964, 64.8885, 6.6241> }
			triangle { <14.5683, 66.4957, 7.1985>, <14.8883, 65.5812, 7.3419>, <16.1777, 66.335, 8.2113> }
			triangle { <15.855, 67.2434, 8.1787>, <14.5683, 66.4957, 7.1985>, <16.1777, 66.335, 8.2113> }
			triangle { <15.855, 67.2434, 8.1787>, <16.1777, 66.335, 8.2113>, <17.2309, 67.00272, 9.2741> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.7206, 23.7698, -3.4461>, <-8.8383, 24.02416, -3.5071>, 1.3646 }
		cylinder { <-8.8383, 24.02416, -3.5071>, <-8.962, 24.2807, -3.5408>, 1.3646 }
		cylinder { <-8.962, 24.2807, -3.5408>, <-9.09058, 24.5371, -3.5467>, 1.3646 }
		cylinder { <-9.09058, 24.5371, -3.5467>, <-9.2226, 24.7907, -3.5248>, 1.3646 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.2226, 24.7907, -3.5248>, <-14.2373, 36.2427, -7.8855>, 0.6226 }
			cylinder { <-14.2373, 36.2427, -7.8855>, <-17.3092, 45.472, -16.8684>, 0.6226 }
			cylinder { <-17.3092, 45.472, -16.8684>, <-17.9112, 50.8951, -28.9323>, 0.6226 }
			cylinder { <-17.9112, 50.8951, -28.9323>, <-15.9401, 51.5815, -42.00722>, 0.6226 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-15.9401, 51.5815, -42.00722>, <-14.9728, 51.02459, -43.5714>, <-15.7254, 51.702, -43.6039> }
			triangle { <-15.7254, 51.702, -43.6039>, <-14.9728, 51.02459, -43.5714>, <-14.5145, 51.04069, -45.1823> }
			triangle { <-15.7254, 51.702, -43.6039>, <-14.5145, 51.04069, -45.1823>, <-15.3888, 51.904, -45.2688> }
			triangle { <-14.5145, 51.04069, -45.1823>, <-14.8039, 52.1796, -46.7561>, <-15.3888, 51.904, -45.2688> }
			triangle { <-15.7254, 51.702, -43.6039>, <-16.0773, 52.6038, -43.655>, <-15.9401, 51.5815, -42.00722> }
			triangle { <-16.0773, 52.6038, -43.655>, <-15.7254, 51.702, -43.6039>, <-15.3888, 51.904, -45.2688> }
			triangle { <-15.636, 52.8228, -45.3487>, <-16.0773, 52.6038, -43.655>, <-15.3888, 51.904, -45.2688> }
			triangle { <-15.636, 52.8228, -45.3487>, <-15.3888, 51.904, -45.2688>, <-14.8039, 52.1796, -46.7561> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.2226, 24.7907, -3.5248>, <-9.3292, 25.03797, -3.507>, 1.2835 }
		cylinder { <-9.3292, 25.03797, -3.507>, <-9.4175, 25.2924, -3.492>, 1.2835 }
		cylinder { <-9.4175, 25.2924, -3.492>, <-9.487, 25.5528, -3.48>, 1.2835 }
		cylinder { <-9.487, 25.5528, -3.48>, <-9.5375, 25.8176, -3.471>, 1.2835 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.5375, 25.8176, -3.471>, <-17.8668, 35.7054, -2.1154>, 0.6112 }
			cylinder { <-17.8668, 35.7054, -2.1154>, <-29.9306, 40.1491, -0.1909>, 0.6112 }
			cylinder { <-29.9306, 40.1491, -0.1909>, <-42.5941, 37.9942, 1.8025>, 0.6112 }
			cylinder { <-42.5941, 37.9942, 1.8025>, <-52.5673, 29.8006, 3.3469>, 0.6112 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-52.5673, 29.8006, 3.3469>, <-53.221, 28.03575, 3.4782>, <-53.8119, 28.8342, 3.528> }
			triangle { <-53.8119, 28.8342, 3.528>, <-53.221, 28.03575, 3.4782>, <-54.3562, 26.8497, 3.5717> }
			triangle { <-53.8119, 28.8342, 3.528>, <-54.3562, 26.8497, 3.5717>, <-55.1222, 27.7855, 3.5902> }
			triangle { <-54.3562, 26.8497, 3.5717>, <-56.2704, 26.7002, 3.3926>, <-55.1222, 27.7855, 3.5902> }
			triangle { <-53.8119, 28.8342, 3.528>, <-54.4354, 29.4547, 3.1644>, <-52.5673, 29.8006, 3.3469> }
			triangle { <-54.4354, 29.4547, 3.1644>, <-53.8119, 28.8342, 3.528>, <-55.1222, 27.7855, 3.5902> }
			triangle { <-55.7498, 28.3272, 3.1529>, <-54.4354, 29.4547, 3.1644>, <-55.1222, 27.7855, 3.5902> }
			triangle { <-55.7498, 28.3272, 3.1529>, <-55.1222, 27.7855, 3.5902>, <-56.2704, 26.7002, 3.3926> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.5375, 25.8176, -3.471>, <-9.5997, 26.09593, -3.4804>, 1.3574 }
		cylinder { <-9.5997, 26.09593, -3.4804>, <-9.6705, 26.3708, -3.5087>, 1.3574 }
		cylinder { <-9.6705, 26.3708, -3.5087>, <-9.7495, 26.6409, -3.5557>, 1.3574 }
		cylinder { <-9.7495, 26.6409, -3.5557>, <-9.8363, 26.9047, -3.6212>, 1.3574 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.8363, 26.9047, -3.6212>, <-11.7906, 39.3149, -2.3637>, 0.5937 }
			cylinder { <-11.7906, 39.3149, -2.3637>, <-11.5985, 50.7983, 2.881>, 0.5937 }
			cylinder { <-11.5985, 50.7983, 2.881>, <-9.2857, 59.8161, 11.41>, 0.5937 }
			cylinder { <-9.2857, 59.8161, 11.41>, <-5.1621, 65.1597, 22.0804>, 0.5937 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-5.1621, 65.1597, 22.0804>, <-4.8078, 65.04357, 23.8745>, <-4.661, 65.85, 23.3633> }
			triangle { <-4.661, 65.85, 23.3633>, <-4.8078, 65.04357, 23.8745>, <-4.4046, 65.5728, 25.3264> }
			triangle { <-4.661, 65.85, 23.3633>, <-4.4046, 65.5728, 25.3264>, <-4.2532, 66.5899, 24.7586> }
			triangle { <-4.4046, 65.5728, 25.3264>, <-4.1258, 67.2254, 26.1627>, <-4.2532, 66.5899, 24.7586> }
			triangle { <-4.661, 65.85, 23.3633>, <-4.8883, 66.6989, 23.07661>, <-5.1621, 65.1597, 22.0804> }
			triangle { <-4.8883, 66.6989, 23.07661>, <-4.661, 65.85, 23.3633>, <-4.2532, 66.5899, 24.7586> }
			triangle { <-4.5453, 67.4274, 24.5533>, <-4.8883, 66.6989, 23.07661>, <-4.2532, 66.5899, 24.7586> }
			triangle { <-4.5453, 67.4274, 24.5533>, <-4.2532, 66.5899, 24.7586>, <-4.1258, 67.2254, 26.1627> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.8363, 26.9047, -3.6212>, <-9.9362, 27.1478, -3.6646>, 1.2675 }
		cylinder { <-9.9362, 27.1478, -3.6646>, <-10.05422, 27.3853, -3.6899>, 1.2675 }
		cylinder { <-10.05422, 27.3853, -3.6899>, <-10.189, 27.615, -3.6969>, 1.2675 }
		cylinder { <-10.189, 27.615, -3.6969>, <-10.3394, 27.8346, -3.6853>, 1.2675 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.3394, 27.8346, -3.6853>, <-12.6463, 38.9581, -7.5887>, 0.5648 }
			cylinder { <-12.6463, 38.9581, -7.5887>, <-9.8243, 48.1375, -14.8042>, 0.5648 }
			cylinder { <-9.8243, 48.1375, -14.8042>, <-2.6762, 52.761, -23.2787>, 0.5648 }
			cylinder { <-2.6762, 52.761, -23.2787>, <6.7639, 51.5129, -30.6009>, 0.5648 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <6.7639, 51.5129, -30.6009>, <8.02389, 50.5154, -31.2768>, <7.9177, 51.4012, -31.4978> }
			triangle { <7.9177, 51.4012, -31.4978>, <8.02389, 50.5154, -31.2768>, <9.2731, 50.2021, -32.08304> }
			triangle { <7.9177, 51.4012, -31.4978>, <9.2731, 50.2021, -32.08304>, <9.2106, 51.2859, -32.3484> }
			triangle { <9.2731, 50.2021, -32.08304>, <10.5532, 51.1123, -32.9245>, <9.2106, 51.2859, -32.3484> }
			triangle { <7.9177, 51.4012, -31.4978>, <8.1237, 52.2545, -31.4444>, <6.7639, 51.5129, -30.6009> }
			triangle { <8.1237, 52.2545, -31.4444>, <7.9177, 51.4012, -31.4978>, <9.2106, 51.2859, -32.3484> }
			triangle { <9.4964, 52.09787, -32.2518>, <8.1237, 52.2545, -31.4444>, <9.2106, 51.2859, -32.3484> }
			triangle { <9.4964, 52.09787, -32.2518>, <9.2106, 51.2859, -32.3484>, <10.5532, 51.1123, -32.9245> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.3394, 27.8346, -3.6853>, <-10.4559, 28.0413, -3.664>, 1.1332 }
		cylinder { <-10.4559, 28.0413, -3.664>, <-10.5535, 28.2562, -3.6319>, 1.1332 }
		cylinder { <-10.5535, 28.2562, -3.6319>, <-10.6311, 28.4773, -3.5893>, 1.1332 }
		cylinder { <-10.6311, 28.4773, -3.5893>, <-10.688, 28.7025, -3.5366>, 1.1332 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.688, 28.7025, -3.5366>, <-19.3152, 39.7008, -3.4209>, 0.6573 }
			cylinder { <-19.3152, 39.7008, -3.4209>, <-31.3866, 46.1321, -6.3067>, 0.6573 }
			cylinder { <-31.3866, 46.1321, -6.3067>, <-44.3241, 46.623, -11.5779>, 0.6573 }
			cylinder { <-44.3241, 46.623, -11.5779>, <-55.3651, 41.06853, -18.1088>, 0.6573 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-55.3651, 41.06853, -18.1088>, <-56.2024, 39.5348, -19.1397>, <-56.7331, 40.4333, -18.9052> }
			triangle { <-56.7331, 40.4333, -18.9052>, <-56.2024, 39.5348, -19.1397>, <-57.442, 38.6996, -20.08456> }
			triangle { <-56.7331, 40.4333, -18.9052>, <-57.442, 38.6996, -20.08456>, <-58.1169, 39.7907, -19.8715> }
			triangle { <-57.442, 38.6996, -20.08456>, <-59.2275, 39.1804, -21.02303>, <-58.1169, 39.7907, -19.8715> }
			triangle { <-56.7331, 40.4333, -18.9052>, <-57.1203, 41.3527, -19.1339>, <-55.3651, 41.06853, -18.1088> }
			triangle { <-57.1203, 41.3527, -19.1339>, <-56.7331, 40.4333, -18.9052>, <-58.1169, 39.7907, -19.8715> }
			triangle { <-58.4807, 40.6691, -20.2062>, <-57.1203, 41.3527, -19.1339>, <-58.1169, 39.7907, -19.8715> }
			triangle { <-58.4807, 40.6691, -20.2062>, <-58.1169, 39.7907, -19.8715>, <-59.2275, 39.1804, -21.02303> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.688, 28.7025, -3.5366>, <-10.7358, 28.9045, -3.5103>, 0.9955 }
		cylinder { <-10.7358, 28.9045, -3.5103>, <-10.7811, 29.1087, -3.5043>, 0.9955 }
		cylinder { <-10.7811, 29.1087, -3.5043>, <-10.8233, 29.3131, -3.5185>, 0.9955 }
		cylinder { <-10.8233, 29.3131, -3.5185>, <-10.862, 29.5158, -3.5529>, 0.9955 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.862, 29.5158, -3.5529>, <-14.2336, 41.6323, 1.3045>, 0.6339 }
			cylinder { <-14.2336, 41.6323, 1.3045>, <-17.5213, 49.3553, 11.8551>, 0.6339 }
			cylinder { <-17.5213, 49.3553, 11.8551>, <-19.7896, 50.4874, 25.09695>, 0.6339 }
			cylinder { <-19.7896, 50.4874, 25.09695>, <-20.3932, 44.7064, 37.2619>, 0.6339 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-20.3932, 44.7064, 37.2619>, <-20.09432, 43.1508, 38.4106>, <-20.4934, 44.03535, 38.7605> }
			triangle { <-20.4934, 44.03535, 38.7605>, <-20.09432, 43.1508, 38.4106>, <-20.1744, 42.2199, 39.8374> }
			triangle { <-20.4934, 44.03535, 38.7605>, <-20.1744, 42.2199, 39.8374>, <-20.7089, 43.2549, 40.3027> }
			triangle { <-20.1744, 42.2199, 39.8374>, <-21.08721, 42.3249, 41.6139>, <-20.7089, 43.2549, 40.3027> }
			triangle { <-20.4934, 44.03535, 38.7605>, <-21.2404, 44.6128, 39.04856>, <-20.3932, 44.7064, 37.2619> }
			triangle { <-21.2404, 44.6128, 39.04856>, <-20.4934, 44.03535, 38.7605>, <-20.7089, 43.2549, 40.3027> }
			triangle { <-21.5053, 43.732, 40.5912>, <-21.2404, 44.6128, 39.04856>, <-20.7089, 43.2549, 40.3027> }
			triangle { <-21.5053, 43.732, 40.5912>, <-20.7089, 43.2549, 40.3027>, <-21.08721, 42.3249, 41.6139> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.862, 29.5158, -3.5529>, <-10.911, 29.6817, -3.5791>, 0.8322 }
		cylinder { <-10.911, 29.6817, -3.5791>, <-10.9761, 29.8424, -3.6025>, 0.8322 }
		cylinder { <-10.9761, 29.8424, -3.6025>, <-11.05668, 29.9963, -3.6228>, 0.8322 }
		cylinder { <-11.05668, 29.9963, -3.6228>, <-11.1519, 30.142, -3.6399>, 0.8322 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.1519, 30.142, -3.6399>, <-12.8051, 41.9148, -5.7065>, 0.5674 }
			cylinder { <-12.8051, 41.9148, -5.7065>, <-9.221, 53.1494, -8.2639>, 0.5674 }
			cylinder { <-9.221, 53.1494, -8.2639>, <-1.08805, 61.6886, -10.8209>, 0.5674 }
			cylinder { <-1.08805, 61.6886, -10.8209>, <10.03227, 65.8927, -12.8867>, 0.5674 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <10.03227, 65.8927, -12.8867>, <11.7687, 65.6781, -12.8115>, <11.3733, 66.4428, -13.1451> }
			triangle { <11.3733, 66.4428, -13.1451>, <11.7687, 65.6781, -12.8115>, <13.2364, 66.08142, -12.9254> }
			triangle { <11.3733, 66.4428, -13.1451>, <13.2364, 66.08142, -12.9254>, <12.8021, 67.04715, -13.2982> }
			triangle { <13.2364, 66.08142, -12.9254>, <14.1735, 67.5853, -13.1788>, <12.8021, 67.04715, -13.2982> }
			triangle { <11.3733, 66.4428, -13.1451>, <11.11, 67.2843, -13.08859>, <10.03227, 65.8927, -12.8867> }
			triangle { <11.11, 67.2843, -13.08859>, <11.3733, 66.4428, -13.1451>, <12.8021, 67.04715, -13.2982> }
			triangle { <12.6001, 67.8826, -13.1627>, <11.11, 67.2843, -13.08859>, <12.8021, 67.04715, -13.2982> }
			triangle { <12.6001, 67.8826, -13.1627>, <12.8021, 67.04715, -13.2982>, <14.1735, 67.5853, -13.1788> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-11.1519, 30.142, -3.6399>, <-11.24, 30.2913, -3.6419>, 0.825 }
		cylinder { <-11.24, 30.2913, -3.6419>, <-11.3209, 30.4441, -3.6288>, 0.825 }
		cylinder { <-11.3209, 30.4441, -3.6288>, <-11.3938, 30.599, -3.6008>, 0.825 }
		cylinder { <-11.3938, 30.599, -3.6008>, <-11.4581, 30.7543, -3.5582>, 0.825 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.4581, 30.7543, -3.5582>, <-17.2794, 38.4085, -5.7835>, 0.4641 }
			cylinder { <-17.2794, 38.4085, -5.7835>, <-23.6098, 42.6968, -12.02551>, 0.4641 }
			cylinder { <-23.6098, 42.6968, -12.02551>, <-28.648, 42.3991, -20.508>, 0.4641 }
			cylinder { <-28.648, 42.3991, -20.508>, <-30.9603, 37.6, -28.8175>, 0.4641 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-30.9603, 37.6, -28.8175>, <-30.8642, 36.4298, -29.6382>, <-31.2535, 37.0433, -29.8444> }
			triangle { <-31.2535, 37.0433, -29.8444>, <-30.8642, 36.4298, -29.6382>, <-31.01801, 35.7327, -30.6626> }
			triangle { <-31.2535, 37.0433, -29.8444>, <-31.01801, 35.7327, -30.6626>, <-31.4707, 36.4726, -30.9639> }
			triangle { <-31.01801, 35.7327, -30.6626>, <-31.4588, 35.9309, -32.04476>, <-31.4707, 36.4726, -30.9639> }
			triangle { <-31.2535, 37.0433, -29.8444>, <-31.3418, 37.6577, -30.2145>, <-30.9603, 37.6, -28.8175> }
			triangle { <-31.3418, 37.6577, -30.2145>, <-31.2535, 37.0433, -29.8444>, <-31.4707, 36.4726, -30.9639> }
			triangle { <-31.4946, 37.0547, -31.3729>, <-31.3418, 37.6577, -30.2145>, <-31.4707, 36.4726, -30.9639> }
			triangle { <-31.4946, 37.0547, -31.3729>, <-31.4707, 36.4726, -30.9639>, <-31.4588, 35.9309, -32.04476> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-11.4581, 30.7543, -3.5582>, <-11.4897, 30.8488, -3.5404>, 0.4816 }
		cylinder { <-11.4897, 30.8488, -3.5404>, <-11.515, 30.9462, -3.5297>, 0.4816 }
		cylinder { <-11.515, 30.9462, -3.5297>, <-11.534, 31.04566, -3.5263>, 0.4816 }
		cylinder { <-11.534, 31.04566, -3.5263>, <-11.5463, 31.146, -3.5303>, 0.4816 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.5463, 31.146, -3.5303>, <-15.1275, 38.6405, -0.9553>, 0.4089 }
			cylinder { <-15.1275, 38.6405, -0.9553>, <-20.4692, 43.404, 3.9843>, 0.4089 }
			cylinder { <-20.4692, 43.404, 3.9843>, <-26.4306, 44.419, 10.2338>, 0.4089 }
			cylinder { <-26.4306, 44.419, 10.2338>, <-31.7386, 41.469, 16.4584>, 0.4089 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-31.7386, 41.469, 16.4584>, <-32.294, 40.502, 17.04962>, <-32.3963, 41.1365, 17.2218> }
			triangle { <-32.3963, 41.1365, 17.2218>, <-32.294, 40.502, 17.04962>, <-32.9814, 40.00872, 17.7526> }
			triangle { <-32.3963, 41.1365, 17.2218>, <-32.9814, 40.00872, 17.7526>, <-33.1529, 40.7697, 17.967> }
			triangle { <-32.9814, 40.00872, 17.7526>, <-33.9608, 40.3498, 18.5197>, <-33.1529, 40.7697, 17.967> }
			triangle { <-32.3963, 41.1365, 17.2218>, <-32.7341, 41.6761, 17.2307>, <-31.7386, 41.469, 16.4584> }
			triangle { <-32.7341, 41.6761, 17.2307>, <-32.3963, 41.1365, 17.2218>, <-33.1529, 40.7697, 17.967> }
			triangle { <-33.5404, 41.2625, 17.9525>, <-32.7341, 41.6761, 17.2307>, <-33.1529, 40.7697, 17.967> }
			triangle { <-33.5404, 41.2625, 17.9525>, <-33.1529, 40.7697, 17.967>, <-33.9608, 40.3498, 18.5197> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-11.5463, 31.146, -3.5303>, <-11.5607, 31.2136, -3.5359>, 0.33 }
		cylinder { <-11.5607, 31.2136, -3.5359>, <-11.5811, 31.2794, -3.5445>, 0.33 }
		cylinder { <-11.5811, 31.2794, -3.5445>, <-11.6071, 31.3427, -3.5558>, 0.33 }
		cylinder { <-11.6071, 31.3427, -3.5558>, <-11.6386, 31.4029, -3.5698>, 0.33 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.6386, 31.4029, -3.5698>, <-11.7149, 38.1747, -3.4733>, 0.3184 }
			cylinder { <-11.7149, 38.1747, -3.4733>, <-8.7744, 44.07994, -1.9391>, 0.3184 }
			cylinder { <-8.7744, 44.07994, -1.9391>, <-3.5812, 47.5843, 0.6341>, 0.3184 }
			cylinder { <-3.5812, 47.5843, 0.6341>, <2.5153, 47.7773, 3.5779>, 0.3184 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <2.5153, 47.7773, 3.5779>, <3.3038, 47.307, 3.929>, <3.2555, 47.8228, 3.9425> }
			triangle { <3.2555, 47.8228, 3.9425>, <3.3038, 47.307, 3.929>, <4.05354, 47.2237, 4.3353> }
			triangle { <3.2555, 47.8228, 3.9425>, <4.05354, 47.2237, 4.3353>, <4.008854, 47.8501, 4.3868> }
			triangle { <4.05354, 47.2237, 4.3353>, <4.6505, 47.7924, 4.9093>, <4.008854, 47.8501, 4.3868> }
			triangle { <3.2555, 47.8228, 3.9425>, <3.1578, 48.2528, 4.1694>, <2.5153, 47.7773, 3.5779> }
			triangle { <3.1578, 48.2528, 4.1694>, <3.2555, 47.8228, 3.9425>, <4.008854, 47.8501, 4.3868> }
			triangle { <3.9164, 48.2458, 4.6578>, <3.1578, 48.2528, 4.1694>, <4.008854, 47.8501, 4.3868> }
			triangle { <3.9164, 48.2458, 4.6578>, <4.008854, 47.8501, 4.3868>, <4.6505, 47.7924, 4.9093> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-11.6386, 31.4029, -3.5698>, <-11.6665, 31.4554, -3.5775>, 0.2852 }
		cylinder { <-11.6665, 31.4554, -3.5775>, <-11.6951, 31.508, -3.5809>, 0.2852 }
		cylinder { <-11.6951, 31.508, -3.5809>, <-11.7242, 31.5604, -3.5799>, 0.2852 }
		cylinder { <-11.7242, 31.5604, -3.5799>, <-11.7535, 31.6125, -3.5746>, 0.2852 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.7535, 31.6125, -3.5746>, <-13.4225, 35.02011, -5.2809>, 0.1956 }
			cylinder { <-13.4225, 35.02011, -5.2809>, <-14.2912, 37.3407, -8.623>, 0.1956 }
			cylinder { <-14.2912, 37.3407, -8.623>, <-14.1339, 37.9714, -12.7323>, 0.1956 }
			cylinder { <-14.1339, 37.9714, -12.7323>, <-12.9915, 36.7482, -16.5413>, 0.1956 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-12.9915, 36.7482, -16.5413>, <-12.7273, 36.3417, -16.9011>, <-12.8548, 36.612, -17.01081> }
			triangle { <-12.8548, 36.612, -17.01081>, <-12.7273, 36.3417, -16.9011>, <-12.5337, 36.1478, -17.3505> }
			triangle { <-12.8548, 36.612, -17.01081>, <-12.5337, 36.1478, -17.3505>, <-12.6704, 36.4787, -17.4977> }
			triangle { <-12.5337, 36.1478, -17.3505>, <-12.4126, 36.3543, -17.9193>, <-12.6704, 36.4787, -17.4977> }
			triangle { <-12.8548, 36.612, -17.01081>, <-12.8389, 36.8984, -17.1134>, <-12.9915, 36.7482, -16.5413> }
			triangle { <-12.8389, 36.8984, -17.1134>, <-12.8548, 36.612, -17.01081>, <-12.6704, 36.4787, -17.4977> }
			triangle { <-12.6215, 36.7554, -17.6027>, <-12.8389, 36.8984, -17.1134>, <-12.6704, 36.4787, -17.4977> }
			triangle { <-12.6215, 36.7554, -17.6027>, <-12.6704, 36.4787, -17.4977>, <-12.4126, 36.3543, -17.9193> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-11.7535, 31.6125, -3.5746>, <-11.7691, 31.6478, -3.5718>, 0.1843 }
		cylinder { <-11.7691, 31.6478, -3.5718>, <-11.7813, 31.6845, -3.5698>, 0.1843 }
		cylinder { <-11.7813, 31.6845, -3.5698>, <-11.7899, 31.7223, -3.5686>, 0.1843 }
		cylinder { <-11.7899, 31.7223, -3.5686>, <-11.7949, 31.7607, -3.5681>, 0.1843 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.7949, 31.7607, -3.5681>, <-12.1103, 32.1678, -3.5081>, 0.02438 }
			cylinder { <-12.1103, 32.1678, -3.5081>, <-12.5853, 32.352, -3.4113>, 0.02438 }
			cylinder { <-12.5853, 32.352, -3.4113>, <-13.08469, 32.2608, -3.3053>, 0.02438 }
			cylinder { <-13.08469, 32.2608, -3.3053>, <-13.4663, 31.9202, -3.2203>, 0.02438 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-6.6262, 16.4923, -2.7552>, <-6.7715, 16.8821, -2.7826>, 1.9835 }
		cylinder { <-6.7715, 16.8821, -2.7826>, <-6.906, 17.271, -2.8494>, 1.9835 }
		cylinder { <-6.906, 17.271, -2.8494>, <-7.02841, 17.6553, -2.955>, 1.9835 }
		cylinder { <-7.02841, 17.6553, -2.955>, <-7.1374, 18.03128, -3.0985>, 1.9835 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.1374, 18.03128, -3.0985>, <-12.2186, 30.7377, -2.6939>, 0.6437 }
			cylinder { <-12.2186, 30.7377, -2.6939>, <-18.02608, 41.87, 2.7633>, 0.6437 }
			cylinder { <-18.02608, 41.87, 2.7633>, <-23.6757, 49.7332, 12.4425>, 0.6437 }
			cylinder { <-23.6757, 49.7332, 12.4425>, <-28.3075, 53.1304, 24.8699>, 0.6437 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-28.3075, 53.1304, 24.8699>, <-29.02753, 52.5878, 26.6406>, <-28.8762, 53.589, 26.3722> }
			triangle { <-28.8762, 53.589, 26.3722>, <-29.02753, 52.5878, 26.6406>, <-29.7237, 52.8129, 28.2103> }
			triangle { <-28.8762, 53.589, 26.3722>, <-29.7237, 52.8129, 28.2103>, <-29.6067, 54.04682, 27.9166> }
			triangle { <-29.7237, 52.8129, 28.2103>, <-30.5437, 54.334, 29.2774>, <-29.6067, 54.04682, 27.9166> }
			triangle { <-28.8762, 53.589, 26.3722>, <-29.1875, 54.4896, 26.06116>, <-28.3075, 53.1304, 24.8699> }
			triangle { <-29.1875, 54.4896, 26.06116>, <-28.8762, 53.589, 26.3722>, <-29.6067, 54.04682, 27.9166> }
			triangle { <-30.01698, 54.8988, 27.633>, <-29.1875, 54.4896, 26.06116>, <-29.6067, 54.04682, 27.9166> }
			triangle { <-30.01698, 54.8988, 27.633>, <-29.6067, 54.04682, 27.9166>, <-30.5437, 54.334, 29.2774> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.1374, 18.03128, -3.0985>, <-7.2692, 18.3549, -3.2244>, 1.7673 }
		cylinder { <-7.2692, 18.3549, -3.2244>, <-7.4343, 18.6641, -3.3473>, 1.7673 }
		cylinder { <-7.4343, 18.6641, -3.3473>, <-7.6311, 18.956, -3.4659>, 1.7673 }
		cylinder { <-7.6311, 18.956, -3.4659>, <-7.8578, 19.2276, -3.5792>, 1.7673 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.8578, 19.2276, -3.5792>, <-11.1113, 31.648, -8.2944>, 0.6431 }
			cylinder { <-11.1113, 31.648, -8.2944>, <-8.7127, 44.3573, -12.7448>, 0.6431 }
			cylinder { <-8.7127, 44.3573, -12.7448>, <-1.07346, 55.1748, -16.1668>, 0.6431 }
			cylinder { <-1.07346, 55.1748, -16.1668>, <10.4956, 62.2444, -17.9732>, 0.6431 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <10.4956, 62.2444, -17.9732>, <12.4021, 62.5582, -17.5178>, <11.8831, 63.1393, -18.2166> }
			triangle { <11.8831, 63.1393, -18.2166>, <12.4021, 62.5582, -17.5178>, <13.9238, 63.3816, -17.533> }
			triangle { <11.8831, 63.1393, -18.2166>, <13.9238, 63.3816, -17.533>, <13.3263, 64.1498, -18.3529> }
			triangle { <13.9238, 63.3816, -17.533>, <14.6536, 65.1586, -18.1862>, <13.3263, 64.1498, -18.3529> }
			triangle { <11.8831, 63.1393, -18.2166>, <11.3903, 63.9613, -18.5069>, <10.4956, 62.2444, -17.9732> }
			triangle { <11.3903, 63.9613, -18.5069>, <11.8831, 63.1393, -18.2166>, <13.3263, 64.1498, -18.3529> }
			triangle { <12.8811, 65.00832, -18.5468>, <11.3903, 63.9613, -18.5069>, <13.3263, 64.1498, -18.3529> }
			triangle { <12.8811, 65.00832, -18.5468>, <13.3263, 64.1498, -18.3529>, <14.6536, 65.1586, -18.1862> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-7.8578, 19.2276, -3.5792>, <-8.06188, 19.4957, -3.6552>, 1.6433 }
		cylinder { <-8.06188, 19.4957, -3.6552>, <-8.2571, 19.7769, -3.7012>, 1.6433 }
		cylinder { <-8.2571, 19.7769, -3.7012>, <-8.4417, 20.06842, -3.7167>, 1.6433 }
		cylinder { <-8.4417, 20.06842, -3.7167>, <-8.6139, 20.3674, -3.7016>, 1.6433 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.6139, 20.3674, -3.7016>, <-16.938, 30.5765, -7.6028>, 0.646 }
			cylinder { <-16.938, 30.5765, -7.6028>, <-25.6215, 37.7328, -15.4846>, 0.646 }
			cylinder { <-25.6215, 37.7328, -15.4846>, <-33.5006, 40.8772, -26.2906>, 0.646 }
			cylinder { <-33.5006, 40.8772, -26.2906>, <-39.5194, 39.5884, -38.5728>, 0.646 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-39.5194, 39.5884, -38.5728>, <-39.4743, 38.9214, -40.4513>, <-40.2851, 39.4632, -40.05877> }
			triangle { <-40.2851, 39.4632, -40.05877>, <-39.4743, 38.9214, -40.4513>, <-40.0202, 38.7322, -42.09031> }
			triangle { <-40.2851, 39.4632, -40.05877>, <-40.0202, 38.7322, -42.09031>, <-41.00902, 39.4297, -41.6789> }
			triangle { <-40.0202, 38.7322, -42.09031>, <-41.4436, 39.5462, -43.3004>, <-41.00902, 39.4297, -41.6789> }
			triangle { <-40.2851, 39.4632, -40.05877>, <-40.83, 40.299, -39.9314>, <-39.5194, 39.5884, -38.5728> }
			triangle { <-40.83, 40.299, -39.9314>, <-40.2851, 39.4632, -40.05877>, <-41.00902, 39.4297, -41.6789> }
			triangle { <-41.4878, 40.2961, -41.6393>, <-40.83, 40.299, -39.9314>, <-41.00902, 39.4297, -41.6789> }
			triangle { <-41.4878, 40.2961, -41.6393>, <-41.00902, 39.4297, -41.6789>, <-41.4436, 39.5462, -43.3004> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.6139, 20.3674, -3.7016>, <-8.6951, 20.5194, -3.6825>, 0.825 }
		cylinder { <-8.6951, 20.5194, -3.6825>, <-8.7707, 20.6725, -3.652>, 0.825 }
		cylinder { <-8.7707, 20.6725, -3.652>, <-8.8402, 20.8258, -3.6103>, 0.825 }
		cylinder { <-8.8402, 20.8258, -3.6103>, <-8.9032, 20.9785, -3.5576>, 0.825 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.9032, 20.9785, -3.5576>, <-14.6148, 28.8372, -5.3028>, 0.4641 }
			cylinder { <-14.6148, 28.8372, -5.3028>, <-20.8242, 33.6265, -11.297>, 0.4641 }
			cylinder { <-20.8242, 33.6265, -11.297>, <-25.7648, 33.9838, -19.8345>, 0.4641 }
			cylinder { <-25.7648, 33.9838, -19.8345>, <-28.03072, 29.8074, -28.486>, 0.4641 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-28.03072, 29.8074, -28.486>, <-27.9231, 28.7039, -29.3932>, <-28.3184, 29.3274, -29.5524> }
			triangle { <-28.3184, 29.3274, -29.5524>, <-27.9231, 28.7039, -29.3932>, <-28.07011, 28.08516, -30.4676> }
			triangle { <-28.3184, 29.3274, -29.5524>, <-28.07011, 28.08516, -30.4676>, <-28.5301, 28.8413, -30.7122> }
			triangle { <-28.07011, 28.08516, -30.4676>, <-28.513, 28.3834, -31.831>, <-28.5301, 28.8413, -30.7122> }
			triangle { <-28.3184, 29.3274, -29.5524>, <-28.4129, 29.9673, -29.8747>, <-28.03072, 29.8074, -28.486> }
			triangle { <-28.4129, 29.9673, -29.8747>, <-28.3184, 29.3274, -29.5524>, <-28.5301, 28.8413, -30.7122> }
			triangle { <-28.5598, 29.4525, -31.07577>, <-28.4129, 29.9673, -29.8747>, <-28.5301, 28.8413, -30.7122> }
			triangle { <-28.5598, 29.4525, -31.07577>, <-28.5301, 28.8413, -30.7122>, <-28.513, 28.3834, -31.831> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.9032, 20.9785, -3.5576>, <-8.934, 21.07193, -3.5335>, 0.4816 }
		cylinder { <-8.934, 21.07193, -3.5335>, <-8.9584, 21.1686, -3.5163>, 0.4816 }
		cylinder { <-8.9584, 21.1686, -3.5163>, <-8.9763, 21.2677, -3.5061>, 0.4816 }
		cylinder { <-8.9763, 21.2677, -3.5061>, <-8.9875, 21.3683, -3.5031>, 0.4816 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.9875, 21.3683, -3.5031>, <-12.7529, 28.468, -0.1805>, 0.4089 }
			cylinder { <-12.7529, 28.468, -0.1805>, <-18.3468, 32.1834, 5.3447>, 0.4089 }
			cylinder { <-18.3468, 32.1834, 5.3447>, <-24.3156, 31.5491, 11.6371>, 0.4089 }
			cylinder { <-24.3156, 31.5491, 11.6371>, <-29.1086, 26.7298, 17.06174>, 0.4089 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-29.1086, 26.7298, 17.06174>, <-29.4599, 25.5966, 17.4921>, <-29.7095, 26.1657, 17.73> }
			triangle { <-29.7095, 26.1657, 17.73>, <-29.4599, 25.5966, 17.4921>, <-30.05104, 24.8783, 18.0795> }
			triangle { <-29.7095, 26.1657, 17.73>, <-30.05104, 24.8783, 18.0795>, <-30.3982, 25.5494, 18.3689> }
			triangle { <-30.05104, 24.8783, 18.0795>, <-31.1161, 24.8958, 18.807>, <-30.3982, 25.5494, 18.3689> }
			triangle { <-29.7095, 26.1657, 17.73>, <-30.1596, 26.6135, 17.7774>, <-29.1086, 26.7298, 17.06174> }
			triangle { <-30.1596, 26.6135, 17.7774>, <-29.7095, 26.1657, 17.73>, <-30.3982, 25.5494, 18.3689> }
			triangle { <-30.8851, 25.9443, 18.3839>, <-30.1596, 26.6135, 17.7774>, <-30.3982, 25.5494, 18.3689> }
			triangle { <-30.8851, 25.9443, 18.3839>, <-30.3982, 25.5494, 18.3689>, <-31.1161, 24.8958, 18.807> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.9875, 21.3683, -3.5031>, <-9.001201, 21.4363, -3.5041>, 0.33 }
		cylinder { <-9.001201, 21.4363, -3.5041>, <-9.02073, 21.5027, -3.5082>, 0.33 }
		cylinder { <-9.02073, 21.5027, -3.5082>, <-9.04594, 21.567, -3.5153>, 0.33 }
		cylinder { <-9.04594, 21.567, -3.5153>, <-9.0766, 21.6284, -3.5254>, 0.33 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.0766, 21.6284, -3.5254>, <-9.08079, 28.3771, -2.9536>, 0.3184 }
			cylinder { <-9.08079, 28.3771, -2.9536>, <-6.09498, 34.1254, -0.9754>, 0.3184 }
			cylinder { <-6.09498, 34.1254, -0.9754>, <-0.8949, 37.3798, 1.895>, 0.3184 }
			cylinder { <-0.8949, 37.3798, 1.895>, <5.1681, 37.2947, 4.9121>, 0.3184 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <5.1681, 37.2947, 4.9121>, <5.942, 36.7907, 5.2487>, <5.9047, 37.3061, 5.2867> }
			triangle { <5.9047, 37.3061, 5.2867>, <5.942, 36.7907, 5.2487>, <6.6846, 36.6712, 5.6589> }
			triangle { <5.9047, 37.3061, 5.2867>, <6.6846, 36.6712, 5.6589>, <6.653, 37.2952, 5.7401> }
			triangle { <6.6846, 36.6712, 5.6589>, <7.2869, 37.1981, 6.2663>, <6.653, 37.2952, 5.7401> }
			triangle { <5.9047, 37.3061, 5.2867>, <5.8137, 37.7268, 5.533>, <5.1681, 37.2947, 4.9121> }
			triangle { <5.8137, 37.7268, 5.533>, <5.9047, 37.3061, 5.2867>, <6.653, 37.2952, 5.7401> }
			triangle { <6.5659, 37.6793, 6.02899>, <5.8137, 37.7268, 5.533>, <6.653, 37.2952, 5.7401> }
			triangle { <6.5659, 37.6793, 6.02899>, <6.653, 37.2952, 5.7401>, <7.2869, 37.1981, 6.2663> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.0766, 21.6284, -3.5254>, <-9.1041, 21.6816, -3.5283>, 0.2852 }
		cylinder { <-9.1041, 21.6816, -3.5283>, <-9.1324, 21.7343, -3.5254>, 0.2852 }
		cylinder { <-9.1324, 21.7343, -3.5254>, <-9.1613, 21.7862, -3.5167>, 0.2852 }
		cylinder { <-9.1613, 21.7862, -3.5167>, <-9.1903, 21.8366, -3.5023>, 0.2852 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.1903, 21.8366, -3.5023>, <-10.9859, 25.5027, -4.3051>, 0.1956 }
			cylinder { <-10.9859, 25.5027, -4.3051>, <-12.2156, 28.6319, -6.7557>, 0.1956 }
			cylinder { <-12.2156, 28.6319, -6.7557>, <-12.6431, 30.6233, -10.3835>, 0.1956 }
			cylinder { <-12.6431, 30.6233, -10.3835>, <-12.1865, 31.09458, -14.4918>, 0.1956 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-12.1865, 31.09458, -14.4918>, <-11.9223, 30.9305, -15.00949>, <-12.1377, 31.1642, -14.9923> }
			triangle { <-12.1377, 31.1642, -14.9923>, <-11.9223, 30.9305, -15.00949>, <-11.8007, 30.9611, -15.5206> }
			triangle { <-12.1377, 31.1642, -14.9923>, <-11.8007, 30.9611, -15.5206>, <-12.04945, 31.2576, -15.5142> }
			triangle { <-11.8007, 30.9611, -15.5206>, <-11.8789, 31.3624, -15.9829>, <-12.04945, 31.2576, -15.5142> }
			triangle { <-12.1377, 31.1642, -14.9923>, <-12.2215, 31.4569, -14.9823>, <-12.1865, 31.09458, -14.4918> }
			triangle { <-12.2215, 31.4569, -14.9823>, <-12.1377, 31.1642, -14.9923>, <-12.04945, 31.2576, -15.5142> }
			triangle { <-12.1004, 31.5532, -15.5145>, <-12.2215, 31.4569, -14.9823>, <-12.04945, 31.2576, -15.5142> }
			triangle { <-12.1004, 31.5532, -15.5145>, <-12.04945, 31.2576, -15.5142>, <-11.8789, 31.3624, -15.9829> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.1903, 21.8366, -3.5023>, <-9.2067, 21.8706, -3.4934>, 0.1843 }
		cylinder { <-9.2067, 21.8706, -3.4934>, <-9.2204, 21.9058, -3.485>, 0.1843 }
		cylinder { <-9.2204, 21.9058, -3.485>, <-9.2316, 21.942, -3.4771>, 0.1843 }
		cylinder { <-9.2316, 21.942, -3.4771>, <-9.2401, 21.9791, -3.4697>, 0.1843 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.2401, 21.9791, -3.4697>, <-9.5624, 22.3624, -3.335>, 0.02438 }
			cylinder { <-9.5624, 22.3624, -3.335>, <-10.02422, 22.551, -3.1934>, 0.02438 }
			cylinder { <-10.02422, 22.551, -3.1934>, <-10.5269, 22.5046, -3.07504>, 0.02438 }
			cylinder { <-10.5269, 22.5046, -3.07504>, <-10.9632, 22.2332, -3.00516>, 0.02438 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.6139, 20.3674, -3.7016>, <-8.722, 20.5913, -3.7071>, 1.1834 }
		cylinder { <-8.722, 20.5913, -3.7071>, <-8.8132, 20.8217, -3.729>, 1.1834 }
		cylinder { <-8.8132, 20.8217, -3.729>, <-8.8866, 21.05632, -3.7671>, 1.1834 }
		cylinder { <-8.8866, 21.05632, -3.7671>, <-8.9415, 21.2928, -3.8209>, 1.1834 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.9415, 21.2928, -3.8209>, <-15.5858, 33.3314, -3.445>, 0.6468 }
			cylinder { <-15.5858, 33.3314, -3.445>, <-24.9473, 42.714, 0.2353>, 0.6468 }
			cylinder { <-24.9473, 42.714, 0.2353>, <-35.7715, 48.1832, 6.7271>, 0.6468 }
			cylinder { <-35.7715, 48.1832, 6.7271>, <-46.6076, 49.006, 15.1601>, 0.6468 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-46.6076, 49.006, 15.1601>, <-48.1733, 48.1397, 16.04559>, <-47.9263, 49.1528, 16.1881> }
			triangle { <-47.9263, 49.1528, 16.1881>, <-48.1733, 48.1397, 16.04559>, <-49.6296, 48.06116, 16.9946> }
			triangle { <-47.9263, 49.1528, 16.1881>, <-49.6296, 48.06116, 16.9946>, <-49.404, 49.3095, 17.1628> }
			triangle { <-49.6296, 48.06116, 16.9946>, <-50.9489, 49.3734, 17.8321>, <-49.404, 49.3095, 17.1628> }
			triangle { <-47.9263, 49.1528, 16.1881>, <-48.04121, 50.1392, 16.02032>, <-46.6076, 49.006, 15.1601> }
			triangle { <-48.04121, 50.1392, 16.02032>, <-47.9263, 49.1528, 16.1881>, <-49.404, 49.3095, 17.1628> }
			triangle { <-49.6157, 50.255, 16.9505>, <-48.04121, 50.1392, 16.02032>, <-49.404, 49.3095, 17.1628> }
			triangle { <-49.6157, 50.255, 16.9505>, <-49.404, 49.3095, 17.1628>, <-50.9489, 49.3734, 17.8321> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-8.9415, 21.2928, -3.8209>, <-9.03295, 21.574, -3.9028>, 1.4598 }
		cylinder { <-9.03295, 21.574, -3.9028>, <-9.147, 21.842, -3.9992>, 1.4598 }
		cylinder { <-9.147, 21.842, -3.9992>, <-9.2828, 22.09422, -4.1094>, 1.4598 }
		cylinder { <-9.2828, 22.09422, -4.1094>, <-9.4389, 22.3281, -4.2321>, 1.4598 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.4389, 22.3281, -4.2321>, <-11.3956, 35.8161, -6.5022>, 0.6497 }
			cylinder { <-11.3956, 35.8161, -6.5022>, <-7.8173, 49.07442, -4.9782>, 0.6497 }
			cylinder { <-7.8173, 49.07442, -4.9782>, <0.4509, 58.9719, -0.02001>, 0.6497 }
			cylinder { <0.4509, 58.9719, -0.02001>, <11.4566, 63.1712, 7.2014>, 0.6497 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <11.4566, 63.1712, 7.2014>, <13.03801, 62.7394, 8.3565>, <12.7837, 63.7276, 8.07982> }
			triangle { <12.7837, 63.7276, 8.07982>, <13.03801, 62.7394, 8.3565>, <14.4073, 63.07098, 9.3909> }
			triangle { <12.7837, 63.7276, 8.07982>, <14.4073, 63.07098, 9.3909>, <14.1139, 64.2942, 9.1266> }
			triangle { <14.4073, 63.07098, 9.3909>, <15.2199, 64.6935, 10.3439>, <14.1139, 64.2942, 9.1266> }
			triangle { <12.7837, 63.7276, 8.07982>, <12.3811, 64.6394, 8.2528>, <11.4566, 63.1712, 7.2014> }
			triangle { <12.3811, 64.6394, 8.2528>, <12.7837, 63.7276, 8.07982>, <14.1139, 64.2942, 9.1266> }
			triangle { <13.7162, 65.1639, 9.4062>, <12.3811, 64.6394, 8.2528>, <14.1139, 64.2942, 9.1266> }
			triangle { <13.7162, 65.1639, 9.4062>, <14.1139, 64.2942, 9.1266>, <15.2199, 64.6935, 10.3439> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-9.4389, 22.3281, -4.2321>, <-9.6193, 22.5892, -4.3354>, 1.5883 }
		cylinder { <-9.6193, 22.5892, -4.3354>, <-9.8087, 22.8546, -4.4075>, 1.5883 }
		cylinder { <-9.8087, 22.8546, -4.4075>, <-10.00513, 23.1215, -4.4476>, 1.5883 }
		cylinder { <-10.00513, 23.1215, -4.4476>, <-10.2067, 23.3875, -4.4553>, 1.5883 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.2067, 23.3875, -4.4553>, <-16.8484, 33.6246, -10.8752>, 0.6483 }
			cylinder { <-16.8484, 33.6246, -10.8752>, <-20.3879, 40.9259, -22.02378>, 0.6483 }
			cylinder { <-20.3879, 40.9259, -22.02378>, <-20.06947, 43.7322, -35.52>, 0.6483 }
			cylinder { <-20.06947, 43.7322, -35.52>, <-15.9609, 41.4442, -48.4819>, 0.6483 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-15.9609, 41.4442, -48.4819>, <-14.7812, 40.475, -49.7757>, <-15.4823, 41.2036, -50.07687> }
			triangle { <-15.4823, 41.2036, -50.07687>, <-14.7812, 40.475, -49.7757>, <-14.06071, 40.11, -51.3216> }
			triangle { <-15.4823, 41.2036, -50.07687>, <-14.06071, 40.11, -51.3216>, <-14.8602, 41.02346, -51.7363> }
			triangle { <-14.06071, 40.11, -51.3216>, <-14.00399, 40.9411, -53.1898>, <-14.8602, 41.02346, -51.7363> }
			triangle { <-15.4823, 41.2036, -50.07687>, <-15.7479, 42.131, -50.3744>, <-15.9609, 41.4442, -48.4819> }
			triangle { <-15.7479, 42.131, -50.3744>, <-15.4823, 41.2036, -50.07687>, <-14.8602, 41.02346, -51.7363> }
			triangle { <-15.0125, 41.9551, -52.04847>, <-15.7479, 42.131, -50.3744>, <-14.8602, 41.02346, -51.7363> }
			triangle { <-15.0125, 41.9551, -52.04847>, <-14.8602, 41.02346, -51.7363>, <-14.00399, 40.9411, -53.1898> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.2067, 23.3875, -4.4553>, <-10.2683, 23.4677, -4.4528>, 0.4816 }
		cylinder { <-10.2683, 23.4677, -4.4528>, <-10.3304, 23.5473, -4.4453>, 0.4816 }
		cylinder { <-10.3304, 23.5473, -4.4453>, <-10.3928, 23.6261, -4.4329>, 0.4816 }
		cylinder { <-10.3928, 23.6261, -4.4329>, <-10.4553, 23.7038, -4.4157>, 0.4816 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.4553, 23.7038, -4.4157>, <-15.3342, 30.5948, -6.498>, 0.4089 }
			cylinder { <-15.3342, 30.5948, -6.498>, <-18.8874, 36.5141, -11.7856>, 0.4089 }
			cylinder { <-18.8874, 36.5141, -11.7856>, <-20.5054, 40.4463, -19.3714>, 0.4089 }
			cylinder { <-20.5054, 40.4463, -19.3714>, <-19.9105, 41.7166, -27.9538>, 0.4089 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-19.9105, 41.7166, -27.9538>, <-19.2956, 41.5405, -29.04189>, <-19.8587, 41.8924, -28.9989> }
			triangle { <-19.8587, 41.8924, -28.9989>, <-19.2956, 41.5405, -29.04189>, <-19.07561, 41.6776, -30.1109> }
			triangle { <-19.8587, 41.8924, -28.9989>, <-19.07561, 41.6776, -30.1109>, <-19.7405, 42.138, -30.08891> }
			triangle { <-19.07561, 41.6776, -30.1109>, <-19.462, 42.4513, -31.06813>, <-19.7405, 42.138, -30.08891> }
			triangle { <-19.8587, 41.8924, -28.9989>, <-20.189, 42.436, -28.9712>, <-19.9105, 41.7166, -27.9538> }
			triangle { <-20.189, 42.436, -28.9712>, <-19.8587, 41.8924, -28.9989>, <-19.7405, 42.138, -30.08891> }
			triangle { <-20.00647, 42.7058, -30.083>, <-20.189, 42.436, -28.9712>, <-19.7405, 42.138, -30.08891> }
			triangle { <-20.00647, 42.7058, -30.083>, <-19.7405, 42.138, -30.08891>, <-19.462, 42.4513, -31.06813> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.4553, 23.7038, -4.4157>, <-10.4941, 23.7603, -4.4046>, 0.33 }
		cylinder { <-10.4941, 23.7603, -4.4046>, <-10.5288, 23.8195, -4.3945>, 0.33 }
		cylinder { <-10.5288, 23.8195, -4.3945>, <-10.5591, 23.8812, -4.3851>, 0.33 }
		cylinder { <-10.5591, 23.8812, -4.3851>, <-10.5849, 23.9451, -4.3768>, 0.33 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.5849, 23.9451, -4.3768>, <-15.7842, 28.07297, -3.03555>, 0.3184 }
			cylinder { <-15.7842, 28.07297, -3.03555>, <-22.3165, 29.02106, -1.5182>, 0.3184 }
			cylinder { <-22.3165, 29.02106, -1.5182>, <-28.4844, 26.543, -0.219>, 0.3184 }
			cylinder { <-28.4844, 26.543, -0.219>, <-32.6854, 21.2827, 0.5243>, 0.3184 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-32.6854, 21.2827, 0.5243>, <-32.8435, 20.3128, 0.5027>, <-33.2157, 20.6554, 0.615> }
			triangle { <-33.2157, 20.6554, 0.615>, <-32.8435, 20.3128, 0.5027>, <-33.3032, 19.5902, 0.5273> }
			triangle { <-33.2157, 20.6554, 0.615>, <-33.3032, 19.5902, 0.5273>, <-33.7793, 19.9867, 0.6423> }
			triangle { <-33.3032, 19.5902, 0.5273>, <-34.2739, 19.331, 0.5252>, <-33.7793, 19.9867, 0.6423> }
			triangle { <-33.2157, 20.6554, 0.615>, <-33.6144, 20.9286, 0.5042>, <-32.6854, 21.2827, 0.5243> }
			triangle { <-33.6144, 20.9286, 0.5042>, <-33.2157, 20.6554, 0.615>, <-33.7793, 19.9867, 0.6423> }
			triangle { <-34.1775, 20.2238, 0.4884>, <-33.6144, 20.9286, 0.5042>, <-33.7793, 19.9867, 0.6423> }
			triangle { <-34.1775, 20.2238, 0.4884>, <-33.7793, 19.9867, 0.6423>, <-34.2739, 19.331, 0.5252> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.5849, 23.9451, -4.3768>, <-10.6098, 23.9995, -4.3747>, 0.2852 }
		cylinder { <-10.6098, 23.9995, -4.3747>, <-10.6372, 24.05284, -4.3779>, 0.2852 }
		cylinder { <-10.6372, 24.05284, -4.3779>, <-10.6667, 24.1043, -4.3863>, 0.2852 }
		cylinder { <-10.6667, 24.1043, -4.3863>, <-10.6982, 24.1535, -4.3997>, 0.2852 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.6982, 24.1535, -4.3997>, <-12.2912, 27.9747, -3.9878>, 0.1956 }
			cylinder { <-12.2912, 27.9747, -3.9878>, <-13.08313, 31.6873, -2.2852>, 0.1956 }
			cylinder { <-13.08313, 31.6873, -2.2852>, <-12.9676, 34.7937, 0.4799>, 0.1956 }
			cylinder { <-12.9676, 34.7937, 0.4799>, <-11.9603, 36.8776, 3.937>, 0.1956 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-11.9603, 36.8776, 3.937>, <-11.8336, 36.8782, 4.5274>, <-11.8406, 37.1439, 4.3523> }
			triangle { <-11.8406, 37.1439, 4.3523>, <-11.8336, 36.8782, 4.5274>, <-11.7345, 37.08757, 5.000044> }
			triangle { <-11.8406, 37.1439, 4.3523>, <-11.7345, 37.08757, 5.000044>, <-11.754, 37.4211, 4.8046> }
			triangle { <-11.7345, 37.08757, 5.000044>, <-11.7511, 37.6461, 5.2618>, <-11.754, 37.4211, 4.8046> }
			triangle { <-11.8406, 37.1439, 4.3523>, <-11.9707, 37.4007, 4.2524>, <-11.9603, 36.8776, 3.937> }
			triangle { <-11.9707, 37.4007, 4.2524>, <-11.8406, 37.1439, 4.3523>, <-11.754, 37.4211, 4.8046> }
			triangle { <-11.9041, 37.6705, 4.7319>, <-11.9707, 37.4007, 4.2524>, <-11.754, 37.4211, 4.8046> }
			triangle { <-11.9041, 37.6705, 4.7319>, <-11.754, 37.4211, 4.8046>, <-11.7511, 37.6461, 5.2618> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.6982, 24.1535, -4.3997>, <-10.7209, 24.1843, -4.4058>, 0.1843 }
		cylinder { <-10.7209, 24.1843, -4.4058>, <-10.746, 24.2137, -4.4091>, 0.1843 }
		cylinder { <-10.746, 24.2137, -4.4091>, <-10.7731, 24.2414, -4.4096>, 0.1843 }
		cylinder { <-10.7731, 24.2414, -4.4096>, <-10.8019, 24.2672, -4.4074>, 0.1843 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.8019, 24.2672, -4.4074>, <-11.08229, 24.6899, -4.5149>, 0.02438 }
			cylinder { <-11.08229, 24.6899, -4.5149>, <-11.2196, 25.1336, -4.7455>, 0.02438 }
			cylinder { <-11.2196, 25.1336, -4.7455>, <-11.1954, 25.5388, -5.06825>, 0.02438 }
			cylinder { <-11.1954, 25.5388, -5.06825>, <-11.01313, 25.8511, -5.4398>, 0.02438 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.2067, 23.3875, -4.4553>, <-10.3959, 23.6791, -4.4672>, 1.6548 }
		cylinder { <-10.3959, 23.6791, -4.4672>, <-10.5633, 23.9836, -4.4829>, 1.6548 }
		cylinder { <-10.5633, 23.9836, -4.4829>, <-10.708, 24.2993, -4.5022>, 1.6548 }
		cylinder { <-10.708, 24.2993, -4.5022>, <-10.8292, 24.6245, -4.5251>, 1.6548 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.8292, 24.6245, -4.5251>, <-20.7366, 33.9004, -4.4878>, 0.6382 }
			cylinder { <-20.7366, 33.9004, -4.4878>, <-33.7065, 37.7812, -3.5285>, 0.6382 }
			cylinder { <-33.7065, 37.7812, -3.5285>, <-46.9692, 35.4381, -1.8521>, 0.6382 }
			cylinder { <-46.9692, 35.4381, -1.8521>, <-57.6925, 27.3716, 0.1833>, 0.6382 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-57.6925, 27.3716, 0.1833>, <-58.4722, 25.5643, 0.2573>, <-59.02833, 26.4243, 0.4294> }
			triangle { <-59.02833, 26.4243, 0.4294>, <-58.4722, 25.5643, 0.2573>, <-59.7175, 24.3893, 0.3849> }
			triangle { <-59.02833, 26.4243, 0.4294>, <-59.7175, 24.3893, 0.3849>, <-60.4493, 25.4045, 0.553> }
			triangle { <-59.7175, 24.3893, 0.3849>, <-61.7306, 24.3583, 0.3879>, <-60.4493, 25.4045, 0.553> }
			triangle { <-59.02833, 26.4243, 0.4294>, <-59.6709, 27.134, 0.1634>, <-57.6925, 27.3716, 0.1833> }
			triangle { <-59.6709, 27.134, 0.1634>, <-59.02833, 26.4243, 0.4294>, <-60.4493, 25.4045, 0.553> }
			triangle { <-61.1087, 26.03865, 0.2053>, <-59.6709, 27.134, 0.1634>, <-60.4493, 25.4045, 0.553> }
			triangle { <-61.1087, 26.03865, 0.2053>, <-60.4493, 25.4045, 0.553>, <-61.7306, 24.3583, 0.3879> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-10.8292, 24.6245, -4.5251>, <-10.9622, 24.95, -4.572>, 1.6881 }
		cylinder { <-10.9622, 24.95, -4.572>, <-11.1038, 25.2677, -4.6422>, 1.6881 }
		cylinder { <-11.1038, 25.2677, -4.6422>, <-11.2533, 25.5756, -4.7355>, 1.6881 }
		cylinder { <-11.2533, 25.5756, -4.7355>, <-11.4099, 25.8723, -4.8511>, 1.6881 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.4099, 25.8723, -4.8511>, <-15.2955, 38.6549, -3.9418>, 0.6296 }
			cylinder { <-15.2955, 38.6549, -3.9418>, <-16.4113, 50.5698, 2.06725>, 0.6296 }
			cylinder { <-16.4113, 50.5698, 2.06725>, <-14.5431, 59.329, 12.0224>, 0.6296 }
			cylinder { <-14.5431, 59.329, 12.0224>, <-10.04975, 63.2507, 24.01194>, 0.6296 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-10.04975, 63.2507, 24.01194>, <-9.3612, 62.8062, 25.7742>, <-9.5171, 63.7709, 25.4663> }
			triangle { <-9.5171, 63.7709, 25.4663>, <-9.3612, 62.8062, 25.7742>, <-8.8557, 63.09663, 27.3646> }
			triangle { <-9.5171, 63.7709, 25.4663>, <-8.8557, 63.09663, 27.3646>, <-9.07361, 64.2842, 27.05785> }
			triangle { <-8.8557, 63.09663, 27.3646>, <-8.8839, 64.6068, 28.6548>, <-9.07361, 64.2842, 27.05785> }
			triangle { <-9.5171, 63.7709, 25.4663>, <-10.02556, 64.6086, 25.4336>, <-10.04975, 63.2507, 24.01194> }
			triangle { <-10.02556, 64.6086, 25.4336>, <-9.5171, 63.7709, 25.4663>, <-9.07361, 64.2842, 27.05785> }
			triangle { <-9.631, 65.07095, 27.1108>, <-10.02556, 64.6086, 25.4336>, <-9.07361, 64.2842, 27.05785> }
			triangle { <-9.631, 65.07095, 27.1108>, <-9.07361, 64.2842, 27.05785>, <-8.8839, 64.6068, 28.6548> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-11.4099, 25.8723, -4.8511>, <-11.5855, 26.1525, -4.9406>, 1.63 }
		cylinder { <-11.5855, 26.1525, -4.9406>, <-11.7839, 26.4238, -5.00697>, 1.63 }
		cylinder { <-11.7839, 26.4238, -5.00697>, <-12.00315, 26.6836, -5.04959>, 1.63 }
		cylinder { <-12.00315, 26.6836, -5.04959>, <-12.2411, 26.9294, -5.06808>, 1.63 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-12.2411, 26.9294, -5.06808>, <-17.1326, 38.248, -10.2546>, 0.629 }
			cylinder { <-17.1326, 38.248, -10.2546>, <-16.4693, 48.6159, -18.6811>, 0.629 }
			cylinder { <-16.4693, 48.6159, -18.6811>, <-10.4078, 55.5845, -28.3576>, 0.629 }
			cylinder { <-10.4078, 55.5845, -28.3576>, <-0.3795, 57.5083, -36.9989>, 0.629 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-0.3795, 57.5083, -36.9989>, <1.3493, 56.9793, -37.7061>, <0.827, 57.7839, -38.06299> }
			triangle { <0.827, 57.7839, -38.06299>, <1.3493, 56.9793, -37.7061>, <2.7476, 57.1109, -38.65> }
			triangle { <0.827, 57.7839, -38.06299>, <2.7476, 57.1109, -38.65>, <2.1768, 58.1271, -39.08622> }
			triangle { <2.7476, 57.1109, -38.65>, <3.6079, 58.4778, -39.8028>, <2.1768, 58.1271, -39.08622> }
			triangle { <0.827, 57.7839, -38.06299>, <0.6397, 58.7424, -38.1372>, <-0.3795, 57.5083, -36.9989> }
			triangle { <0.6397, 58.7424, -38.1372>, <0.827, 57.7839, -38.06299>, <2.1768, 58.1271, -39.08622> }
			triangle { <2.09003, 59.0875, -39.1134>, <0.6397, 58.7424, -38.1372>, <2.1768, 58.1271, -39.08622> }
			triangle { <2.09003, 59.0875, -39.1134>, <2.1768, 58.1271, -39.08622>, <3.6079, 58.4778, -39.8028> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-12.2411, 26.9294, -5.06808>, <-12.4218, 27.1521, -5.0708>, 1.3646 }
		cylinder { <-12.4218, 27.1521, -5.0708>, <-12.5823, 27.3896, -5.06074>, 1.3646 }
		cylinder { <-12.5823, 27.3896, -5.06074>, <-12.721, 27.6397, -5.03799>, 1.3646 }
		cylinder { <-12.721, 27.6397, -5.03799>, <-12.8365, 27.8998, -5.002782>, 1.3646 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-12.8365, 27.8998, -5.002782>, <-22.7986, 36.5245, -6.2991>, 0.6226 }
			cylinder { <-22.7986, 36.5245, -6.2991>, <-35.03551, 39.7285, -10.2111>, 0.6226 }
			cylinder { <-35.03551, 39.7285, -10.2111>, <-46.6572, 36.7551, -15.8149>, 0.6226 }
			cylinder { <-46.6572, 36.7551, -15.8149>, <-54.9194, 28.3065, -21.7872>, 0.6226 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-54.9194, 28.3065, -21.7872>, <-55.255, 26.5786, -22.5583>, <-55.9556, 27.3097, -22.5239> }
			triangle { <-55.9556, 27.3097, -22.5239>, <-55.255, 26.5786, -22.5583>, <-56.1155, 25.4079, -23.3915> }
			triangle { <-55.9556, 27.3097, -22.5239>, <-56.1155, 25.4079, -23.3915>, <-56.9864, 26.2787, -23.4186> }
			triangle { <-56.1155, 25.4079, -23.3915>, <-57.7535, 25.3123, -24.4711>, <-56.9864, 26.2787, -23.4186> }
			triangle { <-55.9556, 27.3097, -22.5239>, <-56.479, 28.02666, -22.9134>, <-54.9194, 28.3065, -21.7872> }
			triangle { <-56.479, 28.02666, -22.9134>, <-55.9556, 27.3097, -22.5239>, <-56.9864, 26.2787, -23.4186> }
			triangle { <-57.4685, 26.9487, -23.8984>, <-56.479, 28.02666, -22.9134>, <-56.9864, 26.2787, -23.4186> }
			triangle { <-57.4685, 26.9487, -23.8984>, <-56.9864, 26.2787, -23.4186>, <-57.7535, 25.3123, -24.4711> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-12.8365, 27.8998, -5.002782>, <-12.8731, 27.9931, -4.9881>, 0.4816 }
		cylinder { <-12.8731, 27.9931, -4.9881>, <-12.9053, 28.08761, -4.9714>, 0.4816 }
		cylinder { <-12.9053, 28.08761, -4.9714>, <-12.9331, 28.1831, -4.9527>, 0.4816 }
		cylinder { <-12.9331, 28.1831, -4.9527>, <-12.9565, 28.2793, -4.9318>, 0.4816 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-12.9565, 28.2793, -4.9318>, <-18.4357, 35.0318, -5.01436>, 0.4089 }
			cylinder { <-18.4357, 35.0318, -5.01436>, <-26.09285, 38.6719, -6.9489>, 0.4089 }
			cylinder { <-26.09285, 38.6719, -6.9489>, <-34.1194, 38.3402, -10.2787>, 0.4089 }
			cylinder { <-34.1194, 38.3402, -10.2787>, <-40.62, 34.115, -14.2174>, 0.4089 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-40.62, 34.115, -14.2174>, <-41.06573, 33.07066, -14.7685>, <-41.4274, 33.6251, -14.7013> }
			triangle { <-41.4274, 33.6251, -14.7013>, <-41.06573, 33.07066, -14.7685>, <-41.7832, 32.451, -15.3265> }
			triangle { <-41.4274, 33.6251, -14.7013>, <-41.7832, 32.451, -15.3265>, <-42.2391, 33.1183, -15.29> }
			triangle { <-41.7832, 32.451, -15.3265>, <-42.8766, 32.6274, -15.9879>, <-42.2391, 33.1183, -15.29> }
			triangle { <-41.4274, 33.6251, -14.7013>, <-41.6865, 34.1649, -14.9177>, <-40.62, 34.115, -14.2174> }
			triangle { <-41.6865, 34.1649, -14.9177>, <-41.4274, 33.6251, -14.7013>, <-42.2391, 33.1183, -15.29> }
			triangle { <-42.4794, 33.6263, -15.5683>, <-41.6865, 34.1649, -14.9177>, <-42.2391, 33.1183, -15.29> }
			triangle { <-42.4794, 33.6263, -15.5683>, <-42.2391, 33.1183, -15.29>, <-42.8766, 32.6274, -15.9879> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-12.9565, 28.2793, -4.9318>, <-12.9721, 28.3463, -4.9225>, 0.33 }
		cylinder { <-12.9721, 28.3463, -4.9225>, <-12.9871, 28.4139, -4.9183>, 0.33 }
		cylinder { <-12.9871, 28.4139, -4.9183>, <-13.00156, 28.4817, -4.9191>, 0.33 }
		cylinder { <-13.00156, 28.4817, -4.9191>, <-13.01527, 28.5495, -4.925>, 0.33 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.01527, 28.5495, -4.925>, <-14.6143, 34.8588, -3.05209>, 0.3184 }
			cylinder { <-14.6143, 34.8588, -3.05209>, <-16.2592, 40.01741, 1.01662>, 0.3184 }
			cylinder { <-16.2592, 40.01741, 1.01662>, <-17.7296, 43.334, 6.7358>, 0.3184 }
			cylinder { <-17.7296, 43.334, 6.7358>, <-18.8283, 44.3642, 13.3391>, 0.3184 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-18.8283, 44.3642, 13.3391>, <-19.1524, 44.03624, 14.2072>, <-18.9587, 44.5124, 14.1416> }
			triangle { <-18.9587, 44.5124, 14.1416>, <-19.1524, 44.03624, 14.2072>, <-19.3714, 44.08442, 15.0341> }
			triangle { <-18.9587, 44.5124, 14.1416>, <-19.3714, 44.08442, 15.0341>, <-19.1637, 44.6765, 14.9762> }
			triangle { <-19.3714, 44.08442, 15.0341>, <-19.4988, 44.803, 15.7245>, <-19.1637, 44.6765, 14.9762> }
			triangle { <-18.9587, 44.5124, 14.1416>, <-18.9997, 45.00298, 14.08179>, <-18.8283, 44.3642, 13.3391> }
			triangle { <-18.9997, 45.00298, 14.08179>, <-18.9587, 44.5124, 14.1416>, <-19.1637, 44.6765, 14.9762> }
			triangle { <-19.2567, 45.154, 14.9333>, <-18.9997, 45.00298, 14.08179>, <-19.1637, 44.6765, 14.9762> }
			triangle { <-19.2567, 45.154, 14.9333>, <-19.1637, 44.6765, 14.9762>, <-19.4988, 44.803, 15.7245> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-13.01527, 28.5495, -4.925>, <-13.03276, 28.6067, -4.9291>, 0.2852 }
		cylinder { <-13.03276, 28.6067, -4.9291>, <-13.05573, 28.662, -4.9322>, 0.2852 }
		cylinder { <-13.05573, 28.662, -4.9322>, <-13.08395, 28.7149, -4.9342>, 0.2852 }
		cylinder { <-13.08395, 28.7149, -4.9342>, <-13.1171, 28.7648, -4.9351>, 0.2852 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.1171, 28.7648, -4.9351>, <-13.4396, 32.89, -5.3682>, 0.1956 }
			cylinder { <-13.4396, 32.89, -5.3682>, <-11.6971, 36.6048, -6.05626>, 0.1956 }
			cylinder { <-11.6971, 36.6048, -6.05626>, <-8.3425, 38.944, -6.8205>, 0.1956 }
			cylinder { <-8.3425, 38.944, -6.8205>, <-4.2473, 39.2997, -7.4624>, 0.1956 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-4.2473, 39.2997, -7.4624>, <-3.7046, 39.04208, -7.5232>, <-3.7487, 39.3569, -7.5384> }
			triangle { <-3.7487, 39.3569, -7.5384>, <-3.7046, 39.04208, -7.5232>, <-3.1809, 39.02466, -7.5718> }
			triangle { <-3.7487, 39.3569, -7.5384>, <-3.1809, 39.02466, -7.5718>, <-3.2152, 39.4101, -7.5775> }
			triangle { <-3.1809, 39.02466, -7.5718>, <-2.7077, 39.4189, -7.5324>, <-3.2152, 39.4101, -7.5775> }
			triangle { <-3.7487, 39.3569, -7.5384>, <-3.7407, 39.6387, -7.4229>, <-4.2473, 39.2997, -7.4624> }
			triangle { <-3.7407, 39.6387, -7.4229>, <-3.7487, 39.3569, -7.5384>, <-3.2152, 39.4101, -7.5775> }
			triangle { <-3.1879, 39.6749, -7.4391>, <-3.7407, 39.6387, -7.4229>, <-3.2152, 39.4101, -7.5775> }
			triangle { <-3.1879, 39.6749, -7.4391>, <-3.2152, 39.4101, -7.5775>, <-2.7077, 39.4189, -7.5324> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-13.1171, 28.7648, -4.9351>, <-13.1374, 28.7977, -4.9332>, 0.1843 }
		cylinder { <-13.1374, 28.7977, -4.9332>, <-13.1565, 28.8311, -4.9288>, 0.1843 }
		cylinder { <-13.1565, 28.8311, -4.9288>, <-13.1742, 28.8649, -4.9218>, 0.1843 }
		cylinder { <-13.1742, 28.8649, -4.9218>, <-13.1905, 28.8987, -4.9124>, 0.1843 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.1905, 28.8987, -4.9124>, <-13.4994, 29.3103, -4.9769>, 0.02438 }
			cylinder { <-13.4994, 29.3103, -4.9769>, <-13.8459, 29.6094, -5.2204>, 0.02438 }
			cylinder { <-13.8459, 29.6094, -5.2204>, <-14.1706, 29.7449, -5.6013>, 0.02438 }
			cylinder { <-14.1706, 29.7449, -5.6013>, <-14.4178, 29.6934, -6.05425>, 0.02438 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-12.8365, 27.8998, -5.002782>, <-12.9421, 28.148, -4.9957>, 1.2835 }
		cylinder { <-12.9421, 28.148, -4.9957>, <-13.04359, 28.3972, -5.01479>, 1.2835 }
		cylinder { <-13.04359, 28.3972, -5.01479>, <-13.1399, 28.6451, -5.05979>, 1.2835 }
		cylinder { <-13.1399, 28.6451, -5.05979>, <-13.2302, 28.8894, -5.1303>, 1.2835 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.2302, 28.8894, -5.1303>, <-18.4678, 40.6794, -3.5344>, 0.6112 }
			cylinder { <-18.4678, 40.6794, -3.5344>, <-23.7946, 50.6957, 2.8124>, 0.6112 }
			cylinder { <-23.7946, 50.6957, 2.8124>, <-28.3998, 57.4133, 12.944>, 0.6112 }
			cylinder { <-28.3998, 57.4133, 12.944>, <-31.5822, 59.8096, 25.3179>, 0.6112 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-31.5822, 59.8096, 25.3179>, <-32.12, 59.1806, 27.0134>, <-31.9738, 60.1448, 26.818> }
			triangle { <-31.9738, 60.1448, 26.818>, <-32.12, 59.1806, 27.0134>, <-32.6326, 59.2924, 28.5718> }
			triangle { <-31.9738, 60.1448, 26.818>, <-32.6326, 59.2924, 28.5718>, <-32.5148, 60.4794, 28.3723> }
			triangle { <-32.6326, 59.2924, 28.5718>, <-33.2716, 60.6702, 29.7601>, <-32.5148, 60.4794, 28.3723> }
			triangle { <-31.9738, 60.1448, 26.818>, <-32.2713, 61.02631, 26.617>, <-31.5822, 59.8096, 25.3179> }
			triangle { <-32.2713, 61.02631, 26.617>, <-31.9738, 60.1448, 26.818>, <-32.5148, 60.4794, 28.3723> }
			triangle { <-32.9046, 61.3149, 28.2028>, <-32.2713, 61.02631, 26.617>, <-32.5148, 60.4794, 28.3723> }
			triangle { <-32.9046, 61.3149, 28.2028>, <-32.5148, 60.4794, 28.3723>, <-33.2716, 60.6702, 29.7601> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-13.2302, 28.8894, -5.1303>, <-13.3515, 29.1377, -5.201>, 1.3574 }
		cylinder { <-13.3515, 29.1377, -5.201>, <-13.4976, 29.3736, -5.2673>, 1.3574 }
		cylinder { <-13.4976, 29.3736, -5.2673>, <-13.667, 29.5949, -5.3285>, 1.3574 }
		cylinder { <-13.667, 29.5949, -5.3285>, <-13.858, 29.7994, -5.3839>, 1.3574 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.858, 29.7994, -5.3839>, <-16.2934, 41.6856, -8.8771>, 0.5937 }
			cylinder { <-16.2934, 41.6856, -8.8771>, <-12.01607, 53.02564, -12.4157>, 0.5937 }
			cylinder { <-12.01607, 53.02564, -12.4157>, <-2.2431, 60.5928, -14.993>, 0.5937 }
			cylinder { <-2.2431, 60.5928, -14.993>, <10.2445, 62.2339, -15.8756>, 0.5937 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <10.2445, 62.2339, -15.8756>, <11.9395, 61.5395, -15.8257>, <11.7622, 62.4764, -15.9807> }
			triangle { <11.7622, 62.4764, -15.9807>, <11.9395, 61.5395, -15.8257>, <13.5364, 61.5695, -15.8186> }
			triangle { <11.7622, 62.4764, -15.9807>, <13.5364, 61.5695, -15.8186>, <13.3744, 62.7238, -15.964> }
			triangle { <13.5364, 61.5695, -15.8186>, <14.8902, 62.8571, -15.6878>, <13.3744, 62.7238, -15.964> }
			triangle { <11.7622, 62.4764, -15.9807>, <11.7078, 63.3611, -15.7182>, <10.2445, 62.2339, -15.8756> }
			triangle { <11.7078, 63.3611, -15.7182>, <11.7622, 62.4764, -15.9807>, <13.3744, 62.7238, -15.964> }
			triangle { <13.3742, 63.5675, -15.6218>, <11.7078, 63.3611, -15.7182>, <13.3744, 62.7238, -15.964> }
			triangle { <13.3742, 63.5675, -15.6218>, <13.3744, 62.7238, -15.964>, <14.8902, 62.8571, -15.6878> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-13.858, 29.7994, -5.3839>, <-14.02927, 30.00147, -5.4132>, 1.2675 }
		cylinder { <-14.02927, 30.00147, -5.4132>, <-14.1915, 30.2126, -5.4195>, 1.2675 }
		cylinder { <-14.1915, 30.2126, -5.4195>, <-14.3434, 30.4309, -5.403>, 1.2675 }
		cylinder { <-14.3434, 30.4309, -5.403>, <-14.4833, 30.6542, -5.3638>, 1.2675 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-14.4833, 30.6542, -5.3638>, <-22.6614, 38.9831, -8.1987>, 0.5648 }
			cylinder { <-22.6614, 38.9831, -8.1987>, <-31.1372, 43.9748, -15.09323>, 0.5648 }
			cylinder { <-31.1372, 43.9748, -15.09323>, <-38.2832, 44.6706, -24.7234>, 0.5648 }
			cylinder { <-38.2832, 44.6706, -24.7234>, <-42.7271, 40.9369, -35.24>, 0.5648 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-42.7271, 40.9369, -35.24>, <-42.5877, 39.9445, -36.6666>, <-43.296, 40.5121, -36.5223> }
			triangle { <-43.296, 40.5121, -36.5223>, <-42.5877, 39.9445, -36.6666>, <-42.9575, 39.425, -38.04583> }
			triangle { <-43.296, 40.5121, -36.5223>, <-42.9575, 39.425, -38.04583>, <-43.815, 40.133, -37.9348> }
			triangle { <-42.9575, 39.425, -38.04583>, <-44.07542, 39.8726, -39.3593>, <-43.815, 40.133, -37.9348> }
			triangle { <-43.296, 40.5121, -36.5223>, <-43.7412, 41.2604, -36.6463>, <-42.7271, 40.9369, -35.24> }
			triangle { <-43.7412, 41.2604, -36.6463>, <-43.296, 40.5121, -36.5223>, <-43.815, 40.133, -37.9348> }
			triangle { <-44.1951, 40.8854, -38.1342>, <-43.7412, 41.2604, -36.6463>, <-43.815, 40.133, -37.9348> }
			triangle { <-44.1951, 40.8854, -38.1342>, <-43.815, 40.133, -37.9348>, <-44.07542, 39.8726, -39.3593> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-14.4833, 30.6542, -5.3638>, <-14.5954, 30.8635, -5.3455>, 1.1332 }
		cylinder { <-14.5954, 30.8635, -5.3455>, <-14.6935, 31.08064, -5.3442>, 1.1332 }
		cylinder { <-14.6935, 31.08064, -5.3442>, <-14.7764, 31.3033, -5.3599>, 1.1332 }
		cylinder { <-14.7764, 31.3033, -5.3599>, <-14.8436, 31.5295, -5.3925>, 1.1332 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-14.8436, 31.5295, -5.3925>, <-22.7133, 42.7417, -2.6067>, 0.6573 }
			cylinder { <-22.7133, 42.7417, -2.6067>, <-32.8307, 49.4968, 4.279>, 0.6573 }
			cylinder { <-32.8307, 49.4968, 4.279>, <-43.03529, 50.352, 13.7945>, 0.6573 }
			cylinder { <-43.03529, 50.352, 13.7945>, <-51.1477, 45.1249, 23.9074>, 0.6573 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-51.1477, 45.1249, 23.9074>, <-51.835, 43.5278, 24.9528>, <-52.1602, 44.5286, 25.1438> }
			triangle { <-52.1602, 44.5286, 25.1438>, <-51.835, 43.5278, 24.9528>, <-52.8525, 42.6623, 26.1115> }
			triangle { <-52.1602, 44.5286, 25.1438>, <-52.8525, 42.6623, 26.1115>, <-53.3205, 43.8518, 26.3509> }
			triangle { <-52.8525, 42.6623, 26.1115>, <-54.5377, 43.05544, 27.2541>, <-53.3205, 43.8518, 26.3509> }
			triangle { <-52.1602, 44.5286, 25.1438>, <-52.8265, 45.3025, 25.07475>, <-51.1477, 45.1249, 23.9074> }
			triangle { <-52.8265, 45.3025, 25.07475>, <-52.1602, 44.5286, 25.1438>, <-53.3205, 43.8518, 26.3509> }
			triangle { <-54.05311, 44.5366, 26.2481>, <-52.8265, 45.3025, 25.07475>, <-53.3205, 43.8518, 26.3509> }
			triangle { <-54.05311, 44.5366, 26.2481>, <-53.3205, 43.8518, 26.3509>, <-54.5377, 43.05544, 27.2541> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-14.8436, 31.5295, -5.3925>, <-14.9195, 31.7208, -5.4301>, 0.9955 }
		cylinder { <-14.9195, 31.7208, -5.4301>, <-15.01155, 31.9029, -5.4765>, 0.9955 }
		cylinder { <-15.01155, 31.9029, -5.4765>, <-15.1188, 32.07412, -5.5311>, 0.9955 }
		cylinder { <-15.1188, 32.07412, -5.5311>, <-15.2403, 32.2326, -5.5935>, 0.9955 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-15.2403, 32.2326, -5.5935>, <-18.2014, 45.3119, -6.9844>, 0.6339 }
			cylinder { <-18.2014, 45.3119, -6.9844>, <-15.6617, 58.4636, -5.4508>, 0.6339 }
			cylinder { <-15.6617, 58.4636, -5.4508>, <-8.1635, 68.8793, -1.3202>, 0.6339 }
			cylinder { <-8.1635, 68.8793, -1.3202>, <2.6918, 74.3346, 4.5253>, 0.6339 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <2.6918, 74.3346, 4.5253>, <4.3192, 74.1299, 5.5923>, <3.9983, 75.04172, 5.232> }
			triangle { <3.9983, 75.04172, 5.232>, <4.3192, 74.1299, 5.5923>, <5.6886, 74.6392, 6.4721> }
			triangle { <3.9983, 75.04172, 5.232>, <5.6886, 74.6392, 6.4721>, <5.3165, 75.7779, 6.1005> }
			triangle { <5.6886, 74.6392, 6.4721>, <6.436, 76.3596, 7.1661>, <5.3165, 75.7779, 6.1005> }
			triangle { <3.9983, 75.04172, 5.232>, <3.5625, 75.9226, 5.3244>, <2.6918, 74.3346, 4.5253> }
			triangle { <3.5625, 75.9226, 5.3244>, <3.9983, 75.04172, 5.232>, <5.3165, 75.7779, 6.1005> }
			triangle { <4.8939, 76.6304, 6.3003>, <3.5625, 75.9226, 5.3244>, <5.3165, 75.7779, 6.1005> }
			triangle { <4.8939, 76.6304, 6.3003>, <5.3165, 75.7779, 6.1005>, <6.436, 76.3596, 7.1661> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-15.2403, 32.2326, -5.5935>, <-15.3449, 32.367, -5.6332>, 0.8322 }
		cylinder { <-15.3449, 32.367, -5.6332>, <-15.4519, 32.5027, -5.6604>, 0.8322 }
		cylinder { <-15.4519, 32.5027, -5.6604>, <-15.5609, 32.6387, -5.6749>, 0.8322 }
		cylinder { <-15.5609, 32.6387, -5.6749>, <-15.6711, 32.7746, -5.6765>, 0.8322 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-15.6711, 32.7746, -5.6765>, <-22.3421, 41.6617, -10.3796>, 0.5674 }
			cylinder { <-22.3421, 41.6617, -10.3796>, <-27.06626, 48.7131, -18.9565>, 0.5674 }
			cylinder { <-27.06626, 48.7131, -18.9565>, <-29.1242, 52.8553, -30.1014>, 0.5674 }
			cylinder { <-29.1242, 52.8553, -30.1014>, <-28.2028, 53.4576, -42.1177>, 0.5674 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-28.2028, 53.4576, -42.1177>, <-27.2712, 53.2005, -43.5781>, <-28.1237, 53.5548, -43.5847> }
			triangle { <-28.1237, 53.5548, -43.5847>, <-27.2712, 53.2005, -43.5781>, <-26.9519, 53.2807, -45.06869> }
			triangle { <-28.1237, 53.5548, -43.5847>, <-26.9519, 53.2807, -45.06869>, <-27.9676, 53.7558, -45.1227> }
			triangle { <-26.9519, 53.2807, -45.06869>, <-27.6129, 54.1024, -46.515>, <-27.9676, 53.7558, -45.1227> }
			triangle { <-28.1237, 53.5548, -43.5847>, <-28.701, 54.2216, -43.6366>, <-28.2028, 53.4576, -42.1177> }
			triangle { <-28.701, 54.2216, -43.6366>, <-28.1237, 53.5548, -43.5847>, <-27.9676, 53.7558, -45.1227> }
			triangle { <-28.4613, 54.4673, -45.207>, <-28.701, 54.2216, -43.6366>, <-27.9676, 53.7558, -45.1227> }
			triangle { <-28.4613, 54.4673, -45.207>, <-27.9676, 53.7558, -45.1227>, <-27.6129, 54.1024, -46.515> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-15.6711, 32.7746, -5.6765>, <-15.7703, 32.9167, -5.6807>, 0.825 }
		cylinder { <-15.7703, 32.9167, -5.6807>, <-15.859, 33.06563, -5.6875>, 0.825 }
		cylinder { <-15.859, 33.06563, -5.6875>, <-15.9367, 33.2204, -5.6967>, 0.825 }
		cylinder { <-15.9367, 33.2204, -5.6967>, <-16.00292, 33.3802, -5.7085>, 0.825 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-16.00292, 33.3802, -5.7085>, <-23.2574, 40.07032, -5.5072>, 0.4641 }
			cylinder { <-23.2574, 40.07032, -5.5072>, <-32.605, 43.06757, -4.4752>, 0.4641 }
			cylinder { <-32.605, 43.06757, -4.4752>, <-42.2506, 41.7964, -2.8107>, 0.4641 }
			cylinder { <-42.2506, 41.7964, -2.8107>, <-50.3423, 36.5011, -0.8332>, 0.4641 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-50.3423, 36.5011, -0.8332>, <-50.999, 35.231, -0.7455>, <-51.3475, 35.8832, -0.5921> }
			triangle { <-51.3475, 35.8832, -0.5921>, <-50.999, 35.231, -0.7455>, <-51.9565, 34.4438, -0.5952> }
			triangle { <-51.3475, 35.8832, -0.5921>, <-51.9565, 34.4438, -0.5952>, <-52.4242, 35.2179, -0.436> }
			triangle { <-51.9565, 34.4438, -0.5952>, <-53.415, 34.5277, -0.4962>, <-52.4242, 35.2179, -0.436> }
			triangle { <-51.3475, 35.8832, -0.5921>, <-51.7877, 36.4334, -0.7528>, <-50.3423, 36.5011, -0.8332> }
			triangle { <-51.7877, 36.4334, -0.7528>, <-51.3475, 35.8832, -0.5921>, <-52.4242, 35.2179, -0.436> }
			triangle { <-52.8844, 35.7146, -0.6554>, <-51.7877, 36.4334, -0.7528>, <-52.4242, 35.2179, -0.436> }
			triangle { <-52.8844, 35.7146, -0.6554>, <-52.4242, 35.2179, -0.436>, <-53.415, 34.5277, -0.4962> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-16.00292, 33.3802, -5.7085>, <-16.04451, 33.4715, -5.7219>, 0.4816 }
		cylinder { <-16.04451, 33.4715, -5.7219>, <-16.08882, 33.5603, -5.7417>, 0.4816 }
		cylinder { <-16.08882, 33.5603, -5.7417>, <-16.1356, 33.6462, -5.768>, 0.4816 }
		cylinder { <-16.1356, 33.6462, -5.768>, <-16.1846, 33.7286, -5.8005>, 0.4816 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-16.1846, 33.7286, -5.8005>, <-18.8471, 41.9748, -5.06957>, 0.4089 }
			cylinder { <-18.8471, 41.9748, -5.06957>, <-19.3929, 49.6272, -0.9746>, 0.4089 }
			cylinder { <-19.3929, 49.6272, -0.9746>, <-17.7054, 55.05145, 5.6096>, 0.4089 }
			cylinder { <-17.7054, 55.05145, 5.6096>, <-14.1449, 57.08926, 13.2774>, 0.4089 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-14.1449, 57.08926, 13.2774>, <-13.5429, 56.7346, 14.3285>, <-13.7237, 57.3642, 14.2117> }
			triangle { <-13.7237, 57.3642, 14.2117>, <-13.5429, 56.7346, 14.3285>, <-13.115, 56.8511, 15.3352> }
			triangle { <-13.7237, 57.3642, 14.2117>, <-13.115, 56.8511, 15.3352>, <-13.3488, 57.6197, 15.2395> }
			triangle { <-13.115, 56.8511, 15.3352>, <-13.1253, 57.7353, 16.2745>, <-13.3488, 57.6197, 15.2395> }
			triangle { <-13.7237, 57.3642, 14.2117>, <-14.1025, 57.8704, 14.2864>, <-14.1449, 57.08926, 13.2774> }
			triangle { <-14.1025, 57.8704, 14.2864>, <-13.7237, 57.3642, 14.2117>, <-13.3488, 57.6197, 15.2395> }
			triangle { <-13.7496, 58.08437, 15.3689>, <-14.1025, 57.8704, 14.2864>, <-13.3488, 57.6197, 15.2395> }
			triangle { <-13.7496, 58.08437, 15.3689>, <-13.3488, 57.6197, 15.2395>, <-13.1253, 57.7353, 16.2745> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-16.1846, 33.7286, -5.8005>, <-16.2228, 33.7837, -5.8179>, 0.33 }
		cylinder { <-16.2228, 33.7837, -5.8179>, <-16.2654, 33.8371, -5.8305>, 0.33 }
		cylinder { <-16.2654, 33.8371, -5.8305>, <-16.3119, 33.888, -5.8379>, 0.33 }
		cylinder { <-16.3119, 33.888, -5.8379>, <-16.3618, 33.9362, -5.8403>, 0.33 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-16.3618, 33.9362, -5.8403>, <-19.1532, 39.5245, -8.4575>, 0.3184 }
			cylinder { <-19.1532, 39.5245, -8.4575>, <-19.2032, 44.684, -12.8449>, 0.3184 }
			cylinder { <-19.2032, 44.684, -12.8449>, <-16.5, 48.196, -17.9664>, 0.3184 }
			cylinder { <-16.5, 48.196, -17.9664>, <-11.6819, 49.2313, -22.6125>, 0.3184 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-11.6819, 49.2313, -22.6125>, <-10.8116, 48.9911, -23.00123>, <-11.1039, 49.3777, -23.1847> }
			triangle { <-11.1039, 49.3777, -23.1847>, <-10.8116, 48.9911, -23.00123>, <-10.1304, 49.07187, -23.5144> }
			triangle { <-11.1039, 49.3777, -23.1847>, <-10.1304, 49.07187, -23.5144>, <-10.4543, 49.5625, -23.741> }
			triangle { <-10.1304, 49.07187, -23.5144>, <-9.7567, 49.7594, -24.1445>, <-10.4543, 49.5625, -23.741> }
			triangle { <-11.1039, 49.3777, -23.1847>, <-11.2243, 49.856, -23.2364>, <-11.6819, 49.2313, -22.6125> }
			triangle { <-11.2243, 49.856, -23.2364>, <-11.1039, 49.3777, -23.1847>, <-10.4543, 49.5625, -23.741> }
			triangle { <-10.5228, 50.04516, -23.7714>, <-11.2243, 49.856, -23.2364>, <-10.4543, 49.5625, -23.741> }
			triangle { <-10.5228, 50.04516, -23.7714>, <-10.4543, 49.5625, -23.741>, <-9.7567, 49.7594, -24.1445> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-16.3618, 33.9362, -5.8403>, <-16.4021, 33.9806, -5.8405>, 0.2852 }
		cylinder { <-16.4021, 33.9806, -5.8405>, <-16.4393, 34.02762, -5.839>, 0.2852 }
		cylinder { <-16.4393, 34.02762, -5.839>, <-16.4732, 34.07697, -5.8356>, 0.2852 }
		cylinder { <-16.4732, 34.07697, -5.8356>, <-16.5036, 34.1283, -5.8305>, 0.2852 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-16.5036, 34.1283, -5.8305>, <-19.8974, 36.4966, -6.2574>, 0.1956 }
			cylinder { <-19.8974, 36.4966, -6.2574>, <-23.8497, 37.1598, -7.375>, 0.1956 }
			cylinder { <-23.8497, 37.1598, -7.375>, <-27.5163, 35.9762, -8.9447>, 0.1956 }
			cylinder { <-27.5163, 35.9762, -8.9447>, <-30.1144, 33.1987, -10.6313>, 0.1956 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		mesh { // leaf
			triangle { <-30.1144, 33.1987, -10.6313>, <-30.2078, 32.6581, -10.8836>, <-30.4412, 32.8698, -10.8381> }
			triangle { <-30.4412, 32.8698, -10.8381>, <-30.2078, 32.6581, -10.8836>, <-30.4795, 32.2801, -11.1292> }
			triangle { <-30.4412, 32.8698, -10.8381>, <-30.4795, 32.2801, -11.1292>, <-30.7712, 32.5322, -11.09492> }
			triangle { <-30.4795, 32.2801, -11.1292>, <-31.02649, 32.2228, -11.4093>, <-30.7712, 32.5322, -11.09492> }
			triangle { <-30.4412, 32.8698, -10.8381>, <-30.6344, 33.08612, -10.9313>, <-30.1144, 33.1987, -10.6313> }
			triangle { <-30.6344, 33.08612, -10.9313>, <-30.4412, 32.8698, -10.8381>, <-30.7712, 32.5322, -11.09492> }
			triangle { <-30.9538, 32.7357, -11.2183>, <-30.6344, 33.08612, -10.9313>, <-30.7712, 32.5322, -11.09492> }
			triangle { <-30.9538, 32.7357, -11.2183>, <-30.7712, 32.5322, -11.09492>, <-31.02649, 32.2228, -11.4093> }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
	union { // internode
		cylinder { <-16.5036, 34.1283, -5.8305>, <-16.523, 34.1618, -5.83>, 0.1843 }
		cylinder { <-16.523, 34.1618, -5.83>, <-16.5421, 34.1955, -5.8324>, 0.1843 }
		cylinder { <-16.5421, 34.1955, -5.8324>, <-16.5608, 34.229, -5.8376>, 0.1843 }
		cylinder { <-16.5608, 34.229, -5.8376>, <-16.579, 34.2623, -5.8455>, 0.1843 }
		pigment { color rgb <0.57, 0.79, 0.66> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-16.579, 34.2623, -5.8455>, <-16.8437, 34.6981, -5.7512>, 0.02438 }
			cylinder { <-16.8437, 34.6981, -5.7512>, <-17.08954, 35.05802, -5.4703>, 0.02438 }
			cylinder { <-17.08954, 35.05802, -5.4703>, <-17.2791, 35.2872, -5.04554>, 0.02438 }
			cylinder { <-17.2791, 35.2872, -5.04554>, <-17.3835, 35.3508, -4.5416>, 0.02438 }
			pigment { color rgb <0.57, 0.79, 0.66> }}
		}
} // end marsh_grass

