// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare planta02 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.3476, 2.03739, 0.2083>, 0.07122 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <0.3476, 2.03739, 0.2083>, <0.4777, 3.1131, 0.2571>, 0.03718 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.4777, 3.1131, 0.2571>, <0.3332, 3.3566, 0.06885>, 0.02003 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <0.3332, 3.3566, 0.06885>, <0.138, 3.6259, -0.1576>, <0.1569, 3.6209, -0.1854> }
			triangle { <0.138, 3.6259, -0.1576>, <0.0185, 3.5834, -0.2698>, <0.1569, 3.6209, -0.1854> }
			triangle { <0.138, 3.6259, -0.1576>, <0.02201, 3.5977, -0.227>, <0.0185, 3.5834, -0.2698> }
			triangle { <0.0185, 3.5834, -0.2698>, <0.07053, 3.5897, -0.2745>, <0.1569, 3.6209, -0.1854> }
			triangle { <0.1569, 3.6209, -0.1854>, <0.2249, 3.4988, -0.1044>, <0.3332, 3.3566, 0.06885> }
			triangle { <0.3332, 3.3566, 0.06885>, <0.1835, 3.5075, -0.06129>, <0.138, 3.6259, -0.1576> }
			triangle { <0.1835, 3.5075, -0.06129>, <0.09057, 3.5986, -0.143>, <0.138, 3.6259, -0.1576> }
			triangle { <0.09057, 3.5986, -0.143>, <0.02201, 3.5977, -0.227>, <0.138, 3.6259, -0.1576> }
			triangle { <0.1569, 3.6209, -0.1854>, <0.07053, 3.5897, -0.2745>, <0.1424, 3.5819, -0.2247> }
			triangle { <0.1424, 3.5819, -0.2247>, <0.2249, 3.4988, -0.1044>, <0.1569, 3.6209, -0.1854> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.4777, 3.1131, 0.2571>, <0.6064, 20.4039, -1.2077>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.6064, 20.4039, -1.2077>, <-3.5064, 25.1852, -6.3666>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-3.5064, 25.1852, -6.3666>, <-8.897, 30.3186, -12.4909>, <-8.4359, 30.1647, -13.143> }
			triangle { <-8.897, 30.3186, -12.4909>, <-11.6372, 28.6489, -14.9749>, <-8.4359, 30.1647, -13.143> }
			triangle { <-8.897, 30.3186, -12.4909>, <-11.5889, 29.1277, -14.00213>, <-11.6372, 28.6489, -14.9749> }
			triangle { <-11.6372, 28.6489, -14.9749>, <-10.4159, 28.9216, -15.1283>, <-8.4359, 30.1647, -13.143> }
			triangle { <-8.4359, 30.1647, -13.143>, <-6.4804, 27.7144, -10.8727>, <-3.5064, 25.1852, -6.3666> }
			triangle { <-3.5064, 25.1852, -6.3666>, <-7.4875, 27.9436, -9.8574>, <-8.897, 30.3186, -12.4909> }
			triangle { <-7.4875, 27.9436, -9.8574>, <-9.9529, 29.5916, -12.03919>, <-8.897, 30.3186, -12.4909> }
			triangle { <-9.9529, 29.5916, -12.03919>, <-11.5889, 29.1277, -14.00213>, <-8.897, 30.3186, -12.4909> }
			triangle { <-8.4359, 30.1647, -13.143>, <-10.4159, 28.9216, -15.1283>, <-8.6791, 29.08396, -13.9508> }
			triangle { <-8.6791, 29.08396, -13.9508>, <-6.4804, 27.7144, -10.8727>, <-8.4359, 30.1647, -13.143> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.6064, 20.4039, -1.2077>, <0.901, 37.7215, -2.2813>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.901, 37.7215, -2.2813>, <3.5762, 42.7391, 3.5544>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <3.5762, 42.7391, 3.5544>, <7.228, 48.1494, 10.6475>, <6.604, 48.03567, 11.1567> }
			triangle { <7.228, 48.1494, 10.6475>, <9.153, 46.5925, 13.8627>, <6.604, 48.03567, 11.1567> }
			triangle { <7.228, 48.1494, 10.6475>, <9.3812, 47.01798, 12.8906>, <9.153, 46.5925, 13.8627> }
			triangle { <9.153, 46.5925, 13.8627>, <7.9426, 46.8845, 13.6648>, <6.604, 48.03567, 11.1567> }
			triangle { <6.604, 48.03567, 11.1567>, <5.2785, 45.4831, 8.5664>, <3.5762, 42.7391, 3.5544> }
			triangle { <3.5762, 42.7391, 3.5544>, <6.528, 45.6472, 7.8525>, <7.228, 48.1494, 10.6475> }
			triangle { <6.528, 45.6472, 7.8525>, <8.3492, 47.389, 10.5365>, <7.228, 48.1494, 10.6475> }
			triangle { <8.3492, 47.389, 10.5365>, <9.3812, 47.01798, 12.8906>, <7.228, 48.1494, 10.6475> }
			triangle { <6.604, 48.03567, 11.1567>, <7.9426, 46.8845, 13.6648>, <6.5938, 46.9983, 12.05331> }
			triangle { <6.5938, 46.9983, 12.05331>, <5.2785, 45.4831, 8.5664>, <6.604, 48.03567, 11.1567> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.901, 37.7215, -2.2813>, <1.1611, 55.00819, -3.7783>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.1611, 55.00819, -3.7783>, <0.7252, 59.6234, -10.4789>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <0.7252, 59.6234, -10.4789>, <-0.1777, 64.5367, -18.7229>, <0.5864, 64.4085, -18.9701> }
			triangle { <-0.1777, 64.5367, -18.7229>, <-0.834, 62.7559, -22.3096>, <0.5864, 64.4085, -18.9701> }
			triangle { <-0.1777, 64.5367, -18.7229>, <-1.393, 63.2305, -21.5095>, <-0.834, 62.7559, -22.3096> }
			triangle { <-0.834, 62.7559, -22.3096>, <0.2268, 63.08644, -21.7141>, <0.5864, 64.4085, -18.9701> }
			triangle { <0.5864, 64.4085, -18.9701>, <0.9094, 62.03847, -15.927>, <0.7252, 59.6234, -10.4789> }
			triangle { <0.7252, 59.6234, -10.4789>, <-0.5123, 62.214, -15.7135>, <-0.1777, 64.5367, -18.7229> }
			triangle { <-0.5123, 62.214, -15.7135>, <-1.2643, 63.7583, -18.9699>, <-0.1777, 64.5367, -18.7229> }
			triangle { <-1.2643, 63.7583, -18.9699>, <-1.393, 63.2305, -21.5095>, <-0.1777, 64.5367, -18.7229> }
			triangle { <0.5864, 64.4085, -18.9701>, <0.2268, 63.08644, -21.7141>, <0.9156, 63.3225, -19.7395> }
			triangle { <0.9156, 63.3225, -19.7395>, <0.9094, 62.03847, -15.927>, <0.5864, 64.4085, -18.9701> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.1611, 55.00819, -3.7783>, <0.5205, 72.2069, -1.5584>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.5205, 72.2069, -1.5584>, <-1.1365, 76.4921, 5.1706>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-1.1365, 76.4921, 5.1706>, <-2.8299, 80.993, 13.5248>, <-3.6336, 80.8687, 13.5149> }
			triangle { <-2.8299, 80.993, 13.5248>, <-3.333, 79.03275, 17.04208>, <-3.6336, 80.8687, 13.5149> }
			triangle { <-2.8299, 80.993, 13.5248>, <-2.5503, 79.5332, 16.481>, <-3.333, 79.03275, 17.04208> }
			triangle { <-3.333, 79.03275, 17.04208>, <-4.1538, 79.4119, 16.1634>, <-3.6336, 80.8687, 13.5149> }
			triangle { <-3.6336, 80.8687, 13.5149>, <-3.001069, 78.6513, 10.406>, <-1.1365, 76.4921, 5.1706> }
			triangle { <-1.1365, 76.4921, 5.1706>, <-1.583, 78.8084, 10.6551>, <-2.8299, 80.993, 13.5248> }
			triangle { <-1.583, 78.8084, 10.6551>, <-1.8779, 80.1824, 14.058>, <-2.8299, 80.993, 13.5248> }
			triangle { <-1.8779, 80.1824, 14.058>, <-2.5503, 79.5332, 16.481>, <-2.8299, 80.993, 13.5248> }
			triangle { <-3.6336, 80.8687, 13.5149>, <-4.1538, 79.4119, 16.1634>, <-4.191, 79.7544, 14.08723> }
			triangle { <-4.191, 79.7544, 14.08723>, <-3.001069, 78.6513, 10.406>, <-3.6336, 80.8687, 13.5149> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.5205, 72.2069, -1.5584>, <1.001805, 89.5486, -1.1413>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.001805, 89.5486, -1.1413>, <4.4609, 94.7508, -6.372>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <4.4609, 94.7508, -6.372>, <8.449, 100.3976, -13.08987>, <9.2148, 100.2755, -12.8447> }
			triangle { <8.449, 100.3976, -13.08987>, <10.1118, 98.958, -16.5>, <9.2148, 100.2755, -12.8447> }
			triangle { <8.449, 100.3976, -13.08987>, <9.1707, 99.3714, -16.1516>, <10.1118, 98.958, -16.5> }
			triangle { <10.1118, 98.958, -16.5>, <10.6002, 99.2111, -15.3657>, <9.2148, 100.2755, -12.8447> }
			triangle { <9.2148, 100.2755, -12.8447>, <7.7542, 97.6372, -10.4181>, <4.4609, 94.7508, -6.372> }
			triangle { <4.4609, 94.7508, -6.372>, <6.4778, 97.8237, -11.07668>, <8.449, 100.3976, -13.08987> }
			triangle { <6.4778, 97.8237, -11.07668>, <7.7492, 99.6679, -13.9984>, <8.449, 100.3976, -13.08987> }
			triangle { <7.7492, 99.6679, -13.9984>, <9.1707, 99.3714, -16.1516>, <8.449, 100.3976, -13.08987> }
			triangle { <9.2148, 100.2755, -12.8447>, <10.6002, 99.2111, -15.3657>, <9.9746, 99.2554, -13.3567> }
			triangle { <9.9746, 99.2554, -13.3567>, <7.7542, 97.6372, -10.4181>, <9.2148, 100.2755, -12.8447> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.001805, 89.5486, -1.1413>, <-0.4736, 106.7173, 0.9065>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.4736, 106.7173, 0.9065>, <-5.7958, 110.7721, 5.5566>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-5.7958, 110.7721, 5.5566>, <-12.09855, 114.9829, 11.5117>, <-12.7438, 114.869, 11.02986> }
			triangle { <-12.09855, 114.9829, 11.5117>, <-14.5377, 112.9008, 13.998>, <-12.7438, 114.869, 11.02986> }
			triangle { <-12.09855, 114.9829, 11.5117>, <-13.5804, 113.4119, 14.01848>, <-14.5377, 112.9008, 13.998> }
			triangle { <-14.5377, 112.9008, 13.998>, <-14.6954, 113.3223, 12.8204>, <-12.7438, 114.869, 11.02986> }
			triangle { <-12.7438, 114.869, 11.02986>, <-10.3902, 112.7599, 8.795>, <-5.7958, 110.7721, 5.5566> }
			triangle { <-5.7958, 110.7721, 5.5566>, <-9.3861, 112.8901, 9.8306>, <-12.09855, 114.9829, 11.5117> }
			triangle { <-9.3861, 112.8901, 9.8306>, <-11.6276, 114.1415, 12.4696>, <-12.09855, 114.9829, 11.5117> }
			triangle { <-11.6276, 114.1415, 12.4696>, <-13.5804, 113.4119, 14.01848>, <-12.09855, 114.9829, 11.5117> }
			triangle { <-12.7438, 114.869, 11.02986>, <-14.6954, 113.3223, 12.8204>, <-13.5177, 113.7414, 11.1273> }
			triangle { <-13.5177, 113.7414, 11.1273>, <-10.3902, 112.7599, 8.795>, <-12.7438, 114.869, 11.02986> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.4736, 106.7173, 0.9065>, <-1.949, 123.8861, 2.9545>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.949, 123.8861, 2.9545>, <3.4377, 129.771, 1.2994>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <3.4377, 129.771, 1.2994>, <10.08893, 136.291, -1.1843>, <10.5668, 136.1593, -0.5394> }
			triangle { <10.08893, 136.291, -1.1843>, <13.5766, 135.3191, -3.01677>, <10.5668, 136.1593, -0.5394> }
			triangle { <10.08893, 136.291, -1.1843>, <12.5791, 135.6633, -3.2706>, <13.5766, 135.3191, -3.01677> }
			triangle { <13.5766, 135.3191, -3.01677>, <13.2698, 135.4446, -1.8004>, <10.5668, 136.1593, -0.5394> }
			triangle { <10.5668, 136.1593, -0.5394>, <8.2039, 133.2097, 0.2963>, <3.4377, 129.771, 1.2994> }
			triangle { <3.4377, 129.771, 1.2994>, <7.5574, 133.4429, -0.9785>, <10.08893, 136.291, -1.1843> }
			triangle { <7.5574, 133.4429, -0.9785>, <10.1369, 135.66, -2.3872>, <10.08893, 136.291, -1.1843> }
			triangle { <10.1369, 135.66, -2.3872>, <12.5791, 135.6633, -3.2706>, <10.08893, 136.291, -1.1843> }
			triangle { <10.5668, 136.1593, -0.5394>, <13.2698, 135.4446, -1.8004>, <11.5729, 135.2285, -0.5744> }
			triangle { <11.5729, 135.2285, -0.5744>, <8.2039, 133.2097, 0.2963>, <10.5668, 136.1593, -0.5394> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-1.949, 123.8861, 2.9545>, <-7.5735, 140.1542, 5.1567>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.5735, 140.1542, 5.1567>, <-13.2502, 141.7572, 5.6909>, 0.3489 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-13.2502, 141.7572, 5.6909>, <-20.05537, 143.1804, 6.5646>, <-20.2035, 143.0849, 6.000329> }
			triangle { <-20.05537, 143.1804, 6.5646>, <-22.1137, 141.0919, 6.8844>, <-20.2035, 143.0849, 6.000329> }
			triangle { <-20.05537, 143.1804, 6.5646>, <-21.6657, 141.5655, 7.3287>, <-22.1137, 141.0919, 6.8844> }
			triangle { <-22.1137, 141.0919, 6.8844>, <-21.7888, 141.5239, 6.1444>, <-20.2035, 143.0849, 6.000329> }
			triangle { <-20.2035, 143.0849, 6.000329>, <-17.5637, 142.1768, 5.6496>, <-13.2502, 141.7572, 5.6909> }
			triangle { <-13.2502, 141.7572, 5.6909>, <-17.4435, 142.2548, 6.6926>, <-20.05537, 143.1804, 6.5646> }
			triangle { <-17.4435, 142.2548, 6.6926>, <-20.03677, 142.5192, 7.2986>, <-20.05537, 143.1804, 6.5646> }
			triangle { <-20.03677, 142.5192, 7.2986>, <-21.6657, 141.5655, 7.3287>, <-20.05537, 143.1804, 6.5646> }
			triangle { <-20.2035, 143.0849, 6.000329>, <-21.7888, 141.5239, 6.1444>, <-20.4878, 142.1837, 5.6835> }
			triangle { <-20.4878, 142.1837, 5.6835>, <-17.5637, 142.1768, 5.6496>, <-20.2035, 143.0849, 6.000329> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-7.5735, 140.1542, 5.1567>, <-11.2107, 156.8888, 7.961>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.2107, 156.8888, 7.961>, <-10.7852, 157.4103, 8.1835>, 0.04176 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-10.7852, 157.4103, 8.1835>, <-10.2327, 157.9952, 8.42>, <-10.2312, 157.9756, 8.488> }
			triangle { <-10.2327, 157.9952, 8.42>, <-9.8883, 157.9301, 8.4618>, <-10.2312, 157.9756, 8.488> }
			triangle { <-10.2327, 157.9952, 8.42>, <-9.9476, 157.9638, 8.3965>, <-9.8883, 157.9301, 8.4618> }
			triangle { <-9.8883, 157.9301, 8.4618>, <-9.9726, 157.9265, 8.5318>, <-10.2312, 157.9756, 8.488> }
			triangle { <-10.2312, 157.9756, 8.488>, <-10.4211, 157.7138, 8.3942>, <-10.7852, 157.4103, 8.1835> }
			triangle { <-10.7852, 157.4103, 8.1835>, <-10.403, 157.7499, 8.2748>, <-10.2327, 157.9952, 8.42> }
			triangle { <-10.403, 157.7499, 8.2748>, <-10.1641, 157.9553, 8.3324>, <-10.2327, 157.9952, 8.42> }
			triangle { <-10.1641, 157.9553, 8.3324>, <-9.9476, 157.9638, 8.3965>, <-10.2327, 157.9952, 8.42> }
			triangle { <-10.2312, 157.9756, 8.488>, <-9.9726, 157.9265, 8.5318>, <-10.1529, 157.8948, 8.5276> }
			triangle { <-10.1529, 157.8948, 8.5276>, <-10.4211, 157.7138, 8.3942>, <-10.2312, 157.9756, 8.488> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-11.2107, 156.8888, 7.961>, <-12.2796, 159.9514, 8.2151>, 0.1115 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-12.2796, 159.9514, 8.2151>, <-12.7102, 160.187, 8.01088>, 0.03132 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-12.7102, 160.187, 8.01088>, <-13.2409, 160.4223, 7.7688>, <-13.2218, 160.4278, 7.7196> }
			triangle { <-13.2409, 160.4223, 7.7688>, <-13.4147, 160.2768, 7.6318>, <-13.2218, 160.4278, 7.7196> }
			triangle { <-13.2409, 160.4223, 7.7688>, <-13.4043, 160.3002, 7.6979>, <-13.4147, 160.2768, 7.6318> }
			triangle { <-13.4147, 160.2768, 7.6318>, <-13.35, 160.3218, 7.6083>, <-13.2218, 160.4278, 7.7196> }
			triangle { <-13.2218, 160.4278, 7.7196>, <-13.01678, 160.3063, 7.8031>, <-12.7102, 160.187, 8.01088> }
			triangle { <-12.7102, 160.187, 8.01088>, <-13.06359, 160.2906, 7.8837>, <-13.2409, 160.4223, 7.7688> }
			triangle { <-13.06359, 160.2906, 7.8837>, <-13.2815, 160.3512, 7.803>, <-13.2409, 160.4223, 7.7688> }
			triangle { <-13.2815, 160.3512, 7.803>, <-13.4043, 160.3002, 7.6979>, <-13.2409, 160.4223, 7.7688> }
			triangle { <-13.2218, 160.4278, 7.7196>, <-13.35, 160.3218, 7.6083>, <-13.229, 160.3622, 7.6592> }
			triangle { <-13.229, 160.3622, 7.6592>, <-13.01678, 160.3063, 7.8031>, <-13.2218, 160.4278, 7.7196> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.4777, 3.1131, 0.2571>, <0.9648, 6.3566, 0.6289>, 0.1131 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.9648, 6.3566, 0.6289>, <1.3277, 6.7871, 1.3854>, 0.05555 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <1.3277, 6.7871, 1.3854>, <1.8036, 7.2256, 2.2941>, <1.7282, 7.2147, 2.3495> }
			triangle { <1.8036, 7.2256, 2.2941>, <1.9861, 6.9653, 2.6398>, <1.7282, 7.2147, 2.3495> }
			triangle { <1.8036, 7.2256, 2.2941>, <2.02305, 7.02563, 2.536>, <1.9861, 6.9653, 2.6398> }
			triangle { <1.9861, 6.9653, 2.6398>, <1.8529, 7.02155, 2.6199>, <1.7282, 7.2147, 2.3495> }
			triangle { <1.7282, 7.2147, 2.3495>, <1.5461, 6.989, 2.008083>, <1.3277, 6.7871, 1.3854> }
			triangle { <1.3277, 6.7871, 1.3854>, <1.6948, 6.9987, 1.9312>, <1.8036, 7.2256, 2.2941> }
			triangle { <1.6948, 6.9987, 1.9312>, <1.9203, 7.1228, 2.2707>, <1.8036, 7.2256, 2.2941> }
			triangle { <1.9203, 7.1228, 2.2707>, <2.02305, 7.02563, 2.536>, <1.8036, 7.2256, 2.2941> }
			triangle { <1.7282, 7.2147, 2.3495>, <1.8529, 7.02155, 2.6199>, <1.7068, 7.08274, 2.4349> }
			triangle { <1.7068, 7.08274, 2.4349>, <1.5461, 6.989, 2.008083>, <1.7282, 7.2147, 2.3495> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.9648, 6.3566, 0.6289>, <2.1147, 14.1179, 1.3245>, 0.27 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.1147, 14.1179, 1.3245>, <2.212, 15.785, -0.3661>, 0.1399 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <2.212, 15.785, -0.3661>, <2.1968, 17.6324, -2.4852>, <2.4147, 17.5789, -2.5622> }
			triangle { <2.1968, 17.6324, -2.4852>, <1.9661, 17.3306, -3.6061>, <2.4147, 17.5789, -2.5622> }
			triangle { <2.1968, 17.6324, -2.4852>, <1.8165, 17.4471, -3.3526>, <1.9661, 17.3306, -3.6061> }
			triangle { <1.9661, 17.3306, -3.6061>, <2.2809, 17.354, -3.4176>, <2.4147, 17.5789, -2.5622> }
			triangle { <2.4147, 17.5789, -2.5622>, <2.3963, 16.7389, -1.8082>, <2.212, 15.785, -0.3661> }
			triangle { <2.212, 15.785, -0.3661>, <1.9904, 16.8329, -1.7389>, <2.1968, 17.6324, -2.4852> }
			triangle { <1.9904, 16.8329, -1.7389>, <1.8551, 17.4649, -2.5963>, <2.1968, 17.6324, -2.4852> }
			triangle { <1.8551, 17.4649, -2.5963>, <1.8165, 17.4471, -3.3526>, <2.1968, 17.6324, -2.4852> }
			triangle { <2.4147, 17.5789, -2.5622>, <2.2809, 17.354, -3.4176>, <2.4745, 17.2956, -2.838> }
			triangle { <2.4745, 17.2956, -2.838>, <2.3963, 16.7389, -1.8082>, <2.4147, 17.5789, -2.5622> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <2.1147, 14.1179, 1.3245>, <4.522, 31.3027, 1.1607>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.522, 31.3027, 1.1607>, <4.6984, 36.2786, -5.2889>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <4.6984, 36.2786, -5.2889>, <4.4438, 41.6961, -13.2578>, <5.1805, 41.4745, -13.5221> }
			triangle { <4.4438, 41.6961, -13.2578>, <3.5171, 40.2165, -16.921>, <5.1805, 41.4745, -13.5221> }
			triangle { <4.4438, 41.6961, -13.2578>, <3.03661, 40.7226, -16.08989>, <3.5171, 40.2165, -16.921> }
			triangle { <3.5171, 40.2165, -16.921>, <4.6182, 40.3622, -16.3246>, <5.1805, 41.4745, -13.5221> }
			triangle { <5.1805, 41.4745, -13.5221>, <5.1853, 38.9261, -10.6087>, <4.6984, 36.2786, -5.2889> }
			triangle { <4.6984, 36.2786, -5.2889>, <3.8043, 39.2892, -10.3664>, <4.4438, 41.6961, -13.2578> }
			triangle { <3.8043, 39.2892, -10.3664>, <3.2562, 41.09294, -13.5287>, <4.4438, 41.6961, -13.2578> }
			triangle { <3.2562, 41.09294, -13.5287>, <3.03661, 40.7226, -16.08989>, <4.4438, 41.6961, -13.2578> }
			triangle { <5.1805, 41.4745, -13.5221>, <4.6182, 40.3622, -16.3246>, <5.3471, 40.3948, -14.3505> }
			triangle { <5.3471, 40.3948, -14.3505>, <5.1853, 38.9261, -10.6087>, <5.1805, 41.4745, -13.5221> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <4.522, 31.3027, 1.1607>, <6.3103, 48.408, 3.4727>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.3103, 48.408, 3.4727>, <5.3119, 53.01321, 10.1199>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <5.3119, 53.01321, 10.1199>, <4.2945, 57.8622, 18.3886>, <3.4814, 57.8733, 18.3688> }
			triangle { <4.2945, 57.8622, 18.3886>, <3.43, 56.06787, 21.924>, <3.4814, 57.8733, 18.3688> }
			triangle { <4.2945, 57.8622, 18.3886>, <4.2918, 56.4222, 21.3676>, <3.43, 56.06787, 21.924> }
			triangle { <3.43, 56.06787, 21.924>, <2.6945, 56.5648, 21.02889>, <3.4814, 57.8733, 18.3688> }
			triangle { <3.4814, 57.8733, 18.3688>, <3.772, 55.5336, 15.299>, <5.3119, 53.01321, 10.1199> }
			triangle { <5.3119, 53.01321, 10.1199>, <5.1934, 55.4562, 15.5662>, <4.2945, 57.8622, 18.3886> }
			triangle { <5.1934, 55.4562, 15.5662>, <5.09163, 56.9127, 18.9459>, <4.2945, 57.8622, 18.3886> }
			triangle { <5.09163, 56.9127, 18.9459>, <4.2918, 56.4222, 21.3676>, <4.2945, 57.8622, 18.3886> }
			triangle { <3.4814, 57.8733, 18.3688>, <2.6945, 56.5648, 21.02889>, <2.7393, 56.8765, 18.9479> }
			triangle { <2.7393, 56.8765, 18.9479>, <3.772, 55.5336, 15.299>, <3.4814, 57.8733, 18.3688> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <6.3103, 48.408, 3.4727>, <6.6616, 49.8861, 3.224>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <6.6616, 49.8861, 3.224>, <7.1728, 51.1716, 2.5486>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <7.1728, 51.1716, 2.5486>, <7.7946, 52.1312, 1.5179>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <7.7946, 52.1312, 1.5179>, <8.4663, 52.6655, 0.2399>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <8.4663, 52.6655, 0.2399>, <8.7947, 53.5504, -0.9762>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.7947, 53.5504, -0.9762>, <8.8092, 55.2846, -2.8066>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <8.8092, 55.2846, -2.8066>, <9.8512, 57.6149, -3.8902>, <8.7661, 56.8648, -4.5204> }
					triangle { <8.7661, 56.8648, -4.5204>, <9.8512, 57.6149, -3.8902>, <9.9961, 59.4766, -5.425> }
					triangle { <8.7661, 56.8648, -4.5204>, <9.9961, 59.4766, -5.425>, <8.6289, 58.6573, -6.212> }
					triangle { <9.9961, 59.4766, -5.425>, <8.4139, 60.6086, -7.4863>, <8.6289, 58.6573, -6.212> }
					triangle { <8.7661, 56.8648, -4.5204>, <7.4221, 56.6377, -4.8354>, <8.8092, 55.2846, -2.8066> }
					triangle { <7.4221, 56.6377, -4.8354>, <8.7661, 56.8648, -4.5204>, <8.6289, 58.6573, -6.212> }
					triangle { <7.1083, 58.4225, -6.4465>, <7.4221, 56.6377, -4.8354>, <8.6289, 58.6573, -6.212> }
					triangle { <7.1083, 58.4225, -6.4465>, <8.6289, 58.6573, -6.212>, <8.4139, 60.6086, -7.4863> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <8.8092, 55.2846, -2.8066>, <9.1396, 55.9426, -5.4802>, <8.8229, 56.9345, -4.4539> }
					triangle { <8.8229, 56.9345, -4.4539>, <9.1396, 55.9426, -5.4802>, <9.3462, 57.4005, -7.397> }
					triangle { <8.8229, 56.9345, -4.4539>, <9.3462, 57.4005, -7.397>, <9.03169, 58.6718, -6.1951> }
					triangle { <9.3462, 57.4005, -7.397>, <9.627, 60.1786, -7.884>, <9.03169, 58.6718, -6.1951> }
					triangle { <8.8229, 56.9345, -4.4539>, <9.1541, 57.9633, -3.5657>, <8.8092, 55.2846, -2.8066> }
					triangle { <9.1541, 57.9633, -3.5657>, <8.8229, 56.9345, -4.4539>, <9.03169, 58.6718, -6.1951> }
					triangle { <9.4925, 59.7492, -5.1707>, <9.1541, 57.9633, -3.5657>, <9.03169, 58.6718, -6.1951> }
					triangle { <9.4925, 59.7492, -5.1707>, <9.03169, 58.6718, -6.1951>, <9.627, 60.1786, -7.884> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <8.8092, 55.2846, -2.8066>, <7.4927, 57.2481, -4.2565>, <8.878, 56.8629, -4.5213> }
					triangle { <8.878, 56.8629, -4.5213>, <7.4927, 57.2481, -4.2565>, <7.1844, 58.8737, -6.01852> }
					triangle { <8.878, 56.8629, -4.5213>, <7.1844, 58.8737, -6.01852>, <8.8468, 58.41, -6.4446> }
					triangle { <7.1844, 58.8737, -6.01852>, <8.5023, 59.6325, -8.4104>, <8.8468, 58.41, -6.4446> }
					triangle { <8.878, 56.8629, -4.5213>, <9.8729, 56.1908, -5.2393>, <8.8092, 55.2846, -2.8066> }
					triangle { <9.8729, 56.1908, -5.2393>, <8.878, 56.8629, -4.5213>, <8.8468, 58.41, -6.4446> }
					triangle { <9.8849, 57.5641, -7.2377>, <9.8729, 56.1908, -5.2393>, <8.8468, 58.41, -6.4446> }
					triangle { <9.8849, 57.5641, -7.2377>, <8.8468, 58.41, -6.4446>, <8.5023, 59.6325, -8.4104> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <8.7947, 53.5504, -0.9762>, <9.5829, 54.34, -2.03693>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5829, 54.34, -2.03693>, <11.3523, 55.5029, -3.4064>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <11.3523, 55.5029, -3.4064>, <12.9797, 55.5776, -5.6506>, <13.00066, 56.6166, -4.6223> }
					triangle { <13.00066, 56.6166, -4.6223>, <12.9797, 55.5776, -5.6506>, <14.7409, 56.3996, -7.08754> }
					triangle { <13.00066, 56.6166, -4.6223>, <14.7409, 56.3996, -7.08754>, <14.8725, 57.6634, -5.8444> }
					triangle { <14.7409, 56.3996, -7.08754>, <16.8474, 58.2897, -6.933>, <14.8725, 57.6634, -5.8444> }
					triangle { <13.00066, 56.6166, -4.6223>, <13.5416, 57.2545, -3.5009>, <11.3523, 55.5029, -3.4064> }
					triangle { <13.5416, 57.2545, -3.5009>, <13.00066, 56.6166, -4.6223>, <14.8725, 57.6634, -5.8444> }
					triangle { <15.4827, 58.2652, -4.5452>, <13.5416, 57.2545, -3.5009>, <14.8725, 57.6634, -5.8444> }
					triangle { <15.4827, 58.2652, -4.5452>, <14.8725, 57.6634, -5.8444>, <16.8474, 58.2897, -6.933> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <11.3523, 55.5029, -3.4064>, <12.1941, 57.716, -4.8499>, <13.01964, 56.5216, -4.6783> }
					triangle { <13.01964, 56.5216, -4.6783>, <12.1941, 57.716, -4.8499>, <13.6471, 59.00487, -6.2886> }
					triangle { <13.01964, 56.5216, -4.6783>, <13.6471, 59.00487, -6.2886>, <14.6783, 57.5607, -6.1826> }
					triangle { <13.6471, 59.00487, -6.2886>, <15.9375, 58.5432, -7.8933>, <14.6783, 57.5607, -6.1826> }
					triangle { <13.01964, 56.5216, -4.6783>, <13.5721, 55.3115, -5.1112>, <11.3523, 55.5029, -3.4064> }
					triangle { <13.5721, 55.3115, -5.1112>, <13.01964, 56.5216, -4.6783>, <14.6783, 57.5607, -6.1826> }
					triangle { <15.1831, 56.1826, -6.7004>, <13.5721, 55.3115, -5.1112>, <14.6783, 57.5607, -6.1826> }
					triangle { <15.1831, 56.1826, -6.7004>, <14.6783, 57.5607, -6.1826>, <15.9375, 58.5432, -7.8933> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <11.3523, 55.5029, -3.4064>, <13.9243, 56.514, -3.6352>, <12.9426, 56.595, -4.7155> }
					triangle { <12.9426, 56.595, -4.7155>, <13.9243, 56.514, -3.6352>, <15.7535, 57.7129, -4.6643> }
					triangle { <12.9426, 56.595, -4.7155>, <15.7535, 57.7129, -4.6643>, <14.5925, 57.9111, -5.9958> }
					triangle { <15.7535, 57.7129, -4.6643>, <16.1334, 59.431, -6.8864>, <14.5925, 57.9111, -5.9958> }
					triangle { <12.9426, 56.595, -4.7155>, <11.9924, 57.2655, -5.4931>, <11.3523, 55.5029, -3.4064> }
					triangle { <11.9924, 57.2655, -5.4931>, <12.9426, 56.595, -4.7155>, <14.5925, 57.9111, -5.9958> }
					triangle { <13.4861, 58.6961, -6.7587>, <11.9924, 57.2655, -5.4931>, <14.5925, 57.9111, -5.9958> }
					triangle { <13.4861, 58.6961, -6.7587>, <14.5925, 57.9111, -5.9958>, <16.1334, 59.431, -6.8864> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <9.5829, 54.34, -2.03693>, <10.03168, 54.9205, -3.3903>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <10.03168, 54.9205, -3.3903>, <10.352, 55.4718, -5.8299>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <10.352, 55.4718, -5.8299>, <9.9718, 57.2001, -7.965>, <10.6661, 55.9203, -8.09618> }
					triangle { <10.6661, 55.9203, -8.09618>, <9.9718, 57.2001, -7.965>, <10.01948, 57.9208, -10.2716> }
					triangle { <10.6661, 55.9203, -8.09618>, <10.01948, 57.9208, -10.2716>, <10.8116, 56.3493, -10.5227> }
					triangle { <10.01948, 57.9208, -10.2716>, <10.5266, 56.763, -12.8086>, <10.8116, 56.3493, -10.5227> }
					triangle { <10.6661, 55.9203, -8.09618>, <10.7423, 54.571, -8.458>, <10.352, 55.4718, -5.8299> }
					triangle { <10.7423, 54.571, -8.458>, <10.6661, 55.9203, -8.09618>, <10.8116, 56.3493, -10.5227> }
					triangle { <10.7921, 54.8319, -10.8682>, <10.7423, 54.571, -8.458>, <10.8116, 56.3493, -10.5227> }
					triangle { <10.7921, 54.8319, -10.8682>, <10.8116, 56.3493, -10.5227>, <10.5266, 56.763, -12.8086> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <10.352, 55.4718, -5.8299>, <12.04257, 55.958, -7.9738>, <10.5857, 55.9977, -8.08924> }
					triangle { <10.5857, 55.9977, -8.08924>, <12.04257, 55.958, -7.9738>, <12.6412, 56.5995, -10.2259> }
					triangle { <10.5857, 55.9977, -8.08924>, <12.6412, 56.5995, -10.2259>, <10.8801, 56.735, -10.4266> }
					triangle { <12.6412, 56.5995, -10.2259>, <11.3637, 57.7633, -12.4726>, <10.8801, 56.735, -10.4266> }
					triangle { <10.5857, 55.9977, -8.08924>, <9.3557, 56.6597, -8.168>, <10.352, 55.4718, -5.8299> }
					triangle { <9.3557, 56.6597, -8.168>, <10.5857, 55.9977, -8.08924>, <10.8801, 56.735, -10.4266> }
					triangle { <9.5466, 57.5375, -10.4203>, <9.3557, 56.6597, -8.168>, <10.8801, 56.735, -10.4266> }
					triangle { <9.5466, 57.5375, -10.4203>, <10.8801, 56.735, -10.4266>, <11.3637, 57.7633, -12.4726> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <10.352, 55.4718, -5.8299>, <9.9451, 54.8457, -8.5006>, <10.693, 56.0254, -8.0689> }
					triangle { <10.693, 56.0254, -8.0689>, <9.9451, 54.8457, -8.5006>, <10.2081, 55.05748, -10.8939> }
					triangle { <10.693, 56.0254, -8.0689>, <10.2081, 55.05748, -10.8939>, <11.1883, 56.4711, -10.4457> }
					triangle { <10.2081, 55.05748, -10.8939>, <11.8452, 56.5142, -12.6916>, <11.1883, 56.4711, -10.4457> }
					triangle { <10.693, 56.0254, -8.0689>, <11.8723, 56.7357, -7.8204>, <10.352, 55.4718, -5.8299> }
					triangle { <11.8723, 56.7357, -7.8204>, <10.693, 56.0254, -8.0689>, <11.1883, 56.4711, -10.4457> }
					triangle { <12.541, 57.1644, -10.1114>, <11.8723, 56.7357, -7.8204>, <11.1883, 56.4711, -10.4457> }
					triangle { <12.541, 57.1644, -10.1114>, <11.1883, 56.4711, -10.4457>, <11.8452, 56.5142, -12.6916> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.3103, 48.408, 3.4727>, <6.01511, 49.867, 3.8654>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <6.01511, 49.867, 3.8654>, <5.5192, 51.1485, 4.5596>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.5192, 51.1485, 4.5596>, <5.2692, 53.2363, 5.9513>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <5.2692, 53.2363, 5.9513>, <5.1461, 56.00155, 6.1207>, <5.04796, 55.1312, 7.2913> }
					triangle { <5.04796, 55.1312, 7.2913>, <5.1461, 56.00155, 6.1207>, <5.06089, 58.1556, 7.2138> }
					triangle { <5.04796, 55.1312, 7.2913>, <5.06089, 58.1556, 7.2138>, <5.004859, 57.1655, 8.6891> }
					triangle { <5.06089, 58.1556, 7.2138>, <5.3436, 59.1725, 9.8444>, <5.004859, 57.1655, 8.6891> }
					triangle { <5.04796, 55.1312, 7.2913>, <5.564, 54.5098, 8.4336>, <5.2692, 53.2363, 5.9513> }
					triangle { <5.564, 54.5098, 8.4336>, <5.04796, 55.1312, 7.2913>, <5.004859, 57.1655, 8.6891> }
					triangle { <5.6741, 56.4425, 9.8939>, <5.564, 54.5098, 8.4336>, <5.004859, 57.1655, 8.6891> }
					triangle { <5.6741, 56.4425, 9.8939>, <5.004859, 57.1655, 8.6891>, <5.3436, 59.1725, 9.8444> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.2692, 53.2363, 5.9513>, <3.7696, 54.7896, 7.6916>, <5.08886, 55.1923, 7.207> }
					triangle { <5.08886, 55.1923, 7.207>, <3.7696, 54.7896, 7.6916>, <3.2101, 56.7419, 9.002116> }
					triangle { <5.08886, 55.1923, 7.207>, <3.2101, 56.7419, 9.002116>, <4.776, 57.3303, 8.4007> }
					triangle { <3.2101, 56.7419, 9.002116>, <4.1422, 59.4042, 9.281>, <4.776, 57.3303, 8.4007> }
					triangle { <5.08886, 55.1923, 7.207>, <5.9462, 55.925, 6.3792>, <5.2692, 53.2363, 5.9513> }
					triangle { <5.9462, 55.925, 6.3792>, <5.08886, 55.1923, 7.207>, <4.776, 57.3303, 8.4007> }
					triangle { <5.6614, 58.112, 7.387>, <5.9462, 55.925, 6.3792>, <4.776, 57.3303, 8.4007> }
					triangle { <5.6614, 58.112, 7.387>, <4.776, 57.3303, 8.4007>, <4.1422, 59.4042, 9.281> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.2692, 53.2363, 5.9513>, <6.1813, 54.8786, 7.9912>, <4.978, 55.1737, 7.2151> }
					triangle { <4.978, 55.1737, 7.2151>, <6.1813, 54.8786, 7.9912>, <6.1158, 56.7243, 9.5504> }
					triangle { <4.978, 55.1737, 7.2151>, <6.1158, 56.7243, 9.5504>, <4.6051, 57.112, 8.6975> }
					triangle { <6.1158, 56.7243, 9.5504>, <4.2343, 58.6611, 10.4122>, <4.6051, 57.112, 8.6975> }
					triangle { <4.978, 55.1737, 7.2151>, <3.5928, 55.2137, 7.02361>, <5.2692, 53.2363, 5.9513> }
					triangle { <3.5928, 55.2137, 7.02361>, <4.978, 55.1737, 7.2151>, <4.6051, 57.112, 8.6975> }
					triangle { <3.0601, 57.04309, 8.5234>, <3.5928, 55.2137, 7.02361>, <4.6051, 57.112, 8.6975> }
					triangle { <3.0601, 57.04309, 8.5234>, <4.6051, 57.112, 8.6975>, <4.2343, 58.6611, 10.4122> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.01511, 49.867, 3.8654>, <5.9407, 51.4033, 3.9296>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.9407, 51.4033, 3.9296>, <5.277, 53.8296, 3.7529>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <5.277, 53.8296, 3.7529>, <4.3692, 56.1582, 4.9545>, <4.6621, 56.06691, 3.525> }
					triangle { <4.6621, 56.06691, 3.525>, <4.3692, 56.1582, 4.9545>, <3.5582, 58.4329, 5.05352> }
					triangle { <4.6621, 56.06691, 3.525>, <3.5582, 58.4329, 5.05352>, <3.8257, 58.3782, 3.2969> }
					triangle { <3.5582, 58.4329, 5.05352>, <2.6692, 60.4117, 3.2292>, <3.8257, 58.3782, 3.2969> }
					triangle { <4.6621, 56.06691, 3.525>, <4.2981, 55.9367, 2.1805>, <5.277, 53.8296, 3.7529> }
					triangle { <4.2981, 55.9367, 2.1805>, <4.6621, 56.06691, 3.525>, <3.8257, 58.3782, 3.2969> }
					triangle { <3.3506, 58.1416, 1.8338>, <4.2981, 55.9367, 2.1805>, <3.8257, 58.3782, 3.2969> }
					triangle { <3.3506, 58.1416, 1.8338>, <3.8257, 58.3782, 3.2969>, <2.6692, 60.4117, 3.2292> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.277, 53.8296, 3.7529>, <5.9314, 56.453, 3.1368>, <4.6102, 56.05993, 3.6239> }
					triangle { <4.6102, 56.05993, 3.6239>, <5.9314, 56.453, 3.1368>, <5.6117, 58.8447, 2.9955> }
					triangle { <4.6102, 56.05993, 3.6239>, <5.6117, 58.8447, 2.9955>, <4.005981, 58.4532, 3.6499> }
					triangle { <5.6117, 58.8447, 2.9955>, <3.7531, 60.7606, 3.9488>, <4.005981, 58.4532, 3.6499> }
					triangle { <4.6102, 56.05993, 3.6239>, <3.6306, 55.9314, 4.6143>, <5.277, 53.8296, 3.7529> }
					triangle { <3.6306, 55.9314, 4.6143>, <4.6102, 56.05993, 3.6239>, <4.005981, 58.4532, 3.6499> }
					triangle { <3.000802, 58.2637, 4.8229>, <3.6306, 55.9314, 4.6143>, <4.005981, 58.4532, 3.6499> }
					triangle { <3.000802, 58.2637, 4.8229>, <4.005981, 58.4532, 3.6499>, <3.7531, 60.7606, 3.9488> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.277, 53.8296, 3.7529>, <3.6355, 55.792, 2.6832>, <4.7189, 56.08927, 3.6188> }
					triangle { <4.7189, 56.08927, 3.6188>, <3.6355, 55.792, 2.6832>, <2.8725, 58.03946, 2.2256> }
					triangle { <4.7189, 56.08927, 3.6188>, <2.8725, 58.03946, 2.2256>, <4.2146, 58.4849, 3.3028> }
					triangle { <2.8725, 58.03946, 2.2256>, <3.8272, 60.6823, 2.5966>, <4.2146, 58.4849, 3.3028> }
					triangle { <4.7189, 56.08927, 3.6188>, <6.006426, 56.5321, 3.9402>, <5.277, 53.8296, 3.7529> }
					triangle { <6.006426, 56.5321, 3.9402>, <4.7189, 56.08927, 3.6188>, <4.2146, 58.4849, 3.3028> }
					triangle { <5.6881, 58.9076, 3.5721>, <6.006426, 56.5321, 3.9402>, <4.2146, 58.4849, 3.3028> }
					triangle { <5.6881, 58.9076, 3.5721>, <4.2146, 58.4849, 3.3028>, <3.8272, 60.6823, 2.5966> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.01511, 49.867, 3.8654>, <6.1883, 51.295, 4.4137>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <6.1883, 51.295, 4.4137>, <6.739, 52.6709, 4.8303>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.739, 52.6709, 4.8303>, <7.3892, 55.1027, 4.9781>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <7.3892, 55.1027, 4.9781>, <7.02638, 57.6157, 6.09336>, <8.0244, 57.3445, 5.06002> }
					triangle { <8.0244, 57.3445, 5.06002>, <7.02638, 57.6157, 6.09336>, <7.35, 59.9973, 6.3487> }
					triangle { <8.0244, 57.3445, 5.06002>, <7.35, 59.9973, 6.3487>, <8.5358, 59.7594, 5.04599> }
					triangle { <7.35, 59.9973, 6.3487>, <8.6146, 62.09527, 4.9228>, <8.5358, 59.7594, 5.04599> }
					triangle { <8.0244, 57.3445, 5.06002>, <8.498, 57.3649, 3.7438>, <7.3892, 55.1027, 4.9781> }
					triangle { <8.498, 57.3649, 3.7438>, <8.0244, 57.3445, 5.06002>, <8.5358, 59.7594, 5.04599> }
					triangle { <8.9565, 59.7379, 3.5476>, <8.498, 57.3649, 3.7438>, <8.5358, 59.7594, 5.04599> }
					triangle { <8.9565, 59.7379, 3.5476>, <8.5358, 59.7594, 5.04599>, <8.6146, 62.09527, 4.9228> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <7.3892, 55.1027, 4.9781>, <9.2978, 57.04408, 5.5061>, <7.9277, 57.3672, 5.1115> }
					triangle { <7.9277, 57.3672, 5.1115>, <9.2978, 57.04408, 5.5061>, <10.1532, 59.278, 5.8525> }
					triangle { <7.9277, 57.3672, 5.1115>, <10.1532, 59.278, 5.8525>, <8.4877, 59.7479, 5.4462> }
					triangle { <10.1532, 59.278, 5.8525>, <9.09859, 61.8905, 6.163>, <8.4877, 59.7479, 5.4462> }
					triangle { <7.9277, 57.3672, 5.1115>, <6.6137, 57.7697, 5.3731>, <7.3892, 55.1027, 4.9781> }
					triangle { <6.6137, 57.7697, 5.3731>, <7.9277, 57.3672, 5.1115>, <8.4877, 59.7479, 5.4462> }
					triangle { <7.02419, 60.1161, 5.8269>, <6.6137, 57.7697, 5.3731>, <8.4877, 59.7479, 5.4462> }
					triangle { <7.02419, 60.1161, 5.8269>, <8.4877, 59.7479, 5.4462>, <9.09859, 61.8905, 6.163> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <7.3892, 55.1027, 4.9781>, <7.6824, 57.5814, 3.7696>, <8.01885, 57.3392, 5.1716> }
					triangle { <8.01885, 57.3392, 5.1716>, <7.6824, 57.5814, 3.7696>, <8.352, 59.897, 3.5905> }
					triangle { <8.01885, 57.3392, 5.1716>, <8.352, 59.897, 3.5905>, <8.8485, 59.6615, 5.2811> }
					triangle { <8.352, 59.897, 3.5905>, <9.9043, 61.7407, 5.08212>, <8.8485, 59.6615, 5.2811> }
					triangle { <8.01885, 57.3392, 5.1716>, <8.9158, 57.1029, 6.2188>, <7.3892, 55.1027, 4.9781> }
					triangle { <8.9158, 57.1029, 6.2188>, <8.01885, 57.3392, 5.1716>, <8.8485, 59.6615, 5.2811> }
					triangle { <9.8974, 59.3145, 6.3774>, <8.9158, 57.1029, 6.2188>, <8.8485, 59.6615, 5.2811> }
					triangle { <9.8974, 59.3145, 6.3774>, <8.8485, 59.6615, 5.2811>, <9.9043, 61.7407, 5.08212> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.1883, 51.295, 4.4137>, <5.972, 52.6772, 5.05619>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.972, 52.6772, 5.05619>, <5.8577, 54.6638, 6.605>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <5.8577, 54.6638, 6.605>, <6.8254, 57.1367, 7.4042>, <5.7132, 56.4666, 8.07619> }
					triangle { <5.7132, 56.4666, 8.07619>, <6.8254, 57.1367, 7.4042>, <7.02754, 59.09005, 8.8134> }
					triangle { <5.7132, 56.4666, 8.07619>, <7.02754, 59.09005, 8.8134>, <5.7176, 58.3051, 9.7234> }
					triangle { <7.02754, 59.09005, 8.8134>, <6.1185, 59.9242, 11.3652>, <5.7176, 58.3051, 9.7234> }
					triangle { <5.7132, 56.4666, 8.07619>, <5.1503, 55.7105, 9.1099>, <5.8577, 54.6638, 6.605> }
					triangle { <5.1503, 55.7105, 9.1099>, <5.7132, 56.4666, 8.07619>, <5.7176, 58.3051, 9.7234> }
					triangle { <5.183, 57.3874, 10.8611>, <5.1503, 55.7105, 9.1099>, <5.7176, 58.3051, 9.7234> }
					triangle { <5.183, 57.3874, 10.8611>, <5.7176, 58.3051, 9.7234>, <6.1185, 59.9242, 11.3652> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.8577, 54.6638, 6.605>, <4.445, 56.8107, 7.6467>, <5.8163, 56.4969, 8.04498> }
					triangle { <5.8163, 56.4969, 8.04498>, <4.445, 56.8107, 7.6467>, <4.1053, 58.8287, 8.933> }
					triangle { <5.8163, 56.4969, 8.04498>, <4.1053, 58.8287, 8.933>, <5.7942, 58.5514, 9.4133> }
					triangle { <4.1053, 58.8287, 8.933>, <5.7035, 60.6972, 10.3431>, <5.7942, 58.5514, 9.4133> }
					triangle { <5.8163, 56.4969, 8.04498>, <7.202, 56.6857, 8.01047>, <5.8577, 54.6638, 6.605> }
					triangle { <7.202, 56.6857, 8.01047>, <5.8163, 56.4969, 8.04498>, <5.7942, 58.5514, 9.4133> }
					triangle { <7.3281, 58.7629, 9.2552>, <7.202, 56.6857, 8.01047>, <5.7942, 58.5514, 9.4133> }
					triangle { <7.3281, 58.7629, 9.2552>, <5.7942, 58.5514, 9.4133>, <5.7035, 60.6972, 10.3431> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.8577, 54.6638, 6.605>, <5.9925, 55.7134, 9.1683>, <5.7264, 56.5354, 7.9889> }
					triangle { <5.7264, 56.5354, 7.9889>, <5.9925, 55.7134, 9.1683>, <5.8088, 57.4042, 10.8857> }
					triangle { <5.7264, 56.5354, 7.9889>, <5.8088, 57.4042, 10.8857>, <5.4112, 58.4552, 9.5083> }
					triangle { <5.8088, 57.4042, 10.8857>, <4.8002, 60.04316, 11.1154>, <5.4112, 58.4552, 9.5083> }
					triangle { <5.7264, 56.5354, 7.9889>, <4.8868, 57.2443, 7.1231>, <5.8577, 54.6638, 6.605> }
					triangle { <4.8868, 57.2443, 7.1231>, <5.7264, 56.5354, 7.9889>, <5.4112, 58.4552, 9.5083> }
					triangle { <4.4044, 59.1484, 8.5449>, <4.8868, 57.2443, 7.1231>, <5.4112, 58.4552, 9.5083> }
					triangle { <4.4044, 59.1484, 8.5449>, <5.4112, 58.4552, 9.5083>, <4.8002, 60.04316, 11.1154> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		}
	union { // internode
		cylinder { <2.1147, 14.1179, 1.3245>, <4.01293, 30.1936, 4.7343>, 0.5672 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.01293, 30.1936, 4.7343>, <3.05019, 33.1849, 10.7295>, 0.3987 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <3.05019, 33.1849, 10.7295>, <2.08635, 36.1961, 18.08671>, <1.4115, 36.1619, 18.07967> }
			triangle { <2.08635, 36.1961, 18.08671>, <1.5279, 34.2825, 20.8052>, <1.4115, 36.1619, 18.07967> }
			triangle { <2.08635, 36.1961, 18.08671>, <2.2133, 34.6835, 20.3783>, <1.5279, 34.2825, 20.8052> }
			triangle { <1.5279, 34.2825, 20.8052>, <0.8759, 34.7486, 20.131>, <1.4115, 36.1619, 18.07967> }
			triangle { <1.4115, 36.1619, 18.07967>, <1.7263, 34.5959, 15.2889>, <3.05019, 33.1849, 10.7295> }
			triangle { <3.05019, 33.1849, 10.7295>, <2.9131, 34.5824, 15.4863>, <2.08635, 36.1961, 18.08671> }
			triangle { <2.9131, 34.5824, 15.4863>, <2.808, 35.3991, 18.4317>, <2.08635, 36.1961, 18.08671> }
			triangle { <2.808, 35.3991, 18.4317>, <2.2133, 34.6835, 20.3783>, <2.08635, 36.1961, 18.08671> }
			triangle { <1.4115, 36.1619, 18.07967>, <0.8759, 34.7486, 20.131>, <0.8604, 35.2374, 18.4524> }
			triangle { <0.8604, 35.2374, 18.4524>, <1.7263, 34.5959, 15.2889>, <1.4115, 36.1619, 18.07967> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <4.01293, 30.1936, 4.7343>, <5.7695, 47.00487, 8.6629>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.7695, 47.00487, 8.6629>, <9.9227, 52.4465, 4.2438>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <9.9227, 52.4465, 4.2438>, <14.6412, 58.5004, -1.5875>, <15.3819, 58.2193, -1.4032> }
			triangle { <14.6412, 58.5004, -1.5875>, <15.9846, 57.4448, -5.2682>, <15.3819, 58.2193, -1.4032> }
			triangle { <14.6412, 58.5004, -1.5875>, <15.1294, 57.9315, -4.8103>, <15.9846, 57.4448, -5.2682> }
			triangle { <15.9846, 57.4448, -5.2682>, <16.5289, 57.4145, -4.1315>, <15.3819, 58.2193, -1.4032> }
			triangle { <15.3819, 58.2193, -1.4032>, <13.561, 55.4539, 0.6015>, <9.9227, 52.4465, 4.2438> }
			triangle { <9.9227, 52.4465, 4.2438>, <12.3192, 55.9501, 0.04547>, <14.6412, 58.5004, -1.5875> }
			triangle { <12.3192, 55.9501, 0.04547>, <13.8157, 58.06062, -2.5737>, <14.6412, 58.5004, -1.5875> }
			triangle { <13.8157, 58.06062, -2.5737>, <15.1294, 57.9315, -4.8103>, <14.6412, 58.5004, -1.5875> }
			triangle { <15.3819, 58.2193, -1.4032>, <16.5289, 57.4145, -4.1315>, <15.9572, 57.2001, -2.1175> }
			triangle { <15.9572, 57.2001, -2.1175>, <13.561, 55.4539, 0.6015>, <15.3819, 58.2193, -1.4032> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <5.7695, 47.00487, 8.6629>, <5.8478, 63.557, 13.8741>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.8478, 63.557, 13.8741>, <0.6037, 66.8292, 19.1828>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <0.6037, 66.8292, 19.1828>, <-5.6265, 70.04065, 25.8001>, <-6.2709, 70.03682, 25.3037> }
			triangle { <-5.6265, 70.04065, 25.8001>, <-8.1423, 67.6041, 27.8497>, <-6.2709, 70.03682, 25.3037> }
			triangle { <-5.6265, 70.04065, 25.8001>, <-7.1714, 68.07474, 27.9673>, <-8.1423, 67.6041, 27.8497> }
			triangle { <-8.1423, 67.6041, 27.8497>, <-8.2789, 68.2413, 26.7705>, <-6.2709, 70.03682, 25.3037> }
			triangle { <-6.2709, 70.03682, 25.3037>, <-3.9592, 68.3125, 22.7221>, <0.6037, 66.8292, 19.1828> }
			triangle { <0.6037, 66.8292, 19.1828>, <-2.9601, 68.2192, 23.7665>, <-5.6265, 70.04065, 25.8001> }
			triangle { <-2.9601, 68.2192, 23.7665>, <-5.1868, 69.02271, 26.5862>, <-5.6265, 70.04065, 25.8001> }
			triangle { <-5.1868, 69.02271, 26.5862>, <-7.1714, 68.07474, 27.9673>, <-5.6265, 70.04065, 25.8001> }
			triangle { <-6.2709, 70.03682, 25.3037>, <-8.2789, 68.2413, 26.7705>, <-7.07664, 68.9335, 25.1879> }
			triangle { <-7.07664, 68.9335, 25.1879>, <-3.9592, 68.3125, 22.7221>, <-6.2709, 70.03682, 25.3037> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <5.8478, 63.557, 13.8741>, <6.7286, 80.1711, 18.8069>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.7286, 80.1711, 18.8069>, <12.9197, 85.4302, 18.1727>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <12.9197, 85.4302, 18.1727>, <20.4602, 91.2803, 16.8186>, <20.9088, 90.9638, 17.4188> }
			triangle { <20.4602, 91.2803, 16.8186>, <23.7871, 90.1788, 14.7727>, <20.9088, 90.9638, 17.4188> }
			triangle { <20.4602, 91.2803, 16.8186>, <22.8516, 90.7032, 14.6058>, <23.7871, 90.1788, 14.7727> }
			triangle { <23.7871, 90.1788, 14.7727>, <23.4914, 90.1179, 15.9968>, <20.9088, 90.9638, 17.4188> }
			triangle { <20.9088, 90.9638, 17.4188>, <18.1392, 88.2786, 17.7365>, <12.9197, 85.4302, 18.1727> }
			triangle { <12.9197, 85.4302, 18.1727>, <17.5437, 88.8353, 16.5394>, <20.4602, 91.2803, 16.8186> }
			triangle { <17.5437, 88.8353, 16.5394>, <20.427, 90.8843, 15.5188>, <20.4602, 91.2803, 16.8186> }
			triangle { <20.427, 90.8843, 15.5188>, <22.8516, 90.7032, 14.6058>, <20.4602, 91.2803, 16.8186> }
			triangle { <20.9088, 90.9638, 17.4188>, <23.4914, 90.1179, 15.9968>, <21.7708, 89.9218, 17.1928> }
			triangle { <21.7708, 89.9218, 17.1928>, <18.1392, 88.2786, 17.7365>, <20.9088, 90.9638, 17.4188> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <6.7286, 80.1711, 18.8069>, <6.3939, 81.609, 19.2431>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <6.3939, 81.609, 19.2431>, <5.6707, 82.9068, 19.6464>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <5.6707, 82.9068, 19.6464>, <4.6114, 83.9705, 19.9874>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <4.6114, 83.9705, 19.9874>, <3.2926, 84.7229, 20.2415>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <3.2926, 84.7229, 20.2415>, <2.1844, 85.6202, 20.8217>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.1844, 85.6202, 20.8217>, <0.6591, 87.1861, 22.07871>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <0.6591, 87.1861, 22.07871>, <-0.6281, 89.6348, 22.2712>, <-0.7461, 88.5956, 23.2928> }
					triangle { <-0.7461, 88.5956, 23.2928>, <-0.6281, 89.6348, 22.2712>, <-1.941, 91.3749, 23.3154> }
					triangle { <-0.7461, 88.5956, 23.2928>, <-1.941, 91.3749, 23.3154>, <-2.07559, 90.1875, 24.6314> }
					triangle { <-1.941, 91.3749, 23.3154>, <-2.9885, 91.9381, 25.8883>, <-2.07559, 90.1875, 24.6314> }
					triangle { <-0.7461, 88.5956, 23.2928>, <-0.4334, 88.01438, 24.5263>, <0.6591, 87.1861, 22.07871> }
					triangle { <-0.4334, 88.01438, 24.5263>, <-0.7461, 88.5956, 23.2928>, <-2.07559, 90.1875, 24.6314> }
					triangle { <-1.6119, 89.5586, 25.9775>, <-0.4334, 88.01438, 24.5263>, <-2.07559, 90.1875, 24.6314> }
					triangle { <-1.6119, 89.5586, 25.9775>, <-2.07559, 90.1875, 24.6314>, <-2.9885, 91.9381, 25.8883> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <0.6591, 87.1861, 22.07871>, <-1.8274, 87.7428, 23.1729>, <-0.7081, 88.6814, 23.2319> }
					triangle { <-0.7081, 88.6814, 23.2319>, <-1.8274, 87.7428, 23.1729>, <-3.5339, 89.08581, 24.2343> }
					triangle { <-0.7081, 88.6814, 23.2319>, <-3.5339, 89.08581, 24.2343>, <-2.2415, 90.3053, 24.2832> }
					triangle { <-3.5339, 89.08581, 24.2343>, <-3.9178, 91.8086, 24.9218>, <-2.2415, 90.3053, 24.2832> }
					triangle { <-0.7081, 88.6814, 23.2319>, <-0.002198, 89.8128, 22.8091>, <0.6591, 87.1861, 22.07871> }
					triangle { <-0.002198, 89.8128, 22.8091>, <-0.7081, 88.6814, 23.2319>, <-2.2415, 90.3053, 24.2832> }
					triangle { <-1.47, 91.5248, 23.7002>, <-0.002198, 89.8128, 22.8091>, <-2.2415, 90.3053, 24.2832> }
					triangle { <-1.47, 91.5248, 23.7002>, <-2.2415, 90.3053, 24.2832>, <-3.9178, 91.8086, 24.9218> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <0.6591, 87.1861, 22.07871>, <0.08849, 88.6566, 24.3595>, <-0.7975, 88.6223, 23.1971> }
					triangle { <-0.7975, 88.6223, 23.1971>, <0.08849, 88.6566, 24.3595>, <-1.2368, 90.03946, 25.8337> }
					triangle { <-0.7975, 88.6223, 23.1971>, <-1.2368, 90.03946, 25.8337>, <-2.3966, 89.9903, 24.4875> }
					triangle { <-1.2368, 90.03946, 25.8337>, <-3.9126, 90.9625, 25.9821>, <-2.3966, 89.9903, 24.4875> }
					triangle { <-0.7975, 88.6223, 23.1971>, <-1.9287, 88.184, 22.5003>, <0.6591, 87.1861, 22.07871> }
					triangle { <-1.9287, 88.184, 22.5003>, <-0.7975, 88.6223, 23.1971>, <-2.3966, 89.9903, 24.4875> }
					triangle { <-3.6252, 89.3908, 23.7435>, <-1.9287, 88.184, 22.5003>, <-2.3966, 89.9903, 24.4875> }
					triangle { <-3.6252, 89.3908, 23.7435>, <-2.3966, 89.9903, 24.4875>, <-3.9126, 90.9625, 25.9821> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <2.1844, 85.6202, 20.8217>, <1.0216, 86.6127, 21.00253>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.0216, 86.6127, 21.00253>, <-0.868, 88.2768, 20.8678>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-0.868, 88.2768, 20.8678>, <-3.5804, 88.8375, 21.00597>, <-2.5745, 89.8582, 20.7167> }
					triangle { <-2.5745, 89.8582, 20.7167>, <-3.5804, 88.8375, 21.00597>, <-5.5815, 90.1786, 20.8081> }
					triangle { <-2.5745, 89.8582, 20.7167>, <-5.5815, 90.1786, 20.8081>, <-4.4239, 91.4586, 20.382> }
					triangle { <-5.5815, 90.1786, 20.8081>, <-6.2997, 92.7114, 19.7577>, <-4.4239, 91.4586, 20.382> }
					triangle { <-2.5745, 89.8582, 20.7167>, <-1.8587, 90.6997, 19.8584>, <-0.868, 88.2768, 20.8678> }
					triangle { <-1.8587, 90.6997, 19.8584>, <-2.5745, 89.8582, 20.7167>, <-4.4239, 91.4586, 20.382> }
					triangle { <-3.6101, 92.2997, 19.356>, <-1.8587, 90.6997, 19.8584>, <-4.4239, 91.4586, 20.382> }
					triangle { <-3.6101, 92.2997, 19.356>, <-4.4239, 91.4586, 20.382>, <-6.2997, 92.7114, 19.7577> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-0.868, 88.2768, 20.8678>, <-2.1056, 90.5765, 21.8007>, <-2.6476, 89.7743, 20.7053> }
					triangle { <-2.6476, 89.7743, 20.7053>, <-2.1056, 90.5765, 21.8007>, <-3.8503, 92.2394, 21.9818> }
					triangle { <-2.6476, 89.7743, 20.7053>, <-3.8503, 92.2394, 21.9818>, <-4.6061, 91.2769, 20.6926> }
					triangle { <-3.8503, 92.2394, 21.9818>, <-6.5167, 92.5719, 21.07985>, <-4.6061, 91.2769, 20.6926> }
					triangle { <-2.6476, 89.7743, 20.7053>, <-3.5266, 88.8304, 20.1634>, <-0.868, 88.2768, 20.8678> }
					triangle { <-3.5266, 88.8304, 20.1634>, <-2.6476, 89.7743, 20.7053>, <-4.6061, 91.2769, 20.6926> }
					triangle { <-5.5573, 90.1555, 20.1825>, <-3.5266, 88.8304, 20.1634>, <-4.6061, 91.2769, 20.6926> }
					triangle { <-5.5573, 90.1555, 20.1825>, <-4.6061, 91.2769, 20.6926>, <-6.5167, 92.5719, 21.07985> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-0.868, 88.2768, 20.8678>, <-2.3163, 90.1444, 19.4169>, <-2.621, 89.8128, 20.8077> }
					triangle { <-2.621, 89.8128, 20.8077>, <-2.3163, 90.1444, 19.4169>, <-3.9585, 91.8793, 19.04885> }
					triangle { <-2.621, 89.8128, 20.8077>, <-3.9585, 91.8793, 19.04885>, <-4.3438, 91.58, 20.7582> }
					triangle { <-3.9585, 91.8793, 19.04885>, <-5.654, 93.5147, 20.625>, <-4.3438, 91.58, 20.7582> }
					triangle { <-2.621, 89.8128, 20.8077>, <-2.5925, 90.05476, 22.1854>, <-0.868, 88.2768, 20.8678> }
					triangle { <-2.5925, 90.05476, 22.1854>, <-2.621, 89.8128, 20.8077>, <-4.3438, 91.58, 20.7582> }
					triangle { <-4.1949, 91.8722, 22.2796>, <-2.5925, 90.05476, 22.1854>, <-4.3438, 91.58, 20.7582> }
					triangle { <-4.1949, 91.8722, 22.2796>, <-4.3438, 91.58, 20.7582>, <-5.654, 93.5147, 20.625> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <1.0216, 86.6127, 21.00253>, <-0.2703, 87.3183, 21.4529>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.2703, 87.3183, 21.4529>, <-2.4418, 88.1291, 22.4457>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-2.4418, 88.1291, 22.4457>, <-3.805, 89.8372, 24.1528>, <-4.479, 88.8261, 23.3399> }
					triangle { <-4.479, 88.8261, 23.3399>, <-3.805, 89.8372, 24.1528>, <-5.7077, 90.7204, 25.3535> }
					triangle { <-4.479, 88.8261, 23.3399>, <-5.7077, 90.7204, 25.3535>, <-6.5884, 89.4687, 24.4494> }
					triangle { <-5.7077, 90.7204, 25.3535>, <-8.3918, 89.9615, 25.8574>, <-6.5884, 89.4687, 24.4494> }
					triangle { <-4.479, 88.8261, 23.3399>, <-5.1035, 87.5889, 23.1487>, <-2.4418, 88.1291, 22.4457> }
					triangle { <-5.1035, 87.5889, 23.1487>, <-4.479, 88.8261, 23.3399>, <-6.5884, 89.4687, 24.4494> }
					triangle { <-7.1914, 88.04222, 24.2954>, <-5.1035, 87.5889, 23.1487>, <-6.5884, 89.4687, 24.4494> }
					triangle { <-7.1914, 88.04222, 24.2954>, <-6.5884, 89.4687, 24.4494>, <-8.3918, 89.9615, 25.8574> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-2.4418, 88.1291, 22.4457>, <-4.9569, 89.249, 22.1137>, <-4.4225, 88.8763, 23.4224> }
					triangle { <-4.4225, 88.8763, 23.4224>, <-4.9569, 89.249, 22.1137>, <-7.06528, 90.2112, 22.8002> }
					triangle { <-4.4225, 88.8763, 23.4224>, <-7.06528, 90.2112, 22.8002>, <-6.4553, 89.849, 24.4301> }
					triangle { <-7.06528, 90.2112, 22.8002>, <-8.2543, 91.1309, 25.2032>, <-6.4553, 89.849, 24.4301> }
					triangle { <-4.4225, 88.8763, 23.4224>, <-3.8276, 89.16, 24.6564>, <-2.4418, 88.1291, 22.4457> }
					triangle { <-3.8276, 89.16, 24.6564>, <-4.4225, 88.8763, 23.4224>, <-6.4553, 89.849, 24.4301> }
					triangle { <-5.7124, 90.2302, 25.7436>, <-3.8276, 89.16, 24.6564>, <-6.4553, 89.849, 24.4301> }
					triangle { <-5.7124, 90.2302, 25.7436>, <-6.4553, 89.849, 24.4301>, <-8.2543, 91.1309, 25.2032> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-2.4418, 88.1291, 22.4457>, <-4.7417, 87.6247, 23.9107>, <-4.4453, 88.932, 23.3272> }
					triangle { <-4.4453, 88.932, 23.3272>, <-4.7417, 87.6247, 23.9107>, <-6.9167, 88.09125, 24.8563> }
					triangle { <-4.4453, 88.932, 23.3272>, <-6.9167, 88.09125, 24.8563>, <-6.6584, 89.6874, 24.1177> }
					triangle { <-6.9167, 88.09125, 24.8563>, <-8.9076, 90.0948, 24.6203>, <-6.6584, 89.6874, 24.1177> }
					triangle { <-4.4453, 88.932, 23.3272>, <-4.591, 89.9301, 22.3578>, <-2.4418, 88.1291, 22.4457> }
					triangle { <-4.591, 89.9301, 22.3578>, <-4.4453, 88.932, 23.3272>, <-6.6584, 89.6874, 24.1177> }
					triangle { <-6.8069, 90.7124, 22.956>, <-4.591, 89.9301, 22.3578>, <-6.6584, 89.6874, 24.1177> }
					triangle { <-6.8069, 90.7124, 22.956>, <-6.6584, 89.6874, 24.1177>, <-8.9076, 90.0948, 24.6203> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.7286, 80.1711, 18.8069>, <7.1136, 81.4999, 19.4822>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <7.1136, 81.4999, 19.4822>, <7.8706, 82.6992, 20.08107>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8706, 82.6992, 20.08107>, <9.04355, 84.8502, 20.6774>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <9.04355, 84.8502, 20.6774>, <9.0747, 87.2614, 22.04697>, <10.1699, 86.8285, 21.1807> }
					triangle { <10.1699, 86.8285, 21.1807>, <9.0747, 87.2614, 22.04697>, <9.9035, 89.441, 22.683> }
					triangle { <10.1699, 86.8285, 21.1807>, <9.9035, 89.441, 22.683>, <11.2409, 89.01419, 21.5924> }
					triangle { <9.9035, 89.441, 22.683>, <11.9053, 91.2477, 21.8097>, <11.2409, 89.01419, 21.5924> }
					triangle { <10.1699, 86.8285, 21.1807>, <10.8974, 86.839, 19.9858>, <9.04355, 84.8502, 20.6774> }
					triangle { <10.8974, 86.839, 19.9858>, <10.1699, 86.8285, 21.1807>, <11.2409, 89.01419, 21.5924> }
					triangle { <11.9458, 89.01452, 20.2048>, <10.8974, 86.839, 19.9858>, <11.2409, 89.01419, 21.5924> }
					triangle { <11.9458, 89.01452, 20.2048>, <11.2409, 89.01419, 21.5924>, <11.9053, 91.2477, 21.8097> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <9.04355, 84.8502, 20.6774>, <11.2117, 86.1644, 21.8009>, <10.07313, 86.8713, 21.2168> }
					triangle { <10.07313, 86.8713, 21.2168>, <11.2117, 86.1644, 21.8009>, <12.4901, 88.0537, 22.6> }
					triangle { <10.07313, 86.8713, 21.2168>, <12.4901, 88.0537, 22.6>, <11.1093, 88.9806, 21.9722> }
					triangle { <12.4901, 88.0537, 22.6>, <12.05683, 90.814, 23.07599>, <11.1093, 88.9806, 21.9722> }
					triangle { <10.07313, 86.8713, 21.2168>, <8.8704, 87.5818, 21.293>, <9.04355, 84.8502, 20.6774> }
					triangle { <8.8704, 87.5818, 21.293>, <10.07313, 86.8713, 21.2168>, <11.1093, 88.9806, 21.9722> }
					triangle { <9.7318, 89.6871, 22.133>, <8.8704, 87.5818, 21.293>, <11.1093, 88.9806, 21.9722> }
					triangle { <9.7318, 89.6871, 22.133>, <11.1093, 88.9806, 21.9722>, <12.05683, 90.814, 23.07599> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <9.04355, 84.8502, 20.6774>, <10.1712, 87.26, 19.8955>, <10.1402, 86.815, 21.2877> }
					triangle { <10.1402, 86.815, 21.2877>, <10.1712, 87.26, 19.8955>, <11.4023, 89.323, 20.1608> }
					triangle { <10.1402, 86.815, 21.2877>, <11.4023, 89.323, 20.1608>, <11.4648, 88.8168, 21.8637> }
					triangle { <11.4023, 89.323, 20.1608>, <13.0091, 90.5527, 22.1459>, <11.4648, 88.8168, 21.8637> }
					triangle { <10.1402, 86.815, 21.2877>, <10.7157, 86.259, 22.4352>, <9.04355, 84.8502, 20.6774> }
					triangle { <10.7157, 86.259, 22.4352>, <10.1402, 86.815, 21.2877>, <11.4648, 88.8168, 21.8637> }
					triangle { <12.1473, 88.11, 23.0708>, <10.7157, 86.259, 22.4352>, <11.4648, 88.8168, 21.8637> }
					triangle { <12.1473, 88.11, 23.0708>, <11.4648, 88.8168, 21.8637>, <13.0091, 90.5527, 22.1459> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.1136, 81.4999, 19.4822>, <7.1005, 82.868, 20.1879>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.1005, 82.868, 20.1879>, <7.134, 84.8803, 21.707>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <7.134, 84.8803, 21.707>, <8.4484, 87.1125, 22.697>, <7.1132, 86.7174, 23.1425> }
					triangle { <7.1132, 86.7174, 23.1425>, <8.4484, 87.1125, 22.697>, <8.8039, 89.02036, 24.1379> }
					triangle { <7.1132, 86.7174, 23.1425>, <8.8039, 89.02036, 24.1379>, <7.2103, 88.5628, 24.7791> }
					triangle { <8.8039, 89.02036, 24.1379>, <7.6411, 90.1089, 26.4824>, <7.2103, 88.5628, 24.7791> }
					triangle { <7.1132, 86.7174, 23.1425>, <6.2191, 86.1318, 24.04528>, <7.134, 84.8803, 21.707> }
					triangle { <6.2191, 86.1318, 24.04528>, <7.1132, 86.7174, 23.1425>, <7.2103, 88.5628, 24.7791> }
					triangle { <6.2892, 87.8167, 25.7877>, <6.2191, 86.1318, 24.04528>, <7.2103, 88.5628, 24.7791> }
					triangle { <6.2892, 87.8167, 25.7877>, <7.2103, 88.5628, 24.7791>, <7.6411, 90.1089, 26.4824> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <7.134, 84.8803, 21.707>, <6.05107, 87.3113, 22.4866>, <7.2243, 86.7239, 23.1314> }
					triangle { <7.2243, 86.7239, 23.1314>, <6.05107, 87.3113, 22.4866>, <5.9237, 89.3943, 23.706> }
					triangle { <7.2243, 86.7239, 23.1314>, <5.9237, 89.3943, 23.706>, <7.3943, 88.7771, 24.4912> }
					triangle { <5.9237, 89.3943, 23.706>, <7.5991, 90.9206, 25.4083>, <7.3943, 88.7771, 24.4912> }
					triangle { <7.2243, 86.7239, 23.1314>, <8.6, 86.6105, 23.3587>, <7.134, 84.8803, 21.707> }
					triangle { <8.6, 86.6105, 23.3587>, <7.2243, 86.7239, 23.1314>, <7.3943, 88.7771, 24.4912> }
					triangle { <8.9397, 88.6504, 24.625>, <8.6, 86.6105, 23.3587>, <7.3943, 88.7771, 24.4912> }
					triangle { <8.9397, 88.6504, 24.625>, <7.3943, 88.7771, 24.4912>, <7.5991, 90.9206, 25.4083> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <7.134, 84.8803, 21.707>, <7.01647, 85.9562, 24.2602>, <7.1568, 86.7789, 23.05997> }
					triangle { <7.1568, 86.7789, 23.05997>, <7.01647, 85.9562, 24.2602>, <6.8883, 87.6999, 25.9292> }
					triangle { <7.1568, 86.7789, 23.05997>, <6.8883, 87.6999, 25.9292>, <6.9887, 88.7682, 24.5119> }
					triangle { <6.8883, 87.6999, 25.9292>, <6.4491, 90.4994, 25.9915>, <6.9887, 88.7682, 24.5119> }
					triangle { <7.1568, 86.7789, 23.05997>, <6.665, 87.6238, 22.0592>, <7.134, 84.8803, 21.707> }
					triangle { <6.665, 87.6238, 22.0592>, <7.1568, 86.7789, 23.05997>, <6.9887, 88.7682, 24.5119> }
					triangle { <6.3512, 89.6304, 23.3839>, <6.665, 87.6238, 22.0592>, <6.9887, 88.7682, 24.5119> }
					triangle { <6.3512, 89.6304, 23.3839>, <6.9887, 88.7682, 24.5119>, <6.4491, 90.4994, 25.9915> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.1136, 81.4999, 19.4822>, <7.4481, 82.9742, 19.7727>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <7.4481, 82.9742, 19.7727>, <7.4617, 84.5125, 19.8312>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.4617, 84.5125, 19.8312>, <7.2672, 86.9828, 20.2982>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <7.2672, 86.9828, 20.2982>, <8.4361, 89.3708, 21.08644>, <7.02289, 89.2611, 20.7286> }
					triangle { <7.02289, 89.2611, 20.7286>, <8.4361, 89.3708, 21.08644>, <8.5085, 91.7006, 21.7259> }
					triangle { <7.02289, 89.2611, 20.7286>, <8.5085, 91.7006, 21.7259>, <6.7675, 91.6301, 21.3737> }
					triangle { <8.5085, 91.7006, 21.7259>, <6.6542, 93.7462, 22.3671>, <6.7675, 91.6301, 21.3737> }
					triangle { <7.02289, 89.2611, 20.7286>, <5.6607, 89.1626, 21.03205>, <7.2672, 86.9828, 20.2982> }
					triangle { <5.6607, 89.1626, 21.03205>, <7.02289, 89.2611, 20.7286>, <6.7675, 91.6301, 21.3737> }
					triangle { <5.2806, 91.4344, 21.7899>, <5.6607, 89.1626, 21.03205>, <6.7675, 91.6301, 21.3737> }
					triangle { <5.2806, 91.4344, 21.7899>, <6.7675, 91.6301, 21.3737>, <6.6542, 93.7462, 22.3671> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <7.2672, 86.9828, 20.2982>, <6.7022, 89.5502, 19.4153>, <7.1189, 89.2579, 20.7858> }
					triangle { <7.1189, 89.2579, 20.7858>, <6.7022, 89.5502, 19.4153>, <6.5604, 91.9597, 19.5443> }
					triangle { <7.1189, 89.2579, 20.7858>, <6.5604, 91.9597, 19.5443>, <7.1296, 91.6902, 21.2066> }
					triangle { <6.5604, 91.9597, 19.5443>, <7.4303, 94.00949, 21.298>, <7.1296, 91.6902, 21.2066> }
					triangle { <7.1189, 89.2579, 20.7858>, <8.05742, 89.202, 21.8218>, <7.2672, 86.9828, 20.2982> }
					triangle { <8.05742, 89.202, 21.8218>, <7.1189, 89.2579, 20.7858>, <7.1296, 91.6902, 21.2066> }
					triangle { <8.2488, 91.575, 22.2821>, <8.05742, 89.202, 21.8218>, <7.1296, 91.6902, 21.2066> }
					triangle { <8.2488, 91.575, 22.2821>, <7.1296, 91.6902, 21.2066>, <7.4303, 94.00949, 21.298> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <7.2672, 86.9828, 20.2982>, <6.1281, 89.06773, 21.7286>, <7.1195, 89.2788, 20.6751> }
					triangle { <7.1195, 89.2788, 20.6751>, <6.1281, 89.06773, 21.7286>, <5.6469, 91.368, 22.2938> }
					triangle { <7.1195, 89.2788, 20.6751>, <5.6469, 91.368, 22.2938>, <6.7939, 91.7069, 20.9786> }
					triangle { <5.6469, 91.368, 22.2938>, <6.08314, 93.9293, 21.1609>, <6.7939, 91.7069, 20.9786> }
					triangle { <7.1195, 89.2788, 20.6751>, <7.5089, 89.6212, 19.3758>, <7.2672, 86.9828, 20.2982> }
					triangle { <7.5089, 89.6212, 19.3758>, <7.1195, 89.2788, 20.6751>, <6.7939, 91.7069, 20.9786> }
					triangle { <7.1405, 92.01509, 19.493>, <7.5089, 89.6212, 19.3758>, <6.7939, 91.7069, 20.9786> }
					triangle { <7.1405, 92.01509, 19.493>, <6.7939, 91.7069, 20.9786>, <6.08314, 93.9293, 21.1609> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.4481, 82.9742, 19.7727>, <8.0809, 84.2844, 20.2756>, 0.05424 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.0809, 84.2844, 20.2756>, <9.3234, 86.4334, 20.719>, 0.05424 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <9.3234, 86.4334, 20.719>, <9.3233, 89.1972, 20.9461>, <10.5281, 88.3881, 21.1228> }
					triangle { <10.5281, 88.3881, 21.1228>, <9.3233, 89.1972, 20.9461>, <10.2799, 91.4023, 21.2003> }
					triangle { <10.5281, 88.3881, 21.1228>, <10.2799, 91.4023, 21.2003>, <11.7982, 90.4916, 21.3591> }
					triangle { <10.2799, 91.4023, 21.2003>, <12.863, 92.5691, 21.1922>, <11.7982, 90.4916, 21.3591> }
					triangle { <10.5281, 88.3881, 21.1228>, <11.7455, 87.8487, 20.6937>, <9.3234, 86.4334, 20.719> }
					triangle { <11.7455, 87.8487, 20.6937>, <10.5281, 88.3881, 21.1228>, <11.7982, 90.4916, 21.3591> }
					triangle { <13.0974, 89.8599, 20.7799>, <11.7455, 87.8487, 20.6937>, <11.7982, 90.4916, 21.3591> }
					triangle { <13.0974, 89.8599, 20.7799>, <11.7982, 90.4916, 21.3591>, <12.863, 92.5691, 21.1922> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <9.3234, 86.4334, 20.719>, <10.8311, 88.02119, 22.4207>, <10.4445, 88.4461, 21.07642> }
					triangle { <10.4445, 88.4461, 21.07642>, <10.8311, 88.02119, 22.4207>, <11.9729, 90.01905, 23.1603> }
					triangle { <10.4445, 88.4461, 21.07642>, <11.9729, 90.01905, 23.1603>, <11.4816, 90.6321, 21.5657> }
					triangle { <11.9729, 90.01905, 23.1603>, <12.182, 92.7252, 22.3439>, <11.4816, 90.6321, 21.5657> }
					triangle { <10.4445, 88.4461, 21.07642>, <9.6563, 89.1645, 20.171>, <9.3234, 86.4334, 20.719> }
					triangle { <9.6563, 89.1645, 20.171>, <10.4445, 88.4461, 21.07642>, <11.4816, 90.6321, 21.5657> }
					triangle { <10.5084, 91.3905, 20.617>, <9.6563, 89.1645, 20.171>, <11.4816, 90.6321, 21.5657> }
					triangle { <10.5084, 91.3905, 20.617>, <11.4816, 90.6321, 21.5657>, <12.182, 92.7252, 22.3439> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <9.3234, 86.4334, 20.719>, <11.3399, 88.2159, 20.05073>, <10.4436, 88.4238, 21.1868> }
					triangle { <10.4436, 88.4238, 21.1868>, <11.3399, 88.2159, 20.05073>, <12.7793, 90.1391, 20.3179> }
					triangle { <10.4436, 88.4238, 21.1868>, <12.7793, 90.1391, 20.3179>, <11.7739, 90.4238, 21.7559> }
					triangle { <12.7793, 90.1391, 20.3179>, <13.3574, 92.04816, 22.3317>, <11.7739, 90.4238, 21.7559> }
					triangle { <10.4436, 88.4238, 21.1868>, <10.1269, 88.4018, 22.5493>, <9.3234, 86.4334, 20.719> }
					triangle { <10.1269, 88.4018, 22.5493>, <10.4436, 88.4238, 21.1868>, <11.7739, 90.4238, 21.7559> }
					triangle { <11.4664, 90.2881, 23.2756>, <10.1269, 88.4018, 22.5493>, <11.7739, 90.4238, 21.7559> }
					triangle { <11.4664, 90.2881, 23.2756>, <11.7739, 90.4238, 21.7559>, <13.3574, 92.04816, 22.3317> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		}
} // end Copy_of_Breeder_plant_2

#declare Copy_of_Copy_of_Breeder_plant_2 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.2542, 2.06168, 0.0>, 0.07122 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <-0.2542, 2.06168, 0.0>, <-0.2356, 3.145, 0.04992>, 0.03718 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2356, 3.145, 0.04992>, <0.01787, 3.3524, 0.1414>, 0.02003 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <0.01787, 3.3524, 0.1414>, <0.3375, 3.5761, 0.2399>, <0.3349, 3.5706, 0.2733> }
			triangle { <0.3375, 3.5761, 0.2399>, <0.4901, 3.5103, 0.2728>, <0.3349, 3.5706, 0.2733> }
			triangle { <0.3375, 3.5761, 0.2399>, <0.4672, 3.5288, 0.2383>, <0.4901, 3.5103, 0.2728> }
			triangle { <0.4901, 3.5103, 0.2728>, <0.4492, 3.5219, 0.304>, <0.3349, 3.5706, 0.2733> }
			triangle { <0.3349, 3.5706, 0.2733>, <0.2184, 3.4649, 0.2366>, <0.01787, 3.3524, 0.1414> }
			triangle { <0.01787, 3.3524, 0.1414>, <0.2328, 3.473, 0.1784>, <0.3375, 3.5761, 0.2399> }
			triangle { <0.2328, 3.473, 0.1784>, <0.3664, 3.5451, 0.2021>, <0.3375, 3.5761, 0.2399> }
			triangle { <0.3664, 3.5451, 0.2021>, <0.4672, 3.5288, 0.2383>, <0.3375, 3.5761, 0.2399> }
			triangle { <0.3349, 3.5706, 0.2733>, <0.4492, 3.5219, 0.304>, <0.3617, 3.5268, 0.2985> }
			triangle { <0.3617, 3.5268, 0.2985>, <0.2184, 3.4649, 0.2366>, <0.3349, 3.5706, 0.2733> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.2356, 3.145, 0.04992>, <1.8728, 11.3339, 1.07237>, 0.292 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.8728, 11.3339, 1.07237>, <3.5819, 12.2304, 1.669>, 0.119 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <3.5819, 12.2304, 1.669>, <5.6946, 13.1441, 2.3117>, <5.6716, 13.1072, 2.5086> }
			triangle { <5.6946, 13.1441, 2.3117>, <6.5071, 12.579, 2.4922>, <5.6716, 13.1072, 2.5086> }
			triangle { <5.6946, 13.1441, 2.3117>, <6.3972, 12.7211, 2.2919>, <6.5071, 12.579, 2.4922> }
			triangle { <6.5071, 12.579, 2.4922>, <6.2807, 12.6853, 2.6796>, <5.6716, 13.1072, 2.5086> }
			triangle { <5.6716, 13.1072, 2.5086>, <4.8739, 12.6333, 2.2634>, <3.5819, 12.2304, 1.669> }
			triangle { <3.5819, 12.2304, 1.669>, <4.9702, 12.678, 1.9204>, <5.6946, 13.1441, 2.3117> }
			triangle { <4.9702, 12.678, 1.9204>, <5.8299, 12.94, 2.08025>, <5.6946, 13.1441, 2.3117> }
			triangle { <5.8299, 12.94, 2.08025>, <6.3972, 12.7211, 2.2919>, <5.6946, 13.1441, 2.3117> }
			triangle { <5.6716, 13.1072, 2.5086>, <6.2807, 12.6853, 2.6796>, <5.7763, 12.8151, 2.6474> }
			triangle { <5.7763, 12.8151, 2.6474>, <4.8739, 12.6333, 2.2634>, <5.6716, 13.1072, 2.5086> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.8728, 11.3339, 1.07237>, <9.5525, 26.5764, 4.2067>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <9.5525, 26.5764, 4.2067>, <17.2311, 27.5234, 6.7626>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <17.2311, 27.5234, 6.7626>, <26.4917, 28.04494, 9.3869>, <26.3728, 27.7558, 10.1378> }
			triangle { <26.4917, 28.04494, 9.3869>, <28.9894, 24.8468, 9.368>, <26.3728, 27.7558, 10.1378> }
			triangle { <26.4917, 28.04494, 9.3869>, <28.716, 25.6839, 8.7337>, <28.9894, 24.8468, 9.368> }
			triangle { <28.9894, 24.8468, 9.368>, <28.2494, 25.3332, 10.2653>, <26.3728, 27.7558, 10.1378> }
			triangle { <26.3728, 27.7558, 10.1378>, <22.7272, 27.07483, 9.0294>, <17.2311, 27.5234, 6.7626> }
			triangle { <17.2311, 27.5234, 6.7626>, <23.1288, 27.4417, 7.687>, <26.4917, 28.04494, 9.3869> }
			triangle { <23.1288, 27.4417, 7.687>, <26.7633, 27.3303, 8.263>, <26.4917, 28.04494, 9.3869> }
			triangle { <26.7633, 27.3303, 8.263>, <28.716, 25.6839, 8.7337>, <26.4917, 28.04494, 9.3869> }
			triangle { <26.3728, 27.7558, 10.1378>, <28.2494, 25.3332, 10.2653>, <26.4488, 26.4135, 10.4067> }
			triangle { <26.4488, 26.4135, 10.4067>, <22.7272, 27.07483, 9.0294>, <26.3728, 27.7558, 10.1378> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <9.5525, 26.5764, 4.2067>, <16.9315, 42.01212, 7.1096>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <16.9315, 42.01212, 7.1096>, <14.1866, 49.1348, 4.2595>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <14.1866, 49.1348, 4.2595>, <10.2533, 57.2854, 0.9407>, <10.4604, 57.1574, 0.1646> }
			triangle { <10.2533, 57.2854, 0.9407>, <6.612, 57.4283, -0.8445>, <10.4604, 57.1574, 0.1646> }
			triangle { <10.2533, 57.2854, 0.9407>, <7.05824, 57.5804, 0.133>, <6.612, 57.4283, -0.8445> }
			triangle { <6.612, 57.4283, -0.8445>, <7.774, 57.2787, -1.3102>, <10.4604, 57.1574, 0.1646> }
			triangle { <10.4604, 57.1574, 0.1646>, <11.6536, 53.661, 1.3195>, <14.1866, 49.1348, 4.2595> }
			triangle { <14.1866, 49.1348, 4.2595>, <11.07097, 53.9539, 2.6127>, <10.2533, 57.2854, 0.9407> }
			triangle { <11.07097, 53.9539, 2.6127>, <9.1122, 56.8897, 1.5643>, <10.2533, 57.2854, 0.9407> }
			triangle { <9.1122, 56.8897, 1.5643>, <7.05824, 57.5804, 0.133>, <10.2533, 57.2854, 0.9407> }
			triangle { <10.4604, 57.1574, 0.1646>, <7.774, 57.2787, -1.3102>, <9.6268, 56.4916, -0.6964> }
			triangle { <9.6268, 56.4916, -0.6964>, <11.6536, 53.661, 1.3195>, <10.4604, 57.1574, 0.1646> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <16.9315, 42.01212, 7.1096>, <24.9289, 56.9145, 10.9948>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <24.9289, 56.9145, 10.9948>, <30.2421, 58.3331, 17.00713>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <30.2421, 58.3331, 17.00713>, <36.7356, 59.3019, 24.06507>, <36.1901, 59.3037, 24.6684> }
			triangle { <36.7356, 59.3019, 24.06507>, <38.07068, 56.1877, 26.298>, <36.1901, 59.3037, 24.6684> }
			triangle { <36.7356, 59.3019, 24.06507>, <38.3598, 56.758, 25.421>, <38.07068, 56.1877, 26.298> }
			triangle { <38.07068, 56.1877, 26.298>, <37.1171, 56.9957, 26.463>, <36.1901, 59.3037, 24.6684> }
			triangle { <36.1901, 59.3037, 24.6684>, <33.5603, 58.4514, 21.9591>, <30.2421, 58.3331, 17.00713> }
			triangle { <30.2421, 58.3331, 17.00713>, <34.6572, 58.299, 21.02575>, <36.7356, 59.3019, 24.06507> }
			triangle { <34.6572, 58.299, 21.02575>, <37.3607, 58.2231, 23.5236>, <36.7356, 59.3019, 24.06507> }
			triangle { <37.3607, 58.2231, 23.5236>, <38.3598, 56.758, 25.421>, <36.7356, 59.3019, 24.06507> }
			triangle { <36.1901, 59.3037, 24.6684>, <37.1171, 56.9957, 26.463>, <35.8029, 58.1418, 25.2847> }
			triangle { <35.8029, 58.1418, 25.2847>, <33.5603, 58.4514, 21.9591>, <36.1901, 59.3037, 24.6684> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <24.9289, 56.9145, 10.9948>, <33.01227, 71.6637, 15.268>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <33.01227, 71.6637, 15.268>, <33.8927, 78.1189, 10.3747>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <33.8927, 78.1189, 10.3747>, <34.2805, 85.5801, 4.2838>, <34.8274, 85.2415, 3.786> }
			triangle { <34.2805, 85.5801, 4.2838>, <32.2619, 85.6823, 0.765>, <34.8274, 85.2415, 3.786> }
			triangle { <34.2805, 85.5801, 4.2838>, <32.1508, 86.02104, 1.7901>, <32.2619, 85.6823, 0.765> }
			triangle { <32.2619, 85.6823, 0.765>, <33.4245, 85.2931, 1.05902>, <34.8274, 85.2415, 3.786> }
			triangle { <34.8274, 85.2415, 3.786>, <34.3966, 82.02951, 5.9024>, <33.8927, 78.1189, 10.3747> }
			triangle { <33.8927, 78.1189, 10.3747>, <33.3087, 82.6969, 6.5871>, <34.2805, 85.5801, 4.2838> }
			triangle { <33.3087, 82.6969, 6.5871>, <32.9269, 85.4813, 4.209>, <34.2805, 85.5801, 4.2838> }
			triangle { <32.9269, 85.4813, 4.209>, <32.1508, 86.02104, 1.7901>, <34.2805, 85.5801, 4.2838> }
			triangle { <34.8274, 85.2415, 3.786>, <33.4245, 85.2931, 1.05902>, <34.4415, 84.4805, 2.7127> }
			triangle { <34.4415, 84.4805, 2.7127>, <34.3966, 82.02951, 5.9024>, <34.8274, 85.2415, 3.786> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <33.01227, 71.6637, 15.268>, <40.8549, 85.8044, 21.5663>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <40.8549, 85.8044, 21.5663>, <42.1253, 87.5576, 29.4214>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <42.1253, 87.5576, 29.4214>, <43.6749, 88.9026, 38.8399>, <42.9026, 89.08649, 39.01698> }
			triangle { <43.6749, 88.9026, 38.8399>, <42.8559, 86.09161, 41.6495>, <42.9026, 89.08649, 39.01698> }
			triangle { <43.6749, 88.9026, 38.8399>, <43.6944, 86.4503, 41.06118>, <42.8559, 86.09161, 41.6495> }
			triangle { <42.8559, 86.09161, 41.6495>, <42.1682, 87.03672, 41.1771>, <42.9026, 89.08649, 39.01698> }
			triangle { <42.9026, 89.08649, 39.01698>, <42.09476, 88.1204, 35.3568>, <42.1253, 87.5576, 29.4214> }
			triangle { <42.1253, 87.5576, 29.4214>, <43.4617, 87.6564, 35.2393>, <43.6749, 88.9026, 38.8399> }
			triangle { <43.4617, 87.6564, 35.2393>, <44.2477, 87.67, 38.836>, <43.6749, 88.9026, 38.8399> }
			triangle { <44.2477, 87.67, 38.836>, <43.6944, 86.4503, 41.06118>, <43.6749, 88.9026, 38.8399> }
			triangle { <42.9026, 89.08649, 39.01698>, <42.1682, 87.03672, 41.1771>, <42.00274, 88.1174, 39.3788> }
			triangle { <42.00274, 88.1174, 39.3788>, <42.09476, 88.1204, 35.3568>, <42.9026, 89.08649, 39.01698> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <40.8549, 85.8044, 21.5663>, <49.3575, 100.1687, 26.3108>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <49.3575, 100.1687, 26.3108>, <54.1826, 105.0189, 21.8855>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <54.1826, 105.0189, 21.8855>, <59.5011, 110.5526, 16.05372>, <60.1464, 110.0575, 16.0493> }
			triangle { <59.5011, 110.5526, 16.05372>, <59.8894, 109.8558, 12.07499>, <60.1464, 110.0575, 16.0493> }
			triangle { <59.5011, 110.5526, 16.05372>, <59.2957, 110.4611, 12.7525>, <59.8894, 109.8558, 12.07499> }
			triangle { <59.8894, 109.8558, 12.07499>, <60.5705, 109.4799, 13.06707>, <60.1464, 110.0575, 16.0493> }
			triangle { <60.1464, 110.0575, 16.0493>, <57.9304, 107.5592, 18.00636>, <54.1826, 105.0189, 21.8855> }
			triangle { <54.1826, 105.0189, 21.8855>, <56.8175, 108.4571, 17.7769>, <59.5011, 110.5526, 16.05372> }
			triangle { <56.8175, 108.4571, 17.7769>, <58.4406, 110.5304, 15.2038>, <59.5011, 110.5526, 16.05372> }
			triangle { <58.4406, 110.5304, 15.2038>, <59.2957, 110.4611, 12.7525>, <59.5011, 110.5526, 16.05372> }
			triangle { <60.1464, 110.0575, 16.0493>, <60.5705, 109.4799, 13.06707>, <60.2805, 109.0674, 15.1103> }
			triangle { <60.2805, 109.0674, 15.1103>, <57.9304, 107.5592, 18.00636>, <60.1464, 110.0575, 16.0493> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <49.3575, 100.1687, 26.3108>, <57.3441, 114.5902, 31.7305>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <57.3441, 114.5902, 31.7305>, <55.5374, 118.9303, 38.3855>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <55.5374, 118.9303, 38.3855>, <53.1804, 123.4322, 46.5767>, <52.4939, 123.7587, 46.2873> }
			triangle { <53.1804, 123.4322, 46.5767>, <50.4745, 121.9628, 49.2197>, <52.4939, 123.7587, 46.2873> }
			triangle { <53.1804, 123.4322, 46.5767>, <51.548, 121.9788, 49.06088>, <50.4745, 121.9628, 49.2197> }
			triangle { <50.4745, 121.9628, 49.2197>, <50.3551, 122.7444, 48.2377>, <52.4939, 123.7587, 46.2873> }
			triangle { <52.4939, 123.7587, 46.2873>, <53.1087, 121.6245, 43.1173>, <55.5374, 118.9303, 38.3855> }
			triangle { <55.5374, 118.9303, 38.3855>, <54.2002, 120.9902, 43.8272>, <53.1804, 123.4322, 46.5767> }
			triangle { <54.2002, 120.9902, 43.8272>, <53.3258, 122.2247, 47.1836>, <53.1804, 123.4322, 46.5767> }
			triangle { <53.3258, 122.2247, 47.1836>, <51.548, 121.9788, 49.06088>, <53.1804, 123.4322, 46.5767> }
			triangle { <52.4939, 123.7587, 46.2873>, <50.3551, 122.7444, 48.2377>, <51.2936, 123.1038, 46.3886> }
			triangle { <51.2936, 123.1038, 46.3886>, <53.1087, 121.6245, 43.1173>, <52.4939, 123.7587, 46.2873> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <57.3441, 114.5902, 31.7305>, <67.2464, 128.2998, 35.6199>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <67.2464, 128.2998, 35.6199>, <74.5826, 130.0688, 32.8104>, 0.4743 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <74.5826, 130.0688, 32.8104>, <83.07931, 131.8107, 28.87>, <83.4747, 131.2593, 29.3009> }
			triangle { <83.07931, 131.8107, 28.87>, <84.6448, 129.5598, 25.9432>, <83.4747, 131.2593, 29.3009> }
			triangle { <83.07931, 131.8107, 28.87>, <84.08276, 130.4654, 26.06352>, <84.6448, 129.5598, 25.9432> }
			triangle { <84.6448, 129.5598, 25.9432>, <84.7444, 129.5005, 27.1838>, <83.4747, 131.2593, 29.3009> }
			triangle { <83.4747, 131.2593, 29.3009>, <80.04542, 130.1759, 30.6044>, <74.5826, 130.0688, 32.8104> }
			triangle { <74.5826, 130.0688, 32.8104>, <79.4644, 131.073, 29.6523>, <83.07931, 131.8107, 28.87> }
			triangle { <79.4644, 131.073, 29.6523>, <82.4727, 131.6351, 27.6843>, <83.07931, 131.8107, 28.87> }
			triangle { <82.4727, 131.6351, 27.6843>, <84.08276, 130.4654, 26.06352>, <83.07931, 131.8107, 28.87> }
			triangle { <83.4747, 131.2593, 29.3009>, <84.7444, 129.5005, 27.1838>, <83.6132, 129.9854, 28.8605> }
			triangle { <83.6132, 129.9854, 28.8605>, <80.04542, 130.1759, 30.6044>, <83.4747, 131.2593, 29.3009> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <67.2464, 128.2998, 35.6199>, <73.07021, 143.7403, 40.9876>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <73.07021, 143.7403, 40.9876>, <72.1283, 145.2487, 41.7918>, 0.1149 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <72.1283, 145.2487, 41.7918>, <70.8945, 146.917, 42.8045>, <70.8159, 146.9838, 42.6392> }
			triangle { <70.8945, 146.917, 42.8045>, <69.9479, 146.8302, 43.00727>, <70.8159, 146.9838, 42.6392> }
			triangle { <70.8945, 146.917, 42.8045>, <70.1785, 146.8008, 43.1236>, <69.9479, 146.8302, 43.00727> }
			triangle { <69.9479, 146.8302, 43.00727>, <70.09367, 146.9385, 42.7659>, <70.8159, 146.9838, 42.6392> }
			triangle { <70.8159, 146.9838, 42.6392>, <71.2126, 146.2551, 42.2257>, <72.1283, 145.2487, 41.7918> }
			triangle { <72.1283, 145.2487, 41.7918>, <71.2996, 146.1409, 42.5415>, <70.8945, 146.917, 42.8045> }
			triangle { <71.2996, 146.1409, 42.5415>, <70.7766, 146.684, 42.9989>, <70.8945, 146.917, 42.8045> }
			triangle { <70.7766, 146.684, 42.9989>, <70.1785, 146.8008, 43.1236>, <70.8945, 146.917, 42.8045> }
			triangle { <70.8159, 146.9838, 42.6392>, <70.09367, 146.9385, 42.7659>, <70.5309, 146.8664, 42.5257> }
			triangle { <70.5309, 146.8664, 42.5257>, <71.2126, 146.2551, 42.2257>, <70.8159, 146.9838, 42.6392> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <73.07021, 143.7403, 40.9876>, <78.7449, 152.1631, 44.2591>, 0.3658 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <78.7449, 152.1631, 44.2591>, <79.497, 152.2054, 44.375>, 0.04489 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <79.497, 152.2054, 44.375>, <80.3943, 152.207, 44.463>, <80.395, 152.1677, 44.5281> }
			triangle { <80.3943, 152.207, 44.463>, <80.6132, 151.9128, 44.3653>, <80.395, 152.1677, 44.5281> }
			triangle { <80.3943, 152.207, 44.463>, <80.5802, 152.0006, 44.3266>, <80.6132, 151.9128, 44.3653> }
			triangle { <80.6132, 151.9128, 44.3653>, <80.5618, 151.9424, 44.4672>, <80.395, 152.1677, 44.5281> }
			triangle { <80.395, 152.1677, 44.5281>, <80.03901, 152.1246, 44.4787>, <79.497, 152.2054, 44.375> }
			triangle { <79.497, 152.2054, 44.375>, <80.05466, 152.1811, 44.3566>, <80.3943, 152.207, 44.463> }
			triangle { <80.05466, 152.1811, 44.3566>, <80.3981, 152.1604, 44.3448>, <80.3943, 152.207, 44.463> }
			triangle { <80.3981, 152.1604, 44.3448>, <80.5802, 152.0006, 44.3266>, <80.3943, 152.207, 44.463> }
			triangle { <80.395, 152.1677, 44.5281>, <80.5618, 151.9424, 44.4672>, <80.4021, 152.0396, 44.5287> }
			triangle { <80.4021, 152.0396, 44.5287>, <80.03901, 152.1246, 44.4787>, <80.395, 152.1677, 44.5281> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <78.7449, 152.1631, 44.2591>, <79.1786, 152.8068, 44.5091>, 0.02796 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <79.1786, 152.8068, 44.5091>, <79.1431, 152.9352, 44.5076>, 0.007849 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <79.1431, 152.9352, 44.5076>, <79.08961, 153.0835, 44.5073>, <79.09072, 153.0852, 44.4941> }
			triangle { <79.08961, 153.0835, 44.5073>, <79.02717, 153.0996, 44.4916>, <79.09072, 153.0852, 44.4941> }
			triangle { <79.08961, 153.0835, 44.5073>, <79.03707, 153.0964, 44.506>, <79.02717, 153.0996, 44.4916> }
			triangle { <79.02717, 153.0996, 44.4916>, <79.0443, 153.0981, 44.4802>, <79.09072, 153.0852, 44.4941> }
			triangle { <79.09072, 153.0852, 44.4941>, <79.105, 153.0236, 44.4916>, <79.1431, 152.9352, 44.5076> }
			triangle { <79.1431, 152.9352, 44.5076>, <79.09961, 153.0223, 44.5146>, <79.08961, 153.0835, 44.5073> }
			triangle { <79.09961, 153.0223, 44.5146>, <79.07202, 153.0757, 44.5184>, <79.08961, 153.0835, 44.5073> }
			triangle { <79.07202, 153.0757, 44.5184>, <79.03707, 153.0964, 44.506>, <79.08961, 153.0835, 44.5073> }
			triangle { <79.09072, 153.0852, 44.4941>, <79.0443, 153.0981, 44.4802>, <79.07378, 153.0803, 44.4803> }
			triangle { <79.07378, 153.0803, 44.4803>, <79.105, 153.0236, 44.4916>, <79.09072, 153.0852, 44.4941> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.8728, 11.3339, 1.07237>, <3.3407, 27.243, 1.1673>, 0.5478 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.3407, 27.243, 1.1673>, <-0.07849, 31.2193, -1.5336>, 0.3475 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-0.07849, 31.2193, -1.5336>, <-4.5312, 35.5785, -4.6756>, <-4.3286, 35.4796, -5.2196> }
			triangle { <-4.5312, 35.5785, -4.6756>, <-6.9854, 34.6793, -6.017>, <-4.3286, 35.4796, -5.2196> }
			triangle { <-4.5312, 35.5785, -4.6756>, <-6.7545, 34.9641, -5.322>, <-6.9854, 34.6793, -6.017> }
			triangle { <-6.9854, 34.6793, -6.017>, <-6.1367, 34.8147, -6.324>, <-4.3286, 35.4796, -5.2196> }
			triangle { <-4.3286, 35.4796, -5.2196>, <-2.746, 33.4724, -4.07127>, <-0.07849, 31.2193, -1.5336> }
			triangle { <-0.07849, 31.2193, -1.5336>, <-3.2647, 33.6353, -3.1746>, <-4.5312, 35.5785, -4.6756> }
			triangle { <-3.2647, 33.6353, -3.1746>, <-5.2454, 35.08942, -4.2075>, <-4.5312, 35.5785, -4.6756> }
			triangle { <-5.2454, 35.08942, -4.2075>, <-6.7545, 34.9641, -5.322>, <-4.5312, 35.5785, -4.6756> }
			triangle { <-4.3286, 35.4796, -5.2196>, <-6.1367, 34.8147, -6.324>, <-4.7101, 34.7633, -5.7912> }
			triangle { <-4.7101, 34.7633, -5.7912>, <-2.746, 33.4724, -4.07127>, <-4.3286, 35.4796, -5.2196> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <3.3407, 27.243, 1.1673>, <6.879, 43.992, 4.01131>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.879, 43.992, 4.01131>, <11.5268, 46.843, 10.06599>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <11.5268, 46.843, 10.06599>, <17.424, 49.5931, 17.1777>, <16.8944, 49.4421, 17.7763> }
			triangle { <17.424, 49.5931, 17.1777>, <19.5576, 46.9779, 19.4306>, <16.8944, 49.4421, 17.7763> }
			triangle { <17.424, 49.5931, 17.1777>, <19.6834, 47.6062, 18.5547>, <19.5576, 46.9779, 19.4306> }
			triangle { <19.5576, 46.9779, 19.4306>, <18.4145, 47.4865, 19.5852>, <16.8944, 49.4421, 17.7763> }
			triangle { <16.8944, 49.4421, 17.7763>, <14.6336, 47.8868, 15.04649>, <11.5268, 46.843, 10.06599> }
			triangle { <11.5268, 46.843, 10.06599>, <15.7378, 48.04776, 14.1231>, <17.424, 49.5931, 17.1777> }
			triangle { <15.7378, 48.04776, 14.1231>, <18.3313, 48.7326, 16.6447>, <17.424, 49.5931, 17.1777> }
			triangle { <18.3313, 48.7326, 16.6447>, <19.6834, 47.6062, 18.5547>, <17.424, 49.5931, 17.1777> }
			triangle { <16.8944, 49.4421, 17.7763>, <18.4145, 47.4865, 19.5852>, <16.8426, 48.2183, 18.3923> }
			triangle { <16.8426, 48.2183, 18.3923>, <14.6336, 47.8868, 15.04649>, <16.8944, 49.4421, 17.7763> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <6.879, 43.992, 4.01131>, <9.6839, 61.1118, 4.4379>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <9.6839, 61.1118, 4.4379>, <8.5676, 66.5251, -1.5485>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <8.5676, 66.5251, -1.5485>, <6.6949, 72.5004, -8.8771>, <7.3367, 72.2748, -9.323> }
			triangle { <6.6949, 72.5004, -8.8771>, <4.8585, 71.315, -12.2961>, <7.3367, 72.2748, -9.323> }
			triangle { <6.6949, 72.5004, -8.8771>, <4.613, 71.7758, -11.3446>, <4.8585, 71.315, -12.2961> }
			triangle { <4.8585, 71.315, -12.2961>, <6.07518, 71.3829, -11.9725>, <7.3367, 72.2748, -9.323> }
			triangle { <7.3367, 72.2748, -9.323>, <7.9086, 69.527, -6.6575>, <8.5676, 66.5251, -1.5485> }
			triangle { <8.5676, 66.5251, -1.5485>, <6.6431, 69.9157, -6.07011>, <6.6949, 72.5004, -8.8771> }
			triangle { <6.6431, 69.9157, -6.07011>, <5.4495, 71.9561, -8.8926>, <6.6949, 72.5004, -8.8771> }
			triangle { <5.4495, 71.9561, -8.8926>, <4.613, 71.7758, -11.3446>, <6.6949, 72.5004, -8.8771> }
			triangle { <7.3367, 72.2748, -9.323>, <6.07518, 71.3829, -11.9725>, <7.2509, 71.252, -10.2319> }
			triangle { <7.2509, 71.252, -10.2319>, <7.9086, 69.527, -6.6575>, <7.3367, 72.2748, -9.323> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <9.6839, 61.1118, 4.4379>, <9.9898, 63.0015, 5.07045>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <9.9898, 63.0015, 5.07045>, <10.2494, 64.6291, 6.2313>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <10.2494, 64.6291, 6.2313>, <10.4403, 65.8547, 7.8207>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <10.4403, 65.8547, 7.8207>, <10.5462, 66.5725, 9.7016>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <10.5462, 66.5725, 9.7016>, <11.1017, 67.5948, 11.348>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <11.1017, 67.5948, 11.348>, <12.4629, 69.5241, 13.6566>, 0.07103 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <12.4629, 69.5241, 13.6566>, <12.2538, 73.7279, 16.643>, <14.3557, 72.00075, 16.6747> }
					triangle { <14.3557, 72.00075, 16.6747>, <12.2538, 73.7279, 16.643>, <13.7666, 76.799, 19.5605> }
					triangle { <14.3557, 72.00075, 16.6747>, <13.7666, 76.799, 19.5605>, <16.4434, 74.8557, 19.6062> }
					triangle { <13.7666, 76.799, 19.5605>, <18.3631, 78.08955, 21.8032>, <16.4434, 74.8557, 19.6062> }
					triangle { <14.3557, 72.00075, 16.6747>, <16.7704, 71.2638, 16.03907>, <12.4629, 69.5241, 13.6566> }
					triangle { <16.7704, 71.2638, 16.03907>, <14.3557, 72.00075, 16.6747>, <16.4434, 74.8557, 19.6062> }
					triangle { <19.0823, 74.09235, 18.6883>, <16.7704, 71.2638, 16.03907>, <16.4434, 74.8557, 19.6062> }
					triangle { <19.0823, 74.09235, 18.6883>, <16.4434, 74.8557, 19.6062>, <18.3631, 78.08955, 21.8032> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <12.4629, 69.5241, 13.6566>, <14.27, 70.1417, 18.451>, <14.2266, 72.1552, 16.6217> }
					triangle { <14.2266, 72.1552, 16.6217>, <14.27, 70.1417, 18.451>, <15.8824, 72.3897, 21.9978> }
					triangle { <14.2266, 72.1552, 16.6217>, <15.8824, 72.3897, 21.9978>, <15.7683, 74.9594, 19.9176> }
					triangle { <15.8824, 72.3897, 21.9978>, <16.5666, 77.423, 23.4194>, <15.7683, 74.9594, 19.9176> }
					triangle { <14.2266, 72.1552, 16.6217>, <13.2356, 74.3203, 15.569>, <12.4629, 69.5241, 13.6566> }
					triangle { <13.2356, 74.3203, 15.569>, <14.2266, 72.1552, 16.6217>, <15.7683, 74.9594, 19.9176> }
					triangle { <14.4654, 77.2701, 18.7548>, <13.2356, 74.3203, 15.569>, <15.7683, 74.9594, 19.9176> }
					triangle { <14.4654, 77.2701, 18.7548>, <15.7683, 74.9594, 19.9176>, <16.5666, 77.423, 23.4194> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <12.4629, 69.5241, 13.6566>, <16.3481, 72.5383, 15.223>, <14.1712, 72.01736, 16.7696> }
					triangle { <14.1712, 72.01736, 16.7696>, <16.3481, 72.5383, 15.223>, <18.7305, 75.0386, 18.1049> }
					triangle { <14.1712, 72.01736, 16.7696>, <18.7305, 75.0386, 18.1049>, <16.2058, 74.3845, 20.14> }
					triangle { <18.7305, 75.0386, 18.1049>, <18.7046, 76.0886, 23.274>, <16.2058, 74.3845, 20.14> }
					triangle { <14.1712, 72.01736, 16.7696>, <12.93, 70.7887, 18.7004>, <12.4629, 69.5241, 13.6566> }
					triangle { <12.93, 70.7887, 18.7004>, <14.1712, 72.01736, 16.7696>, <16.2058, 74.3845, 20.14> }
					triangle { <14.9074, 72.8264, 22.2077>, <12.93, 70.7887, 18.7004>, <16.2058, 74.3845, 20.14> }
					triangle { <14.9074, 72.8264, 22.2077>, <16.2058, 74.3845, 20.14>, <18.7046, 76.0886, 23.274> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <11.1017, 67.5948, 11.348>, <11.07097, 68.6702, 13.05309>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <11.07097, 68.6702, 13.05309>, <10.3775, 70.4051, 15.7759>, 0.07103 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <10.3775, 70.4051, 15.7759>, <10.09043, 70.7011, 20.9202>, <9.4111, 72.7667, 19.285> }
					triangle { <9.4111, 72.7667, 19.285>, <10.09043, 70.7011, 20.9202>, <9.06538, 72.5304, 24.8995> }
					triangle { <9.4111, 72.7667, 19.285>, <9.06538, 72.5304, 24.8995>, <8.08269, 75.07513, 23.028> }
					triangle { <9.06538, 72.5304, 24.8995>, <6.3184, 76.6675, 26.6778>, <8.08269, 75.07513, 23.028> }
					triangle { <9.4111, 72.7667, 19.285>, <7.6986, 74.2762, 18.03325>, <10.3775, 70.4051, 15.7759> }
					triangle { <7.6986, 74.2762, 18.03325>, <9.4111, 72.7667, 19.285>, <8.08269, 75.07513, 23.028> }
					triangle { <6.07657, 76.5676, 21.5661>, <7.6986, 74.2762, 18.03325>, <8.08269, 75.07513, 23.028> }
					triangle { <6.07657, 76.5676, 21.5661>, <8.08269, 75.07513, 23.028>, <6.3184, 76.6675, 26.6778> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <10.3775, 70.4051, 15.7759>, <11.2607, 74.4892, 18.8047>, <9.4038, 72.5904, 19.3954> }
					triangle { <9.4038, 72.5904, 19.3954>, <11.2607, 74.4892, 18.8047>, <10.875, 77.07529, 22.4647> }
					triangle { <9.4038, 72.5904, 19.3954>, <10.875, 77.07529, 22.4647>, <8.6782, 74.774, 23.3715> }
					triangle { <10.875, 77.07529, 22.4647>, <8.7519, 76.6974, 27.2785>, <8.6782, 74.774, 23.3715> }
					triangle { <9.4038, 72.5904, 19.3954>, <8.555, 70.4836, 20.6677>, <10.3775, 70.4051, 15.7759> }
					triangle { <8.555, 70.4836, 20.6677>, <9.4038, 72.5904, 19.3954>, <8.6782, 74.774, 23.3715> }
					triangle { <7.9281, 72.332, 24.7363>, <8.555, 70.4836, 20.6677>, <8.6782, 74.774, 23.3715> }
					triangle { <7.9281, 72.332, 24.7363>, <8.6782, 74.774, 23.3715>, <8.7519, 76.6974, 27.2785> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <10.3775, 70.4051, 15.7759>, <6.9825, 73.02134, 18.6504>, <9.5845, 72.6948, 19.375> }
					triangle { <9.5845, 72.6948, 19.375>, <6.9825, 73.02134, 18.6504>, <5.5837, 75.624, 22.04184> }
					triangle { <9.5845, 72.6948, 19.375>, <5.5837, 75.624, 22.04184>, <8.7492, 75.4168, 22.98> }
					triangle { <5.5837, 75.624, 22.04184>, <7.771, 78.5379, 25.8561>, <8.7492, 75.4168, 22.98> }
					triangle { <9.5845, 72.6948, 19.375>, <12.04598, 73.5026, 19.6332>, <10.3775, 70.4051, 15.7759> }
					triangle { <12.04598, 73.5026, 19.6332>, <9.5845, 72.6948, 19.375>, <8.7492, 75.4168, 22.98> }
					triangle { <11.477, 76.3875, 23.05628>, <12.04598, 73.5026, 19.6332>, <8.7492, 75.4168, 22.98> }
					triangle { <11.477, 76.3875, 23.05628>, <8.7492, 75.4168, 22.98>, <7.771, 78.5379, 25.8561> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <11.07097, 68.6702, 13.05309>, <11.4659, 69.3619, 14.9051>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <11.4659, 69.3619, 14.9051>, <12.5502, 70.01804, 17.9544>, 0.07103 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <12.5502, 70.01804, 17.9544>, <15.2662, 72.9994, 21.1743>, <13.9407, 70.7697, 21.995> }
					triangle { <13.9407, 70.7697, 21.995>, <15.2662, 72.9994, 21.1743>, <17.191, 74.1965, 25.05956> }
					triangle { <13.9407, 70.7697, 21.995>, <17.191, 74.1965, 25.05956>, <15.7363, 71.4406, 26.1698> }
					triangle { <17.191, 74.1965, 25.05956>, <18.1327, 72.0025, 29.763>, <15.7363, 71.4406, 26.1698> }
					triangle { <13.9407, 70.7697, 21.995>, <13.8148, 68.269, 22.7083>, <12.5502, 70.01804, 17.9544> }
					triangle { <13.8148, 68.269, 22.7083>, <13.9407, 70.7697, 21.995>, <15.7363, 71.4406, 26.1698> }
					triangle { <15.7206, 68.6102, 26.7844>, <13.8148, 68.269, 22.7083>, <15.7363, 71.4406, 26.1698> }
					triangle { <15.7206, 68.6102, 26.7844>, <15.7363, 71.4406, 26.1698>, <18.1327, 72.0025, 29.763> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <12.5502, 70.01804, 17.9544>, <11.558, 71.1328, 22.8946>, <14.08567, 70.8966, 21.9161> }
					triangle { <14.08567, 70.8966, 21.9161>, <11.558, 71.1328, 22.8946>, <12.5044, 72.3014, 27.1339> }
					triangle { <14.08567, 70.8966, 21.9161>, <12.5044, 72.3014, 27.1339>, <15.6276, 72.1737, 26.05077> }
					triangle { <12.5044, 72.3014, 27.1339>, <16.6832, 74.04629, 29.8387>, <15.6276, 72.1737, 26.05077> }
					triangle { <14.08567, 70.8966, 21.9161>, <16.3392, 71.86, 21.03795>, <12.5502, 70.01804, 17.9544> }
					triangle { <16.3392, 71.86, 21.03795>, <14.08567, 70.8966, 21.9161>, <15.6276, 72.1737, 26.05077> }
					triangle { <18.01564, 73.3806, 24.9418>, <16.3392, 71.86, 21.03795>, <15.6276, 72.1737, 26.05077> }
					triangle { <18.01564, 73.3806, 24.9418>, <15.6276, 72.1737, 26.05077>, <16.6832, 74.04629, 29.8387> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <12.5502, 70.01804, 17.9544>, <15.2356, 68.6085, 22.13>, <13.8965, 70.9712, 21.9673> }
					triangle { <13.8965, 70.9712, 21.9673>, <15.2356, 68.6085, 22.13>, <16.7622, 68.9043, 26.3507> }
					triangle { <13.8965, 70.9712, 21.9673>, <16.7622, 68.9043, 26.3507>, <15.07317, 71.7486, 26.3393> }
					triangle { <16.7622, 68.9043, 26.3507>, <15.7893, 71.8236, 30.6348>, <15.07317, 71.7486, 26.3393> }
					triangle { <13.8965, 70.9712, 21.9673>, <11.8852, 72.5445, 22.4745>, <12.5502, 70.01804, 17.9544> }
					triangle { <11.8852, 72.5445, 22.4745>, <13.8965, 70.9712, 21.9673>, <15.07317, 71.7486, 26.3393> }
					triangle { <12.7005, 73.3319, 26.8424>, <11.8852, 72.5445, 22.4745>, <15.07317, 71.7486, 26.3393> }
					triangle { <12.7005, 73.3319, 26.8424>, <15.07317, 71.7486, 26.3393>, <15.7893, 71.8236, 30.6348> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <9.6839, 61.1118, 4.4379>, <10.3879, 62.9615, 4.05438>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <10.3879, 62.9615, 4.05438>, <11.00968, 64.6502, 3.1453>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <11.00968, 64.6502, 3.1453>, <11.4201, 67.6166, 1.7536>, 0.07103 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <11.4201, 67.6166, 1.7536>, <13.3317, 72.4062, 1.9496>, <11.8746, 71.486, -0.1556> }
					triangle { <11.8746, 71.486, -0.1556>, <13.3317, 72.4062, 1.9496>, <13.9717, 76.6538, 0.6153> }
					triangle { <11.8746, 71.486, -0.1556>, <13.9717, 76.6538, 0.6153>, <12.106, 75.7095, -1.948> }
					triangle { <13.9717, 76.6538, 0.6153>, <11.9559, 79.9362, -2.9882>, <12.106, 75.7095, -1.948> }
					triangle { <11.8746, 71.486, -0.1556>, <9.6888, 71.2671, -1.5529>, <11.4201, 67.6166, 1.7536> }
					triangle { <9.6888, 71.2671, -1.5529>, <11.8746, 71.486, -0.1556>, <12.106, 75.7095, -1.948> }
					triangle { <9.5671, 75.421, -3.3117>, <9.6888, 71.2671, -1.5529>, <12.106, 75.7095, -1.948> }
					triangle { <9.5671, 75.421, -3.3117>, <12.106, 75.7095, -1.948>, <11.9559, 79.9362, -2.9882> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <11.4201, 67.6166, 1.7536>, <13.2147, 70.5115, -2.1235>, <11.9277, 71.5655, 0.02932> }
					triangle { <11.9277, 71.5655, 0.02932>, <13.2147, 70.5115, -2.1235>, <14.2412, 74.3053, -4.3111> }
					triangle { <11.9277, 71.5655, 0.02932>, <14.2412, 74.3053, -4.3111>, <12.811, 75.7322, -1.6915> }
					triangle { <14.2412, 74.3053, -4.3111>, <14.4044, 79.4711, -3.2572>, <12.811, 75.7322, -1.6915> }
					triangle { <11.9277, 71.5655, 0.02932>, <11.855, 72.7876, 2.3269>, <11.4201, 67.6166, 1.7536> }
					triangle { <11.855, 72.7876, 2.3269>, <11.9277, 71.5655, 0.02932>, <12.811, 75.7322, -1.6915> }
					triangle { <12.8907, 76.9529, 0.9338>, <11.855, 72.7876, 2.3269>, <12.811, 75.7322, -1.6915> }
					triangle { <12.8907, 76.9529, 0.9338>, <12.811, 75.7322, -1.6915>, <14.4044, 79.4711, -3.2572> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <11.4201, 67.6166, 1.7536>, <9.3957, 71.9558, -0.1715>, <12.07449, 71.4857, -0.09737> }
					triangle { <12.07449, 71.4857, -0.09737>, <9.3957, 71.9558, -0.1715>, <9.3929, 75.9303, -2.2775> }
					triangle { <12.07449, 71.4857, -0.09737>, <9.3929, 75.9303, -2.2775>, <12.6623, 75.4344, -2.3702> }
					triangle { <9.3929, 75.9303, -2.2775>, <12.782, 78.8382, -5.08488>, <12.6623, 75.4344, -2.3702> }
					triangle { <12.07449, 71.4857, -0.09737>, <14.3466, 70.8025, -1.1691>, <11.4201, 67.6166, 1.7536> }
					triangle { <14.3466, 70.8025, -1.1691>, <12.07449, 71.4857, -0.09737>, <12.6623, 75.4344, -2.3702> }
					triangle { <15.08544, 74.4981, -3.6511>, <14.3466, 70.8025, -1.1691>, <12.6623, 75.4344, -2.3702> }
					triangle { <15.08544, 74.4981, -3.6511>, <12.6623, 75.4344, -2.3702>, <12.782, 78.8382, -5.08488> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <10.3879, 62.9615, 4.05438>, <11.1208, 64.8318, 4.2253>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <11.1208, 64.8318, 4.2253>, <12.8964, 67.6089, 4.426>, 0.07103 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <12.8964, 67.6089, 4.426>, <14.4944, 72.04006, 2.3178>, <15.2862, 71.2122, 4.7855> }
					triangle { <15.2862, 71.2122, 4.7855>, <14.4944, 72.04006, 2.3178>, <16.9099, 75.8201, 1.9873> }
					triangle { <15.2862, 71.2122, 4.7855>, <16.9099, 75.8201, 1.9873>, <18.05606, 74.8738, 4.9427> }
					triangle { <16.9099, 75.8201, 1.9873>, <21.01644, 78.03055, 4.4518>, <18.05606, 74.8738, 4.9427> }
					triangle { <15.2862, 71.2122, 4.7855>, <16.9843, 70.1497, 6.4486>, <12.8964, 67.6089, 4.426> }
					triangle { <16.9843, 70.1497, 6.4486>, <15.2862, 71.2122, 4.7855>, <18.05606, 74.8738, 4.9427> }
					triangle { <19.972, 73.5257, 6.6459>, <16.9843, 70.1497, 6.4486>, <18.05606, 74.8738, 4.9427> }
					triangle { <19.972, 73.5257, 6.6459>, <18.05606, 74.8738, 4.9427>, <21.01644, 78.03055, 4.4518> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <12.8964, 67.6089, 4.426>, <13.91, 72.09187, 6.7731>, <15.2724, 71.236, 4.5792> }
					triangle { <15.2724, 71.236, 4.5792>, <13.91, 72.09187, 6.7731>, <15.8558, 76.1072, 7.3413> }
					triangle { <15.2724, 71.236, 4.5792>, <15.8558, 76.1072, 7.3413>, <17.5034, 75.2516, 4.6032> }
					triangle { <15.8558, 76.1072, 7.3413>, <18.9029, 79.3756, 4.5383>, <17.5034, 75.2516, 4.6032> }
					triangle { <15.2724, 71.236, 4.5792>, <15.8052, 71.2227, 2.03088>, <12.8964, 67.6089, 4.426> }
					triangle { <15.8052, 71.2227, 2.03088>, <15.2724, 71.236, 4.5792>, <17.5034, 75.2516, 4.6032> }
					triangle { <17.8765, 75.2205, 1.7311>, <15.8052, 71.2227, 2.03088>, <17.5034, 75.2516, 4.6032> }
					triangle { <17.8765, 75.2205, 1.7311>, <17.5034, 75.2516, 4.6032>, <18.9029, 79.3756, 4.5383> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <12.8964, 67.6089, 4.426>, <17.4636, 69.9503, 4.9657>, <15.1272, 71.3197, 4.705> }
					triangle { <15.1272, 71.3197, 4.705>, <17.4636, 69.9503, 4.9657>, <20.2927, 73.4012, 5.5319> }
					triangle { <15.1272, 71.3197, 4.705>, <20.2927, 73.4012, 5.5319>, <17.5153, 75.1896, 5.3565> }
					triangle { <20.2927, 73.4012, 5.5319>, <19.9668, 78.5413, 6.6702>, <17.5153, 75.1896, 5.3565> }
					triangle { <15.1272, 71.3197, 4.705>, <13.1139, 72.683, 5.6358>, <12.8964, 67.6089, 4.426> }
					triangle { <13.1139, 72.683, 5.6358>, <15.1272, 71.3197, 4.705>, <17.5153, 75.1896, 5.3565> }
					triangle { <15.2534, 76.5496, 6.5496>, <13.1139, 72.683, 5.6358>, <17.5153, 75.1896, 5.3565> }
					triangle { <15.2534, 76.5496, 6.5496>, <17.5153, 75.1896, 5.3565>, <19.9668, 78.5413, 6.6702> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <10.3879, 62.9615, 4.05438>, <10.5192, 64.947, 3.7303>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <10.5192, 64.947, 3.7303>, <10.3187, 66.9494, 3.8518>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <10.3187, 66.9494, 3.8518>, <10.542, 70.2002, 4.3879>, 0.07103 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <10.542, 70.2002, 4.3879>, <11.5347, 74.9499, 2.6307>, <10.8311, 74.4503, 5.2109> }
					triangle { <10.8311, 74.4503, 5.2109>, <11.5347, 74.9499, 2.6307>, <12.2138, 79.389, 2.8879> }
					triangle { <10.8311, 74.4503, 5.2109>, <12.2138, 79.389, 2.8879>, <11.4967, 78.9114, 6.08193> }
					triangle { <12.2138, 79.389, 2.8879>, <12.8673, 83.003, 6.6741>, <11.4967, 78.9114, 6.08193> }
					triangle { <10.8311, 74.4503, 5.2109>, <11.3492, 74.1198, 7.7408>, <10.542, 70.2002, 4.3879> }
					triangle { <11.3492, 74.1198, 7.7408>, <10.8311, 74.4503, 5.2109>, <11.4967, 78.9114, 6.08193> }
					triangle { <12.2383, 78.4063, 8.8358>, <11.3492, 74.1198, 7.7408>, <11.4967, 78.9114, 6.08193> }
					triangle { <12.2383, 78.4063, 8.8358>, <11.4967, 78.9114, 6.08193>, <12.8673, 83.003, 6.6741> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <10.542, 70.2002, 4.3879>, <8.3268, 74.6536, 5.7637>, <10.942, 74.4715, 5.03612> }
					triangle { <10.942, 74.4715, 5.03612>, <8.3268, 74.6536, 5.7637>, <8.03537, 79.09734, 6.397> }
					triangle { <10.942, 74.4715, 5.03612>, <8.03537, 79.09734, 6.397>, <11.1919, 79.04344, 5.4088> }
					triangle { <8.03537, 79.09734, 6.397>, <10.8714, 83.3823, 5.2058>, <11.1919, 79.04344, 5.4088> }
					triangle { <10.942, 74.4715, 5.03612>, <12.9124, 74.7358, 3.355>, <10.542, 70.2002, 4.3879> }
					triangle { <12.9124, 74.7358, 3.355>, <10.942, 74.4715, 5.03612>, <11.1919, 79.04344, 5.4088> }
					triangle { <13.2565, 79.2351, 3.3865>, <12.9124, 74.7358, 3.355>, <11.1919, 79.04344, 5.4088> }
					triangle { <13.2565, 79.2351, 3.3865>, <11.1919, 79.04344, 5.4088>, <10.8714, 83.3823, 5.2058> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <10.542, 70.2002, 4.3879>, <12.6789, 74.1663, 6.9052>, <10.733, 74.4867, 5.031> }
					triangle { <10.733, 74.4867, 5.031>, <12.6789, 74.1663, 6.9052>, <13.201, 78.4484, 8.1794> }
					triangle { <10.733, 74.4867, 5.031>, <13.201, 78.4484, 8.1794>, <10.7513, 78.973, 6.01901> }
					triangle { <13.201, 78.4484, 8.1794>, <10.5723, 82.9944, 7.6823>, <10.7513, 78.973, 6.01901> }
					triangle { <10.733, 74.4867, 5.031>, <8.2762, 74.9024, 4.2764>, <10.542, 70.2002, 4.3879> }
					triangle { <8.2762, 74.9024, 4.2764>, <10.733, 74.4867, 5.031>, <10.7513, 78.973, 6.01901> }
					triangle { <7.9557, 79.2793, 5.3265>, <8.2762, 74.9024, 4.2764>, <10.7513, 78.973, 6.01901> }
					triangle { <7.9557, 79.2793, 5.3265>, <10.7513, 78.973, 6.01901>, <10.5723, 82.9944, 7.6823> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <10.5192, 64.947, 3.7303>, <10.9724, 66.7648, 2.9854>, 0.07103 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <10.9724, 66.7648, 2.9854>, <11.1567, 69.6789, 1.4432>, 0.07103 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <11.1567, 69.6789, 1.4432>, <10.8185, 74.8266, 1.5851>, <11.3981, 73.45, -0.6888> }
					triangle { <11.3981, 73.45, -0.6888>, <10.8185, 74.8266, 1.5851>, <10.7092, 79.00442, -0.07826> }
					triangle { <11.3981, 73.45, -0.6888>, <10.7092, 79.00442, -0.07826>, <11.2921, 77.4525, -2.941> }
					triangle { <10.7092, 79.00442, -0.07826>, <10.4456, 81.2862, -4.8266>, <11.2921, 77.4525, -2.941> }
					triangle { <11.3981, 73.45, -0.6888>, <10.789, 72.4049, -2.9942>, <11.1567, 69.6789, 1.4432> }
					triangle { <10.789, 72.4049, -2.9942>, <11.3981, 73.45, -0.6888>, <11.2921, 77.4525, -2.941> }
					triangle { <10.4343, 76.201, -5.4082>, <10.789, 72.4049, -2.9942>, <11.2921, 77.4525, -2.941> }
					triangle { <10.4343, 76.201, -5.4082>, <11.2921, 77.4525, -2.941>, <10.4456, 81.2862, -4.8266> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <11.1567, 69.6789, 1.4432>, <13.8956, 73.1448, -1.2249>, <11.2945, 73.5395, -0.532> }
					triangle { <11.2945, 73.5395, -0.532>, <13.8956, 73.1448, -1.2249>, <14.7414, 77.0834, -3.2261> }
					triangle { <11.2945, 73.5395, -0.532>, <14.7414, 77.0834, -3.2261>, <11.6253, 77.7505, -2.338> }
					triangle { <14.7414, 77.0834, -3.2261>, <12.504, 81.8515, -3.5124>, <11.6253, 77.7505, -2.338> }
					triangle { <11.2945, 73.5395, -0.532>, <9.4099, 74.5728, 0.9372>, <11.1567, 69.6789, 1.4432> }
					triangle { <9.4099, 74.5728, 0.9372>, <11.2945, 73.5395, -0.532>, <11.6253, 77.7505, -2.338> }
					triangle { <9.6452, 78.8357, -0.5241>, <9.4099, 74.5728, 0.9372>, <11.6253, 77.7505, -2.338> }
					triangle { <9.6452, 78.8357, -0.5241>, <11.6253, 77.7505, -2.338>, <12.504, 81.8515, -3.5124> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <11.1567, 69.6789, 1.4432>, <9.494, 72.8837, -2.2443>, <11.5038, 73.5286, -0.5276> }
					triangle { <11.5038, 73.5286, -0.5276>, <9.494, 72.8837, -2.2443>, <9.4989, 76.5719, -4.8192> }
					triangle { <11.5038, 73.5286, -0.5276>, <9.4989, 76.5719, -4.8192>, <12.04043, 77.4346, -2.8852> }
					triangle { <9.4989, 76.5719, -4.8192>, <12.699, 80.6646, -5.7319>, <12.04043, 77.4346, -2.8852> }
					triangle { <11.5038, 73.5286, -0.5276>, <14.00892, 73.843, 0.1077>, <11.1567, 69.6789, 1.4432> }
					triangle { <14.00892, 73.843, 0.1077>, <11.5038, 73.5286, -0.5276>, <12.04043, 77.4346, -2.8852> }
					triangle { <14.8661, 77.5831, -2.2669>, <14.00892, 73.843, 0.1077>, <12.04043, 77.4346, -2.8852> }
					triangle { <14.8661, 77.5831, -2.2669>, <12.04043, 77.4346, -2.8852>, <12.699, 80.6646, -5.7319> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		}
	union { // internode
		cylinder { <-0.2356, 3.145, 0.04992>, <-0.4349, 6.3668, 0.01032>, 0.1106 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.4349, 6.3668, 0.01032>, <-0.9745, 6.8738, -0.371>, 0.04906 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-0.9745, 6.8738, -0.371>, <-1.6634, 7.4172, -0.819>, <-1.6301, 7.4106, -0.8949> }
			triangle { <-1.6634, 7.4172, -0.819>, <-1.9814, 7.2529, -1.0286>, <-1.6301, 7.4106, -0.8949> }
			triangle { <-1.6634, 7.4172, -0.819>, <-1.9586, 7.2929, -0.9276>, <-1.9814, 7.2529, -1.0286> }
			triangle { <-1.9814, 7.2529, -1.0286>, <-1.8637, 7.29, -1.06573>, <-1.6301, 7.4106, -0.8949> }
			triangle { <-1.6301, 7.4106, -0.8949>, <-1.3766, 7.1533, -0.7337>, <-0.9745, 6.8738, -0.371> }
			triangle { <-0.9745, 6.8738, -0.371>, <-1.4572, 7.1606, -0.6097>, <-1.6634, 7.4172, -0.819> }
			triangle { <-1.4572, 7.1606, -0.6097>, <-1.7563, 7.3323, -0.7602>, <-1.6634, 7.4172, -0.819> }
			triangle { <-1.7563, 7.3323, -0.7602>, <-1.9586, 7.2929, -0.9276>, <-1.6634, 7.4172, -0.819> }
			triangle { <-1.6301, 7.4106, -0.8949>, <-1.8637, 7.29, -1.06573>, <-1.6664, 7.3067, -0.9817> }
			triangle { <-1.6664, 7.3067, -0.9817>, <-1.3766, 7.1533, -0.7337>, <-1.6301, 7.4106, -0.8949> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.4349, 6.3668, 0.01032>, <-0.9805, 10.2129, -0.264>, 0.1335 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.9805, 10.2129, -0.264>, <-1.4206, 10.549, -0.5776>, 0.03748 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-1.4206, 10.549, -0.5776>, <-1.9763, 10.9008, -0.9437>, <-1.9503, 10.8944, -1.001361> }
			triangle { <-1.9763, 10.9008, -0.9437>, <-2.2079, 10.7474, -1.09634>, <-1.9503, 10.8944, -1.001361> }
			triangle { <-1.9763, 10.9008, -0.9437>, <-2.1932, 10.7836, -1.02112>, <-2.2079, 10.7474, -1.09634> }
			triangle { <-2.2079, 10.7474, -1.09634>, <-2.1203, 10.781, -1.1262>, <-1.9503, 10.8944, -1.001361> }
			triangle { <-1.9503, 10.8944, -1.001361>, <-1.7423, 10.7212, -0.8668>, <-1.4206, 10.549, -0.5776> }
			triangle { <-1.4206, 10.549, -0.5776>, <-1.8046, 10.7274, -0.7726>, <-1.9763, 10.9008, -0.9437> }
			triangle { <-1.8046, 10.7274, -0.7726>, <-2.04228, 10.8333, -0.8951>, <-1.9763, 10.9008, -0.9437> }
			triangle { <-2.04228, 10.8333, -0.8951>, <-2.1932, 10.7836, -1.02112>, <-1.9763, 10.9008, -0.9437> }
			triangle { <-1.9503, 10.8944, -1.001361>, <-2.1203, 10.781, -1.1262>, <-1.9713, 10.8094, -1.06295> }
			triangle { <-1.9713, 10.8094, -1.06295>, <-1.7423, 10.7212, -0.8668>, <-1.9503, 10.8944, -1.001361> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.4349, 6.3668, 0.01032>, <-0.5633, 13.0313, 0.3294>, 0.2288 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.5633, 13.0313, 0.3294>, <0.03829, 13.8776, 1.2427>, 0.08146 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <0.03829, 13.8776, 1.2427>, <0.8386, 14.7908, 2.3391>, <0.7494, 14.768, 2.442> }
			triangle { <0.8386, 14.7908, 2.3391>, <1.2587, 14.5255, 2.816>, <0.7494, 14.768, 2.442> }
			triangle { <0.8386, 14.7908, 2.3391>, <1.2673, 14.6009, 2.6481>, <1.2587, 14.5255, 2.816> }
			triangle { <1.2587, 14.5255, 2.816>, <1.04972, 14.5713, 2.8189>, <0.7494, 14.768, 2.442> }
			triangle { <0.7494, 14.768, 2.442>, <0.4603, 14.3367, 2.03966>, <0.03829, 13.8776, 1.2427> }
			triangle { <0.03829, 13.8776, 1.2427>, <0.6479, 14.3707, 1.8845>, <0.8386, 14.7908, 2.3391> }
			triangle { <0.6479, 14.3707, 1.8845>, <1.02514, 14.666, 2.2856>, <0.8386, 14.7908, 2.3391> }
			triangle { <1.02514, 14.666, 2.2856>, <1.2673, 14.6009, 2.6481>, <0.8386, 14.7908, 2.3391> }
			triangle { <0.7494, 14.768, 2.442>, <1.04972, 14.5713, 2.8189>, <0.7769, 14.5898, 2.589> }
			triangle { <0.7769, 14.5898, 2.589>, <0.4603, 14.3367, 2.03966>, <0.7494, 14.768, 2.442> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.5633, 13.0313, 0.3294>, <-1.6329, 23.01333, -2.05923>, 0.3538 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.6329, 23.01333, -2.05923>, <-2.4839, 24.2154, -4.7066>, 0.1784 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-2.4839, 24.2154, -4.7066>, <-3.6383, 25.4091, -7.8827>, <-3.3778, 25.3583, -8.02775> }
			triangle { <-3.6383, 25.4091, -7.8827>, <-4.1069, 24.4952, -8.9878>, <-3.3778, 25.3583, -8.02775> }
			triangle { <-3.6383, 25.4091, -7.8827>, <-4.2598, 24.715, -8.686>, <-4.1069, 24.4952, -8.9878> }
			triangle { <-4.1069, 24.4952, -8.9878>, <-3.6862, 24.6762, -8.888>, <-3.3778, 25.3583, -8.02775> }
			triangle { <-3.3778, 25.3583, -8.02775>, <-2.9372, 24.7145, -6.8183>, <-2.4839, 24.2154, -4.7066> }
			triangle { <-2.4839, 24.2154, -4.7066>, <-3.4395, 24.7689, -6.6321>, <-3.6383, 25.4091, -7.8827> }
			triangle { <-3.4395, 24.7689, -6.6321>, <-4.02541, 25.08906, -7.8272>, <-3.6383, 25.4091, -7.8827> }
			triangle { <-4.02541, 25.08906, -7.8272>, <-4.2598, 24.715, -8.686>, <-3.6383, 25.4091, -7.8827> }
			triangle { <-3.3778, 25.3583, -8.02775>, <-3.6862, 24.6762, -8.888>, <-3.2854, 24.9136, -8.2593> }
			triangle { <-3.2854, 24.9136, -8.2593>, <-2.9372, 24.7145, -6.8183>, <-3.3778, 25.3583, -8.02775> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-1.6329, 23.01333, -2.05923>, <-3.4339, 39.713, -5.194>, 0.5858 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.4339, 39.713, -5.194>, <-4.1812, 45.8815, -0.2263>, 0.4686 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-4.1812, 45.8815, -0.2263>, <-4.7023, 52.7914, 6.1421>, <-5.4659, 52.6674, 6.3217> }
			triangle { <-4.7023, 52.7914, 6.1421>, <-4.4482, 52.1663, 10.04623>, <-5.4659, 52.6674, 6.3217> }
			triangle { <-4.7023, 52.7914, 6.1421>, <-3.8285, 52.444, 9.2328>, <-4.4482, 52.1663, 10.04623> }
			triangle { <-4.4482, 52.1663, 10.04623>, <-5.4113, 52.2133, 9.2811>, <-5.4659, 52.6674, 6.3217> }
			triangle { <-5.4659, 52.6674, 6.3217>, <-5.2313, 49.5985, 4.1287>, <-4.1812, 45.8815, -0.2263> }
			triangle { <-4.1812, 45.8815, -0.2263>, <-3.8404, 49.8376, 4.0411>, <-4.7023, 52.7914, 6.1421> }
			triangle { <-3.8404, 49.8376, 4.0411>, <-3.6416, 52.2341, 6.7127>, <-4.7023, 52.7914, 6.1421> }
			triangle { <-3.6416, 52.2341, 6.7127>, <-3.8285, 52.444, 9.2328>, <-4.7023, 52.7914, 6.1421> }
			triangle { <-5.4659, 52.6674, 6.3217>, <-5.4113, 52.2133, 9.2811>, <-5.8243, 51.8323, 7.3046> }
			triangle { <-5.8243, 51.8323, 7.3046>, <-5.2313, 49.5985, 4.1287>, <-5.4659, 52.6674, 6.3217> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-3.4339, 39.713, -5.194>, <-4.6703, 56.3581, -9.9429>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.6703, 56.3581, -9.9429>, <-2.7131, 59.4919, -17.2049>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-2.7131, 59.4919, -17.2049>, <-0.5899, 62.5495, -26.09666>, <0.2162, 62.4952, -26.00358> }
			triangle { <-0.5899, 62.5495, -26.09666>, <0.3532, 60.03972, -29.1426>, <0.2162, 62.4952, -26.00358> }
			triangle { <-0.5899, 62.5495, -26.09666>, <-0.5078, 60.5666, -28.7442>, <0.3532, 60.03972, -29.1426> }
			triangle { <0.3532, 60.03972, -29.1426>, <1.06557, 60.6359, -28.2902>, <0.2162, 62.4952, -26.00358> }
			triangle { <0.2162, 62.4952, -26.00358>, <-0.54, 60.8253, -22.5945>, <-2.7131, 59.4919, -17.2049> }
			triangle { <-2.7131, 59.4919, -17.2049>, <-1.9376, 60.8186, -22.9741>, <-0.5899, 62.5495, -26.09666> }
			triangle { <-1.9376, 60.8186, -22.9741>, <-1.4345, 61.5813, -26.5405>, <-0.5899, 62.5495, -26.09666> }
			triangle { <-1.4345, 61.5813, -26.5405>, <-0.5078, 60.5666, -28.7442>, <-0.5899, 62.5495, -26.09666> }
			triangle { <0.2162, 62.4952, -26.00358>, <1.06557, 60.6359, -28.2902>, <0.8954, 61.346, -26.3163> }
			triangle { <0.8954, 61.346, -26.3163>, <-0.54, 60.8253, -22.5945>, <0.2162, 62.4952, -26.00358> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-4.6703, 56.3581, -9.9429>, <-6.9671, 73.2127, -13.3757>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.9671, 73.2127, -13.3757>, <-11.5369, 78.7086, -9.464>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-11.5369, 78.7086, -9.464>, <-16.8305, 84.8206, -4.2161>, <-17.5476, 84.5537, -4.4919> }
			triangle { <-16.8305, 84.8206, -4.2161>, <-18.6343, 83.773, -0.7354>, <-17.5476, 84.5537, -4.4919> }
			triangle { <-16.8305, 84.8206, -4.2161>, <-17.7209, 84.2461, -1.08162>, <-18.6343, 83.773, -0.7354> }
			triangle { <-18.6343, 83.773, -0.7354>, <-19.03524, 83.7576, -1.9305>, <-17.5476, 84.5537, -4.4919> }
			triangle { <-17.5476, 84.5537, -4.4919>, <-15.5425, 81.7649, -6.2763>, <-11.5369, 78.7086, -9.464> }
			triangle { <-11.5369, 78.7086, -9.464>, <-14.37, 82.2361, -5.5685>, <-16.8305, 84.8206, -4.2161> }
			triangle { <-14.37, 82.2361, -5.5685>, <-16.1402, 84.3615, -3.1389>, <-16.8305, 84.8206, -4.2161> }
			triangle { <-16.1402, 84.3615, -3.1389>, <-17.7209, 84.2461, -1.08162>, <-16.8305, 84.8206, -4.2161> }
			triangle { <-17.5476, 84.5537, -4.4919>, <-19.03524, 83.7576, -1.9305>, <-18.224, 83.542, -3.8605> }
			triangle { <-18.224, 83.542, -3.8605>, <-15.5425, 81.7649, -6.2763>, <-17.5476, 84.5537, -4.4919> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-6.9671, 73.2127, -13.3757>, <-8.1993, 90.0205, -17.5129>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.1993, 90.0205, -17.5129>, <-3.06865, 94.2483, -22.2237>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-3.06865, 94.2483, -22.2237>, <3.1295, 98.6229, -28.1704>, <3.7365, 98.661, -27.6304> }
			triangle { <3.1295, 98.6229, -28.1704>, <6.05035, 96.6483, -30.1794>, <3.7365, 98.661, -27.6304> }
			triangle { <3.1295, 98.6229, -28.1704>, <5.03856, 97.00787, -30.3372>, <6.05035, 96.6483, -30.1794> }
			triangle { <6.05035, 96.6483, -30.1794>, <6.03884, 97.2211, -29.05642>, <3.7365, 98.661, -27.6304> }
			triangle { <3.7365, 98.661, -27.6304>, <1.494, 96.5014, -25.3306>, <-3.06865, 94.2483, -22.2237> }
			triangle { <-3.06865, 94.2483, -22.2237>, <0.5824, 96.3631, -26.4475>, <3.1295, 98.6229, -28.1704> }
			triangle { <0.5824, 96.3631, -26.4475>, <2.8688, 97.6169, -29.04654>, <3.1295, 98.6229, -28.1704> }
			triangle { <2.8688, 97.6169, -29.04654>, <5.03856, 97.00787, -30.3372>, <3.1295, 98.6229, -28.1704> }
			triangle { <3.7365, 98.661, -27.6304>, <6.03884, 97.2211, -29.05642>, <4.6624, 97.6553, -27.5246> }
			triangle { <4.6624, 97.6553, -27.5246>, <1.494, 96.5014, -25.3306>, <3.7365, 98.661, -27.6304> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-8.1993, 90.0205, -17.5129>, <-11.06656, 106.7372, -21.1829>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.06656, 106.7372, -21.1829>, <-17.8267, 111.2415, -20.5495>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-17.8267, 111.2415, -20.5495>, <-26.04554, 116.1109, -19.262>, <-26.4079, 115.8236, -19.9311> }
			triangle { <-26.04554, 116.1109, -19.262>, <-29.3828, 114.4511, -17.6577>, <-26.4079, 115.8236, -19.9311> }
			triangle { <-26.04554, 116.1109, -19.262>, <-28.5266, 115.0432, -17.3509>, <-29.3828, 114.4511, -17.6577> }
			triangle { <-29.3828, 114.4511, -17.6577>, <-28.9865, 114.5636, -18.8492>, <-26.4079, 115.8236, -19.9311> }
			triangle { <-26.4079, 115.8236, -19.9311>, <-23.3447, 113.4839, -20.2841>, <-17.8267, 111.2415, -20.5495> }
			triangle { <-17.8267, 111.2415, -20.5495>, <-22.9101, 113.9534, -18.9847>, <-26.04554, 116.1109, -19.262> }
			triangle { <-22.9101, 113.9534, -18.9847>, <-26.07195, 115.571, -18.01494>, <-26.04554, 116.1109, -19.262> }
			triangle { <-26.07195, 115.571, -18.01494>, <-28.5266, 115.0432, -17.3509>, <-26.04554, 116.1109, -19.262> }
			triangle { <-26.4079, 115.8236, -19.9311>, <-28.9865, 114.5636, -18.8492>, <-27.1658, 114.6815, -19.8982> }
			triangle { <-27.1658, 114.6815, -19.8982>, <-23.3447, 113.4839, -20.2841>, <-26.4079, 115.8236, -19.9311> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-11.06656, 106.7372, -21.1829>, <-9.6966, 123.6858, -24.6478>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.6966, 123.6858, -24.6478>, <-2.9085, 128.1613, -25.1782>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-2.9085, 128.1613, -25.1782>, <5.4742, 132.8434, -26.02981>, <5.6221, 132.8774, -25.2307> }
			triangle { <5.4742, 132.8434, -26.02981>, <9.08078, 130.992, -25.8511>, <5.6221, 132.8774, -25.2307> }
			triangle { <5.4742, 132.8434, -26.02981>, <8.3653, 131.3353, -26.5915>, <9.08078, 130.992, -25.8511> }
			triangle { <9.08078, 130.992, -25.8511>, <8.3643, 131.5297, -24.964>, <5.6221, 132.8774, -25.2307> }
			triangle { <5.6221, 132.8774, -25.2307>, <2.5186, 130.6024, -24.8121>, <-2.9085, 128.1613, -25.1782> }
			triangle { <-2.9085, 128.1613, -25.1782>, <2.4868, 130.4796, -26.2549>, <5.4742, 132.8434, -26.02981> }
			triangle { <2.4868, 130.4796, -26.2549>, <5.8397, 131.8596, -26.8936>, <5.4742, 132.8434, -26.02981> }
			triangle { <5.8397, 131.8596, -26.8936>, <8.3653, 131.3353, -26.5915>, <5.4742, 132.8434, -26.02981> }
			triangle { <5.6221, 132.8774, -25.2307>, <8.3643, 131.5297, -24.964>, <6.3242, 131.8882, -24.5916> }
			triangle { <6.3242, 131.8882, -24.5916>, <2.5186, 130.6024, -24.8121>, <5.6221, 132.8774, -25.2307> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-9.6966, 123.6858, -24.6478>, <-9.5132, 140.5859, -28.5835>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.5132, 140.5859, -28.5835>, <-15.6582, 144.6632, -32.0481>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-15.6582, 144.6632, -32.0481>, <-23.3928, 149.0326, -35.7902>, <-23.3162, 148.7001, -36.5286> }
			triangle { <-23.3928, 149.0326, -35.7902>, <-27.00071, 147.2159, -36.1764>, <-23.3162, 148.7001, -36.5286> }
			triangle { <-23.3928, 149.0326, -35.7902>, <-26.4766, 147.872, -35.4888>, <-27.00071, 147.2159, -36.1764> }
			triangle { <-27.00071, 147.2159, -36.1764>, <-26.01784, 147.3134, -36.9599>, <-23.3162, 148.7001, -36.5286> }
			triangle { <-23.3162, 148.7001, -36.5286>, <-20.4848, 146.5525, -34.9946>, <-15.6582, 144.6632, -32.0481> }
			triangle { <-15.6582, 144.6632, -32.0481>, <-20.8548, 147.0926, -33.7027>, <-23.3928, 149.0326, -35.7902> }
			triangle { <-20.8548, 147.0926, -33.7027>, <-24.08275, 148.5344, -34.7304>, <-23.3928, 149.0326, -35.7902> }
			triangle { <-24.08275, 148.5344, -34.7304>, <-26.4766, 147.872, -35.4888>, <-23.3928, 149.0326, -35.7902> }
			triangle { <-23.3162, 148.7001, -36.5286>, <-26.01784, 147.3134, -36.9599>, <-23.9259, 147.5132, -36.844> }
			triangle { <-23.9259, 147.5132, -36.844>, <-20.4848, 146.5525, -34.9946>, <-23.3162, 148.7001, -36.5286> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-9.5132, 140.5859, -28.5835>, <-9.6568, 157.4224, -32.7845>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.6568, 157.4224, -32.7845>, <-4.8646, 163.4535, -30.1293>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-4.8646, 163.4535, -30.1293>, <1.3398, 170.084, -26.8953>, <0.9997, 170.1516, -26.1595> }
			triangle { <1.3398, 170.084, -26.8953>, <4.5046, 169.192, -24.5172>, <0.9997, 170.1516, -26.1595> }
			triangle { <1.3398, 170.084, -26.8953>, <4.2797, 169.3477, -25.5675>, <4.5046, 169.192, -24.5172> }
			triangle { <4.5046, 169.192, -24.5172>, <3.3197, 169.5312, -24.2516>, <0.9997, 170.1516, -26.1595> }
			triangle { <0.9997, 170.1516, -26.1595>, <-1.243, 167.1722, -27.1963>, <-4.8646, 163.4535, -30.1293> }
			triangle { <-4.8646, 163.4535, -30.1293>, <-0.4284, 167.0494, -28.3876>, <1.3398, 170.084, -26.8953> }
			triangle { <-0.4284, 167.0494, -28.3876>, <2.3238, 169.2251, -27.2716>, <1.3398, 170.084, -26.8953> }
			triangle { <2.3238, 169.2251, -27.2716>, <4.2797, 169.3477, -25.5675>, <1.3398, 170.084, -26.8953> }
			triangle { <0.9997, 170.1516, -26.1595>, <3.3197, 169.5312, -24.2516>, <1.4053, 169.3675, -25.1104> }
			triangle { <1.4053, 169.3675, -25.1104>, <-1.243, 167.1722, -27.1963>, <0.9997, 170.1516, -26.1595> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-9.6568, 157.4224, -32.7845>, <-10.02523, 174.1645, -37.3347>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.02523, 174.1645, -37.3347>, <-13.4575, 177.6801, -43.8346>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-13.4575, 177.6801, -43.8346>, <-18.02115, 181.2948, -51.5175>, <-17.4659, 181.0466, -52.05758> }
			triangle { <-18.02115, 181.2948, -51.5175>, <-20.3261, 179.0509, -53.9911>, <-17.4659, 181.0466, -52.05758> }
			triangle { <-18.02115, 181.2948, -51.5175>, <-20.4325, 179.7044, -53.1311>, <-20.3261, 179.0509, -53.9911> }
			triangle { <-20.3261, 179.0509, -53.9911>, <-19.1027, 179.3538, -54.02292>, <-17.4659, 181.0466, -52.05758> }
			triangle { <-17.4659, 181.0466, -52.05758>, <-15.8029, 179.1673, -49.1105>, <-13.4575, 177.6801, -43.8346> }
			triangle { <-13.4575, 177.6801, -43.8346>, <-16.953, 179.5285, -48.3078>, <-18.02115, 181.2948, -51.5175> }
			triangle { <-16.953, 179.5285, -48.3078>, <-19.1132, 180.6104, -51.08578>, <-18.02115, 181.2948, -51.5175> }
			triangle { <-19.1132, 180.6104, -51.08578>, <-20.4325, 179.7044, -53.1311>, <-18.02115, 181.2948, -51.5175> }
			triangle { <-17.4659, 181.0466, -52.05758>, <-19.1027, 179.3538, -54.02292>, <-17.5614, 179.823, -52.6689> }
			triangle { <-17.5614, 179.823, -52.6689>, <-15.8029, 179.1673, -49.1105>, <-17.4659, 181.0466, -52.05758> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-10.02523, 174.1645, -37.3347>, <-9.9929, 191.2677, -40.2697>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.9929, 191.2677, -40.2697>, <-8.625, 196.2254, -35.4231>, 0.4163 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-8.625, 196.2254, -35.4231>, <-6.6049, 201.6727, -29.4114>, <-7.2073, 201.5986, -29.05204> }
			triangle { <-6.6049, 201.6727, -29.4114>, <-5.3718, 200.6973, -26.2627>, <-7.2073, 201.5986, -29.05204> }
			triangle { <-6.6049, 201.6727, -29.4114>, <-5.05034, 200.9829, -27.1>, <-5.3718, 200.6973, -26.2627> }
			triangle { <-5.3718, 200.6973, -26.2627>, <-6.3864, 200.8863, -26.6241>, <-7.2073, 201.5986, -29.05204> }
			triangle { <-7.2073, 201.5986, -29.05204>, <-7.9257, 199.1127, -31.1906>, <-8.625, 196.2254, -35.4231> }
			triangle { <-8.625, 196.2254, -35.4231>, <-6.7605, 199.2343, -31.6439>, <-6.6049, 201.6727, -29.4114> }
			triangle { <-6.7605, 199.2343, -31.6439>, <-5.6135, 201.0485, -29.2799>, <-6.6049, 201.6727, -29.4114> }
			triangle { <-5.6135, 201.0485, -29.2799>, <-5.05034, 200.9829, -27.1>, <-6.6049, 201.6727, -29.4114> }
			triangle { <-7.2073, 201.5986, -29.05204>, <-6.3864, 200.8863, -26.6241>, <-7.3186, 200.7869, -28.1902> }
			triangle { <-7.3186, 200.7869, -28.1902>, <-7.9257, 199.1127, -31.1906>, <-7.2073, 201.5986, -29.05204> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-9.9929, 191.2677, -40.2697>, <-9.6861, 207.4712, -46.4738>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.6861, 207.4712, -46.4738>, <-9.593, 207.9116, -47.6926>, 0.07653 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-9.593, 207.9116, -47.6926>, <-9.5346, 208.3324, -49.1697>, <-9.4078, 208.3093, -49.1836> }
			triangle { <-9.5346, 208.3324, -49.1697>, <-9.5426, 207.9093, -49.6591>, <-9.4078, 208.3093, -49.1836> }
			triangle { <-9.5346, 208.3324, -49.1697>, <-9.652, 208.0096, -49.5701>, <-9.5426, 207.9093, -49.6591> }
			triangle { <-9.5426, 207.9093, -49.6591>, <-9.3915, 207.993, -49.5562>, <-9.4078, 208.3093, -49.1836> }
			triangle { <-9.4078, 208.3093, -49.1836>, <-9.4298, 208.0681, -48.6159>, <-9.593, 207.9116, -47.6926> }
			triangle { <-9.593, 207.9116, -47.6926>, <-9.6593, 208.0916, -48.625>, <-9.5346, 208.3324, -49.1697> }
			triangle { <-9.6593, 208.0916, -48.625>, <-9.6977, 208.1934, -49.2019>, <-9.5346, 208.3324, -49.1697> }
			triangle { <-9.6977, 208.1934, -49.2019>, <-9.652, 208.0096, -49.5701>, <-9.5346, 208.3324, -49.1697> }
			triangle { <-9.4078, 208.3093, -49.1836>, <-9.3915, 207.993, -49.5562>, <-9.3341, 208.114, -49.2486> }
			triangle { <-9.3341, 208.114, -49.2486>, <-9.4298, 208.0681, -48.6159>, <-9.4078, 208.3093, -49.1836> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-9.6861, 207.4712, -46.4738>, <-9.7656, 211.2182, -47.5318>, 0.1335 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.7656, 211.2182, -47.5318>, <-9.9749, 211.6971, -47.1688>, 0.03748 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-9.9749, 211.6971, -47.1688>, <-10.2034, 212.2341, -46.6933>, <-10.265, 212.2192, -46.6968> }
			triangle { <-10.2034, 212.2341, -46.6933>, <-10.2683, 212.1793, -46.388>, <-10.265, 212.2192, -46.6968> }
			triangle { <-10.2034, 212.2341, -46.6933>, <-10.2043, 212.2067, -46.4363>, <-10.2683, 212.1793, -46.388> }
			triangle { <-10.2683, 212.1793, -46.388>, <-10.3249, 212.1784, -46.4685>, <-10.265, 212.2192, -46.6968> }
			triangle { <-10.265, 212.2192, -46.6968>, <-10.1777, 211.9796, -46.8592>, <-9.9749, 211.6971, -47.1688> }
			triangle { <-9.9749, 211.6971, -47.1688>, <-10.07095, 212.0075, -46.8344>, <-10.2034, 212.2341, -46.6933> }
			triangle { <-10.07095, 212.0075, -46.8344>, <-10.1316, 212.1953, -46.6253>, <-10.2034, 212.2341, -46.6933> }
			triangle { <-10.1316, 212.1953, -46.6253>, <-10.2043, 212.2067, -46.4363>, <-10.2034, 212.2341, -46.6933> }
			triangle { <-10.265, 212.2192, -46.6968>, <-10.3249, 212.1784, -46.4685>, <-10.3093, 212.1487, -46.6294> }
			triangle { <-10.3093, 212.1487, -46.6294>, <-10.1777, 211.9796, -46.8592>, <-10.265, 212.2192, -46.6968> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
} // end Copy_of_Copy_of_Breeder_plant_2

#declare Copy_of_Copy_of_Breeder_plant_2 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.1613, 2.06168, -0.1965>, 0.07122 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <0.1613, 2.06168, -0.1965>, <0.2007, 3.143, -0.2708>, 0.03718 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.2007, 3.143, -0.2708>, <-0.01774, 3.3697, -0.1421>, 0.02003 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-0.01774, 3.3697, -0.1421>, <-0.2819, 3.6177, 0.03273>, <-0.3067, 3.6122, 0.01018> }
			triangle { <-0.2819, 3.6177, 0.03273>, <-0.4061, 3.5639, 0.1347>, <-0.3067, 3.6122, 0.01018> }
			triangle { <-0.2819, 3.6177, 0.03273>, <-0.364, 3.5804, 0.1374>, <-0.4061, 3.5639, 0.1347> }
			triangle { <-0.4061, 3.5639, 0.1347>, <-0.4044, 3.5725, 0.08281>, <-0.3067, 3.6122, 0.01018> }
			triangle { <-0.3067, 3.6122, 0.01018>, <-0.211, 3.4977, -0.0517>, <-0.01774, 3.3697, -0.1421> }
			triangle { <-0.01774, 3.3697, -0.1421>, <-0.1741, 3.5065, -0.004633>, <-0.2819, 3.6177, 0.03273> }
			triangle { <-0.1741, 3.5065, -0.004633>, <-0.272, 3.5888, 0.08056>, <-0.2819, 3.6177, 0.03273> }
			triangle { <-0.272, 3.5888, 0.08056>, <-0.364, 3.5804, 0.1374>, <-0.2819, 3.6177, 0.03273> }
			triangle { <-0.3067, 3.6122, 0.01018>, <-0.4044, 3.5725, 0.08281>, <-0.3453, 3.5707, 0.01778> }
			triangle { <-0.3453, 3.5707, 0.01778>, <-0.211, 3.4977, -0.0517>, <-0.3067, 3.6122, 0.01018> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.2007, 3.143, -0.2708>, <-1.6281, 19.919, 0.1288>, 0.5787 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.6281, 19.919, 0.1288>, <-6.315, 23.5211, 2.9474>, 0.3857 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-6.315, 23.5211, 2.9474>, <-11.9277, 27.3427, 6.6778>, <-12.3881, 27.2265, 6.2285> }
			triangle { <-11.9277, 27.3427, 6.6778>, <-14.1912, 25.8602, 8.4989>, <-12.3881, 27.2265, 6.2285> }
			triangle { <-11.9277, 27.3427, 6.6778>, <-13.4224, 26.2615, 8.5933>, <-14.1912, 25.8602, 8.4989> }
			triangle { <-14.1912, 25.8602, 8.4989>, <-14.1742, 26.123, 7.5204>, <-12.3881, 27.2265, 6.2285> }
			triangle { <-12.3881, 27.2265, 6.2285>, <-10.3011, 25.3689, 4.8604>, <-6.315, 23.5211, 2.9474> }
			triangle { <-6.315, 23.5211, 2.9474>, <-9.6183, 25.5306, 5.7892>, <-11.9277, 27.3427, 6.6778> }
			triangle { <-9.6183, 25.5306, 5.7892>, <-11.6785, 26.7262, 7.5446>, <-11.9277, 27.3427, 6.6778> }
			triangle { <-11.6785, 26.7262, 7.5446>, <-13.4224, 26.2615, 8.5933>, <-11.9277, 27.3427, 6.6778> }
			triangle { <-12.3881, 27.2265, 6.2285>, <-14.1742, 26.123, 7.5204>, <-13.03624, 26.3372, 6.2874> }
			triangle { <-13.03624, 26.3372, 6.2874>, <-10.3011, 25.3689, 4.8604>, <-12.3881, 27.2265, 6.2285> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-1.6281, 19.919, 0.1288>, <-3.09767, 37.2072, 0.435>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.09767, 37.2072, 0.435>, <2.8089, 42.6083, -1.09111>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <2.8089, 42.6083, -1.09111>, <10.09084, 48.5019, -3.3622>, <10.4978, 48.3887, -2.6672> }
			triangle { <10.09084, 48.5019, -3.3622>, <13.6559, 47.1829, -4.7825>, <10.4978, 48.3887, -2.6672> }
			triangle { <10.09084, 48.5019, -3.3622>, <12.7117, 47.5687, -5.1534>, <13.6559, 47.1829, -4.7825> }
			triangle { <13.6559, 47.1829, -4.7825>, <13.2489, 47.4166, -3.6124>, <10.4978, 48.3887, -2.6672> }
			triangle { <10.4978, 48.3887, -2.6672>, <7.8716, 45.6612, -1.8637>, <2.8089, 42.6083, -1.09111> }
			triangle { <2.8089, 42.6083, -1.09111>, <7.3614, 45.8394, -3.2075>, <10.09084, 48.5019, -3.3622> }
			triangle { <7.3614, 45.8394, -3.2075>, <10.2047, 47.7821, -4.5096>, <10.09084, 48.5019, -3.3622> }
			triangle { <10.2047, 47.7821, -4.5096>, <12.7117, 47.5687, -5.1534>, <10.09084, 48.5019, -3.3622> }
			triangle { <10.4978, 48.3887, -2.6672>, <13.2489, 47.4166, -3.6124>, <11.4366, 47.3973, -2.5426> }
			triangle { <11.4366, 47.3973, -2.5426>, <7.8716, 45.6612, -1.8637>, <10.4978, 48.3887, -2.6672> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <-3.09767, 37.2072, 0.435>, <-3.6986, 39.137, 0.3421>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-3.6986, 39.137, 0.3421>, <-4.6994, 40.8823, 0.1277>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-4.6994, 40.8823, 0.1277>, <-6.04964, 42.3542, -0.1948>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-6.04964, 42.3542, -0.1948>, <-7.6811, 43.4777, -0.6067>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-7.6811, 43.4777, -0.6067>, <-9.173, 44.8434, -0.6577>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.173, 44.8434, -0.6577>, <-11.346, 47.3348, -0.4252>, 0.07128 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-11.346, 47.3348, -0.4252>, <-12.5991, 49.6784, -1.5792>, <-12.9489, 49.1535, -0.1881> }
					triangle { <-12.9489, 49.1535, -0.1881>, <-12.5991, 49.6784, -1.5792>, <-14.06239, 51.7359, -1.6312> }
					triangle { <-12.9489, 49.1535, -0.1881>, <-14.06239, 51.7359, -1.6312>, <-14.4886, 51.203, 0.096> }
					triangle { <-14.06239, 51.7359, -1.6312>, <-15.5784, 53.3815, 0.3085>, <-14.4886, 51.203, 0.096> }
					triangle { <-12.9489, 49.1535, -0.1881>, <-12.8744, 49.1723, 1.2714>, <-11.346, 47.3348, -0.4252> }
					triangle { <-12.8744, 49.1723, 1.2714>, <-12.9489, 49.1535, -0.1881>, <-14.4886, 51.203, 0.096> }
					triangle { <-14.2812, 51.2334, 1.7085>, <-12.8744, 49.1723, 1.2714>, <-14.4886, 51.203, 0.096> }
					triangle { <-14.2812, 51.2334, 1.7085>, <-14.4886, 51.203, 0.096>, <-15.5784, 53.3815, 0.3085> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-11.346, 47.3348, -0.4252>, <-14.07594, 48.2534, -0.1117>, <-12.8953, 49.2085, -0.2762> }
					triangle { <-12.8953, 49.2085, -0.2762>, <-14.07594, 48.2534, -0.1117>, <-15.9639, 49.9289, -0.04074> }
					triangle { <-12.8953, 49.2085, -0.2762>, <-15.9639, 49.9289, -0.04074>, <-14.5915, 51.151, -0.3093> }
					triangle { <-15.9639, 49.9289, -0.04074>, <-16.3655, 52.7887, -0.6962>, <-14.5915, 51.151, -0.3093> }
					triangle { <-12.8953, 49.2085, -0.2762>, <-12.04468, 50.1124, -1.048>, <-11.346, 47.3348, -0.4252> }
					triangle { <-12.04468, 50.1124, -1.048>, <-12.8953, 49.2085, -0.2762>, <-14.5915, 51.151, -0.3093> }
					triangle { <-13.6408, 52.06868, -1.257>, <-12.04468, 50.1124, -1.048>, <-14.5915, 51.151, -0.3093> }
					triangle { <-13.6408, 52.06868, -1.257>, <-14.5915, 51.151, -0.3093>, <-16.3655, 52.7887, -0.6962> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-11.346, 47.3348, -0.4252>, <-12.2802, 49.7231, 0.923>, <-12.9835, 49.1337, -0.298> }
					triangle { <-12.9835, 49.1337, -0.298>, <-12.2802, 49.7231, 0.923>, <-13.849, 51.6366, 1.4273> }
					triangle { <-12.9835, 49.1337, -0.298>, <-13.849, 51.6366, 1.4273>, <-14.8012, 50.9399, -0.006832> }
					triangle { <-13.849, 51.6366, 1.4273>, <-16.5874, 52.4681, 0.6663>, <-14.8012, 50.9399, -0.006832> }
					triangle { <-12.9835, 49.1337, -0.298>, <-14.04001, 48.3631, -0.9509>, <-11.346, 47.3348, -0.4252> }
					triangle { <-14.04001, 48.3631, -0.9509>, <-12.9835, 49.1337, -0.298>, <-14.8012, 50.9399, -0.006832> }
					triangle { <-15.9563, 49.9923, -0.6486>, <-14.04001, 48.3631, -0.9509>, <-14.8012, 50.9399, -0.006832> }
					triangle { <-15.9563, 49.9923, -0.6486>, <-14.8012, 50.9399, -0.006832>, <-16.5874, 52.4681, 0.6663> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <-9.173, 44.8434, -0.6577>, <-10.5924, 46.1952, -1.1592>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.5924, 46.1952, -1.1592>, <-12.8499, 48.2566, -2.4389>, 0.07128 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-12.8499, 48.2566, -2.4389>, <-15.6233, 48.9844, -2.855>, <-14.4606, 49.8001, -3.417> }
					triangle { <-14.4606, 49.8001, -3.417>, <-15.6233, 48.9844, -2.855>, <-17.557, 50.2922, -3.8179> }
					triangle { <-14.4606, 49.8001, -3.417>, <-17.557, 50.2922, -3.8179>, <-16.2008, 51.2945, -4.5959> }
					triangle { <-17.557, 50.2922, -3.8179>, <-17.9734, 52.3386, -5.9175>, <-16.2008, 51.2945, -4.5959> }
					triangle { <-14.4606, 49.8001, -3.417>, <-13.5626, 50.2272, -4.4883>, <-12.8499, 48.2566, -2.4389> }
					triangle { <-13.5626, 50.2272, -4.4883>, <-14.4606, 49.8001, -3.417>, <-16.2008, 51.2945, -4.5959> }
					triangle { <-15.1858, 51.6486, -5.816>, <-13.5626, 50.2272, -4.4883>, <-16.2008, 51.2945, -4.5959> }
					triangle { <-15.1858, 51.6486, -5.816>, <-16.2008, 51.2945, -4.5959>, <-17.9734, 52.3386, -5.9175> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-12.8499, 48.2566, -2.4389>, <-14.00857, 50.9069, -2.6067>, <-14.543, 49.7183, -3.4034> }
					triangle { <-14.543, 49.7183, -3.4034>, <-14.00857, 50.9069, -2.6067>, <-15.682, 52.6651, -3.3033> }
					triangle { <-14.543, 49.7183, -3.4034>, <-15.682, 52.6651, -3.3033>, <-16.4348, 51.2543, -4.2478> }
					triangle { <-15.682, 52.6651, -3.3033>, <-18.3329, 52.7501, -4.6205>, <-16.4348, 51.2543, -4.2478> }
					triangle { <-14.543, 49.7183, -3.4034>, <-15.4906, 48.634, -3.6535>, <-12.8499, 48.2566, -2.4389> }
					triangle { <-15.4906, 48.634, -3.6535>, <-14.543, 49.7183, -3.4034>, <-16.4348, 51.2543, -4.2478> }
					triangle { <-17.4764, 50.01567, -4.4056>, <-15.4906, 48.634, -3.6535>, <-16.4348, 51.2543, -4.2478> }
					triangle { <-17.4764, 50.01567, -4.4056>, <-16.4348, 51.2543, -4.2478>, <-18.3329, 52.7501, -4.6205> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-12.8499, 48.2566, -2.4389>, <-14.04712, 49.5367, -4.746>, <-14.5213, 49.7955, -3.3173> }
					triangle { <-14.5213, 49.7955, -3.3173>, <-14.04712, 49.5367, -4.746>, <-15.5571, 51.1369, -5.9854> }
					triangle { <-14.5213, 49.7955, -3.3173>, <-15.5571, 51.1369, -5.9854>, <-16.1413, 51.5596, -4.2738> }
					triangle { <-15.5571, 51.1369, -5.9854>, <-17.3104, 53.4309, -5.3275>, <-16.1413, 51.5596, -4.2738> }
					triangle { <-14.5213, 49.7955, -3.3173>, <-14.5964, 50.5844, -2.08915>, <-12.8499, 48.2566, -2.4389> }
					triangle { <-14.5964, 50.5844, -2.08915>, <-14.5213, 49.7955, -3.3173>, <-16.1413, 51.5596, -4.2738> }
					triangle { <-16.1002, 52.4492, -2.9133>, <-14.5964, 50.5844, -2.08915>, <-16.1413, 51.5596, -4.2738> }
					triangle { <-16.1002, 52.4492, -2.9133>, <-16.1413, 51.5596, -4.2738>, <-17.3104, 53.4309, -5.3275> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <-10.5924, 46.1952, -1.1592>, <-12.2598, 47.3256, -1.3478>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-12.2598, 47.3256, -1.3478>, <-15.1404, 48.9612, -1.2458>, 0.07128 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-15.1404, 48.9612, -1.2458>, <-16.6128, 51.4082, -0.7572>, <-17.2902, 50.1043, -1.1743> }
					triangle { <-17.2902, 50.1043, -1.1743>, <-16.6128, 51.4082, -0.7572>, <-18.6539, 52.8658, -0.4635> }
					triangle { <-17.2902, 50.1043, -1.1743>, <-18.6539, 52.8658, -0.4635>, <-19.5573, 51.3018, -0.8961> }
					triangle { <-18.6539, 52.8658, -0.4635>, <-21.5808, 52.492, -0.2121>, <-19.5573, 51.3018, -0.8961> }
					triangle { <-17.2902, 50.1043, -1.1743>, <-18.051, 48.8849, -0.9086>, <-15.1404, 48.9612, -1.2458> }
					triangle { <-18.051, 48.8849, -0.9086>, <-17.2902, 50.1043, -1.1743>, <-19.5573, 51.3018, -0.8961> }
					triangle { <-20.3261, 49.9235, -0.5046>, <-18.051, 48.8849, -0.9086>, <-19.5573, 51.3018, -0.8961> }
					triangle { <-20.3261, 49.9235, -0.5046>, <-19.5573, 51.3018, -0.8961>, <-21.5808, 52.492, -0.2121> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-15.1404, 48.9612, -1.2458>, <-17.5176, 49.9291, -2.5898>, <-17.2402, 50.1883, -1.1103> }
					triangle { <-17.2402, 50.1883, -1.1103>, <-17.5176, 49.9291, -2.5898>, <-19.6717, 51.2219, -2.8453> }
					triangle { <-17.2402, 50.1883, -1.1103>, <-19.6717, 51.2219, -2.8453>, <-19.3703, 51.6414, -1.06137> }
					triangle { <-19.6717, 51.2219, -2.8453>, <-21.1828, 53.262, -1.3208>, <-19.3703, 51.6414, -1.06137> }
					triangle { <-17.2402, 50.1883, -1.1103>, <-16.8062, 51.01978, 0.01068>, <-15.1404, 48.9612, -1.2458> }
					triangle { <-16.8062, 51.01978, 0.01068>, <-17.2402, 50.1883, -1.1103>, <-19.3703, 51.6414, -1.06137> }
					triangle { <-18.7863, 52.5963, 0.1181>, <-16.8062, 51.01978, 0.01068>, <-19.3703, 51.6414, -1.06137> }
					triangle { <-18.7863, 52.5963, 0.1181>, <-19.3703, 51.6414, -1.06137>, <-21.1828, 53.262, -1.3208> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-15.1404, 48.9612, -1.2458>, <-17.8061, 49.269, -0.1533>, <-17.2403, 50.1954, -1.2278> }
					triangle { <-17.2403, 50.1954, -1.2278>, <-17.8061, 49.269, -0.1533>, <-20.1343, 50.227, 0.04271> }
					triangle { <-17.2403, 50.1954, -1.2278>, <-20.1343, 50.227, 0.04271>, <-19.5452, 51.3493, -1.3147> }
					triangle { <-20.1343, 50.227, 0.04271>, <-21.8814, 52.04381, -1.5118>, <-19.5452, 51.3493, -1.3147> }
					triangle { <-17.2403, 50.1954, -1.2278>, <-17.09985, 50.6658, -2.6045>, <-15.1404, 48.9612, -1.2458> }
					triangle { <-17.09985, 50.6658, -2.6045>, <-17.2403, 50.1954, -1.2278>, <-19.5452, 51.3493, -1.3147> }
					triangle { <-19.3713, 51.7531, -2.8802>, <-17.09985, 50.6658, -2.6045>, <-19.5452, 51.3493, -1.3147> }
					triangle { <-19.3713, 51.7531, -2.8802>, <-19.5452, 51.3493, -1.3147>, <-21.8814, 52.04381, -1.5118> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.09767, 37.2072, 0.435>, <-3.02805, 39.1848, 0.8568>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-3.02805, 39.1848, 0.8568>, <-2.3732, 41.04078, 1.3264>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.3732, 41.04078, 1.3264>, <-1.3455, 44.1777, 1.62>, 0.07128 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-1.3455, 44.1777, 1.62>, <-1.8463, 46.9079, 2.4507>, <-0.5387, 46.4695, 1.794> }
					triangle { <-0.5387, 46.4695, 1.794>, <-1.8463, 46.9079, 2.4507>, <-1.3917, 49.3813, 2.6798> }
					triangle { <-0.5387, 46.4695, 1.794>, <-1.3917, 49.3813, 2.6798>, <0.1952, 48.9417, 1.8211> }
					triangle { <-1.3917, 49.3813, 2.6798>, <0.5334, 51.3529, 1.5956>, <0.1952, 48.9417, 1.8211> }
					triangle { <-0.5387, 46.4695, 1.794>, <0.3766, 46.347, 0.6612>, <-1.3455, 44.1777, 1.62> }
					triangle { <0.3766, 46.347, 0.6612>, <-0.5387, 46.4695, 1.794>, <0.1952, 48.9417, 1.8211> }
					triangle { <1.1165, 48.7641, 0.4931>, <0.3766, 46.347, 0.6612>, <0.1952, 48.9417, 1.8211> }
					triangle { <1.1165, 48.7641, 0.4931>, <0.1952, 48.9417, 1.8211>, <0.5334, 51.3529, 1.5956> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-1.3455, 44.1777, 1.62>, <0.5336, 46.1057, 2.6905>, <-0.6492, 46.5042, 1.81> }
					triangle { <-0.6492, 46.5042, 1.81>, <0.5336, 46.1057, 2.6905>, <1.4662, 48.3962, 3.2014> }
					triangle { <-0.6492, 46.5042, 1.81>, <1.4662, 48.3962, 3.2014>, <0.01063, 48.9668, 2.1991> }
					triangle { <1.4662, 48.3962, 3.2014>, <0.5682, 51.2105, 2.9952>, <0.01063, 48.9668, 2.1991> }
					triangle { <-0.6492, 46.5042, 1.81>, <-1.9926, 47.03635, 1.5904>, <-1.3455, 44.1777, 1.62> }
					triangle { <-1.9926, 47.03635, 1.5904>, <-0.6492, 46.5042, 1.81>, <0.01063, 48.9668, 2.1991> }
					triangle { <-1.5235, 49.4837, 2.04695>, <-1.9926, 47.03635, 1.5904>, <0.01063, 48.9668, 2.1991> }
					triangle { <-1.5235, 49.4837, 2.04695>, <0.01063, 48.9668, 2.1991>, <0.5682, 51.2105, 2.9952> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-1.3455, 44.1777, 1.62>, <-0.4139, 46.6312, 0.3923>, <-0.5826, 46.4737, 1.9022> }
					triangle { <-0.5826, 46.4737, 1.9022>, <-0.4139, 46.6312, 0.3923>, <0.5224, 48.9752, 0.3173> }
					triangle { <-0.5826, 46.4737, 1.9022>, <0.5224, 48.9752, 0.3173>, <0.4135, 48.8379, 2.1662> }
					triangle { <0.5224, 48.9752, 0.3173>, <1.7143, 50.9077, 2.2184>, <0.4135, 48.8379, 2.1662> }
					triangle { <-0.5826, 46.4737, 1.9022>, <-0.079, 46.2535, 3.2565>, <-1.3455, 44.1777, 1.62> }
					triangle { <-0.079, 46.2535, 3.2565>, <-0.5826, 46.4737, 1.9022>, <0.4135, 48.8379, 2.1662> }
					triangle { <1.03953, 48.4961, 3.6275>, <-0.079, 46.2535, 3.2565>, <0.4135, 48.8379, 2.1662> }
					triangle { <1.03953, 48.4961, 3.6275>, <0.4135, 48.8379, 2.1662>, <1.7143, 50.9077, 2.2184> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.02805, 39.1848, 0.8568>, <-3.5497, 41.1105, 1.1937>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.5497, 41.1105, 1.1937>, <-4.3598, 44.1562, 2.2187>, 0.07128 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-4.3598, 44.1562, 2.2187>, <-3.6646, 46.9474, 2.5656>, <-5.008021, 46.3685, 3.005326> }
					triangle { <-5.008021, 46.3685, 3.005326>, <-3.6646, 46.9474, 2.5656>, <-3.9484, 49.3239, 3.3708> }
					triangle { <-5.008021, 46.3685, 3.005326>, <-3.9484, 49.3239, 3.3708>, <-5.5735, 48.6804, 3.9985> }
					triangle { <-3.9484, 49.3239, 3.3708>, <-5.7521, 50.8071, 5.1919>, <-5.5735, 48.6804, 3.9985> }
					triangle { <-5.008021, 46.3685, 3.005326>, <-5.9457, 45.8569, 4.002955>, <-4.3598, 44.1562, 2.2187> }
					triangle { <-5.9457, 45.8569, 4.002955>, <-5.008021, 46.3685, 3.005326>, <-5.5735, 48.6804, 3.9985> }
					triangle { <-6.5237, 48.03952, 5.152>, <-5.9457, 45.8569, 4.002955>, <-5.5735, 48.6804, 3.9985> }
					triangle { <-6.5237, 48.03952, 5.152>, <-5.5735, 48.6804, 3.9985>, <-5.7521, 50.8071, 5.1919> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-4.3598, 44.1562, 2.2187>, <-6.08947, 46.4747, 2.05391>, <-4.8952, 46.3992, 3.003235> }
					triangle { <-4.8952, 46.3992, 3.003235>, <-6.08947, 46.4747, 2.05391>, <-6.8585, 48.8315, 2.5341> }
					triangle { <-4.8952, 46.3992, 3.003235>, <-6.8585, 48.8315, 2.5341>, <-5.3823, 48.8449, 3.661> }
					triangle { <-6.8585, 48.8315, 2.5341>, <-5.7763, 51.2502, 3.8563>, <-5.3823, 48.8449, 3.661> }
					triangle { <-4.8952, 46.3992, 3.003235>, <-3.5223, 46.7039, 3.4013>, <-4.3598, 44.1562, 2.2187> }
					triangle { <-3.5223, 46.7039, 3.4013>, <-4.8952, 46.3992, 3.003235>, <-5.3823, 48.8449, 3.661> }
					triangle { <-3.8191, 49.1504, 3.9885>, <-3.5223, 46.7039, 3.4013>, <-5.3823, 48.8449, 3.661> }
					triangle { <-3.8191, 49.1504, 3.9885>, <-5.3823, 48.8449, 3.661>, <-5.7763, 51.2502, 3.8563> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-4.3598, 44.1562, 2.2187>, <-5.1418, 45.953, 4.3528>, <-4.9623, 46.4135, 2.9076> }
					triangle { <-4.9623, 46.4135, 2.9076>, <-5.1418, 45.953, 4.3528>, <-5.9193, 48.1201, 5.39> }
					triangle { <-4.9623, 46.4135, 2.9076>, <-5.9193, 48.1201, 5.39>, <-5.7934, 48.7412, 3.6442> }
					triangle { <-5.9193, 48.1201, 5.39>, <-6.9511, 50.735, 4.4587>, <-5.7934, 48.7412, 3.6442> }
					triangle { <-4.9623, 46.4135, 2.9076>, <-5.4602, 46.7987, 1.5884>, <-4.3598, 44.1562, 2.2187> }
					triangle { <-5.4602, 46.7987, 1.5884>, <-4.9623, 46.4135, 2.9076>, <-5.7934, 48.7412, 3.6442> }
					triangle { <-6.4199, 49.06752, 2.1796>, <-5.4602, 46.7987, 1.5884>, <-5.7934, 48.7412, 3.6442> }
					triangle { <-6.4199, 49.06752, 2.1796>, <-5.7934, 48.7412, 3.6442>, <-6.9511, 50.735, 4.4587> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.02805, 39.1848, 0.8568>, <-2.8811, 41.2026, 0.8303>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-2.8811, 41.2026, 0.8303>, <-3.1349, 43.1547, 0.3626>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.1349, 43.1547, 0.3626>, <-3.8365, 46.3723, -0.008737>, 0.07128 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-3.8365, 46.3723, -0.008737>, <-3.0228, 49.1474, 0.1659>, <-4.4177, 48.7213, -0.2873> }
					triangle { <-4.4177, 48.7213, -0.2873>, <-3.0228, 49.1474, 0.1659>, <-3.3115, 51.6555, 0.1093> }
					triangle { <-4.4177, 48.7213, -0.2873>, <-3.3115, 51.6555, 0.1093>, <-5.0493, 51.2201, -0.3802> }
					triangle { <-3.3115, 51.6555, 0.1093>, <-5.5499, 53.5887, -0.03711>, <-5.0493, 51.2201, -0.3802> }
					triangle { <-4.4177, 48.7213, -0.2873>, <-5.848, 48.5029, -0.08044>, <-3.8365, 46.3723, -0.008737> }
					triangle { <-5.848, 48.5029, -0.08044>, <-4.4177, 48.7213, -0.2873>, <-5.0493, 51.2201, -0.3802> }
					triangle { <-6.6112, 50.9184, -0.04327>, <-5.848, 48.5029, -0.08044>, <-5.0493, 51.2201, -0.3802> }
					triangle { <-6.6112, 50.9184, -0.04327>, <-5.0493, 51.2201, -0.3802>, <-5.5499, 53.5887, -0.03711> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-3.8365, 46.3723, -0.008737>, <-4.6104, 48.5845, -1.7121>, <-4.3259, 48.749, -0.2205> }
					triangle { <-4.3259, 48.749, -0.2205>, <-4.6104, 48.5845, -1.7121>, <-5.06234, 50.9932, -2.321> }
					triangle { <-4.3259, 48.749, -0.2205>, <-5.06234, 50.9932, -2.321>, <-4.6617, 51.2871, -0.5315> }
					triangle { <-5.06234, 50.9932, -2.321>, <-4.6423, 53.6628, -1.1101>, <-4.6617, 51.2871, -0.5315> }
					triangle { <-4.3259, 48.749, -0.2205>, <-3.4888, 49.1322, 0.9146>, <-3.8365, 46.3723, -0.008737> }
					triangle { <-3.4888, 49.1322, 0.9146>, <-4.3259, 48.749, -0.2205>, <-4.6617, 51.2871, -0.5315> }
					triangle { <-3.6366, 51.6502, 0.6773>, <-3.4888, 49.1322, 0.9146>, <-4.6617, 51.2871, -0.5315> }
					triangle { <-3.6366, 51.6502, 0.6773>, <-4.6617, 51.2871, -0.5315>, <-4.6423, 53.6628, -1.1101> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-3.8365, 46.3723, -0.008737>, <-5.4468, 48.6788, 0.685>, <-4.3133, 48.7383, -0.337> }
					triangle { <-4.3133, 48.7383, -0.337>, <-5.4468, 48.6788, 0.685>, <-6.2921, 51.05214, 0.5124> }
					triangle { <-4.3133, 48.7383, -0.337>, <-6.2921, 51.05214, 0.5124>, <-4.9795, 51.1874, -0.7945> }
					triangle { <-6.2921, 51.05214, 0.5124>, <-6.001815, 53.3391, -1.3463>, <-4.9795, 51.1874, -0.7945> }
					triangle { <-4.3133, 48.7383, -0.337>, <-3.7832, 48.7664, -1.6988>, <-3.8365, 46.3723, -0.008737> }
					triangle { <-3.7832, 48.7664, -1.6988>, <-4.3133, 48.7383, -0.337>, <-4.9795, 51.1874, -0.7945> }
					triangle { <-4.4649, 51.1218, -2.3356>, <-3.7832, 48.7664, -1.6988>, <-4.9795, 51.1874, -0.7945> }
					triangle { <-4.4649, 51.1218, -2.3356>, <-4.9795, 51.1874, -0.7945>, <-6.001815, 53.3391, -1.3463> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <-2.8811, 41.2026, 0.8303>, <-2.3462, 43.1089, 1.2472>, 0.07128 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.3462, 43.1089, 1.2472>, <-1.1852, 46.1995, 1.5357>, 0.07128 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-1.1852, 46.1995, 1.5357>, <-1.5888, 49.05779, 1.287>, <-0.2694, 48.446, 1.7539> }
					triangle { <-0.2694, 48.446, 1.7539>, <-1.5888, 49.05779, 1.287>, <-0.9397, 51.4981, 1.2786> }
					triangle { <-0.2694, 48.446, 1.7539>, <-0.9397, 51.4981, 1.2786>, <0.7175, 50.8285, 1.7826> }
					triangle { <-0.9397, 51.4981, 1.2786>, <1.5554, 53.08994, 1.3787>, <0.7175, 50.8285, 1.7826> }
					triangle { <-0.2694, 48.446, 1.7539>, <1.1137, 48.01749, 1.5555>, <-1.1852, 46.1995, 1.5357> }
					triangle { <1.1137, 48.01749, 1.5555>, <-0.2694, 48.446, 1.7539>, <0.7175, 50.8285, 1.7826> }
					triangle { <2.2186, 50.2951, 1.4567>, <1.1137, 48.01749, 1.5555>, <0.7175, 50.8285, 1.7826> }
					triangle { <2.2186, 50.2951, 1.4567>, <0.7175, 50.8285, 1.7826>, <1.5554, 53.08994, 1.3787> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-1.1852, 46.1995, 1.5357>, <-0.09588, 48.32, 3.1822>, <-0.3563, 48.485, 1.6862> }
					triangle { <-0.3563, 48.485, 1.6862>, <-0.09588, 48.32, 3.1822>, <0.7013, 50.653, 3.7288> }
					triangle { <-0.3563, 48.485, 1.6862>, <0.7013, 50.653, 3.7288>, <0.3441, 50.9549, 1.9314> }
					triangle { <0.7013, 50.653, 3.7288>, <0.6701, 53.3226, 2.4476>, <0.3441, 50.9549, 1.9314> }
					triangle { <-0.3563, 48.485, 1.6862>, <-1.1312, 48.9556, 0.5398>, <-1.1852, 46.1995, 1.5357> }
					triangle { <-1.1312, 48.9556, 0.5398>, <-0.3563, 48.485, 1.6862>, <0.3441, 50.9549, 1.9314> }
					triangle { <-0.6198, 51.4309, 0.7115>, <-1.1312, 48.9556, 0.5398>, <0.3441, 50.9549, 1.9314> }
					triangle { <-0.6198, 51.4309, 0.7115>, <0.3441, 50.9549, 1.9314>, <0.6701, 53.3226, 2.4476> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-1.1852, 46.1995, 1.5357>, <0.7407, 48.2295, 0.7849>, <-0.3701, 48.4793, 1.803> }
					triangle { <-0.3701, 48.4793, 1.803>, <0.7407, 48.2295, 0.7849>, <1.9212, 50.459, 0.8971> }
					triangle { <-0.3701, 48.4793, 1.803>, <1.9212, 50.459, 0.8971>, <0.6446, 50.8172, 2.1975> }
					triangle { <1.9212, 50.459, 0.8971>, <1.9688, 52.8117, 2.6948>, <0.6446, 50.8172, 2.1975> }
					triangle { <-0.3701, 48.4793, 1.803>, <-0.888, 48.6194, 3.1626>, <-1.1852, 46.1995, 1.5357> }
					triangle { <-0.888, 48.6194, 3.1626>, <-0.3701, 48.4793, 1.803>, <0.6446, 50.8172, 2.1975> }
					triangle { <0.1288, 50.8671, 3.7388>, <-0.888, 48.6194, 3.1626>, <0.6446, 50.8172, 2.1975> }
					triangle { <0.1288, 50.8671, 3.7388>, <0.6446, 50.8172, 2.1975>, <1.9688, 52.8117, 2.6948> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		}
	union { // internode
		cylinder { <0.2007, 3.143, -0.2708>, <0.3206, 6.434, -0.4971>, 0.1131 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3206, 6.434, -0.4971>, <1.04862, 6.9926, -0.7145>, 0.05555 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <1.04862, 6.9926, -0.7145>, <1.9417, 7.5883, -1.01781>, <1.9853, 7.5814, -0.9346> }
			triangle { <1.9417, 7.5883, -1.01781>, <2.3485, 7.3934, -1.1484>, <1.9853, 7.5814, -0.9346> }
			triangle { <1.9417, 7.5883, -1.01781>, <2.2438, 7.4395, -1.2001>, <2.3485, 7.3934, -1.1484> }
			triangle { <2.3485, 7.3934, -1.1484>, <2.299, 7.4382, -1.0187>, <1.9853, 7.5814, -0.9346> }
			triangle { <1.9853, 7.5814, -0.9346>, <1.6587, 7.2973, -0.8194>, <1.04862, 6.9926, -0.7145> }
			triangle { <1.04862, 6.9926, -0.7145>, <1.6061, 7.304, -0.9784>, <1.9417, 7.5883, -1.01781> }
			triangle { <1.6061, 7.304, -0.9784>, <1.9537, 7.4901, -1.14>, <1.9417, 7.5883, -1.01781> }
			triangle { <1.9537, 7.4901, -1.14>, <2.2438, 7.4395, -1.2001>, <1.9417, 7.5883, -1.01781> }
			triangle { <1.9853, 7.5814, -0.9346>, <2.299, 7.4382, -1.0187>, <2.08581, 7.4626, -0.9035> }
			triangle { <2.08581, 7.4626, -0.9035>, <1.6587, 7.2973, -0.8194>, <1.9853, 7.5814, -0.9346> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.3206, 6.434, -0.4971>, <1.9888, 18.9928, -1.6667>, 0.4362 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.9888, 18.9928, -1.6667>, <4.8455, 20.7595, -2.4948>, 0.2037 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <4.8455, 20.7595, -2.4948>, <8.3161, 22.5998, -3.6428>, <8.4752, 22.5598, -3.3389> }
			triangle { <8.3161, 22.5998, -3.6428>, <9.7251, 21.7361, -4.13>, <8.4752, 22.5598, -3.3389> }
			triangle { <8.3161, 22.5998, -3.6428>, <9.3583, 21.9425, -4.3176>, <9.7251, 21.7361, -4.13> }
			triangle { <9.7251, 21.7361, -4.13>, <9.5648, 21.9199, -3.6535>, <8.4752, 22.5598, -3.3389> }
			triangle { <8.4752, 22.5598, -3.3389>, <7.1818, 21.6449, -2.9021>, <4.8455, 20.7595, -2.4948> }
			triangle { <4.8455, 20.7595, -2.4948>, <6.9874, 21.6864, -3.484>, <8.3161, 22.5998, -3.6428> }
			triangle { <6.9874, 21.6864, -3.484>, <8.3198, 22.2349, -4.08993>, <8.3161, 22.5998, -3.6428> }
			triangle { <8.3198, 22.2349, -4.08993>, <9.3583, 21.9425, -4.3176>, <8.3161, 22.5998, -3.6428> }
			triangle { <8.4752, 22.5598, -3.3389>, <9.5648, 21.9199, -3.6535>, <8.7989, 22.08948, -3.2256> }
			triangle { <8.7989, 22.08948, -3.2256>, <7.1818, 21.6449, -2.9021>, <8.4752, 22.5598, -3.3389> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.9888, 18.9928, -1.6667>, <1.7308, 35.6415, -3.3883>, 0.5739 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.7308, 35.6415, -3.3883>, <-3.3863, 39.08274, -4.09502>, 0.3656 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-3.3863, 39.08274, -4.09502>, <-9.7109, 42.7785, -4.6074>, <-9.8357, 42.5974, -5.1867> }
			triangle { <-9.7109, 42.7785, -4.6074>, <-12.4785, 41.459, -4.2134>, <-9.8357, 42.5974, -5.1867> }
			triangle { <-9.7109, 42.7785, -4.6074>, <-11.9188, 41.8866, -3.7806>, <-12.4785, 41.459, -4.2134> }
			triangle { <-12.4785, 41.459, -4.2134>, <-11.9415, 41.6032, -4.9964>, <-9.8357, 42.5974, -5.1867> }
			triangle { <-9.8357, 42.5974, -5.1867>, <-7.5011, 40.8146, -4.9302>, <-3.3863, 39.08274, -4.09502> }
			triangle { <-3.3863, 39.08274, -4.09502>, <-7.4556, 41.1009, -3.8656>, <-9.7109, 42.7785, -4.6074> }
			triangle { <-7.4556, 41.1009, -3.8656>, <-9.9855, 42.3037, -3.7291>, <-9.7109, 42.7785, -4.6074> }
			triangle { <-9.9855, 42.3037, -3.7291>, <-11.9188, 41.8866, -3.7806>, <-9.7109, 42.7785, -4.6074> }
			triangle { <-9.8357, 42.5974, -5.1867>, <-11.9415, 41.6032, -4.9964>, <-10.3901, 41.7335, -5.3792> }
			triangle { <-10.3901, 41.7335, -5.3792>, <-7.5011, 40.8146, -4.9302>, <-9.8357, 42.5974, -5.1867> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.7308, 35.6415, -3.3883>, <1.8883, 52.9051, -5.1441>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.8883, 52.9051, -5.1441>, <-4.5964, 57.7471, -6.08888>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-4.5964, 57.7471, -6.08888>, <-12.6492, 62.9993, -6.7852>, <-12.8204, 62.7724, -7.5473> }
			triangle { <-12.6492, 62.9993, -6.7852>, <-16.3648, 61.4446, -6.2919>, <-12.8204, 62.7724, -7.5473> }
			triangle { <-12.6492, 62.9993, -6.7852>, <-15.6064, 61.9677, -5.7182>, <-16.3648, 61.4446, -6.2919> }
			triangle { <-16.3648, 61.4446, -6.2919>, <-15.6462, 61.6027, -7.3156>, <-12.8204, 62.7724, -7.5473> }
			triangle { <-12.8204, 62.7724, -7.5473>, <-9.8752, 60.2845, -7.2037>, <-4.5964, 57.7471, -6.08888> }
			triangle { <-4.5964, 57.7471, -6.08888>, <-9.8043, 60.6524, -5.8047>, <-12.6492, 62.9993, -6.7852> }
			triangle { <-9.8043, 60.6524, -5.8047>, <-13.04539, 62.3906, -5.6362>, <-12.6492, 62.9993, -6.7852> }
			triangle { <-13.04539, 62.3906, -5.6362>, <-15.6064, 61.9677, -5.7182>, <-12.6492, 62.9993, -6.7852> }
			triangle { <-12.8204, 62.7724, -7.5473>, <-15.6462, 61.6027, -7.3156>, <-13.6013, 61.6759, -7.8076> }
			triangle { <-13.6013, 61.6759, -7.8076>, <-9.8752, 60.2845, -7.2037>, <-12.8204, 62.7724, -7.5473> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.8883, 52.9051, -5.1441>, <5.1765, 69.9382, -5.5894>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.1765, 69.9382, -5.5894>, <11.9468, 73.8004, -3.2153>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <11.9468, 73.8004, -3.2153>, <20.3337, 77.7564, -0.5832>, <20.2016, 77.6859, 0.2162> }
			triangle { <20.3337, 77.7564, -0.5832>, <23.569, 75.5724, 0.5255>, <20.2016, 77.6859, 0.2162> }
			triangle { <20.3337, 77.7564, -0.5832>, <23.1664, 76.06177, -0.3556>, <23.569, 75.5724, 0.5255> }
			triangle { <23.569, 75.5724, 0.5255>, <22.6199, 76.06992, 1.1896>, <20.2016, 77.6859, 0.2162> }
			triangle { <20.2016, 77.6859, 0.2162>, <17.03526, 75.6739, -0.7364>, <11.9468, 73.8004, -3.2153> }
			triangle { <11.9468, 73.8004, -3.2153>, <17.4914, 75.7187, -2.1102>, <20.3337, 77.7564, -0.5832> }
			triangle { <17.4914, 75.7187, -2.1102>, <20.9238, 76.8473, -1.4035>, <20.3337, 77.7564, -0.5832> }
			triangle { <20.9238, 76.8473, -1.4035>, <23.1664, 76.06177, -0.3556>, <20.3337, 77.7564, -0.5832> }
			triangle { <20.2016, 77.6859, 0.2162>, <22.6199, 76.06992, 1.1896>, <20.595, 76.5703, 0.9094> }
			triangle { <20.595, 76.5703, 0.9094>, <17.03526, 75.6739, -0.7364>, <20.2016, 77.6859, 0.2162> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <5.1765, 69.9382, -5.5894>, <8.7797, 86.9125, -5.754>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <8.7797, 86.9125, -5.754>, <5.08728, 92.7796, -10.0357>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <5.08728, 92.7796, -10.0357>, <0.09944, 99.315, -15.06845>, <0.4269, 99.1212, -15.7873> }
			triangle { <0.09944, 99.315, -15.06845>, <-3.2348, 98.4082, -17.196>, <0.4269, 99.1212, -15.7873> }
			triangle { <0.09944, 99.315, -15.06845>, <-2.9584, 98.7951, -16.2204>, <-3.2348, 98.4082, -17.196> }
			triangle { <-3.2348, 98.4082, -17.196>, <-2.01557, 98.4442, -17.5144>, <0.4269, 99.1212, -15.7873> }
			triangle { <0.4269, 99.1212, -15.7873>, <2.1214, 96.172, -13.9398>, <5.08728, 92.7796, -10.0357> }
			triangle { <5.08728, 92.7796, -10.0357>, <1.3291, 96.5208, -12.7786>, <0.09944, 99.315, -15.06845> }
			triangle { <1.3291, 96.5208, -12.7786>, <-1.01328, 98.7802, -14.4997>, <0.09944, 99.315, -15.06845> }
			triangle { <-1.01328, 98.7802, -14.4997>, <-2.9584, 98.7951, -16.2204>, <0.09944, 99.315, -15.06845> }
			triangle { <0.4269, 99.1212, -15.7873>, <-2.01557, 98.4442, -17.5144>, <-0.1405, 98.1723, -16.5981> }
			triangle { <-0.1405, 98.1723, -16.5981>, <2.1214, 96.172, -13.9398>, <0.4269, 99.1212, -15.7873> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <8.7797, 86.9125, -5.754>, <13.8068, 103.3482, -3.3595>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <13.8068, 103.3482, -3.3595>, <18.1704, 106.5866, 2.7118>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <18.1704, 106.5866, 2.7118>, <23.6663, 109.7599, 9.9674>, <23.07238, 109.7448, 10.5228> }
			triangle { <23.6663, 109.7599, 9.9674>, <25.3018, 107.3045, 12.7535>, <23.07238, 109.7448, 10.5228> }
			triangle { <23.6663, 109.7599, 9.9674>, <25.571, 107.7881, 11.8199>, <25.3018, 107.3045, 12.7535> }
			triangle { <25.3018, 107.3045, 12.7535>, <24.2096, 107.9332, 12.721>, <23.07238, 109.7448, 10.5228> }
			triangle { <23.07238, 109.7448, 10.5228>, <20.9128, 108.034, 7.8041>, <18.1704, 106.5866, 2.7118> }
			triangle { <18.1704, 106.5866, 2.7118>, <22.1058, 107.9598, 6.9862>, <23.6663, 109.7599, 9.9674> }
			triangle { <22.1058, 107.9598, 6.9862>, <24.5215, 108.7525, 9.649>, <23.6663, 109.7599, 9.9674> }
			triangle { <24.5215, 108.7525, 9.649>, <25.571, 107.7881, 11.8199>, <23.6663, 109.7599, 9.9674> }
			triangle { <23.07238, 109.7448, 10.5228>, <24.2096, 107.9332, 12.721>, <22.8367, 108.6307, 11.2864> }
			triangle { <22.8367, 108.6307, 11.2864>, <20.9128, 108.034, 7.8041>, <23.07238, 109.7448, 10.5228> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <13.8068, 103.3482, -3.3595>, <18.904, 119.697, -0.554>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <18.904, 119.697, -0.554>, <19.2774, 125.6796, -6.07293>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <19.2774, 125.6796, -6.07293>, <19.1485, 132.4348, -12.9481>, <19.8037, 132.1546, -13.3402> }
			triangle { <19.1485, 132.4348, -12.9481>, <17.6029, 131.8097, -16.6478>, <19.8037, 132.1546, -13.3402> }
			triangle { <19.1485, 132.4348, -12.9481>, <17.307, 132.2233, -15.689>, <17.6029, 131.8097, -16.6478> }
			triangle { <17.6029, 131.8097, -16.6478>, <18.7684, 131.6728, -16.1869>, <19.8037, 132.1546, -13.3402> }
			triangle { <19.8037, 132.1546, -13.3402>, <19.6652, 129.1471, -10.9075>, <19.2774, 125.6796, -6.07293> }
			triangle { <19.2774, 125.6796, -6.07293>, <18.4016, 129.668, -10.4284>, <19.1485, 132.4348, -12.9481> }
			triangle { <18.4016, 129.668, -10.4284>, <17.8522, 132.0814, -13.1538>, <19.1485, 132.4348, -12.9481> }
			triangle { <17.8522, 132.0814, -13.1538>, <17.307, 132.2233, -15.689>, <19.1485, 132.4348, -12.9481> }
			triangle { <19.8037, 132.1546, -13.3402>, <18.7684, 131.6728, -16.1869>, <19.6924, 131.2318, -14.3481> }
			triangle { <19.6924, 131.2318, -14.3481>, <19.6652, 129.1471, -10.9075>, <19.8037, 132.1546, -13.3402> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <18.904, 119.697, -0.554>, <23.9388, 135.9882, 2.6688>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <23.9388, 135.9882, 2.6688>, <24.3004, 139.4132, 10.05316>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <24.3004, 139.4132, 10.05316>, <24.8986, 142.7963, 19.05955>, <24.09507, 142.8571, 19.1698> }
			triangle { <24.8986, 142.7963, 19.05955>, <24.4101, 140.4653, 22.345>, <24.09507, 142.8571, 19.1698> }
			triangle { <24.8986, 142.7963, 19.05955>, <25.2085, 140.8615, 21.7257>, <24.4101, 140.4653, 22.345> }
			triangle { <24.4101, 140.4653, 22.345>, <23.5963, 141.1519, 21.67>, <24.09507, 142.8571, 19.1698> }
			triangle { <24.09507, 142.8571, 19.1698>, <23.7422, 141.0757, 15.7515>, <24.3004, 139.4132, 10.05316> }
			triangle { <24.3004, 139.4132, 10.05316>, <25.1759, 140.8719, 15.7759>, <24.8986, 142.7963, 19.05955> }
			triangle { <25.1759, 140.8719, 15.7759>, <25.6865, 141.7202, 19.3218>, <24.8986, 142.7963, 19.05955> }
			triangle { <25.6865, 141.7202, 19.3218>, <25.2085, 140.8615, 21.7257>, <24.8986, 142.7963, 19.05955> }
			triangle { <24.09507, 142.8571, 19.1698>, <23.5963, 141.1519, 21.67>, <23.3646, 141.8185, 19.6872> }
			triangle { <23.3646, 141.8185, 19.6872>, <23.7422, 141.0757, 15.7515>, <24.09507, 142.8571, 19.1698> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <23.9388, 135.9882, 2.6688>, <28.5938, 152.224, 6.652>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <28.5938, 152.224, 6.652>, <31.7006, 155.8405, 3.138>, 0.3489 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <31.7006, 155.8405, 3.138>, <35.1394, 159.8798, -1.4399>, <35.6557, 159.5972, -1.3843> }
			triangle { <35.1394, 159.8798, -1.4399>, <35.6349, 159.0879, -4.2378>, <35.6557, 159.5972, -1.3843> }
			triangle { <35.1394, 159.8798, -1.4399>, <35.1198, 159.5118, -3.8167>, <35.6349, 159.0879, -4.2378> }
			triangle { <35.6349, 159.0879, -4.2378>, <36.1286, 158.9788, -3.4735>, <35.6557, 159.5972, -1.3843> }
			triangle { <35.6557, 159.5972, -1.3843>, <34.2604, 157.7366, 0.1993>, <31.7006, 155.8405, 3.138> }
			triangle { <31.7006, 155.8405, 3.138>, <33.3736, 158.2353, -0.0714>, <35.1394, 159.8798, -1.4399> }
			triangle { <33.3736, 158.2353, -0.0714>, <34.4105, 159.6751, -2.0749>, <35.1394, 159.8798, -1.4399> }
			triangle { <34.4105, 159.6751, -2.0749>, <35.1198, 159.5118, -3.8167>, <35.1394, 159.8798, -1.4399> }
			triangle { <35.6557, 159.5972, -1.3843>, <36.1286, 158.9788, -3.4735>, <35.8912, 158.8259, -1.9699> }
			triangle { <35.8912, 158.8259, -1.9699>, <34.2604, 157.7366, 0.1993>, <35.6557, 159.5972, -1.3843> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <28.5938, 152.224, 6.652>, <32.3469, 168.4462, 11.5399>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <32.3469, 168.4462, 11.5399>, <32.03152, 168.8153, 12.05643>, 0.04176 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <32.03152, 168.8153, 12.05643>, <31.6483, 169.196, 12.6979>, <31.5878, 169.2079, 12.6632> }
			triangle { <31.6483, 169.196, 12.6979>, <31.4179, 169.0327, 12.9098>, <31.5878, 169.2079, 12.6632> }
			triangle { <31.6483, 169.196, 12.6979>, <31.5096, 169.0549, 12.907>, <31.4179, 169.0327, 12.9098> }
			triangle { <31.4179, 169.0327, 12.9098>, <31.4045, 169.0904, 12.8175>, <31.5878, 169.2079, 12.6632> }
			triangle { <31.5878, 169.2079, 12.6632>, <31.7187, 169.0214, 12.4152>, <32.03152, 168.8153, 12.05643> }
			triangle { <32.03152, 168.8153, 12.05643>, <31.8141, 168.9943, 12.4929>, <31.6483, 169.196, 12.6979> }
			triangle { <31.8141, 168.9943, 12.4929>, <31.6766, 169.1006, 12.7619>, <31.6483, 169.196, 12.6979> }
			triangle { <31.6766, 169.1006, 12.7619>, <31.5096, 169.0549, 12.907>, <31.6483, 169.196, 12.6979> }
			triangle { <31.5878, 169.2079, 12.6632>, <31.4045, 169.0904, 12.8175>, <31.4985, 169.1288, 12.6651> }
			triangle { <31.4985, 169.1288, 12.6651>, <31.7187, 169.0214, 12.4152>, <31.5878, 169.2079, 12.6632> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <32.3469, 168.4462, 11.5399>, <33.1914, 171.4734, 12.3823>, 0.1115 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <33.1914, 171.4734, 12.3823>, <33.6514, 171.7089, 12.2574>, 0.03132 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <33.6514, 171.7089, 12.2574>, <34.1953, 171.962, 12.0685>, <34.2257, 171.9334, 12.1014> }
			triangle { <34.1953, 171.962, 12.0685>, <34.3578, 171.8441, 11.8958>, <34.2257, 171.9334, 12.1014> }
			triangle { <34.1953, 171.962, 12.0685>, <34.3062, 171.8925, 11.8967>, <34.3578, 171.8441, 11.8958> }
			triangle { <34.3578, 171.8441, 11.8958>, <34.3541, 171.8421, 11.978>, <34.2257, 171.9334, 12.1014> }
			triangle { <34.2257, 171.9334, 12.1014>, <34.01502, 171.807, 12.1598>, <33.6514, 171.7089, 12.2574> }
			triangle { <33.6514, 171.7089, 12.2574>, <33.9718, 171.8544, 12.09037>, <34.1953, 171.962, 12.0685> }
			triangle { <33.9718, 171.8544, 12.09037>, <34.1704, 171.9404, 11.9861>, <34.1953, 171.962, 12.0685> }
			triangle { <34.1704, 171.9404, 11.9861>, <34.3062, 171.8925, 11.8967>, <34.1953, 171.962, 12.0685> }
			triangle { <34.2257, 171.9334, 12.1014>, <34.3541, 171.8421, 11.978>, <34.2595, 171.8543, 12.07683> }
			triangle { <34.2595, 171.8543, 12.07683>, <34.01502, 171.807, 12.1598>, <34.2257, 171.9334, 12.1014> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.7308, 35.6415, -3.3883>, <3.8231, 52.8491, -4.1996>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.8231, 52.8491, -4.1996>, <10.5031, 56.8791, -1.8489>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <10.5031, 56.8791, -1.8489>, <18.8014, 61.05621, 0.7218>, <18.6938, 60.95, 1.521> }
			triangle { <18.8014, 61.05621, 0.7218>, <22.1463, 58.9593, 1.661>, <18.6938, 60.95, 1.521> }
			triangle { <18.8014, 61.05621, 0.7218>, <21.7017, 59.466, 0.8104>, <22.1463, 58.9593, 1.661> }
			triangle { <22.1463, 58.9593, 1.661>, <21.1972, 59.3936, 2.3682>, <18.6938, 60.95, 1.521> }
			triangle { <18.6938, 60.95, 1.521>, <15.5817, 58.8537, 0.5711>, <10.5031, 56.8791, -1.8489> }
			triangle { <10.5031, 56.8791, -1.8489>, <15.9986, 58.9689, -0.811>, <18.8014, 61.05621, 0.7218> }
			triangle { <15.9986, 58.9689, -0.811>, <19.4033, 60.2029, -0.1482>, <18.8014, 61.05621, 0.7218> }
			triangle { <19.4033, 60.2029, -0.1482>, <21.7017, 59.466, 0.8104>, <18.8014, 61.05621, 0.7218> }
			triangle { <18.6938, 60.95, 1.521>, <21.1972, 59.3936, 2.3682>, <19.1479, 59.8249, 2.1596> }
			triangle { <19.1479, 59.8249, 2.1596>, <15.5817, 58.8537, 0.5711>, <18.6938, 60.95, 1.521> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <3.8231, 52.8491, -4.1996>, <3.7642, 54.4655, -4.6002>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <3.7642, 54.4655, -4.6002>, <3.4473, 55.9455, -5.297>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <3.4473, 55.9455, -5.297>, <2.8902, 57.1974, -6.245>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <2.8902, 57.1974, -6.245>, <2.1255, 58.1435, -7.3838>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <2.1255, 58.1435, -7.3838>, <1.3099, 59.3461, -8.1992>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.3099, 59.3461, -8.1992>, <0.03319, 61.5384, -9.2058>, 0.05871 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <0.03319, 61.5384, -9.2058>, <0.0004799, 63.8849, -11.06342>, <-1.1897, 63.5557, -10.08129> }
					triangle { <-1.1897, 63.5557, -10.08129>, <0.0004799, 63.8849, -11.06342>, <-0.901, 66.09782, -12.11> }
					triangle { <-1.1897, 63.5557, -10.08129>, <-0.901, 66.09782, -12.11>, <-2.3554, 65.8098, -10.8924> }
					triangle { <-0.901, 66.09782, -12.11>, <-3.08541, 68.1505, -11.4993>, <-2.3554, 65.8098, -10.8924> }
					triangle { <-1.1897, 63.5557, -10.08129>, <-1.9904, 63.7568, -8.8171>, <0.03319, 61.5384, -9.2058> }
					triangle { <-1.9904, 63.7568, -8.8171>, <-1.1897, 63.5557, -10.08129>, <-2.3554, 65.8098, -10.8924> }
					triangle { <-3.1343, 66.03188, -9.4208>, <-1.9904, 63.7568, -8.8171>, <-2.3554, 65.8098, -10.8924> }
					triangle { <-3.1343, 66.03188, -9.4208>, <-2.3554, 65.8098, -10.8924>, <-3.08541, 68.1505, -11.4993> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <0.03319, 61.5384, -9.2058>, <-2.3012, 62.736, -10.6459>, <-1.08508, 63.5962, -10.1257> }
					triangle { <-1.08508, 63.5962, -10.1257>, <-2.3012, 62.736, -10.6459>, <-3.6836, 64.6085, -11.824> }
					triangle { <-1.08508, 63.5962, -10.1257>, <-3.6836, 64.6085, -11.824>, <-2.2082, 65.7127, -11.2904> }
					triangle { <-3.6836, 64.6085, -11.824>, <-3.2293, 67.4785, -12.7804>, <-2.2082, 65.7127, -11.2904> }
					triangle { <-1.08508, 63.5962, -10.1257>, <0.2088, 64.3524, -10.3095>, <0.03319, 61.5384, -9.2058> }
					triangle { <0.2088, 64.3524, -10.3095>, <-1.08508, 63.5962, -10.1257>, <-2.2082, 65.7127, -11.2904> }
					triangle { <-0.7246, 66.4522, -11.5618>, <0.2088, 64.3524, -10.3095>, <-2.2082, 65.7127, -11.2904> }
					triangle { <-0.7246, 66.4522, -11.5618>, <-2.2082, 65.7127, -11.2904>, <-3.2293, 67.4785, -12.7804> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <0.03319, 61.5384, -9.2058>, <-1.2109, 64.2272, -8.7814>, <-1.1561, 63.524, -10.1928> }
					triangle { <-1.1561, 63.524, -10.1928>, <-1.2109, 64.2272, -8.7814>, <-2.5506, 66.373, -9.4182> }
					triangle { <-1.1561, 63.524, -10.1928>, <-2.5506, 66.373, -9.4182>, <-2.5922, 65.5527, -11.152> }
					triangle { <-2.5506, 66.373, -9.4182>, <-4.2672, 67.344, -11.7566>, <-2.5922, 65.5527, -11.152> }
					triangle { <-1.1561, 63.524, -10.1928>, <-1.7583, 62.7371, -11.3321>, <0.03319, 61.5384, -9.2058> }
					triangle { <-1.7583, 62.7371, -11.3321>, <-1.1561, 63.524, -10.1928>, <-2.5922, 65.5527, -11.152> }
					triangle { <-3.308, 64.5943, -12.3313>, <-1.7583, 62.7371, -11.3321>, <-2.5922, 65.5527, -11.152> }
					triangle { <-3.308, 64.5943, -12.3313>, <-2.5922, 65.5527, -11.152>, <-4.2672, 67.344, -11.7566> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <1.3099, 59.3461, -8.1992>, <0.7782, 60.4703, -9.3083>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.7782, 60.4703, -9.3083>, <0.1542, 62.1294, -11.3837>, 0.05871 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <0.1542, 62.1294, -11.3837>, <-1.7729, 63.01672, -13.4947>, <-0.3539, 63.6787, -13.3002> }
					triangle { <-0.3539, 63.6787, -13.3002>, <-1.7729, 63.01672, -13.4947>, <-2.5917, 64.3521, -15.5807> }
					triangle { <-0.3539, 63.6787, -13.3002>, <-2.5917, 64.3521, -15.5807>, <-0.8549, 65.158, -15.4585> }
					triangle { <-2.5917, 64.3521, -15.5807>, <-1.3629, 66.1595, -17.7211>, <-0.8549, 65.158, -15.4585> }
					triangle { <-0.3539, 63.6787, -13.3002>, <1.09717, 63.889, -13.6602>, <0.1542, 62.1294, -11.3837> }
					triangle { <1.09717, 63.889, -13.6602>, <-0.3539, 63.6787, -13.3002>, <-0.8549, 65.158, -15.4585> }
					triangle { <0.7718, 65.2631, -15.8636>, <1.09717, 63.889, -13.6602>, <-0.8549, 65.158, -15.4585> }
					triangle { <0.7718, 65.2631, -15.8636>, <-0.8549, 65.158, -15.4585>, <-1.3629, 66.1595, -17.7211> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <0.1542, 62.1294, -11.3837>, <-0.3075, 64.8933, -12.435>, <-0.4422, 63.6035, -13.3338> }
					triangle { <-0.4422, 63.6035, -13.3338>, <-0.3075, 64.8933, -12.435>, <-1.006044, 66.7079, -14.1741> }
					triangle { <-0.4422, 63.6035, -13.3338>, <-1.006044, 66.7079, -14.1741>, <-1.2643, 65.1859, -15.3132> }
					triangle { <-1.006044, 66.7079, -14.1741>, <-2.3825, 66.7975, -16.9045>, <-1.2643, 65.1859, -15.3132> }
					triangle { <-0.4422, 63.6035, -13.3338>, <-1.2326, 62.5315, -14.04501>, <0.1542, 62.1294, -11.3837> }
					triangle { <-1.2326, 62.5315, -14.04501>, <-0.4422, 63.6035, -13.3338>, <-1.2643, 65.1859, -15.3132> }
					triangle { <-2.2108, 63.9772, -15.9949>, <-1.2326, 62.5315, -14.04501>, <-1.2643, 65.1859, -15.3132> }
					triangle { <-2.2108, 63.9772, -15.9949>, <-1.2643, 65.1859, -15.3132>, <-2.3825, 66.7975, -16.9045> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <0.1542, 62.1294, -11.3837>, <0.7514, 63.1829, -14.1207>, <-0.465, 63.6933, -13.2551> }
					triangle { <-0.465, 63.6933, -13.2551>, <0.7514, 63.1829, -14.1207>, <0.4924, 64.7439, -16.1946> }
					triangle { <-0.465, 63.6933, -13.2551>, <0.4924, 64.7439, -16.1946>, <-0.9613, 65.4715, -15.1759> }
					triangle { <0.4924, 64.7439, -16.1946>, <-1.01149, 67.311, -16.9063>, <-0.9613, 65.4715, -15.1759> }
					triangle { <-0.465, 63.6933, -13.2551>, <-1.1528, 64.6848, -12.3476>, <0.1542, 62.1294, -11.3837> }
					triangle { <-1.1528, 64.6848, -12.3476>, <-0.465, 63.6933, -13.2551>, <-0.9613, 65.4715, -15.1759> }
					triangle { <-1.6185, 66.5766, -14.095>, <-1.1528, 64.6848, -12.3476>, <-0.9613, 65.4715, -15.1759> }
					triangle { <-1.6185, 66.5766, -14.095>, <-0.9613, 65.4715, -15.1759>, <-1.01149, 67.311, -16.9063> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <0.7782, 60.4703, -9.3083>, <-0.1277, 61.4555, -10.3008>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.1277, 61.4555, -10.3008>, <-1.9274, 62.9453, -11.7117>, 0.05871 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <-1.9274, 62.9453, -11.7117>, <-3.129, 65.6063, -12.3699>, <-3.6196, 64.26, -13.03067> }
					triangle { <-3.6196, 64.26, -13.03067>, <-3.129, 65.6063, -12.3699>, <-4.8205, 67.2657, -13.4608> }
					triangle { <-3.6196, 64.26, -13.03067>, <-4.8205, 67.2657, -13.4608>, <-5.5251, 65.666, -14.2515> }
					triangle { <-4.8205, 67.2657, -13.4608>, <-7.4676, 67.104, -14.9857>, <-5.5251, 65.666, -14.2515> }
					triangle { <-3.6196, 64.26, -13.03067>, <-4.5727, 63.09823, -13.1769>, <-1.9274, 62.9453, -11.7117> }
					triangle { <-4.5727, 63.09823, -13.1769>, <-3.6196, 64.26, -13.03067>, <-5.5251, 65.666, -14.2515> }
					triangle { <-6.5801, 64.3593, -14.2856>, <-4.5727, 63.09823, -13.1769>, <-5.5251, 65.666, -14.2515> }
					triangle { <-6.5801, 64.3593, -14.2856>, <-5.5251, 65.666, -14.2515>, <-7.4676, 67.104, -14.9857> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-1.9274, 62.9453, -11.7117>, <-2.9959, 63.9032, -14.3382>, <-3.6046, 64.3515, -12.9532> }
					triangle { <-3.6046, 64.3515, -12.9532>, <-2.9959, 63.9032, -14.3382>, <-4.4788, 65.327, -15.9441> }
					triangle { <-3.6046, 64.3515, -12.9532>, <-4.4788, 65.327, -15.9441>, <-5.2266, 65.9787, -14.302> }
					triangle { <-4.4788, 65.327, -15.9441>, <-6.3784, 67.7152, -15.7297>, <-5.2266, 65.9787, -14.302> }
					triangle { <-3.6046, 64.3515, -12.9532>, <-3.7956, 65.3258, -11.8157>, <-1.9274, 62.9453, -11.7117> }
					triangle { <-3.7956, 65.3258, -11.8157>, <-3.6046, 64.3515, -12.9532>, <-5.2266, 65.9787, -14.302> }
					triangle { <-5.3105, 67.07777, -13.03442>, <-3.7956, 65.3258, -11.8157>, <-5.2266, 65.9787, -14.302> }
					triangle { <-5.3105, 67.07777, -13.03442>, <-5.2266, 65.9787, -14.302>, <-6.3784, 67.7152, -15.7297> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <-1.9274, 62.9453, -11.7117>, <-4.7642, 63.5777, -12.4262>, <-3.5343, 64.3428, -13.05207> }
					triangle { <-3.5343, 64.3428, -13.05207>, <-4.7642, 63.5777, -12.4262>, <-6.7036, 64.7316, -13.7348> }
					triangle { <-3.5343, 64.3428, -13.05207>, <-6.7036, 64.7316, -13.7348>, <-5.2613, 65.6569, -14.5976> }
					triangle { <-6.7036, 64.7316, -13.7348>, <-7.00923, 66.4885, -16.2204>, <-5.2613, 65.6569, -14.5976> }
					triangle { <-3.5343, 64.3428, -13.05207>, <-2.5413, 64.6276, -14.1531>, <-1.9274, 62.9453, -11.7117> }
					triangle { <-2.5413, 64.6276, -14.1531>, <-3.5343, 64.3428, -13.05207>, <-5.2613, 65.6569, -14.5976> }
					triangle { <-4.1373, 65.846, -15.8315>, <-2.5413, 64.6276, -14.1531>, <-5.2613, 65.6569, -14.5976> }
					triangle { <-4.1373, 65.846, -15.8315>, <-5.2613, 65.6569, -14.5976>, <-7.00923, 66.4885, -16.2204> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.8231, 52.8491, -4.1996>, <3.9895, 54.4728, -3.8641>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <3.9895, 54.4728, -3.8641>, <4.512, 55.9275, -3.2418>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.512, 55.9275, -3.2418>, <5.5833, 58.3434, -2.5597>, 0.05871 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <5.5833, 58.3434, -2.5597>, <5.2748, 61.2981, -2.1963>, <6.6347, 60.5421, -1.9338> }
					triangle { <6.6347, 60.5421, -1.9338>, <5.2748, 61.2981, -2.1963>, <6.04695, 63.7483, -1.7425> }
					triangle { <6.6347, 60.5421, -1.9338>, <6.04695, 63.7483, -1.7425>, <7.7546, 62.9156, -1.4757> }
					triangle { <6.04695, 63.7483, -1.7425>, <8.6916, 65.2614, -1.4703>, <7.7546, 62.9156, -1.4757> }
					triangle { <6.6347, 60.5421, -1.9338>, <8.03111, 60.1079, -2.3097>, <5.5833, 58.3434, -2.5597> }
					triangle { <8.03111, 60.1079, -2.3097>, <6.6347, 60.5421, -1.9338>, <7.7546, 62.9156, -1.4757> }
					triangle { <9.261, 62.3984, -2.009607>, <8.03111, 60.1079, -2.3097>, <7.7546, 62.9156, -1.4757> }
					triangle { <9.261, 62.3984, -2.009607>, <7.7546, 62.9156, -1.4757>, <8.6916, 65.2614, -1.4703> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.5833, 58.3434, -2.5597>, <6.8876, 60.1119, -0.5277>, <6.543, 60.5983, -1.9886> }
					triangle { <6.543, 60.5983, -1.9886>, <6.8876, 60.1119, -0.5277>, <7.8386, 62.3332, 0.4552> }
					triangle { <6.543, 60.5983, -1.9886>, <7.8386, 62.3332, 0.4552>, <7.3834, 63.02388, -1.2758> }
					triangle { <7.8386, 62.3332, 0.4552>, <7.8486, 65.301, -0.2866>, <7.3834, 63.02388, -1.2758> }
					triangle { <6.543, 60.5983, -1.9886>, <5.7005, 61.3366, -3.001041>, <5.5833, 58.3434, -2.5597> }
					triangle { <5.7005, 61.3366, -3.001041>, <6.543, 60.5983, -1.9886>, <7.3834, 63.02388, -1.2758> }
					triangle { <6.3422, 63.7887, -2.3494>, <5.7005, 61.3366, -3.001041>, <7.3834, 63.02388, -1.2758> }
					triangle { <6.3422, 63.7887, -2.3494>, <7.3834, 63.02388, -1.2758>, <7.8486, 65.301, -0.2866> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.5833, 58.3434, -2.5597>, <7.6128, 60.4943, -3.02106>, <6.535, 60.5686, -1.871> }
					triangle { <6.535, 60.5686, -1.871>, <7.6128, 60.4943, -3.02106>, <8.9303, 62.6898, -2.5224> }
					triangle { <6.535, 60.5686, -1.871>, <8.9303, 62.6898, -2.5224>, <7.7021, 62.82, -1.05435> }
					triangle { <8.9303, 62.6898, -2.5224>, <9.1791, 64.6933, -0.2241>, <7.7021, 62.82, -1.05435> }
					triangle { <6.535, 60.5686, -1.871>, <6.08281, 60.4429, -0.4359>, <5.5833, 58.3434, -2.5597> }
					triangle { <6.08281, 60.4429, -0.4359>, <6.535, 60.5686, -1.871>, <7.7021, 62.82, -1.05435> }
					triangle { <7.2583, 62.5651, 0.5455>, <6.08281, 60.4429, -0.4359>, <7.7021, 62.82, -1.05435> }
					triangle { <7.2583, 62.5651, 0.5455>, <7.7021, 62.82, -1.05435>, <9.1791, 64.6933, -0.2241> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.9895, 54.4728, -3.8641>, <3.7858, 56.1264, -3.844>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.7858, 56.1264, -3.844>, <3.2337, 58.7744, -3.4797>, 0.05871 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <3.2337, 58.7744, -3.4797>, <4.1258, 61.5132, -2.6667>, <2.6565, 61.2012, -3.1499> }
					triangle { <2.6565, 61.2012, -3.1499>, <4.1258, 61.5132, -2.6667>, <3.8645, 64.04411, -2.09125> }
					triangle { <2.6565, 61.2012, -3.1499>, <3.8645, 64.04411, -2.09125>, <2.0395, 63.7328, -2.5944> }
					triangle { <3.8645, 64.04411, -2.09125>, <1.5781, 66.02602, -1.6412>, <2.0395, 63.7328, -2.5944> }
					triangle { <2.6565, 61.2012, -3.1499>, <1.1884, 60.9353, -2.9186>, <3.2337, 58.7744, -3.4797> }
					triangle { <1.1884, 60.9353, -2.9186>, <2.6565, 61.2012, -3.1499>, <2.0395, 63.7328, -2.5944> }
					triangle { <0.441, 63.3516, -2.2462>, <1.1884, 60.9353, -2.9186>, <2.0395, 63.7328, -2.5944> }
					triangle { <0.441, 63.3516, -2.2462>, <2.0395, 63.7328, -2.5944>, <1.5781, 66.02602, -1.6412> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <3.2337, 58.7744, -3.4797>, <2.3815, 61.4155, -4.6006>, <2.7551, 61.2123, -3.08114> }
					triangle { <2.7551, 61.2123, -3.08114>, <2.3815, 61.4155, -4.6006>, <1.9214, 63.9832, -4.5939> }
					triangle { <2.7551, 61.2123, -3.08114>, <1.9214, 63.9832, -4.5939>, <2.4324, 63.8362, -2.7505> }
					triangle { <1.9214, 63.9832, -4.5939>, <2.4596, 66.362, -2.7472>, <2.4324, 63.8362, -2.7505> }
					triangle { <2.7551, 61.2123, -3.08114>, <3.6838, 61.3148, -1.895>, <3.2337, 58.7744, -3.4797> }
					triangle { <3.6838, 61.3148, -1.895>, <2.7551, 61.2123, -3.08114>, <2.4324, 63.8362, -2.7505> }
					triangle { <3.5585, 63.8997, -1.5057>, <3.6838, 61.3148, -1.895>, <2.4324, 63.8362, -2.7505> }
					triangle { <3.5585, 63.8997, -1.5057>, <2.4324, 63.8362, -2.7505>, <2.4596, 66.362, -2.7472> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <3.2337, 58.7744, -3.4797>, <1.6449, 60.922, -2.1302>, <2.7619, 61.2303, -3.2012> }
					triangle { <2.7619, 61.2303, -3.2012>, <1.6449, 60.922, -2.1302>, <0.8012, 63.3479, -1.6739> }
					triangle { <2.7619, 61.2303, -3.2012>, <0.8012, 63.3479, -1.6739>, <2.08935, 63.8019, -3.02129> }
					triangle { <0.8012, 63.3479, -1.6739>, <1.03991, 66.09932, -2.9897>, <2.08935, 63.8019, -3.02129> }
					triangle { <2.7619, 61.2303, -3.2012>, <3.2384, 61.5923, -4.5874>, <3.2337, 58.7744, -3.4797> }
					triangle { <3.2384, 61.5923, -4.5874>, <2.7619, 61.2303, -3.2012>, <2.08935, 63.8019, -3.02129> }
					triangle { <2.539, 64.1141, -4.6093>, <3.2384, 61.5923, -4.5874>, <2.08935, 63.8019, -3.02129> }
					triangle { <2.539, 64.1141, -4.6093>, <2.08935, 63.8019, -3.02129>, <1.03991, 66.09932, -2.9897> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.9895, 54.4728, -3.8641>, <4.4529, 56.07275, -3.8187>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <4.4529, 56.07275, -3.8187>, <4.8218, 57.6393, -4.2503>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.8218, 57.6393, -4.2503>, <5.05377, 60.2949, -4.8362>, 0.05871 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <5.05377, 60.2949, -4.8362>, <6.1614, 62.9984, -4.1866>, <5.2145, 62.7369, -5.4213> }
					triangle { <5.2145, 62.7369, -5.4213>, <6.1614, 62.9984, -4.1866>, <6.4579, 65.5807, -4.4074> }
					triangle { <5.2145, 62.7369, -5.4213>, <6.4579, 65.5807, -4.4074>, <5.2518, 65.3605, -5.883> }
					triangle { <6.4579, 65.5807, -4.4074>, <5.1066, 67.8821, -5.9025>, <5.2518, 65.3605, -5.883> }
					triangle { <5.2145, 62.7369, -5.4213>, <3.8813, 62.7689, -6.1295>, <5.05377, 60.2949, -4.8362> }
					triangle { <3.8813, 62.7689, -6.1295>, <5.2145, 62.7369, -5.4213>, <5.2518, 65.3605, -5.883> }
					triangle { <3.7164, 65.3443, -6.5643>, <3.8813, 62.7689, -6.1295>, <5.2518, 65.3605, -5.883> }
					triangle { <3.7164, 65.3443, -6.5643>, <5.2518, 65.3605, -5.883>, <5.1066, 67.8821, -5.9025> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.05377, 60.2949, -4.8362>, <5.8906, 62.4625, -6.7227>, <5.2544, 62.7581, -5.3094> }
					triangle { <5.2544, 62.7581, -5.3094>, <5.8906, 62.4625, -6.7227>, <6.3679, 64.9057, -7.5024> }
					triangle { <5.2544, 62.7581, -5.3094>, <6.3679, 64.9057, -7.5024>, <5.672, 65.3486, -5.7702> }
					triangle { <6.3679, 64.9057, -7.5024>, <6.5083, 67.6864, -6.235>, <5.672, 65.3486, -5.7702> }
					triangle { <5.2544, 62.7581, -5.3094>, <5.3268, 63.1451, -3.8518>, <5.05377, 60.2949, -4.8362> }
					triangle { <5.3268, 63.1451, -3.8518>, <5.2544, 62.7581, -5.3094>, <5.672, 65.3486, -5.7702> }
					triangle { <5.849, 65.6938, -4.1359>, <5.3268, 63.1451, -3.8518>, <5.672, 65.3486, -5.7702> }
					triangle { <5.849, 65.6938, -4.1359>, <5.672, 65.3486, -5.7702>, <6.5083, 67.6864, -6.235> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <5.05377, 60.2949, -4.8362>, <3.7809, 62.9723, -5.247>, <5.3329, 62.7316, -5.3984> }
					triangle { <5.3329, 62.7316, -5.3984>, <3.7809, 62.9723, -5.247>, <3.6673, 65.4937, -5.9066> }
					triangle { <5.3329, 62.7316, -5.3984>, <3.6673, 65.4937, -5.9066>, <5.5522, 65.2678, -6.1841> }
					triangle { <3.6673, 65.4937, -5.9066>, <5.4795, 67.5484, -7.2675>, <5.5522, 65.2678, -6.1841> }
					triangle { <5.3329, 62.7316, -5.3984>, <6.5924, 62.5159, -6.2027>, <5.05377, 60.2949, -4.8362> }
					triangle { <6.5924, 62.5159, -6.2027>, <5.3329, 62.7316, -5.3984>, <5.5522, 65.2678, -6.1841> }
					triangle { <6.8887, 64.9387, -7.1469>, <6.5924, 62.5159, -6.2027>, <5.5522, 65.2678, -6.1841> }
					triangle { <6.8887, 64.9387, -7.1469>, <5.5522, 65.2678, -6.1841>, <5.4795, 67.5484, -7.2675> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.4529, 56.07275, -3.8187>, <4.9711, 57.5691, -3.3004>, 0.05871 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.9711, 57.5691, -3.3004>, <6.1842, 59.9033, -2.5731>, 0.05871 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <6.1842, 59.9033, -2.5731>, <6.7013, 62.8102, -3.0638>, <7.3435, 62.01937, -1.8588> }
					triangle { <7.3435, 62.01937, -1.8588>, <6.7013, 62.8102, -3.0638>, <7.8263, 65.1361, -2.7039> }
					triangle { <7.3435, 62.01937, -1.8588>, <7.8263, 65.1361, -2.7039>, <8.706, 64.2291, -1.2602> }
					triangle { <7.8263, 65.1361, -2.7039>, <10.175, 66.2786, -1.1112>, <8.706, 64.2291, -1.2602> }
					triangle { <7.3435, 62.01937, -1.8588>, <8.4768, 61.2975, -1.1702>, <6.1842, 59.9033, -2.5731> }
					triangle { <8.4768, 61.2975, -1.1702>, <7.3435, 62.01937, -1.8588>, <8.706, 64.2291, -1.2602> }
					triangle { <9.9849, 63.36, -0.604>, <8.4768, 61.2975, -1.1702>, <8.706, 64.2291, -1.2602> }
					triangle { <9.9849, 63.36, -0.604>, <8.706, 64.2291, -1.2602>, <10.175, 66.2786, -1.1112> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <6.1842, 59.9033, -2.5731>, <6.6057, 62.08094, -0.5635>, <7.3228, 62.06443, -1.9689> }
					triangle { <7.3228, 62.06443, -1.9689>, <6.6057, 62.08094, -0.5635>, <7.4951, 64.3568, 0.3498> }
					triangle { <7.3228, 62.06443, -1.9689>, <7.4951, 64.3568, 0.3498>, <8.3461, 64.4494, -1.3671> }
					triangle { <7.4951, 64.3568, 0.3498>, <8.8805, 66.8445, -0.7683>, <8.3461, 64.4494, -1.3671> }
					triangle { <7.3228, 62.06443, -1.9689>, <7.4903, 62.5058, -3.4031>, <6.1842, 59.9033, -2.5731> }
					triangle { <7.4903, 62.5058, -3.4031>, <7.3228, 62.06443, -1.9689>, <8.3461, 64.4494, -1.3671> }
					triangle { <8.4055, 64.9206, -2.9783>, <7.4903, 62.5058, -3.4031>, <8.3461, 64.4494, -1.3671> }
					triangle { <8.4055, 64.9206, -2.9783>, <8.3461, 64.4494, -1.3671>, <8.8805, 66.8445, -0.7683> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				mesh { // fruit section
					triangle { <6.1842, 59.9033, -2.5731>, <8.6838, 61.4616, -2.04231>, <7.2409, 62.07935, -1.8802> }
					triangle { <7.2409, 62.07935, -1.8802>, <8.6838, 61.4616, -2.04231>, <10.1162, 63.4942, -1.2536> }
					triangle { <7.2409, 62.07935, -1.8802>, <10.1162, 63.4942, -1.2536>, <8.398, 64.2956, -0.9599> }
					triangle { <10.1162, 63.4942, -1.2536>, <9.6609, 66.1248, 0.2399>, <8.398, 64.2956, -0.9599> }
					triangle { <7.2409, 62.07935, -1.8802>, <6.04895, 62.5279, -1.06939>, <6.1842, 59.9033, -2.5731> }
					triangle { <6.04895, 62.5279, -1.06939>, <7.2409, 62.07935, -1.8802>, <8.398, 64.2956, -0.9599> }
					triangle { <7.07789, 64.6813, 0.004465>, <6.04895, 62.5279, -1.06939>, <8.398, 64.2956, -0.9599> }
					triangle { <7.07789, 64.6813, 0.004465>, <8.398, 64.2956, -0.9599>, <9.6609, 66.1248, 0.2399> }
					pigment { color rgb <0.0, 0.78, 0.78> }}
				}
			}
		}
	union { // internode
		cylinder { <0.3206, 6.434, -0.4971>, <0.5786, 13.5147, -0.9838>, 0.2435 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.5786, 13.5147, -0.9838>, <-0.9678, 14.8733, -1.1916>, 0.1218 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-0.9678, 14.8733, -1.1916>, <-2.9079, 16.3575, -1.3475>, <-2.9437, 16.3209, -1.5476> }
			triangle { <-2.9079, 16.3575, -1.3475>, <-3.8808, 16.02011, -1.3094>, <-2.9437, 16.3209, -1.5476> }
			triangle { <-2.9079, 16.3575, -1.3475>, <-3.6888, 16.1253, -1.142>, <-3.8808, 16.02011, -1.3094> }
			triangle { <-3.8808, 16.02011, -1.3094>, <-3.6813, 16.0708, -1.5546>, <-2.9437, 16.3209, -1.5476> }
			triangle { <-2.9437, 16.3209, -1.5476>, <-2.2448, 15.633, -1.4818>, <-0.9678, 14.8733, -1.1916> }
			triangle { <-0.9678, 14.8733, -1.1916>, <-2.2415, 15.6923, -1.1188>, <-2.9079, 16.3575, -1.3475> }
			triangle { <-2.2415, 15.6923, -1.1188>, <-3.03523, 16.1845, -1.07739>, <-2.9079, 16.3575, -1.3475> }
			triangle { <-3.03523, 16.1845, -1.07739>, <-3.6888, 16.1253, -1.142>, <-2.9079, 16.3575, -1.3475> }
			triangle { <-2.9437, 16.3209, -1.5476>, <-3.6813, 16.0708, -1.5546>, <-3.1555, 16.06423, -1.65> }
			triangle { <-3.1555, 16.06423, -1.65>, <-2.2448, 15.633, -1.4818>, <-2.9437, 16.3209, -1.5476> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.5786, 13.5147, -0.9838>, <0.3596, 30.8215, -2.2343>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3596, 30.8215, -2.2343>, <-6.2289, 35.5464, -3.04385>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-6.2289, 35.5464, -3.04385>, <-14.3943, 40.6397, -3.5946>, <-14.5603, 40.4315, -4.3632> }
			triangle { <-14.3943, 40.6397, -3.5946>, <-18.07535, 38.9905, -3.1508>, <-14.5603, 40.4315, -4.3632> }
			triangle { <-14.3943, 40.6397, -3.5946>, <-17.3287, 39.513, -2.5612>, <-18.07535, 38.9905, -3.1508> }
			triangle { <-18.07535, 38.9905, -3.1508>, <-17.3599, 39.194, -4.1687>, <-14.5603, 40.4315, -4.3632> }
			triangle { <-14.5603, 40.4315, -4.3632>, <-11.5615, 37.9995, -4.08952>, <-6.2289, 35.5464, -3.04385> }
			triangle { <-6.2289, 35.5464, -3.04385>, <-11.4992, 38.3278, -2.6802>, <-14.3943, 40.6397, -3.5946> }
			triangle { <-11.4992, 38.3278, -2.6802>, <-14.7775, 39.9892, -2.4643>, <-14.3943, 40.6397, -3.5946> }
			triangle { <-14.7775, 39.9892, -2.4643>, <-17.3287, 39.513, -2.5612>, <-14.3943, 40.6397, -3.5946> }
			triangle { <-14.5603, 40.4315, -4.3632>, <-17.3599, 39.194, -4.1687>, <-15.3169, 39.3262, -4.6562> }
			triangle { <-15.3169, 39.3262, -4.6562>, <-11.5615, 37.9995, -4.08952>, <-14.5603, 40.4315, -4.3632> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.3596, 30.8215, -2.2343>, <2.1063, 48.08115, -2.6708>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.1063, 48.08115, -2.6708>, <8.3135, 52.8605, -0.4308>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <8.3135, 52.8605, -0.4308>, <16.1088, 57.943, 2.0832>, <15.9699, 57.9014, 2.8835> }
			triangle { <16.1088, 57.943, 2.0832>, <19.5598, 56.2317, 3.3594>, <15.9699, 57.9014, 2.8835> }
			triangle { <16.1088, 57.943, 2.0832>, <19.1194, 56.6191, 2.4462>, <19.5598, 56.2317, 3.3594> }
			triangle { <19.5598, 56.2317, 3.3594>, <18.5444, 56.6466, 3.9809>, <15.9699, 57.9014, 2.8835> }
			triangle { <15.9699, 57.9014, 2.8835>, <13.08834, 55.471, 2.005179>, <8.3135, 52.8605, -0.4308> }
			triangle { <8.3135, 52.8605, -0.4308>, <13.5638, 55.4945, 0.6373>, <16.1088, 57.943, 2.0832> }
			triangle { <13.5638, 55.4945, 0.6373>, <16.8205, 57.06803, 1.3246>, <16.1088, 57.943, 2.0832> }
			triangle { <16.8205, 57.06803, 1.3246>, <19.1194, 56.6191, 2.4462>, <16.1088, 57.943, 2.0832> }
			triangle { <15.9699, 57.9014, 2.8835>, <18.5444, 56.6466, 3.9809>, <16.4802, 56.8818, 3.6449> }
			triangle { <16.4802, 56.8818, 3.6449>, <13.08834, 55.471, 2.005179>, <15.9699, 57.9014, 2.8835> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <2.1063, 48.08115, -2.6708>, <2.5631, 65.3592, -4.2189>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.5631, 65.3592, -4.2189>, <-2.281, 69.9427, -8.9003>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-2.281, 69.9427, -8.9003>, <-8.5431, 74.8588, -14.335>, <-8.2051, 74.6507, -15.04494> }
			triangle { <-8.5431, 74.8588, -14.335>, <-11.7056, 73.1274, -16.1971>, <-8.2051, 74.6507, -15.04494> }
			triangle { <-8.5431, 74.8588, -14.335>, <-11.4799, 73.6632, -15.2807>, <-11.7056, 73.1274, -16.1971> }
			triangle { <-11.7056, 73.1274, -16.1971>, <-10.524, 73.3514, -16.5752>, <-8.2051, 74.6507, -15.04494> }
			triangle { <-8.2051, 74.6507, -15.04494>, <-5.9372, 72.2835, -12.9869>, <-2.281, 69.9427, -8.9003> }
			triangle { <-2.281, 69.9427, -8.9003>, <-6.7484, 72.6064, -11.8313>, <-8.5431, 74.8588, -14.335> }
			triangle { <-6.7484, 72.6064, -11.8313>, <-9.5197, 74.1946, -13.6621>, <-8.5431, 74.8588, -14.335> }
			triangle { <-9.5197, 74.1946, -13.6621>, <-11.4799, 73.6632, -15.2807>, <-8.5431, 74.8588, -14.335> }
			triangle { <-8.2051, 74.6507, -15.04494>, <-10.524, 73.3514, -16.5752>, <-8.6067, 73.5306, -15.726> }
			triangle { <-8.6067, 73.5306, -15.726>, <-5.9372, 72.2835, -12.9869>, <-8.2051, 74.6507, -15.04494> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <2.5631, 65.3592, -4.2189>, <3.2401, 82.6588, -5.4032>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.2401, 82.6588, -5.4032>, <6.636, 88.2008, -0.4896>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <6.636, 88.2008, -0.4896>, <11.1299, 94.2321, 5.5392>, <10.5474, 94.218, 6.1066> }
			triangle { <11.1299, 94.2321, 5.5392>, <13.2493, 92.9788, 8.7648>, <10.5474, 94.218, 6.1066> }
			triangle { <11.1299, 94.2321, 5.5392>, <13.4128, 93.2668, 7.7312>, <13.2493, 92.9788, 8.7648> }
			triangle { <13.2493, 92.9788, 8.7648>, <12.04132, 93.3125, 8.6276>, <10.5474, 94.218, 6.1066> }
			triangle { <10.5474, 94.218, 6.1066>, <8.8875, 91.4436, 3.9782>, <6.636, 88.2008, -0.4896> }
			triangle { <6.636, 88.2008, -0.4896>, <10.07746, 91.4466, 3.1525>, <11.1299, 94.2321, 5.5392> }
			triangle { <10.07746, 91.4466, 3.1525>, <12.201, 93.4012, 5.4381>, <11.1299, 94.2321, 5.5392> }
			triangle { <12.201, 93.4012, 5.4381>, <13.4128, 93.2668, 7.7312>, <11.1299, 94.2321, 5.5392> }
			triangle { <10.5474, 94.218, 6.1066>, <12.04132, 93.3125, 8.6276>, <10.5659, 93.3022, 7.1267> }
			triangle { <10.5659, 93.3022, 7.1267>, <8.8875, 91.4436, 3.9782>, <10.5474, 94.218, 6.1066> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <3.2401, 82.6588, -5.4032>, <3.9172, 99.9584, -6.5874>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.9172, 99.9584, -6.5874>, <2.6842, 104.5838, -13.181>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <2.6842, 104.5838, -13.181>, <0.7664, 109.5294, -21.2297>, <1.4757, 109.3618, -21.5909> }
			triangle { <0.7664, 109.5294, -21.2297>, <-0.5265, 107.7814, -24.656>, <1.4757, 109.3618, -21.5909> }
			triangle { <0.7664, 109.5294, -21.2297>, <-0.9301, 108.285, -23.7833>, <-0.5265, 107.7814, -24.656> }
			triangle { <-0.5265, 107.7814, -24.656>, <0.629, 108.0574, -24.2345>, <1.4757, 109.3618, -21.5909> }
			triangle { <1.4757, 109.3618, -21.5909>, <2.1451, 106.981, -18.6133>, <2.6842, 104.5838, -13.181> }
			triangle { <2.6842, 104.5838, -13.181>, <0.7843, 107.2299, -18.1843>, <0.7664, 109.5294, -21.2297> }
			triangle { <0.7843, 107.2299, -18.1843>, <-0.3833, 108.8078, -21.2989>, <0.7664, 109.5294, -21.2297> }
			triangle { <-0.3833, 108.8078, -21.2989>, <-0.9301, 108.285, -23.7833>, <0.7664, 109.5294, -21.2297> }
			triangle { <1.4757, 109.3618, -21.5909>, <0.629, 108.0574, -24.2345>, <1.6263, 108.2596, -22.3922> }
			triangle { <1.6263, 108.2596, -22.3922>, <2.1451, 106.981, -18.6133>, <1.4757, 109.3618, -21.5909> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <3.9172, 99.9584, -6.5874>, <4.4304, 117.2966, -6.07706>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.4304, 117.2966, -6.07706>, <3.934, 121.9734, 0.5765>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <3.934, 121.9734, 0.5765>, <3.6911, 126.965, 8.8193>, <2.9013, 126.8338, 8.9626> }
			triangle { <3.6911, 126.965, 8.8193>, <3.8681, 125.2203, 12.4787>, <2.9013, 126.8338, 8.9626> }
			triangle { <3.6911, 126.965, 8.8193>, <4.5272, 125.6916, 11.7566>, <3.8681, 125.2203, 12.4787> }
			triangle { <3.8681, 125.2203, 12.4787>, <2.8953, 125.5383, 11.7426>, <2.9013, 126.8338, 8.9626> }
			triangle { <2.9013, 126.8338, 8.9626>, <3.004357, 124.4349, 5.9266>, <3.934, 121.9734, 0.5765> }
			triangle { <3.934, 121.9734, 0.5765>, <4.4408, 124.6183, 5.9049>, <3.6911, 126.965, 8.8193> }
			triangle { <4.4408, 124.6183, 5.9049>, <4.7388, 126.1962, 9.2178>, <3.6911, 126.965, 8.8193> }
			triangle { <4.7388, 126.1962, 9.2178>, <4.5272, 125.6916, 11.7566>, <3.6911, 126.965, 8.8193> }
			triangle { <2.9013, 126.8338, 8.9626>, <2.8953, 125.5383, 11.7426>, <2.4775, 125.7524, 9.6911> }
			triangle { <2.4775, 125.7524, 9.6911>, <3.004357, 124.4349, 5.9266>, <2.9013, 126.8338, 8.9626> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <4.4304, 117.2966, -6.07706>, <5.1158, 134.636, -5.9561>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.1158, 134.636, -5.9561>, <7.9092, 139.5832, -11.7967>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <7.9092, 139.5832, -11.7967>, <11.01083, 144.9213, -19.1996>, <11.8005, 144.7744, -19.07169> }
			triangle { <11.01083, 144.9213, -19.1996>, <12.07445, 143.3438, -22.7838>, <11.8005, 144.7744, -19.07169> }
			triangle { <11.01083, 144.9213, -19.1996>, <11.2138, 143.8015, -22.3065>, <12.07445, 143.3438, -22.7838> }
			triangle { <12.07445, 143.3438, -22.7838>, <12.7408, 143.6019, -21.7453>, <11.8005, 144.7744, -19.07169> }
			triangle { <11.8005, 144.7744, -19.07169>, <10.6389, 142.2489, -16.3781>, <7.9092, 139.5832, -11.7967> }
			triangle { <7.9092, 139.5832, -11.7967>, <9.2836, 142.4716, -16.8377>, <11.01083, 144.9213, -19.1996> }
			triangle { <9.2836, 142.4716, -16.8377>, <10.1534, 144.2004, -19.9696>, <11.01083, 144.9213, -19.1996> }
			triangle { <10.1534, 144.2004, -19.9696>, <11.2138, 143.8015, -22.3065>, <11.01083, 144.9213, -19.1996> }
			triangle { <11.8005, 144.7744, -19.07169>, <12.7408, 143.6019, -21.7453>, <12.4351, 143.7143, -19.666> }
			triangle { <12.4351, 143.7143, -19.666>, <10.6389, 142.2489, -16.3781>, <11.8005, 144.7744, -19.07169> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <5.1158, 134.636, -5.9561>, <3.8026, 151.7833, -3.6364>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.8026, 151.7833, -3.6364>, <-0.6117, 156.0173, 1.4558>, 0.4688 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-0.6117, 156.0173, 1.4558>, <-5.8225, 160.4536, 7.9231>, <-6.5075, 160.3801, 7.5275> }
			triangle { <-5.8225, 160.4536, 7.9231>, <-8.02546, 158.5501, 10.6129>, <-6.5075, 160.3801, 7.5275> }
			triangle { <-5.8225, 160.4536, 7.9231>, <-7.06731, 158.9952, 10.5249>, <-8.02546, 158.5501, 10.6129> }
			triangle { <-8.02546, 158.5501, 10.6129>, <-8.2856, 158.974, 9.4864>, <-6.5075, 160.3801, 7.5275> }
			triangle { <-6.5075, 160.3801, 7.5275>, <-4.5928, 158.2002, 5.1032>, <-0.6117, 156.0173, 1.4558> }
			triangle { <-0.6117, 156.0173, 1.4558>, <-3.4977, 158.2677, 5.9964>, <-5.8225, 160.4536, 7.9231> }
			triangle { <-3.4977, 158.2677, 5.9964>, <-5.3066, 159.6035, 8.8028>, <-5.8225, 160.4536, 7.9231> }
			triangle { <-5.3066, 159.6035, 8.8028>, <-7.06731, 158.9952, 10.5249>, <-5.8225, 160.4536, 7.9231> }
			triangle { <-6.5075, 160.3801, 7.5275>, <-8.2856, 158.974, 9.4864>, <-7.3093, 159.3232, 7.7112> }
			triangle { <-7.3093, 159.3232, 7.7112>, <-4.5928, 158.2002, 5.1032>, <-6.5075, 160.3801, 7.5275> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <3.8026, 151.7833, -3.6364>, <2.8585, 168.9815, -1.5228>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.8585, 168.9815, -1.5228>, <3.3981, 169.5056, -1.783>, 0.04688 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <3.3981, 169.5056, -1.783>, <4.04758, 170.0818, -2.1475>, <4.1047, 170.0618, -2.0961> }
			triangle { <4.04758, 170.0818, -2.1475>, <4.3309, 169.9597, -2.3964>, <4.1047, 170.0618, -2.0961> }
			triangle { <4.04758, 170.0818, -2.1475>, <4.2346, 170.004, -2.3993>, <4.3309, 169.9597, -2.3964> }
			triangle { <4.3309, 169.9597, -2.3964>, <4.328, 169.9703, -2.2737>, <4.1047, 170.0618, -2.0961> }
			triangle { <4.1047, 170.0618, -2.0961>, <3.8664, 169.7958, -1.972>, <3.3981, 169.5056, -1.783> }
			triangle { <3.3981, 169.5056, -1.783>, <3.7814, 169.8297, -2.07996>, <4.04758, 170.0818, -2.1475> }
			triangle { <3.7814, 169.8297, -2.07996>, <4.02085, 170.0247, -2.2643>, <4.04758, 170.0818, -2.1475> }
			triangle { <4.02085, 170.0247, -2.2643>, <4.2346, 170.004, -2.3993>, <4.04758, 170.0818, -2.1475> }
			triangle { <4.1047, 170.0618, -2.0961>, <4.328, 169.9703, -2.2737>, <4.1897, 169.9615, -2.1218> }
			triangle { <4.1897, 169.9615, -2.1218>, <3.8664, 169.7958, -1.972>, <4.1047, 170.0618, -2.0961> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <2.8585, 168.9815, -1.5228>, <2.4144, 173.2595, -0.9547>, 0.1487 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.4144, 173.2595, -0.9547>, <1.8249, 173.6194, -0.7951>, 0.04176 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <1.8249, 173.6194, -0.7951>, <1.1073, 173.993, -0.5741>, <1.07701, 173.9868, -0.6377> }
			triangle { <1.1073, 173.993, -0.5741>, <0.8145, 173.8147, -0.49>, <1.07701, 173.9868, -0.6377> }
			triangle { <1.1073, 173.993, -0.5741>, <0.8884, 173.8554, -0.4476>, <0.8145, 173.8147, -0.49> }
			triangle { <0.8145, 173.8147, -0.49>, <0.851, 173.855, -0.5852>, <1.07701, 173.9868, -0.6377> }
			triangle { <1.07701, 173.9868, -0.6377>, <1.3442, 173.8007, -0.7233>, <1.8249, 173.6194, -0.7951> }
			triangle { <1.8249, 173.6194, -0.7951>, <1.3798, 173.8055, -0.6025>, <1.1073, 173.993, -0.5741> }
			triangle { <1.3798, 173.8055, -0.6025>, <1.103, 173.9155, -0.4848>, <1.1073, 173.993, -0.5741> }
			triangle { <1.103, 173.9155, -0.4848>, <0.8884, 173.8554, -0.4476>, <1.1073, 173.993, -0.5741> }
			triangle { <1.07701, 173.9868, -0.6377>, <0.851, 173.855, -0.5852>, <1.01114, 173.8916, -0.6661> }
			triangle { <1.01114, 173.8916, -0.6661>, <1.3442, 173.8007, -0.7233>, <1.07701, 173.9868, -0.6377> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.5786, 13.5147, -0.9838>, <1.01364, 25.4516, -1.8043>, 0.4105 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.01364, 25.4516, -1.8043>, <3.07834, 27.04076, -1.08522>, 0.1592 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <3.07834, 27.04076, -1.08522>, <5.6716, 28.7357, -0.2937>, <5.6373, 28.7104, -0.02731> }
			triangle { <5.6716, 28.7357, -0.2937>, <6.8424, 28.1711, 0.05641>, <5.6373, 28.7104, -0.02731> }
			triangle { <5.6716, 28.7357, -0.2937>, <6.6813, 28.3093, -0.2344>, <6.8424, 28.1711, 0.05641> }
			triangle { <6.8424, 28.1711, 0.05641>, <6.5127, 28.2944, 0.2823>, <5.6373, 28.7104, -0.02731> }
			triangle { <5.6373, 28.7104, -0.02731>, <4.6823, 27.9003, -0.3105>, <3.07834, 27.04076, -1.08522> }
			triangle { <3.07834, 27.04076, -1.08522>, <4.82, 27.9292, -0.7699>, <5.6716, 28.7357, -0.2937> }
			triangle { <4.82, 27.9292, -0.7699>, <5.901, 28.46, -0.567>, <5.6716, 28.7357, -0.2937> }
			triangle { <5.901, 28.46, -0.567>, <6.6813, 28.3093, -0.2344>, <5.6716, 28.7357, -0.2937> }
			triangle { <5.6373, 28.7104, -0.02731>, <6.5127, 28.2944, 0.2823>, <5.8227, 28.3651, 0.2036> }
			triangle { <5.8227, 28.3651, 0.2036>, <4.6823, 27.9003, -0.3105>, <5.6373, 28.7104, -0.02731> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.01364, 25.4516, -1.8043>, <-0.2035, 41.3515, -4.4461>, 0.5542 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2035, 41.3515, -4.4461>, <-3.551, 43.9899, -7.5961>, 0.3122 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-3.551, 43.9899, -7.5961>, <-7.8261, 46.752, -11.2578>, <-7.5846, 46.6321, -11.7131> }
			triangle { <-7.8261, 46.752, -11.2578>, <-9.7432, 45.4248, -12.4948>, <-7.5846, 46.6321, -11.7131> }
			triangle { <-7.8261, 46.752, -11.2578>, <-9.6422, 45.7927, -11.9008>, <-9.7432, 45.4248, -12.4948> }
			triangle { <-9.7432, 45.4248, -12.4948>, <-8.9863, 45.6384, -12.727>, <-7.5846, 46.6321, -11.7131> }
			triangle { <-7.5846, 46.6321, -11.7131>, <-6.002273, 45.2526, -10.3232>, <-3.551, 43.9899, -7.5961> }
			triangle { <-3.551, 43.9899, -7.5961>, <-6.5632, 45.4216, -9.5855>, <-7.8261, 46.752, -11.2578> }
			triangle { <-6.5632, 45.4216, -9.5855>, <-8.4278, 46.2681, -10.8271>, <-7.8261, 46.752, -11.2578> }
			triangle { <-8.4278, 46.2681, -10.8271>, <-9.6422, 45.7927, -11.9008>, <-7.8261, 46.752, -11.2578> }
			triangle { <-7.5846, 46.6321, -11.7131>, <-8.9863, 45.6384, -12.727>, <-7.7675, 45.8771, -12.1511> }
			triangle { <-7.7675, 45.8771, -12.1511>, <-6.002273, 45.2526, -10.3232>, <-7.5846, 46.6321, -11.7131> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.2035, 41.3515, -4.4461>, <-0.4109, 58.6729, -5.4774>, 0.595 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.4109, 58.6729, -5.4774>, <2.7229, 64.3369, -0.529>, 0.4799 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <2.7229, 64.3369, -0.529>, <6.945, 70.5412, 5.5207>, <6.3773, 70.4786, 6.09982> }
			triangle { <6.945, 70.5412, 5.5207>, <9.2125, 69.3722, 8.6764>, <6.3773, 70.4786, 6.09982> }
			triangle { <6.945, 70.5412, 5.5207>, <9.334, 69.6888, 7.6455>, <9.2125, 69.3722, 8.6764> }
			triangle { <9.2125, 69.3722, 8.6764>, <7.9825, 69.628, 8.571>, <6.3773, 70.4786, 6.09982> }
			triangle { <6.3773, 70.4786, 6.09982>, <4.8558, 67.6398, 3.953>, <2.7229, 64.3369, -0.529> }
			triangle { <2.7229, 64.3369, -0.529>, <6.02445, 67.7359, 3.1029>, <6.945, 70.5412, 5.5207> }
			triangle { <6.02445, 67.7359, 3.1029>, <8.06565, 69.7846, 5.3812>, <6.945, 70.5412, 5.5207> }
			triangle { <8.06565, 69.7846, 5.3812>, <9.334, 69.6888, 7.6455>, <6.945, 70.5412, 5.5207> }
			triangle { <6.3773, 70.4786, 6.09982>, <7.9825, 69.628, 8.571>, <6.4782, 69.5477, 7.1013> }
			triangle { <6.4782, 69.5477, 7.1013>, <4.8558, 67.6398, 3.953>, <6.3773, 70.4786, 6.09982> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
} // end Copy_of_Copy_of_Breeder_plant_2


/* 
#declare allPlants_planta02 = union { // all plants
	object { Copy_of_Breeder_plant_2 }
	object { Copy_of_Copy_of_Breeder_plant_2 }
	object { Copy_of_Copy_of_Breeder_plant_2 }
	}
*/ 
