// macro for objects falling from a moving point. Useful for water flling off a moving object.
                                                       
/*  
    StartPoint - The location of the emitting object at time=0
                 Object extends from StartPoint to StartPoint+Length
    Length - The length of the object
    Direction - The distance and direction that the emitting object moves in a unit of time
    StartTime - Time the emitting object starts emitting particles  // integer
    EndTime -  Time the emitting object stops emitting particles // integer
    Duration - The duration of the simulation // integer
    Frequency - Amount of particles emittied in a unit of time. 
                The particles are emitted randomly as the object moves
    g - Gravitational acceleration (9.8 m.s^-2 on earth)
    Seed - Seed for rnd num generator
*/                                                       
                                                       
#macro Falling (StartPoint,Length,Width,Angle,Displacement,StartTime,EndTime,Duration,Frequency,g,Seed,FileName)
  #local rnd=seed(Seed);
  #local ptArray = array[(EndTime-StartTime+1)*Frequency]
  #local index=0;
  #local i= StartTime+(rand(rnd)-0.5)/Frequency;
  #while (i<EndTime)
   #local rndLength = rand(rnd)*Length;
   #local Loc= StartPoint+<rndLength,rndLength*sin(Angle),(rand(rnd)-0.5)*Width>+(Displacement*i);//+(rand(rnd)*2-1)*Displacement/Frequency;
   #local fallDistance = 0.5*g*(Duration-i)^2;    // (s=ut + 1/2at^2) u=0
   #local Loc = <Loc.x,Loc.y-fallDistance-(fallDistance*0.2)*(rand(rnd)-0.5),Loc.z>;
   #local ptArray[index]=Loc;
   #local index=index+1;
   #local i=i+1/Frequency+(rand(rnd)-0.5)/Frequency;
  #end  
  #local MaxIndex = index-1;
  #fopen arr_file FileName write
  #write (arr_file,"\n#declare maxIndex=",MaxIndex,";\n")
  #write (arr_file,"\n#declare pos=array[",MaxIndex,"]\n")
  #local i=0;
  #while (i<MaxIndex)
    #write (arr_file,"#declare pos[",i,"]=",ptArray[i],";\n") 
    #local i=i+1;
  #end
  #fclose arr_file
#end

Falling(<6.75,7.1,-0.5>,3.25,0.5,-16.125,<-1,-0.3,0>,0,10,10,250,0.75,7377,"falling1.inc")

/*Falling(<-5,0.5,0>,2.5,<0.75,0.1,0>,2,10,10,40,0.2,7377,"falling1.inc")

#include "Falling1.inc"

blob {
 threshold 1
 #declare j=0;
 #while (j<maxIndex)
  sphere {
   pos[j],0.2,0.9
  }
  #declare j=j+1;
 #end
 pigment {rgb <1,0,0>}
}

camera {
 location <0,-2,-20>
 look_at <0,-2,0>
}

light_source {
 <0,5,-10>
 rgb 1
} */