// Persistence of Vision Ray Tracer Scene Description File
// File: Painting.pov
// Vers: 3.5
// Desc: Paintings comes to life
// Date: 15 Jan 2002
// Auth: Gail Shaw
// 1unit = 10 cm (aprox)

// ini = cmd:+W800 +H500
// ini final = cmd:+W1024 +H640

#version 3.5;

global_settings {
  ambient_light 0.1
  max_trace_level 30
}

#declare ShowMedia=1;
#declare ShowFish=1;

#include "kolors.inc"
#include "shapes.inc"
#include "rand.inc"
#include "woods.inc"
#include "metals.inc"
#include "glass.inc"
#include "macros35.inc"
#if (ShowFish=1)
 #include "Trout.inc"
#end

#declare SceneCamera=
 camera {
  location <27,3.6,-32> // <27,3.8,-27> // <23,3.5,-38>
  up 5/6*y
  right 4/3*x
  look_at <-10.5,-0.75,0>  // <-8.7,-0.9,0> // <-10.5,-1,0>
  angle 37
  aperture 1.5
  focal_point <0,-0.75,0>
  blur_samples 75 
  confidence 0.999
  variance 1/255
 }

#declare FishCamera=
 camera {
  location <27,3,-32>
  up 5/6*y
  right 4/3*x
  look_at <-5,-3.5,0>  
  angle 12
 }

#declare BlackMarble=
 texture {
  pigment {
   granite
   turbulence 0.6
   color_map {
    [0.000, 0.104   color rgbf <0.361, 0.333, 0.318, 0.000>
                    color rgbf <0.310, 0.282, 0.271, 0.000>]
    [0.104, 0.252   color rgbf <0.310, 0.282, 0.271, 0.000>
                    color rgbf <0.361, 0.333, 0.318, 0.000>]
    [0.252, 0.383   color rgbf <0.361, 0.333, 0.318, 0.000>
                    color rgbf <0.200, 0.200, 0.200, 0.000>]
    [0.383, 0.643   color rgbf <0.200, 0.200, 0.200, 0.000>
                    color rgbf <0.361, 0.333, 0.318, 0.000>]
    [0.643, 0.783   color rgbf <0.361, 0.333, 0.318, 0.000>
                    color rgbf <0.420, 0.349, 0.337, 0.000>]
    [0.783, 0.922   color rgbf <0.420, 0.349, 0.337, 0.000>
                    color rgbf <0.200, 0.200, 0.200, 0.000>]
    [0.922, 0.983   color rgbf <0.200, 0.200, 0.200, 0.000>
                    color rgbf <0.420, 0.349, 0.337, 0.000>]
    [0.983, 1.001   color rgbf <0.420, 0.349, 0.337, 0.000>
                    color rgbf <0.361, 0.333, 0.318, 0.000>]
   }
  }
  finish{phong 1 phong_size 90}
  scale 10
 }
 
#declare T_Frame=
 texture {T_Wood6 translate x*5}

#declare M_Water=
 material {
  texture {
   pigment {rgbf <0.95,0.95,0.975,0.98>}
   finish {
    specular 0.9
    roughness 0.002
    reflection {0.2,1.0 fresnel on}
   }
  }
  interior {ior 1.33}
 }
 
#macro PictureFrameEdge(Len,Texture1,Texture2,Texture3)
 #local Length = Len*10;
 difference {
  union {
   box {
    <1.5,-Length/2,0>,<10,Length/2,1>
    texture {Texture1 scale 5 rotate x*90}
   }
   cylinder {
    <8.5,-Length/2,0>,<8.5,Length/2,0>,1.5
    scale <1,1,0.35>
   }
   box {
    <1.85,-Length/2,0>,<4.5,Length/2,-0.25>
   }
   cylinder {
    <1.85,-Length/2,0>,<1.85,Length/2,0>,0.35
    scale <1,1,0.25/0.35>
   }
   cylinder {
    <4.5,-Length/2,0>,<4.5,Length/2,0>,0.35
    scale <1,1,0.25/0.35>
   }
   cylinder {
    <5.2,-Length/2,0>,<5.2,Length/2,0>,0.3
   }
   cylinder {
    <5.9,-Length/2,0>,<5.9,Length/2,0>,0.3
   }
   cylinder {
    <6.6,-Length/2,0>,<6.6,Length/2,0>,0.3
   }
   cylinder {
    <0.75,-Length/2,0.45>,<0.75,Length/2,0.45>,0.6
    texture {Texture3 rotate x*-90}
   }
  }
  box {
   <-10,-10,-1.5>,<10,10,1.5>
   rotate z*45
   translate <0,Length/2,0>
  }
  box {
   <-10,-10,-1.5>,<10,10,1.5>
   rotate z*-45
   translate <0,-Length/2,0>
  }
  texture {Texture2 scale 5 rotate x*-90}
  scale <0.1,0.1,0.2>
 }  
#end

#macro Picture(PicName, Description)
 union {
  union {
   object {
    PictureFrameEdge(13.75,T_Wood2,T_Frame,T_Gold_4D)
    translate x*4.5
   }
   object {
    PictureFrameEdge(13.75,T_Wood2,T_Frame,T_Gold_4D)
    scale <-1,1,1>
    translate x*-4.5
   }  
   object {
    PictureFrameEdge(11.85,T_Wood2,T_Frame,T_Gold_4D)
    rotate z*90
    translate y*5.45
   }      
   object {
    PictureFrameEdge(11.85,T_Wood2,T_Frame,T_Gold_4D)
    rotate z*-90
    translate y*-5.45
   }     
   box {
    <-2.5,-3,0>,<2.5,3,0.01>
    pigment {
     image_map {png PicName interpolate 2}
     translate <-0.5,-0.5,0>
     scale <5,6,1>
    }
    scale 1.8
    no_shadow
   }
   rotate x*-2
   translate z*-0.12
  }
  difference {
   object {Round_Box_Union(<-4,-8.25,0.1>,<4,-7.25,0.2>,0.02)}
   text {ttf "chancery.ttf" Description 0.1,0 scale <1,1,0.2>*0.75 translate <-(Text_Width("chancery.ttf", Description, 0.75, 0))/2,-7.925,0.089> pigment {Black}}
   texture {T_Brass_3B}
  }
  box {
   <-4.5,-8.25,-0.1>,<4.5,-7.25,-0.2>
   texture {
    pigment {White}
    finish {ambient 0.45/0.1}
   }
   no_image
   no_shadow
  }
  light_source {
   <0,8,-7>
   White*1.2
   spotlight
   point_at <0, 0.5, 1>
   radius 85
   falloff 90
   tightness 5
   media_interaction off
  }
  light_source {
   <0,8,-7>
   White*1.2
   spotlight
   point_at <0, -3, 1>
   radius 85
   falloff 90
   tightness 5
   media_interaction off
  }
 }
#end

#macro Pedestal()
 box {
  <-1.6,-18,-4.1>,<1.6,-8,-0.9>
  texture {BlackMarble}
 }
#end
 
#macro WaterDrops(Number,Size,StartPoint,EndPoint,Seed)
 #local rndPos=seed(Seed);
 #local rndSize=seed(Seed+1);
 #local i=0;
 union {  
  #while(i<Number)  
   #local Pos=<(rand(rndPos)*(EndPoint.x-StartPoint.x))+StartPoint.x,(rand(rndPos)*(EndPoint.y-StartPoint.y))+StartPoint.y,(rand(rndPos)*(EndPoint.z-StartPoint.z))+StartPoint.z>;
   sphere {
    Pos,Size+(Size*(rand(rndSize)-0.5))
    scale <1,1.25,1>
   }
   #local i=i+1;
  #end
 }    
#end
 
camera {SceneCamera}

light_source {
 <50,25,-50>
 White*0.15
 media_interaction off
}

light_source {
 <-50,25,-50>
 White*0.15           
 media_interaction off
}

object {Picture("Pond.png","Leap of Faith")}

object {Picture("PalmSunset.png","Solitude") translate x*-25}

object {Picture("AlienPalms.png","Planetset") translate x*-50}

object {Pedestal() translate x*-12.5}

light_source {
 <-12.5,8,-3.5>
 White*1.25
 spotlight
 point_at <-12.5,0,-2.5>
 radius 5
 falloff 10
 media_interaction off
}

light_source {
 <-37.5,8,-3.5>
 White*1.25
 spotlight
 point_at <-37.5,0,-2.5>
 radius 5
 falloff 10
 media_interaction off
}

julia_fractal {
  <-0.083,0.7,-0.83,-0.025>
  quaternion
  sqr
  max_iteration 10
  precision 35
  texture {T_Gold_3B}
  scale 1.5    
  rotate z*30     
  rotate y*-5 
  translate <-12.5,-7,-2.75>
 }

object {Pedestal() translate x*-37.5}

/*julia_fractal {
 <-0.083,0.7,-0.83,-0.025>
 quaternion               
 slice <0.2,0,0,0.5>,0.3
 cube
 max_iteration 7
 precision 40
 scale 1.5
 rotate z*90
 texture {
  crackle
  texture_map {
   [0.0 T_Silver_4D]
   [0.5 T_Brass_4D]
   [1.0 T_Copper_1C]
  }
  turbulence 0.2
  scale 0.24
 }
 scale 2*/
 
#declare F_cos=
 function { cos(atan2(x+(y^5),z)*10) }
 
isosurface {
 function { x^2+y^2+z^2 -F_cos(x,y,z)/2 -0.75}
 max_gradient 100
 contained_by { sphere {<0,0,0>,1.3}}
 texture {
  pigment {
   spherical 
   color_map {
    [0.0 rgb <0.0,0,0.75>+0.5]
    [0.5 rgb <0,0.75,0>+0.5]
   }
  }
  finish {
   ambient 0
   diffuse 0.9
   specular 0.75
   roughness 0.02
   brilliance 2
  }
 }
 rotate z*-20
 translate <-37.5,-6.6,-2.75>
}

union {
 
 torus {
  1.25,0.25
 }
 torus {
  1.25,0.25
  translate y*0.1
 }               
 texture {T_Silver_4D}
 translate <-37.5,-7.7,-2.75>
}

// pics come real

light_source {
 <10,8,15>
 rgb <0.99,0.53,0.32>
 //spotlight
 //point_at <-37.5,-7,-2.75>
 //radius 85
 //falloff 90
 projected_through {
  box {
   <-2.5,-3,0>,<2.5,3,0.01>
   scale 1.8
   rotate x*-2
   translate z*-0.12
   translate x*-25
  }
 }
}

#if (ShowMedia=1)
 box {
  <-35,-18,-10>,<-15,10,2>
  pigment {Clear}
  interior {
   media {
    scattering {1, rgb 0.025 extinction 0.05}
    intervals 1
		samples 20
  	method 3
   }
  }
  hollow
 }
#end

#if (ShowFish=1)
 #declare rnd=seed(386);
 #include "Falling1.inc"
 #declare Fish=
  object{
   Trout 
   scale 15.9
   rotate x*-2.5
   rotate z*16.5
  }
  
 light_group {
  object{
   Trout 
   scale 15.9
   rotate x*-2.5
   rotate z*16.5
   rotate y*-30
   translate <-4.225,-9.335,-0.08>
  }
  blob {
   threshold 1
   #declare j=0;
   #while (j<maxIndex)
    sphere {
     pos[j],0.125,0.95
    }
    #declare j=j+1;
   #end
   material {M_Water}
   rotate y*-30
   translate <-4.225,-9.335,-0.08>
  }
  blob {
   threshold 1      
   #declare i=0;
   #while (i<500)
    sphere {
     VRand_On_Object(Trout,rnd),0.0075,0.8
    }
    #declare i=i+1;
   #end                                 
   material {M_Water}
   //pigment {Red}
   scale 15.9
   rotate x*-2.5
   rotate z*16.5
   rotate y*-30
   translate <-4.225,-9.335,-0.08>
  }
  light_source {
   <6,0,-8>
   White*0.15
  }
  light_source {
   <4,-10,-3> //<2,-8,-2>
   White*0.3
  }
  global_lights on
 }
#end

// walls and floor

box {
 <-80,-18,0.2>,<50,20,0.5>
 texture {
  pigment {
   rgb <1,1,0.9529>
  }
  finish {
   specular 0.1 roughness 0.005
  }
  normal {
   granite 0.075
   scale <0.75,0.75,0.75>
  }
 }
 no_shadow
}

box {
 <-80,-18,0.2>,<50,-19,-10>
 //pigment {rgb <0.7255,0.7333,1>}
 texture {BlackMarble}
}

